/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.TestBase;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.TestPlatform;

public abstract class TestComparisonBase
extends TestBase {
    protected Platform getPlatform(boolean delimitedIdentifierModeOn) {
        TestPlatform platform = new TestPlatform(){

            protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
                return null;
            }
        };
        PlatformInfo platformInfo = platform.getPlatformInfo();
        platform.setDelimitedIdentifierModeOn(delimitedIdentifierModeOn);
        platformInfo.setHasSize(3, true);
        platformInfo.setHasSize(2, true);
        platformInfo.setHasSize(1, true);
        platformInfo.setHasSize(12, true);
        return platform;
    }

    protected void assertTable(String name, String description, int columnCount, int fkCount, int indexCount, Table table) {
        TestComparisonBase.assertEquals((String)name, (String)table.getName());
        TestComparisonBase.assertEquals((String)description, (String)table.getDescription());
        TestComparisonBase.assertEquals((int)columnCount, (int)table.getColumnCount());
        TestComparisonBase.assertEquals((int)fkCount, (int)table.getForeignKeyCount());
        TestComparisonBase.assertEquals((int)indexCount, (int)table.getIndexCount());
    }

    protected void assertColumn(String name, int typeCode, String sizeSpec, String defaultValue, boolean isPrimaryKey, boolean isRequired, boolean isAutoIncrement, Column column) {
        TestComparisonBase.assertEquals((String)name, (String)column.getName());
        TestComparisonBase.assertEquals((int)typeCode, (int)column.getTypeCode());
        TestComparisonBase.assertEquals((String)sizeSpec, (String)column.getSize());
        TestComparisonBase.assertEquals((String)defaultValue, (String)column.getDefaultValue());
        TestComparisonBase.assertEquals((boolean)isPrimaryKey, (boolean)column.isPrimaryKey());
        TestComparisonBase.assertEquals((boolean)isRequired, (boolean)column.isRequired());
        TestComparisonBase.assertEquals((boolean)isAutoIncrement, (boolean)column.isAutoIncrement());
    }

    protected void assertIndex(String name, boolean isUnique, String[] indexColumns, Index index) {
        TestComparisonBase.assertEquals((String)name, (String)index.getName());
        TestComparisonBase.assertEquals((boolean)isUnique, (boolean)index.isUnique());
        TestComparisonBase.assertEquals((int)indexColumns.length, (int)index.getColumnCount());
        for (int idx = 0; idx < indexColumns.length; ++idx) {
            TestComparisonBase.assertEquals((String)indexColumns[idx], (String)index.getColumn(idx).getName());
            TestComparisonBase.assertEquals((String)indexColumns[idx], (String)index.getColumn(idx).getColumn().getName());
        }
    }

    protected void assertForeignKey(String name, String targetTableName, String[] localColumnNames, String[] foreignColumnNames, ForeignKey fk) {
        TestComparisonBase.assertEquals((String)name, (String)fk.getName());
        TestComparisonBase.assertEquals((String)targetTableName, (String)fk.getForeignTable().getName());
        TestComparisonBase.assertEquals((int)localColumnNames.length, (int)fk.getReferenceCount());
        for (int idx = 0; idx < localColumnNames.length; ++idx) {
            TestComparisonBase.assertEquals((String)localColumnNames[idx], (String)fk.getReference(idx).getLocalColumnName());
            TestComparisonBase.assertEquals((String)foreignColumnNames[idx], (String)fk.getReference(idx).getForeignColumnName());
        }
    }
}

