/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.io.IOException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.TestBase;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.platform.TestPlatform;

public class TestAlterationAlgorithm
extends TestBase {
    private Platform _platform;

    protected void setUp() throws Exception {
        this._platform = new TestPlatform();
        this._platform.setSqlCommentsOn(false);
        this._platform.setDelimitedIdentifierModeOn(true);
    }

    protected void tearDown() throws Exception {
        this._platform = null;
    }

    protected String getAlterModelSQL(String currentSchema, String desiredSchema) throws IOException {
        Database currentModel = this.parseDatabaseFromString(currentSchema);
        Database desiredModel = this.parseDatabaseFromString(desiredSchema);
        return this._platform.getAlterModelSql(currentModel, desiredModel);
    }

    public void testNoChange() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' required='true'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEA'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n    <index name='TESTINDEX'>\n      <index-column name='COLFK'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' required='true'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEA'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n    <index name='TESTINDEX'>\n      <index-column name='COLFK'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' required='true'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEA'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n    <index name='TESTINDEX'>\n      <index-column name='COLFK'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testAddTable() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TABLEB\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"COLPK\")\n);\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>"));
    }

    public void testAddTableWithIndex() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TABLEB\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COL\" VARCHAR(64),\n    PRIMARY KEY (\"COLPK\")\n);\nCREATE INDEX \"TESTINDEX\" ON \"TABLEB\" (\"COL\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testAddTableWithUniqueIndex() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='VARCHAR' size='64'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL'/>\n    </unique>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TABLEB\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COL\" VARCHAR(64),\n    PRIMARY KEY (\"COLPK\")\n);\nCREATE UNIQUE INDEX \"TESTINDEX\" ON \"TABLEB\" (\"COL\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='VARCHAR' size='64'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL'/>\n    </unique>\n  </table>\n</database>"));
    }

    public void testAddTableWithForeignKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TABLEB\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COLFK\" INTEGER,\n    PRIMARY KEY (\"COLPK\")\n);\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK\") REFERENCES \"TableA\" (\"ColPK\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testAddTablesWithForeignKeys() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='ColFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"ColFK\" DOUBLE,\n    PRIMARY KEY (\"ColPK\")\n);\nCREATE TABLE \"TABLEB\"\n(\n    \"COLPK\" DOUBLE NOT NULL,\n    \"COLFK\" INTEGER,\n    PRIMARY KEY (\"COLPK\")\n);\nALTER TABLE \"TableA\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"ColFK\") REFERENCES \"TABLEB\" (\"COLPK\");\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK\") REFERENCES \"TableA\" (\"ColPK\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='ColFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testRemoveTable() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"TableA\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>"));
    }

    public void testRemoveTableWithIndex() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"TableA\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>"));
    }

    public void testRemoveTableWithForeignKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='VARCHAR' size='64'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='ColFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TableA\" DROP CONSTRAINT \"TESTFK\";\nDROP TABLE \"TableA\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='VARCHAR' size='64'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='ColFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n</database>"));
    }

    public void testRemoveTableReferencedByForeignKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='VARCHAR' size='64'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='ColFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='VARCHAR' size='64'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TableA\" DROP CONSTRAINT \"TESTFK\";\nDROP TABLE \"TABLEB\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='VARCHAR' size='64'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='ColFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='VARCHAR' size='64'/>\n  </table>\n</database>"));
    }

    public void testRemoveTablesWithForeignKeys() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='ColFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TableA\" DROP CONSTRAINT \"TESTFK\";\nALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nDROP TABLE \"TableA\";\nDROP TABLE \"TABLEB\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='ColFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n</database>"));
    }

    public void testAddIndex() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE INDEX \"TestIndex\" ON \"TableA\" (\"Col\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testAddUniqueIndex() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col'/>\n    </unique>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE UNIQUE INDEX \"TestIndex\" ON \"TableA\" (\"Col\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col'/>\n    </unique>\n  </table>\n</database>"));
    }

    public void testRemoveIndex() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP INDEX \"TestIndex\" ON \"TableA\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>"));
    }

    public void testRemoveUniqueIndex() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP INDEX \"TestIndex\" ON \"TableA\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col'/>\n    </unique>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>"));
    }

    public void testAddPrimaryKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TableA\" ADD CONSTRAINT \"TableA_PK\" PRIMARY KEY (\"ColPK1\",\"ColPK2\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n</database>"));
    }

    public void testAddPrimaryKeyAndColumn() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TableA\" ADD COLUMN \"Col\" DOUBLE;\nALTER TABLE \"TableA\" ADD CONSTRAINT \"TableA_PK\" PRIMARY KEY (\"ColPK1\",\"ColPK2\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n</database>"));
    }

    public void testRemovePrimaryKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" VARCHAR(64) NOT NULL\n);\nINSERT INTO \"TableA_\" (\"ColPK1\", \"ColPK2\") SELECT \"ColPK1\", \"ColPK2\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" VARCHAR(64) NOT NULL\n);\nINSERT INTO \"TableA\" (\"ColPK1\", \"ColPK2\") SELECT \"ColPK1\", \"ColPK2\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='VARCHAR' size='64' required='true'/>\n  </table>\n</database>"));
    }

    public void testAddColumn() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TableA\" ADD COLUMN \"Col\" VARCHAR(64);\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>"));
    }

    public void testRemoveColumn() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>"));
    }

    public void testAddPrimaryKeyColumn() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='VARCHAR' primaryKey='true' size='64'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" VARCHAR(64),\n    PRIMARY KEY (\"ColPK1\",\"ColPK2\")\n);\nINSERT INTO \"TableA_\" (\"ColPK1\") SELECT \"ColPK1\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" VARCHAR(64),\n    PRIMARY KEY (\"ColPK1\",\"ColPK2\")\n);\nINSERT INTO \"TableA\" (\"ColPK1\", \"ColPK2\") SELECT \"ColPK1\", \"ColPK2\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='VARCHAR' primaryKey='true' size='64'/>\n  </table>\n</database>"));
    }

    public void testRemovePrimaryKeyColumn() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='VARCHAR' primaryKey='true' size='64'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK1\")\n);\nINSERT INTO \"TableA_\" (\"ColPK1\") SELECT \"ColPK1\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK1\")\n);\nINSERT INTO \"TableA\" (\"ColPK1\") SELECT \"ColPK1\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='VARCHAR' primaryKey='true' size='64'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>"));
    }

    public void testAddColumnsToPrimaryAndForeignKeys() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK1' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK1' foreign='ColPK1'/>\n      <reference local='COLFK2' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" DOUBLE,\n    PRIMARY KEY (\"ColPK1\",\"ColPK2\")\n);\nINSERT INTO \"TableA_\" (\"ColPK1\") SELECT \"ColPK1\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" DOUBLE,\n    PRIMARY KEY (\"ColPK1\",\"ColPK2\")\n);\nINSERT INTO \"TableA\" (\"ColPK1\",\"ColPK2\") SELECT \"ColPK1\",\"ColPK2\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nALTER TABLE \"TABLEB\" ADD COLUMN \"COLFK2\" DOUBLE;\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK1\",\"COLFK2\") REFERENCES \"TableA\" (\"ColPK1\",\"ColPK2\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK1' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK1' foreign='ColPK1'/>\n      <reference local='COLFK2' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testRemoveColumnsFromPrimaryAndForeignKeys() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK1' foreign='ColPK1'/>\n      <reference local='COLFK2' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK1' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK1\")\n);\nINSERT INTO \"TableA_\" (\"ColPK1\") SELECT \"ColPK1\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK1\")\n);\nINSERT INTO \"TableA\" (\"ColPK1\") SELECT \"ColPK1\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nCREATE TABLE \"TABLEB_\"\n(\n    \"COLPK\" DOUBLE NOT NULL,\n    \"COLFK1\" INTEGER,\n    PRIMARY KEY (\"COLPK\")\n);\nINSERT INTO \"TABLEB_\" (\"COLPK\",\"COLFK1\") SELECT \"COLPK\",\"COLFK1\" FROM \"TABLEB\";\nDROP TABLE \"TABLEB\";\nCREATE TABLE \"TABLEB\"\n(\n    \"COLPK\" DOUBLE NOT NULL,\n    \"COLFK1\" INTEGER,\n    PRIMARY KEY (\"COLPK\")\n);\nINSERT INTO \"TABLEB\" (\"COLPK\",\"COLFK1\") SELECT \"COLPK\",\"COLFK1\" FROM \"TABLEB_\";\nDROP TABLE \"TABLEB_\";\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK1\") REFERENCES \"TableA\" (\"ColPK1\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK1' foreign='ColPK1'/>\n      <reference local='COLFK2' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK1' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testAddIndexColumn() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP INDEX \"TESTINDEX\" ON \"TableA\";\nALTER TABLE \"TableA\" ADD COLUMN \"Col2\" VARCHAR(64);\nCREATE INDEX \"TESTINDEX\" ON \"TableA\" (\"Col1\",\"Col2\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testRemoveIndexColumn() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP INDEX \"TESTINDEX\" ON \"TableA\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col1\" DOUBLE,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col1\") SELECT \"ColPK\",\"Col1\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col1\" DOUBLE,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col1\") SELECT \"ColPK\",\"Col1\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nCREATE INDEX \"TESTINDEX\" ON \"TableA\" (\"Col1\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testAddUniqueIndexColumn() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n      <unique-column name='Col2'/>\n    </unique>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP INDEX \"TESTINDEX\" ON \"TableA\";\nALTER TABLE \"TableA\" ADD COLUMN \"Col2\" VARCHAR(64);\nCREATE UNIQUE INDEX \"TESTINDEX\" ON \"TableA\" (\"Col1\",\"Col2\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n    </unique>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n      <unique-column name='Col2'/>\n    </unique>\n  </table>\n</database>"));
    }

    public void testRemoveUniqueIndexColumn() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n      <unique-column name='Col2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n    </unique>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP INDEX \"TESTINDEX\" ON \"TableA\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col1\" DOUBLE,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col1\") SELECT \"ColPK\",\"Col1\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col1\" DOUBLE,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col1\") SELECT \"ColPK\",\"Col1\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nCREATE UNIQUE INDEX \"TESTINDEX\" ON \"TableA\" (\"Col1\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n      <unique-column name='Col2'/>\n    </unique>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n    </unique>\n  </table>\n</database>"));
    }

    public void testAddColumnToTableWithIndex() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TableA\" ADD COLUMN \"Col2\" VARCHAR(64);\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testAddColumnToTableWithForeignKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <column name='COL' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" ADD COLUMN \"COL\" DOUBLE;\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <column name='COL' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testAddColumnToTableReferencedByForeignKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TableA\" ADD COLUMN \"Col\" DOUBLE;\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testInsertColumnToTableReferencedByForeignKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='Col' type='DOUBLE'/>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"Col\" DOUBLE,\n    \"ColPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"Col\" DOUBLE,\n    \"ColPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"Col\",\"ColPK\") SELECT \"Col\",\"ColPK\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK\") REFERENCES \"TableA\" (\"ColPK\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='Col' type='DOUBLE'/>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testAddExistingColumnToPrimaryKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK1\",\"ColPK2\")\n);\nINSERT INTO \"TableA_\" (\"ColPK1\",\"ColPK2\") SELECT \"ColPK1\",\"ColPK2\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK1\",\"ColPK2\")\n);\nINSERT INTO \"TableA\" (\"ColPK1\",\"ColPK2\") SELECT \"ColPK1\",\"ColPK2\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>"));
    }

    public void testRemoveColumnFromPrimaryKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK2\")\n);\nINSERT INTO \"TableA_\" (\"ColPK1\",\"ColPK2\") SELECT \"ColPK1\",\"ColPK2\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK2\")\n);\nINSERT INTO \"TableA\" (\"ColPK1\",\"ColPK2\") SELECT \"ColPK1\",\"ColPK2\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>"));
    }

    public void testAddExistingColumnsToPrimaryAndForeignKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='DOUBLE'/>\n    <column name='COLFK2' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK2' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='DOUBLE'/>\n    <column name='COLFK2' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK2' foreign='ColPK1'/>\n      <reference local='COLFK1' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK1\",\"ColPK2\")\n);\nINSERT INTO \"TableA_\" (\"ColPK1\",\"ColPK2\") SELECT \"ColPK1\",\"ColPK2\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK1\",\"ColPK2\")\n);\nINSERT INTO \"TableA\" (\"ColPK1\",\"ColPK2\") SELECT \"ColPK1\",\"ColPK2\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK2\",\"COLFK1\") REFERENCES \"TableA\" (\"ColPK1\",\"ColPK2\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='DOUBLE'/>\n    <column name='COLFK2' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK2' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='DOUBLE'/>\n    <column name='COLFK2' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK2' foreign='ColPK1'/>\n      <reference local='COLFK1' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testRemoveExistingColumnsFromPrimaryAndForeignKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='DOUBLE'/>\n    <column name='COLFK2' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK2' foreign='ColPK1'/>\n      <reference local='COLFK1' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='DOUBLE'/>\n    <column name='COLFK2' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK2' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK1\")\n);\nINSERT INTO \"TableA_\" (\"ColPK1\",\"ColPK2\") SELECT \"ColPK1\",\"ColPK2\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK1\" INTEGER NOT NULL,\n    \"ColPK2\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK1\")\n);\nINSERT INTO \"TableA\" (\"ColPK1\",\"ColPK2\") SELECT \"ColPK1\",\"ColPK2\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK2\") REFERENCES \"TableA\" (\"ColPK1\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='DOUBLE'/>\n    <column name='COLFK2' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK2' foreign='ColPK1'/>\n      <reference local='COLFK1' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='DOUBLE' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='DOUBLE'/>\n    <column name='COLFK2' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK2' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testAddExistingColumnToIndex() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n      <unique-column name='Col2'/>\n    </unique>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP INDEX \"TESTINDEX\" ON \"TableA\";\nCREATE UNIQUE INDEX \"TESTINDEX\" ON \"TableA\" (\"Col1\",\"Col2\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n    </unique>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='Col1'/>\n      <unique-column name='Col2'/>\n    </unique>\n  </table>\n</database>"));
    }

    public void testRemoveExistingColumnFromIndex() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP INDEX \"TESTINDEX\" ON \"TableA\";\nCREATE INDEX \"TESTINDEX\" ON \"TableA\" (\"Col1\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='VARCHAR' size='64'/>\n    <index name='TESTINDEX'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testRemoveColumnFromTableReferencedByForeignKey() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK\") REFERENCES \"TableA\" (\"ColPK\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testChangeColumnDatatype() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE' required='true'/>\n  </table>\n</database>"));
    }

    public void testChangePrimaryKeyColumnDatatype() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" DOUBLE NOT NULL,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" DOUBLE NOT NULL,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>"));
    }

    public void testChangeIndexColumnDatatype() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nCREATE INDEX \"TestIndex\" ON \"TableA\" (\"Col\");\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testChangePrimaryAndForeignKeyColumnsDatatype() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" DOUBLE NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nCREATE TABLE \"TABLEB_\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COLFK\" DOUBLE,\n    PRIMARY KEY (\"COLPK\")\n);\nINSERT INTO \"TABLEB_\" (\"COLPK\",\"COLFK\") SELECT \"COLPK\",\"COLFK\" FROM \"TABLEB\";\nDROP TABLE \"TABLEB\";\nCREATE TABLE \"TABLEB\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COLFK\" DOUBLE,\n    PRIMARY KEY (\"COLPK\")\n);\nINSERT INTO \"TABLEB\" (\"COLPK\",\"COLFK\") SELECT \"COLPK\",\"COLFK\" FROM \"TABLEB_\";\nDROP TABLE \"TABLEB_\";\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK\") REFERENCES \"TableA\" (\"ColPK\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testChangeColumnSize() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" VARCHAR(64) NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" VARCHAR(64) NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='64' required='true'/>\n  </table>\n</database>"));
    }

    public void testChangePrimaryKeyColumnSize() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DECIMAL' size='15,2' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DECIMAL' size='30,4' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" DECIMAL(30,4) NOT NULL,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" DECIMAL(30,4) NOT NULL,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DECIMAL' size='15,2' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DECIMAL' size='30,4' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>"));
    }

    public void testChangeIndexColumnSize() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DECIMAL' size='10,4' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DECIMAL' size='15,2' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" DECIMAL(15,2) NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" DECIMAL(15,2) NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nCREATE INDEX \"TestIndex\" ON \"TableA\" (\"Col\");\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DECIMAL' size='10,4' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DECIMAL' size='15,2' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testChangePrimaryAndForeignKeyColumnsSize() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='VARCHAR' size='64'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK\" VARCHAR(64) NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" VARCHAR(64) NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nCREATE TABLE \"TABLEB_\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COLFK\" VARCHAR(64),\n    PRIMARY KEY (\"COLPK\")\n);\nINSERT INTO \"TABLEB_\" (\"COLPK\",\"COLFK\") SELECT \"COLPK\",\"COLFK\" FROM \"TABLEB\";\nDROP TABLE \"TABLEB\";\nCREATE TABLE \"TABLEB\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COLFK\" VARCHAR(64),\n    PRIMARY KEY (\"COLPK\")\n);\nINSERT INTO \"TABLEB\" (\"COLPK\",\"COLFK\") SELECT \"COLPK\",\"COLFK\" FROM \"TABLEB_\";\nDROP TABLE \"TABLEB_\";\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK\") REFERENCES \"TableA\" (\"ColPK\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='VARCHAR' size='64' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='VARCHAR' size='64'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testChangeColumnDefault() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32' default='test 1' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32' default='test 2' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" VARCHAR(32) DEFAULT 'test 2' NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" VARCHAR(32) DEFAULT 'test 2' NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32' default='test 1' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32' default='test 2' required='true'/>\n  </table>\n</database>"));
    }

    public void testChangePrimaryKeyColumnDefault() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DECIMAL' size='15,2' default='2.0' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DECIMAL' size='15,2' default='4.0' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" DECIMAL(15,2) DEFAULT 4.0 NOT NULL,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" DECIMAL(15,2) DEFAULT 4.0 NOT NULL,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DECIMAL' size='15,2' default='2.0' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='DECIMAL' size='15,2' default='4.0' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>"));
    }

    public void testChangeIndexColumnDefault() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DATE' default='2000-01-02' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DATE' default='2001-02-03' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" DATE DEFAULT '2001-02-03' NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" DATE DEFAULT '2001-02-03' NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nCREATE INDEX \"TestIndex\" ON \"TableA\" (\"Col\");\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DATE' default='2000-01-02' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DATE' default='2001-02-03' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testChangePrimaryAndForeignKeyColumnsDefault() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' default='0' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' default='1'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' default='1' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' default='0'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER DEFAULT 1 NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER DEFAULT 1 NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nCREATE TABLE \"TABLEB_\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COLFK\" INTEGER DEFAULT 0,\n    PRIMARY KEY (\"COLPK\")\n);\nINSERT INTO \"TABLEB_\" (\"COLPK\",\"COLFK\") SELECT \"COLPK\",\"COLFK\" FROM \"TABLEB\";\nDROP TABLE \"TABLEB\";\nCREATE TABLE \"TABLEB\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COLFK\" INTEGER DEFAULT 0,\n    PRIMARY KEY (\"COLPK\")\n);\nINSERT INTO \"TABLEB\" (\"COLPK\",\"COLFK\") SELECT \"COLPK\",\"COLFK\" FROM \"TABLEB_\";\nDROP TABLE \"TABLEB_\";\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK\") REFERENCES \"TableA\" (\"ColPK\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' default='0' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' default='1'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' default='1' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' default='0'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testChangeColumnAutoIncrement() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='false' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='true' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='false' required='true'/>\n  </table>\n</database>"));
    }

    public void testChangePrimaryKeyColumnAutoIncrement() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' autoIncrement='false' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' autoIncrement='true' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL IDENTITY,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL IDENTITY,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' autoIncrement='false' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' autoIncrement='true' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>"));
    }

    public void testChangeIndexColumnAutoIncrement() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='false' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='true' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" INTEGER NOT NULL IDENTITY,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" INTEGER NOT NULL IDENTITY,\n    PRIMARY KEY (\"ColPK\")\n);\nCREATE INDEX \"TestIndex\" ON \"TableA\" (\"Col\");\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='false' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='true' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testChangePrimaryAndForeignKeyColumnsAutoIncrement() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' autoIncrement='true' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' autoIncrement='false' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK\") REFERENCES \"TableA\" (\"ColPK\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' autoIncrement='true' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' autoIncrement='false' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testChangeColumnRequired() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='false'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" INTEGER,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" INTEGER,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='false'/>\n  </table>\n</database>"));
    }

    public void testChangePrimaryKeyColumnRequired() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='false'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='false'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>"));
    }

    public void testChangeIndexColumnRequired() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='false'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("CREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    \"Col\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nCREATE INDEX \"TestIndex\" ON \"TableA\" (\"Col\");\nINSERT INTO \"TableA\" (\"ColPK\",\"Col\") SELECT \"ColPK\",\"Col\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='false'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>"));
    }

    public void testChangePrimaryAndForeignKeyColumnsRequired() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='false'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' required='true'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' required='false'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"TABLEB\" DROP CONSTRAINT \"TESTFK\";\nCREATE TABLE \"TableA_\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA_\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA\";\nDROP TABLE \"TableA\";\nCREATE TABLE \"TableA\"\n(\n    \"ColPK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"ColPK\")\n);\nINSERT INTO \"TableA\" (\"ColPK\") SELECT \"ColPK\" FROM \"TableA_\";\nDROP TABLE \"TableA_\";\nCREATE TABLE \"TABLEB_\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COLFK\" INTEGER,\n    PRIMARY KEY (\"COLPK\")\n);\nINSERT INTO \"TABLEB_\" (\"COLPK\",\"COLFK\") SELECT \"COLPK\",\"COLFK\" FROM \"TABLEB\";\nDROP TABLE \"TABLEB\";\nCREATE TABLE \"TABLEB\"\n(\n    \"COLPK\" INTEGER NOT NULL,\n    \"COLFK\" INTEGER,\n    PRIMARY KEY (\"COLPK\")\n);\nINSERT INTO \"TABLEB\" (\"COLPK\",\"COLFK\") SELECT \"COLPK\",\"COLFK\" FROM \"TABLEB_\";\nDROP TABLE \"TABLEB_\";\nALTER TABLE \"TABLEB\" ADD CONSTRAINT \"TESTFK\" FOREIGN KEY (\"COLFK\") REFERENCES \"TableA\" (\"ColPK\");\n", this.getAlterModelSQL("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='false'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' required='true'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER' required='false'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>"));
    }
}

