/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.PlatformUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.InputSource;

public class TestSummaryCreatorTask
extends Task {
    private String _version;
    private File _outputFile;
    private ArrayList _fileSets = new ArrayList();

    public void setVersion(String version) {
        this._version = version;
    }

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    public void addConfiguredFileset(FileSet fileset) {
        this._fileSets.add(fileset);
    }

    private List getInputFiles() {
        ArrayList<File> result = new ArrayList<File>();
        for (FileSet fileSet : this._fileSets) {
            File fileSetDir = fileSet.getDir(this.getProject());
            DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
            String[] files = scanner.getIncludedFiles();
            for (int idx = 0; files != null && idx < files.length; ++idx) {
                File file = new File(fileSetDir, files[idx]);
                if (!file.isFile() || !file.canRead()) continue;
                result.add(file);
            }
        }
        return result;
    }

    private Document processInputFiles() throws IOException {
        Document summaryDoc = DocumentHelper.createDocument();
        summaryDoc.addElement("summary");
        Iterator it = this.getInputFiles().iterator();
        while (it.hasNext()) {
            this.processInputFile(summaryDoc, (File)it.next());
        }
        return summaryDoc;
    }

    private String getAttrValue(Document doc, String xpath, String attrName) {
        Node node = doc.selectSingleNode(xpath);
        if (node instanceof Attribute) {
            return ((Attribute)node).getValue();
        }
        if (node != null) {
            return node.valueOf("@" + attrName);
        }
        return null;
    }

    private void processInputFile(Document summaryDoc, File inputFile) throws IOException {
        try {
            SAXReader reader = new SAXReader();
            Document testDoc = reader.read(new InputSource(new FileReader(inputFile)));
            if (testDoc.selectSingleNode("/testsuite") == null) {
                return;
            }
            Element generalElement = (Element)summaryDoc.selectSingleNode("//general");
            int totalNumTests = 0;
            int totalNumErrors = 0;
            int totalNumFailures = 0;
            if (generalElement == null) {
                generalElement = summaryDoc.getRootElement().addElement("general");
                generalElement.addAttribute("ddlUtilsVersion", this._version);
                generalElement.addAttribute("date", this.getAttrValue(testDoc, "//property[@name='TODAY']", "value"));
                generalElement.addAttribute("lang", this.getAttrValue(testDoc, "//property[@name='env.LANG']", "value"));
                generalElement.addAttribute("jre", this.getAttrValue(testDoc, "//property[@name='java.runtime.name']", "value") + " " + this.getAttrValue(testDoc, "//property[@name='java.runtime.version']", "value") + " (" + this.getAttrValue(testDoc, "//property[@name='java.vendor']", "value") + ")");
                generalElement.addAttribute("os", this.getAttrValue(testDoc, "//property[@name='os.name']", "value") + " " + this.getAttrValue(testDoc, "//property[@name='os.version']", "value") + ", arch " + this.getAttrValue(testDoc, "//property[@name='os.arch']", "value"));
                this.addTargetDatabaseInfo(generalElement, this.getAttrValue(testDoc, "//property[@name='jdbc.properties.file']", "value"));
            } else {
                totalNumTests = Integer.parseInt(generalElement.attributeValue("tests"));
                totalNumErrors = Integer.parseInt(generalElement.attributeValue("errors"));
                totalNumFailures = Integer.parseInt(generalElement.attributeValue("failures"));
            }
            int numTests = Integer.parseInt(this.getAttrValue(testDoc, "/testsuite", "tests"));
            int numErrors = Integer.parseInt(this.getAttrValue(testDoc, "/testsuite", "errors"));
            int numFailures = Integer.parseInt(this.getAttrValue(testDoc, "/testsuite", "failures"));
            generalElement.addAttribute("tests", String.valueOf(totalNumTests += numTests));
            generalElement.addAttribute("errors", String.valueOf(totalNumErrors += numErrors));
            generalElement.addAttribute("failures", String.valueOf(totalNumFailures += numFailures));
            if (numErrors > 0 || numFailures > 0) {
                Element testSuiteNode = (Element)testDoc.selectSingleNode("/testsuite");
                String testSuiteName = testSuiteNode.attributeValue("name");
                for (Element failedTestElement : testSuiteNode.selectNodes("testcase[failure or error]")) {
                    Element newTestElement = summaryDoc.getRootElement().addElement("failedTest");
                    if (!failedTestElement.attributeValue("classname").startsWith("junit.framework.TestSuite")) {
                        newTestElement.addAttribute("name", failedTestElement.attributeValue("classname") + "#" + failedTestElement.attributeValue("name"));
                    }
                    newTestElement.addAttribute("testsuite", testSuiteName);
                }
            }
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    protected void addTargetDatabaseInfo(Element element, String jdbcPropertiesFile) throws IOException, BuildException {
        if (jdbcPropertiesFile == null) {
            return;
        }
        Properties props = this.readProperties(jdbcPropertiesFile);
        Connection conn = null;
        DatabaseMetaData metaData = null;
        try {
            String dataSourceClass = props.getProperty("datasource.class", BasicDataSource.class.getName());
            DataSource dataSource = (DataSource)Class.forName(dataSourceClass).newInstance();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String propName = (String)entry.getKey();
                if (!propName.startsWith("datasource.") || propName.equals("datasource.class")) continue;
                BeanUtils.setProperty((Object)dataSource, (String)propName.substring("datasource.".length()), (Object)entry.getValue());
            }
            String platformName = props.getProperty("ddlutils.platform");
            if (platformName == null && (platformName = new PlatformUtils().determineDatabaseType(dataSource)) == null) {
                throw new BuildException("Could not determine platform from datasource, please specify it in the jdbc.properties via the ddlutils.platform property");
            }
            element.addAttribute("platform", platformName);
            element.addAttribute("dataSourceClass", dataSourceClass);
            conn = dataSource.getConnection();
            metaData = conn.getMetaData();
            try {
                element.addAttribute("dbProductName", metaData.getDatabaseProductName());
            }
            catch (Throwable entry) {
                // empty catch block
            }
            try {
                element.addAttribute("dbProductVersion", metaData.getDatabaseProductVersion());
            }
            catch (Throwable entry) {
                // empty catch block
            }
            try {
                int databaseMajorVersion = metaData.getDatabaseMajorVersion();
                int databaseMinorVersion = metaData.getDatabaseMinorVersion();
                element.addAttribute("dbVersion", databaseMajorVersion + "." + databaseMinorVersion);
            }
            catch (Throwable databaseMajorVersion) {
                // empty catch block
            }
            try {
                element.addAttribute("driverName", metaData.getDriverName());
            }
            catch (Throwable databaseMajorVersion) {
                // empty catch block
            }
            try {
                element.addAttribute("driverVersion", metaData.getDriverVersion());
            }
            catch (Throwable databaseMajorVersion) {
                // empty catch block
            }
            try {
                int jdbcMajorVersion = metaData.getJDBCMajorVersion();
                int jdbcMinorVersion = metaData.getJDBCMinorVersion();
                element.addAttribute("jdbcVersion", jdbcMajorVersion + "." + jdbcMinorVersion);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private Properties readProperties(String jdbcPropertiesFile) {
        Properties props = new Properties();
        InputStream propStream = null;
        try {
            propStream = TestSummaryCreatorTask.class.getResourceAsStream(jdbcPropertiesFile);
            if (propStream == null) {
                File baseDir = this.getProject().getBaseDir();
                File propFile = new File(baseDir, jdbcPropertiesFile);
                if (propFile.exists() && propFile.isFile() && propFile.canRead()) {
                    propStream = new FileInputStream(propFile);
                } else {
                    throw new BuildException("Cannot load test jdbc properties from file " + jdbcPropertiesFile);
                }
            }
            props.load(propStream);
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BuildException("Cannot load test jdbc properties from file " + jdbcPropertiesFile, (Throwable)ex);
        }
        finally {
            if (propStream != null) {
                try {
                    propStream.close();
                }
                catch (IOException ex) {
                    this.log("Could not close the stream used to read the test jdbc properties", 1);
                }
            }
        }
        return props;
    }

    public void execute() throws BuildException {
        try {
            this.log("Processing test results", 2);
            Document doc = this.processInputFiles();
            XMLWriter writer = null;
            writer = this._outputFile != null ? new XMLWriter((Writer)new FileWriter(this._outputFile), OutputFormat.createPrettyPrint()) : new XMLWriter((OutputStream)System.out, OutputFormat.createPrettyPrint());
            writer.write(doc);
            writer.close();
            this.log("Processing finished", 2);
        }
        catch (Exception ex) {
            throw new BuildException("Error while processing the test results: " + ex.getLocalizedMessage(), (Throwable)ex);
        }
    }
}

