/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.TestBase;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.platform.SqlBuilder;

public abstract class TestPlatformBase
extends TestBase {
    private Platform _platform;
    private StringWriter _writer;

    protected void setUp() throws Exception {
        this._writer = new StringWriter();
        this._platform = PlatformFactory.createNewPlatformInstance((String)this.getDatabaseName());
        this._platform.getSqlBuilder().setWriter((Writer)this._writer);
        if (this._platform.getPlatformInfo().isDelimitedIdentifiersSupported()) {
            this._platform.setDelimitedIdentifierModeOn(true);
        }
    }

    protected void tearDown() throws Exception {
        this._platform = null;
        this._writer = null;
    }

    protected Platform getPlatform() {
        return this._platform;
    }

    protected PlatformInfo getPlatformInfo() {
        return this.getPlatform().getPlatformInfo();
    }

    protected SqlBuilder getSqlBuilder() {
        return this.getPlatform().getSqlBuilder();
    }

    protected String getBuilderOutput() {
        return this._writer.toString();
    }

    protected abstract String getDatabaseName();

    protected String getDatabaseCreationSql(String schema) throws IOException {
        Database testDb = this.parseDatabaseFromString(schema);
        this.getPlatform().setSqlCommentsOn(false);
        this.getPlatform().getSqlBuilder().createTables(testDb);
        return this.getBuilderOutput();
    }

    protected String getColumnTestDatabaseCreationSql() throws IOException {
        String schema = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='datatypetest'>\n  <table name='coltype'>\n    <column name='COL_ARRAY'           type='ARRAY'/>\n    <column name='COL_BIGINT'          type='BIGINT'/>\n    <column name='COL_BINARY'          type='BINARY'/>\n    <column name='COL_BIT'             type='BIT'/>\n    <column name='COL_BLOB'            type='BLOB'/>\n    <column name='COL_BOOLEAN'         type='BOOLEAN'/>\n    <column name='COL_CHAR'            type='CHAR' size='15'/>\n    <column name='COL_CLOB'            type='CLOB'/>\n    <column name='COL_DATALINK'        type='DATALINK'/>\n    <column name='COL_DATE'            type='DATE'/>\n    <column name='COL_DECIMAL'         type='DECIMAL' size='15,3'/>\n    <column name='COL_DECIMAL_NOSCALE' type='DECIMAL' size='15'/>\n    <column name='COL_DISTINCT'        type='DISTINCT'/>\n    <column name='COL_DOUBLE'          type='DOUBLE'/>\n    <column name='COL_FLOAT'           type='FLOAT'/>\n    <column name='COL_INTEGER'         type='INTEGER'/>\n    <column name='COL_JAVA_OBJECT'     type='JAVA_OBJECT'/>\n    <column name='COL_LONGVARBINARY'   type='LONGVARBINARY'/>\n    <column name='COL_LONGVARCHAR'     type='LONGVARCHAR'/>\n    <column name='COL_NULL'            type='NULL'/>\n    <column name='COL_NUMERIC'         type='NUMERIC' size='15' />\n    <column name='COL_OTHER'           type='OTHER'/>\n    <column name='COL_REAL'            type='REAL'/>\n    <column name='COL_REF'             type='REF'/>\n    <column name='COL_SMALLINT'        type='SMALLINT' size='5'/>\n    <column name='COL_STRUCT'          type='STRUCT'/>\n    <column name='COL_TIME'            type='TIME'/>\n    <column name='COL_TIMESTAMP'       type='TIMESTAMP'/>\n    <column name='COL_TINYINT'         type='TINYINT'/>\n    <column name='COL_VARBINARY'       type='VARBINARY' size='15'/>\n    <column name='COL_VARCHAR'         type='VARCHAR' size='15'/>\n  </table>\n</database>";
        return this.getDatabaseCreationSql("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='datatypetest'>\n  <table name='coltype'>\n    <column name='COL_ARRAY'           type='ARRAY'/>\n    <column name='COL_BIGINT'          type='BIGINT'/>\n    <column name='COL_BINARY'          type='BINARY'/>\n    <column name='COL_BIT'             type='BIT'/>\n    <column name='COL_BLOB'            type='BLOB'/>\n    <column name='COL_BOOLEAN'         type='BOOLEAN'/>\n    <column name='COL_CHAR'            type='CHAR' size='15'/>\n    <column name='COL_CLOB'            type='CLOB'/>\n    <column name='COL_DATALINK'        type='DATALINK'/>\n    <column name='COL_DATE'            type='DATE'/>\n    <column name='COL_DECIMAL'         type='DECIMAL' size='15,3'/>\n    <column name='COL_DECIMAL_NOSCALE' type='DECIMAL' size='15'/>\n    <column name='COL_DISTINCT'        type='DISTINCT'/>\n    <column name='COL_DOUBLE'          type='DOUBLE'/>\n    <column name='COL_FLOAT'           type='FLOAT'/>\n    <column name='COL_INTEGER'         type='INTEGER'/>\n    <column name='COL_JAVA_OBJECT'     type='JAVA_OBJECT'/>\n    <column name='COL_LONGVARBINARY'   type='LONGVARBINARY'/>\n    <column name='COL_LONGVARCHAR'     type='LONGVARCHAR'/>\n    <column name='COL_NULL'            type='NULL'/>\n    <column name='COL_NUMERIC'         type='NUMERIC' size='15' />\n    <column name='COL_OTHER'           type='OTHER'/>\n    <column name='COL_REAL'            type='REAL'/>\n    <column name='COL_REF'             type='REF'/>\n    <column name='COL_SMALLINT'        type='SMALLINT' size='5'/>\n    <column name='COL_STRUCT'          type='STRUCT'/>\n    <column name='COL_TIME'            type='TIME'/>\n    <column name='COL_TIMESTAMP'       type='TIMESTAMP'/>\n    <column name='COL_TINYINT'         type='TINYINT'/>\n    <column name='COL_VARBINARY'       type='VARBINARY' size='15'/>\n    <column name='COL_VARCHAR'         type='VARCHAR' size='15'/>\n  </table>\n</database>");
    }

    protected String getConstraintTestDatabaseCreationSql() throws IOException {
        String schema = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='columnconstraintstest'>\n  <table name='constraints'>\n    <column name='COL_PK' type='VARCHAR' size='32' primaryKey='true'/>\n    <column name='COL_PK_AUTO_INCR' type='INTEGER' primaryKey='true' autoIncrement='true'/>\n    <column name='COL_NOT_NULL' type='BINARY' size='100' required='true'/>\n    <column name='COL_NOT_NULL_DEFAULT' type='DOUBLE' required='true' default='-2.0'/>\n    <column name='COL_DEFAULT' type='CHAR' size='4' default='test'/>\n    <column name='COL_AUTO_INCR' type='BIGINT' autoIncrement='true'/>\n  </table>\n</database>";
        return this.getDatabaseCreationSql("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='columnconstraintstest'>\n  <table name='constraints'>\n    <column name='COL_PK' type='VARCHAR' size='32' primaryKey='true'/>\n    <column name='COL_PK_AUTO_INCR' type='INTEGER' primaryKey='true' autoIncrement='true'/>\n    <column name='COL_NOT_NULL' type='BINARY' size='100' required='true'/>\n    <column name='COL_NOT_NULL_DEFAULT' type='DOUBLE' required='true' default='-2.0'/>\n    <column name='COL_DEFAULT' type='CHAR' size='4' default='test'/>\n    <column name='COL_AUTO_INCR' type='BIGINT' autoIncrement='true'/>\n  </table>\n</database>");
    }

    protected String getTableConstraintTestDatabaseCreationSql() throws IOException {
        String schema = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='tableconstraintstest'>\n  <table name='table1'>\n    <column name='COL_PK_1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='COL_PK_2' type='INTEGER' primaryKey='true'/>\n    <column name='COL_INDEX_1' type='BINARY' size='100' required='true'/>\n    <column name='COL_INDEX_2' type='DOUBLE' required='true'/>\n    <column name='COL_INDEX_3' type='CHAR' size='4'/>\n    <index name='testindex1'>\n      <index-column name='COL_INDEX_2'/>\n    </index>\n    <unique name='testindex2'>\n      <unique-column name='COL_INDEX_3'/>\n      <unique-column name='COL_INDEX_1'/>\n    </unique>\n  </table>\n  <table name='table2'>\n    <column name='COL_PK' type='INTEGER' primaryKey='true'/>\n    <column name='COL_FK_1' type='INTEGER'/>\n    <column name='COL_FK_2' type='VARCHAR' size='32' required='true'/>\n    <foreign-key foreignTable='table1'>\n      <reference local='COL_FK_1' foreign='COL_PK_2'/>\n      <reference local='COL_FK_2' foreign='COL_PK_1'/>\n    </foreign-key>\n  </table>\n  <table name='table3'>\n    <column name='COL_PK' type='VARCHAR' size='16' primaryKey='true'/>\n    <column name='COL_FK' type='INTEGER' required='true'/>\n    <foreign-key name='testfk' foreignTable='table2'>\n      <reference local='COL_FK' foreign='COL_PK'/>\n    </foreign-key>\n  </table>\n</database>";
        return this.getDatabaseCreationSql("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='tableconstraintstest'>\n  <table name='table1'>\n    <column name='COL_PK_1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='COL_PK_2' type='INTEGER' primaryKey='true'/>\n    <column name='COL_INDEX_1' type='BINARY' size='100' required='true'/>\n    <column name='COL_INDEX_2' type='DOUBLE' required='true'/>\n    <column name='COL_INDEX_3' type='CHAR' size='4'/>\n    <index name='testindex1'>\n      <index-column name='COL_INDEX_2'/>\n    </index>\n    <unique name='testindex2'>\n      <unique-column name='COL_INDEX_3'/>\n      <unique-column name='COL_INDEX_1'/>\n    </unique>\n  </table>\n  <table name='table2'>\n    <column name='COL_PK' type='INTEGER' primaryKey='true'/>\n    <column name='COL_FK_1' type='INTEGER'/>\n    <column name='COL_FK_2' type='VARCHAR' size='32' required='true'/>\n    <foreign-key foreignTable='table1'>\n      <reference local='COL_FK_1' foreign='COL_PK_2'/>\n      <reference local='COL_FK_2' foreign='COL_PK_1'/>\n    </foreign-key>\n  </table>\n  <table name='table3'>\n    <column name='COL_PK' type='VARCHAR' size='16' primaryKey='true'/>\n    <column name='COL_FK' type='INTEGER' required='true'/>\n    <foreign-key name='testfk' foreignTable='table2'>\n      <reference local='COL_FK' foreign='COL_PK'/>\n    </foreign-key>\n  </table>\n</database>");
    }

    protected String getCharEscapingTestDatabaseCreationSql() throws IOException {
        String schema = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='escapetest'>\n  <table name='escapedcharacters'>\n    <column name='COL_PK' type='INTEGER' primaryKey='true'/>\n    <column name='COL_TEXT' type='VARCHAR' size='128' default='&#39;'/>\n  </table>\n</database>";
        return this.getDatabaseCreationSql("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='escapetest'>\n  <table name='escapedcharacters'>\n    <column name='COL_PK' type='INTEGER' primaryKey='true'/>\n    <column name='COL_TEXT' type='VARCHAR' size='128' default='&#39;'/>\n  </table>\n</database>");
    }
}

