/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;

public abstract class TestBase
extends TestCase {
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected Log getLog() {
        return this._log;
    }

    protected Database parseDatabaseFromString(String dbDef) {
        DatabaseIO dbIO = new DatabaseIO();
        dbIO.setUseInternalDtd(true);
        dbIO.setValidateXml(true);
        return dbIO.read((Reader)new StringReader(dbDef));
    }

    protected void assertEqualsIgnoringWhitespaces(String expected, String actual) {
        String processedExpected = this.compressWhitespaces(expected);
        String processedActual = this.compressWhitespaces(actual);
        TestBase.assertEquals((String)processedExpected, (String)processedActual);
    }

    private String compressWhitespaces(String original) {
        StringBuilder result = new StringBuilder();
        char oldChar = ' ';
        for (int idx = 0; idx < original.length(); ++idx) {
            char curChar = original.charAt(idx);
            if (Character.isWhitespace(curChar)) {
                if (oldChar == 32) continue;
                oldChar = ' ';
                result.append(oldChar);
                continue;
            }
            if ((curChar == ',' || curChar == ';' || curChar == '(' || curChar == ')') && oldChar == ' ' && result.length() > 0) {
                result.setLength(result.length() - 1);
            }
            if (oldChar == ',' || oldChar == ';') {
                result.append(' ');
            }
            result.append(curChar);
            oldChar = curChar;
        }
        return result.toString();
    }
}

