/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.DatabaseOperationException;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.PlatformUtils;
import org.apache.ddlutils.TestPlatformBase;
import org.apache.ddlutils.dynabean.SqlDynaBean;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.dynabean.SqlDynaProperty;
import org.apache.ddlutils.io.BinaryObjectsHelper;
import org.apache.ddlutils.io.DataReader;
import org.apache.ddlutils.io.DataSink;
import org.apache.ddlutils.io.DataToDatabaseSink;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.CloneHelper;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultValueHelper;
import org.apache.ddlutils.util.StringUtilsExt;

public abstract class TestAgainstLiveDatabaseBase
extends TestPlatformBase {
    public static final String JDBC_PROPERTIES_PROPERTY = "jdbc.properties.file";
    public static final String DATASOURCE_PROPERTY_PREFIX = "datasource.";
    public static final String DDLUTILS_PROPERTY_PREFIX = "ddlutils.";
    public static final String DDLUTILS_PLATFORM_PROPERTY = "ddlutils.platform";
    public static final String DDLUTILS_CATALOG_PROPERTY = "ddlutils.catalog";
    public static final String DDLUTILS_SCHEMA_PROPERTY = "ddlutils.schema";
    public static final String DDLUTILS_TABLE_CREATION_PREFIX = "ddlutils.tableCreation.";
    private Properties _testProps;
    private DataSource _dataSource;
    private String _databaseName;
    private Database _model;
    private boolean _useDelimitedIdentifiers;

    protected static TestSuite getTests(Class testedClass) {
        if (!TestAgainstLiveDatabaseBase.class.isAssignableFrom(testedClass) || Modifier.isAbstract(testedClass.getModifiers())) {
            throw new DdlUtilsException("Cannot create parameterized tests for class " + testedClass.getName());
        }
        TestSuite suite = new TestSuite();
        Properties props = TestAgainstLiveDatabaseBase.readTestProperties();
        if (props == null) {
            return suite;
        }
        DataSource dataSource = TestAgainstLiveDatabaseBase.initDataSourceFromProperties(props);
        String databaseName = TestAgainstLiveDatabaseBase.determineDatabaseName(props, dataSource);
        try {
            Method[] methods = testedClass.getMethods();
            PlatformInfo info = null;
            for (int idx = 0; methods != null && idx < methods.length; ++idx) {
                if (!methods[idx].getName().startsWith("test") || methods[idx].getParameterTypes() != null && methods[idx].getParameterTypes().length != 0) continue;
                TestAgainstLiveDatabaseBase newTest = (TestAgainstLiveDatabaseBase)((Object)testedClass.newInstance());
                newTest.setName(methods[idx].getName());
                newTest.setTestProperties(props);
                newTest.setDataSource(dataSource);
                newTest.setDatabaseName(databaseName);
                newTest.setUseDelimitedIdentifiers(false);
                suite.addTest((Test)newTest);
                if (info == null) {
                    info = PlatformFactory.createNewPlatformInstance((String)newTest.getDatabaseName()).getPlatformInfo();
                }
                if (!info.isDelimitedIdentifiersSupported()) continue;
                newTest = (TestAgainstLiveDatabaseBase)((Object)testedClass.newInstance());
                newTest.setName(methods[idx].getName());
                newTest.setTestProperties(props);
                newTest.setDataSource(dataSource);
                newTest.setDatabaseName(databaseName);
                newTest.setUseDelimitedIdentifiers(true);
                suite.addTest((Test)newTest);
            }
        }
        catch (Exception ex) {
            throw new DdlUtilsException((Throwable)ex);
        }
        return suite;
    }

    protected static Properties readTestProperties() {
        String propFile = System.getProperty(JDBC_PROPERTIES_PROPERTY);
        if (propFile == null) {
            return null;
        }
        InputStream propStream = null;
        try {
            propStream = TestAgainstLiveDatabaseBase.class.getResourceAsStream(propFile);
            if (propStream == null) {
                propStream = new FileInputStream(propFile);
            }
            Properties props = new Properties();
            props.load(propStream);
            Properties properties = props;
            return properties;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (propStream != null) {
                try {
                    propStream.close();
                }
                catch (IOException ex) {
                    LogFactory.getLog(TestAgainstLiveDatabaseBase.class).error((Object)"Could not close the stream used to read the test jdbc properties", (Throwable)ex);
                }
            }
        }
    }

    private static DataSource initDataSourceFromProperties(Properties props) {
        if (props == null) {
            return null;
        }
        try {
            String dataSourceClass = props.getProperty("datasource.class", BasicDataSource.class.getName());
            DataSource dataSource = (DataSource)Class.forName(dataSourceClass).newInstance();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String propName = (String)entry.getKey();
                if (!propName.startsWith(DATASOURCE_PROPERTY_PREFIX) || propName.equals("datasource.class")) continue;
                BeanUtils.setProperty((Object)dataSource, (String)propName.substring(DATASOURCE_PROPERTY_PREFIX.length()), (Object)entry.getValue());
            }
            return dataSource;
        }
        catch (Exception ex) {
            throw new DatabaseOperationException((Throwable)ex);
        }
    }

    private static String determineDatabaseName(Properties props, DataSource dataSource) {
        String platformName = props.getProperty(DDLUTILS_PLATFORM_PROPERTY);
        if (platformName == null && (platformName = new PlatformUtils().determineDatabaseType(dataSource)) == null) {
            throw new DatabaseOperationException("Could not determine platform from datasource, please specify it in the jdbc.properties via the ddlutils.platform property");
        }
        return platformName;
    }

    protected Properties getTestProperties() {
        return this._testProps;
    }

    private void setTestProperties(Properties props) {
        this._testProps = props;
    }

    protected CreationParameters getTableCreationParameters(Database model) {
        CreationParameters params = new CreationParameters();
        for (Map.Entry<Object, Object> entry : this._testProps.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!name.startsWith(DDLUTILS_TABLE_CREATION_PREFIX)) continue;
            name = name.substring(DDLUTILS_TABLE_CREATION_PREFIX.length());
            for (int tableIdx = 0; tableIdx < model.getTableCount(); ++tableIdx) {
                params.addParameter(model.getTable(tableIdx), name, value);
            }
        }
        return params;
    }

    protected void setUseDelimitedIdentifiers(boolean useDelimitedIdentifiers) {
        this._useDelimitedIdentifiers = useDelimitedIdentifiers;
    }

    protected boolean isUseDelimitedIdentifiers() {
        return this._useDelimitedIdentifiers;
    }

    protected DataSource getDataSource() {
        return this._dataSource;
    }

    private void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    @Override
    protected String getDatabaseName() {
        return this._databaseName;
    }

    private void setDatabaseName(String databaseName) {
        this._databaseName = databaseName;
    }

    protected Database getModel() {
        return this._model;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getPlatform().setDataSource(this.getDataSource());
        this.getPlatform().setDelimitedIdentifierModeOn(this._useDelimitedIdentifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            if (this._model != null) {
                this.dropDatabase();
                this._model = null;
            }
        }
        finally {
            this.assertAndEnsureClearDatabase();
            super.tearDown();
        }
    }

    protected Database createDatabase(String schemaXml) throws DatabaseOperationException {
        Database model = this.parseDatabaseFromString(schemaXml);
        this.createDatabase(model);
        return model;
    }

    protected void createDatabase(Database model) throws DatabaseOperationException {
        try {
            this._model = model;
            this.getPlatform().setSqlCommentsOn(false);
            this.getPlatform().createModel(this._model, this.getTableCreationParameters(this._model), false, false);
        }
        catch (Exception ex) {
            throw new DatabaseOperationException((Throwable)ex);
        }
    }

    protected Database alterDatabase(String schemaXml) throws DatabaseOperationException {
        Database model = this.parseDatabaseFromString(schemaXml);
        this.alterDatabase(model);
        return model;
    }

    protected void alterDatabase(Database desiredModel) throws DatabaseOperationException {
        try {
            this._model = desiredModel;
            this._model.resetDynaClassCache();
            Database liveModel = this.readModelFromDatabase(desiredModel.getName());
            this.getPlatform().setSqlCommentsOn(false);
            this.getPlatform().alterModel(liveModel, this._model, this.getTableCreationParameters(this._model), false);
        }
        catch (Exception ex) {
            throw new DatabaseOperationException((Throwable)ex);
        }
    }

    protected Database insertData(String dataXml) throws DatabaseOperationException {
        try {
            DataReader dataReader = new DataReader();
            dataReader.setModel(this._model);
            dataReader.setSink((DataSink)new DataToDatabaseSink(this.getPlatform(), this._model));
            dataReader.getSink().start();
            dataReader.read((Reader)new StringReader(dataXml));
            dataReader.getSink().end();
            return this._model;
        }
        catch (Exception ex) {
            throw new DatabaseOperationException((Throwable)ex);
        }
    }

    protected void dropDatabase() throws DatabaseOperationException {
        this.getPlatform().dropModel(this._model, true);
    }

    protected DynaBean insertRow(String tableName, Object[] columnValues) {
        Table table = this.getModel().findTable(tableName);
        DynaBean bean = this.getModel().createDynaBeanFor(table);
        for (int idx = 0; idx < table.getColumnCount() && idx < columnValues.length; ++idx) {
            Column column = table.getColumn(idx);
            bean.set(column.getName(), columnValues[idx]);
        }
        this.getPlatform().insert(this.getModel(), bean);
        return bean;
    }

    protected DynaBean updateRow(String tableName, DynaBean oldBean, Object[] columnValues) {
        Table table = this.getModel().findTable(tableName);
        DynaBean bean = this.getModel().createDynaBeanFor(table);
        for (int idx = 0; idx < table.getColumnCount() && idx < columnValues.length; ++idx) {
            Column column = table.getColumn(idx);
            bean.set(column.getName(), columnValues[idx]);
        }
        this.getPlatform().update(this.getModel(), oldBean, bean);
        return bean;
    }

    protected void deleteRow(String tableName, Object[] pkColumnValues) {
        Table table = this.getModel().findTable(tableName);
        DynaBean bean = this.getModel().createDynaBeanFor(table);
        Column[] pkColumns = table.getPrimaryKeyColumns();
        for (int idx = 0; idx < pkColumns.length && idx < pkColumnValues.length; ++idx) {
            bean.set(pkColumns[idx].getName(), pkColumnValues[idx]);
        }
        this.getPlatform().delete(this.getModel(), bean);
    }

    protected String getSelectQueryForAllString(Table table, String orderColumn) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ");
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatformInfo().getDelimiterToken());
        }
        query.append(table.getName());
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatformInfo().getDelimiterToken());
        }
        if (orderColumn != null) {
            query.append(" ORDER BY ");
            if (this.getPlatform().isDelimitedIdentifierModeOn()) {
                query.append(this.getPlatformInfo().getDelimiterToken());
            }
            query.append(orderColumn);
            if (this.getPlatform().isDelimitedIdentifierModeOn()) {
                query.append(this.getPlatformInfo().getDelimiterToken());
            }
        }
        return query.toString();
    }

    protected List getRows(String tableName) {
        Table table = this.getModel().findTable(tableName, this.getPlatform().isDelimitedIdentifierModeOn());
        return this.getPlatform().fetch(this.getModel(), this.getSelectQueryForAllString(table, null), new Table[]{table});
    }

    protected List getRows(String tableName, String orderColumn) {
        Table table = this.getModel().findTable(tableName, this.getPlatform().isDelimitedIdentifierModeOn());
        return this.getPlatform().fetch(this.getModel(), this.getSelectQueryForAllString(table, orderColumn), new Table[]{table});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertAndEnsureClearDatabase() {
        Database liveModel = this.readModelFromDatabase("tmp");
        boolean hasStuff = false;
        if (liveModel.getTableCount() > 0) {
            hasStuff = true;
            try {
                this.getPlatform().dropModel(liveModel, true);
            }
            catch (Exception ex) {
                this.getLog().error((Object)"Could not clear database", (Throwable)ex);
            }
        }
        if ("Firebird".equals(this.getPlatform().getName()) || "Interbase".equals(this.getPlatform().getName())) {
            Connection connection = null;
            try {
                connection = this.getPlatform().borrowConnection();
                hasStuff |= this.dropTriggers(connection);
                hasStuff |= this.dropGenerators(connection);
            }
            catch (Exception ex) {
                this.getLog().error((Object)"Could not clear database", (Throwable)ex);
            }
            finally {
                this.getPlatform().returnConnection(connection);
            }
        }
        if (hasStuff) {
            TestAgainstLiveDatabaseBase.fail((String)"Database is not empty after test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropGenerators(Connection connection) {
        Statement stmt = null;
        boolean hasGenerators = false;
        try {
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT RDB$GENERATOR_NAME FROM RDB$GENERATORS WHERE RDB$GENERATOR_NAME NOT LIKE '%$%'");
            ArrayList<String> names = new ArrayList<String>();
            while (rs.next()) {
                names.add(rs.getString(1));
            }
            rs.close();
            for (String name : names) {
                if (!name.toLowerCase().startsWith("gen_")) continue;
                hasGenerators = true;
                stmt.execute("DROP GENERATOR " + name);
            }
        }
        catch (Exception ex) {
            this.getLog().error((Object)"Error while dropping the remaining generators", (Throwable)ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    this.getLog().error((Object)"Error while clearing the database", (Throwable)ex);
                }
            }
        }
        return hasGenerators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropTriggers(Connection connection) {
        Statement stmt = null;
        boolean hasTriggers = false;
        try {
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM RDB$TRIGGERS WHERE RDB$SYSTEM_FLAG IS NULL OR RDB$SYSTEM_FLAG = 0");
            ArrayList<String> names = new ArrayList<String>();
            while (rs.next()) {
                names.add(rs.getString(1));
            }
            rs.close();
            for (String name : names) {
                if (!name.toLowerCase().startsWith("trg_")) continue;
                hasTriggers = true;
                stmt.execute("DROP TRIGGER " + name);
            }
        }
        catch (Exception ex) {
            this.getLog().error((Object)"Error while dropping the remaining triggers", (Throwable)ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    this.getLog().error((Object)"Error while clearing the database", (Throwable)ex);
                }
            }
        }
        return hasTriggers;
    }

    protected Database readModelFromDatabase(String databaseName) {
        Properties props = this.getTestProperties();
        String catalog = props.getProperty(DDLUTILS_CATALOG_PROPERTY);
        String schema = props.getProperty(DDLUTILS_SCHEMA_PROPERTY);
        return this.getPlatform().readModelFromDatabase(databaseName, catalog, schema, null);
    }

    protected Database adjustModel(Database sourceModel) {
        Database model = new CloneHelper().clone(sourceModel);
        for (int tableIdx = 0; tableIdx < model.getTableCount(); ++tableIdx) {
            Table table = model.getTable(tableIdx);
            for (int columnIdx = 0; columnIdx < table.getColumnCount(); ++columnIdx) {
                Integer defaultSize;
                Column column = table.getColumn(columnIdx);
                int origType = column.getTypeCode();
                int targetType = this.getPlatformInfo().getTargetJdbcType(origType);
                if (targetType != origType) {
                    column.setTypeCode(targetType);
                    if (column.getDefaultValue() != null) {
                        DefaultValueHelper helper = this.getPlatform().getSqlBuilder().getDefaultValueHelper();
                        column.setDefaultValue(helper.convert(column.getDefaultValue(), origType, targetType));
                    }
                }
                if (column.getSize() == null && this.getPlatformInfo().hasSize(targetType) && (defaultSize = this.getPlatformInfo().getDefaultSize(targetType)) != null) {
                    column.setSize(defaultSize.toString());
                }
                if (this.getPlatformInfo().isSyntheticDefaultValueForRequiredReturned() && column.getDefaultValue() == null && column.isRequired() && !column.isAutoIncrement()) {
                    switch (column.getTypeCode()) {
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            column.setDefaultValue("0");
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            column.setDefaultValue("0.0");
                            break;
                        }
                        case -7: {
                            column.setDefaultValue("false");
                            break;
                        }
                        default: {
                            column.setDefaultValue("");
                        }
                    }
                }
                if (column.isPrimaryKey() && this.getPlatformInfo().isPrimaryKeyColumnAutomaticallyRequired()) {
                    column.setRequired(true);
                }
                if (!column.isAutoIncrement() || !this.getPlatformInfo().isIdentityColumnAutomaticallyRequired()) continue;
                column.setRequired(true);
            }
            for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
                ForeignKey fk = table.getForeignKey(fkIdx);
                if (fk.getName() != null) continue;
                fk.setName(this.getPlatform().getSqlBuilder().getForeignKeyName(table, fk));
            }
        }
        return model;
    }

    protected Database getAdjustedModel() {
        Database model = this.getModel();
        return model == null ? null : this.adjustModel(model);
    }

    protected String getAlterTablesSql(Database desiredModel) {
        Database liveModel = this.readModelFromDatabase(desiredModel.getName());
        return this.getPlatform().getAlterModelSql(liveModel, desiredModel, this.getTableCreationParameters(desiredModel));
    }

    protected Object getPropertyValue(DynaBean bean, String propName) {
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            return bean.get(propName);
        }
        DynaProperty[] props = bean.getDynaClass().getDynaProperties();
        for (int idx = 0; idx < props.length; ++idx) {
            if (!propName.equalsIgnoreCase(props[idx].getName())) continue;
            return bean.get(props[idx].getName());
        }
        throw new IllegalArgumentException("The bean has no property with the name " + propName);
    }

    protected void assertEquals(Database expected, Database actual) {
        this.assertEquals(expected, actual, this._useDelimitedIdentifiers);
    }

    protected void assertEquals(Table expected, Table actual) {
        this.assertEquals(expected, actual, this._useDelimitedIdentifiers);
    }

    protected void assertEquals(Column expected, Column actual) {
        this.assertEquals(expected, actual, this._useDelimitedIdentifiers);
    }

    protected void assertEquals(ForeignKey expected, ForeignKey actual) {
        this.assertEquals(expected, actual, this._useDelimitedIdentifiers);
    }

    protected void assertEquals(Reference expected, Reference actual) {
        this.assertEquals(expected, actual, this._useDelimitedIdentifiers);
    }

    protected void assertEquals(Index expected, Index actual) {
        this.assertEquals(expected, actual, this._useDelimitedIdentifiers);
    }

    protected void assertEquals(IndexColumn expected, IndexColumn actual) {
        this.assertEquals(expected, actual, this._useDelimitedIdentifiers);
    }

    protected void assertEquals(Object expected, Object bean, String attrName) {
        SqlDynaClass dynaClass;
        Column column;
        DynaBean dynaBean = (DynaBean)bean;
        Object value = dynaBean.get(attrName);
        if (value instanceof byte[] && !(expected instanceof byte[]) && dynaBean instanceof SqlDynaBean && TypeMap.isBinaryType((int)(column = ((SqlDynaProperty)(dynaClass = (SqlDynaClass)((SqlDynaBean)dynaBean).getDynaClass()).getDynaProperty(attrName)).getColumn()).getTypeCode())) {
            value = new BinaryObjectsHelper().deserialize((byte[])value);
        }
        if (expected == null) {
            TestAgainstLiveDatabaseBase.assertNull((Object)value);
        } else {
            TestAgainstLiveDatabaseBase.assertEquals((Object)expected, (Object)value);
        }
    }

    protected void assertEquals(Database expected, Database actual, boolean caseSensitive) {
        try {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Model names do not match.", (String)expected.getName(), (String)actual.getName());
            TestAgainstLiveDatabaseBase.assertEquals((String)"Not the same number of tables.", (int)expected.getTableCount(), (int)actual.getTableCount());
            for (int tableIdx = 0; tableIdx < actual.getTableCount(); ++tableIdx) {
                this.assertEquals(expected.getTable(tableIdx), actual.getTable(tableIdx), caseSensitive);
            }
        }
        catch (Throwable ex) {
            StringWriter writer = new StringWriter();
            DatabaseIO dbIo = new DatabaseIO();
            dbIo.write(expected, (Writer)writer);
            this.getLog().error((Object)("Expected model:\n" + writer.toString()));
            writer = new StringWriter();
            dbIo.write(actual, (Writer)writer);
            this.getLog().error((Object)("Actual model:\n" + writer.toString()));
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw new DdlUtilsException(ex);
        }
    }

    protected void assertEquals(Table expected, Table actual, boolean caseSensitive) {
        if (caseSensitive) {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Table names do not match.", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getName(), this.getSqlBuilder().getMaxTableNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getName(), this.getSqlBuilder().getMaxTableNameLength()));
        } else {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Table names do not match (ignoring case).", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getName().toUpperCase(), this.getSqlBuilder().getMaxTableNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getName().toUpperCase(), this.getSqlBuilder().getMaxTableNameLength()));
        }
        TestAgainstLiveDatabaseBase.assertEquals((String)("Not the same number of columns in table " + actual.getName() + "."), (int)expected.getColumnCount(), (int)actual.getColumnCount());
        for (int columnIdx = 0; columnIdx < actual.getColumnCount(); ++columnIdx) {
            this.assertEquals(expected.getColumn(columnIdx), actual.getColumn(columnIdx), caseSensitive);
        }
        TestAgainstLiveDatabaseBase.assertEquals((String)("Not the same number of foreign keys in table " + actual.getName() + "."), (int)expected.getForeignKeyCount(), (int)actual.getForeignKeyCount());
        for (int expectedFkIdx = 0; expectedFkIdx < expected.getForeignKeyCount(); ++expectedFkIdx) {
            ForeignKey expectedFk = expected.getForeignKey(expectedFkIdx);
            String expectedName = this.getPlatform().getSqlBuilder().shortenName(expectedFk.getName(), this.getSqlBuilder().getMaxForeignKeyNameLength());
            for (int actualFkIdx = 0; actualFkIdx < actual.getForeignKeyCount(); ++actualFkIdx) {
                ForeignKey actualFk = actual.getForeignKey(actualFkIdx);
                String actualName = this.getPlatform().getSqlBuilder().shortenName(actualFk.getName(), this.getSqlBuilder().getMaxForeignKeyNameLength());
                if (!StringUtilsExt.equals((String)expectedName, (String)actualName, (boolean)caseSensitive)) continue;
                this.assertEquals(expectedFk, actualFk, caseSensitive);
            }
        }
        TestAgainstLiveDatabaseBase.assertEquals((String)("Not the same number of indices in table " + actual.getName() + "."), (int)expected.getIndexCount(), (int)actual.getIndexCount());
        for (int indexIdx = 0; indexIdx < actual.getIndexCount(); ++indexIdx) {
            this.assertEquals(expected.getIndex(indexIdx), actual.getIndex(indexIdx), caseSensitive);
        }
    }

    protected void assertEquals(Column expected, Column actual, boolean caseSensitive) {
        if (caseSensitive) {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Column names do not match.", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getName(), this.getSqlBuilder().getMaxColumnNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getName(), this.getSqlBuilder().getMaxColumnNameLength()));
        } else {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Column names do not match (ignoring case).", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getName().toUpperCase(), this.getSqlBuilder().getMaxColumnNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getName().toUpperCase(), this.getSqlBuilder().getMaxColumnNameLength()));
        }
        TestAgainstLiveDatabaseBase.assertEquals((String)("Primary key status not the same for column " + actual.getName() + "."), (boolean)expected.isPrimaryKey(), (boolean)actual.isPrimaryKey());
        TestAgainstLiveDatabaseBase.assertEquals((String)("Required status not the same for column " + actual.getName() + "."), (boolean)expected.isRequired(), (boolean)actual.isRequired());
        if (this.getPlatformInfo().getIdentityStatusReadingSupported()) {
            TestAgainstLiveDatabaseBase.assertEquals((String)("Auto-increment status not the same for column " + actual.getName() + "."), (boolean)expected.isAutoIncrement(), (boolean)actual.isAutoIncrement());
        }
        TestAgainstLiveDatabaseBase.assertEquals((String)("Type not the same for column " + actual.getName() + "."), (String)expected.getType(), (String)actual.getType());
        TestAgainstLiveDatabaseBase.assertEquals((String)("Type code not the same for column " + actual.getName() + "."), (int)expected.getTypeCode(), (int)actual.getTypeCode());
        TestAgainstLiveDatabaseBase.assertEquals((String)("Parsed default values do not match for column " + actual.getName() + "."), (Object)expected.getParsedDefaultValue(), (Object)actual.getParsedDefaultValue());
        if (expected.getTypeCode() == 2 || expected.getTypeCode() == 3) {
            TestAgainstLiveDatabaseBase.assertEquals((String)("Precision not the same for column " + actual.getName() + "."), (int)expected.getSizeAsInt(), (int)actual.getSizeAsInt());
            TestAgainstLiveDatabaseBase.assertEquals((String)("Scale not the same for column " + actual.getName() + "."), (int)expected.getScale(), (int)actual.getScale());
        } else if (expected.getTypeCode() == 1 || expected.getTypeCode() == 12 || expected.getTypeCode() == -2 || expected.getTypeCode() == -3) {
            TestAgainstLiveDatabaseBase.assertEquals((String)("Size not the same for column " + actual.getName() + "."), (String)expected.getSize(), (String)actual.getSize());
        }
    }

    protected void assertEquals(ForeignKey expected, ForeignKey actual, boolean caseSensitive) {
        if (caseSensitive) {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Foreign key names do not match.", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getName(), this.getSqlBuilder().getMaxForeignKeyNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getName(), this.getSqlBuilder().getMaxForeignKeyNameLength()));
            TestAgainstLiveDatabaseBase.assertEquals((String)"Referenced table names do not match.", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getForeignTableName(), this.getSqlBuilder().getMaxTableNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getForeignTableName(), this.getSqlBuilder().getMaxTableNameLength()));
        } else {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Foreign key names do not match (ignoring case).", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getName().toUpperCase(), this.getSqlBuilder().getMaxForeignKeyNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getName().toUpperCase(), this.getSqlBuilder().getMaxForeignKeyNameLength()));
            TestAgainstLiveDatabaseBase.assertEquals((String)"Referenced table names do not match (ignoring case).", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getForeignTableName().toUpperCase(), this.getSqlBuilder().getMaxTableNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getForeignTableName().toUpperCase(), this.getSqlBuilder().getMaxTableNameLength()));
        }
        TestAgainstLiveDatabaseBase.assertTrue((String)("Not the same onUpdate setting in foreign key " + actual.getName() + ": expected = " + expected.getOnUpdate() + ", actual = " + actual.getOnUpdate()), (expected.getOnUpdate().equals((Object)actual.getOnUpdate()) || this.getPlatformInfo().areEquivalentOnUpdateActions(expected.getOnUpdate(), actual.getOnUpdate()) ? 1 : 0) != 0);
        TestAgainstLiveDatabaseBase.assertTrue((String)("Not the same onDelete setting in foreign key " + actual.getName() + ": expected = " + expected.getOnDelete() + ", actual = " + actual.getOnDelete()), (expected.getOnDelete().equals((Object)actual.getOnDelete()) || this.getPlatformInfo().areEquivalentOnDeleteActions(expected.getOnDelete(), actual.getOnDelete()) ? 1 : 0) != 0);
        TestAgainstLiveDatabaseBase.assertEquals((String)("Not the same number of references in foreign key " + actual.getName() + "."), (int)expected.getReferenceCount(), (int)actual.getReferenceCount());
        for (int refIdx = 0; refIdx < actual.getReferenceCount(); ++refIdx) {
            this.assertEquals(expected.getReference(refIdx), actual.getReference(refIdx), caseSensitive);
        }
    }

    protected void assertEquals(Reference expected, Reference actual, boolean caseSensitive) {
        if (caseSensitive) {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Local column names do not match.", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getLocalColumnName(), this.getSqlBuilder().getMaxColumnNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getLocalColumnName(), this.getSqlBuilder().getMaxColumnNameLength()));
            TestAgainstLiveDatabaseBase.assertEquals((String)"Foreign column names do not match.", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getForeignColumnName(), this.getSqlBuilder().getMaxColumnNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getForeignColumnName(), this.getSqlBuilder().getMaxColumnNameLength()));
        } else {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Local column names do not match (ignoring case).", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getLocalColumnName().toUpperCase(), this.getSqlBuilder().getMaxColumnNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getLocalColumnName().toUpperCase(), this.getSqlBuilder().getMaxColumnNameLength()));
            TestAgainstLiveDatabaseBase.assertEquals((String)"Foreign column names do not match (ignoring case).", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getForeignColumnName().toUpperCase(), this.getSqlBuilder().getMaxColumnNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getForeignColumnName().toUpperCase(), this.getSqlBuilder().getMaxColumnNameLength()));
        }
    }

    protected void assertEquals(Index expected, Index actual, boolean caseSensitive) {
        if (caseSensitive) {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Index names do not match.", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getName(), this.getSqlBuilder().getMaxConstraintNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getName(), this.getSqlBuilder().getMaxConstraintNameLength()));
        } else {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Index names do not match (ignoring case).", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getName().toUpperCase(), this.getSqlBuilder().getMaxConstraintNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getName().toUpperCase(), this.getSqlBuilder().getMaxConstraintNameLength()));
        }
        TestAgainstLiveDatabaseBase.assertEquals((String)("Unique status not the same for index " + actual.getName() + "."), (boolean)expected.isUnique(), (boolean)actual.isUnique());
        TestAgainstLiveDatabaseBase.assertEquals((String)("Not the same number of columns in index " + actual.getName() + "."), (int)expected.getColumnCount(), (int)actual.getColumnCount());
        for (int columnIdx = 0; columnIdx < actual.getColumnCount(); ++columnIdx) {
            this.assertEquals(expected.getColumn(columnIdx), actual.getColumn(columnIdx), caseSensitive);
        }
    }

    protected void assertEquals(IndexColumn expected, IndexColumn actual, boolean caseSensitive) {
        if (caseSensitive) {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Index column names do not match.", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getName(), this.getSqlBuilder().getMaxColumnNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getName(), this.getSqlBuilder().getMaxColumnNameLength()));
        } else {
            TestAgainstLiveDatabaseBase.assertEquals((String)"Index column names do not match (ignoring case).", (String)this.getPlatform().getSqlBuilder().shortenName(expected.getName().toUpperCase(), this.getSqlBuilder().getMaxColumnNameLength()), (String)this.getPlatform().getSqlBuilder().shortenName(actual.getName().toUpperCase(), this.getSqlBuilder().getMaxColumnNameLength()));
        }
        TestAgainstLiveDatabaseBase.assertEquals((String)("Size not the same for index column " + actual.getName() + "."), (String)expected.getSize(), (String)actual.getSize());
    }
}

