/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.pxf.gfxd.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

public class TestDataHelper {
    public static final int RECORDS_PER_SPLIT = 5;
    public static final String BASE_DIR = "ashetkar2/gemfire/gfxd/";
    public static final String SCHEMA_NAME = "schemaone";
    public static final String[] TABLE_NAMES = new String[]{"region1", "region2", "region3"};
    public static final String[][][] TABLE_META_DATA = new String[][][]{{{"order_id", "23", "integer"}, {"cust_id", "23", "integer"}}, {{"cust_id", "23", "integer"}, {"cust_name", "1043", "varchar"}, {"cust_address", "1043", "varchar"}}, {{"order_id", "23", "integer"}, {"order_desc", "1043", "varchar"}, {"order_shipped", "16", "boolean"}, {"cust_id", "23", "integer"}}};
    public static final String[] HOST_NAMES = new String[]{"hostname1", "hostname2", "hostname3", "hostname4", "hostname5"};
    private static final HashMap<String, InputSplit[]> REGION_SPLITS = new HashMap();
    private static final HashMap<InputSplit, List<Object[]>> SPLIT_DATA = new HashMap();

    private static void initializeTestData() {
        TestDataHelper.populateRegionSplits();
        TestDataHelper.populateSplitRecords();
    }

    public static Map<String, String> populateInputDataParam(int tableIndex) {
        return TestDataHelper.populateInputDataParam(tableIndex, 0, 1, "0");
    }

    public static Map<String, String> populateInputDataParam(int tableIndex, int segId, int segCount, String segs) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("X-GP-ALIGNMENT", "4");
        map.put("X-GP-SEGMENT-ID", String.valueOf(segId));
        map.put("X-GP-SEGMENT-COUNT", String.valueOf(segCount));
        map.put("X-GP-DATA-FRAGMENT", segs);
        map.put("X-GP-HAS-FILTER", "0");
        map.put("X-GP-FORMAT", "GPDBWritable");
        map.put("X-GP-URL-HOST", "hostname");
        map.put("X-GP-URL-PORT", "30079");
        map.put("X-GP-DATA-DIR", "ashetkar2/gemfire/gfxd/schemaone." + TABLE_NAMES[tableIndex]);
        map.put("X-GP-ATTRS", String.valueOf(TABLE_META_DATA[tableIndex].length));
        for (int i = 0; i < TABLE_META_DATA[tableIndex].length; ++i) {
            map.put("X-GP-ATTR-NAME" + i, TABLE_META_DATA[tableIndex][i][0]);
            map.put("X-GP-ATTR-TYPECODE" + i, TABLE_META_DATA[tableIndex][i][1]);
            map.put("X-GP-ATTR-TYPENAME" + i, TABLE_META_DATA[tableIndex][i][2]);
        }
        map.put("X-GP-ACCESSOR", "GemFireXDAccessor");
        map.put("X-GP-RESOLVER", "GemFireXDResolver");
        return map;
    }

    private static void populateRegionSplits() {
        InputSplit[] splits1 = new InputSplit[1];
        InputSplit[] splits2 = new InputSplit[5];
        InputSplit[] splits3 = new InputSplit[10];
        String path = "/ashetkar2/gemfire/gfxd/schemaone." + TABLE_NAMES[0] + "/data.hop";
        splits1[0] = TestDataHelper.getCombineSplit(new Path(path), 0L, 1024L, new String[]{HOST_NAMES[0], HOST_NAMES[1]});
        path = "/ashetkar2/gemfire/gfxd/schemaone." + TABLE_NAMES[1] + "/data1.hop";
        splits2[0] = TestDataHelper.getCombineSplit(new Path(path), 0L, 512L, new String[]{HOST_NAMES[0], HOST_NAMES[1]});
        splits2[1] = TestDataHelper.getCombineSplit(new Path(path), 512L, 512L, new String[]{HOST_NAMES[0], HOST_NAMES[2]});
        path = "/ashetkar2/gemfire/gfxd/schemaone." + TABLE_NAMES[1] + "/data2.hop";
        splits2[2] = TestDataHelper.getCombineSplit(new Path(path), 1024L, 1024L, new String[]{HOST_NAMES[0], HOST_NAMES[3]});
        splits2[3] = TestDataHelper.getCombineSplit(new Path(path), 2048L, 2048L, new String[]{HOST_NAMES[1], HOST_NAMES[2]});
        path = "/ashetkar2/gemfire/gfxd/schemaone." + TABLE_NAMES[1] + "/data.hop";
        splits2[4] = TestDataHelper.getCombineSplit(new Path(path), 4096L, 512L, new String[]{HOST_NAMES[2], HOST_NAMES[3]});
        path = "/ashetkar2/gemfire/gfxd/schemaone." + TABLE_NAMES[2] + "/data1.hop";
        splits3[0] = TestDataHelper.getCombineSplit(new Path(path), 0L, 1024L, new String[]{HOST_NAMES[0], HOST_NAMES[1]});
        splits3[1] = TestDataHelper.getCombineSplit(new Path(path), 1024L, 1024L, new String[]{HOST_NAMES[0], HOST_NAMES[2]});
        splits3[2] = TestDataHelper.getCombineSplit(new Path(path), 2048L, 1024L, new String[]{HOST_NAMES[0], HOST_NAMES[3]});
        splits3[3] = TestDataHelper.getCombineSplit(new Path(path), 3072L, 1024L, new String[]{HOST_NAMES[0], HOST_NAMES[1], HOST_NAMES[3]});
        path = "/ashetkar2/gemfire/gfxd/schemaone." + TABLE_NAMES[2] + "/data.hop";
        splits3[4] = TestDataHelper.getCombineSplit(new Path(path), 4096L, 1024L, new String[]{HOST_NAMES[1], HOST_NAMES[2]});
        splits3[5] = TestDataHelper.getCombineSplit(new Path(path), 5120L, 1024L, new String[]{HOST_NAMES[1], HOST_NAMES[3]});
        splits3[6] = TestDataHelper.getCombineSplit(new Path(path), 6144L, 1024L, new String[]{HOST_NAMES[1], HOST_NAMES[2], HOST_NAMES[3]});
        splits3[7] = TestDataHelper.getCombineSplit(new Path(path), 7168L, 1024L, new String[]{HOST_NAMES[2], HOST_NAMES[3]});
        splits3[8] = TestDataHelper.getCombineSplit(new Path(path), 8192L, 1024L, new String[]{HOST_NAMES[2], HOST_NAMES[3], HOST_NAMES[0]});
        splits3[9] = TestDataHelper.getCombineSplit(new Path(path), 9216L, 1024L, new String[]{HOST_NAMES[3], HOST_NAMES[4]});
        REGION_SPLITS.put(TABLE_NAMES[0], splits1);
        REGION_SPLITS.put(TABLE_NAMES[1], splits2);
        REGION_SPLITS.put(TABLE_NAMES[2], splits3);
    }

    private static InputSplit getCombineSplit(Path path, long l, long m, String[] strings) {
        Path[] paths = new Path[]{path};
        long[] offsets = new long[]{l};
        long[] lengths = new long[]{m};
        return new CombineFileSplit(null, paths, offsets, lengths, strings);
    }

    private static void populateSplitRecords() {
        int j;
        ArrayList<Object[]> list;
        String r = TABLE_NAMES[0];
        int i = 0;
        for (InputSplit split : TestDataHelper.getSplits(r)) {
            list = new ArrayList<Object[]>();
            j = 0;
            while (j < 5) {
                list.add(new Object[]{i, i + 1000});
                ++j;
                ++i;
            }
            SPLIT_DATA.put(split, list);
            ++i;
        }
        r = TABLE_NAMES[1];
        for (InputSplit split : TestDataHelper.getSplits(r)) {
            list = new ArrayList();
            j = 0;
            while (j < 5) {
                list.add(new Object[]{i + 1000, "cust_name_" + i, "cust_address_" + i});
                ++j;
                ++i;
            }
            SPLIT_DATA.put(split, list);
            ++i;
        }
        r = TABLE_NAMES[2];
        for (InputSplit split : TestDataHelper.getSplits(r)) {
            list = new ArrayList();
            j = 0;
            while (j < 5) {
                list.add(new Object[]{i, "order_desc_" + i, Boolean.TRUE, i + 1000});
                ++j;
                ++i;
            }
            SPLIT_DATA.put(split, list);
            ++i;
        }
    }

    public static InputSplit[] getSplits(String region) {
        return REGION_SPLITS.get(region);
    }

    public static List<Object[]> getSplitRecords(InputSplit split) {
        return SPLIT_DATA.get(split);
    }

    public static byte[] serialize(Object data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        if (data instanceof Object[]) {
            out.write(((Object[])data).length);
            for (Object obj : (Object[])data) {
                TestDataHelper.write(out, obj);
            }
        } else {
            TestDataHelper.write(out, data);
        }
        return baos.toByteArray();
    }

    private static void write(DataOutput out, Object data) throws IOException {
        if (data instanceof Integer) {
            out.writeInt((Integer)data);
        } else if (data instanceof String) {
            out.writeUTF((String)data);
        } else if (data instanceof Boolean) {
            out.writeBoolean((Boolean)data);
        } else {
            throw new IllegalArgumentException("Unknown type " + data);
        }
    }

    public static Object deserialize(String region, byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(bais);
        Integer result = null;
        if (TABLE_NAMES[0].equals(region)) {
            result = in.readInt();
        } else if (TABLE_NAMES[1].equals(region)) {
            result = in.readInt();
        } else if (TABLE_NAMES[2].equals(region)) {
            result = in.readInt();
        } else {
            throw new Exception("Region is unknown " + region);
        }
        return result;
    }

    public static Object[] deserializeArray(String region, byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(bais);
        Object[] result = null;
        byte values = in.readByte();
        result = new Object[values];
        if (TABLE_NAMES[0].equals(region)) {
            result[0] = in.readInt();
            result[1] = in.readInt();
        } else if (TABLE_NAMES[1].equals(region)) {
            result[0] = in.readInt();
            result[1] = in.readUTF();
            result[2] = in.readUTF();
        } else if (TABLE_NAMES[2].equals(region)) {
            result[0] = in.readInt();
            result[1] = in.readUTF();
            result[2] = in.readBoolean();
            result[3] = in.readInt();
        } else {
            throw new Exception("Region is unknown " + region);
        }
        return result;
    }

    static {
        TestDataHelper.initializeTestData();
    }
}

