/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.pxf.gfxd;

import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.pxf.gfxd.util.TestDataHelper;
import java.io.IOException;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

public class TestRecordReader
implements RecordReader<Object, Object> {
    private int numOfRecords = 5;
    private int currentRecord = 0;
    protected InputSplit split;

    public TestRecordReader(JobConf job, InputSplit split) {
        this.split = split;
    }

    public void close() throws IOException {
    }

    public boolean next(Object key, Object val) throws IOException {
        if (this.currentRecord == this.numOfRecords) {
            return false;
        }
        Object[] record = TestDataHelper.getSplitRecords(this.split).get(this.currentRecord);
        byte[] k = TestDataHelper.serialize(record[0]);
        byte[] v = TestDataHelper.serialize(record);
        ((KeyClass)((Object)key)).setValue(k);
        ((ValueClass)((Object)val)).setValue(v);
        ++this.currentRecord;
        return true;
    }

    public Object createKey() {
        return new KeyClass();
    }

    public Object createValue() {
        return new ValueClass();
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    public class ValueClass
    extends Row {
        private byte[] bytes;

        public void setValue(byte[] val) {
            this.bytes = val;
        }

        public byte[] getValue() {
            return this.bytes;
        }

        public String toString() {
            return "hello" + this.bytes;
        }
    }

    public class KeyClass
    extends Key {
        private byte[] bytes;

        public void setValue(byte[] val) {
            this.bytes = val;
        }

        public byte[] getValue() {
            return this.bytes;
        }

        public String toString() {
            return "hello" + this.bytes;
        }
    }
}

