/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.wan;

import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.TestUtil;
import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.AvailablePortHelper;
import io.snappydata.test.dunit.VM;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;

public class GfxdWanTestBase
extends DistributedSQLTestBase {
    public static final String SITE_A = "A";
    public static final String SITE_B = "B";
    public static final String SITE_C = "C";
    public static final String SITE_D = "D";

    public GfxdWanTestBase(String name) {
        super(name);
    }

    public int getSiteAccessorServerNum(String site) throws Exception {
        if (site.equals(SITE_A)) {
            return 3;
        }
        if (site.equals(SITE_B)) {
            return 7;
        }
        if (site.equals(SITE_C)) {
            return 11;
        }
        if (site.equals(SITE_D)) {
            return 15;
        }
        throw new Exception("Unexpected site: " + site);
    }

    public VM getSiteAccessor(String site) throws Exception {
        return (VM)this.serverVMs.get(this.getSiteAccessorServerNum(site));
    }

    public boolean compareSites(String siteOne, String siteTwo, String query) throws Exception {
        int siteOneServerNum = this.getSiteAccessorServerNum(siteOne);
        int siteTwoServerNum = this.getSiteAccessorServerNum(siteTwo);
        int siteOnePort = this.startNetworkServer(siteOneServerNum, null, null);
        int siteTwoPort = this.startNetworkServer(siteTwoServerNum, null, null);
        InetAddress localHost = SocketCreator.getLocalHost();
        this.getLogWriter().info((Object)("Comparing site results for query:" + query));
        String firstUrl = TestUtil.getNetProtocol(localHost.getHostName(), siteOnePort);
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(firstUrl, props);
        Statement st = conn.createStatement();
        st.execute(query);
        ResultSet result = st.getResultSet();
        String secondUrl = TestUtil.getNetProtocol(localHost.getHostName(), siteTwoPort);
        Connection conn2 = DriverManager.getConnection(secondUrl, props);
        Statement st2 = conn2.createStatement();
        st2.execute(query);
        ResultSet result2 = st2.getResultSet();
        boolean retVal = TestUtil.compareResults(result, result2, false);
        st.close();
        st2.close();
        conn.close();
        conn2.close();
        return retVal;
    }

    public void executeSql(String site, String sql) throws Exception {
        VM siteAccessor = this.getSiteAccessor(site);
        this.executeSql(siteAccessor, sql);
    }

    public void executeOnSite(String site, Runnable runnable) throws Exception {
        this.getSiteAccessor(site).invoke(runnable);
    }

    public void executeOnSite(String site, Callable callable) throws Exception {
        this.getSiteAccessor(site).invoke(callable);
    }

    public void executeOnSitesAsync(String[] sites, Runnable runnable, boolean waitForAllToFinish) throws Exception {
        ArrayList<AsyncInvocation> asyncList = new ArrayList<AsyncInvocation>(sites.length);
        for (String site : sites) {
            asyncList.add(this.getSiteAccessor(site).invokeAsync(runnable));
        }
        if (waitForAllToFinish) {
            this.joinAsyncInvocation(asyncList);
        }
    }

    public void executeOnSitesAsync(String[] sites, Runnable runnable) throws Exception {
        this.executeOnSitesAsync(sites, runnable, true);
    }

    public void _addExpectedException(String[] sites, Object[] exceptionClasses) throws Exception {
        int start = -1;
        int end = -1;
        for (String site : sites) {
            if (site.equals(SITE_A)) {
                start = 1;
                end = 3;
            } else if (site.equals(SITE_B)) {
                start = 5;
                end = 7;
            } else if (site.equals(SITE_C)) {
                start = 9;
                end = 11;
            } else if (site.equals(SITE_D)) {
                start = 13;
                end = 15;
            } else {
                throw new Exception("Invalid site:" + site);
            }
            for (int i = start; i <= end; ++i) {
                VM serverVM = (VM)this.serverVMs.get(i);
                this.getLogWriter().info((Object)("Adding expected exceptions to site " + site + ", VM=" + i + ", VMDir=" + serverVM.getWorkingDirectory().getAbsolutePath()));
                super.addExpectedException(serverVM, exceptionClasses);
            }
        }
    }

    public void addExpectedException(String[] sites, Object[] exceptionClasses) throws Exception {
        VM[] vms = this.getServerVMs(sites);
        for (int i = 0; i < vms.length; ++i) {
            VM serverVM = vms[i];
            super.addExpectedException(serverVM, exceptionClasses);
        }
    }

    public void addExpectedException(String[] sites, String[] strings) throws Exception {
        VM[] vms;
        for (VM vm : vms = this.getServerVMs(sites)) {
            for (String s : strings) {
                DistributedSQLTestBase.addExpectedException((String)s, (VM)vm);
            }
        }
    }

    protected VM[] getServerVMs(String[] sites) throws Exception {
        int start = -1;
        int end = -1;
        VM[] vms = new VM[sites.length * 3];
        int index = 0;
        for (String site : sites) {
            if (site.equals(SITE_A)) {
                start = 1;
                end = 3;
            } else if (site.equals(SITE_B)) {
                start = 5;
                end = 7;
            } else if (site.equals(SITE_C)) {
                start = 9;
                end = 11;
            } else if (site.equals(SITE_D)) {
                start = 13;
                end = 15;
            } else {
                throw new Exception("Invalid site:" + site);
            }
            for (int i = start; i <= end; ++i) {
                vms[index] = (VM)this.serverVMs.get(i);
                ++index;
            }
        }
        return vms;
    }

    public void sqlExecuteVerify(String site, String sql, String goldenTextFile, String resultSetID, boolean usePrepStmt, boolean checkTypeInfo) throws Exception {
        VM siteVM = this.getSiteAccessor(site);
        this.sqlExecuteVerify(siteVM, sql, goldenTextFile, resultSetID, usePrepStmt, checkTypeInfo);
    }

    public void sqlExecuteVerify(VM vm, String sql, String goldenTextFile, String resultSetID, boolean usePrepStmt, boolean checkTypeInfo) throws Exception {
        this.execute(vm, sql, true, goldenTextFile, resultSetID, null, null, null, usePrepStmt, checkTypeInfo, false);
    }

    public void executeSql(VM vm, String sql) throws Exception {
        this.executeSql(vm, sql, false);
    }

    public void executeSql(VM vm, String sql, boolean doVerify) throws Exception {
        this.execute(vm, sql, doVerify, null, null, null, null, null, true, false, false);
    }

    public void startSites() throws Exception {
        this.getLogWriter().info((Object)"Starting 4 WAN sites");
        this.getLogWriter().info((Object)"Starting SITE_A");
        Properties props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "_A");
        props.setProperty("mcast-port", "0");
        int aPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.setProperty("locators", "localhost[" + aPort + "]");
        props.setProperty("distributed-system-id", "1");
        this.startLocatorVM("localhost", aPort, null, props);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + aPort + "]");
        props.setProperty("gemfirexd.debug.true", "TraceDBSynchronizer");
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "sg1", props);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "sg1,sgSender", props);
        props.setProperty("host-data", "false");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1,sgSender", props);
        this.joinVMs(true, async1, async2, async3);
        GfxdWanTestBase.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.getLogWriter().info((Object)"Started SITE_A");
        this.getLogWriter().info((Object)"Starting SITE_B");
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "_B");
        props.setProperty("mcast-port", "0");
        int bPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.setProperty("locators", "localhost[" + bPort + "]");
        props.setProperty("remote-locators", "localhost[" + aPort + "]");
        props.setProperty("distributed-system-id", "2");
        this.startLocatorVM("localhost", bPort, null, props);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + bPort + "]");
        props.setProperty("gemfirexd.debug.true", "TraceDBSynchronizer");
        async1 = this.invokeStartServerVM(1, 0, "sg1", props);
        async2 = this.invokeStartServerVM(2, 0, "sg1,sgSender", props);
        props.setProperty("host-data", "false");
        async3 = this.invokeStartServerVM(3, 0, "sg1,sgSender", props);
        this.joinVMs(true, async1, async2, async3);
        GfxdWanTestBase.assertTrue((this.serverVMs.size() == 8 ? 1 : 0) != 0);
        this.getLogWriter().info((Object)"Started SITE_B");
        this.getLogWriter().info((Object)"Starting SITE_C");
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "_C");
        props.setProperty("mcast-port", "0");
        int cPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.setProperty("locators", "localhost[" + cPort + "]");
        props.setProperty("remote-locators", "localhost[" + aPort + "]");
        props.setProperty("distributed-system-id", "3");
        this.startLocatorVM("localhost", cPort, null, props);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + cPort + "]");
        props.setProperty("gemfirexd.debug.true", "TraceDBSynchronizer");
        async1 = this.invokeStartServerVM(1, 0, "sg1", props);
        async2 = this.invokeStartServerVM(2, 0, "sg1,sgSender", props);
        props.setProperty("host-data", "false");
        async3 = this.invokeStartServerVM(3, 0, "sg1,sgSender", props);
        this.joinVMs(true, async1, async2, async3);
        GfxdWanTestBase.assertTrue((this.serverVMs.size() == 12 ? 1 : 0) != 0);
        this.getLogWriter().info((Object)"Started SITE_C");
        this.getLogWriter().info((Object)"Starting SITE_D");
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "_D");
        props.setProperty("mcast-port", "0");
        int dPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.setProperty("locators", "localhost[" + dPort + "]");
        props.setProperty("remote-locators", "localhost[" + aPort + "]");
        props.setProperty("distributed-system-id", "4");
        this.startLocatorVM("localhost", dPort, null, props);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + dPort + "]");
        props.setProperty("gemfirexd.debug.true", "TraceDBSynchronizer");
        async1 = this.invokeStartServerVM(1, 0, "sg1", props);
        async2 = this.invokeStartServerVM(2, 0, "sg1,sgSender", props);
        props.setProperty("host-data", "false");
        async3 = this.invokeStartServerVM(3, 0, "sg1,sgSender", props);
        this.joinVMs(true, async1, async2, async3);
        this.getLogWriter().info((Object)"Started SITE_D");
        GfxdWanTestBase.assertTrue((this.serverVMs.size() == 16 ? 1 : 0) != 0);
    }

    public void startTwoSites() throws Exception {
        this.getLogWriter().info((Object)"Starting 2 WAN sites");
        int aLocatorPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        int bLocatorPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        this.getLogWriter().info((Object)"Starting SITE_A");
        Properties props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "_A");
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + aLocatorPort + "]");
        props.setProperty("distributed-system-id", "1");
        this.startLocatorVM("localhost", aLocatorPort, null, props);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + aLocatorPort + "]");
        props.setProperty("remote-locators", "localhost[" + bLocatorPort + "]");
        props.setProperty("gemfirexd.debug.true", "TraceDBSynchronizer");
        DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "sg1", props);
        DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "sg1,sgSender", props);
        props.setProperty("host-data", "false");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1,sgSender", props);
        this.joinVMs(true, async1, async2, async3);
        GfxdWanTestBase.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.getLogWriter().info((Object)"Started SITE_A");
        this.getLogWriter().info((Object)"Starting SITE_B");
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "_B");
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + bLocatorPort + "]");
        props.setProperty("remote-locators", "localhost[" + aLocatorPort + "]");
        props.setProperty("distributed-system-id", "2");
        this.startLocatorVM("localhost", bLocatorPort, null, props);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + bLocatorPort + "]");
        props.setProperty("gemfirexd.debug.true", "TraceDBSynchronizer");
        async1 = this.invokeStartServerVM(1, 0, "sg1", props);
        async2 = this.invokeStartServerVM(2, 0, "sg1,sgSender", props);
        props.setProperty("host-data", "false");
        async3 = this.invokeStartServerVM(3, 0, "sg1,sgSender", props);
        this.joinVMs(true, async1, async2, async3);
        GfxdWanTestBase.assertTrue((this.serverVMs.size() == 8 ? 1 : 0) != 0);
        this.getLogWriter().info((Object)"Started SITE_B");
    }

    public void startSites(int numSites) throws Exception {
        this.getLogWriter().info((Object)("Starting " + numSites + " WAN sites"));
        int createdSites = 0;
        int remotePort = 0;
        while (createdSites < numSites) {
            Properties props = new Properties();
            if (++createdSites == 1) {
                this.getLogWriter().info((Object)"Starting SITE_A");
                props.put("sys-disk-dir", this.getUniqueName() + "_A");
                props.setProperty("distributed-system-id", "1");
            }
            if (createdSites == 2) {
                this.getLogWriter().info((Object)"Starting SITE_B");
                props.put("sys-disk-dir", this.getUniqueName() + "_B");
                props.setProperty("distributed-system-id", "2");
                props.setProperty("remote-locators", "localhost[" + remotePort + "]");
            }
            if (createdSites == 3) {
                this.getLogWriter().info((Object)"Starting SITE_C");
                props.put("sys-disk-dir", this.getUniqueName() + "_C");
                props.setProperty("distributed-system-id", "3");
                props.setProperty("remote-locators", "localhost[" + remotePort + "]");
            }
            if (createdSites == 4) {
                this.getLogWriter().info((Object)"Starting SITE_D");
                props.put("sys-disk-dir", this.getUniqueName() + "_D");
                props.setProperty("distributed-system-id", "4");
                props.setProperty("remote-locators", "localhost[" + remotePort + "]");
            }
            props.setProperty("mcast-port", "0");
            int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
            props.setProperty("locators", "localhost[" + port + "]");
            this.startLocatorVM("localhost", port, null, props);
            props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", "localhost[" + port + "]");
            props.setProperty("gemfirexd.debug.true", "TraceDBSynchronizer,TraceDBSynchronizerHA");
            DistributedSQLTestBase.AsyncVM async1 = this.invokeStartServerVM(1, 0, "sg1,sg2", props);
            DistributedSQLTestBase.AsyncVM async2 = this.invokeStartServerVM(2, 0, "sg1,sg2,sgSender", props);
            props.setProperty("host-data", "false");
            DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1,sgSender", props);
            this.joinVMs(true, async1, async2, async3);
            if (createdSites == 1) {
                remotePort = port;
                GfxdWanTestBase.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
                this.getLogWriter().info((Object)"Started SITE_A");
            }
            if (createdSites == 2) {
                GfxdWanTestBase.assertTrue((this.serverVMs.size() == 8 ? 1 : 0) != 0);
                this.getLogWriter().info((Object)"Started SITE_B");
            }
            if (createdSites == 3) {
                GfxdWanTestBase.assertTrue((this.serverVMs.size() == 12 ? 1 : 0) != 0);
                this.getLogWriter().info((Object)"Started SITE_C");
            }
            if (createdSites != 4) continue;
            GfxdWanTestBase.assertTrue((this.serverVMs.size() == 16 ? 1 : 0) != 0);
            this.getLogWriter().info((Object)"Started SITE_D");
        }
    }

    public void stopSites() throws Exception {
    }

    public static Integer createLocator(int dsId) throws Exception {
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.put("sys-disk-dir", "" + dsId);
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        FabricLocator locator = FabricServiceManager.getFabricLocatorInstance();
        InetAddress localHost = InetAddress.getLocalHost();
        locator.start(localHost.getHostAddress(), port, props);
        return port;
    }

    public static Integer createRemoteLocator(int dsId, int remoteLocPort) throws Exception {
        int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.put("sys-disk-dir", "" + dsId);
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "" + dsId);
        props.setProperty("locators", "localhost[" + port + "]");
        props.setProperty("start-locator", "localhost[" + port + "],server=true,peer=true,hostname-for-clients=localhost");
        props.setProperty("remote-locators", "localhost[" + remoteLocPort + "]");
        FabricLocator locator = FabricServiceManager.getFabricLocatorInstance();
        InetAddress localHost = InetAddress.getLocalHost();
        locator.start(localHost.getHostAddress(), port, props);
        return port;
    }

    protected String getSQLSuffixClause() {
        return "";
    }
}

