/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.wan;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.versions.ConcurrentCacheModificationException;
import com.gemstone.gemfire.internal.cache.wan.BatchException70;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.impl.GatewayConflictHelper;
import com.pivotal.gemfirexd.callbacks.impl.GatewayConflictResolver;
import com.pivotal.gemfirexd.callbacks.impl.GatewayConflictResolverWrapper;
import com.pivotal.gemfirexd.callbacks.impl.GatewayEvent;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.wan.GfxdWanTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class GfxdWanConsistencyDUnit
extends GfxdWanTestBase {
    public GfxdWanConsistencyDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void vmTearDown() throws Exception {
        super.vmTearDown();
    }

    public void testResolver_Parallel_ActivePassive_Update() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)enable concurrency checks";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)enable concurrency checks GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)enable concurrency checks" + this.getSQLSuffixClause());
        this.executeSql("B", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714', 'city1')");
        this.executeSql("A", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714', 'city1')");
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = "CREATE gatewaysender MySender (remotedsid 2 isparallel true ) server groups (sg1)";
        this.executeSql("A", "CREATE gatewaysender MySender (remotedsid 2 isparallel true ) server groups (sg1)");
        this.executeSql("B", "CALL SYS.ATTACH_GATEWAY_CONFLICT_RESOLVER('com.pivotal.gemfirexd.wan.GfxdWanConsistencyDUnit$CustomResolver','2,customDesc,false,false')");
        this.executeSql("A", "update EMP.PARTITIONED_TABLE set city = 'city2' where id = 1");
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION, CITY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id12", true, false);
        this.executeSql("B", "CALL SYS.REMOVE_GATEWAY_CONFLICT_RESOLVER()");
        this.executeSql("A", "CALL SYS.STOP_GATEWAYSENDER('MySender')");
    }

    public void testGatewayEventAPI() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)enable concurrency checks";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)enable concurrency checks GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)enable concurrency checks" + this.getSQLSuffixClause());
        this.executeSql("B", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714', 'city1')");
        this.executeSql("A", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714', 'city1')");
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = "CREATE gatewaysender MySender (remotedsid 2 isparallel true ) server groups (sg1)";
        this.executeSql("A", "CREATE gatewaysender MySender (remotedsid 2 isparallel true ) server groups (sg1)");
        this.executeSql("B", "CALL SYS.ATTACH_GATEWAY_CONFLICT_RESOLVER('com.pivotal.gemfirexd.wan.GfxdWanConsistencyDUnit$CustomResolver_API','')");
        this.executeSql("A", "update EMP.PARTITIONED_TABLE set city = 'city2' where id = 1");
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION, CITY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id14", true, false);
        this.executeSql("B", "CALL SYS.REMOVE_GATEWAY_CONFLICT_RESOLVER()");
        this.executeSql("A", "CALL SYS.STOP_GATEWAYSENDER('MySender')");
    }

    public void testResolver_Parallel_ActivePassive_Insert() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)enable concurrency checks";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)enable concurrency checks GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)enable concurrency checks" + this.getSQLSuffixClause());
        this.executeSql("B", "CALL SYS.ATTACH_GATEWAY_CONFLICT_RESOLVER('com.pivotal.gemfirexd.wan.GfxdWanConsistencyDUnit$CustomResolver','2,customDesc,false,false')");
        this.executeSql("B", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714')");
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = "CREATE gatewaysender MySender (remotedsid 2 isparallel true ) server groups (sg1)";
        this.executeSql("A", "CREATE gatewaysender MySender (remotedsid 2 isparallel true ) server groups (sg1)");
        this.executeSql("A", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714')");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, -1)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id11", true, false);
        this.executeSql("B", "CALL SYS.REMOVE_GATEWAY_CONFLICT_RESOLVER()");
        this.executeSql("A", "CALL SYS.STOP_GATEWAYSENDER('MySender')");
    }

    public void testSetGatewayFKChecks() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createParentTable = "create table trade.parent_customers (cid int not null, cust_name varchar(100), addr varchar(100), primary key (cid)) partition by column(cid) redundancy 1server groups (sgSender) enable concurrency checks";
        this.executeSql("A", "create table trade.parent_customers (cid int not null, cust_name varchar(100), addr varchar(100), primary key (cid)) partition by column(cid) redundancy 1server groups (sgSender) enable concurrency checks GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table trade.parent_customers (cid int not null, cust_name varchar(100), addr varchar(100), primary key (cid)) partition by column(cid) redundancy 1server groups (sgSender) enable concurrency checks" + this.getSQLSuffixClause());
        String createChildTable = "create table trade.customers_status(id int not null, cust_id int not null, status varchar(100) not null, primary key (id),constraint cust_fk foreign key (cust_id) references trade.parent_customers (cid) on delete restrict) partition by column(id) redundancy 1 server groups (sgSender) enable concurrency checks";
        this.executeSql("A", "create table trade.customers_status(id int not null, cust_id int not null, status varchar(100) not null, primary key (id),constraint cust_fk foreign key (cust_id) references trade.parent_customers (cid) on delete restrict) partition by column(id) redundancy 1 server groups (sgSender) enable concurrency checks GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table trade.customers_status(id int not null, cust_id int not null, status varchar(100) not null, primary key (id),constraint cust_fk foreign key (cust_id) references trade.parent_customers (cid) on delete restrict) partition by column(id) redundancy 1 server groups (sgSender) enable concurrency checks" + this.getSQLSuffixClause());
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        this.executeSql("B", "CALL SYS.SET_GATEWAY_FK_CHECKS('FALSE')");
        String createGWS = "CREATE gatewaysender MySender (remotedsid 2 isparallel true ) server groups (sg1)";
        this.executeSql("A", "CREATE gatewaysender MySender (remotedsid 2 isparallel true ) server groups (sg1)");
        this.addExpectedException(new int[0], new int[]{5, 6, 7, 8}, new Object[]{SQLException.class, EntryExistsException.class, BatchException70.class});
        this.executeSql("A", "insert into trade.parent_customers  values (1, 'custName1', 'addr1')");
        this.executeSql("A", "insert into trade.parent_customers  values (2, 'custName1', 'addr1')");
        this.executeSql("A", "insert into trade.customers_status  values (100, 1, 'active')");
        this.executeSql("A", "insert into trade.customers_status  values (200, 2, 'inactive')");
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select STATUS from trade.customers_status where id = 100", goldenFile, "id13", true, false);
        this.executeSql("A", "CALL SYS.STOP_GATEWAYSENDER('MySender')");
    }

    public void installCustomResolverDirectly(String site, int changedColumnIndex, String changedColumnValue, boolean skipInsert, boolean skipUpdate) throws Exception {
        int i;
        if (site.equals("A")) {
            for (i = 1; i <= 4; ++i) {
                this.serverExecute(i, GfxdWanConsistencyDUnit.setCustomResolver(changedColumnIndex, changedColumnValue, skipInsert, skipUpdate));
            }
        }
        if (site.equals("B")) {
            for (i = 5; i <= 8; ++i) {
                this.serverExecute(i, GfxdWanConsistencyDUnit.setCustomResolver(changedColumnIndex, changedColumnValue, skipInsert, skipUpdate));
            }
        }
    }

    public static Runnable setCustomResolver(int columnIndex, String columnValue, boolean skipInsertFlag, boolean skipUpdateFlag) {
        final int index = columnIndex;
        final String value = columnValue;
        final boolean skipInsert = skipInsertFlag;
        final boolean skipUpdate = skipUpdateFlag;
        SerializableRunnable senderConf = new SerializableRunnable("Set Custom Resolver"){
            private static final long serialVersionUID = 1L;

            public void run() throws CacheException {
                GatewayConflictResolver resolver = new GatewayConflictResolver(){

                    public void onEvent(GatewayEvent event, GatewayConflictHelper helper) {
                        LogWriterI18n logger = Misc.getGemFireCache().getLoggerI18n();
                        try {
                            GatewayEvent.GatewayEventType eventType = event.getType();
                            if (eventType == null) {
                                throw new Exception("Event type is null");
                            }
                            if (eventType.equals((Object)GatewayEvent.GatewayEventType.INSERT) && skipInsert) {
                                helper.disallowEvent();
                                return;
                            }
                            if (event.getType().equals((Object)GatewayEvent.GatewayEventType.UPDATE) && skipUpdate) {
                                helper.disallowEvent();
                                return;
                            }
                            helper.setColumnValue(index, (Object)value);
                        }
                        catch (Exception e) {
                            helper.disallowEvent();
                            logger.fine("Exception setting column" + e.getMessage(), (Throwable)e);
                        }
                    }

                    public void init(String params) {
                    }
                };
                GatewayConflictResolverWrapper resolverWrapper = new GatewayConflictResolverWrapper(resolver);
                GemFireCacheImpl.getExisting().setGatewayConflictResolver((com.gemstone.gemfire.cache.util.GatewayConflictResolver)resolverWrapper);
            }
        };
        return senderConf;
    }

    public void verifyActivePassive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksDisabled(boolean isParallel, boolean randomOps) throws Exception {
        this.logConfig(isParallel, false, false, true, true);
        this.startSites(2);
        if (randomOps) {
            this.addExpectedException(new String[]{"A", "B"}, new Object[]{EntryNotFoundException.class, EntryExistsException.class});
            this.addExpectedException(new String[]{"A", "B"}, new String[]{"Foreign key constraint violation"});
        } else {
            this.addExpectedException(new String[]{"A", "B"}, new Object[0]);
        }
        String createParent = "create table emp.parent_table (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        String createChild = "create table emp.child_table(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,constraint parent_fk foreign key (parent_ref) references emp.parent_table (id) on delete restrict,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1)";
        this.executeSql("A", "create table emp.parent_table (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("A", "create table emp.child_table(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,constraint parent_fk foreign key (parent_ref) references emp.parent_table (id) on delete restrict,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table emp.parent_table (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table emp.child_table(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,constraint parent_fk foreign key (parent_ref) references emp.parent_table (id) on delete restrict,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1)" + this.getSQLSuffixClause());
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        this.executeSql("A", "create gatewaysender MySender (remotedsid 2 isparallel " + (isParallel ? "true" : "false") + " ) server groups (sg1)");
        this.executeSql("B", "CALL SYS.SET_GATEWAY_FK_CHECKS('FALSE')");
        if (randomOps) {
            this.executeOnSite("A", this.doRandomDMLOpsOnParentChildTables());
        } else {
            this.executeOnSite("A", this.doInsertsIntoParentChildTables());
        }
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, -1)");
        GfxdWanConsistencyDUnit.assertTrue((boolean)this.compareSites("A", "B", "select * from emp.parent_table"));
        GfxdWanConsistencyDUnit.assertTrue((boolean)this.compareSites("A", "B", "select * from emp.child_table"));
        this.executeSql("A", "CALL SYS.STOP_GATEWAYSENDER('MYSENDER')");
    }

    public void verifyActiveActive_TablesWithoutFKs_ConcurrencyChecksEnabled(boolean isParallel) throws Exception {
        this.logConfig(isParallel, true, true, false, false);
        this.startTwoSites();
        this.addExpectedException(new String[]{"A", "B"}, new Object[]{ConcurrentCacheModificationException.class, EntryExistsException.class, FunctionExecutionException.class});
        String createTableOne = "create table emp.table_one (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        String createTableTwo = "create table emp.table_two(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1)";
        String enableConcurrencyChecks = " enable concurrency checks";
        this.executeSql("A", "create table emp.table_one (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (siteASender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("A", "create table emp.table_two(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1) GatewaySender (siteASender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("B", "create table emp.table_one (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (siteBSender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("B", "create table emp.table_two(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1) GatewaySender (siteBSender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("B", "create gatewayreceiver siteBReceiver() server groups(sgSender)");
        this.executeSql("A", "create gatewaysender siteASender (remotedsid 2 isparallel " + (isParallel ? "true" : "false ") + ") server groups (sg1)");
        this.executeSql("A", "create gatewayreceiver siteAReceiver() server groups(sgSender)");
        this.executeSql("B", "create gatewaysender siteBSender (remotedsid 1 isparallel " + (isParallel ? "true " : "false ") + ") server groups (sg1)");
        this.executeOnSitesAsync(new String[]{"A", "B"}, this.doInsertsIntoUnrelatedTables());
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SITEASENDER', 0, -1)");
        this.executeSql("B", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SITEBSENDER', 0, -1)");
        GfxdWanConsistencyDUnit.assertTrue((boolean)this.compareSites("A", "B", "select * from emp.table_one"));
        GfxdWanConsistencyDUnit.assertTrue((boolean)this.compareSites("A", "B", "select * from emp.table_two"));
        this.executeSql("A", "CALL SYS.STOP_GATEWAYSENDER('SITEASENDER')");
        this.executeSql("B", "CALL SYS.STOP_GATEWAYSENDER('SITEBSENDER')");
    }

    public void verifyActiveActive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksEnabled(boolean isParallel, boolean randomOps) throws Exception {
        this.logConfig(isParallel, true, true, true, true);
        this.startTwoSites();
        if (randomOps) {
            this.addExpectedException(new String[]{"A", "B"}, new Object[]{EntryNotFoundException.class, EntryExistsException.class, ConcurrentCacheModificationException.class, FunctionExecutionException.class});
            this.addExpectedException(new String[]{"A", "B"}, new String[]{"Foreign key constraint violation", "The statement was aborted because it would have caused a duplicate key value", "Failed to create or update entry"});
        } else {
            this.addExpectedException(new String[]{"A", "B"}, new Object[]{ConcurrentCacheModificationException.class, EntryExistsException.class, FunctionExecutionException.class});
        }
        String createParent = "create table emp.parent_table (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        String createChild = "create table emp.child_table(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,constraint parent_fk foreign key (parent_ref) references emp.parent_table (id) on delete restrict,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1)";
        String enableConcurrencyChecks = " enable concurrency checks";
        this.executeSql("A", "create table emp.parent_table (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (siteASender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("A", "create table emp.child_table(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,constraint parent_fk foreign key (parent_ref) references emp.parent_table (id) on delete restrict,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1) GatewaySender (siteASender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("B", "create table emp.parent_table (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (siteBSender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("B", "create table emp.child_table(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,constraint parent_fk foreign key (parent_ref) references emp.parent_table (id) on delete restrict,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1) GatewaySender (siteBSender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("B", "create gatewayreceiver siteBReceiver() server groups(sgSender)");
        this.executeSql("A", "create gatewaysender siteASender (remotedsid 2 isparallel " + (isParallel ? "true" : "false ") + ") server groups (sg1)");
        this.executeSql("A", "create gatewayreceiver siteAReceiver() server groups(sgSender)");
        this.executeSql("B", "create gatewaysender siteBSender (remotedsid 1 isparallel " + (isParallel ? "true " : "false ") + ") server groups (sg1)");
        this.executeSql("A", "CALL SYS.SET_GATEWAY_FK_CHECKS('FALSE')");
        this.executeSql("B", "CALL SYS.SET_GATEWAY_FK_CHECKS('FALSE')");
        if (randomOps) {
            this.executeOnSitesAsync(new String[]{"A", "B"}, this.doRandomDMLOpsOnParentChildTables());
        } else {
            this.executeOnSitesAsync(new String[]{"A", "B"}, this.doInsertsIntoParentChildTables());
        }
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SITEASENDER', 0, -1)");
        this.executeSql("B", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SITEBSENDER', 0, -1)");
        GfxdWanConsistencyDUnit.assertTrue((boolean)this.compareSites("A", "B", "select * from emp.parent_table"));
        GfxdWanConsistencyDUnit.assertTrue((boolean)this.compareSites("A", "B", "select * from emp.child_table"));
        this.executeSql("A", "CALL SYS.STOP_GATEWAYSENDER('SITEASENDER')");
        this.executeSql("B", "CALL SYS.STOP_GATEWAYSENDER('SITEBSENDER')");
    }

    public Runnable doInsertsIntoParentChildTables() {
        SerializableRunnable runnable = new SerializableRunnable("doInsertsIntoParentChildTables"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    for (int i = 0; i < 50; ++i) {
                        st.execute("insert into emp.parent_table values (" + i + ",'Desc" + i + "','Addr" + i + "','city" + i + "')");
                        st.execute("insert into emp.child_table values(" + i * 100 + "," + i + ",'childDesc" + i + "','childAddr" + i + "')");
                    }
                    st.close();
                    conn.close();
                }
                catch (Exception e) {
                    GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("doInsertsIntoParentChildTables:" + e.getMessage()));
                }
            }
        };
        return runnable;
    }

    public Runnable doDeletes() {
        SerializableRunnable runnable = new SerializableRunnable("doDeletes"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    st.execute("delete from emp.child_table where parent_ref = 2");
                    st.execute("delete from emp.child_table where id = 300");
                    st.close();
                    conn.close();
                }
                catch (Exception e) {
                    GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("doInsertsIntoParentChildTables:" + e.getMessage()));
                }
            }
        };
        return runnable;
    }

    public Runnable doRandomDMLOpsOnParentChildTables() {
        SerializableRunnable runnable = new SerializableRunnable("doRandomDMLOpsOnParentChildTables"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    Random randomOp = new Random();
                    Random randomUpdate = new Random();
                    int i = 0;
                    for (int opCount = 0; opCount < 100; ++opCount) {
                        int next = randomOp.nextInt();
                        int op = next % 3;
                        if (op == 0) {
                            String insertP = "insert into emp.parent_table values (" + i + ",'Desc" + i + "','Addr" + i + "','city" + i + "')";
                            GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("RandomDML:" + insertP));
                            st.execute(insertP);
                            String insertC = "insert into emp.child_table values(" + i * 100 + "," + i + ",'childDesc" + i + "','childAddr" + i + "')";
                            GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("RandomDML:" + insertC));
                            st.execute(insertC);
                            ++i;
                            continue;
                        }
                        if (op == 1) {
                            if (i < 10) continue;
                            int nextUpdateOp = randomUpdate.nextInt() % 2;
                            String update = null;
                            update = nextUpdateOp == 0 ? "update emp.parent_table set city = 'changedCity" + (i - 1) + "' where id = " + (i - 1) : "update emp.child_table set parent_ref = " + (i - 2) + " where id = " + (i - 1) * 100;
                            GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("RandomDML:" + update));
                            st.execute(update);
                            continue;
                        }
                        if (i < 10) continue;
                        String deleteC = "delete from emp.child_table where parent_ref = " + (i - 1);
                        GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("RandomDML:" + deleteC));
                        st.execute(deleteC);
                        String deleteP = "delete from emp.parent_table where id = " + (i - 1);
                        GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("RandomDML:" + deleteP));
                        st.execute(deleteP);
                    }
                    st.close();
                    conn.close();
                }
                catch (Exception e) {
                    GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("doRandomDMLOpsOnParentChildTables:" + e.getMessage()));
                }
            }
        };
        return runnable;
    }

    public Runnable doUpdate() {
        SerializableRunnable runnable = new SerializableRunnable("doUpdate"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    st.execute("update emp.table_one set city = 'newcity' where id = 1");
                    st.close();
                    conn.close();
                }
                catch (Exception e) {
                    GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("doUpdate:" + e.getMessage()));
                }
            }
        };
        return runnable;
    }

    public Runnable doDelete() {
        SerializableRunnable runnable = new SerializableRunnable("doUpdate"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    st.execute("delete from emp.table_one where id = 1");
                    st.close();
                    conn.close();
                }
                catch (Exception e) {
                    GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("doUpdate:" + e.getMessage()));
                }
            }
        };
        return runnable;
    }

    public Runnable doInserts() {
        SerializableRunnable runnable = new SerializableRunnable("doInsertsIntoUnrelatedTables"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    for (int i = 0; i < 2; ++i) {
                        st.execute("insert into emp.table_one values (" + i + ",'oneDesc" + i + "','oneAddr" + i + "','city" + i + "')");
                        st.execute("insert into emp.table_two values(" + i * 100 + "," + i + ",'twoDesc" + i + "','twoAddr" + i + "')");
                    }
                    st.close();
                    conn.close();
                }
                catch (Exception e) {
                    GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("doInsertsIntoUnrelatedTables:" + e.getMessage()));
                }
            }
        };
        return runnable;
    }

    public Runnable doInsertsIntoUnrelatedTables() {
        SerializableRunnable runnable = new SerializableRunnable("doInsertsIntoUnrelatedTables"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    for (int i = 0; i < 50; ++i) {
                        st.execute("insert into emp.table_one values (" + i + ",'oneDesc" + i + "','oneAddr" + i + "','city" + i + "')");
                        st.execute("insert into emp.table_two values(" + i * 100 + "," + i + ",'twoDesc" + i + "','twoAddr" + i + "')");
                    }
                    st.close();
                    conn.close();
                }
                catch (Exception e) {
                    GfxdWanConsistencyDUnit.this.getLogWriter().info((Object)("doInsertsIntoUnrelatedTables:" + e.getMessage()));
                }
            }
        };
        return runnable;
    }

    protected void logConfig(boolean isParallel, boolean isActiveActive, boolean concurrencyChecksEnabled, boolean tablesHaveFKs, boolean fkChecksRelaxed) {
        this.getLogWriter().info((Object)("TEST CONFIG:[" + (isParallel ? "PARALLEL" : "SERIAL") + "-" + (isActiveActive ? "AA" : "AP") + "-" + "concurrency checks" + (concurrencyChecksEnabled ? " enabled" : " disabled") + "-" + (tablesHaveFKs ? "FKs" : "No FKs") + "-" + (fkChecksRelaxed ? "FK relaxed" : "FK checked") + "]"));
    }

    public void testSerial_ActivePassive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksDisabled() throws Exception {
        this.verifyActivePassive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksDisabled(false, false);
    }

    public void testDeleteUpdateConflict() throws Exception {
        boolean isParallel = true;
        this.logConfig(isParallel, true, true, false, false);
        this.startTwoSites();
        this.addExpectedException(new String[]{"A", "B"}, new Object[]{ConcurrentCacheModificationException.class, EntryExistsException.class, EntryNotFoundException.class, FunctionExecutionException.class});
        String createTableOne = "create table emp.table_one (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        String createTableTwo = "create table emp.table_two(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1)";
        String enableConcurrencyChecks = " enable concurrency checks";
        this.executeSql("A", "create table emp.table_one (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (siteASender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("A", "create table emp.table_two(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1) GatewaySender (siteASender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("B", "create table emp.table_one (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, CITY varchar(200) not null,primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (siteBSender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("B", "create table emp.table_two(ID int, PARENT_REF int,CHILD_DESCRIPTION varchar(1024) not null,CHILD_ADDRESS varchar(200) not null,primary key(ID) ) partition by column(CHILD_ADDRESS) redundancy 1 server groups(sg1) GatewaySender (siteBSender)" + enableConcurrencyChecks + this.getSQLSuffixClause());
        this.executeSql("B", "create gatewayreceiver siteBReceiver() server groups(sgSender)");
        this.executeSql("A", "create gatewaysender siteASender (remotedsid 2 isparallel " + (isParallel ? "true" : "false ") + ") server groups (sg1)");
        this.executeSql("A", "create gatewayreceiver siteAReceiver() server groups(sgSender)");
        this.executeSql("B", "create gatewaysender siteBSender (remotedsid 1 isparallel " + (isParallel ? "true " : "false ") + ") server groups (sg1)");
        this.executeOnSitesAsync(new String[]{"A", "B"}, this.doInserts());
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SITEASENDER', 0, -1)");
        this.executeSql("B", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SITEBSENDER', 0, -1)");
        this.executeOnSite("A", this.doDelete());
        this.executeOnSite("B", this.doUpdate());
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SITEASENDER', 0, -1)");
        this.executeSql("B", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('SITEBSENDER', 0, -1)");
        GfxdWanConsistencyDUnit.assertTrue((boolean)this.compareSites("A", "B", "select * from emp.table_one"));
        GfxdWanConsistencyDUnit.assertTrue((boolean)this.compareSites("A", "B", "select * from emp.table_two"));
        this.executeSql("A", "CALL SYS.STOP_GATEWAYSENDER('SITEASENDER')");
        this.executeSql("B", "CALL SYS.STOP_GATEWAYSENDER('SITEBSENDER')");
    }

    public void testRandomOps_Serial_ActivePassive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksDisabled() throws Exception {
        this.verifyActivePassive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksDisabled(false, true);
    }

    public void testSerial_ActiveActive_TablesWithoutFKs_ConcurrencyChecksEnabled() throws Exception {
        this.verifyActiveActive_TablesWithoutFKs_ConcurrencyChecksEnabled(false);
    }

    public void testSerial_ActiveActive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksEnabled() throws Exception {
        this.verifyActiveActive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksEnabled(false, false);
    }

    public void DISABLED_Bug_48786_testRandomOps_Serial_ActiveActive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksEnabled() throws Exception {
        this.verifyActiveActive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksEnabled(false, true);
    }

    public void testParallel_ActivePassive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksDisabled() throws Exception {
        this.verifyActivePassive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksDisabled(true, false);
    }

    public void testRandomOps_Parallel_ActivePassive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksDisabled() throws Exception {
        this.verifyActivePassive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksDisabled(true, true);
    }

    public void testParallel_ActiveActive_TablesWithoutFKs_ConcurrencyChecksEnabled() throws Exception {
        this.verifyActiveActive_TablesWithoutFKs_ConcurrencyChecksEnabled(true);
    }

    public void testParallel_ActiveActive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksEnabled() throws Exception {
        this.verifyActiveActive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksEnabled(true, false);
    }

    public void DISABLED_Bug_48786_testRandomOps_Parallel_ActiveActive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksEnabled() throws Exception {
        this.verifyActiveActive_TablesWithFKs_FKChecksRelaxed_ConcurrencyChecksEnabled(true, true);
    }

    public static class CustomResolver_API
    implements GatewayConflictResolver {
        public void init(String params) {
        }

        public void onEvent(GatewayEvent event, GatewayConflictHelper helper) {
            LogWriterI18n logger = Misc.getGemFireCache().getLoggerI18n();
            try {
                GatewayEvent.GatewayEventType eventType = event.getType();
                logger.fine("GatewayEvent:" + event);
                ResultSet oldRow = event.getOldRow();
                logger.fine("OLD ROW:");
                ResultSetMetaData metadata = oldRow.getMetaData();
                int numCols = metadata.getColumnCount();
                logger.fine("ColCount=" + numCols);
                TestCase.assertTrue((boolean)metadata.getColumnName(1).equalsIgnoreCase("ID"));
                TestCase.assertTrue((boolean)metadata.getColumnName(2).equalsIgnoreCase("DESCRIPTION"));
                TestCase.assertTrue((boolean)metadata.getColumnName(3).equalsIgnoreCase("ADDRESS"));
                TestCase.assertTrue((boolean)metadata.getColumnName(4).equalsIgnoreCase("CITY"));
                TestCase.assertTrue((boolean)metadata.getColumnTypeName(1).equalsIgnoreCase("INTEGER"));
                TestCase.assertTrue((boolean)metadata.getColumnTypeName(2).equalsIgnoreCase("VARCHAR"));
                TestCase.assertTrue((boolean)metadata.getColumnTypeName(3).equalsIgnoreCase("VARCHAR"));
                TestCase.assertTrue((boolean)metadata.getColumnTypeName(4).equalsIgnoreCase("VARCHAR"));
                TestCase.assertEquals((int)1, (int)oldRow.getInt(1));
                TestCase.assertEquals((String)"First", (String)oldRow.getString(2));
                TestCase.assertEquals((String)"A714", (String)oldRow.getString(3));
                TestCase.assertEquals((String)"city1", (String)oldRow.getString(4));
                int[] modCols = event.getModifiedColumns();
                TestCase.assertTrue((modCols != null ? 1 : 0) != 0);
                TestCase.assertTrue((modCols.length == 1 ? 1 : 0) != 0);
                TestCase.assertEquals((int)4, (int)modCols[0]);
                ResultSet newRow = event.getNewRow();
                logger.fine("NEW ROW:");
                ResultSetMetaData m = newRow.getMetaData();
                numCols = m.getColumnCount();
                logger.fine("ColCount=" + numCols);
                TestCase.assertEquals((String)"city2", (String)newRow.getString(1));
            }
            catch (Exception e) {
                helper.disallowEvent();
                logger.fine("Exception setting column" + e.getMessage(), (Throwable)e);
                Assert.fail((String)("Exception setting column" + e.getMessage()));
            }
        }
    }

    public static class CustomResolver
    implements GatewayConflictResolver {
        private int index;
        private String value;
        private boolean skipInsert;
        private boolean skipUpdate;

        public void init(String params) {
            if (params != null) {
                String[] p = params.split(",");
                TestCase.assertEquals((int)4, (int)p.length);
                this.index = new Integer(p[0]);
                this.value = p[1];
                this.skipInsert = new Boolean(p[2]);
                this.skipUpdate = new Boolean(p[3]);
            }
        }

        public void onEvent(GatewayEvent event, GatewayConflictHelper helper) {
            LogWriterI18n logger = Misc.getGemFireCache().getLoggerI18n();
            try {
                GatewayEvent.GatewayEventType eventType = event.getType();
                if (eventType == null) {
                    throw new Exception("Event type is null");
                }
                if (eventType.equals((Object)GatewayEvent.GatewayEventType.INSERT) && this.skipInsert) {
                    helper.disallowEvent();
                    return;
                }
                if (event.getType().equals((Object)GatewayEvent.GatewayEventType.UPDATE) && this.skipUpdate) {
                    helper.disallowEvent();
                    return;
                }
                helper.setColumnValue(this.index, (Object)this.value);
            }
            catch (Exception e) {
                helper.disallowEvent();
                logger.fine("Exception setting column" + e.getMessage(), (Throwable)e);
                Assert.fail((String)("Exception setting column" + e.getMessage()));
            }
        }
    }
}

