/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.wan;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import com.pivotal.gemfirexd.wan.GfxdWanTestBase;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;

public abstract class GfxdWanCommonTestBase
extends GfxdWanTestBase {
    public GfxdWanCommonTestBase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void vmTearDown() throws Exception {
        super.vmTearDown();
    }

    public void testBasicInsert() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.executeSql("A", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714')");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
    }

    protected abstract String getCreateGatewayDML();

    public void testBasicPrepStmt() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal', primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal', primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal', primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.serverExecute(4, GfxdWanCommonTestBase.prepInsert());
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
    }

    public void testBasicUpdateDelete() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.executeSql("A", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714')");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.executeSql("A", "Update EMP.PARTITIONED_TABLE set DESCRIPTION = 'Second' where ID = 1");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id2", true, false);
        this.executeSql("A", "Delete from  EMP.PARTITIONED_TABLE where ID = 1");
        this.sqlExecuteVerify("A", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
    }

    public void testNonPKBasedUpdateDelete() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.executeSql("A", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714')");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.executeSql("A", "Update EMP.PARTITIONED_TABLE set DESCRIPTION = 'Second' where ADDRESS = 'A714'");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id2", true, false);
        this.executeSql("A", "Delete from  EMP.PARTITIONED_TABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify("A", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
    }

    public void testBatchInsert() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        this.addExpectedException(new String[]{"A", "B"}, new Object[]{CacheClosedException.class});
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal',primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal',primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal',primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.serverExecute(4, GfxdWanCommonTestBase.batchInsert());
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
    }

    public void testBatchUpdate() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal', primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal', primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal', primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.serverExecute(4, GfxdWanCommonTestBase.batchInsert());
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.serverExecute(4, GfxdWanCommonTestBase.batchUpdate());
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id10", true, false);
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id10", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id10", true, false);
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id10", true, false);
    }

    public void testBatchDelete() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        this.addExpectedException(new String[]{"A", "B"}, new Object[]{ForceReattemptException.class});
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal', primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal', primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal', primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.serverExecute(4, GfxdWanCommonTestBase.batchInsert());
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.serverExecute(4, GfxdWanCommonTestBase.batchUpdate());
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id10", true, false);
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id10", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id10", true, false);
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id10", true, false);
        this.serverExecute(4, GfxdWanCommonTestBase.batchDelete());
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "empty", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "empty", true, false);
    }

    public void testBULKUpdate() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        this.addExpectedException(new String[]{"A", "B"}, new Object[]{ForceReattemptException.class});
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.serverExecute(4, GfxdWanCommonTestBase.batchInsertForBULK());
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.executeSql("A", "Update EMP.PARTITIONED_TABLE set DESCRIPTION = 'Second' where ADDRESS = 'A714'");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id2", true, false);
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.executeSql("A", "Update EMP.PARTITIONED_TABLE set COMPANY = 'Pivotal' where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id10", true, false);
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id10", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id10", true, false);
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id10", true, false);
    }

    public void testBULKDelete() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.serverExecute(4, GfxdWanCommonTestBase.batchInsertForBULK());
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.executeSql("A", "Update EMP.PARTITIONED_TABLE set DESCRIPTION = 'Second' where ADDRESS = 'A714'");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id2", true, false);
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.executeSql("A", "Delete from EMP.PARTITIONED_TABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "empty", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "empty", true, false);
    }

    public void testTxOperations() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.serverExecute(4, GfxdWanCommonTestBase.txInsert());
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id2", true, false);
    }

    public void testTxInsertUpdateDeleteOperations() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024), primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.serverExecute(4, GfxdWanCommonTestBase.txInsert());
        this.serverExecute(4, this.txUpdate());
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id10", true, false);
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id10", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id10", true, false);
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "id10", true, false);
        this.serverExecute(4, this.txDelete());
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "empty", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE WHERE ID = 2", goldenFile, "empty", true, false);
    }

    private Runnable txUpdate() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    conn.setAutoCommit(false);
                    conn.setTransactionIsolation(4);
                    Statement st = conn.createStatement();
                    st.execute("Update EMP.PARTITIONED_TABLE set COMPANY = 'Pivotal' where DESCRIPTION = 'First'");
                    st.execute("Update EMP.PARTITIONED_TABLE set COMPANY = 'Pivotal' where DESCRIPTION = 'Second'");
                    conn.commit();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    private Runnable txDelete() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    conn.setAutoCommit(false);
                    conn.setTransactionIsolation(4);
                    Statement st = conn.createStatement();
                    st.execute("Delete from EMP.PARTITIONED_TABLE where ID = 1");
                    st.execute("Delete from EMP.PARTITIONED_TABLE where ID = 2");
                    conn.commit();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public void testBasicInsertOnNonPKBasedTable() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null )  partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null )  partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null )  partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.executeSql("A", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714')");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
    }

    public void testUpdateOnNonPKBasedTable() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null )  partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null )  partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null )  partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.executeSql("A", "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714')");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id7", true, false);
        this.executeSql("A", "Update EMP.PARTITIONED_TABLE set DESCRIPTION = 'Second' where ID = 1");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "id2", true, false);
        this.executeSql("A", "Delete from  EMP.PARTITIONED_TABLE where ID = 1");
        this.sqlExecuteVerify("A", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE ID = 1", goldenFile, "empty", true, false);
    }

    public void testIdentityColumnGeneratedAlways() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        this.addExpectedException(new String[]{"A", "B"}, new Object[]{PRLocallyDestroyedException.class, ForceReattemptException.class});
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID bigint GENERATED ALWAYS AS IDENTITY, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID bigint GENERATED ALWAYS AS IDENTITY, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID bigint GENERATED ALWAYS AS IDENTITY, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.executeSql("A", "insert into EMP.PARTITIONED_TABLE (DESCRIPTION, ADDRESS)values ('First', 'A714')");
        this.sqlExecuteVerify("A", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE DESCRIPTION = 'First'", goldenFile, "id8", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("A", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE DESCRIPTION = 'First'", goldenFile, "id8", true, false);
        this.executeSql("A", "Update EMP.PARTITIONED_TABLE set DESCRIPTION = 'Second' where ADDRESS = 'A714'");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ADDRESS = 'A714'", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ADDRESS = 'A714'", goldenFile, "id2", true, false);
        this.executeSql("A", "Delete from  EMP.PARTITIONED_TABLE where ADDRESS = 'A714'");
        this.sqlExecuteVerify("A", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE ADDRESS = 'A714'", goldenFile, "empty", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE ADDRESS = 'A714'", goldenFile, "empty", true, false);
    }

    public void testIdentityColumnGeneratedDefault() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        this.addExpectedException(new String[]{"A", "B"}, new Object[]{PRLocallyDestroyedException.class});
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 5,INCREMENT BY 5), DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 5,INCREMENT BY 5), DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID bigint GENERATED BY DEFAULT AS IDENTITY (START WITH 5,INCREMENT BY 5), DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)" + this.getSQLSuffixClause());
        this.executeSql("A", "insert into EMP.PARTITIONED_TABLE (DESCRIPTION, ADDRESS)values ('First', 'A714')");
        this.sqlExecuteVerify("A", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE DESCRIPTION = 'First'", goldenFile, "id8", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("A", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE DESCRIPTION = 'First'", goldenFile, "id8", true, false);
        this.executeSql("A", "Update EMP.PARTITIONED_TABLE set DESCRIPTION = 'Second' where ADDRESS = 'A714'");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ADDRESS = 'A714'", goldenFile, "id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.PARTITIONED_TABLE WHERE ADDRESS = 'A714'", goldenFile, "id2", true, false);
        this.executeSql("A", "Delete from  EMP.PARTITIONED_TABLE where ADDRESS = 'A714'");
        this.sqlExecuteVerify("A", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE ADDRESS = 'A714'", goldenFile, "empty", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select ADDRESS from EMP.PARTITIONED_TABLE WHERE ADDRESS = 'A714'", goldenFile, "empty", true, false);
    }

    public void testDAP_PartitionedRegion() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        this.addExpectedException(new String[]{"A", "B"}, new Object[]{PRLocallyDestroyedException.class});
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal',primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)";
        this.executeSql("A", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal',primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1) GatewaySender (MySender)");
        this.executeSql("B", "create table EMP.PARTITIONED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'Pivotal',primary key (ID)) partition by column(ADDRESS)  redundancy 1 server groups (sg1)");
        this.serverExecute(4, GfxdWanCommonTestBase.wanInsertDAP("EMP.PARTITIONED_TABLE"));
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.PARTITIONED_TABLE", goldenFile, "batch_id2", true, false);
        String wanUpdateDAP = "CREATE PROCEDURE wan_update_dap(IN inParam1 VARCHAR(50)) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA EXTERNAL NAME '" + GfxdWanCommonTestBase.class.getName() + ".wanUpdateDAP'";
        this.serverExecute(4, GfxdWanCommonTestBase.callDAP(wanUpdateDAP, "EMP.PARTITIONED_TABLE"));
        this.sqlExecuteVerify("A", "select COMPANY from EMP.PARTITIONED_TABLE ORDER BY ID", goldenFile, "batch_id8", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select COMPANY from EMP.PARTITIONED_TABLE ORDER BY ID", goldenFile, "batch_id8", true, false);
    }

    public static Runnable wanInsertDAP(final String table) throws SQLException {
        SerializableRunnable wanInsert = new SerializableRunnable("DAP Caller"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    boolean orig = conn.getAutoCommit();
                    conn.setAutoCommit(false);
                    st.addBatch("insert into " + table + " values (1, 'First', 'A', 'VMWARE')");
                    st.addBatch("insert into " + table + " values (2, 'Second', 'B', 'VMWARE')");
                    st.addBatch("insert into " + table + " values (3, 'Third', 'C', 'VMWARE')");
                    st.addBatch("insert into " + table + " values (4, 'Fourth', 'D', 'VMWARE')");
                    st.addBatch("insert into " + table + " values (5, 'Fifth', 'E', 'VMWARE')");
                    st.addBatch("insert into " + table + " values (6, 'Sixth', 'F', 'VMWARE')");
                    st.executeBatch();
                    conn.commit();
                    conn.setAutoCommit(orig);
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return wanInsert;
    }

    public static void wanUpdateDAP(String inParam1, ProcedureExecutionContext context) throws SQLException {
        Connection conn = context.getConnection();
        Statement st = conn.createStatement();
        st.execute("<local> Update " + inParam1 + " set COMPANY = 'PIVOTAL' where ID = 2 OR ID = 4 OR ID = 6");
    }

    public static Runnable callDAP(final String procedure, final String table) {
        SerializableRunnable senderConf = new SerializableRunnable("DAP Caller"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    st.execute(procedure);
                    CallableStatement cs = null;
                    cs = conn.prepareCall("CALL wan_update_dap(?) ON SERVER GROUPS (sg2)");
                    cs.setString(1, table);
                    cs.execute();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable batchInsert() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    st.addBatch("insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714', 'Pivotal')");
                    st.addBatch("insert into EMP.PARTITIONED_TABLE values (2, 'Second', 'J 605', 'Pivotal')");
                    st.executeBatch();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable batchUpdate() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    st.addBatch("Update EMP.PARTITIONED_TABLE set COMPANY = 'Pivotal' where DESCRIPTION = 'First'");
                    st.addBatch("Update EMP.PARTITIONED_TABLE set COMPANY = 'Pivotal' where DESCRIPTION = 'Second'");
                    st.executeBatch();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable batchDelete() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    st.addBatch("Delete from EMP.PARTITIONED_TABLE where ID = 1");
                    st.addBatch("Delete from EMP.PARTITIONED_TABLE where ID = 2");
                    st.executeBatch();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable batchInsertForBULK() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    st.addBatch("insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714', 'Pivotal')");
                    st.addBatch("insert into EMP.PARTITIONED_TABLE values (2, 'Second', 'J 605', 'Zimbra')");
                    st.executeBatch();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable txInsert() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                boolean origAutocommit = false;
                Connection conn = null;
                try {
                    conn = TestUtil.jdbcConn;
                    origAutocommit = conn.getAutoCommit();
                    conn.setAutoCommit(false);
                    conn.setTransactionIsolation(4);
                    Statement st = conn.createStatement();
                    st.execute("insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714', 'Pivotal')");
                    st.execute("insert into EMP.PARTITIONED_TABLE values (2, 'Second', 'J 605', 'Zimbra')");
                    conn.commit();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.setAutoCommit(origAutocommit);
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        };
        return senderConf;
    }

    public static Runnable prepInsert() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    conn.setAutoCommit(false);
                    conn.setTransactionIsolation(2);
                    PreparedStatement prep = conn.prepareStatement("insert into EMP.PARTITIONED_TABLE (ID, DESCRIPTION, ADDRESS, COMPANY) values (?, ?, ?, ?)");
                    prep.setInt(1, 1);
                    prep.setString(2, "First");
                    prep.setString(3, "A714");
                    prep.setString(4, "Pivotal");
                    prep.addBatch();
                    prep.setInt(1, 2);
                    prep.setString(2, "Second");
                    prep.setString(3, "J 605");
                    prep.setString(4, "Zimbra");
                    prep.addBatch();
                    prep.executeBatch();
                    conn.commit();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    private static SerializableRunnable getExecutorToWaitForQueuesToDrain(final String senderId, final int regionSize) {
        SerializableRunnable waitForQueueToDrain = new SerializableRunnable("waitForQueueToDrain"){

            public void run() throws CacheException {
                AbstractGatewaySenderEventProcessor processor;
                Set senders = Misc.getGemFireCache().getAllGatewaySenders();
                Misc.getGemFireCache().getLogger().fine("Inside waitForQueueToDrain for sender " + senderId + " all senders in cache are " + senders);
                ParallelGatewaySenderImpl sender = null;
                for (GatewaySender s : senders) {
                    if (!s.getId().equals(senderId)) continue;
                    sender = (ParallelGatewaySenderImpl)s;
                    break;
                }
                if ((processor = sender.getEventProcessor()) == null) {
                    return;
                }
                final Region region = processor.getQueue().getRegion();
                DistributedTestBase.WaitCriterion wc = new DistributedTestBase.WaitCriterion(){

                    public boolean done() {
                        if (region.keySet().size() == regionSize) {
                            Misc.getGemFireCache().getLogger().fine("Inside waitForQueueToDrain for sender " + senderId + " queue is drained and empty ");
                            return true;
                        }
                        Misc.getGemFireCache().getLogger().fine("Inside waitForQueueToDrain for sender " + senderId + " queue is not yet drained " + region.keySet().size());
                        return false;
                    }

                    public String description() {
                        return "Expected queue entries: " + regionSize + " but actual entries: " + region.keySet().size();
                    }
                };
                DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)60000L, (long)500L, (boolean)true);
            }
        };
        return waitForQueueToDrain;
    }
}

