/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.wan;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.dbsync.DBSynchronizerTestBase;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.wan.GfxdWanTestBase;
import io.snappydata.test.dunit.AvailablePortHelper;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Element;

public class GfxdSerialWanDUnit
extends GfxdWanTestBase {
    private static volatile Bug42930Tester bugtester;

    public GfxdSerialWanDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testDispatchForInsertsOnAllBuckets() throws Exception {
        this.startTwoSites();
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        this.executeSql("A", "create gatewaysender MySender (remotedsid 2 isparallel false ) server groups (sgSender)");
        String createTable = "create table testtable (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, ID1 int,primary key (ID))  partition by primary key server groups (sg1)";
        this.executeSql("A", "create table testtable (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, ID1 int,primary key (ID))  partition by primary key server groups (sg1) GatewaySender (MySender) " + this.getSQLSuffixClause());
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        DBSynchronizerTestBase.startNetworkServer(netPort);
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + netPort + "/newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        derbyStmt = derbyConn.createStatement();
        DBSynchronizerTestBase.createDerbyValidationArtefacts(netPort);
        Runnable createListener = DBSynchronizerTestBase.getExecutorForWBCLConfiguration("SG1", "TESTDBSYNC", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
        this.executeOnSite("B", createListener);
        this.executeSql("B", "create table testtable (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, ID1 int,primary key (ID))  partition by primary key server groups (sg1)AsyncEventListener (TESTDBSYNC) " + this.getSQLSuffixClause());
        Runnable startListener = DBSynchronizerTestBase.startAsyncEventListener("TESTDBSYNC");
        this.executeOnSite("B", startListener);
        for (int i = 1; i <= 113; ++i) {
            this.executeSql("A", "insert into testtable values(" + i + ", 'desc" + i + "', 'addr1', " + i + ")");
        }
        this.executeSql("A", "update testtable set description = 'modified_desc1' where id = 1");
        this.executeSql("A", "update testtable set description = 'modified_desc1' where description = 'desc1'");
        this.executeSql("A", "update testtable set description = 'modified_desc2' where description = 'modified_desc1'");
        this.executeSql("A", "delete from testtable where id = 1");
        DBSynchronizerTestBase.blockForValidation(netPort);
        Runnable stopListener = DBSynchronizerTestBase.stopAsyncEventListener("TESTDBSYNC");
        this.executeOnSite("B", stopListener);
        Thread.sleep(5000L);
        int vmNum = this.getSiteAccessorServerNum("B");
        int networkPort = this.startNetworkServer(vmNum, "SG1", null);
        Connection clientConn = TestUtil.getNetConnection(networkPort, null, null);
        Statement stmt = clientConn.createStatement();
        ResultSet derbyRS = derbyStmt.executeQuery("select * from testtable");
        ResultSet gfxdRS = stmt.executeQuery("select * from testtable");
        Element resultElement = Misc.resultSetToXMLElement((ResultSet)gfxdRS, (boolean)true, (boolean)true);
        Element expectedElement = Misc.resultSetToXMLElement((ResultSet)derbyRS, (boolean)true, (boolean)true);
        Map<String, Integer> resultMap = TestUtil.xmlElementToFrequencyMap(resultElement);
        Map<String, Integer> expectedResultMap = TestUtil.xmlElementToFrequencyMap(expectedElement);
        String resultStr = Misc.serializeXML((Element)resultElement);
        String expectedStr = Misc.serializeXML((Element)expectedElement);
        this.getLogWriter().info((Object)("sqlExecuteVerifyText: The result XML is:\n" + resultStr));
        this.getLogWriter().info((Object)("sqlExecuteVerifyText: The expected XML is:\n" + expectedStr));
        if (!TestUtil.compareFrequencyMaps(expectedResultMap, resultMap)) {
            this.getLogWriter().info((Object)("sqlExecuteVerifyText: The result XML is:\n" + resultStr));
            this.getLogWriter().info((Object)("sqlExecuteVerifyText: The expected XML is:\n" + expectedStr));
            Assert.fail((String)"Expected string in derby does not match the result from GemFireXD.");
        }
    }

    public void testBug51507() throws Exception {
        this.startSites(2);
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        this.executeSql("A", "create gatewaysender MySender (remotedsid 2 isparallel false ) server groups (sgSender)");
        String createTable = "create table testtable (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, ID1 int,primary key (ID))  replicate server groups (sg1)";
        this.executeSql("A", "create table testtable (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, ID1 int,primary key (ID))  replicate server groups (sg1) GatewaySender (MySender) " + this.getSQLSuffixClause());
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        DBSynchronizerTestBase.startNetworkServer(netPort);
        String derbyDbUrl = "jdbc:derby://" + InetAddress.getLocalHost().getHostName() + ':' + netPort + "/newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            derbyDbUrl = derbyDbUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        derbyStmt = derbyConn.createStatement();
        DBSynchronizerTestBase.createDerbyValidationArtefacts(netPort);
        Runnable createListener = DBSynchronizerTestBase.getExecutorForWBCLConfiguration("SG1", "TESTDBSYNC", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", "org.apache.derby.jdbc.ClientDriver", derbyDbUrl, true, 1, null, Boolean.TRUE, null, null, null, 100000, "", false);
        this.executeOnSite("B", createListener);
        this.executeSql("B", "create table testtable (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, ID1 int,primary key (ID))  replicate server groups (sg1)AsyncEventListener (TESTDBSYNC) " + this.getSQLSuffixClause());
        Runnable startListener = DBSynchronizerTestBase.startAsyncEventListener("TESTDBSYNC");
        this.executeOnSite("B", startListener);
        this.executeSql("A", "insert into testtable values(1, 'desc1', 'addr1', 1)");
        this.executeSql("A", "update testtable set description = 'modified_desc1' where id = 1");
        this.executeSql("A", "update testtable set description = 'modified_desc1' where description = 'desc1'");
        this.executeSql("A", "update testtable set description = 'modified_desc2' where description = 'modified_desc1'");
        this.executeSql("A", "delete from testtable where id = 1");
        DBSynchronizerTestBase.blockForValidation(netPort);
        Runnable stopListener = DBSynchronizerTestBase.stopAsyncEventListener("TESTDBSYNC");
        this.executeOnSite("B", stopListener);
        Thread.sleep(5000L);
        int vmNum = this.getSiteAccessorServerNum("B");
        int networkPort = this.startNetworkServer(vmNum, "SG1", null);
        Connection clientConn = TestUtil.getNetConnection(networkPort, null, null);
        Statement stmt = clientConn.createStatement();
        ResultSet derbyRS = derbyStmt.executeQuery("select * from testtable");
        ResultSet gfxdRS = stmt.executeQuery("select * from testtable");
        Element resultElement = Misc.resultSetToXMLElement((ResultSet)gfxdRS, (boolean)true, (boolean)true);
        Element expectedElement = Misc.resultSetToXMLElement((ResultSet)derbyRS, (boolean)true, (boolean)true);
        Map<String, Integer> resultMap = TestUtil.xmlElementToFrequencyMap(resultElement);
        Map<String, Integer> expectedResultMap = TestUtil.xmlElementToFrequencyMap(expectedElement);
        String resultStr = Misc.serializeXML((Element)resultElement);
        String expectedStr = Misc.serializeXML((Element)expectedElement);
        this.getLogWriter().info((Object)("sqlExecuteVerifyText: The result XML is:\n" + resultStr));
        this.getLogWriter().info((Object)("sqlExecuteVerifyText: The expected XML is:\n" + expectedStr));
        if (!TestUtil.compareFrequencyMaps(expectedResultMap, resultMap)) {
            this.getLogWriter().info((Object)("sqlExecuteVerifyText: The result XML is:\n" + resultStr));
            this.getLogWriter().info((Object)("sqlExecuteVerifyText: The expected XML is:\n" + expectedStr));
            Assert.fail((String)"Expected string in derby does not match the result from GemFireXD.");
        }
    }

    public void testSerialWanNewDunitConfig() throws Exception {
        this.startSites();
        this.addExpectedException(new String[]{"A", "B", "C", "D"}, new Object[]{FunctionExecutionException.class});
        this.addExpectedException(new String[]{"A", "B", "C", "D"}, new String[]{"Could not connect"});
        VM siteA = (VM)this.serverVMs.get(3);
        VM siteB = (VM)this.serverVMs.get(7);
        VM siteC = (VM)this.serverVMs.get(11);
        VM siteD = (VM)this.serverVMs.get(15);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql(siteA, "create gatewayreceiver myrcvr() server groups(sgSender)");
        this.executeSql(siteB, "create gatewayreceiver myrcvr() server groups(sgSender)");
        this.executeSql(siteC, "create gatewayreceiver myrcvr() server groups(sgSender)");
        this.executeSql(siteD, "create gatewayreceiver myrcvr() server groups(sgSender)");
        this.executeSql(siteA, "CREATE gatewaysender mySender (remotedsid 2) server groups (sgSender)");
        this.executeSql(siteA, "CREATE gatewaysender mySenderB (remotedsid 3) server groups (sgSender)");
        this.executeSql(siteB, "CREATE gatewaysender mySender (remotedsid 1) server groups (sgSender)");
        this.executeSql(siteC, "CREATE gatewaysender mySender (remotedsid 4) server groups (sgSender)");
        String createPTable = "create table EMP.REPLICATED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate server groups (sg1)";
        this.executeSql(siteA, "create table EMP.REPLICATED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate server groups (sg1) GatewaySender (MySender,mySenderB)" + this.getSQLSuffixClause());
        this.executeSql(siteB, "create table EMP.REPLICATED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql(siteC, "create table EMP.REPLICATED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql(siteD, "create table EMP.REPLICATED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate server groups (sg1)" + this.getSQLSuffixClause());
        String createCTable = "create table EMP.PARTITIONED_TABLE (ID int not null, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID), foreign key (ID) references EMP.REPLICATED_TABLE (id)) partition by column(ADDRESS) redundancy 1 server groups (sg1)";
        this.executeSql(siteA, createCTable + " GatewaySender (MySender,mySenderB)" + this.getSQLSuffixClause());
        this.executeSql(siteB, createCTable + " GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql(siteC, createCTable + " GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql(siteD, createCTable + this.getSQLSuffixClause());
        this.executeSql(siteA, "insert into EMP.REPLICATED_TABLE values (1, 'First', 'A714')");
        this.executeSql(siteA, "insert into EMP.PARTITIONED_TABLE values (1, 'First', 'A714')");
        this.executeSql(siteA, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.sqlExecuteVerify(siteA, "select ID from EMP.PARTITIONED_TABLE", goldenFile, "id1", true, false);
        this.sqlExecuteVerify(siteB, "select ID from EMP.PARTITIONED_TABLE", goldenFile, "id1", true, false);
        this.executeSql(siteA, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDERB', 0, 0)");
        this.sqlExecuteVerify(siteC, "select ID from EMP.PARTITIONED_TABLE", goldenFile, "id1", true, false);
        this.executeSql(siteC, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify(siteD, "select ID from EMP.PARTITIONED_TABLE", goldenFile, "id1", true, false);
        this.executeSql(siteB, "Update EMP.REPLICATED_TABLE set DESCRIPTION = 'Second' where ADDRESS = 'A714'");
        this.executeSql(siteB, "Update EMP.PARTITIONED_TABLE set DESCRIPTION = 'Second' where ADDRESS = 'A714'");
        this.executeSql(siteB, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify(siteA, "select DESCRIPTION from EMP.PARTITIONED_TABLE", goldenFile, "id2", true, false);
        this.executeSql(siteA, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDERB', 0, 0)");
        this.sqlExecuteVerify(siteC, "select DESCRIPTION from EMP.PARTITIONED_TABLE", goldenFile, "id2", true, false);
        this.executeSql(siteC, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify(siteD, "select DESCRIPTION from EMP.PARTITIONED_TABLE", goldenFile, "id2", true, false);
    }

    public void testBasicDMLOperationPropagationOnUseCase1Schema_PlusVersions48125() throws Exception {
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(1, 0, "sg1", props);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(2, 0, null, props);
        this.joinVMs(true, async3, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.addExpectedException((VM)this.serverVMs.get(2), new Object[]{CacheClosedException.class});
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(3)));
        this.addExpectedException((VM)this.serverVMs.get(3), new Object[]{CacheClosedException.class});
        Runnable createReceiver = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createReceiver);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(1, 0, "tableGrp,senderGrp", props);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async6 = this.invokeStartServerVM(2, 0, "tableGrp", props);
        this.joinVMs(true, async5, async6);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 6 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(5)));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "senderGrp"));
        VM receiver1 = (VM)this.serverVMs.get(2);
        VM sender0 = (VM)this.serverVMs.get(4);
        VM ds1member = (VM)this.serverVMs.get(3);
        VM ds0member = (VM)this.serverVMs.get(5);
        this.executeSql(receiver1, "create schema EMP");
        this.executeSql(sender0, "create schema EMP");
        String table = "CREATE TABLE SECT_CHANNEL_DATA(CHANNEL_TXN_ID varchar(30) NOT NULL primary key,     CLIENT_ID int not null ,     CLIENT_NAME VARCHAR (100) ,     CLIENT_ACCOUNT VARCHAR (100) ,     COMPANY_ID VARCHAR (100) ,     CLIENT_REF_NO VARCHAR (100) ,     VALUE_DATE TIMESTAMP ,     AMOUNT DECIMAL (16,2) ,     CURRENCY VARCHAR (20) ,     PAY_METHOD VARCHAR (100) ,     PAY_VEHICLE VARCHAR (100) ,     ORIG_BANK_ID VARCHAR (100) ,     BACKOFFICE_CODE VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,     BENE_ACCNT_NO VARCHAR (100) ,     BENE_NAME VARCHAR (100) ,     BENE_ADDR VARCHAR (100) ,     BENE_BANK_ID VARCHAR (100) ,     BENE_BANK_NAME VARCHAR (100) ,     BENE_BANK_ADDR VARCHAR (256) ,     CLIENT_FILE_ID VARCHAR (100) ,     CLIENT_FILE_TIME TIMESTAMP ,     TXN_CREATED_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP,     RAW_DATA CLOB NOT NULL ,     DATA_LIFE_STATUS SMALLINT NOT NULL ,     MATCH_STATUS SMALLINT WITH DEFAULT 1 ,     LAST_MATCH_DATE TIMESTAMP ,     MATCH_CATEG_ID INTEGER ,     IS_REJECTED CHAR (1) WITH DEFAULT 'N' ,     IS_CANCELLED CHAR (1) WITH DEFAULT 'N' ,     FILE_TYPE_ID VARCHAR (36) NOT NULL ,     ETL_TIME INTEGER NOT NULL ,     CHANNEL_NAME VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,     TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN' ,     HIT_STATUS SMALLINT ,     ACTUAL_VALUE_DATE TIMESTAMP ,     LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP    )    PARTITION BY column(CLIENT_ID)    REDUNDANCY 1    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW" + this.getSQLSuffixClause();
        this.executeSql(sender0, table);
        this.executeSql(receiver1, table);
        this.executeSql(sender0, "alter table SECT_CHANNEL_DATA set GatewaySender (MySender)");
        String sql1 = "INSERT INTO SECT_CHANNEL_DATA  (CHANNEL_TXN_ID,CLIENT_ID,CLIENT_NAME,CLIENT_ACCOUNT,COMPANY_ID,CLIENT_REF_NO,VALUE_DATE,AMOUNT,CURRENCY,PAY_METHOD,PAY_VEHICLE,ORIG_BANK_ID,BACKOFFICE_CODE,BENE_ACCNT_NO,BENE_NAME,BENE_ADDR,BENE_BANK_ID,BENE_BANK_NAME,BENE_BANK_ADDR,CLIENT_FILE_ID,CLIENT_FILE_TIME,TXN_CREATED_TIME,RAW_DATA,DATA_LIFE_STATUS,MATCH_STATUS,LAST_MATCH_DATE,MATCH_CATEG_ID,IS_REJECTED,IS_CANCELLED,FILE_TYPE_ID,ETL_TIME,CHANNEL_NAME,TXN_TYPE,HIT_STATUS,ACTUAL_VALUE_DATE,LAST_UPDATE_TIME) VALUES('testCol1',1,null,'19882893','6777734','7XWzXJPAaUR2D',{ts '2012-03-02 00:00:00'},125.37,'GBP',null,null,'ouuAeSpCLP','IPAY','P988WgvLVJ','JoqVZBxRox','0MBMP4UveC0ExdgnXZzS','WU0D8ZPtAT',null,'auqvTxVzXtmUHujYOEto',null,null,{ts '2013-03-08 16:14:33'},'<Clob>',0,1,null,null,'N','N','1a53b9a4-f0df-4abb-9da8-33f23183579s',-1,'H2H','DDI',null,null,{ts '2013-03-08 16:14:33'})";
        String sql114 = "INSERT INTO SECT_CHANNEL_DATA  (CHANNEL_TXN_ID,CLIENT_ID,CLIENT_NAME,CLIENT_ACCOUNT,COMPANY_ID,CLIENT_REF_NO,VALUE_DATE,AMOUNT,CURRENCY,PAY_METHOD,PAY_VEHICLE,ORIG_BANK_ID,BACKOFFICE_CODE,BENE_ACCNT_NO,BENE_NAME,BENE_ADDR,BENE_BANK_ID,BENE_BANK_NAME,BENE_BANK_ADDR,CLIENT_FILE_ID,CLIENT_FILE_TIME,TXN_CREATED_TIME,RAW_DATA,DATA_LIFE_STATUS,MATCH_STATUS,LAST_MATCH_DATE,MATCH_CATEG_ID,IS_REJECTED,IS_CANCELLED,FILE_TYPE_ID,ETL_TIME,CHANNEL_NAME,TXN_TYPE,HIT_STATUS,ACTUAL_VALUE_DATE,LAST_UPDATE_TIME) VALUES('testCol2',1,null,'19882893','6777734','7XWzXJPAaUR2D',{ts '2012-03-02 00:00:00'},125.37,'GBP',null,null,'ouuAeSpCLP','IPAY','P988WgvLVJ','JoqVZBxRox','0MBMP4UveC0ExdgnXZzS','WU0D8ZPtAT',null,'auqvTxVzXtmUHujYOEto',null,null,{ts '2013-03-08 16:14:33'},'<Clob>',0,1,null,null,'N','N','1a53b9a4-f0df-4abb-9da8-33f23183579s',-1,'H2H','DDI',null,null,{ts '2013-03-08 16:14:33'})";
        this.executeSql(ds1member, sql1);
        this.executeSql(ds0member, sql114);
        this.executeSql(sender0, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        Object result = receiver1.invoke((Callable)new SerializableCallable(){

            public Object call() throws Exception {
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("select * from SECT_CHANNEL_DATA");
                TestCase.assertTrue((boolean)rs.next());
                int res = rs.getInt(2);
                TestCase.assertEquals((int)1, (int)res);
                TestCase.assertTrue((boolean)rs.next());
                res = rs.getInt(2);
                TestCase.assertEquals((int)1, (int)res);
                TestCase.assertFalse((boolean)rs.next());
                conn.close();
                return res;
            }
        });
        GfxdSerialWanDUnit.assertEquals((int)1, (int)((Integer)result));
        String table21 = "CREATE TABLE EMP.SECT_CHANNEL_DATA2(CHANNEL_TXN_ID varchar(30) NOT NULL primary key,     CLIENT_ID int not null ,     CLIENT_NAME VARCHAR (100) ,     CLIENT_ACCOUNT VARCHAR (100) ,     COMPANY_ID VARCHAR (100) ,     CLIENT_REF_NO VARCHAR (100) ,     VALUE_DATE TIMESTAMP ,     AMOUNT DECIMAL (16,2) ,     CURRENCY VARCHAR (20) ,     PAY_METHOD VARCHAR (100) ,     PAY_VEHICLE VARCHAR (100) ,     ORIG_BANK_ID VARCHAR (100) ,     BACKOFFICE_CODE VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,     BENE_ACCNT_NO VARCHAR (100) ,     BENE_NAME VARCHAR (100) ,     BENE_ADDR VARCHAR (100) ,     BENE_BANK_ID VARCHAR (100) ,     BENE_BANK_NAME VARCHAR (100) ,     BENE_BANK_ADDR VARCHAR (256) ,     CLIENT_FILE_ID VARCHAR (100) ,     CLIENT_FILE_TIME TIMESTAMP ,     TXN_CREATED_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP,     RAW_DATA CLOB NOT NULL ,     DATA_LIFE_STATUS SMALLINT NOT NULL ,     MATCH_STATUS SMALLINT WITH DEFAULT 1 ,     LAST_MATCH_DATE TIMESTAMP ,     MATCH_CATEG_ID INTEGER ,     IS_REJECTED CHAR (1) WITH DEFAULT 'N' ,     IS_CANCELLED CHAR (1) WITH DEFAULT 'N' ,     FILE_TYPE_ID VARCHAR (36) NOT NULL ,     ETL_TIME INTEGER NOT NULL ,     CHANNEL_NAME VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,     TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN' ,     HIT_STATUS SMALLINT ,     ACTUAL_VALUE_DATE TIMESTAMP,     LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP    )    PARTITION BY column(CLIENT_ID)    REDUNDANCY 1    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW" + this.getSQLSuffixClause();
        String table22 = "CREATE TABLE EMP.SECT_CHANNEL_DATA2(CHANNEL_TXN_ID varchar(30) NOT NULL primary key,     CLIENT_ID int not null ,     CLIENT_NAME VARCHAR (100) ,     CLIENT_ACCOUNT VARCHAR (100) ,     COMPANY_ID VARCHAR (100) ,     CLIENT_REF_NO VARCHAR (100) ,     VALUE_DATE TIMESTAMP ,     AMOUNT DECIMAL (16,2) ,     CURRENCY VARCHAR (20) ,     PAY_METHOD VARCHAR (100) ,     PAY_VEHICLE VARCHAR (100) ,     ORIG_BANK_ID VARCHAR (100) ,     BACKOFFICE_CODE VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,     BENE_ACCNT_NO VARCHAR (100) ,     BENE_NAME VARCHAR (100) ,     BENE_ADDR VARCHAR (100) ,     BENE_BANK_ID VARCHAR (100) ,     BENE_BANK_NAME VARCHAR (100) ,     BENE_BANK_ADDR VARCHAR (256) ,     CLIENT_FILE_ID VARCHAR (100) ,     CLIENT_FILE_TIME TIMESTAMP ,     TXN_CREATED_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP,     RAW_DATA CLOB NOT NULL ,     DATA_LIFE_STATUS SMALLINT NOT NULL ,     MATCH_STATUS SMALLINT WITH DEFAULT 1 ,     LAST_MATCH_DATE TIMESTAMP ,     MATCH_CATEG_ID INTEGER ,     IS_REJECTED CHAR (1) WITH DEFAULT 'N' ,     IS_CANCELLED CHAR (1) WITH DEFAULT 'N' ,     FILE_TYPE_ID VARCHAR (36) NOT NULL ,     ETL_TIME INTEGER NOT NULL ,     CHANNEL_NAME VARCHAR (100) WITH DEFAULT 'UNKNOWN' ,     TXN_TYPE VARCHAR (30) WITH DEFAULT 'UNKNOWN' ,     HIT_STATUS SMALLINT ,     ACTUAL_VALUE_DATE TIMESTAMP    )    PARTITION BY column(CLIENT_ID)    REDUNDANCY 1    EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW" + this.getSQLSuffixClause();
        String table23 = "ALTER TABLE EMP.SECT_CHANNEL_DATA2 ADD COLUMN LAST_UPDATE_TIME TIMESTAMP WITH DEFAULT CURRENT_TIMESTAMP";
        this.executeSql(sender0, table21);
        this.executeSql(receiver1, table22);
        this.executeSql(receiver1, table23);
        this.executeSql(sender0, "alter table EMP.SECT_CHANNEL_DATA2 set GatewaySender (MySender)");
        SerializableCallable sel1 = new SerializableCallable(){

            public Object call() throws Exception {
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("VALUES SYS.GET_TABLE_VERSION('EMP', 'SECT_CHANNEL_DATA2')");
                TestCase.assertTrue((boolean)rs.next());
                int result = rs.getInt(1);
                TestCase.assertFalse((boolean)rs.next());
                conn.close();
                return result;
            }
        };
        result = sender0.invoke((Callable)sel1);
        GfxdSerialWanDUnit.assertEquals((int)1, (int)((Integer)result));
        result = ds0member.invoke((Callable)sel1);
        GfxdSerialWanDUnit.assertEquals((int)1, (int)((Integer)result));
        result = receiver1.invoke((Callable)sel1);
        GfxdSerialWanDUnit.assertEquals((int)2, (int)((Integer)result));
        result = ds1member.invoke((Callable)sel1);
        GfxdSerialWanDUnit.assertEquals((int)2, (int)((Integer)result));
        sql1 = "INSERT INTO EMP.SECT_CHANNEL_DATA2 (CHANNEL_TXN_ID,CLIENT_ID,CLIENT_NAME,CLIENT_ACCOUNT,COMPANY_ID,CLIENT_REF_NO,VALUE_DATE,AMOUNT,CURRENCY,PAY_METHOD,PAY_VEHICLE,ORIG_BANK_ID,BACKOFFICE_CODE,BENE_ACCNT_NO,BENE_NAME,BENE_ADDR,BENE_BANK_ID,BENE_BANK_NAME,BENE_BANK_ADDR,CLIENT_FILE_ID,CLIENT_FILE_TIME,TXN_CREATED_TIME,RAW_DATA,DATA_LIFE_STATUS,MATCH_STATUS,LAST_MATCH_DATE,MATCH_CATEG_ID,IS_REJECTED,IS_CANCELLED,FILE_TYPE_ID,ETL_TIME,CHANNEL_NAME,TXN_TYPE,HIT_STATUS,ACTUAL_VALUE_DATE,LAST_UPDATE_TIME) VALUES('testCol1',1,null,'19882893','6777734','7XWzXJPAaUR2D',{ts '2012-03-02 00:00:00'},125.37,'GBP',null,null,'ouuAeSpCLP','IPAY','P988WgvLVJ','JoqVZBxRox','0MBMP4UveC0ExdgnXZzS','WU0D8ZPtAT',null,'auqvTxVzXtmUHujYOEto',null,null,{ts '2013-03-08 16:14:33'},'<Clob>',0,1,null,null,'N','N','1a53b9a4-f0df-4abb-9da8-33f23183579s',-1,'H2H','DDI',null,null,{ts '2013-03-08 16:14:33'})";
        sql114 = "INSERT INTO EMP.SECT_CHANNEL_DATA2  (CHANNEL_TXN_ID,CLIENT_ID,CLIENT_NAME,CLIENT_ACCOUNT,COMPANY_ID,CLIENT_REF_NO,VALUE_DATE,AMOUNT,CURRENCY,PAY_METHOD,PAY_VEHICLE,ORIG_BANK_ID,BACKOFFICE_CODE,BENE_ACCNT_NO,BENE_NAME,BENE_ADDR,BENE_BANK_ID,BENE_BANK_NAME,BENE_BANK_ADDR,CLIENT_FILE_ID,CLIENT_FILE_TIME,TXN_CREATED_TIME,RAW_DATA,DATA_LIFE_STATUS,MATCH_STATUS,LAST_MATCH_DATE,MATCH_CATEG_ID,IS_REJECTED,IS_CANCELLED,FILE_TYPE_ID,ETL_TIME,CHANNEL_NAME,TXN_TYPE,HIT_STATUS,ACTUAL_VALUE_DATE,LAST_UPDATE_TIME) VALUES('testCol2',1,null,'19882893','6777734','7XWzXJPAaUR2D',{ts '2012-03-02 00:00:00'},125.37,'GBP',null,null,'ouuAeSpCLP','IPAY','P988WgvLVJ','JoqVZBxRox','0MBMP4UveC0ExdgnXZzS','WU0D8ZPtAT',null,'auqvTxVzXtmUHujYOEto',null,null,{ts '2013-03-08 16:14:33'},'<Clob>',0,1,null,null,'N','N','1a53b9a4-f0df-4abb-9da8-33f23183579s',-1,'H2H','DDI',null,null,{ts '2013-03-08 16:14:33'})";
        this.executeSql(ds0member, "CALL SYS.INCREMENT_TABLE_VERSION('EMP', 'SECT_CHANNEL_DATA2', 1)");
        this.executeSql(ds0member, sql114);
        this.executeSql(sender0, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        SerializableCallable sel2 = new SerializableCallable(){

            public Object call() throws Exception {
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("select * from EMP.SECT_CHANNEL_DATA2");
                int numResults = 0;
                while (rs.next()) {
                    ++numResults;
                    TestCase.assertEquals((int)1, (int)rs.getInt(2));
                }
                conn.close();
                return numResults;
            }
        };
        result = receiver1.invoke((Callable)sel2);
        GfxdSerialWanDUnit.assertEquals((int)1, (int)((Integer)result));
        this.stopVMNums(-5, -6);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        async5 = this.restartServerVMAsync(5, 0, null, props);
        async6 = this.restartServerVMAsync(6, 0, "tableGrp,senderGrp", props);
        this.joinVMs(false, async5, async6);
        this.executeSql(sender0, sql1);
        this.executeSql(sender0, "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        result = receiver1.invoke((Callable)sel2);
        GfxdSerialWanDUnit.assertEquals((int)2, (int)((Integer)result));
    }

    public void testBasicDMLOperationPropagationToWanSitesOnReplicatedAlterTable() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        Runnable createRecevier = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createRecevier);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(1, 0, "tableGrp", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(1, 0, "tableGrp,senderGrp", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "senderGrp"));
        VM reciever = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        this.executeSql(reciever, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        this.executeSql(reciever, "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate server groups (sg1)" + this.getSQLSuffixClause());
        this.executeSql(sender, "create table EMP.TESTTABLE (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate server groups (tableGrp)" + this.getSQLSuffixClause());
        this.executeSql(sender, "alter table EMP.TESTTABLE set GatewaySender (MySender)");
        SerializableCallable checkSYSTABLES = new SerializableCallable(){

            public Object call() throws Exception {
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("select gatewaysenders from sys.systables where tablename='TESTTABLE'");
                TestCase.assertTrue((boolean)rs.next());
                String senders = rs.getString(1);
                rs.close();
                conn.close();
                return senders;
            }
        };
        String senders = (String)this.serverExecute(4, (Callable<?>)checkSYSTABLES);
        GfxdSerialWanDUnit.assertEquals((String)"MYSENDER", (String)senders);
        senders = (String)this.serverExecute(5, (Callable<?>)checkSYSTABLES);
        GfxdSerialWanDUnit.assertEquals((String)"MYSENDER", (String)senders);
        this.serverExecute(4, GfxdSerialWanDUnit.batchInsert());
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(sender, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where ID = 1");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(sender, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testBasicDMLOperationPropagationToWanSitesOnReplicatedTable() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        Runnable createRecevier = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createRecevier);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM reciever = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        this.executeSql(reciever, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate gatewaysender (MYSENDER) server groups (sg1)" + this.getSQLSuffixClause();
        this.executeSql(reciever, createTable);
        this.executeSql(sender, createTable);
        this.serverExecute(4, GfxdSerialWanDUnit.batchInsert());
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(sender, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where ID = 1");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(sender, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void DEBUGtestBasicDMLOperationPropagationToWanSitesOnReplicatedTable() throws Exception {
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "DEMOGOUP", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        this.serverExecute(3, GfxdSerialWanDUnit.createConfiguration2());
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "DEMOGOUP", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createConfiguration1());
        this.serverExecute(4, GfxdSerialWanDUnit.startSender());
        this.serverExecute(4, GfxdSerialWanDUnit.doInserts());
        this.serverExecute(4, GfxdSerialWanDUnit.doUpdates());
        GfxdSerialWanDUnit.pause((int)5000);
    }

    public void testBasicDMLOperationPropagationToWanSitesOnPartitionedTable() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        Runnable createRecevier = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createRecevier);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM reciever = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        this.executeSql(reciever, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) gatewaysender (MYSENDER) server groups (sg1) " + this.getSQLSuffixClause();
        this.executeSql(reciever, createTable);
        this.executeSql(sender, createTable);
        this.serverExecute(4, GfxdSerialWanDUnit.batchInsert());
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(sender, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where ID = 1");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(sender, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testBasicDMLOperationPropagationToWanSitesOnPartitionedTable_1() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        Runnable createRecevier = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createRecevier);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM reciever = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        this.executeSql(reciever, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024)) gatewaysender (MYSENDER) server groups (sg1) " + this.getSQLSuffixClause();
        this.executeSql(reciever, createTable);
        this.executeSql(sender, createTable);
        this.executeSql(sender, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(sender, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where ID = 1");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(sender, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testTableWithNoPrimaryKeys_2Sites() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        this.executeSql("A", "CREATE gatewaysender mySender (remotedsid 2 isparallel false ) server groups (sg1)");
        String createPTable = "create table EMP.REPLICATED_TABLE(ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024)) replicate server groups (sg1)";
        this.executeSql("A", "create table EMP.REPLICATED_TABLE(ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024)) replicate server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.REPLICATED_TABLE(ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024)) replicate server groups (sg1)" + this.getSQLSuffixClause());
        VM accessor = this.getSiteAccessor("A");
        accessor.invoke(GfxdSerialWanDUnit.class, "batchInsert_NoPrimaryKey");
        this.sqlExecuteVerify("A", "select * from EMP.REPLICATED_TABLE", goldenFile, "batch_id5", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select * from EMP.REPLICATED_TABLE", goldenFile, "batch_id5", true, false);
        this.executeSql("A", "Update EMP.REPLICATED_TABLE set DESCRIPTION = 'First' where ADDRESS = 'J 604'");
        this.sqlExecuteVerify("A", "select * from EMP.REPLICATED_TABLE", goldenFile, "batch_id6", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select * from EMP.REPLICATED_TABLE", goldenFile, "batch_id6", true, false);
        this.executeSql("B", "insert into EMP.REPLICATED_TABLE values (11, 'First', 'X 604')");
        this.executeSql("B", "insert into EMP.REPLICATED_TABLE values (12, 'First', 'Y 604')");
        this.executeSql("B", "insert into EMP.REPLICATED_TABLE values (13, 'First', 'Z 604')");
        this.executeSql("B", "insert into EMP.REPLICATED_TABLE values (14, 'First', 'X 604')");
        this.executeSql("B", "insert into EMP.REPLICATED_TABLE values (15, 'First', 'Y 604')");
        this.sqlExecuteVerify("B", "select * from EMP.REPLICATED_TABLE", goldenFile, "batch_id7", true, false);
    }

    public void testBasicDMLOperationPropagationToWanSitesOnPartitionedTableWithIdentityAlways() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        Runnable createRecevier = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createRecevier);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM receiver = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        this.executeSql(receiver, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) partition by primary key gatewaysender (MYSENDER) server groups (sg1)";
        String createIdentTable = "create table EMP.TESTTABLE2 (ID bigint GENERATED ALWAYS AS IDENTITY, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) partition by primary key gatewaysender (MYSENDER) server groups (sg1)";
        String createIdentTable2 = "create table EMP.TESTTABLE3 (ID bigint GENERATED ALWAYS AS IDENTITY, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) partition by primary key gatewaysender (MYSENDER) server groups (sg1)";
        String createIdentTable3 = "create table EMP.TESTTABLE4 (ID bigint GENERATED BY DEFAULT AS IDENTITY, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (DESCRIPTION)) partition by primary key gatewaysender (MYSENDER) server groups (sg1)";
        this.executeSql(receiver, createTable + this.getSQLSuffixClause());
        this.executeSql(receiver, createIdentTable + this.getSQLSuffixClause());
        this.executeSql(receiver, createIdentTable2 + this.getSQLSuffixClause());
        this.executeSql(receiver, createIdentTable3 + this.getSQLSuffixClause());
        this.executeSql(sender, createTable + this.getSQLSuffixClause());
        this.executeSql(sender, createIdentTable + this.getSQLSuffixClause());
        this.executeSql(sender, createIdentTable2 + this.getSQLSuffixClause());
        this.executeSql(sender, createIdentTable3 + this.getSQLSuffixClause());
        this.executeSql(sender, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(receiver, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(receiver, "insert into EMP.TESTTABLE2 (DESCRIPTION, ADDRESS) values ('First', 'J 604')");
        this.executeSql(receiver, "insert into EMP.TESTTABLE2 (DESCRIPTION, ADDRESS) values ('Second', 'J 605')");
        this.executeSql(receiver, "insert into EMP.TESTTABLE3 (DESCRIPTION, ADDRESS) values ('First', 'J 604')");
        this.executeSql(receiver, "insert into EMP.TESTTABLE3 (DESCRIPTION, ADDRESS) values ('Second', 'J 605')");
        this.executeSql(receiver, "insert into EMP.TESTTABLE4 (DESCRIPTION, ADDRESS) values ('First', 'J 604')");
        this.executeSql(receiver, "insert into EMP.TESTTABLE4 (DESCRIPTION, ADDRESS) values ('Second', 'J 605')");
        this.executeSql(sender, "insert into EMP.TESTTABLE2 (DESCRIPTION, ADDRESS) values ('Third', 'J 606')");
        this.executeSql(sender, "insert into EMP.TESTTABLE2 (DESCRIPTION, ADDRESS) values ('Fourth', 'J 607')");
        this.executeSql(sender, "insert into EMP.TESTTABLE3 (DESCRIPTION, ADDRESS) values ('Third', 'J 606')");
        this.executeSql(sender, "insert into EMP.TESTTABLE3 (DESCRIPTION, ADDRESS) values ('Fourth', 'J 607')");
        this.executeSql(sender, "insert into EMP.TESTTABLE4 (DESCRIPTION, ADDRESS) values ('Third', 'J 606')");
        this.executeSql(sender, "insert into EMP.TESTTABLE4 (DESCRIPTION, ADDRESS) values ('Fourth', 'J 607')");
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE2 order by ID", goldenFile, "ident_id", true, false);
        this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE3 order by ID", goldenFile, "ident_id", true, false);
        this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE4 order by ID", goldenFile, "ident_id", true, false);
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE2 order by ID", goldenFile, "ident_id2", true, false);
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE3 order by ID", goldenFile, "ident_id2", true, false);
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE4 order by ID", goldenFile, "ident_id2", true, false);
        this.executeSql(sender, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(sender, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testBasicDMLOperationPropagationToWanSitesOnReplicatedTableWithSkipListenerFlag() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2" + fileSeparator + "Receiver");
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        this.addExpectedException((VM)this.serverVMs.get(2), new Object[]{CacheClosedException.class});
        Runnable createRecevier = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createRecevier);
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "1" + fileSeparator + "Sender");
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.addExpectedException((VM)this.serverVMs.get(3), new Object[]{CacheClosedException.class});
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM reciever = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "1" + fileSeparator + "Accessor");
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        props.put("skip-listeners", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement stmt = conn.createStatement();
        this.executeSql(reciever, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) replicate gatewaysender (MYSENDER) server groups (sg1) ";
        this.executeSql(reciever, createTable + this.getSQLSuffixClause());
        this.executeSql(sender, createTable + this.getSQLSuffixClause());
        stmt.execute("insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        stmt.execute("Update EMP.TESTTABLE set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        stmt.execute("Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testBasicDMLOperationPropagationToWanSitesOnPartitionedTableWithSkipListenerFlag() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2" + fileSeparator + "Receiver");
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        this.addExpectedException((VM)this.serverVMs.get(2), new Object[]{CacheClosedException.class});
        Runnable createRecevier = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createRecevier);
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "1" + fileSeparator + "Sender");
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.addExpectedException((VM)this.serverVMs.get(3), new Object[]{CacheClosedException.class});
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM reciever = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "1" + fileSeparator + "Accessor");
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        props.put("skip-listeners", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement stmt = conn.createStatement();
        this.executeSql(reciever, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) gatewaysender (MYSENDER) server groups (sg1) ";
        this.executeSql(reciever, createTable + this.getSQLSuffixClause());
        this.executeSql(sender, createTable + this.getSQLSuffixClause());
        stmt.execute("insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        stmt.execute("Update EMP.TESTTABLE set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        stmt.execute("Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testGatewayReceivers() throws Exception {
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        Properties props = new Properties();
        props.put("sys-disk-dir", "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(2, 0, "sg1", props);
        this.joinVMs(true, async3);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async4);
        this.serverExecute(3, GfxdSerialWanDUnit.createGatewayReceiver(11111, 11113));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonPKTableInserts() throws Exception {
        try {
            String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
            Properties props = new Properties();
            int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
            props.put("sys-disk-dir", this.getUniqueName() + "1");
            props.setProperty("mcast-port", "0");
            props.setProperty("distributed-system-id", "1");
            props.setProperty("locators", "localhost[" + lnPort + "]");
            this.startLocatorVM("localhost", lnPort, null, props);
            GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
            int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
            props = new Properties();
            props.put("sys-disk-dir", this.getUniqueName() + "2");
            props.setProperty("mcast-port", "0");
            props.setProperty("distributed-system-id", "2");
            props.setProperty("locators", "localhost[" + nyPort + "]");
            props.setProperty("remote-locators", "localhost[" + lnPort + "]");
            this.startLocatorVM("localhost", nyPort, null, props);
            GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
            props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", "localhost[" + nyPort + "]");
            DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
            this.joinVMs(true, async3);
            GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
            GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(2)));
            this.serverExecute(3, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
            this.serverExecute(3, GfxdSerialWanDUnit.createGatewaySender("mySender", "1", "sg1"));
            props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", "localhost[" + lnPort + "]");
            DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
            this.joinVMs(true, async4);
            GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
            GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(3)));
            this.serverExecute(4, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
            this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
            VM reciever = (VM)this.serverVMs.get(2);
            VM sender = (VM)this.serverVMs.get(3);
            this.executeSql(reciever, "create schema EMP");
            this.executeSql(sender, "create schema EMP");
            String createTable = "create table EMP.TESTTABLE (ID bigint , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024)) gatewaysender (MYSENDER) server groups (sg1) ";
            this.executeSql(reciever, createTable + this.getSQLSuffixClause());
            this.executeSql(sender, createTable + this.getSQLSuffixClause());
            for (int i = 0; i < 20; ++i) {
                this.executeSql(sender, "insert into EMP.TESTTABLE values(" + i + ", 'First', 'J 604')");
            }
            this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
            List senderKeys = (List)this.serverExecute(4, (Callable<?>)new SerializableCallable(){

                public Object call() throws Exception {
                    String path = Misc.getRegionPath((String)"EMP", (String)"TESTTABLE", null);
                    LocalRegion rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
                    ArrayList<Long> keys = new ArrayList<Long>();
                    for (Long key : rgn.keySet()) {
                        keys.add(key);
                        Object value = rgn.get((Object)key);
                        Misc.getCacheLogWriter().info("YOGI sender " + key + ":" + Arrays.toString(value instanceof ByteSource ? ((ByteSource)value).getRowBytes() : (byte[])value));
                    }
                    return keys;
                }
            });
            List rcvrKeys = (List)this.serverExecute(3, (Callable<?>)new SerializableCallable(){

                public Object call() throws Exception {
                    String path = Misc.getRegionPath((String)"EMP", (String)"TESTTABLE", null);
                    LocalRegion rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
                    ArrayList<Long> keys = new ArrayList<Long>();
                    for (Long key : rgn.keySet()) {
                        keys.add(key);
                        Object value = rgn.get((Object)key);
                        Misc.getCacheLogWriter().info("YOGI receiver " + key + ":" + Arrays.toString(value instanceof ByteSource ? ((ByteSource)value).getRowBytes() : (byte[])value));
                    }
                    return keys;
                }
            });
            GfxdSerialWanDUnit.assertEquals((int)20, (int)senderKeys.size());
            GfxdSerialWanDUnit.assertEquals((int)20, (int)rcvrKeys.size());
            for (int i = 0; i < 20; ++i) {
                this.executeSql(reciever, "insert into EMP.TESTTABLE values(" + i + ", 'Second', 'J 604')");
            }
            this.serverExecute(3, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
            this.sqlExecuteVerify(reciever, "select count(*) from EMP.TESTTABLE", null, "40", true, false);
            this.sqlExecuteVerify(sender, "select count(*) as FIELD1 from EMP.TESTTABLE where DESCRIPTION =  'First' ", goldenFile, "id6", true, false);
        }
        finally {
            this.serverExecute(3, GfxdSerialWanDUnit.unsetObserver());
        }
    }

    public void testConfig1() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        this.serverExecute(3, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async6 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async6);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 6 ? 1 : 0) != 0);
        VM reciever = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(4);
        this.executeSql(reciever, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) partition by primary key redundancy 1 gatewaysender (MYSENDER) server groups (sg1)";
        this.executeSql(reciever, createTable + this.getSQLSuffixClause());
        this.executeSql(sender, createTable + this.getSQLSuffixClause());
        this.executeSql(sender, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(sender, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where ID = 1");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(sender, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(reciever, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testMultiSitePropagation() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        int tkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "3");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        props.setProperty("remote-locators", "localhost[" + nyPort + "]");
        this.startLocatorVM("localhost", tkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async6 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async6);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 6 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(5)));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewaySender("mySender", "3", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async7 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async7);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 7 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(6)));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        DistributedSQLTestBase.AsyncVM async8 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async8);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 8 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(7)));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewaySender("mySender", "1", "sg1"));
        VM tk = (VM)this.serverVMs.get(3);
        VM ny = (VM)this.serverVMs.get(4);
        VM ln = (VM)this.serverVMs.get(6);
        this.executeSql(tk, "create schema EMP");
        this.executeSql(ny, "create schema EMP");
        this.executeSql(ln, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) partition by primary key redundancy 1 gatewaysender (MYSENDER) server groups (sg1)";
        this.executeSql(tk, createTable + this.getSQLSuffixClause());
        this.executeSql(ny, createTable + this.getSQLSuffixClause());
        this.executeSql(ln, createTable + this.getSQLSuffixClause());
        this.executeSql(ln, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.sqlExecuteVerify(ln, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(ny, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(tk, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(ln, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(ln, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testMultiSiteAlltoAllPropagation() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        int tkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "3");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        props.setProperty("remote-locators", "localhost[" + nyPort + "]");
        this.startLocatorVM("localhost", tkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(3)));
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "1", "sg1"));
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "2", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(4)));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "1", "sg1"));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "3", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async6 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async6);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 6 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(5)));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "2", "sg1"));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "3", "sg1"));
        VM tk = (VM)this.serverVMs.get(3);
        VM ny = (VM)this.serverVMs.get(4);
        VM ln = (VM)this.serverVMs.get(5);
        this.executeSql(tk, "create schema EMP");
        this.executeSql(ny, "create schema EMP");
        this.executeSql(ln, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) partition by primary key redundancy 1 gatewaysender (MYSENDERA,MYSENDERB) server groups (sg1)";
        this.executeSql(tk, createTable + this.getSQLSuffixClause());
        this.executeSql(ny, createTable + this.getSQLSuffixClause());
        this.executeSql(ln, createTable + this.getSQLSuffixClause());
        this.executeSql(ln, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.sqlExecuteVerify(ln, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.sqlExecuteVerify(ny, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.sqlExecuteVerify(tk, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(ln, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(ln, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testMultiFourSitePropagation() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        int tkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "3");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        props.setProperty("remote-locators", "localhost[" + nyPort + "]");
        this.startLocatorVM("localhost", tkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        int hkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "4");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "4");
        props.setProperty("locators", "localhost[" + hkPort + "]");
        props.setProperty("remote-locators", "localhost[" + tkPort + "]");
        this.startLocatorVM("localhost", hkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "4");
        props.setProperty("locators", "localhost[" + hkPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(4)));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySender", "1", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        DistributedSQLTestBase.AsyncVM async6 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async6);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 6 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(5)));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewaySender("mySender", "4", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async7 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async7);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 7 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(6)));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewaySender("mySender", "3", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async8 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async8);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 8 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(7)));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM hk = (VM)this.serverVMs.get(4);
        VM tk = (VM)this.serverVMs.get(5);
        VM ny = (VM)this.serverVMs.get(6);
        VM ln = (VM)this.serverVMs.get(7);
        this.executeSql(hk, "create schema EMP");
        this.executeSql(tk, "create schema EMP");
        this.executeSql(ny, "create schema EMP");
        this.executeSql(ln, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) partition by primary key redundancy 1 gatewaysender (MYSENDER) server groups (sg1)";
        this.executeSql(hk, createTable + this.getSQLSuffixClause());
        this.executeSql(tk, createTable + this.getSQLSuffixClause());
        this.executeSql(ny, createTable + this.getSQLSuffixClause());
        this.executeSql(ln, createTable + this.getSQLSuffixClause());
        this.executeSql(ln, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.sqlExecuteVerify(ln, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(ny, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(tk, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(hk, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(ln, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(hk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(ln, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(hk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testMultiSiteAlltoAllFourSitePropagation() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        int tkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "3");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        props.setProperty("remote-locators", "localhost[" + nyPort + "]");
        this.startLocatorVM("localhost", tkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        int hkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "4");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "4");
        props.setProperty("locators", "localhost[" + hkPort + "]");
        props.setProperty("remote-locators", "localhost[" + tkPort + "]");
        this.startLocatorVM("localhost", hkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "4");
        props.setProperty("locators", "localhost[" + hkPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(4)));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "1", "sg1"));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "2", "sg1"));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySenderC", "3", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        DistributedSQLTestBase.AsyncVM async6 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async6);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 6 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(5)));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "1", "sg1"));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "2", "sg1"));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewaySender("mySenderC", "4", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async7 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async7);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 7 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(6)));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "1", "sg1"));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "3", "sg1"));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewaySender("mySenderC", "4", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async8 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async8);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 8 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(7)));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "2", "sg1"));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "3", "sg1"));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewaySender("mySenderC", "4", "sg1"));
        VM hk = (VM)this.serverVMs.get(4);
        VM tk = (VM)this.serverVMs.get(5);
        VM ny = (VM)this.serverVMs.get(6);
        VM ln = (VM)this.serverVMs.get(7);
        this.executeSql(hk, "create schema EMP");
        this.executeSql(tk, "create schema EMP");
        this.executeSql(ny, "create schema EMP");
        this.executeSql(ln, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) partition by primary key redundancy 1 gatewaysender (MYSENDERA,MYSENDERB,MYSENDERC) server groups (sg1)";
        this.executeSql(hk, createTable + this.getSQLSuffixClause());
        this.executeSql(tk, createTable + this.getSQLSuffixClause());
        this.executeSql(ny, createTable + this.getSQLSuffixClause());
        this.executeSql(ln, createTable + this.getSQLSuffixClause());
        this.executeSql(ln, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.sqlExecuteVerify(ln, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(ny, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(tk, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(hk, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(ln, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(hk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(ln, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(hk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void testMultiFourRandomSitePropagation_2() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        int tkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "3");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        props.setProperty("remote-locators", "localhost[" + nyPort + "]");
        this.startLocatorVM("localhost", tkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        int hkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "4");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "4");
        props.setProperty("locators", "localhost[" + hkPort + "]");
        props.setProperty("remote-locators", "localhost[" + tkPort + "]");
        this.startLocatorVM("localhost", hkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "4");
        props.setProperty("locators", "localhost[" + hkPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(4)));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "2", "sg1"));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "3", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        DistributedSQLTestBase.AsyncVM async6 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async6);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 6 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(5)));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "2", "sg1"));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "4", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async7 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async7);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 7 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(6)));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "1", "sg1"));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "3", "sg1"));
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewaySender("mySenderC", "4", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async8 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async8);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 8 ? 1 : 0) != 0);
        GfxdSerialWanDUnit.addExpectedException((String)"Could not connect", (VM)((VM)this.serverVMs.get(7)));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "2", "sg1"));
        VM hk = (VM)this.serverVMs.get(4);
        VM tk = (VM)this.serverVMs.get(5);
        VM ny = (VM)this.serverVMs.get(6);
        VM ln = (VM)this.serverVMs.get(7);
        this.executeSql(hk, "create schema EMP");
        this.executeSql(tk, "create schema EMP");
        this.executeSql(ny, "create schema EMP");
        this.executeSql(ln, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) partition by primary key redundancy 1 gatewaysender (MYSENDERA, MYSENDERB, MYSENDERC) server groups (sg1)";
        this.executeSql(hk, createTable + this.getSQLSuffixClause());
        this.executeSql(tk, createTable + this.getSQLSuffixClause());
        this.executeSql(ny, createTable + this.getSQLSuffixClause());
        this.executeSql(ln, createTable + this.getSQLSuffixClause());
        this.executeSql(ln, "insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
        this.sqlExecuteVerify(ln, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.sqlExecuteVerify(ny, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(tk, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.sqlExecuteVerify(hk, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(ln, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.sqlExecuteVerify(hk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(ln, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(7, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.sqlExecuteVerify(hk, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
    }

    public void YOGS_testBug44506() throws Exception {
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        int tkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "3");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        props.setProperty("remote-locators", "localhost[" + nyPort + "]");
        this.startLocatorVM("localhost", tkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "1", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewaySender("mySender", "3", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async6 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async6);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 6 ? 1 : 0) != 0);
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM tk = (VM)this.serverVMs.get(3);
        VM ny = (VM)this.serverVMs.get(4);
        VM ln = (VM)this.serverVMs.get(5);
        String createTable = "create table trade.txhistory(cid int, oid int, sid int, qty int, price decimal (30, 20), type varchar(10), tid int,  constraint type_ch check (type in ('buy', 'sell')))  partition by range (cid) ( VALUES BETWEEN 0 AND 999, VALUES BETWEEN 1009 AND 1102, VALUES BETWEEN 1193 AND 1251, VALUES BETWEEN 1291 AND 1677, VALUES BETWEEN 1678 AND 10000) GATEWAYSENDER(MYSENDER)";
        this.executeSql(tk, createTable);
        this.executeSql(ny, createTable);
        this.executeSql(ln, createTable);
        this.executeSql(ln, "insert into trade.txhistory values (4472, 3484, 487,609,46.62,'buy',256)");
        this.executeSql(ln, "insert into trade.txhistory values (1292, 3113, 97, 644,13.28,'buy',221)");
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.verifyRegionSize("/TRADE/TXHISTORY", 9));
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.verifyRegionSize("/TRADE/TXHISTORY", 9));
        this.executeSql(ln, "Update TRADE.TXHISTORY set type = 'sell'");
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.verifyRegionSize("/TRADE/TXHISTORY", 9));
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.verifyRegionSize("/TRADE/TXHISTORY", 9));
        this.executeSql(ln, "Delete from  TRADE.TXHISTORY where type = 'sell'");
        this.serverExecute(6, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.verifyRegionSize("/TRADE/TXHISTORY", 9));
        this.serverExecute(5, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.verifyRegionSize("/TRADE/TXHISTORY", 9));
    }

    public void testBug44506() throws Exception {
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        this.serverExecute(3, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM ln = (VM)this.serverVMs.get(3);
        VM ny = (VM)this.serverVMs.get(2);
        String createTableLn = "create table trade.txhistory( cid int, oid int, sid int, qty int, type varchar(10), tid int,  constraint type_ch check (type in ('buy', 'sell')))  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))   GATEWAYSENDER(MYSENDER) server groups(sg1)";
        String createTableNy = "create table trade.txhistory( cid int, oid int, sid int, qty int, type varchar(10), tid int,  constraint type_ch check (type in ('buy', 'sell')))  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17)) server groups(sg1) ";
        this.executeSql(ny, createTableNy + this.getSQLSuffixClause());
        this.executeSql(ln, createTableLn + this.getSQLSuffixClause());
        this.executeSql(ln, "insert into trade.txhistory values (3917, 3484, 170 ,609,'buy',130)");
        this.executeSql(ln, "insert into trade.txhistory values (3917, 3484, 170 ,609,'buy',131)");
        this.executeSql(ln, "insert into trade.txhistory values (3917, 3484, 170 ,609,'buy',132)");
        this.executeSql(ln, "insert into trade.txhistory values (3917, 3484, 170 ,609,'buy',133)");
        this.executeSql(ln, "insert into trade.txhistory values (3917, 3484, 170 ,609,'buy',134)");
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.verifyRegionSize("/TRADE/TXHISTORY", 5));
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.serverExecute(3, (Runnable)GfxdSerialWanDUnit.verifyRegionSize("/TRADE/TXHISTORY", 5));
        this.executeSql(ln, "delete from trade.txhistory where cid=3917 and sid=170 and tid=132");
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.verifyRegionSize("/TRADE/TXHISTORY", 4));
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.serverExecute(3, (Runnable)GfxdSerialWanDUnit.verifyRegionSize("/TRADE/TXHISTORY", 4));
    }

    public void testWanTransactions() throws Exception {
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        this.addExpectedException((VM)this.serverVMs.get(2), new Object[]{CacheClosedException.class});
        this.serverExecute(3, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.addExpectedException((VM)this.serverVMs.get(3), new Object[]{CacheClosedException.class});
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM ny = (VM)this.serverVMs.get(2);
        VM ln = (VM)this.serverVMs.get(3);
        String createCustTable = "create table customer (c_w_id  integer not null,        c_d_id  integer not null,       c_id    integer not null,       c_discount   decimal(4,4),      c_credit       char(2),      c_last         varchar(16),      c_first        varchar(16),      c_credit_lim   decimal(12,2),      c_balance      decimal(12,2),      c_ytd_payment  float,      c_payment_cnt  integer,      c_delivery_cnt integer,      c_street_1     varchar(20),      c_street_2     varchar(20),      c_city         varchar(20),      c_state        char(2),      c_zip          char(9),              c_phone        char(16),      c_since        timestamp,      c_middle       char(2),      c_data         varchar(500)) partition by (c_w_id) redundancy 1 buckets 9 gatewaysender (MYSENDER )";
        String createHistoryTable = "create table history (  h_c_id   integer,  h_c_d_id integer,  h_c_w_id integer,  h_d_id   integer,  h_w_id   integer,  h_date   timestamp,  h_amount decimal(6,2),  h_data   varchar(24) ) partition by (h_c_w_id) colocate with (customer) redundancy 1 buckets  9 gatewaysender ( MYSENDER )";
        this.executeSql(ny, createCustTable + this.getSQLSuffixClause());
        this.executeSql(ln, createCustTable + this.getSQLSuffixClause());
        this.executeSql(ny, createHistoryTable + this.getSQLSuffixClause());
        this.executeSql(ln, createHistoryTable + this.getSQLSuffixClause());
        String alterTable = "alter table customer add constraint pk_customer  primary key (c_w_id, c_d_id, c_id)";
        this.executeSql(ny, alterTable);
        this.executeSql(ln, alterTable);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        props.put("sys-disk-dir", "oktk");
        Connection con = TestUtil.getConnection(props);
        con.setTransactionIsolation(2);
        Statement stmt = con.createStatement();
        stmt.execute("INSERT INTO history (h_c_id, h_c_d_id, h_c_w_id, h_d_id, h_w_id) VALUES (3,2,9,2,9)");
        stmt.execute("INSERT INTO customer (c_id, c_d_id, c_w_id) VALUES (3,2,9)");
        con.commit();
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
    }

    public void DEBUGtestMultiSiteOrderingIssue() throws Exception {
        int i;
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        int tkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "3");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        props.setProperty("remote-locators", "localhost[" + nyPort + "]");
        this.startLocatorVM("localhost", tkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        int hkPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "4");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "4");
        props.setProperty("locators", "localhost[" + hkPort + "]");
        props.setProperty("remote-locators", "localhost[" + tkPort + "]");
        this.startLocatorVM("localhost", hkPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "4");
        props.setProperty("locators", "localhost[" + hkPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        this.serverExecute(5, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "3");
        props.setProperty("locators", "localhost[" + tkPort + "]");
        DistributedSQLTestBase.AsyncVM async6 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async6);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 6 ? 1 : 0) != 0);
        this.serverExecute(6, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async7 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async7);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 7 ? 1 : 0) != 0);
        this.serverExecute(7, GfxdSerialWanDUnit.createGatewayReceiver(0, 0));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async8 = this.invokeStartServerVM(1, 0, "sg1,sg2", props);
        this.joinVMs(true, async8);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 8 ? 1 : 0) != 0);
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewaySender("mySenderA", "2", "sg2"));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewaySender("mySenderB", "3", "sg2"));
        this.serverExecute(8, GfxdSerialWanDUnit.createGatewaySender("mySenderC", "4", "sg2"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async9 = this.invokeStartServerVM(1, 0, "sg1,sg2", props);
        this.joinVMs(true, async9);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 9 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async10 = this.invokeStartServerVM(1, 0, "sg1,sg2", props);
        this.joinVMs(true, async10);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 10 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async11 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async11);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 11 ? 1 : 0) != 0);
        VM hk = (VM)this.serverVMs.get(4);
        VM tk = (VM)this.serverVMs.get(5);
        VM ny = (VM)this.serverVMs.get(6);
        VM ln = (VM)this.serverVMs.get(7);
        this.executeSql(hk, "create schema EMP");
        this.executeSql(tk, "create schema EMP");
        this.executeSql(ny, "create schema EMP");
        this.executeSql(ln, "create schema EMP");
        String createParentTable = "create table EMP.PARENT (ID int not null, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID)) partition by primary key redundancy 1 gatewaysender (MYSENDERA, MYSENDERB, MYSENDERC) server groups (sg1)";
        String createChildTable = "create table EMP.CHILD (ID int not null, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), primary key (ID), foreign key (ID) references emp.parent (id)) partition by primary key redundancy 1 gatewaysender (MYSENDERA, MYSENDERB, MYSENDERC) server groups (sg1)";
        this.executeSql(hk, createParentTable);
        this.executeSql(tk, createParentTable);
        this.executeSql(ny, createParentTable);
        this.executeSql(ln, createParentTable);
        this.executeSql(hk, createChildTable);
        this.executeSql(tk, createChildTable);
        this.executeSql(ny, createChildTable);
        this.executeSql(ln, createChildTable);
        for (i = 0; i < 25; ++i) {
            this.launchInsertThread((VM)this.serverVMs.get(7), i);
        }
        for (i = 25; i < 50; ++i) {
            this.launchInsertThread((VM)this.serverVMs.get(8), i);
        }
        for (i = 50; i < 75; ++i) {
            this.launchInsertThread((VM)this.serverVMs.get(9), i);
        }
        for (i = 75; i < 100; ++i) {
            this.launchInsertThread((VM)this.serverVMs.get(10), i);
        }
        GfxdSerialWanDUnit.pause((int)180000);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.serverExecute(9, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(9, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(9, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(ny, "select ID from EMP.PARENT", goldenFile, "id1", true, false);
        this.sqlExecuteVerify(ny, "select ID from EMP.CHILD", goldenFile, "id1", true, false);
        this.sqlExecuteVerify(tk, "select ID from EMP.PARENT", goldenFile, "id1", true, false);
        this.sqlExecuteVerify(tk, "select ID from EMP.CHILD", goldenFile, "id1", true, false);
        this.sqlExecuteVerify(hk, "select ID from EMP.PARENT", goldenFile, "id1", true, false);
        this.sqlExecuteVerify(hk, "select ID from EMP.CHILD", goldenFile, "id1", true, false);
        this.executeSql(ln, "Update EMP.PARENT set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.executeSql(ln, "Update EMP.CHILD set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.PARENT", goldenFile, "id2", true, false);
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.CHILD", goldenFile, "id2", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.serverExecute(9, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(9, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(9, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.PARENT", goldenFile, "id2", true, false);
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.CHILD", goldenFile, "id2", true, false);
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.PARENT", goldenFile, "id2", true, false);
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.CHILD", goldenFile, "id2", true, false);
        this.sqlExecuteVerify(hk, "select DESCRIPTION from EMP.PARENT", goldenFile, "id2", true, false);
        this.sqlExecuteVerify(hk, "select DESCRIPTION from EMP.CHILD", goldenFile, "id2", true, false);
        this.executeSql(ln, "Delete from  EMP.CHILD where DESCRIPTION = 'Second'");
        this.executeSql(ln, "Delete from  EMP.PARENT where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.PARENT", goldenFile, "empty", true, false);
        this.sqlExecuteVerify(ln, "select DESCRIPTION from EMP.CHILD", goldenFile, "empty", true, false);
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(8, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.serverExecute(9, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERA", 0));
        this.serverExecute(9, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERB", 0));
        this.serverExecute(9, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDERC", 0));
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.PARENT", goldenFile, "empty", true, false);
        this.sqlExecuteVerify(ny, "select DESCRIPTION from EMP.CHILD", goldenFile, "empty", true, false);
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.PARENT", goldenFile, "empty", true, false);
        this.sqlExecuteVerify(tk, "select DESCRIPTION from EMP.CHILD", goldenFile, "empty", true, false);
        this.sqlExecuteVerify(hk, "select DESCRIPTION from EMP.PARENT", goldenFile, "empty", true, false);
        this.sqlExecuteVerify(hk, "select DESCRIPTION from EMP.CHILD", goldenFile, "empty", true, false);
    }

    public void launchInsertThread(final VM ln, final int i) {
        Thread t = new Thread(){

            @Override
            public void run() {
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"insert into EMP.PARENT values (" + i + ", 'First', 'J 604')", true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"insert into EMP.CHILD values (" + i + ", 'First', 'J 604')", true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"insert into EMP.PARENT values (" + (100 + i) + ", 'First', 'J 604')", true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"insert into EMP.CHILD values (" + (100 + i) + ", 'First', 'J 604')", true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"Update EMP.PARENT set DESCRIPTION = 'Second' where ID = " + i, true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"Update EMP.CHILD set DESCRIPTION = 'Second' where ID = " + i, true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"Delete from  EMP.CHILD where ID = " + i, true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"Delete from  EMP.PARENT where ID = " + i, true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"Update EMP.PARENT set DESCRIPTION = 'Second' where ID = " + (100 + i), true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"Update EMP.CHILD set DESCRIPTION = 'Second' where ID = " + (100 + i), true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"Delete from  EMP.CHILD where ID = " + (100 + i), true, false});
                ln.invoke(TestUtil.class, "sqlExecute", new Object[]{"Delete from  EMP.PARENT where ID = " + (100 + i), true, false});
            }
        };
        t.start();
    }

    public void testBug42962() throws Exception {
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        Runnable createRecevier = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createRecevier);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        props.put("skip-listeners", "true");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM reciever = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        this.executeSql(reciever, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        String createTable = "create table emp.TESTTABLE (id int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (id) )redundancy 1  gatewaysender (MYSENDER) server groups (sg1) ";
        this.executeSql(reciever, createTable + this.getSQLSuffixClause());
        this.executeSql(sender, createTable + this.getSQLSuffixClause());
        this.executeSql(reciever, "create index emp.i1 on emp.testtable(tid)");
        this.executeSql(sender, "insert into EMP.TESTTABLE values (1, 'name_1','" + new Date(System.currentTimeMillis()) + "', 'J 604',1)");
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        for (int i = 2; i < 10; ++i) {
            this.executeSql(sender, "insert into EMP.TESTTABLE values (" + i + ", 'name_" + i + "','" + new Date(System.currentTimeMillis()) + "', 'J 604'," + i + ")");
        }
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.executeSql(reciever, "create index emp.i2 on emp.testtable(cust_name)");
    }

    public void testConcurrentDML_DDL_Bug42930() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        Runnable createRecevier = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createRecevier);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        props.put("skip-listeners", "true");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        VM reciever = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        this.executeSql(reciever, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        String createTable = "create table emp.TESTTABLE (id int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (id) )redundancy 1  gatewaysender (MYSENDER) server groups (sg1) ";
        this.executeSql(reciever, createTable + this.getSQLSuffixClause());
        this.executeSql(sender, createTable + this.getSQLSuffixClause());
        this.executeSql(reciever, "create index emp.i1 on emp.testtable(tid)");
        this.serverExecute(3, (Runnable)new SerializableRunnable("install observer"){

            public void run() {
                bugtester = new Bug42930Tester("emp.i1", "tid");
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)bugtester);
            }
        });
        this.serverExecute(5, (Runnable)new SerializableRunnable("install observer"){

            public void run() {
                bugtester = new Bug42930Tester("emp.i2", "tid");
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)bugtester);
            }
        });
        this.executeSql(sender, "insert into EMP.TESTTABLE values (1, 'name_1','" + new Date(System.currentTimeMillis()) + "', 'J 604',1)");
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.serverExecute(3, (Runnable)new SerializableRunnable("check callback invoked"){

            public void run() {
                TestCase.assertTrue((boolean)bugtester.cbInvoked);
                try {
                    bugtester.indxCreator.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.serverExecute(5, (Runnable)new SerializableRunnable("check callback invoked"){

            public void run() {
                TestCase.assertTrue((boolean)bugtester.cbInvoked);
                try {
                    bugtester.indxCreator.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.sqlExecuteVerify(reciever, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
    }

    public void testBasicDMLOperationPropagationToWanSitesOnReplicatedTableWithDDLReplay() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        Runnable createReceiver = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createReceiver);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM receiver = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        this.executeSql(receiver, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        String createTable = "create table EMP.TESTTABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024)) replicate gatewaysender (MYSENDER) server groups (sg1) ";
        this.executeSql(receiver, createTable + this.getSQLSuffixClause());
        this.executeSql(sender, createTable + this.getSQLSuffixClause());
        this.serverExecute(4, GfxdSerialWanDUnit.batchInsert());
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(receiver, "select ID from EMP.TESTTABLE", goldenFile, "id1", true, false);
        this.executeSql(sender, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "id2", true, false);
        this.executeSql(sender, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
        this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
        this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "empty", true, false);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async5 = this.invokeStartServerVM(1, 0, "sg1", props);
        this.joinVMs(true, async5);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 5 ? 1 : 0) != 0);
        this.serverExecute(5, (Runnable)new SerializableRunnable(){

            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getExisting();
                GatewayReceiver receiver = cache.getGatewayReceiver("MYRCVR");
                TestCase.assertNotNull((Object)receiver);
                TestCase.assertTrue((boolean)receiver.isRunning());
            }
        });
    }

    public void testBatchOperationPropagationToWanSites_45652() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        Properties props = new Properties();
        int lnPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props.put("sys-disk-dir", this.getUniqueName() + "1");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", lnPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 1 ? 1 : 0) != 0);
        int nyPort = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
        props = new Properties();
        props.put("sys-disk-dir", this.getUniqueName() + "2");
        props.setProperty("mcast-port", "0");
        props.setProperty("distributed-system-id", "2");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        props.setProperty("remote-locators", "localhost[" + lnPort + "]");
        this.startLocatorVM("localhost", nyPort, null, props);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 2 ? 1 : 0) != 0);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + nyPort + "]");
        DistributedSQLTestBase.AsyncVM async3 = this.invokeStartServerVM(3, 0, "sg1", props);
        this.joinVMs(true, async3);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 3 ? 1 : 0) != 0);
        Runnable createRecevier = GfxdSerialWanDUnit.createGatewayReceiver(0, 0);
        this.serverExecute(3, createRecevier);
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        DistributedSQLTestBase.AsyncVM async4 = this.invokeStartServerVM(4, 0, "sg1", props);
        this.joinVMs(true, async4);
        GfxdSerialWanDUnit.assertTrue((this.serverVMs.size() == 4 ? 1 : 0) != 0);
        this.serverExecute(4, GfxdSerialWanDUnit.createGatewaySender("mySender", "2", "sg1"));
        VM receiver = (VM)this.serverVMs.get(2);
        VM sender = (VM)this.serverVMs.get(3);
        this.executeSql(receiver, "create schema EMP");
        this.executeSql(sender, "create schema EMP");
        for (int i = 1; i <= 2; ++i) {
            String genStr = i == 1 ? "" : " generated always as identity";
            String createTable = "create table EMP.TESTTABLE (ID bigint" + genStr + ", DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024), " + "primary key (ID)) gatewaysender (MYSENDER) server groups (sg1) ";
            this.executeSql(receiver, createTable + this.getSQLSuffixClause());
            this.executeSql(sender, createTable + this.getSQLSuffixClause());
            this.serverExecute(4, GfxdSerialWanDUnit.batchPrepInsert(i == 1));
            this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
            this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "batch_id1", true, false);
            this.serverExecute(4, GfxdSerialWanDUnit.batchNonPrepInsert(i == 1));
            this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
            this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "batch_id2", true, false);
            this.executeSql(sender, "Update EMP.TESTTABLE set DESCRIPTION = 'Second' where DESCRIPTION = 'First'");
            this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "batch_id3", true, false);
            this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
            this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "batch_id3", true, false);
            this.executeSql(sender, "Delete from  EMP.TESTTABLE where DESCRIPTION = 'Second'");
            this.sqlExecuteVerify(sender, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "batch_id4", true, false);
            this.serverExecute(4, (Runnable)GfxdSerialWanDUnit.getExecutorToWaitForQueuesToDrain("MYSENDER", 0));
            this.sqlExecuteVerify(receiver, "select DESCRIPTION from EMP.TESTTABLE", goldenFile, "batch_id4", true, false);
            this.executeSql(sender, "drop table emp.testtable");
            this.executeSql(receiver, "drop table emp.testtable");
        }
    }

    @Override
    public void sqlExecuteVerify(VM vm, String sql, String goldenTextFile, String resultSetID, boolean usePrepStmt, boolean checkTypeInfo) throws Exception {
        this.execute(vm, sql, true, goldenTextFile, resultSetID, null, null, null, usePrepStmt, checkTypeInfo, false);
    }

    @Override
    public void executeSql(VM vm, String sql) throws Exception {
        this.executeSql(vm, sql, false);
    }

    @Override
    public void executeSql(VM vm, String sql, boolean doVerify) throws Exception {
        if (this.isDefaultOffHeapConfigured()) {
            vm.invoke(GfxdSerialWanDUnit.setOffHeapProperty());
        }
        this.execute(vm, sql, doVerify, null, null, null, null, null, true, false, false);
    }

    private static Runnable setOffHeapProperty() {
        SerializableRunnable csr = new SerializableRunnable("offheap propery setter"){

            public void run() throws CacheException {
                System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
                System.setProperty("gemfire.off-heap-memory-size", "500m");
            }
        };
        return csr;
    }

    public static Runnable setObserver(final List<?> rcvrKeys) {
        SerializableRunnable receiverConf = new SerializableRunnable("Configurator"){

            public void run() throws CacheException {
                GemFireXDQueryObserverAdapter sqo = new GemFireXDQueryObserverAdapter(){
                    private volatile int k = 0;

                    public long overrideUniqueID(long actualUniqueID, boolean forRegionKey) {
                        if (forRegionKey && this.k < rcvrKeys.size()) {
                            long newID = (Long)rcvrKeys.get(this.k++);
                            DistributedTestBase.getGlobalLogger().info((Object)("For actual uniqueID=" + actualUniqueID + " overriding with ID=" + newID + ", k=" + this.k));
                            return newID;
                        }
                        return actualUniqueID;
                    }
                };
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)sqo);
            }
        };
        return receiverConf;
    }

    public static Runnable unsetObserver() {
        SerializableRunnable receiverConf = new SerializableRunnable("Configurator"){

            public void run() throws CacheException {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            }
        };
        return receiverConf;
    }

    public static Runnable createGatewayReceiverDefault() {
        SerializableRunnable receiverConf = new SerializableRunnable("Receiver Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    StringBuilder str = new StringBuilder();
                    str.append("CREATE GATEWAYRECEIVER proxy_reciever_1 server groups ( proxy )");
                    st.execute(str.toString());
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return receiverConf;
    }

    public static Runnable createGatewayReceiver(final int startPort, final int endPort) {
        SerializableRunnable receiverConf = new SerializableRunnable("Receiver Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    StringBuilder str = new StringBuilder();
                    str.append("create gatewayreceiver myrcvr");
                    if (startPort != 0) {
                        str.append("( startport " + startPort);
                    } else {
                        str.append("( startport 5000");
                    }
                    if (endPort != 0) {
                        str.append(" endport " + endPort + ")");
                    } else {
                        str.append(" endport 5500)");
                    }
                    str.append(" server groups (sg1)");
                    st.execute(str.toString());
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return receiverConf;
    }

    public static Runnable createConfiguration1() {
        SerializableRunnable receiverConf = new SerializableRunnable("Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    StringBuilder str = new StringBuilder();
                    str.append("CREATE DISKSTORE STORE1");
                    st.execute(str.toString());
                    st = conn.createStatement();
                    str = new StringBuilder();
                    str.append("CREATE GATEWAYSENDER SENDER1 ( REMOTEDSID 2  ENABLEPERSISTENCE true  DISKSTORENAME STORE1 manualstart true) SERVER GROUPS (DEMOGOUP)");
                    st.execute(str.toString());
                    st = conn.createStatement();
                    str = new StringBuilder();
                    str.append("CREATE TABLE CALL_LOG ( CALL_ID VARCHAR(50) NOT NULL, CALL_CENTER VARCHAR(10) NOT NULL,CALLER_NAME VARCHAR(50) NOT NULL,  CALL_DETAIL VARCHAR(500) NOT NULL, CALLED_AT TIMESTAMP NOT NULL,CALL_STATUS VARCHAR(10) NOT NULL, PRIMARY KEY (CALL_ID) ) replicate SERVER GROUPS (DEMOGOUP) GATEWAYSENDER (SENDER1)");
                    st.execute(str.toString());
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return receiverConf;
    }

    public static Runnable startSender() {
        SerializableRunnable receiverConf = new SerializableRunnable("Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    StringBuilder str = new StringBuilder();
                    str.append("CALL SYS.START_GATEWAYSENDER ('SENDER1')");
                    st.execute(str.toString());
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return receiverConf;
    }

    public static Runnable createConfiguration2() {
        SerializableRunnable receiverConf = new SerializableRunnable("Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    StringBuilder str = new StringBuilder();
                    st = conn.createStatement();
                    str = new StringBuilder();
                    str.append("CREATE GATEWAYRECEIVER RECEIVER2 ( STARTPORT 7785  ENDPORT 7789) SERVER GROUPS (DEMOGOUP)");
                    st.execute(str.toString());
                    st = conn.createStatement();
                    str = new StringBuilder();
                    str.append("CREATE TABLE CALL_LOG ( CALL_ID VARCHAR(50) NOT NULL, CALL_CENTER VARCHAR(10) NOT NULL,CALLER_NAME VARCHAR(50) NOT NULL,  CALL_DETAIL VARCHAR(500) NOT NULL, CALLED_AT TIMESTAMP NOT NULL,CALL_STATUS VARCHAR(10) NOT NULL, PRIMARY KEY (CALL_ID) ) replicate SERVER GROUPS (DEMOGOUP)");
                    st.execute(str.toString());
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return receiverConf;
    }

    public static Runnable addListener() {
        SerializableRunnable listConf = new SerializableRunnable("LISTENER Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    CallableStatement cs = conn.prepareCall("CALL SYS.ADD_LISTENER(?,?,?,?,?,?)");
                    cs.setString(1, "USERTABLELISTENER");
                    cs.setString(2, "EMP");
                    cs.setString(3, "TESTTABLE");
                    cs.setString(4, "com.pivotal.gemfirexd.wan.RouterListener");
                    cs.setString(5, "");
                    cs.setString(6, "");
                    cs.execute();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return listConf;
    }

    public static Runnable createGatewaySender(final String id, final String remoteDs, final String serverGroups) {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                String expectedEx = id.toUpperCase() + ": Could not connect";
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    StringBuilder str = new StringBuilder();
                    TestUtil.addExpectedException(expectedEx);
                    str.append("CREATE gatewaysender " + id + " (remotedsid " + remoteDs + " manualstart false) server groups (" + serverGroups + ") ");
                    st.execute(str.toString());
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
                finally {
                    TestUtil.removeExpectedException(expectedEx);
                }
            }
        };
        return senderConf;
    }

    public static Runnable createGatewaySenderDefault() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                String defaultID = "sender_proxy_1";
                String expectedEx = defaultID.toUpperCase() + ": Could not connect";
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    StringBuilder str = new StringBuilder();
                    TestUtil.addExpectedException(expectedEx);
                    str.append("CREATE GATEWAYSENDER " + defaultID + " (REMOTEDSID 2 MANUALSTART false  ENABLEBATCHCONFLATION true" + " BATCHSIZE 4  BATCHTIMEINTERVAL 60000 ENABLEPERSISTENCE false" + "  MAXQUEUEMEMORY 100 ) SERVER GROUPS ( proxy_1 )");
                    st.execute(str.toString());
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
                finally {
                    TestUtil.removeExpectedException(expectedEx);
                }
            }
        };
        return senderConf;
    }

    public static Runnable batchInsert() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    st.addBatch("insert into EMP.TESTTABLE values (1, 'First', 'J 604')");
                    st.executeBatch();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable inserts() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    st.execute("insert into EMP.TESTTABLE (DESCRIPTION, ADDRESS) values ('First')");
                    st.execute("insert into EMP.TESTTABLE (DESCRIPTION, ADDRESS) values ('Second')");
                    st.execute("insert into EMP.TESTTABLE (DESCRIPTION, ADDRESS) values ('Third')");
                    st.execute("insert into EMP.TESTTABLE (DESCRIPTION, ADDRESS) values ('Fourth')");
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable updates() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    st.execute("update EMP.TESTTABLE set DESCRIPTION ='Fifth' where ID=5");
                    st.execute("update EMP.TESTTABLE set DESCRIPTION ='Sixth' where ID=6");
                    st.execute("update EMP.TESTTABLE set DESCRIPTION ='Seventh' where ID=7");
                    st.execute("update EMP.TESTTABLE set DESCRIPTION ='Eighth' where ID=8");
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable batchPrepInsert(final boolean insertId) {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    PreparedStatement pstmt;
                    Connection conn = TestUtil.jdbcConn;
                    if (insertId) {
                        pstmt = conn.prepareStatement("insert into EMP.TESTTABLE (DESCRIPTION, ID) values (?, ?)");
                        pstmt.setString(1, "First");
                        pstmt.setInt(2, 1);
                        pstmt.addBatch();
                        pstmt.setString(1, "Second");
                        pstmt.setInt(2, 2);
                        pstmt.addBatch();
                        pstmt.setString(1, "Third");
                        pstmt.setInt(2, 3);
                        pstmt.addBatch();
                    } else {
                        pstmt = conn.prepareStatement("insert into EMP.TESTTABLE (DESCRIPTION) values (?)");
                        pstmt.setString(1, "First");
                        pstmt.addBatch();
                        pstmt.setString(1, "Second");
                        pstmt.addBatch();
                        pstmt.setString(1, "Third");
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable batchNonPrepInsert(final boolean insertId) {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement stmt = conn.createStatement();
                    if (insertId) {
                        stmt.addBatch("insert into EMP.TESTTABLE (DESCRIPTION, ID) values ('Fourth', 4)");
                        stmt.addBatch("insert into EMP.TESTTABLE (DESCRIPTION, ID, ADDRESS) values ('Fifth', 5, 'J 605')");
                        stmt.addBatch("insert into EMP.TESTTABLE (ID, DESCRIPTION, ADDRESS) values (6, 'Sixth', 'J 606')");
                    } else {
                        stmt.addBatch("insert into EMP.TESTTABLE (DESCRIPTION) values ('Fourth')");
                        stmt.addBatch("insert into EMP.TESTTABLE (DESCRIPTION, ADDRESS) values ('Fifth', 'J 605')");
                        stmt.addBatch("insert into EMP.TESTTABLE (DESCRIPTION, ADDRESS) values ('Sixth', 'J 606')");
                    }
                    stmt.executeBatch();
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable doInserts() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    st.execute("insert into CALL_LOG values ('A','pune','yogs','status',timestamp('1992-01-01 12:30:30'), 'incomplete')");
                    DistributedTestBase.pause((int)5000);
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    public static Runnable doUpdates() {
        SerializableRunnable senderConf = new SerializableRunnable("Sender Configurator"){

            public void run() throws CacheException {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    st.execute("update CALL_LOG set call_status ='complete' where call_id='A'");
                    DistributedTestBase.pause((int)2000);
                }
                catch (SQLException sqle) {
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
                }
            }
        };
        return senderConf;
    }

    private static SerializableRunnable verifyRegionSize(final String regionName, int regionSize) {
        SerializableRunnable verifyRegionSize = new SerializableRunnable("waitForQueueToDrain"){

            public void run() throws CacheException {
                Region r = Misc.getGemFireCache().getRegion(regionName);
                Misc.getGemFireCache().getLogger().fine("YOGS Region " + r.entrySet());
            }
        };
        return verifyRegionSize;
    }

    private static SerializableRunnable getExecutorToWaitForQueuesToDrain(final String senderId, final int regionSize) {
        SerializableRunnable waitForQueueToDrain = new SerializableRunnable("waitForQueueToDrain"){

            public void run() throws CacheException {
                AbstractGatewaySenderEventProcessor processor;
                Set senders = Misc.getGemFireCache().getAllGatewaySenders();
                Misc.getGemFireCache().getLogger().fine("Inside waitForQueueToDrain for sender " + senderId + " all senders in cache are " + senders);
                SerialGatewaySenderImpl sender = null;
                for (GatewaySender s : senders) {
                    if (!s.getId().equals(senderId)) continue;
                    sender = (SerialGatewaySenderImpl)s;
                    break;
                }
                if ((processor = sender.getEventProcessor()) == null) {
                    return;
                }
                final Region region = processor.getQueue().getRegion();
                DistributedTestBase.WaitCriterion wc = new DistributedTestBase.WaitCriterion(){

                    public boolean done() {
                        if (region.keySet().size() == regionSize) {
                            Misc.getGemFireCache().getLogger().fine("Inside waitForQueueToDrain for sender " + senderId + " queue is drained and empty ");
                            return true;
                        }
                        Misc.getGemFireCache().getLogger().fine("Inside waitForQueueToDrain for sender " + senderId + " queue is not yet drained " + region.keySet().size());
                        return false;
                    }

                    public String description() {
                        return "Expected queue entries: " + regionSize + " but actual entries: " + region.keySet().size();
                    }
                };
                DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)60000L, (long)500L, (boolean)true);
            }
        };
        return waitForQueueToDrain;
    }

    public static void batchInsert_NoPrimaryKey() {
        try {
            Connection conn = TestUtil.jdbcConn;
            Statement st = conn.createStatement();
            st.addBatch("insert into EMP.REPLICATED_TABLE values (1, 'First', 'A 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (2, 'First', 'B 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (3, 'First', 'C 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (4, 'First', 'D 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (5, 'First', 'E 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (6, 'First', 'F 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (7, 'First', 'G 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (8, 'First', 'H 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (9, 'First', 'I 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (10, 'First', 'K 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (1, 'Second', 'J 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (2, 'Second', 'J 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (3, 'Second', 'J 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (4, 'Second', 'J 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (5, 'Second', 'J 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (6, 'Second', 'J 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (7, 'Second', 'J 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (8, 'Second', 'J 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (9, 'Second', 'J 604')");
            st.addBatch("insert into EMP.REPLICATED_TABLE values (10, 'Second', 'J 604')");
            st.executeBatch();
        }
        catch (SQLException sqle) {
            throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
        }
    }

    private static class Bug42930Tester
    extends GemFireXDQueryObserverAdapter {
        final String indexName;
        volatile boolean cbInvoked = false;
        final String field;
        private volatile Thread indxCreator;
        private volatile int onEventCount = 0;
        private final Runnable runnable;

        Bug42930Tester(String name, String fieldName) {
            this.indexName = name;
            this.field = fieldName;
            this.runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn = TestUtil.getConnection();
                        Statement stmt = conn.createStatement();
                        if (Bug42930Tester.this.onEventCount % 2 == 0) {
                            stmt.execute("create index " + Bug42930Tester.this.indexName + " on emp.testtable (" + Bug42930Tester.this.field + ")");
                        } else {
                            stmt.execute(" drop index " + Bug42930Tester.this.indexName);
                        }
                    }
                    catch (Exception e) {
                        throw new GemFireXDRuntimeException((Throwable)e);
                    }
                }
            };
        }

        public void beforeIndexUpdatesAtRegionLevel(LocalRegion owner, EntryEventImpl event, RegionEntry entry) {
            this.cbInvoked = true;
            this.indxCreator = new Thread(this.runnable);
            this.indxCreator.start();
            try {
                this.indxCreator.join(10000L);
            }
            catch (InterruptedException e) {
                throw new GemFireXDRuntimeException((Throwable)e);
            }
            ++this.onEventCount;
        }
    }
}

