/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.wan;

import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.wan.GfxdWanCommonTestBase;

public class GfxdSerialWanBULKStrDUnit
extends GfxdWanCommonTestBase {
    private static final long serialVersionUID = 1L;

    public GfxdSerialWanBULKStrDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected String getCreateGatewayDML() {
        return "CREATE gatewaysender MySender (remotedsid 2 ) server groups (sgSender)";
    }

    public void testDAP_ReplicatedRegion() throws Exception {
        String goldenFile = TestUtil.getResourcesDir() + "/lib/GemFireXDGatewayDUnit.xml";
        this.startSites(2);
        this.addExpectedException(new String[]{"A", "B"}, new Object[]{PRLocallyDestroyedException.class});
        String createGWR = "create gatewayreceiver myrcvr() server groups(sgSender)";
        this.executeSql("B", "create gatewayreceiver myrcvr() server groups(sgSender)");
        String createGWS = this.getCreateGatewayDML();
        this.executeSql("A", createGWS);
        String createPTable = "create table EMP.REPLICATED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'VMWARE',primary key (ID)) REPLICATE server groups (sg1)";
        this.executeSql("A", "create table EMP.REPLICATED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'VMWARE',primary key (ID)) REPLICATE server groups (sg1) GatewaySender (MySender)" + this.getSQLSuffixClause());
        this.executeSql("B", "create table EMP.REPLICATED_TABLE (ID int , DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null, COMPANY varchar(1024) DEFAULT 'VMWARE',primary key (ID)) REPLICATE server groups (sg1)" + this.getSQLSuffixClause());
        this.serverExecute(4, GfxdSerialWanBULKStrDUnit.wanInsertDAP("EMP.REPLICATED_TABLE"));
        this.sqlExecuteVerify("A", "select DESCRIPTION from EMP.REPLICATED_TABLE", goldenFile, "batch_id2", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select DESCRIPTION from EMP.REPLICATED_TABLE", goldenFile, "batch_id2", true, false);
        String wanUpdateDAP = "CREATE PROCEDURE wan_update_dap(IN inParam1 VARCHAR(50)) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA EXTERNAL NAME '" + GfxdWanCommonTestBase.class.getName() + ".wanUpdateDAP'";
        this.serverExecute(4, GfxdSerialWanBULKStrDUnit.callDAP(wanUpdateDAP, "EMP.REPLICATED_TABLE"));
        this.sqlExecuteVerify("A", "select COMPANY from EMP.REPLICATED_TABLE ORDER BY ID", goldenFile, "batch_id8", true, false);
        this.executeSql("A", "call SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('MYSENDER', 0, 0)");
        this.sqlExecuteVerify("B", "select COMPANY from EMP.REPLICATED_TABLE ORDER BY ID", goldenFile, "batch_id8", true, false);
    }
}

