/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.transactions;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TransactionRRHDFSTableDUnit
extends DistributedSQLTestBase {
    private static final long serialVersionUID = 1L;

    public TransactionRRHDFSTableDUnit(String name) {
        super(name);
    }

    @Override
    public void shutDownAll() throws Exception {
        try {
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("drop hdfsstore if exists txhdfs");
            st.close();
            conn.commit();
            TransactionRRHDFSTableDUnit.delete(new File("./txhdfs"));
        }
        catch (Exception e) {
            this.getLogWriter().error((Object)("UNEXPECTED exception in tearDown: " + e), (Throwable)e);
        }
        super.shutDownAll();
    }

    public void testTransactionalInsertOnHDFSTableWithCustomEviction() throws Exception {
        this.startVMs(1, 3);
        String homeDir = new File(".", "txhdfs").getAbsolutePath();
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        this.checkDirExistence(homeDir);
        st.execute("create hdfsstore txhdfs namenode 'localhost' homedir '" + homeDir + "' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1)) " + this.getSuffix() + "eviction by criteria ( c2 > 10 ) EVICT INCOMING");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st.execute("insert into tran.t1 values (10, 10)");
        st.execute("insert into tran.t1 values (20, 20)");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionRRHDFSTableDUnit.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionRRHDFSTableDUnit.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        st.execute("update tran.t1 set c2= 30 where c1 > 20");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionRRHDFSTableDUnit.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        rs = st.executeQuery("Select * from tran.t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionRRHDFSTableDUnit.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        st.execute("drop table tran.t1");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testTransactionalInsertOnHDFSTable() throws Exception {
        this.startVMs(1, 3);
        String homeDir = new File(".", "txhdfs").getAbsolutePath();
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        this.checkDirExistence(homeDir);
        st.execute("create hdfsstore txhdfs namenode 'localhost' homedir '" + homeDir + "' queuepersistent true");
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1)) " + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st.execute("insert into tran.t1 values (10, 10)");
        conn.rollback();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        TransactionRRHDFSTableDUnit.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into tran.t1 values (10, 10)");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionRRHDFSTableDUnit.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        st.execute("delete from tran.t1 where c2 =10");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        TransactionRRHDFSTableDUnit.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("drop table tran.t1");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testRepeatableReadSmall() throws Exception {
        this.startVMs(1, 3);
        String homeDir = new File(".", "txhdfs").getAbsolutePath();
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        this.checkDirExistence(homeDir);
        st.execute("create hdfsstore txhdfs namenode 'localhost' homedir '" + homeDir + "' queuepersistent true");
        st.execute("Create table tran.t1 (c1 int not null, c2 int not null, primary key(c1)) partition by primary key redundancy 2 persistent hdfsstore (txhdfs)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        PreparedStatement pstmt = conn.prepareStatement("insert into tran.t1 values (?, ?)");
        for (int c1 = 10; c1 <= 100; c1 += 10) {
            pstmt.setInt(1, c1);
            pstmt.setInt(2, c1 / 2);
            pstmt.execute();
        }
        conn.commit();
        Connection conn2 = TestUtil.getConnection();
        conn2.setTransactionIsolation(this.getIsolationLevel());
        conn2.setAutoCommit(false);
        PreparedStatement pstmt2 = conn2.prepareStatement("select * from tran.t1 where c1 = ?");
        for (int c1 = 10; c1 <= 100; c1 += 10) {
            System.out.println("Executing for c1 " + c1);
            pstmt2.setInt(1, c1);
            ResultSet rs = pstmt2.executeQuery();
            TransactionRRHDFSTableDUnit.assertTrue((boolean)rs.next());
            TransactionRRHDFSTableDUnit.assertEquals((int)c1, (int)rs.getInt(1));
            TransactionRRHDFSTableDUnit.assertEquals((int)(c1 / 2), (int)rs.getInt(2));
            TransactionRRHDFSTableDUnit.assertFalse((boolean)rs.next());
        }
        conn2.commit();
        TransactionRRHDFSTableDUnit.assertEquals((int)3, (int)st.executeUpdate("delete from tran.t1 where c1 > 70"));
        conn.commit();
        TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (80, 40)"));
        conn.commit();
        st.execute("drop table tran.t1");
        conn.commit();
        conn.close();
    }

    public void testRepeatableRead() throws Exception {
        ResultSet rs;
        PreparedStatement pstmt2;
        Connection conn2;
        Statement st;
        Connection conn;
        block22: {
            block21: {
                block20: {
                    block19: {
                        this.startVMs(1, 3);
                        String homeDir = new File(".", "txhdfs").getAbsolutePath();
                        conn = TestUtil.jdbcConn;
                        st = conn.createStatement();
                        this.checkDirExistence(homeDir);
                        st.execute("create hdfsstore txhdfs namenode 'localhost' homedir '" + homeDir + "' queuepersistent true");
                        st.execute("Create table tran.t1 (c1 int not null, c2 int not null, primary key(c1)) partition by primary key redundancy 2 persistent hdfsstore (txhdfs)");
                        conn.commit();
                        conn.setTransactionIsolation(this.getIsolationLevel());
                        conn.setAutoCommit(false);
                        PreparedStatement pstmt = conn.prepareStatement("insert into tran.t1 values (?, ?)");
                        for (int c1 = 10; c1 <= 100; c1 += 10) {
                            pstmt.setInt(1, c1);
                            pstmt.setInt(2, c1 / 2);
                            pstmt.execute();
                        }
                        conn.commit();
                        conn2 = TestUtil.getConnection();
                        conn2.setTransactionIsolation(this.getIsolationLevel());
                        conn2.setAutoCommit(false);
                        pstmt2 = conn2.prepareStatement("select * from tran.t1 where c1 = ?");
                        for (int c1 = 50; c1 <= 80; c1 += 10) {
                            pstmt2.setInt(1, c1);
                            rs = pstmt2.executeQuery();
                            TransactionRRHDFSTableDUnit.assertTrue((boolean)rs.next());
                            TransactionRRHDFSTableDUnit.assertEquals((int)c1, (int)rs.getInt(1));
                            TransactionRRHDFSTableDUnit.assertEquals((int)(c1 / 2), (int)rs.getInt(2));
                            TransactionRRHDFSTableDUnit.assertFalse((boolean)rs.next());
                        }
                        st = conn.createStatement();
                        st.execute("delete from tran.t1 where c1 > 70");
                        try {
                            conn.commit();
                            TransactionRRHDFSTableDUnit.fail((String)"expected a conflict exception");
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) break block19;
                            throw sqle;
                        }
                    }
                    for (int c1 = 50; c1 <= 80; c1 += 10) {
                        st.execute("delete from tran.t1 where c1 = " + c1);
                        try {
                            conn.commit();
                            TransactionRRHDFSTableDUnit.fail((String)"expected a conflict exception");
                            continue;
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) continue;
                            throw sqle;
                        }
                    }
                    st.execute("update tran.t1 set c2 = 50 where c1 = 70");
                    try {
                        conn.commit();
                        TransactionRRHDFSTableDUnit.fail((String)"expected a conflict exception");
                    }
                    catch (SQLException sqle) {
                        if ("X0Z02".equals(sqle.getSQLState())) break block20;
                        throw sqle;
                    }
                }
                for (int c1 = 10; c1 <= 100; c1 += 10) {
                    System.out.println("Executing for c1 " + c1);
                    pstmt2.setInt(1, c1);
                    rs = pstmt2.executeQuery();
                    TransactionRRHDFSTableDUnit.assertTrue((boolean)rs.next());
                    TransactionRRHDFSTableDUnit.assertEquals((int)c1, (int)rs.getInt(1));
                    TransactionRRHDFSTableDUnit.assertEquals((int)(c1 / 2), (int)rs.getInt(2));
                    TransactionRRHDFSTableDUnit.assertFalse((boolean)rs.next());
                }
                conn2.commit();
                TransactionRRHDFSTableDUnit.assertEquals((int)3, (int)st.executeUpdate("delete from tran.t1 where c1 > 70"));
                conn.commit();
                TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (80, 40)"));
                TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (90, 45)"));
                TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (100, 50)"));
                conn.commit();
                TransactionRRHDFSTableDUnit.assertEquals((int)3, (int)st.executeUpdate("delete from tran.t1 where c1 > 70"));
                TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (80, 40)"));
                TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (90, 45)"));
                TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (100, 50)"));
                conn.commit();
                Statement st2 = conn2.createStatement();
                rs = st2.executeQuery("select * from tran.t1 where c1 > 40 and c1 <= 80 order by c2");
                for (int c1 = 50; c1 <= 80; c1 += 10) {
                    TransactionRRHDFSTableDUnit.assertTrue((boolean)rs.next());
                    TransactionRRHDFSTableDUnit.assertEquals((int)c1, (int)rs.getInt(1));
                    TransactionRRHDFSTableDUnit.assertEquals((int)(c1 / 2), (int)rs.getInt(2));
                }
                TransactionRRHDFSTableDUnit.assertFalse((boolean)rs.next());
                st.execute("delete from tran.t1 where c1 > 70");
                try {
                    conn.commit();
                    TransactionRRHDFSTableDUnit.fail((String)"expected a conflict exception");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block21;
                    throw sqle;
                }
            }
            for (int c1 = 50; c1 <= 80; c1 += 10) {
                st.execute("delete from tran.t1 where c1 = " + c1);
                try {
                    conn.commit();
                    TransactionRRHDFSTableDUnit.fail((String)"expected a conflict exception");
                    continue;
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) continue;
                    throw sqle;
                }
            }
            st.execute("update tran.t1 set c2 = 50 where c1 = 70");
            try {
                conn.commit();
                TransactionRRHDFSTableDUnit.fail((String)"expected a conflict exception");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) break block22;
                throw sqle;
            }
        }
        for (int c1 = 10; c1 <= 100; c1 += 10) {
            pstmt2.setInt(1, c1);
            rs = pstmt2.executeQuery();
            TransactionRRHDFSTableDUnit.assertTrue((boolean)rs.next());
            TransactionRRHDFSTableDUnit.assertEquals((int)c1, (int)rs.getInt(1));
            TransactionRRHDFSTableDUnit.assertEquals((int)(c1 / 2), (int)rs.getInt(2));
            TransactionRRHDFSTableDUnit.assertFalse((boolean)rs.next());
        }
        conn2.commit();
        TransactionRRHDFSTableDUnit.assertEquals((int)3, (int)st.executeUpdate("delete from tran.t1 where c1 > 70"));
        conn.commit();
        TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (80, 40)"));
        TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (90, 45)"));
        TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (100, 50)"));
        conn.commit();
        TransactionRRHDFSTableDUnit.assertEquals((int)3, (int)st.executeUpdate("delete from tran.t1 where c1 > 70"));
        TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (80, 40)"));
        TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (90, 45)"));
        TransactionRRHDFSTableDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (100, 50)"));
        conn.commit();
        st.execute("drop table tran.t1");
        conn.commit();
        conn.close();
    }

    public void testTXWithHDFSEvictionRR() throws Exception {
        Statement st;
        Connection conn;
        block4: {
            int i;
            this.startVMs(1, 3);
            String homeDir = new File(".", "txhdfs").getAbsolutePath();
            conn = TestUtil.jdbcConn;
            conn.setTransactionIsolation(this.getIsolationLevel());
            conn.setAutoCommit(false);
            st = conn.createStatement();
            this.checkDirExistence(homeDir);
            st.execute("create hdfsstore txhdfs namenode 'localhost' homedir '" + homeDir + "' queuepersistent true");
            st.execute("Create table tran.t1 (c1 int not null, c2 int not null , c3 int not null, constraint uq unique (c2, c3), primary key(c1)) partition by primary key redundancy 2 persistent hdfsstore (txhdfs)");
            conn.commit();
            for (i = 10; i < 100; i += 10) {
                st.executeUpdate("insert into tran.t1 values (" + i + "," + i * 2 + "," + i * 5 + ")");
            }
            conn.commit();
            try {
                for (i = 100; i < 1000; i += 100) {
                    st.executeUpdate("insert into tran.t1 values (" + i + "," + i / 10 * 2 + "," + i / 10 * 5 + ")");
                }
                TransactionRRHDFSTableDUnit.fail((String)"Did not get expected constraint violation exception");
            }
            catch (SQLException e) {
                if ("23505".equals(e.getSQLState())) break block4;
                throw e;
            }
        }
        st.execute("drop table tran.t1");
        conn.commit();
        conn.close();
    }

    public void testTXWithHDFSEvictionRC() throws Exception {
        Statement st;
        Connection conn;
        block2: {
            this.startVMs(1, 3);
            String homeDir = new File(".", "txhdfs").getAbsolutePath();
            conn = TestUtil.jdbcConn;
            conn.setTransactionIsolation(2);
            conn.setAutoCommit(false);
            st = conn.createStatement();
            this.checkDirExistence(homeDir);
            st.execute("create hdfsstore txhdfs namenode 'localhost' homedir '" + homeDir + "' queuepersistent true");
            st.execute("Create table tran.t1 (c1 int not null, c2 int not null , c3 int not null, constraint uq unique (c2, c3), primary key(c1)) partition by primary key redundancy 2 persistent hdfsstore (txhdfs)");
            conn.commit();
            st.executeUpdate("insert into tran.t1 values (10, 20, 30)");
            conn.commit();
            try {
                st.executeUpdate("insert into tran.t1 values (20, 20, 30)");
                TransactionRRHDFSTableDUnit.fail((String)"Did not get expected constraint violation exception");
            }
            catch (SQLException e) {
                if ("23505".equals(e.getSQLState())) break block2;
                throw e;
            }
        }
        st.execute("drop table tran.t1");
        conn.commit();
        conn.close();
    }

    public void testTXWithHDFSEvictionMultiRowRC() throws Exception {
        this.startVMs(1, 3);
        String homeDir = new File(".", "txhdfs").getAbsolutePath();
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(2);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        this.checkDirExistence(homeDir);
        st.execute("create hdfsstore txhdfs namenode 'localhost' homedir '" + homeDir + "' queuepersistent true");
        st.execute("Create table tran.t1 (c1 int not null, c2 int not null , c3 int not null, constraint uq unique (c2, c3), primary key(c1)) partition by primary key redundancy 2 persistent hdfsstore (txhdfs) eviction by criteria ( c3 > 2000 ) EVICT INCOMING");
        conn.commit();
        st.executeUpdate("insert into tran.t1 values (10, 100, 1000)");
        st.executeUpdate("insert into tran.t1 values (20, 200, 2000)");
        st.executeUpdate("insert into tran.t1 values (30, 300, 3000)");
        conn.commit();
        ResultSet rs = st.executeQuery("select * from tran.t1 where c2=300");
        TransactionRRHDFSTableDUnit.assertFalse((boolean)rs.next());
        rs.close();
        conn.commit();
        st.execute("drop table tran.t1");
        conn.commit();
        conn.close();
    }

    protected int getIsolationLevel() {
        return 4;
    }

    private void checkDirExistence(String path) {
        File dir = new File(path);
        if (dir.exists()) {
            TransactionRRHDFSTableDUnit.delete(dir);
        }
    }

    private String getSuffix() {
        return "redundancy 2 persistent hdfsstore (txhdfs)";
    }

    public static void checkData(String regionName, long numEntries) {
        PartitionedRegion r = (PartitionedRegion)Misc.getRegionForTable((String)regionName, (boolean)true);
        long localSize = r.getLocalSize();
        TransactionRRHDFSTableDUnit.assertEquals((String)("Unexpected number of rows in the table " + r.getUserAttribute()), (long)numEntries, (long)localSize);
    }
}

