/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.transactions;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.transactions.TransactionDUnit;
import io.snappydata.test.util.TestException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CyclicBarrier;

public class TransactionRRDUnit
extends TransactionDUnit {
    public TransactionRRDUnit(String name) {
        super(name);
    }

    @Override
    public void test42822() throws Exception {
        Thread t;
        CyclicBarrier barrier;
        Statement stmt;
        Connection conn;
        block4: {
            this.startVMs(1, 3);
            conn = TestUtil.jdbcConn;
            conn.setTransactionIsolation(this.getIsolationLevel());
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt.execute("create table oorder (o_w_id       integer      not null,o_d_id       integer      not null,o_id         integer      not null,o_c_id       integer,o_carrier_id integer,o_ol_cnt     decimal(2,0),o_all_local  decimal(1,0),o_entry_d    timestamp) partition by column (o_w_id)");
            stmt.execute("create index oorder_carrier1 on oorder (o_w_id)");
            stmt.execute("create index oorder_carrier2 on oorder (o_d_id)");
            stmt.execute("create index oorder_carrier3 on oorder (o_c_id)");
            stmt.execute("insert into oorder (o_w_id, o_d_id, o_id, o_c_id) values (1, 2, 2, 1), (2, 4, 4, 2), (3, 6, 6, 3), (4, 8, 8, 4)");
            conn.commit();
            stmt.execute("delete from oorder where o_d_id > 6");
            stmt.execute("update oorder set o_c_id = o_w_id + 2 where o_w_id < 2");
            stmt.execute("update oorder set o_c_id = o_id + 1 where o_w_id >= 3");
            this.threadEx = null;
            barrier = new CyclicBarrier(2);
            t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn = TestUtil.getConnection();
                        conn.setTransactionIsolation(TransactionRRDUnit.this.getIsolationLevel());
                        conn.setAutoCommit(false);
                        TransactionRRDUnit.this.checkResultsFor42822(conn, false);
                        barrier.await();
                        barrier.await();
                        TransactionRRDUnit.this.checkResultsFor42822(conn, false);
                        conn.commit();
                        barrier.await();
                        TransactionRRDUnit.this.checkResultsFor42822(conn, true);
                        conn.commit();
                    }
                    catch (Throwable t) {
                        TransactionRRDUnit.this.getLogWriter().error((Object)"unexpected exception", t);
                        TransactionRRDUnit.this.threadEx = t;
                    }
                }
            });
            t.start();
            this.checkResultsFor42822(conn, true);
            barrier.await();
            if (this.threadEx != null) {
                throw new TestException("unexpected exception in thread", this.threadEx);
            }
            try {
                conn.commit();
                TransactionRRDUnit.fail((String)"expected conflict exception");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) break block4;
                throw sqle;
            }
        }
        this.checkResultsFor42822(conn, false);
        barrier.await();
        stmt.execute("delete from oorder where o_d_id > 6");
        stmt.execute("update oorder set o_c_id = o_w_id + 2 where o_w_id < 2");
        stmt.execute("update oorder set o_c_id = o_id + 1 where o_w_id >= 3");
        this.checkResultsFor42822(conn, true);
        conn.commit();
        this.checkResultsFor42822(conn, true);
        barrier.await();
        t.join();
        if (this.threadEx != null) {
            throw new TestException("unexpected exception in thread", this.threadEx);
        }
    }

    public void testRepeatableRead() throws Exception {
        ResultSet rs;
        PreparedStatement pstmt2;
        Connection conn2;
        Statement st;
        Connection conn;
        block22: {
            block21: {
                block20: {
                    block19: {
                        this.startVMs(1, 3);
                        conn = TestUtil.jdbcConn;
                        st = conn.createStatement();
                        st.execute("Create table tran.t1 (c1 int not null, c2 int not null, primary key(c1)) partition by primary key redundancy 2");
                        conn.commit();
                        conn.setTransactionIsolation(this.getIsolationLevel());
                        conn.setAutoCommit(false);
                        PreparedStatement pstmt = conn.prepareStatement("insert into tran.t1 values (?, ?)");
                        for (int c1 = 10; c1 <= 100; c1 += 10) {
                            pstmt.setInt(1, c1);
                            pstmt.setInt(2, c1 / 2);
                            pstmt.execute();
                        }
                        conn.commit();
                        conn2 = TestUtil.getConnection();
                        conn2.setTransactionIsolation(this.getIsolationLevel());
                        conn2.setAutoCommit(false);
                        pstmt2 = conn2.prepareStatement("select * from tran.t1 where c1 = ?");
                        for (int c1 = 50; c1 <= 80; c1 += 10) {
                            pstmt2.setInt(1, c1);
                            rs = pstmt2.executeQuery();
                            TransactionRRDUnit.assertTrue((boolean)rs.next());
                            TransactionRRDUnit.assertEquals((int)c1, (int)rs.getInt(1));
                            TransactionRRDUnit.assertEquals((int)(c1 / 2), (int)rs.getInt(2));
                            TransactionRRDUnit.assertFalse((boolean)rs.next());
                        }
                        st = conn.createStatement();
                        st.execute("delete from tran.t1 where c1 > 70");
                        try {
                            conn.commit();
                            TransactionRRDUnit.fail((String)"expected a conflict exception");
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) break block19;
                            throw sqle;
                        }
                    }
                    for (int c1 = 50; c1 <= 80; c1 += 10) {
                        st.execute("delete from tran.t1 where c1 = " + c1);
                        try {
                            conn.commit();
                            TransactionRRDUnit.fail((String)"expected a conflict exception");
                            continue;
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) continue;
                            throw sqle;
                        }
                    }
                    st.execute("update tran.t1 set c2 = 50 where c1 = 70");
                    try {
                        conn.commit();
                        TransactionRRDUnit.fail((String)"expected a conflict exception");
                    }
                    catch (SQLException sqle) {
                        if ("X0Z02".equals(sqle.getSQLState())) break block20;
                        throw sqle;
                    }
                }
                for (int c1 = 10; c1 <= 100; c1 += 10) {
                    pstmt2.setInt(1, c1);
                    rs = pstmt2.executeQuery();
                    TransactionRRDUnit.assertTrue((boolean)rs.next());
                    TransactionRRDUnit.assertEquals((int)c1, (int)rs.getInt(1));
                    TransactionRRDUnit.assertEquals((int)(c1 / 2), (int)rs.getInt(2));
                    TransactionRRDUnit.assertFalse((boolean)rs.next());
                }
                conn2.commit();
                TransactionRRDUnit.assertEquals((int)3, (int)st.executeUpdate("delete from tran.t1 where c1 > 70"));
                conn.commit();
                TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (80, 40)"));
                TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (90, 45)"));
                TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (100, 50)"));
                conn.commit();
                TransactionRRDUnit.assertEquals((int)3, (int)st.executeUpdate("delete from tran.t1 where c1 > 70"));
                TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (80, 40)"));
                TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (90, 45)"));
                TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (100, 50)"));
                conn.commit();
                Statement st2 = conn2.createStatement();
                rs = st2.executeQuery("select * from tran.t1 where c1 > 40 and c1 <= 80 order by c2");
                for (int c1 = 50; c1 <= 80; c1 += 10) {
                    TransactionRRDUnit.assertTrue((boolean)rs.next());
                    TransactionRRDUnit.assertEquals((int)c1, (int)rs.getInt(1));
                    TransactionRRDUnit.assertEquals((int)(c1 / 2), (int)rs.getInt(2));
                }
                TransactionRRDUnit.assertFalse((boolean)rs.next());
                st.execute("delete from tran.t1 where c1 > 70");
                try {
                    conn.commit();
                    TransactionRRDUnit.fail((String)"expected a conflict exception");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block21;
                    throw sqle;
                }
            }
            for (int c1 = 50; c1 <= 80; c1 += 10) {
                st.execute("delete from tran.t1 where c1 = " + c1);
                try {
                    conn.commit();
                    TransactionRRDUnit.fail((String)"expected a conflict exception");
                    continue;
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) continue;
                    throw sqle;
                }
            }
            st.execute("update tran.t1 set c2 = 50 where c1 = 70");
            try {
                conn.commit();
                TransactionRRDUnit.fail((String)"expected a conflict exception");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) break block22;
                throw sqle;
            }
        }
        for (int c1 = 10; c1 <= 100; c1 += 10) {
            pstmt2.setInt(1, c1);
            rs = pstmt2.executeQuery();
            TransactionRRDUnit.assertTrue((boolean)rs.next());
            TransactionRRDUnit.assertEquals((int)c1, (int)rs.getInt(1));
            TransactionRRDUnit.assertEquals((int)(c1 / 2), (int)rs.getInt(2));
            TransactionRRDUnit.assertFalse((boolean)rs.next());
        }
        conn2.commit();
        TransactionRRDUnit.assertEquals((int)3, (int)st.executeUpdate("delete from tran.t1 where c1 > 70"));
        conn.commit();
        TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (80, 40)"));
        TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (90, 45)"));
        TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (100, 50)"));
        conn.commit();
        TransactionRRDUnit.assertEquals((int)3, (int)st.executeUpdate("delete from tran.t1 where c1 > 70"));
        TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (80, 40)"));
        TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (90, 45)"));
        TransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("insert into tran.t1 values (100, 50)"));
        conn.commit();
        conn.close();
    }

    @Override
    protected int getIsolationLevel() {
        return 4;
    }

    @Override
    protected void checkConnCloseExceptionForReadsOnly(Connection conn) throws SQLException {
        block2: {
            try {
                conn.close();
                TransactionRRDUnit.fail((String)"expected connection active exception in close");
            }
            catch (SQLException e) {
                String state = e.getSQLState();
                if (state.equals("25001")) break block2;
                throw e;
            }
        }
    }
}

