/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.transactions;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TransactionObserver;
import com.gemstone.gemfire.internal.cache.TransactionObserverAdapter;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.ResourceManagerStats;
import com.gemstone.gemfire.internal.cache.locks.ExclusiveSharedSynchronizer;
import com.gemstone.gnu.trove.TIntHashSet;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.client.ClientXid;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource;
import com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.dunit.standalone.AnyCyclicBarrier;
import io.snappydata.test.util.TestException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.TestCase;
import org.apache.derbyTesting.junit.JDBC;

public class TransactionDUnit
extends DistributedSQLTestBase {
    protected volatile boolean gotConflict = false;
    protected volatile Throwable threadEx;
    protected static volatile boolean failed;
    protected static final String DISKSTORE = "TestPersistenceDiskStore";

    public TransactionDUnit(String name) {
        super(name);
    }

    public void DISABLED_testTransactionalInsertAsSubSelects_diffNullable() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, primary key(c1)) partition by primary key" + this.getSuffix());
        st.execute("create table t2 (c1 int, c2 int, primary key(c1)) partition by primary key" + this.getSuffix());
        st.execute("insert into t1 values (1,1)");
        st.execute("insert into t1 values (2,2)");
        st.execute("insert into t2 select * from t1");
        conn.commit();
        conn = TestUtil.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        ResultSet rs = conn.createStatement().executeQuery("select count(*) from t2");
        TransactionDUnit.assertTrue((boolean)rs.next());
        TransactionDUnit.assertEquals((int)2, (int)rs.getInt(1));
        TransactionDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select * from t2");
        TransactionDUnit.assertTrue((boolean)rs.next());
        TransactionDUnit.assertTrue((rs.getInt(1) == 1 || rs.getInt(1) == 2 ? 1 : 0) != 0);
        TransactionDUnit.assertTrue((rs.getInt(2) == 1 || rs.getInt(2) == 2 ? 1 : 0) != 0);
        TransactionDUnit.assertTrue((boolean)rs.next());
        TransactionDUnit.assertTrue((rs.getInt(1) == 1 || rs.getInt(1) == 2 ? 1 : 0) != 0);
        TransactionDUnit.assertTrue((String)("rs.getInt(2)=" + rs.getInt(2)), (rs.getInt(2) == 1 || rs.getInt(2) == 2 ? 1 : 0) != 0);
        TransactionDUnit.assertFalse((boolean)rs.next());
    }

    public void testTransactionalInsertAsSubSelects() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, primary key(c1)) partition by primary key" + this.getSuffix());
        st.execute("create table t2 (c1 int, c2 int not null, primary key(c1)) partition by primary key" + this.getSuffix());
        st.execute("insert into t1 values (1,1)");
        st.execute("insert into t1 values (2,2)");
        st.execute("insert into t2 select * from t1");
        conn.commit();
        conn = TestUtil.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        ResultSet rs = conn.createStatement().executeQuery("select count(*) from t2");
        TransactionDUnit.assertTrue((boolean)rs.next());
        TransactionDUnit.assertEquals((int)2, (int)rs.getInt(1));
        TransactionDUnit.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select * from t2");
        TransactionDUnit.assertTrue((boolean)rs.next());
        TransactionDUnit.assertTrue((rs.getInt(1) == 1 || rs.getInt(1) == 2 ? 1 : 0) != 0);
        TransactionDUnit.assertTrue((rs.getInt(2) == 1 || rs.getInt(2) == 2 ? 1 : 0) != 0);
        TransactionDUnit.assertTrue((boolean)rs.next());
        TransactionDUnit.assertTrue((rs.getInt(1) == 1 || rs.getInt(1) == 2 ? 1 : 0) != 0);
        TransactionDUnit.assertTrue((rs.getInt(2) == 1 || rs.getInt(2) == 2 ? 1 : 0) != 0);
        TransactionDUnit.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalInsertOnReplicatedTable() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, primary key(c1)) replicate" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        ResultSet rs = st.executeQuery("select * from t1 where c1=10");
        TransactionDUnit.assertFalse((boolean)rs.next());
        st.execute("insert into t1 values (10, 10)");
        conn.rollback();
        rs = st.executeQuery("Select * from t1");
        TransactionDUnit.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into t1 values (10, 10)");
        st.execute("insert into t1 values (20, 20)");
        conn.commit();
        st.execute("insert into t1 values (30, 30)");
        PreparedStatement pstmt = conn.prepareStatement("Select * from t1");
        final long connId = ((EmbedConnection)conn).getConnectionID();
        final long stmtId = ((EmbedPreparedStatement)pstmt).getID();
        final TXId txId = TXManagerImpl.getCurrentTXId();
        TransactionObserverAdapter observer = new TransactionObserverAdapter(){
            private static final long serialVersionUID = 3946313849981555748L;

            public void duringIndividualCommit(TXStateProxy tx, Object callbackArg) {
                GfxdConnectionWrapper wrapper = GfxdConnectionHolder.getHolder().getExistingWrapper(Long.valueOf(connId));
                if (wrapper != null && wrapper.getStatementForTEST(stmtId) != null) {
                    failed = true;
                    TestCase.fail((String)("received non-null statement for ID " + stmtId));
                }
            }
        };
        TransactionDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable((TransactionObserver)observer){
            final /* synthetic */ TransactionObserver val$observer;
            {
                this.val$observer = transactionObserver;
            }

            public void run() {
                TXStateProxy tx;
                failed = false;
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                if (cache != null && (tx = cache.getTxManager().getHostedTXState((TransactionId)txId)) != null) {
                    tx.setObserver(this.val$observer);
                }
            }
        });
        rs = st.executeQuery("select * from t1 where c1=20");
        TransactionDUnit.assertTrue((boolean)rs.next());
        TransactionDUnit.assertEquals((int)20, (int)rs.getInt(1));
        TransactionDUnit.assertEquals((int)20, (int)rs.getInt(2));
        TransactionDUnit.assertFalse((boolean)rs.next());
        rs = pstmt.executeQuery();
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"ResultSet should contain three rows ", (int)3, (int)numRows);
        rs.close();
        st.close();
        try {
            pstmt.close();
            conn.commit();
        }
        catch (Throwable throwable) {
            TransactionDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(txId){
                final /* synthetic */ TXId val$txId;
                {
                    this.val$txId = tXId;
                }

                public void run() {
                    TXStateProxy tx;
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    if (cache != null && (tx = cache.getTxManager().getHostedTXState((TransactionId)this.val$txId)) != null) {
                        tx.setObserver(null);
                    }
                    boolean failure = failed;
                    failed = false;
                    TestCase.assertFalse((String)"unexpected failure for statement close assert", (boolean)failure);
                }
            });
            throw throwable;
        }
        TransactionDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
        conn.close();
    }

    public void testTransactionalInsertOnPartitionedTable() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        st.execute("insert into tran.t1 values (10, 10)");
        st.execute("insert into tran.t1 values (20, 20)");
        conn.rollback();
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        TransactionDUnit.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into tran.t1 values (10, 10)");
        st.execute("insert into tran.t1 values (20, 20)");
        conn.commit();
        rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        VM vm = (VM)this.serverVMs.get(0);
        vm.invoke(((Object)((Object)this)).getClass(), "checkData", new Object[]{"TRAN.T1", 2L});
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    public static void checkData(String regionName, long numEntries) {
        PartitionedRegion r = (PartitionedRegion)Misc.getRegionForTable((String)regionName, (boolean)true);
        long localSize = r.getLocalSize();
        TransactionDUnit.assertEquals((String)("Unexpected number of rows in the table " + r.getUserAttribute()), (long)numEntries, (long)localSize);
    }

    public void testCommitWithConflicts() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))" + this.getSuffix());
        conn.commit();
        this.gotConflict = false;
        conn.setTransactionIsolation(this.getIsolationLevel());
        st.execute("insert into tran.t1 values (10, 10)");
        st.execute("insert into tran.t1 values (20, 10)");
        st.execute("insert into tran.t1 values (30, 10)");
        Region r = Misc.getRegionForTable((String)"TRAN.T1", (boolean)false);
        TransactionDUnit.assertNotNull((Object)r);
        final boolean[] otherTxOk = new boolean[]{false};
        Thread otherTx = new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        Connection otherConn = TestUtil.getConnection();
                        otherConn.setTransactionIsolation(TransactionDUnit.this.getIsolationLevel());
                        otherConn.setAutoCommit(false);
                        Statement otherSt = otherConn.createStatement();
                        try {
                            otherSt.execute("insert into tran.t1 values (10, 20)");
                            otherTxOk[0] = true;
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) {
                                Throwable t = sqle.getCause();
                                while (t.getCause() != null) {
                                    t = t.getCause();
                                }
                                TestCase.assertTrue((boolean)(t instanceof ConflictException));
                                TransactionDUnit.this.gotConflict = true;
                                otherConn.rollback();
                                break block6;
                            }
                            throw sqle;
                        }
                    }
                    catch (SQLException sqle) {
                        TransactionDUnit.this.gotConflict = false;
                        DistributedSQLTestBase.fail("unexpected exception", sqle);
                    }
                }
            }
        });
        otherTx.start();
        otherTx.join();
        TransactionDUnit.assertFalse((boolean)otherTxOk[0]);
        TransactionDUnit.assertTrue((String)"expected conflict", (boolean)this.gotConflict);
        this.gotConflict = false;
        PreparedStatement ps = conn.prepareStatement("select * from tran.t1");
        conn.commit();
        ResultSet rs = ps.executeQuery();
        int[] expectedKeys = new int[]{10, 20, 30};
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            int key = rs.getInt(1);
            int index = Arrays.binarySearch(expectedKeys, key);
            TransactionDUnit.assertTrue((String)("Expected to find the key: " + key), (index >= 0 ? 1 : 0) != 0);
            expectedKeys[index] = -2147483647;
            Arrays.sort(expectedKeys);
            TransactionDUnit.assertEquals((String)"Second column should be 10", (int)10, (int)rs.getInt(2));
        }
        TransactionDUnit.assertEquals((String)"ResultSet should have three rows", (int)3, (int)numRows);
        r.destroy((Object)TestUtil.getGemFireKey(10, r));
        Statement st2 = conn.createStatement();
        st2.execute("insert into tran.t1 values (10, 30)");
        conn.commit();
        expectedKeys = new int[]{10, 20, 30};
        rs = ps.executeQuery();
        numRows = 0;
        while (rs.next()) {
            ++numRows;
            int key = rs.getInt(1);
            int index = Arrays.binarySearch(expectedKeys, key);
            TransactionDUnit.assertTrue((String)("Expected to find the key: " + key), (index >= 0 ? 1 : 0) != 0);
            expectedKeys[index] = -2147483647;
            Arrays.sort(expectedKeys);
            if (key == 10) {
                TransactionDUnit.assertEquals((String)"Second column should be 30 for key 10", (int)30, (int)rs.getInt(2));
                continue;
            }
            TransactionDUnit.assertEquals((String)"Second column should be 10", (int)10, (int)rs.getInt(2));
        }
        TransactionDUnit.assertEquals((String)"ResultSet should have three rows", (int)3, (int)numRows);
        rs.close();
        st2.close();
        conn.commit();
        conn.close();
    }

    public void testCommitOnPartitionedAndReplicatedTables() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, primary key(c1)) replicate" + this.getSuffix());
        st.execute("Create table t2 (c1 int not null , c2 int not null, primary key(c1)) " + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st.execute("insert into t2 values(10,10)");
        st.execute("insert into t1 values (10, 10)");
        st.execute("insert into t1 values (20, 20)");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        numRows = 0;
        rs = st.executeQuery("Select * from t2");
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"ResultSet should have one row", (int)1, (int)numRows);
        rs.close();
        st.close();
        this.checkConnCloseExceptionForReadsOnly(conn);
        conn.commit();
        conn.close();
    }

    public void testSelectIsolated() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, primary key(c1)) replicate" + this.getSuffix());
        st.execute("Create table t2 (c1 int not null , c2 int not null, primary key(c1)) " + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st.execute("insert into t2 values(10,10)");
        st.execute("insert into t1 values (10, 10)");
        st.execute("insert into t1 values (20, 20)");
        ResultSet rs = st.executeQuery("Select * from t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        rs.close();
        conn.commit();
        rs = st.executeQuery("Select * from t1");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    public void testColocatedPrTransaction() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create table T1 ( PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key (PkCol1, PkCol2) ) Partition by column (PkCol1)" + this.getSuffix());
        st.execute("create table T2 (PkCol1 int not null, PkCol2 int not null,  col3 int, col4 varchar(10)) Partition by column (PkCol1)  colocate with (T1)" + this.getSuffix());
        conn.commit();
        st.execute("insert into t1 values(10, 10, 10, 10, 'XXXX1')");
        st.execute("insert into t2 values(10, 10, 10, 'XXXX1')");
        conn.commit();
        ResultSet rs = st.executeQuery("select * from t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Select should return one row", (int)1, (int)numRows);
        rs = st.executeQuery("select * from t2");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Select should return one row", (int)1, (int)numRows);
        rs.close();
        st.execute("insert into t1 values(20, 20, 20, 20, 'XXXX2')");
        st.execute("insert into t2 values(20, 20, 20, 'XXXX2')");
        conn.rollback();
        rs = st.executeQuery("select * from t1");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Select should return one row", (int)1, (int)numRows);
        rs = st.executeQuery("select * from t2");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Select should return one row", (int)1, (int)numRows);
        rs.close();
        st.execute("insert into t1 values(20, 20, 20, 20, 'XXXX2')");
        st.execute("insert into t2 values(20, 20, 20, 'XXXX2')");
        conn.commit();
        rs = st.executeQuery("select * from t1");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Select should return two rows", (int)2, (int)numRows);
        rs = st.executeQuery("select * from t2");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Select should return two rows", (int)2, (int)numRows);
        st.close();
        conn.commit();
        conn.close();
    }

    public void testCommitAndRollBack() throws Exception {
        this.startVMs(1, 2);
        Properties props = new Properties();
        props.setProperty("sync-commits", "true");
        Connection conn = TestUtil.getConnection(props);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create table T1 ( PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key (PkCol1, PkCol2)) Partition by column (PkCol1)" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        PreparedStatement psInsert = conn.prepareStatement("insert into t1 values(?, ?, ?, ?, ?)");
        for (int i = 0; i < 1000; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setInt(3, i);
            psInsert.setInt(4, i);
            psInsert.setString(5, "XXXX" + i);
            psInsert.executeUpdate();
            if (i % 2 == 0) {
                conn.commit();
                continue;
            }
            conn.rollback();
        }
        TXManagerImpl.waitForPendingCommitForTest();
        this.checkTxStatistics("commit-afterInserts", 240, 240, 240, 240, 500, 501);
        ResultSet rs = st.executeQuery("select * from t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Table should have 500 rows", (int)500, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
        TXManagerImpl.waitForPendingCommitForTest();
        this.checkTxStatistics("commit-afterSelects", 240, 240, 240, 240, 500, 501);
    }

    private void checkTxStatistics(final String comment, final int rCommits1, int rRollback1, final int rCommits2, int rRollback2, final int lCommit, int lRollback) throws Exception {
        final int[] isRemoteCheck = new int[]{-1};
        SerializableRunnable checkStats = new SerializableRunnable("check transaction counts"){

            public void run() throws CacheException {
                long txRollbackLifeTime;
                long txRollbackTime;
                int txRollbackChanges;
                int txRollbacks;
                long txFailedLifeTime;
                long txFailureTime;
                int txFailureChanges;
                int txFailures;
                long txSuccessLifeTime;
                long txCommitTime;
                int txCommitChanges;
                int txCommit;
                InternalDistributedSystem dsys = Misc.getDistributedSystem();
                StatisticsType stType = dsys.findType("CachePerfStats");
                Statistics[] stats = dsys.findStatisticsByType(stType);
                Statistics cpStats = null;
                for (Statistics s : stats) {
                    if (!"cachePerfStats".equals(s.getTextId())) continue;
                    TransactionDUnit.this.getLogWriter().info((Object)("SB: " + comment + " picked up stats " + s));
                    cpStats = s;
                    break;
                }
                if (isRemoteCheck[0] == -1) {
                    txCommit = cpStats.getInt("txCommits");
                    txCommitChanges = cpStats.getInt("txCommitChanges");
                    txCommitTime = cpStats.getLong("txCommitTime");
                    txSuccessLifeTime = cpStats.getLong("txSuccessLifeTime");
                    txFailures = cpStats.getInt("txFailures");
                    txFailureChanges = cpStats.getInt("txFailureChanges");
                    txFailureTime = cpStats.getLong("txFailureTime");
                    txFailedLifeTime = cpStats.getLong("txFailedLifeTime");
                    txRollbacks = cpStats.getInt("txRollbacks");
                    txRollbackChanges = cpStats.getInt("txRollbackChanges");
                    txRollbackTime = cpStats.getLong("txRollbackTime");
                    txRollbackLifeTime = cpStats.getLong("txRollbackLifeTime");
                } else {
                    txCommit = cpStats.getInt("txRemoteCommits");
                    txCommitChanges = cpStats.getInt("txRemoteCommitChanges");
                    txCommitTime = cpStats.getLong("txRemoteCommitTime");
                    txSuccessLifeTime = cpStats.getLong("txRemoteSuccessLifeTime");
                    txFailures = cpStats.getInt("txRemoteFailures");
                    txFailureChanges = cpStats.getInt("txRemoteFailureChanges");
                    txFailureTime = cpStats.getLong("txRemoteFailureTime");
                    txFailedLifeTime = cpStats.getLong("txRemoteFailedLifeTime");
                    txRollbacks = cpStats.getInt("txRemoteRollbacks");
                    txRollbackChanges = cpStats.getInt("txRemoteRollbackChanges");
                    txRollbackTime = cpStats.getLong("txRemoteRollbackTime");
                    txRollbackLifeTime = cpStats.getLong("txRemoteRollbackLifeTime");
                }
                TransactionDUnit.this.getLogWriter().info((Object)("server " + isRemoteCheck[0] + " isRemote=" + (isRemoteCheck[0] != -1)));
                TransactionDUnit.this.getLogWriter().info((Object)("txCommits=" + txCommit + " txCommitChanges=" + txCommitChanges + " txCommitTime=" + txCommitTime + " txSuccessLifeTime=" + txSuccessLifeTime));
                TransactionDUnit.this.getLogWriter().info((Object)("txFailures=" + txFailures + " txFailureChanges=" + txFailureChanges + " txFailureTime=" + txFailureTime + " txFailedLifeTime=" + txFailedLifeTime));
                TransactionDUnit.this.getLogWriter().info((Object)("txRollbacks=" + txRollbacks + " txRollbackChanges=" + txRollbackChanges + " txRollbackTime=" + txRollbackTime + " txRollbackLifeTime=" + txRollbackLifeTime));
                if (isRemoteCheck[0] == -1) {
                    TestCase.assertTrue((String)("txCommit=" + txCommit + "," + "lCommits=" + lCommit), (txCommit >= lCommit ? 1 : 0) != 0);
                } else if (isRemoteCheck[0] == 1) {
                    TestCase.assertTrue((String)("server " + isRemoteCheck[0] + "txCommit=" + txCommit + "," + "rCommits=" + rCommits1), (txCommit >= rCommits1 ? 1 : 0) != 0);
                } else if (isRemoteCheck[0] == 2) {
                    TestCase.assertTrue((String)("server " + isRemoteCheck[0] + " txCommit=" + txCommit + "," + "rCommits=" + rCommits2), (txCommit >= rCommits2 ? 1 : 0) != 0);
                }
            }
        };
        checkStats.run();
        isRemoteCheck[0] = 1;
        this.serverExecute(1, (Runnable)checkStats);
        isRemoteCheck[0] = 2;
        this.serverExecute(2, (Runnable)checkStats);
    }

    public void testNonTransactionalCommitAndRollback() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(0);
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create table T1 ( PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key (PkCol1, PkCol2) ) Partition by column (PkCol1)" + this.getSuffix());
        conn.commit();
        PreparedStatement psInsert = conn.prepareStatement("insert into t1 values(?, ?, ?, ?, ?)");
        int maxRows = 5000;
        for (int i = 0; i < maxRows; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setInt(3, i);
            psInsert.setInt(4, i);
            psInsert.setString(5, "XXXX" + i);
            psInsert.executeUpdate();
            if (i % 2 == 0) {
                conn.commit();
                continue;
            }
            conn.rollback();
        }
        ResultSet rs = st.executeQuery("select * from t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Table should have 5000 rows", (int)maxRows, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    public void testNonColocatedInsertByPartitioning() throws Exception {
        this.startServerVMs(1, 0, "sg1");
        this.startServerVMs(1, 0, "sg2");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.jdbcConn;
        System.out.println("XXXX the type of conneciton :  " + conn);
        Statement st = conn.createStatement();
        st.execute("create schema test default server groups (sg1, sg2)");
        st.execute("create table test.t1 ( PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key (PkCol1, PkCol2) ) Partition by column (PkCol1) server groups (sg1)" + this.getSuffix());
        st.execute("create table test.t2 (PkCol1 int not null, PkCol2 int not null,  col3 int, col4 varchar(10)) Partition by column (PkCol1) server groups (sg2)" + this.getSuffix());
        conn.commit();
        st.execute("insert into test.t1 values(10, 10, 10, 10, 'XXXX1')");
        st.execute("insert into test.t2 values(10, 10, 10, 'XXXX1')");
        conn.commit();
    }

    public void testTransactionalKeyBasedUpdates() throws Exception {
        this.startServerVMs(2, 0, "sg1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.jdbcConn;
        conn.setAutoCommit(false);
        System.out.println("XXXX the type of conneciton :  " + conn);
        Statement st = conn.createStatement();
        st.execute("create schema test default server groups (sg1, sg2)");
        st.execute("create table test.t1 ( PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key (PkCol1) ) Partition by column (PkCol1) server groups (sg1)" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        PreparedStatement psInsert = conn.prepareStatement("insert into test.t1 values(?, 10, 10, 10, 'XXXX1')");
        for (int i = 0; i < 1000; ++i) {
            psInsert.setInt(1, i);
            psInsert.executeUpdate();
            conn.commit();
        }
        ResultSet rs = st.executeQuery("select * from test.t1");
        int numRows = 0;
        while (rs.next()) {
            TransactionDUnit.assertEquals((String)"Column value should be 10", (int)10, (int)rs.getInt(3));
            TransactionDUnit.assertEquals((String)"Column value should be 10", (int)10, (int)rs.getInt(4));
            TransactionDUnit.assertEquals((String)"Column value should be XXXX1", (String)"XXXX1", (String)rs.getString(5).trim());
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Numbers of rows in resultset should be one", (int)1000, (int)numRows);
        PreparedStatement psUpdate = conn.prepareStatement("update test.t1 set col3 = 20, col4 = 20, col5 = 'changed' where PkCol1=?");
        for (int i = 0; i < 1000; ++i) {
            psUpdate.setInt(1, i);
            psUpdate.executeUpdate();
            conn.commit();
        }
        rs = st.executeQuery("select * from test.t1");
        numRows = 0;
        while (rs.next()) {
            TransactionDUnit.assertEquals((String)"Column value should change", (int)20, (int)rs.getInt(3));
            TransactionDUnit.assertEquals((String)"Columns value should change", (int)20, (int)rs.getInt(4));
            TransactionDUnit.assertEquals((String)"Columns value should change", (String)"changed", (String)rs.getString(5).trim());
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Numbers of rows in resultset should be one", (int)1000, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    public void testTransactionalKeyBasedUpdatePartitionedByPk() throws Exception {
        this.startServerVMs(2, 0, "sg1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.jdbcConn;
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create schema test default server groups (sg1, sg2)");
        st.execute("create table test.t1 ( PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key (PkCol1) ) Partition by Primary Key server groups (sg1) redundancy 1" + this.getSuffix());
        conn.setTransactionIsolation(this.getIsolationLevel());
        PreparedStatement psInsert = conn.prepareStatement("insert into test.t1 values(?, 10, 10, 10, 'XXXX1')");
        for (int i = 0; i < 1000; ++i) {
            psInsert.setInt(1, i);
            psInsert.executeUpdate();
            conn.commit();
        }
        ResultSet rs = st.executeQuery("select * from test.t1");
        int numRows = 0;
        while (rs.next()) {
            TransactionDUnit.assertEquals((String)"Column value should be 10", (int)10, (int)rs.getInt(3));
            TransactionDUnit.assertEquals((String)"Column value should be 10", (int)10, (int)rs.getInt(4));
            TransactionDUnit.assertEquals((String)"Column value should be XXXX1", (String)"XXXX1", (String)rs.getString(5).trim());
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Numbers of rows in resultset should be one", (int)1000, (int)numRows);
        PreparedStatement psUpdate = conn.prepareStatement("update test.t1 set col3 = 20, col4 = 20, col5 = 'changed' where PkCol1=?");
        for (int i = 0; i < 1000; ++i) {
            psUpdate.setInt(1, i);
            psUpdate.executeUpdate();
            conn.commit();
        }
        rs = st.executeQuery("select * from test.t1");
        numRows = 0;
        while (rs.next()) {
            TransactionDUnit.assertEquals((String)"Column value should change", (int)20, (int)rs.getInt(3));
            TransactionDUnit.assertEquals((String)"Columns value should change", (int)20, (int)rs.getInt(4));
            TransactionDUnit.assertEquals((String)"Columns value should change", (String)"changed", (String)rs.getString(5).trim());
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Numbers of rows in resultset should be one", (int)1000, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    public void testNetworkTransactionDDLFollowedByCommitThenDML() throws Exception {
        this.startServerVMs(1, 0, null);
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, "/;user=q;password=q", null);
        conn.setAutoCommit(false);
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("create table t1 (PkCol1 int not null, Col2 int not null, Primary Key (PkCol1))" + this.getSuffix());
        conn.commit();
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?,?)");
        for (int i = 0; i < 1; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        ResultSet rs = st.executeQuery("select * from t1");
        TransactionDUnit.assertTrue((boolean)rs.next());
        conn.commit();
        rs = st.executeQuery("select * from t1");
        TransactionDUnit.assertTrue((boolean)rs.next());
        conn.commit();
        rs.close();
        st.close();
        conn.close();
    }

    public void testNetworkDDLFollowedByInsert() throws Exception {
        int i;
        this.startServerVMs(1, 0, null);
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, "/;user=q;password=q", null);
        conn.setAutoCommit(false);
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("create table t1 (PkCol1 int not null, Col2 int not null, Primary Key (PkCol1))" + this.getSuffix());
        int numRows = 100;
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?,?)");
        for (int i2 = 0; i2 < 100; ++i2) {
            ps.setInt(1, i2);
            ps.setInt(2, i2);
            ps.executeUpdate();
        }
        ResultSet rs = st.executeQuery("select * from t1");
        for (i = 0; i < 100; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
        }
        conn.commit();
        rs = st.executeQuery("select * from t1");
        for (i = 0; i < 100; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
        }
        conn.commit();
        conn.setTransactionIsolation(1);
        TransactionDUnit.assertEquals((int)2, (int)conn.getTransactionIsolation());
        for (i = 100; i < 200; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        rs = st.executeQuery("select * from t1");
        for (i = 100; i < 200; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
        }
        conn.commit();
        rs = st.executeQuery("select * from t1");
        for (i = 100; i < 200; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
        }
        conn.commit();
        rs.close();
        st.close();
        conn.close();
    }

    public void testTransactionalUpdates() throws Exception {
        int i;
        this.startServerVMs(1, 0, null);
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, "/;user=q;password=q", null);
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create table t1 (PkCol1 int not null, Col2 varchar(10) not null, Primary Key (PkCol1))" + this.getSuffix());
        int numRows = 200;
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?,?)");
        PreparedStatement ps1 = conn.prepareStatement("select * from t1");
        for (int i2 = 0; i2 < 200; ++i2) {
            ps.setInt(1, i2);
            ps.setString(2, "XXXX" + i2);
            ps.executeUpdate();
        }
        ResultSet rs = ps1.executeQuery();
        for (i = 0; i < 200; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
            TransactionDUnit.assertTrue((boolean)rs.getString(2).startsWith("XXXX"));
        }
        TransactionDUnit.assertFalse((boolean)rs.next());
        conn.rollback();
        conn.commit();
        rs = ps1.executeQuery();
        TransactionDUnit.assertFalse((boolean)rs.next());
        for (i = 0; i < 200; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "XXXX" + i);
            ps.executeUpdate();
        }
        conn.commit();
        rs = ps1.executeQuery();
        for (i = 0; i < 200; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
            TransactionDUnit.assertTrue((boolean)rs.getString(2).startsWith("XXXX"));
        }
        TransactionDUnit.assertFalse((boolean)rs.next());
        PreparedStatement select = conn.prepareStatement("select * from t1 where t1.pkCol1 = ?");
        PreparedStatement psUpdate = conn.prepareStatement("update t1 set col2 = ? where PkCol1 = ?");
        for (int i3 = 0; i3 < 200; ++i3) {
            select.setInt(1, i3);
            rs = select.executeQuery();
            TransactionDUnit.assertTrue((String)("unexpected no result for i=" + i3), (boolean)rs.next());
            TransactionDUnit.assertTrue((boolean)rs.getString("Col2").trim().equalsIgnoreCase("XXXX" + i3));
            psUpdate.setString(1, "Updated");
            psUpdate.setInt(2, i3);
            psUpdate.executeUpdate();
            rs = select.executeQuery();
            TransactionDUnit.assertTrue((boolean)rs.next());
            TransactionDUnit.assertTrue((boolean)rs.getString("Col2").trim().equalsIgnoreCase("Updated"));
            conn.commit();
            rs = select.executeQuery();
            TransactionDUnit.assertTrue((boolean)rs.next());
            TransactionDUnit.assertTrue((boolean)rs.getString("Col2").trim().equalsIgnoreCase("Updated"));
        }
        conn.commit();
        rs.close();
        st.close();
        conn.close();
    }

    public void testIndexMaintenanceOnPrimaryAndSecondary() throws Exception {
        this.startServerVMs(2, 0, "sg1");
        this.startClientVMs(1, 0, null);
        Properties props = new Properties();
        props.setProperty("sync-commits", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema test default server groups (sg1, sg2)");
        st.execute("create table test.t1 ( PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key(PkCol1)) Partition by Primary Key server groups (sg1) redundancy 1" + this.getSuffix());
        conn.commit();
        st.execute("create index IndexCol4 on test.t1 (col4)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 10;
        VM server1 = (VM)this.serverVMs.get(0);
        VM server2 = (VM)this.serverVMs.get(1);
        server1.invoke(((Object)((Object)this)).getClass(), "installIndexObserver", new Object[]{"test.IndexCol4", null});
        server2.invoke(((Object)((Object)this)).getClass(), "installIndexObserver", new Object[]{"test.IndexCol4", null});
        PreparedStatement psInsert = conn.prepareStatement("insert into test.t1 values(?, 10, 10, 10, 'XXXX1')");
        for (int i = 0; i < 10; ++i) {
            psInsert.setInt(1, i);
            psInsert.executeUpdate();
            conn.commit();
        }
        server1.invoke(((Object)((Object)this)).getClass(), "checkIndexAndReset", new Object[]{10, 0});
        server2.invoke(((Object)((Object)this)).getClass(), "checkIndexAndReset", new Object[]{10, 0});
        PreparedStatement psUpdate = conn.prepareStatement("update test.t1 set col3 = 20, col4 = 20, col5 = 'changed' where PkCol1=?");
        for (int i = 0; i < 10; ++i) {
            psUpdate.setInt(1, i);
            psUpdate.executeUpdate();
            conn.commit();
        }
        server1.invoke(((Object)((Object)this)).getClass(), "checkIndexAndReset", new Object[]{20, 10});
        server2.invoke(((Object)((Object)this)).getClass(), "checkIndexAndReset", new Object[]{20, 10});
        server1.invoke(((Object)((Object)this)).getClass(), "resetIndexObserver");
        server2.invoke(((Object)((Object)this)).getClass(), "resetIndexObserver");
        st.close();
        conn.close();
    }

    public void testXATransactionFromClient_commit() throws Exception {
        this.startServerVMs(2, 0, null);
        this.startClientVMs(1, 0, null);
        int netport = this.startNetworkServer(1, null, null);
        this.serverSQLExecute(1, "create schema test");
        this.serverSQLExecute(1, "create table test.XATT2 (intcol int not null, text varchar(100) not null)" + this.getSuffix());
        this.serverSQLExecute(1, "insert into test.XATT2 values (1, 'ONE')");
        ClientXADataSource xaDataSource = (ClientXADataSource)TestUtil.getXADataSource("com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource");
        byte[] gid = new byte[64];
        byte[] bid = new byte[64];
        for (int i = 0; i < 64; ++i) {
            gid[i] = (byte)i;
            bid[i] = (byte)(64 - i);
        }
        ClientXid xid = new ClientXid(4660, gid, bid);
        String localhost = SocketCreator.getLocalHost().getHostName();
        xaDataSource.setServerName(localhost);
        xaDataSource.setPortNumber(netport);
        xaDataSource.setDatabaseName("gemfirexd");
        XAConnection xaConn = xaDataSource.getXAConnection();
        XAResource xaRes = xaConn.getXAResource();
        Connection conn = xaConn.getConnection();
        xaRes.start((Xid)xid, 0);
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement stm = conn.createStatement();
        stm.execute("insert into test.XATT2 values (2, 'TWO')");
        String jdbcSQL = "select * from test.XATT2";
        String xmlFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, xmlFile, "before_xa_commit");
        stm.execute("select * from test.XATT2");
        ResultSet r = stm.getResultSet();
        int cnt = 0;
        while (r.next()) {
            ++cnt;
        }
        TransactionDUnit.assertEquals((int)2, (int)cnt);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        xaRes.commit((Xid)xid, false);
        VM servervm = this.getServerVM(1);
        servervm.invoke(TransactionDUnit.class, "waitForPendingCommit");
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, xmlFile, "after_xa_commit");
    }

    public void testXATransactionFromPeerClient_commit() throws Exception {
        this.startServerVMs(2, 0, null);
        this.startClientVMs(1, 0, null);
        this.serverSQLExecute(1, "create schema test");
        this.serverSQLExecute(1, "create table test.XATT2 (intcol int not null, text varchar(100) not null)" + this.getSuffix());
        this.serverSQLExecute(1, "insert into test.XATT2 values (1, 'ONE')");
        EmbeddedXADataSource xaDataSource = (EmbeddedXADataSource)TestUtil.getXADataSource("com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource");
        byte[] gid = new byte[64];
        byte[] bid = new byte[64];
        for (int i = 0; i < 64; ++i) {
            gid[i] = (byte)i;
            bid[i] = (byte)(64 - i);
        }
        ClientXid xid = new ClientXid(4660, gid, bid);
        XAConnection xaConn = xaDataSource.getXAConnection();
        XAResource xaRes = xaConn.getXAResource();
        Connection conn = xaConn.getConnection();
        xaRes.start((Xid)xid, 0);
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement stm = conn.createStatement();
        stm.execute("insert into test.XATT2 values (2, 'TWO')");
        String jdbcSQL = "select * from test.XATT2";
        String xmlFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, xmlFile, "before_xa_commit");
        stm.execute("select * from test.XATT2");
        ResultSet r = stm.getResultSet();
        int cnt = 0;
        while (r.next()) {
            ++cnt;
        }
        TransactionDUnit.assertEquals((int)2, (int)cnt);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        xaRes.commit((Xid)xid, false);
        VM servervm = this.getServerVM(1);
        servervm.invoke(TransactionDUnit.class, "waitForPendingCommit");
        TXManagerImpl.waitForPendingCommitForTest();
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, xmlFile, "after_xa_commit");
    }

    public void testXATransactionFromClient_rollback() throws Exception {
        this.startServerVMs(2, 0, null);
        this.startClientVMs(1, 0, null);
        int netport = this.startNetworkServer(1, null, null);
        this.serverSQLExecute(1, "create schema test");
        this.serverSQLExecute(1, "create table test.XATT2 (intcol int not null, text varchar(100) not null)" + this.getSuffix());
        this.serverSQLExecute(1, "insert into test.XATT2 values (1, 'ONE')");
        ClientXADataSource xaDataSource = (ClientXADataSource)TestUtil.getXADataSource("com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource");
        byte[] gid = new byte[64];
        byte[] bid = new byte[64];
        for (int i = 0; i < 64; ++i) {
            gid[i] = (byte)i;
            bid[i] = (byte)(64 - i);
        }
        ClientXid xid = new ClientXid(4660, gid, bid);
        String localhost = SocketCreator.getLocalHost().getHostName();
        xaDataSource.setServerName(localhost);
        xaDataSource.setPortNumber(netport);
        xaDataSource.setDatabaseName("gemfirexd");
        XAConnection xaConn = xaDataSource.getXAConnection();
        XAResource xaRes = xaConn.getXAResource();
        Connection conn = xaConn.getConnection();
        xaRes.start((Xid)xid, 0);
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement stm = conn.createStatement();
        stm.execute("insert into test.XATT2 values (2, 'TWO')");
        String jdbcSQL = "select * from test.XATT2";
        String xmlFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, xmlFile, "before_xa_commit");
        stm.execute("select * from test.XATT2");
        ResultSet r = stm.getResultSet();
        int cnt = 0;
        while (r.next()) {
            ++cnt;
        }
        TransactionDUnit.assertEquals((int)2, (int)cnt);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        xaRes.rollback((Xid)xid);
        VM servervm = this.getServerVM(1);
        servervm.invoke(TransactionDUnit.class, "waitForPendingCommit");
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, xmlFile, "before_xa_commit");
    }

    public void testXATransactionFromPeerClient_rollback() throws Exception {
        this.startServerVMs(2, 0, null);
        this.startClientVMs(1, 0, null);
        this.serverSQLExecute(1, "create schema test");
        this.serverSQLExecute(1, "create table test.XATT2 (intcol int not null, text varchar(100) not null)" + this.getSuffix());
        this.serverSQLExecute(1, "insert into test.XATT2 values (1, 'ONE')");
        EmbeddedXADataSource xaDataSource = (EmbeddedXADataSource)TestUtil.getXADataSource("com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource");
        byte[] gid = new byte[64];
        byte[] bid = new byte[64];
        for (int i = 0; i < 64; ++i) {
            gid[i] = (byte)i;
            bid[i] = (byte)(64 - i);
        }
        ClientXid xid = new ClientXid(4660, gid, bid);
        XAConnection xaConn = xaDataSource.getXAConnection();
        XAResource xaRes = xaConn.getXAResource();
        Connection conn = xaConn.getConnection();
        xaRes.start((Xid)xid, 0);
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement stm = conn.createStatement();
        stm.execute("insert into test.XATT2 values (2, 'TWO')");
        String jdbcSQL = "select * from test.XATT2";
        String xmlFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, xmlFile, "before_xa_commit");
        stm.execute("select * from test.XATT2");
        ResultSet r = stm.getResultSet();
        int cnt = 0;
        while (r.next()) {
            ++cnt;
        }
        TransactionDUnit.assertEquals((int)2, (int)cnt);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        xaRes.rollback((Xid)xid);
        VM servervm = this.getServerVM(1);
        servervm.invoke(TransactionDUnit.class, "waitForPendingCommit");
        this.sqlExecuteVerify(null, new int[]{1}, jdbcSQL, xmlFile, "before_xa_commit");
    }

    public static void waitForPendingCommit() {
        TXManagerImpl.waitForPendingCommitForTest();
    }

    public static void installIndexObserver(String name, TXId txId) {
        CheckIndexOperations checkIndex = new CheckIndexOperations(name, txId);
        GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)checkIndex);
        TransactionDUnit.assertNull((Object)old);
    }

    public static void checkIndexAndReset(int numInsertExpected, int numDeletesExpected) throws Exception {
        CheckIndexOperations checkIndex = (CheckIndexOperations)GemFireXDQueryObserverHolder.getObserver(CheckIndexOperations.class);
        checkIndex.checkNumInserts(numInsertExpected);
        checkIndex.checkNumDeletes(numDeletesExpected);
    }

    public static void resetIndexObserver() throws Exception {
        GemFireXDQueryObserverHolder.clearInstance();
    }

    public void testBug41694() throws Exception {
        this.startServerVMs(2, 0, "sg1");
        this.startClientVMs(1, 0, null);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema test default server groups (sg1, sg2)");
        st.execute("create table test.t1 ( PkCol1 int not null, PkCol2 int not null, col3 int, col4 int, col5 varchar(10),col6 int, col7 int, col8 int, col9 int, col10 int, col11 int, col12 int, col13 int, col14 int, col15 int, col16 int, col17 int, col18 int, col19 int, col20 int, col21 int,col22 int, col23 int, col24 int, col25 int, col26 int, col27 int, col28 int, col29 int, col30 int, col31 int, col32 int, col33 int, col34 int, col35 int, col36 int, col37 int, col38 int, col39 int, col40 int, col41 int, col42 int, col43 int, col44 int, col45 int, col46 int, col47 int, col48 int, col49 int, col50 int, col51 int, col52 int, col53 int, col54 int, col55 int, col56 int, col57 int, col58 int, col59 int, col60 int, col61 int, col62 int, col63 int, col64 int, col65 int, col66 int, col67 int, col68 int, col69 int, col70 int, col71 int, col72 int, col73 int, col74 int, col75 int, col76 int, col77 int, col78 int, col79 int, col80 int, col81 int, col82 int, col83 int, col84 int, col85 int, col86 int, col87 int, col88 int, col89 int, col90 int, col91 int, col92 int, col93 int, col94 int, col95 int, col96 int, col97 int, col98 int, col99 int, col100 int, Primary Key (PkCol1) ) Partition by Primary Key server groups (sg1) redundancy 1" + this.getSuffix());
        conn.commit();
        st.execute("create index IndexCol4 on test.t1 (col4)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        boolean numRows = true;
        PreparedStatement psInsert = conn.prepareStatement("insert into test.t1 values(?, 1000, 1000, 1000, 'XXXX1' , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000  , 1000, 1000, 1000, 1000, 1000  , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 , 1000, 1000, 1000, 1000, 1000 )");
        for (int i = 0; i < 1; ++i) {
            psInsert.setInt(1, i);
            psInsert.executeUpdate();
            conn.commit();
        }
        PreparedStatement psUpdate = conn.prepareStatement("update test.t1 set col3 = 20 where PkCol1=?");
        for (int i = 0; i < 1000; ++i) {
            psUpdate.setInt(1, 0);
            psUpdate.executeUpdate();
            conn.commit();
        }
        st.close();
        conn.commit();
    }

    public void testUseCase_timeInserts() throws Exception {
        this.reduceLogLevelForTest("warning");
        this.startVMs(0, 1);
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, "/;user=app;password=app", null);
        Statement s = conn.createStatement();
        try {
            s.executeUpdate("drop table securities");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s.executeUpdate("create table securities ( sec_id integer not null constraint sec_pk primary key, symbol varchar(30), price double precision, exchange varchar(30),count integer)" + this.getSuffix());
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        this.getLogWriter().info((Object)" Warming up ...");
        this.dumpIntoTable(conn, 1000);
        conn.rollback();
        long begin = System.nanoTime();
        this.dumpIntoTable(conn, 10000);
        conn.commit();
        long end = System.nanoTime();
        this.getLogWriter().info((Object)("Time to execute 10k operations" + (end - begin) / 1000000L + " millis"));
    }

    protected void dumpIntoTable(Connection conn, int rows) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("insert into securities values(?,?,?,?,?)");
        while (rows > 0) {
            ps.setInt(1, rows + 20000);
            ps.setString(2, "SYM" + String.valueOf(rows));
            ps.setFloat(3, 345.0f);
            ps.setString(4, "nasdaq");
            ps.setInt(5, rows);
            ps.executeUpdate();
            --rows;
        }
    }

    public void testTransactionalKeyBasedDeletes() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st.execute("insert into tran.t1 values (10, 10)");
        conn.commit();
        st.execute("delete from tran.t1 where c1 = 10");
        ResultSet rs = st.executeQuery("select * from tran.t1");
        TransactionDUnit.assertFalse((boolean)rs.next());
        conn.commit();
        rs = st.executeQuery("select * from tran.t1");
        TransactionDUnit.assertFalse((boolean)rs.next());
        conn.commit();
        rs.close();
        st.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalDeleteWithLocalIndexes() throws Exception {
        this.startVMs(1, 1);
        Properties props = new Properties();
        props.setProperty("sync-commits", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))" + this.getSuffix());
        conn.commit();
        st.execute("create index IndexCol2 on tran.t1 (c2)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 1000;
        PreparedStatement ps = conn.prepareStatement("insert into tran.t1 values (?, ?)");
        for (int i = 0; i < 1000; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        PreparedStatement psDelete = conn.prepareStatement("delete from tran.t1 where c1 = ?");
        conn.commit();
        VM server1 = (VM)this.serverVMs.get(0);
        ResultSet rs = conn.createStatement().executeQuery("select count(*) from tran.t1");
        TransactionDUnit.assertTrue((boolean)rs.next());
        TransactionDUnit.assertEquals((int)1000, (int)rs.getInt(1));
        TransactionDUnit.assertFalse((boolean)rs.next());
        server1.invoke(((Object)((Object)this)).getClass(), "installIndexObserver", new Object[]{"tran.IndexCol2", TXManagerImpl.getCurrentTXId()});
        for (int i = 0; i < 1000; ++i) {
            psDelete.setInt(1, i);
            psDelete.executeUpdate();
        }
        conn.commit();
        server1.invoke(((Object)((Object)this)).getClass(), "checkIndexAndReset", new Object[]{0, 1000});
        server1.invoke(((Object)((Object)this)).getClass(), "resetIndexObserver");
        st.close();
        conn.close();
    }

    public void testTransactionalDeleteWithLocalIndexesClientServer() throws Exception {
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, "/;user=app;password=app", null);
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))" + this.getSuffix());
        conn.commit();
        st.execute("create index IndexCol2 on tran.t1 (c2)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 1000;
        PreparedStatement ps = conn.prepareStatement("insert into tran.t1 values (?, ?)");
        for (int i = 0; i < numRows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
            conn.commit();
        }
        VM server1 = (VM)this.serverVMs.get(0);
        server1.invoke(((Object)((Object)this)).getClass(), "installIndexObserver", new Object[]{"tran.IndexCol2", null});
        PreparedStatement psDelete = conn.prepareStatement("delete from tran.t1 where c1 = ?");
        for (int i = 0; i < numRows; ++i) {
            psDelete.setInt(1, i);
            psDelete.executeUpdate();
            conn.commit();
        }
        server1.invoke(((Object)((Object)this)).getClass(), "checkIndexAndReset", new Object[]{0, numRows});
        server1.invoke(((Object)((Object)this)).getClass(), "resetIndexObserver");
        st.execute("drop table tran.t1");
        st.execute("drop schema tran restrict");
        st.close();
        conn.commit();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalDeleteWithLocalIndexesClientServerReplicatedTable() throws Exception {
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, "/;user=app;password=app", null);
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1)) replicate" + this.getSuffix());
        conn.commit();
        st.execute("create index IndexCol2 on tran.t1 (c2)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        VM server1 = (VM)this.serverVMs.get(0);
        server1.invoke(((Object)((Object)this)).getClass(), "installIndexObserver", new Object[]{"tran.IndexCol2", null});
        int numRows = 1000;
        PreparedStatement ps = conn.prepareStatement("insert into tran.t1 values (?, ?)");
        for (int i = 0; i < numRows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
            conn.commit();
        }
        server1.invoke(((Object)((Object)this)).getClass(), "checkIndexAndReset", new Object[]{numRows, 0});
        PreparedStatement psDelete = conn.prepareStatement("delete from tran.t1 where c1 = ?");
        for (int i = 0; i < numRows; ++i) {
            psDelete.setInt(1, i);
            psDelete.executeUpdate();
            conn.commit();
        }
        server1.invoke(((Object)((Object)this)).getClass(), "checkIndexAndReset", new Object[]{numRows, numRows});
        server1.invoke(((Object)((Object)this)).getClass(), "resetIndexObserver");
        st.execute("drop table tran.t1");
        st.execute("drop schema tran restrict");
        st.close();
        conn.commit();
        conn.close();
    }

    public void testUpdateWithFunctionExecution() throws Exception {
        int i;
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by list (tid) (VALUES (3, 15, 2, 7), VALUES (10, 16, 4, 5), VALUES (1, 13, 6, 12), VALUES (0, 8, 9, 11, 14, 17)) " + this.getSuffix());
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 10;
        PreparedStatement ps = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?, ?)");
        for (int i2 = 0; i2 < 10; ++i2) {
            ps.setInt(1, i2);
            ps.setString(2, "XXXX" + i2);
            ps.setDouble(3, i2);
            ps.setString(4, "nasdaq");
            ps.setInt(5, i2);
            ps.executeUpdate();
        }
        conn.commit();
        InternalDistributedSystem.getAnyInstance().getLogWriter().info("XXXX starting the update");
        PreparedStatement psUpdate = conn.prepareStatement("update trade.securities set symbol = ? where sec_id = ? and tid = ?");
        for (int i3 = 0; i3 < 10; ++i3) {
            psUpdate.setString(1, "YYYY" + i3);
            psUpdate.setInt(2, i3);
            psUpdate.setInt(3, i3);
            psUpdate.executeUpdate();
        }
        InternalDistributedSystem.getAnyInstance().getLogWriter().info("XXXX update is done");
        ResultSet rs = st.executeQuery("select * from trade.securities order by symbol");
        for (i = 0; i < 10; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
            TransactionDUnit.assertEquals((String)("YYYY" + i), (String)rs.getString("SYMBOL"));
        }
        TransactionDUnit.assertFalse((boolean)rs.next());
        conn.commit();
        rs = st.executeQuery("select * from trade.securities order by symbol");
        for (i = 0; i < 10; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
            TransactionDUnit.assertEquals((String)("YYYY" + i), (String)rs.getString("SYMBOL"));
        }
        TransactionDUnit.assertFalse((boolean)rs.next());
        conn.commit();
        rs.close();
        st.close();
        psUpdate.close();
        ps.close();
        conn.close();
    }

    public void testNetworkFailedDDLFollowedByInsert() throws Exception {
        int i;
        this.startServerVMs(1, 0, null);
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, "/;user=q;password=q", null);
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create table t1 (PkCol1 int not null, Col2 int not null, Primary Key (PkCol1))" + this.getSuffix());
        int numRows = 3;
        st.execute("insert into t1 values (0,0), (1,1), (2,2)");
        ResultSet rs = st.executeQuery("select * from t1");
        for (i = 0; i < 3; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
        }
        TransactionDUnit.assertFalse((boolean)rs.next());
        conn.commit();
        rs = st.executeQuery("select * from t1");
        for (i = 0; i < 3; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
        }
        TransactionDUnit.assertFalse((boolean)rs.next());
        conn.commit();
        rs.close();
        st.execute("drop table t1");
        st.close();
        conn.commit();
        conn.close();
    }

    public void test41679() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))" + this.getSuffix());
        conn.commit();
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(this.getIsolationLevel());
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customers values(?, ?, ?, ?, ?)");
        for (int i = 0; i < 131; ++i) {
            psInsert.setInt(1, i);
            psInsert.setString(2, "YYYY");
            psInsert.setDate(3, new Date(System.currentTimeMillis()));
            psInsert.setString(4, "YYYY");
            psInsert.setInt(5, i);
            psInsert.executeUpdate();
        }
        conn.commit();
        PreparedStatement psUpdate = conn.prepareStatement("update trade.customers set cust_name = ? where cid = ?");
        for (int i = 0; i < 131; ++i) {
            try {
                psUpdate.setString(1, "XXXX");
                psUpdate.setInt(2, i);
                psUpdate.executeUpdate();
                continue;
            }
            catch (SQLException e) {
                if (!"X0Z06".equals(e.getSQLState())) {
                    throw e;
                }
                Throwable t = e.getCause();
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                TransactionDUnit.assertTrue((String)("unexpected cause: " + t), (boolean)(t instanceof EntryExistsException));
            }
        }
        ResultSet rs = st.executeQuery("select * from trade.customers");
        int numRow = 0;
        while (rs.next()) {
            ++numRow;
        }
        System.out.println("XXXX num rows = " + numRow);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    public void testUniquenessFailure() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, c3 int not null, primary key(c1), constraint C3_Unique unique (c3)) " + this.getSuffix());
        conn.commit();
        st.execute("create index IndexCol2 on tran.t1 (c2)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 2;
        PreparedStatement ps = conn.prepareStatement("insert into tran.t1 values (?, ?, ?)");
        try {
            for (int i = 0; i < numRows; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, i);
                ps.setInt(3, 2);
                ps.executeUpdate();
            }
            TransactionDUnit.fail((String)"update should throw an exception for unique key violation");
        }
        catch (SQLException ex) {
            if (!"23505".equals(ex.getSQLState())) {
                throw ex;
            }
            Throwable t = ex.getCause();
            while (t.getCause() != null) {
                t = t.getCause();
            }
            TransactionDUnit.assertTrue((String)("unexpected cause: " + t), (boolean)(t instanceof EntryExistsException));
        }
        String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
        ps.setInt(1, 0);
        ps.setInt(2, 0);
        ps.setInt(3, 2);
        ps.executeUpdate();
        ps.setInt(1, 4);
        ps.setInt(2, 5);
        ps.setInt(3, 6);
        ps.executeUpdate();
        String jdbcSQL = "select * from tran.t1";
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, goldenTextFile, "tran_uniq");
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, null, jdbcSQL, goldenTextFile, "tran_uniq");
        st.close();
        ps.close();
        conn.commit();
        conn.close();
    }

    public void testUniquenessFailureReplicatedTable() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, c3 int not null,primary key(c1), constraint C3_Unique unique (c3)) replicate" + this.getSuffix());
        conn.commit();
        st.execute("create index IndexCol2 on tran.t1 (c2)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 2;
        PreparedStatement ps = conn.prepareStatement("insert into tran.t1 values (?, ?, ?)");
        try {
            for (int i = 0; i < numRows; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, i);
                ps.setInt(3, 2);
                ps.executeUpdate();
            }
            TransactionDUnit.fail((String)"The control should not reach here as unique index key violation should be encountered during transaction op only");
            conn.commit();
        }
        catch (SQLException ex) {
            if (!"23505".equals(ex.getSQLState())) {
                throw ex;
            }
            Throwable t = ex.getCause();
            while (t.getCause() != null) {
                t = t.getCause();
            }
            TransactionDUnit.assertTrue((String)("unexpected cause: " + t), (boolean)(t instanceof EntryExistsException));
        }
        st.close();
        ps.close();
        conn.rollback();
        conn.close();
    }

    public void testNonKeyBasedTransactionalUpdates() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) )  partition by column (tid) " + this.getSuffix());
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 5;
        PreparedStatement ps = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?, ?)");
        for (int i = 0; i < 5; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "XXXX" + i);
            ps.setDouble(3, i);
            ps.setString(4, "nasdaq");
            ps.setInt(5, i);
            ps.executeUpdate();
        }
        conn.commit();
        PreparedStatement psUpdate = conn.prepareStatement("update trade.securities set symbol = ? where sec_id = ? and tid = ?");
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        ResultSet rs = st.executeQuery("select * from trade.securities");
        int numRowsReturned = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got" + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numRowsReturned;
        }
        TransactionDUnit.assertEquals((String)("Expected 5 row but found " + numRowsReturned), (int)5, (int)numRowsReturned);
        conn.commit();
        rs = st.executeQuery("select * from trade.securities");
        int numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        conn.commit();
        rs.close();
        st.close();
        psUpdate.close();
        ps.close();
        conn.close();
    }

    public void testNonKeyBasedTransactionalUpdatesRollbackAndCommit() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) )  partition by column (tid) " + this.getSuffix());
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 5;
        PreparedStatement ps = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?, ?)");
        for (int i = 0; i < 5; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "XXXX" + i);
            ps.setDouble(3, i);
            ps.setString(4, "nasdaq");
            ps.setInt(5, i);
            ps.executeUpdate();
        }
        conn.commit();
        PreparedStatement psUpdate = conn.prepareStatement("update trade.securities set symbol = ? where sec_id = ? and tid = ?");
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        ResultSet rs = st.executeQuery("select * from trade.securities");
        int numRowsReturned = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got" + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numRowsReturned;
        }
        TransactionDUnit.assertEquals((String)("Expected 5 row but found " + numRowsReturned), (int)5, (int)numRowsReturned);
        conn.rollback();
        conn.commit();
        rs = st.executeQuery("select * from trade.securities");
        int numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("XXXX"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        rs.close();
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        conn.commit();
        rs = st.executeQuery("select * from trade.securities");
        numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        conn.commit();
        rs.close();
        st.close();
        psUpdate.close();
        ps.close();
        conn.close();
    }

    public void testNonKeyBasedTransactionalUpdatesAndConflict() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) )  partition by primary key" + this.getSuffix());
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 5;
        PreparedStatement ps = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?, ?)");
        for (int i = 0; i < 5; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "XXXX" + i);
            ps.setDouble(3, i);
            ps.setString(4, "nasdaq");
            ps.setInt(5, i);
            ps.executeUpdate();
        }
        conn.commit();
        PreparedStatement psUpdate = conn.prepareStatement("update trade.securities set symbol = ? where sec_id = ? and tid = ?");
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        this.gotConflict = false;
        Thread otherTx = new Thread(new Runnable(){

            @Override
            public void run() {
                Region r = Misc.getRegionForTable((String)"TRADE.SECURITIES", (boolean)true);
                TXManagerImpl txManager = Misc.getGemFireCache().getCacheTransactionManager();
                txManager.begin();
                try {
                    RegionKey key = TestUtil.getGemFireKey(0, r);
                    Object row = r.get((Object)key);
                    r.put((Object)key, row);
                }
                catch (ConflictException ce) {
                    TransactionDUnit.this.gotConflict = true;
                    txManager.rollback();
                }
                catch (StandardException se) {
                    TransactionDUnit.this.gotConflict = false;
                    DistributedSQLTestBase.fail("failing put with exception", se);
                }
            }
        });
        otherTx.start();
        otherTx.join();
        TransactionDUnit.assertTrue((String)"expected conflict", (boolean)this.gotConflict);
        this.gotConflict = false;
        conn.commit();
        st.close();
        psUpdate.close();
        ps.close();
        conn.close();
    }

    public void testBulkTransactionalUpdatesRollbackAndCommitClientServer() throws Exception {
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, "/;user=app;password=app", null);
        Connection conn2 = TestUtil.getNetConnection(netPort, "/;user=app;password=app", null);
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) ) partition by column (tid) " + this.getSuffix());
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 5;
        PreparedStatement ps = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?, ?)");
        for (int i = 0; i < 5; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "XXXX" + i);
            ps.setDouble(3, i);
            ps.setString(4, "nasdaq");
            ps.setInt(5, i);
            ps.executeUpdate();
        }
        conn.commit();
        PreparedStatement psUpdate = conn.prepareStatement("update trade.securities set symbol = ? where sec_id = ? and tid = ?");
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        ResultSet rs = st.executeQuery("select * from trade.securities");
        int numRowsReturned = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numRowsReturned;
        }
        TransactionDUnit.assertEquals((String)("Expected 5 row but found " + numRowsReturned), (int)5, (int)numRowsReturned);
        Statement st2 = conn2.createStatement();
        rs = st2.executeQuery("select * from trade.securities");
        numRowsReturned = 0;
        while (rs.next()) {
            TransactionDUnit.assertFalse((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("XXX"));
            ++numRowsReturned;
        }
        TransactionDUnit.assertEquals((String)("Expected 5 row but found " + numRowsReturned), (int)5, (int)numRowsReturned);
        conn.rollback();
        conn.commit();
        rs = st.executeQuery("select * from trade.securities");
        int numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("XXXX"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        rs.close();
        rs = st2.executeQuery("select * from trade.securities");
        numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("XXXX"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        rs.close();
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        conn.commit();
        rs = st.executeQuery("select * from trade.securities");
        numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        rs = st2.executeQuery("select * from trade.securities");
        numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        conn.commit();
        conn2.commit();
        rs.close();
        st.close();
        st2.close();
        psUpdate.close();
        ps.close();
        conn.close();
        conn2.close();
    }

    public static <V, K> Region<K, V> createRegion() throws Exception {
        AttributesFactory af = new AttributesFactory();
        af.setIndexMaintenanceSynchronous(true);
        af.setDataPolicy(DataPolicy.PARTITION);
        af.setPartitionAttributes(new PartitionAttributesFactory().setLocalMaxMemory(0).create());
        Region region = Misc.getGemFireCache().createRegion("TXTest", af.create());
        return region;
    }

    public static Region createRegionStore() throws Exception {
        Region r = Misc.getGemFireCache().getRegion("TXTest");
        if (r != null) {
            return null;
        }
        AttributesFactory af = new AttributesFactory();
        af.setIndexMaintenanceSynchronous(true);
        af.setDataPolicy(DataPolicy.PARTITION);
        af.setPartitionAttributes(new PartitionAttributesFactory().setLocalMaxMemory(10).create());
        Region region = Misc.getGemFireCache().createRegion("TXTest", af.create());
        return region;
    }

    public void testBulkTransactionalUpdatesRollbackAndCommitClientServerReplicateTable() throws Exception {
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, "/;user=app;password=app", null);
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) )  replicate " + this.getSuffix());
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 5;
        PreparedStatement ps = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?, ?)");
        for (int i = 0; i < 5; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "XXXX" + i);
            ps.setDouble(3, i);
            ps.setString(4, "nasdaq");
            ps.setInt(5, i);
            ps.executeUpdate();
        }
        conn.commit();
        PreparedStatement psUpdate = conn.prepareStatement("update trade.securities set symbol = ? where sec_id = ? and tid = ?");
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        ResultSet rs = st.executeQuery("select * from trade.securities");
        int numRowsReturned = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got" + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numRowsReturned;
        }
        TransactionDUnit.assertEquals((String)("Expected 5 row but found " + numRowsReturned), (int)5, (int)numRowsReturned);
        conn.rollback();
        conn.commit();
        rs = st.executeQuery("select * from trade.securities");
        int numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("XXXX"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        rs.close();
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        conn.commit();
        rs = st.executeQuery("select * from trade.securities");
        numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        conn.commit();
        rs.close();
        st.close();
        psUpdate.close();
        ps.close();
        conn.close();
    }

    public void testNonKeyBasedTransactionalUpdatesRollbackAndCommitReplicateTable() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) )  replicate " + this.getSuffix());
        conn.commit();
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(this.getIsolationLevel());
        int numRows = 5;
        PreparedStatement ps = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?, ?)");
        for (int i = 0; i < 5; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "XXXX" + i);
            ps.setDouble(3, i);
            ps.setString(4, "nasdaq");
            ps.setInt(5, i);
            ps.executeUpdate();
        }
        conn.commit();
        PreparedStatement psUpdate = conn.prepareStatement("update trade.securities set symbol = ? where sec_id = ? and tid = ?");
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        ResultSet rs = st.executeQuery("select * from trade.securities");
        int numRowsReturned = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got" + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numRowsReturned;
        }
        TransactionDUnit.assertEquals((String)("Expected 5 row but found " + numRowsReturned), (int)5, (int)numRowsReturned);
        conn.rollback();
        conn.commit();
        rs = st.executeQuery("select * from trade.securities");
        int numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("XXXX"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        rs.close();
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        conn.commit();
        rs = st.executeQuery("select * from trade.securities");
        numUpdates = 0;
        while (rs.next()) {
            TransactionDUnit.assertTrue((String)("Got " + rs.getString("SYMBOL").trim()), (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numUpdates;
        }
        TransactionDUnit.assertEquals((int)5, (int)numUpdates);
        conn.commit();
        rs.close();
        st.close();
        psUpdate.close();
        ps.close();
        conn.close();
    }

    public void testBug41970_43473() throws Throwable {
        Thread t;
        Throwable[] failure;
        Connection conn;
        block5: {
            this.startVMs(1, 1);
            conn = TestUtil.jdbcConn;
            conn.setTransactionIsolation(this.getIsolationLevel());
            conn.setAutoCommit(false);
            Statement st = conn.createStatement();
            st.execute("create table customers (cid int not null, cust_name varchar(100),  addr varchar(100), tid int, primary key (cid))");
            st.execute("create table trades (tid int, cid int, eid int, primary Key (tid), foreign key (cid) references customers (cid))" + this.getSuffix());
            PreparedStatement pstmt = conn.prepareStatement("insert into customers values(?,?,?,?)");
            pstmt.setInt(1, 1);
            pstmt.setString(2, "name1");
            pstmt.setString(3, "add1");
            pstmt.setInt(4, 1);
            pstmt.executeUpdate();
            pstmt.setInt(1, 2);
            pstmt.setString(2, "name2");
            pstmt.setString(3, "add2");
            pstmt.setInt(4, 1);
            pstmt.executeUpdate();
            conn.commit();
            ResultSet rs = st.executeQuery("Select * from customers");
            int numRows = 0;
            while (rs.next()) {
                ++numRows;
            }
            TransactionDUnit.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
            rs.close();
            conn.commit();
            st.execute("create table sellorders (oid int not null primary key, cid int, order_time timestamp, status varchar(10), constraint ch check (status in ('cancelled', 'open', 'filled')))" + this.getSuffix());
            pstmt = conn.prepareStatement("insert into sellorders values (?, ?, ?, ?)");
            long currentTime = System.currentTimeMillis();
            Timestamp ts = new Timestamp(currentTime - 100L);
            Timestamp now = new Timestamp(currentTime);
            for (int id = 1; id <= 100; ++id) {
                pstmt.setInt(1, id);
                pstmt.setInt(2, id * 2);
                pstmt.setTimestamp(3, ts);
                pstmt.setString(4, "open");
                pstmt.execute();
            }
            conn.commit();
            final CyclicBarrier barrier = new CyclicBarrier(2);
            failure = new Throwable[1];
            t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn2 = TestUtil.getConnection();
                        conn2.setTransactionIsolation(TransactionDUnit.this.getIsolationLevel());
                        conn2.setAutoCommit(false);
                        PreparedStatement pstmt2 = conn2.prepareStatement("update sellorders set cid = ? where oid = ?");
                        pstmt2.setInt(1, 7);
                        pstmt2.setInt(2, 3);
                        TestCase.assertEquals((int)1, (int)pstmt2.executeUpdate());
                        pstmt2.setInt(1, 3);
                        pstmt2.setInt(2, 1);
                        TestCase.assertEquals((int)1, (int)pstmt2.executeUpdate());
                        TransactionDUnit.this.getServerVM(1).invoke(TransactionDUnit.class, "installObservers");
                        barrier.await();
                        conn2.commit();
                    }
                    catch (Throwable t) {
                        failure[0] = t;
                    }
                }
            });
            t.start();
            pstmt = conn.prepareStatement("update sellorders set status = 'cancelled' where order_time < ? and status = 'open'");
            pstmt.setTimestamp(1, now);
            barrier.await();
            try {
                pstmt.executeUpdate();
                TransactionDUnit.fail((String)"expected conflict exception");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) break block5;
                throw sqle;
            }
        }
        conn.close();
        t.join();
        if (failure[0] != null) {
            throw failure[0];
        }
        this.serverExecute(1, (Runnable)new SerializableRunnable(){

            public void run() {
                GemFireCacheImpl.getExisting().getTxManager().setObserver(null);
                GemFireXDQueryObserverHolder.clearInstance();
            }
        });
    }

    public void testBug41976() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create table customers (cid int not null, cust_name varchar(100),  addr varchar(100), tid int, primary key (cid))" + this.getSuffix());
        PreparedStatement pstmt = conn.prepareStatement("insert into customers values(?,?,?,?)");
        pstmt.setInt(1, 1);
        pstmt.setString(2, "name1");
        pstmt.setString(3, "add1");
        pstmt.setInt(4, 1);
        pstmt.executeUpdate();
        conn.commit();
        int n = st.executeUpdate("update customers set cust_name = 'dummy' where cid=5");
        TransactionDUnit.assertEquals((int)0, (int)n);
        conn.commit();
        pstmt.setInt(1, 5);
        pstmt.setString(2, "name5");
        pstmt.setString(3, "add5");
        pstmt.setInt(4, 1);
        pstmt.executeUpdate();
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from customers");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        conn.commit();
        n = st.executeUpdate("update  customers set cust_name = 'dummy' where cid=6");
        TransactionDUnit.assertEquals((int)0, (int)n);
        pstmt.setInt(1, 6);
        pstmt.setString(2, "name6");
        pstmt.setString(3, "add6");
        pstmt.setInt(4, 1);
        pstmt.executeUpdate();
        conn.commit();
        rs = st.executeQuery("Select * from customers");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"ResultSet should contain two rows ", (int)3, (int)numRows);
        conn.commit();
        conn.close();
    }

    public void testBug41956() throws Exception {
        this.startVMs(2, 2);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid))  partition by list (cid) (VALUES (16, 8, 10, 9), VALUES (7, 6, 0, 13), VALUES (17, 5, 4, 15), VALUES (1, 2, 3, 11, 12, 14)) " + this.getSuffix());
        st.execute("create table trade.trades (tid int, cid int, eid int, tradedate date, primary Key (tid), foreign key (cid) references trade.customers (cid))  " + this.getSuffix());
        PreparedStatement pstmt = conn.prepareStatement("insert into trade.customers values(?,?,?,?)");
        pstmt.setInt(1, 1);
        pstmt.setString(2, "name1");
        pstmt.setString(3, "add1");
        pstmt.setInt(4, 1);
        pstmt.executeUpdate();
        conn.commit();
        int n = st.executeUpdate("update trade.customers set cust_name = 'dummy' where cid = 1");
        TransactionDUnit.assertEquals((int)1, (int)n);
        this.gotConflict = false;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        conn1.setAutoCommit(false);
                        conn1.setTransactionIsolation(TransactionDUnit.this.getIsolationLevel());
                        Statement stmt = conn1.createStatement();
                        try {
                            TestCase.assertEquals((int)1, (int)stmt.executeUpdate("delete from trade.customers where cid = 1 and tid = 1"));
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) {
                                TransactionDUnit.this.gotConflict = true;
                                conn1.rollback();
                                break block5;
                            }
                            throw sqle;
                        }
                    }
                    catch (SQLException sqle) {
                        TransactionDUnit.this.gotConflict = false;
                        TransactionDUnit.this.getLogWriter().error((Object)"unexpected exception", (Throwable)sqle);
                        DistributedSQLTestBase.fail("unexpected exception", sqle);
                    }
                }
            }
        };
        Thread th = new Thread(runnable);
        th.start();
        th.join();
        TransactionDUnit.assertTrue((String)"expected conflict", (boolean)this.gotConflict);
        this.gotConflict = false;
        conn.commit();
        ResultSet rs = st.executeQuery("select * from trade.customers");
        TransactionDUnit.assertTrue((boolean)rs.next());
        TransactionDUnit.assertEquals((int)1, (int)rs.getInt(1));
        TransactionDUnit.assertEquals((String)"dummy", (String)rs.getString(2));
        TransactionDUnit.assertEquals((String)"add1", (String)rs.getString(3));
        TransactionDUnit.assertEquals((int)1, (int)rs.getInt(1));
        TransactionDUnit.assertFalse((boolean)rs.next());
        conn.commit();
        conn.close();
    }

    public void testBug41974() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("create table customers (cid int not null, cust_name varchar(100),  addr varchar(100), tid int, primary key (cid))" + this.getSuffix());
        PreparedStatement pstmt = conn.prepareStatement("insert into customers values(?,?,?,?)");
        pstmt.setInt(1, 1);
        pstmt.setString(2, "name1");
        pstmt.setString(3, "add1");
        pstmt.setInt(4, 1);
        TransactionDUnit.assertEquals((int)1, (int)pstmt.executeUpdate());
        conn.commit();
        TransactionDUnit.assertEquals((int)0, (int)st.executeUpdate("update customers set cust_name = 'dummy' where cid=5"));
        conn.commit();
        pstmt.setInt(1, 5);
        pstmt.setString(2, "name5");
        pstmt.setString(3, "add5");
        pstmt.setInt(4, 1);
        TransactionDUnit.assertEquals((int)1, (int)pstmt.executeUpdate());
        conn.commit();
        TransactionDUnit.assertEquals((int)1, (int)st.executeUpdate("update  customers set cust_name = 'dummy' where cid=5"));
        conn.commit();
        conn.close();
    }

    public void testBug42014() throws Exception {
        this.startVMs(1, 3);
        this.clientSQLExecute(1, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int) partition by list (tid) (values(1,2))" + this.getSuffix());
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        this.clientSQLExecute(1, "Insert into  trade.portfolio values(1,1,1724, 1,7865.66666,1)");
        this.clientSQLExecute(1, "Insert into  trade.portfolio values(2,1,1731, 1,7865.66666,1)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("update trade.portfolio set subTotal = qty * ? where sid = ? ");
        pstmt.setBigDecimal(1, new BigDecimal(13.96));
        pstmt.setInt(2, 1);
        TransactionDUnit.assertEquals((int)2, (int)pstmt.executeUpdate());
        conn.commit();
        String query = "select cid, subTotal from trade.portfolio where  sid = 1 ";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        TransactionDUnit.assertTrue((boolean)rs.next());
        BigDecimal value = rs.getBigDecimal(2);
        if (rs.getInt(1) == 1) {
            TransactionDUnit.assertEquals((int)22412, (int)value.intValue());
        } else {
            TransactionDUnit.assertEquals((int)22503, (int)value.intValue());
        }
        TransactionDUnit.assertTrue((boolean)rs.next());
        value = rs.getBigDecimal(2);
        if (rs.getInt(1) == 1) {
            TransactionDUnit.assertEquals((int)22412, (int)value.intValue());
        } else {
            TransactionDUnit.assertEquals((int)22503, (int)value.intValue());
        }
        conn.commit();
    }

    public void testBug42031IsolationAndTXData() throws Exception {
        Integer got;
        this.startClientVMs(1, 0, null);
        this.startServerVMs(1, -1, "SG1");
        this.clientSQLExecute(1, "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024), ADDRESS varchar(1024), ID1 int)" + this.getSuffix());
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("Insert into TESTTABLE values(114,'desc114','Add114',114)");
        stmt.executeUpdate("Insert into TESTTABLE values(1,'desc1','Add1',1)");
        stmt.executeUpdate("Insert into TESTTABLE values(227,'desc227','Add227',227)");
        stmt.executeUpdate("Insert into TESTTABLE values(340,'desc340','Add340',340)");
        conn.rollback();
        stmt.executeUpdate("Insert into TESTTABLE values(114,'desc114','Add114',114)");
        stmt.executeUpdate("Insert into TESTTABLE values(2,'desc1','Add1',1)");
        stmt.executeUpdate("Insert into TESTTABLE values(224,'desc227','Add227',227)");
        stmt.executeUpdate("Insert into TESTTABLE values(331,'desc340','Add340',340)");
        conn.commit();
        stmt.executeUpdate("update TESTTABLE set ID1 = ID1 +1 ");
        ResultSet rs = stmt.executeQuery("select ID1 from  TESTTABLE");
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(1);
        expected.add(227);
        expected.add(340);
        expected.add(114);
        HashSet<Integer> expected2 = new HashSet<Integer>();
        expected2.add(2);
        expected2.add(228);
        expected2.add(341);
        expected2.add(115);
        int numRows = 0;
        while (rs.next()) {
            got = rs.getInt(1);
            TransactionDUnit.assertTrue((boolean)expected2.contains(got));
            ++numRows;
        }
        TransactionDUnit.assertEquals((int)expected2.size(), (int)numRows);
        conn.rollback();
        rs = stmt.executeQuery("select ID1 from TESTTABLE");
        numRows = 0;
        while (rs.next()) {
            got = rs.getInt(1);
            TransactionDUnit.assertTrue((boolean)expected.contains(got));
            ++numRows;
        }
        TransactionDUnit.assertEquals((int)expected.size(), (int)numRows);
        stmt.executeUpdate("update TESTTABLE set ID1 = ID1 +1 ");
        rs = stmt.executeQuery("select ID1 from TESTTABLE");
        numRows = 0;
        while (rs.next()) {
            got = rs.getInt(1);
            TransactionDUnit.assertTrue((boolean)expected2.contains(got));
            ++numRows;
        }
        TransactionDUnit.assertEquals((int)expected2.size(), (int)numRows);
        conn.commit();
        rs = stmt.executeQuery("select ID1 from TESTTABLE");
        numRows = 0;
        while (rs.next()) {
            got = rs.getInt(1);
            TransactionDUnit.assertTrue((boolean)expected2.contains(got));
            ++numRows;
        }
        TransactionDUnit.assertEquals((int)expected2.size(), (int)numRows);
    }

    public void testBug41873_1() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, -1, "SG1");
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null) redundancy 1 partition by column (c1) " + this.getSuffix());
        conn.commit();
        Statement st = conn.createStatement();
        st.execute("insert into t1 values (1, 1,1,1)");
        st.execute("insert into t1 values (114, 114,114,114)");
        conn.commit();
        st.execute("update t1 set c2 =2 where c1 =1");
        st.execute("update t1 set c3 =3 where c1 =1");
        st.execute("update t1 set c4 =4 where c1 =1");
        st.execute("update t1 set c2 =3 where c1 = 114");
        st.execute("update t1 set c3 =4 where c1 =114");
        st.execute("update t1 set c4 =5 where c1 =114");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from t1 where c1 = 1");
        rs.next();
        TransactionDUnit.assertEquals((int)1, (int)rs.getInt(1));
        TransactionDUnit.assertEquals((int)2, (int)rs.getInt(2));
        TransactionDUnit.assertEquals((int)3, (int)rs.getInt(3));
        TransactionDUnit.assertEquals((int)4, (int)rs.getInt(4));
        rs = st.executeQuery("Select * from t1 where c1 = 114");
        rs.next();
        TransactionDUnit.assertEquals((int)114, (int)rs.getInt(1));
        TransactionDUnit.assertEquals((int)3, (int)rs.getInt(2));
        TransactionDUnit.assertEquals((int)4, (int)rs.getInt(3));
        TransactionDUnit.assertEquals((int)5, (int)rs.getInt(4));
        conn.commit();
    }

    public void testBug42067_1() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, -1, "SG1");
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null, c2 int not null, c3 int not null, c4 int not null) redundancy 1 partition by column (c1) " + this.getSuffix());
        conn.commit();
        Statement st = conn.createStatement();
        st.execute("insert into t1 values (1, 1,1,1)");
        st.execute("insert into t1 values (114, 114,114,114)");
        conn.commit();
        st.execute("delete from t1 where c1 =1 and c3 =1");
        st.execute("update t1 set c2 =2 where c1 =1 and c3 =1");
        conn.commit();
    }

    public void testBug42067_2() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, -1, "SG1");
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, c4 int not null) redundancy 1 partition by column (c1) " + this.getSuffix());
        conn.commit();
        Statement st = conn.createStatement();
        st.execute("insert into t1 values (1, 1,1,1)");
        st.execute("insert into t1 values (114, 114,114,114)");
        conn.commit();
        st.execute("delete from t1 where c1 =1 and c3 =1");
        st.execute("update t1 set c2 =2 where c1 =1 and c3 =1");
        conn.commit();
        ResultSet rs = st.executeQuery("select * from t1");
        TransactionDUnit.assertTrue((boolean)rs.next());
        TransactionDUnit.assertEquals((int)114, (int)rs.getInt(1));
        TransactionDUnit.assertFalse((boolean)rs.next());
    }

    public void testBug42311_1() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, c4 int not null) partition by column (c2) " + this.getSuffix());
        conn.commit();
        Statement st = conn.createStatement();
        st.execute("insert into t1 values (4, 20,13,7), (5, 30, 56,7), (3, 40,7,7), (6, 30,7,7), (8, 5,6,6)");
        conn.commit();
    }

    public void testBug42311_2() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, c4 int not null) partition by column (c2) " + this.getSuffix());
        conn.commit();
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?,?,?,?)");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.setInt(3, i);
            ps.setInt(4, i);
            ps.addBatch();
        }
        ps.executeBatch();
        conn.commit();
    }

    public void testBugPutAllDataLossAsBuggyDistribution() throws Exception {
        this.reduceLogLevelForTest("config");
        this.startServerVMs(2, 0, null);
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        this.serverSQLExecute(1, "Create table app.t1 (c1 int not null primary key, c2 int not null, c3 int not null, c4 int not null) partition by column (c2) redundancy 1" + this.getSuffix());
        conn.commit();
        this.getLogWriter().info((Object)"created table app.t1");
        Statement s = conn.createStatement();
        s.execute("insert into app.t1 values(10, 10, 10, 10)");
        PreparedStatement ps = conn.prepareStatement("insert into app.t1 values (?,?,?,?)");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, 2);
            ps.setInt(3, i);
            ps.setInt(4, i);
            ps.addBatch();
        }
        ps.executeBatch();
        this.getLogWriter().info((Object)"commiting batch");
        conn.commit();
        TXManagerImpl.waitForPendingCommitForTest();
        this.getLogWriter().info((Object)"verifying");
        for (VM vm : this.serverVMs) {
            vm.invoke(TransactionDUnit.class, "verifyNumEntries", new Object[]{1, 10, "APP/T1"});
        }
        for (VM vm : this.serverVMs) {
            vm.invoke(TransactionDUnit.class, "verifyNumEntries", new Object[]{10, 2, "APP/T1"});
        }
    }

    public static void verifyNumEntries(int expectedNum, int bucketid, String regionName) {
        TransactionDUnit.getGlobalLogger().info((Object)"executing verifyNumEntries");
        Region r = Misc.getRegion((String)regionName, (boolean)true, (boolean)false);
        PartitionedRegion pr = (PartitionedRegion)r;
        PartitionedRegionDataStore ds = pr.getDataStore();
        Set brs = ds.getAllLocalBucketRegions();
        for (BucketRegion b : brs) {
            if (b.getId() != bucketid) continue;
            int entryCnt = b.entryCount();
            TransactionDUnit.getGlobalLogger().info((Object)("executing verifyNumEntries for bucket region: " + b + " entry count is: " + entryCnt));
            TransactionDUnit.assertEquals((int)expectedNum, (int)entryCnt);
        }
    }

    public void testMultipleInsertFromThinClient_bug44242() throws Exception {
        this.startServerVMs(2, 0, null);
        int port = this.startNetworkServer(1, null, null);
        Connection netConn = TestUtil.getNetConnection(port, null, null);
        netConn.createStatement().execute("create schema emp");
        netConn.close();
        for (int i = 0; i < 2; ++i) {
            Statement s;
            Connection netConn2;
            block4: {
                Connection netConn1 = TestUtil.getNetConnection(port, null, null);
                netConn2 = TestUtil.getNetConnection(port, null, null);
                s = netConn1.createStatement();
                String ext = "";
                if (i == 1) {
                    ext = "replicate";
                }
                s.execute("create table emp.EMPLOYEE_parent(lastname varchar(30) primary key, depId int)" + ext + this.getSuffix());
                s.execute("create table emp.EMPLOYEE(lastname varchar(30) primary key, depId int, foreign key(lastname) references emp.EMPLOYEE_parent(lastname) on delete restrict)" + ext + this.getSuffix());
                s.execute("insert into emp.EMPLOYEE_parent values('Jones', 10), ('Rafferty', 50), ('Robinson', 100)");
                netConn2.setTransactionIsolation(2);
                netConn2.setAutoCommit(false);
                Statement s2 = netConn2.createStatement();
                s2.execute("delete from emp.EMPLOYEE_parent");
                s2.execute("select * from emp.employee_parent");
                netConn1.setTransactionIsolation(2);
                netConn1.setAutoCommit(false);
                PreparedStatement pstmnt = netConn1.prepareStatement("INSERT INTO emp.employee VALUES (?, ?)");
                pstmnt.setString(1, "Jones");
                pstmnt.setInt(2, 33);
                pstmnt.addBatch();
                pstmnt.setString(1, "Rafferty");
                pstmnt.setInt(2, 31);
                pstmnt.addBatch();
                pstmnt.setString(1, "Robinson");
                pstmnt.setInt(2, 34);
                pstmnt.addBatch();
                try {
                    pstmnt.executeBatch();
                    netConn1.commit();
                    TransactionDUnit.fail((String)"commit should have failed");
                }
                catch (SQLException e) {
                    if ("X0Z02".equals(e.getSQLState())) break block4;
                    throw e;
                }
            }
            netConn2.commit();
            s.execute("drop table emp.employee");
            s.execute("drop table emp.employee_parent");
        }
    }

    public void testFK_NoGlobalIndex_differentThread() throws Exception {
        Statement stmt;
        Connection conn;
        block3: {
            this.startVMs(1, 2);
            conn = TestUtil.jdbcConn;
            this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null)" + this.getSuffix());
            this.clientSQLExecute(1, "Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
            this.clientSQLExecute(1, "insert into t1 values(1, 1, 1)");
            conn.setTransactionIsolation(this.getIsolationLevel());
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt.execute("insert into t2 values(1, 1, 1)");
            try {
                stmt.execute("insert into t2 values(2, 2, 2)");
                TransactionDUnit.fail((String)"the above insert should have failed");
            }
            catch (SQLException ex) {
                TestUtil.getLogger().info((Object)("exception state is: " + ex.getSQLState()), (Throwable)ex);
                if ("23503".equals(ex.getSQLState())) break block3;
                throw ex;
            }
        }
        stmt.execute("insert into t1 values(2, 2, 2)");
        stmt.execute("insert into t2 values(2, 2, 2)");
        this.threadEx = null;
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Statement newstmt;
                    Connection newConn;
                    block7: {
                        newConn = TestUtil.getConnection();
                        newConn.setTransactionIsolation(TransactionDUnit.this.getIsolationLevel());
                        newConn.setAutoCommit(false);
                        newstmt = newConn.createStatement();
                        try {
                            TransactionDUnit.this.addExpectedException(new int[]{1}, new int[]{1}, ConflictException.class);
                            newstmt.execute("insert into t2 values(2, 2, 2)");
                            TestCase.fail((String)"ConflictException should have come");
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) break block7;
                            throw sqle;
                        }
                    }
                    TransactionDUnit.this.removeExpectedException(new int[0], new int[0], ConflictException.class);
                    try {
                        newstmt.execute("insert into t2 values(3, 3, 3)");
                        TestCase.fail((String)"the above insert should have failed");
                    }
                    catch (SQLException ex) {
                        TestUtil.getLogger().info((Object)("exception state is: " + ex.getSQLState()), (Throwable)ex);
                        if (!"23503".equals(ex.getSQLState())) {
                            throw ex;
                        }
                        newstmt.close();
                        newConn.commit();
                    }
                }
                catch (Throwable t) {
                    TransactionDUnit.this.getLogWriter().error((Object)"unexpected exception", t);
                    TransactionDUnit.this.threadEx = t;
                    TestCase.fail((String)("unexpected exception " + t));
                }
            }
        });
        th.start();
        th.join();
        if (this.threadEx != null) {
            throw new TestException("unexpected exception in thread", this.threadEx);
        }
        stmt.close();
        conn.commit();
    }

    public void testFK_NoGlobalIndexSameThread() throws Exception {
        Statement newstmt;
        Connection newConn;
        Statement stmt;
        Connection conn;
        block8: {
            block7: {
                block6: {
                    this.startVMs(1, 2);
                    conn = TestUtil.jdbcConn;
                    this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null)" + this.getSuffix());
                    this.clientSQLExecute(1, "Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
                    this.clientSQLExecute(1, "insert into t1 values(1, 1, 1)");
                    conn.setTransactionIsolation(this.getIsolationLevel());
                    conn.setAutoCommit(false);
                    stmt = conn.createStatement();
                    stmt.execute("insert into t2 values(1, 1, 1)");
                    try {
                        stmt.execute("insert into t2 values(2, 2, 2)");
                        TransactionDUnit.fail((String)"the above insert should have failed");
                    }
                    catch (SQLException ex) {
                        TestUtil.getLogger().info((Object)("exception state is: " + ex.getSQLState()), (Throwable)ex);
                        if ("23503".equals(ex.getSQLState())) break block6;
                        throw ex;
                    }
                }
                stmt.execute("insert into t1 values(2, 2, 2)");
                stmt.execute("insert into t2 values(2, 2, 2)");
                newConn = TestUtil.getConnection();
                newConn.setTransactionIsolation(this.getIsolationLevel());
                newConn.setAutoCommit(false);
                newstmt = newConn.createStatement();
                try {
                    this.addExpectedException(new int[]{1}, new int[]{1}, ConflictException.class);
                    newstmt.execute("insert into t2 values(2, 2, 2)");
                    TransactionDUnit.fail((String)"ConflictException should have come");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block7;
                    throw sqle;
                }
            }
            this.removeExpectedException(new int[0], new int[0], ConflictException.class);
            try {
                newstmt.execute("insert into t2 values(3, 3, 3)");
                TransactionDUnit.fail((String)"the above insert should have failed");
            }
            catch (SQLException ex) {
                TestUtil.getLogger().info((Object)("exception state is: " + ex.getSQLState()), (Throwable)ex);
                if ("23503".equals(ex.getSQLState())) break block8;
                throw ex;
            }
        }
        stmt.close();
        conn.commit();
        newstmt.close();
        newConn.commit();
    }

    public void testFK_GlobalIndexDifferentThread() throws Exception {
        Statement stmt;
        Connection conn;
        block3: {
            this.startVMs(1, 2);
            conn = TestUtil.jdbcConn;
            this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null) partition by column(c2)" + this.getSuffix());
            this.clientSQLExecute(1, "Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
            this.clientSQLExecute(1, "insert into t1 values(1, 1, 1)");
            conn.setTransactionIsolation(this.getIsolationLevel());
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt.execute("insert into t2 values(1, 1, 1)");
            try {
                stmt.execute("insert into t2 values(2, 2, 2)");
                TransactionDUnit.fail((String)"the above insert should have failed");
            }
            catch (SQLException ex) {
                TestUtil.getLogger().info((Object)("exception state is: " + ex.getSQLState()), (Throwable)ex);
                if ("23503".equals(ex.getSQLState())) break block3;
                throw ex;
            }
        }
        stmt.execute("insert into t1 values(2, 2, 2)");
        stmt.execute("insert into t2 values(2, 2, 2)");
        this.threadEx = null;
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Statement newstmt;
                    Connection newConn;
                    block7: {
                        newConn = TestUtil.getConnection();
                        newConn.setTransactionIsolation(TransactionDUnit.this.getIsolationLevel());
                        newConn.setAutoCommit(false);
                        newstmt = newConn.createStatement();
                        try {
                            TransactionDUnit.this.addExpectedException(new int[]{1}, new int[]{1}, ConflictException.class);
                            newstmt.execute("insert into t2 values(2, 2, 2)");
                            TestCase.fail((String)"ConflictException should have come");
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) break block7;
                            throw sqle;
                        }
                    }
                    TransactionDUnit.this.removeExpectedException(new int[0], new int[0], ConflictException.class);
                    try {
                        newstmt.execute("insert into t2 values(3, 3, 3)");
                        TestCase.fail((String)"the above insert should have failed");
                    }
                    catch (SQLException ex) {
                        TestUtil.getLogger().info((Object)("exception state is: " + ex.getSQLState()), (Throwable)ex);
                        if (!"23503".equals(ex.getSQLState())) {
                            throw ex;
                        }
                        newstmt.close();
                        newConn.commit();
                    }
                }
                catch (Throwable t) {
                    TransactionDUnit.this.getLogWriter().error((Object)"unexpected exception", t);
                    TransactionDUnit.this.threadEx = t;
                }
            }
        });
        th.start();
        th.join();
        if (this.threadEx != null) {
            throw new TestException("unexpected exception in thread", this.threadEx);
        }
        stmt.close();
        conn.commit();
    }

    public void testFK_GlobalIndexSameThread() throws Exception {
        Statement newstmt;
        Connection newConn;
        Statement stmt;
        Connection conn;
        block8: {
            block7: {
                block6: {
                    this.startVMs(1, 2);
                    conn = TestUtil.jdbcConn;
                    this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null) partition by column(c2)" + this.getSuffix());
                    this.clientSQLExecute(1, "Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
                    this.clientSQLExecute(1, "insert into t1 values(1, 1, 1)");
                    conn.setTransactionIsolation(this.getIsolationLevel());
                    conn.setAutoCommit(false);
                    stmt = conn.createStatement();
                    stmt.execute("insert into t2 values(1, 1, 1)");
                    try {
                        stmt.execute("insert into t2 values(2, 2, 2)");
                        TransactionDUnit.fail((String)"the above insert should have failed");
                    }
                    catch (SQLException ex) {
                        TestUtil.getLogger().info((Object)("exception state is: " + ex.getSQLState()), (Throwable)ex);
                        if ("23503".equals(ex.getSQLState())) break block6;
                        throw ex;
                    }
                }
                stmt.execute("insert into t1 values(2, 2, 2)");
                stmt.execute("insert into t2 values(2, 2, 2)");
                newConn = TestUtil.getConnection();
                newConn.setTransactionIsolation(this.getIsolationLevel());
                newConn.setAutoCommit(false);
                newstmt = newConn.createStatement();
                try {
                    this.addExpectedException(new int[]{1}, new int[]{1}, ConflictException.class);
                    newstmt.execute("insert into t2 values(2, 2, 2)");
                    TransactionDUnit.fail((String)"ConflictException should have come");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block7;
                    throw sqle;
                }
            }
            this.removeExpectedException(new int[0], new int[0], ConflictException.class);
            try {
                newstmt.execute("insert into t2 values(3, 3, 3)");
                TransactionDUnit.fail((String)"the above insert should have failed");
            }
            catch (SQLException ex) {
                TestUtil.getLogger().info((Object)("exception state is: " + ex.getSQLState()), (Throwable)ex);
                if ("23503".equals(ex.getSQLState())) break block8;
                throw ex;
            }
        }
        stmt.close();
        conn.commit();
        newstmt.close();
        newConn.commit();
    }

    public void testFKWithBatching_49371() throws Throwable {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create table parent (pid int primary key, tid int unique) replicate");
        stmt.execute("create table child (cid int primary key, pid int, constraint p_fk foreign key (pid) references parent (pid) on delete restrict) replicate");
        stmt.execute("create table child2 (cid int primary key, tid int, constraint t_fk foreign key (tid) references parent (tid) on delete restrict) replicate");
        AsyncInvocation asyncServer = this.getServerVM(1).invokeAsync((Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    AnyCyclicBarrier barrier;
                    block7: {
                        Statement stmt;
                        Connection conn;
                        block6: {
                            barrier = new AnyCyclicBarrier(2, "fk_barrier");
                            long waitMillis = 10000L;
                            conn = TestUtil.getConnection();
                            conn.setTransactionIsolation(TransactionDUnit.this.getIsolationLevel());
                            conn.setAutoCommit(false);
                            stmt = conn.createStatement();
                            stmt.execute("insert into parent values (1, 2)");
                            stmt.execute("insert into parent values (2, 3)");
                            barrier.await(10000L);
                            barrier.await(10000L);
                            conn.rollback();
                            stmt.execute("insert into parent values (1, 2), (2, 3)");
                            conn.commit();
                            stmt.execute("delete from parent where pid=1");
                            stmt.execute("delete from parent where pid=2");
                            barrier.await(10000L);
                            barrier.await(10000L);
                            conn.commit();
                            stmt.execute("insert into parent values (3, 4), (4, 5)");
                            conn.commit();
                            barrier.await(10000L);
                            barrier.await(10000L);
                            try {
                                stmt.execute("delete from parent where pid=3");
                                conn.commit();
                                TestCase.fail((String)"expected to fail with conflict");
                            }
                            catch (SQLException sqle) {
                                if ("X0Z02".equals(sqle.getSQLState())) break block6;
                                throw sqle;
                            }
                        }
                        barrier.await(10000L);
                        barrier.await(10000L);
                        try {
                            stmt.execute("delete from parent where pid=4");
                            conn.commit();
                            TestCase.fail((String)"expected to fail with conflict");
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) break block7;
                            throw sqle;
                        }
                    }
                    barrier.await(10000L);
                }
                catch (Throwable t) {
                    TransactionDUnit.this.getLogWriter().error((Object)t);
                    throw new TestException("unexpected exception", t);
                }
            }
        });
        AsyncInvocation asyncChild = this.getServerVM(2).invokeAsync((Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    Statement stmt;
                    Connection conn;
                    AnyCyclicBarrier barrier;
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                block18: {
                                                    barrier = new AnyCyclicBarrier(2, "fk_barrier");
                                                    long waitMillis = 10000L;
                                                    conn = TestUtil.getConnection();
                                                    conn.setTransactionIsolation(TransactionDUnit.this.getIsolationLevel());
                                                    conn.setAutoCommit(false);
                                                    stmt = conn.createStatement();
                                                    barrier.await(10000L);
                                                    try {
                                                        stmt.execute("insert into child values (1, 1)");
                                                        TestCase.fail((String)"expected to fail with constraint violation");
                                                    }
                                                    catch (SQLException sqle) {
                                                        if ("23503".equals(sqle.getSQLState())) break block18;
                                                        throw sqle;
                                                    }
                                                }
                                                try {
                                                    stmt.execute("insert into child values (2, 2)");
                                                    TestCase.fail((String)"expected to fail with constraint violation");
                                                }
                                                catch (SQLException sqle) {
                                                    if ("23503".equals(sqle.getSQLState())) break block19;
                                                    throw sqle;
                                                }
                                            }
                                            try {
                                                stmt.execute("insert into child2 values (2, 2)");
                                                TestCase.fail((String)"expected to fail with constraint violation");
                                            }
                                            catch (SQLException sqle) {
                                                if ("23503".equals(sqle.getSQLState())) break block20;
                                                throw sqle;
                                            }
                                        }
                                        try {
                                            stmt.execute("insert into child2 values (3, 3)");
                                            TestCase.fail((String)"expected to fail with constraint violation");
                                        }
                                        catch (SQLException sqle) {
                                            if ("23503".equals(sqle.getSQLState())) break block21;
                                            throw sqle;
                                        }
                                    }
                                    barrier.await(10000L);
                                    barrier.await(10000L);
                                    try {
                                        stmt.execute("insert into child values (1, 1)");
                                        conn.commit();
                                        TestCase.fail((String)"expected to fail with conflict");
                                    }
                                    catch (SQLException sqle) {
                                        if ("X0Z02".equals(sqle.getSQLState())) break block22;
                                        throw sqle;
                                    }
                                }
                                try {
                                    stmt.execute("insert into child values (2, 2)");
                                    conn.commit();
                                    TestCase.fail((String)"expected to fail with conflict");
                                }
                                catch (SQLException sqle) {
                                    if ("X0Z02".equals(sqle.getSQLState())) break block23;
                                    throw sqle;
                                }
                            }
                            try {
                                stmt.execute("insert into child2 values (2, 2)");
                                conn.commit();
                                TestCase.fail((String)"expected to fail with conflict");
                            }
                            catch (SQLException sqle) {
                                if ("X0Z02".equals(sqle.getSQLState())) break block24;
                                throw sqle;
                            }
                        }
                        try {
                            stmt.execute("insert into child2 values (3, 3)");
                            conn.commit();
                            TestCase.fail((String)"expected to fail with conflict");
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) break block25;
                            throw sqle;
                        }
                    }
                    barrier.await(10000L);
                    barrier.await(10000L);
                    stmt.execute("insert into child values (3, 3)");
                    barrier.await(10000L);
                    barrier.await(10000L);
                    conn.commit();
                    stmt.execute("insert into child2 values (5, 5)");
                    barrier.await(10000L);
                    barrier.await(10000L);
                    conn.commit();
                }
                catch (Throwable t) {
                    TransactionDUnit.this.getLogWriter().error((Object)t);
                    throw new TestException("unexpected exception", t);
                }
            }
        });
        asyncServer.join();
        asyncChild.join();
        AnyCyclicBarrier.destroy((String)"fk_barrier");
        Throwable failure = null;
        if (asyncServer.exceptionOccurred()) {
            failure = asyncServer.getException();
        }
        if (asyncChild.exceptionOccurred()) {
            if (failure != null) {
                Throwable cause = failure;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                cause.initCause(asyncChild.getException());
            } else {
                failure = asyncChild.getException();
            }
        }
        if (failure != null) {
            throw failure;
        }
        Object[][] parentValues = new Object[][]{{4, 5}, {3, 4}};
        Object[][] childValues = new Object[][]{{3, 3}};
        Object[][] child2Values = new Object[][]{{5, 5}};
        ResultSet rs = stmt.executeQuery("select * from parent");
        JDBC.assertUnorderedResultSet(rs, parentValues, false);
        rs = stmt.executeQuery("select * from child");
        JDBC.assertUnorderedResultSet(rs, childValues, false);
        rs = stmt.executeQuery("select * from child2");
        JDBC.assertUnorderedResultSet(rs, child2Values, false);
    }

    public void test42822() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.jdbcConn;
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("create table oorder (o_w_id       integer      not null,o_d_id       integer      not null,o_id         integer      not null,o_c_id       integer,o_carrier_id integer,o_ol_cnt     decimal(2,0),o_all_local  decimal(1,0),o_entry_d    timestamp) partition by column (o_w_id)" + this.getSuffix());
        stmt.execute("create index oorder_carrier1 on oorder (o_w_id)");
        stmt.execute("create index oorder_carrier2 on oorder (o_d_id)");
        stmt.execute("create index oorder_carrier3 on oorder (o_c_id)");
        stmt.execute("insert into oorder (o_w_id, o_d_id, o_id, o_c_id) values (1, 2, 2, 1), (2, 4, 4, 2), (3, 6, 6, 3), (4, 8, 8, 4)");
        conn.commit();
        stmt.execute("delete from oorder where o_d_id > 6");
        stmt.execute("update oorder set o_c_id = o_w_id + 2 where o_w_id < 2");
        stmt.execute("update oorder set o_c_id = o_id + 1 where o_w_id >= 3");
        this.threadEx = null;
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = TestUtil.getConnection();
                    conn.setTransactionIsolation(TransactionDUnit.this.getIsolationLevel());
                    conn.setAutoCommit(false);
                    TransactionDUnit.this.checkResultsFor42822(conn, false);
                    barrier.await();
                    barrier.await();
                    TransactionDUnit.this.checkResultsFor42822(conn, true);
                    conn.commit();
                }
                catch (Throwable t) {
                    TransactionDUnit.this.getLogWriter().error((Object)"unexpected exception", t);
                    TransactionDUnit.this.threadEx = t;
                }
            }
        });
        t.start();
        this.checkResultsFor42822(conn, true);
        barrier.await();
        if (this.threadEx != null) {
            throw new TestException("unexpected exception in thread", this.threadEx);
        }
        conn.commit();
        this.checkResultsFor42822(conn, true);
        barrier.await();
        t.join();
        if (this.threadEx != null) {
            throw new TestException("unexpected exception in thread", this.threadEx);
        }
    }

    public void testSyncCommits() throws Throwable {
        int i;
        this.startVMs(1, 3);
        final int netPort = this.startNetworkServer(2, null, null);
        Properties props = new Properties();
        props.setProperty("sync-commits", "true");
        Connection conn = TestUtil.getConnection(props);
        Connection netConn = TestUtil.getNetConnection(netPort, null, props);
        Statement st = conn.createStatement();
        Statement netSt = netConn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1)) partition by primary key redundancy 2" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st = conn.createStatement();
        netConn.setTransactionIsolation(this.getIsolationLevel());
        netConn.setAutoCommit(false);
        int numThreads = 5;
        int numItems = 10;
        Thread[] thrs = new Thread[5];
        final CyclicBarrier barrier = new CyclicBarrier(6);
        final Throwable[] failure = new Throwable[1];
        for (i = 0; i < 5; ++i) {
            final int thrNum = i;
            thrs[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn = thrNum % 2 == 0 ? TestUtil.getConnection() : TestUtil.getNetConnection(netPort, null, null);
                        PreparedStatement pstmt = conn.prepareStatement("select count(*) from tran.t1");
                        barrier.await();
                        ResultSet rs = pstmt.executeQuery();
                        TestCase.assertTrue((boolean)rs.next());
                        TestCase.assertEquals((int)10, (int)rs.getInt(1));
                        TestCase.assertFalse((boolean)rs.next());
                        pstmt.close();
                        conn.close();
                        barrier.await(10L, TimeUnit.SECONDS);
                    }
                    catch (Throwable t) {
                        failure[0] = t;
                    }
                }
            });
            thrs[i].start();
        }
        for (i = 1; i <= 10; ++i) {
            String ins = "insert into tran.t1 values (" + i * 10 + ", " + i * 10 + ")";
            if (i % 2 == 0) {
                st.execute(ins);
                continue;
            }
            netSt.execute(ins);
        }
        this.serverExecute(1, (Runnable)new SerializableRunnable(){

            public void run() {
                TXManagerImpl txMgr = GemFireCacheImpl.getExisting().getCacheTransactionManager();
                txMgr.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                    public void afterIndividualCommitPhase1(TXStateProxy tx, Object callbackArg) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        conn.commit();
        netConn.commit();
        barrier.await();
        if (failure[0] != null) {
            TransactionDUnit.fail("unexpected failure in thread", failure[0]);
        }
        try {
            barrier.await(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            if (failure[0] != null) {
                TransactionDUnit.fail("unexpected failure in thread for " + e, failure[0]);
            }
            throw e;
        }
        ResultSet rs = st.executeQuery("Select * from tran.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"ResultSet should contain 10 rows ", (int)10, (int)numRows);
        VM vm = (VM)this.serverVMs.get(0);
        vm.invoke(((Object)((Object)this)).getClass(), "checkData", new Object[]{"TRAN.T1", 10L});
        this.serverExecute(1, (Runnable)new SerializableRunnable(){

            public void run() {
                TXManagerImpl txMgr = GemFireCacheImpl.getExisting().getCacheTransactionManager();
                txMgr.setObserver(null);
            }
        });
        rs.close();
        st.close();
        conn.commit();
        conn.close();
        netConn.close();
        for (Thread thr : thrs) {
            thr.join();
        }
        if (failure[0] != null) {
            throw failure[0];
        }
    }

    public void testBasicPersistence() throws Exception {
        int i;
        this.startVMs(1, 3);
        this.createDiskStore(false, 2);
        int totalOps = 1000;
        int txOps = 500;
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create table T1 (PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key (PkCol1, PkCol2)) Partition by column (PkCol1) PERSISTENT 'TestPersistenceDiskStore'" + this.getSuffix());
        st.execute("create index col3Index on T1 (col3)");
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        PreparedStatement psInsert = conn.prepareStatement("insert into t1 values(?, ?, ?, ?, ?)");
        for (i = 0; i < 500; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setInt(3, i);
            psInsert.setInt(4, i);
            psInsert.setString(5, "XXXX" + i);
            psInsert.executeUpdate();
            if (i % 2 == 0) {
                conn.commit();
                continue;
            }
            conn.rollback();
        }
        for (i = 500; i < 1000; i += 2) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setInt(3, i);
            psInsert.setInt(4, i);
            psInsert.setString(5, "XXXX" + i);
            psInsert.executeUpdate();
        }
        conn.commit();
        for (i = 501; i < 1000; i += 2) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setInt(3, i);
            psInsert.setInt(4, i);
            psInsert.setString(5, "XXXX" + i);
            psInsert.executeUpdate();
        }
        conn.rollback();
        ResultSet rs = st.executeQuery("select * from t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Table should have 500 rows", (int)500, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
        this.stopVMNums(1);
        this.stopVMNums(-1, -3, -2);
        this.restartVMNums(-2, -3, -1);
        this.restartVMNums(1);
        conn = TestUtil.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st = conn.createStatement();
        TIntHashSet results = new TIntHashSet(5000);
        rs = st.executeQuery("select * from t1");
        while (rs.next()) {
            int pkCol1 = rs.getInt(1);
            TransactionDUnit.assertTrue((String)("unexpected value for PkCol1 " + pkCol1), (pkCol1 >= 0 && pkCol1 < 1000 && pkCol1 % 2 == 0 ? 1 : 0) != 0);
            if (results.add(pkCol1)) continue;
            throw new TestException("unexpected duplicate value " + pkCol1);
        }
        TransactionDUnit.assertEquals((String)"Table should have 500 rows", (int)500, (int)results.size());
        rs.close();
        st.close();
        PreparedStatement pstmt = conn.prepareStatement("select * from t1 where col3 = ?");
        for (int index = 0; index < 1000; ++index) {
            pstmt.setInt(1, index);
            rs = pstmt.executeQuery();
            if (index % 2 == 0) {
                TransactionDUnit.assertTrue((boolean)rs.next());
                TransactionDUnit.assertEquals((int)index, (int)rs.getInt(1));
                TransactionDUnit.assertEquals((int)index, (int)rs.getInt(2));
                TransactionDUnit.assertEquals((int)index, (int)rs.getInt(3));
                TransactionDUnit.assertEquals((int)index, (int)rs.getInt(4));
                TransactionDUnit.assertFalse((boolean)rs.next());
            } else {
                TransactionDUnit.assertFalse((boolean)rs.next());
            }
            rs.close();
        }
        pstmt.close();
        conn.commit();
        conn.createStatement().execute("drop table t1");
        conn.commit();
        conn.close();
    }

    public void testNewNodeHA() throws Throwable {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1)) partition by primary key " + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        st.execute("insert into tran.t1 values (10, 10)");
        st.execute("insert into tran.t1 values (20, 20)");
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final Throwable[] failEx = new Throwable[]{null};
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Connection conn = TestUtil.getConnection();
                    conn.setAutoCommit(false);
                    Statement st = conn.createStatement();
                    conn.setTransactionIsolation(TransactionDUnit.this.getIsolationLevel());
                    st.execute("insert into tran.t1 values (30, 30)");
                    st.execute("insert into tran.t1 values (40, 40)");
                    barrier.await();
                    conn.commit();
                    st.execute("update tran.t1 set c2 = 60 where c1 = 30");
                    st.execute("update tran.t1 set c2 = 50 where c2 = 40");
                    st.execute("insert into tran.t1 values (60, 60)");
                    barrier.await();
                    conn.commit();
                    TXManagerImpl.waitForPendingCommitForTest();
                }
                catch (Throwable t) {
                    failEx[0] = t;
                    TransactionDUnit.this.getLogWriter().error((Object)"unexpected exception", t);
                }
            }
        });
        t.start();
        this.startVMs(1, 0);
        barrier.await();
        conn.commit();
        if (failEx[0] != null) {
            throw failEx[0];
        }
        st.execute("update tran.t1 set c2 = 50 where c1 = 20");
        st.execute("update tran.t1 set c2 = 40 where c2 = 10");
        st.execute("insert into tran.t1 values (50, 50)");
        this.startVMs(0, 1);
        Connection conn2 = TestUtil.getConnection();
        Statement st2 = conn2.createStatement();
        st2.execute("call sys.rebalance_all_buckets()");
        barrier.await();
        conn.commit();
        t.join();
        if (failEx[0] != null) {
            throw failEx[0];
        }
        TXManagerImpl.waitForPendingCommitForTest();
        SerializableRunnable checkRS = new SerializableRunnable(){

            public void run() {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    ResultSet rs = st.executeQuery("select * from tran.t1");
                    Object[][] expectedOutput = new Object[][]{{10, 40}, {20, 50}, {30, 60}, {40, 50}, {50, 50}, {60, 60}};
                    JDBC.assertUnorderedResultSet(rs, expectedOutput, false);
                }
                catch (SQLException sqle) {
                    DistributedSQLTestBase.fail("failed with SQLException", sqle);
                }
            }
        };
        this.clientExecute(1, (Runnable)checkRS);
        this.clientExecute(2, (Runnable)checkRS);
        this.serverExecute(1, (Runnable)checkRS);
        this.serverExecute(2, (Runnable)checkRS);
        this.serverExecute(3, (Runnable)checkRS);
    }

    public void DISABLED_testWriteLockTimeout() throws Exception {
        TransactionDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty("gemfire.WRITE_LOCK_TIMEOUT", "-1");
            }
        });
        this.startClientVMs(1, 0, null);
        this.startServerVMs(1, 0, null);
        Connection conn = TestUtil.jdbcConn;
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE QUOTE(QUOTEID INTEGER NOT NULL,LOW NUMERIC(14,2),OPEN1 NUMERIC(14,2),VOLUME NUMERIC(19,2) NOT NULL,PRICE NUMERIC(14,2),HIGH NUMERIC(14,2),COMPANYNAME VARCHAR(250),SYMBOL VARCHAR(250) NOT NULL,CHANGE1 NUMERIC(19,2) NOT NULL,PRIMARY KEY (QUOTEID)) REPLICATE PERSISTENT SYNCHRONOUS" + this.getSuffix());
        st.execute("create index quote_symbol on quote(symbol)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int totalRows = 400;
        PreparedStatement psInsert = conn.prepareStatement("insert into quote (quoteid, volume, companyname, symbol, change1) values (?, 1, 'VMW', 'VMW', 0)");
        for (int i = 0; i < 400; ++i) {
            psInsert.setInt(1, i);
            psInsert.executeUpdate();
        }
        conn.commit();
        ResultSet rs = st.executeQuery("select * from quote");
        int numRows = 0;
        while (rs.next()) {
            TransactionDUnit.assertEquals((String)"Column value should be VMW", (String)"VMW", (String)rs.getString("COMPANYNAME"));
            TransactionDUnit.assertEquals((String)"Column value should be VMW", (String)"VMW", (String)rs.getString("SYMBOL"));
            TransactionDUnit.assertEquals((String)"Column value should be 0", (String)"0.00", (String)rs.getString("CHANGE1"));
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Numbers of rows in resultset should be 400", (int)400, (int)numRows);
        conn.commit();
        int numThreads = 5;
        final CyclicBarrier barrier = new CyclicBarrier(5);
        final Exception[] failures = new Exception[1];
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    Connection conn = TestUtil.getConnection();
                    conn.setTransactionIsolation(TransactionDUnit.this.getIsolationLevel());
                    conn.setAutoCommit(false);
                    PreparedStatement psUpdate = conn.prepareStatement("update quote set change1=?, companyname=?, high=?, open1=?, price=?, low=?, volume=? where symbol=?");
                    for (int i = 0; i < 400; ++i) {
                        psUpdate.setBigDecimal(1, new BigDecimal("34." + i));
                        psUpdate.setString(2, "VMW");
                        psUpdate.setBigDecimal(3, new BigDecimal("35.8"));
                        psUpdate.setBigDecimal(4, new BigDecimal("34." + i));
                        psUpdate.setBigDecimal(5, new BigDecimal("34.3"));
                        psUpdate.setBigDecimal(6, new BigDecimal("34.1"));
                        psUpdate.setBigDecimal(7, new BigDecimal("0"));
                        psUpdate.setString(8, "VMW");
                        psUpdate.executeUpdate();
                        conn.commit();
                    }
                }
                catch (Exception e) {
                    failures[0] = e;
                    TransactionDUnit.this.getLogWriter().error((Object)e);
                    DistributedSQLTestBase.fail("unexpected exception", e);
                }
            }
        };
        Thread[] thrs = new Thread[5];
        for (int i = 0; i < thrs.length; ++i) {
            thrs[i] = new Thread(task);
            thrs[i].start();
        }
        for (Thread thr : thrs) {
            thr.join();
        }
        if (failures[0] != null) {
            throw failures[0];
        }
        rs = st.executeQuery("select * from quote");
        numRows = 0;
        while (rs.next()) {
            TransactionDUnit.assertEquals((String)"Column value should change", (String)"35.8", (String)rs.getString("HIGH"));
            TransactionDUnit.assertEquals((String)"Columns value should change", (String)"34.3", (String)rs.getString("PRICE"));
            TransactionDUnit.assertEquals((String)"Column value should change", (String)"34.1", (String)rs.getString("LOW"));
            ++numRows;
        }
        TransactionDUnit.assertEquals((String)"Numbers of rows in resultset should be 400", (int)400, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
        st.execute("drop table quote");
        TransactionDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty("gemfire.WRITE_LOCK_TIMEOUT", "0");
            }
        });
    }

    public void testDeltaGII_51366() throws Exception {
        int i;
        this.reduceLogLevelForTest("config");
        this.startVMs(1, 2);
        Properties props = new Properties();
        props.setProperty("sync-commits", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customer (  c_w_id         integer        not null primary key,  c_d_id         integer        not null,  c_id           integer        not null,  c_data         varchar(500)) partition by (c_w_id) redundancy 2 persistent synchronous");
        stmt.execute("create unique index custId on trade.customer(c_id)");
        PreparedStatement pstmt = conn.prepareStatement("insert into trade.customer values (?, ?, ?, ?)");
        int numBaseInserts = 1000;
        for (i = 0; i < 1000; ++i) {
            pstmt.setInt(1, i * 2);
            pstmt.setInt(2, i / 2);
            pstmt.setInt(3, i);
            pstmt.setString(4, "data-" + i);
            pstmt.execute();
        }
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        for (i = 1000; i < 2000; ++i) {
            pstmt.setInt(1, i * 2);
            pstmt.setInt(2, i / 2);
            pstmt.setInt(3, i);
            pstmt.setString(4, "data-" + i);
            pstmt.execute();
        }
        this.startVMs(0, 1);
        stmt.execute("call sys.rebalance_all_buckets()");
        for (i = 2000; i < 3000; ++i) {
            pstmt.setInt(1, i * 2);
            pstmt.setInt(2, i / 2);
            pstmt.setInt(3, i);
            pstmt.setString(4, "data-" + i);
            pstmt.execute();
        }
        conn.commit();
        this.verifyDeltaSizeFromStats(this.getServerVM(3), 2000, 113, 0, "/TRADE/CUSTOMER");
        this.verifyDeltaSizeFromStats(this.getServerVM(3), 2000, 113, 0, "/TRADE/CUSTID");
        this.verify_test51366(3000);
        this.stopVMNum(-2);
        stmt.execute("call sys.rebalance_all_buckets()");
        this.verifyDeltaSizeFromStats(this.getServerVM(3), 2000, 113, 0, "/TRADE/CUSTOMER");
        this.verifyDeltaSizeFromStats(this.getServerVM(3), 2000, 113, 0, "/TRADE/CUSTID");
        this.verify_test51366(3000);
        conn.setTransactionIsolation(0);
        for (i = 3000; i < 4000; ++i) {
            pstmt.setInt(1, i * 2);
            pstmt.setInt(2, i / 2);
            pstmt.setInt(3, i);
            pstmt.setString(4, "data-" + i);
            pstmt.execute();
        }
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        for (i = 4000; i < 5000; ++i) {
            pstmt.setInt(1, i * 2);
            pstmt.setInt(2, i / 2);
            pstmt.setInt(3, i);
            pstmt.setString(4, "data-" + i);
            pstmt.execute();
        }
        Properties extraProps = new Properties();
        extraProps.setProperty("rebalance", "true");
        this.restartVMNums(new int[]{-2}, 0, null, extraProps);
        this.serverExecute(2, (Runnable)new SerializableRunnable("verify and wait for rebalance"){

            public void run() {
                final InternalResourceManager rm = Misc.getGemFireCache().getResourceManager();
                ResourceManagerStats stats = rm.getStats();
                DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

                    public boolean done() {
                        return rm.getRebalanceOperations().isEmpty();
                    }

                    public String description() {
                        return "waiting for " + rm.getRebalanceOperations() + " to complete";
                    }
                }, (long)30000L, (long)10L, (boolean)true);
                if (stats.getRebalancesCompleted() < 1) {
                    TestCase.fail((String)"expected a rebalance to be done");
                }
            }
        });
        for (int i2 = 5000; i2 < 6000; ++i2) {
            pstmt.setInt(1, i2 * 2);
            pstmt.setInt(2, i2 / 2);
            pstmt.setInt(3, i2);
            pstmt.setString(4, "data-" + i2);
            pstmt.execute();
        }
        conn.commit();
        this.verifyDeltaSizeFromStats(this.getServerVM(2), 2000, 113, 113, "/TRADE/CUSTOMER");
        this.verifyDeltaSizeFromStats(this.getServerVM(2), 2000, 113, 113, "/TRADE/CUSTID");
        this.verify_test51366(6000);
        this.stopVMNum(-1);
        this.verify_test51366(6000);
        stmt.execute("call sys.rebalance_all_buckets()");
        this.verifyDeltaSizeFromStats(this.getServerVM(2), 2000, 113, 113, "/TRADE/CUSTOMER");
        this.verifyDeltaSizeFromStats(this.getServerVM(2), 2000, 113, 113, "/TRADE/CUSTID");
        this.verifyDeltaSizeFromStats(this.getServerVM(3), 2000, 113, 0, "/TRADE/CUSTOMER");
        this.verifyDeltaSizeFromStats(this.getServerVM(3), 2000, 113, 0, "/TRADE/CUSTID");
        this.stopVMNum(-3);
        this.verify_test51366(6000);
    }

    private void verify_test51366(int totalInserts) throws SQLException {
        ResultSet rs;
        int i;
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        for (i = 0; i < totalInserts; ++i) {
            rs = stmt.executeQuery("select * from trade.customer where c_id=" + i);
            TransactionDUnit.assertTrue((String)("failed for i=" + i), (boolean)rs.next());
            TransactionDUnit.assertEquals((int)(i * 2), (int)rs.getInt(1));
            TransactionDUnit.assertEquals((int)(i / 2), (int)rs.getInt(2));
            TransactionDUnit.assertEquals((int)i, (int)rs.getInt(3));
            TransactionDUnit.assertEquals((String)("data-" + i), (String)rs.getString(4));
            TransactionDUnit.assertFalse((boolean)rs.next());
            rs.close();
        }
        rs = stmt.executeQuery("select * from trade.customer order by c_id");
        for (i = 0; i < totalInserts; ++i) {
            TransactionDUnit.assertTrue((boolean)rs.next());
            TransactionDUnit.assertEquals((int)(i * 2), (int)rs.getInt(1));
            TransactionDUnit.assertEquals((int)(i / 2), (int)rs.getInt(2));
            TransactionDUnit.assertEquals((int)i, (int)rs.getInt(3));
            TransactionDUnit.assertEquals((String)("data-" + i), (String)rs.getString(4));
        }
        TransactionDUnit.assertFalse((boolean)rs.next());
        rs.close();
    }

    public String getSuffix() {
        return "  ";
    }

    protected void checkConnCloseExceptionForReadsOnly(Connection conn) throws SQLException {
    }

    protected void checkResultsFor42822(Connection conn, boolean updated) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("SELECT o_id, o_c_id AS maxorderid FROM oorder WHERE o_c_id = ?");
        block5: for (int id = 1; id <= 20; ++id) {
            pstmt.setInt(1, id);
            this.getLogWriter().info((Object)("executing for id=" + id));
            ResultSet rs = pstmt.executeQuery();
            if (updated) {
                boolean hasNext = rs.next();
                if (hasNext) {
                    this.getLogWriter().info((Object)("result for id=" + id + ": " + rs.getInt(1) + ", " + rs.getInt(2)));
                }
                switch (id) {
                    case 3: {
                        TransactionDUnit.assertTrue((boolean)hasNext);
                        TransactionDUnit.assertEquals((int)2, (int)rs.getInt(1));
                        TransactionDUnit.assertEquals((int)3, (int)rs.getInt(2));
                        continue block5;
                    }
                    case 2: {
                        TransactionDUnit.assertTrue((boolean)hasNext);
                        TransactionDUnit.assertEquals((int)4, (int)rs.getInt(1));
                        TransactionDUnit.assertEquals((int)2, (int)rs.getInt(2));
                        continue block5;
                    }
                    case 7: {
                        TransactionDUnit.assertTrue((boolean)hasNext);
                        TransactionDUnit.assertEquals((int)6, (int)rs.getInt(1));
                        TransactionDUnit.assertEquals((int)7, (int)rs.getInt(2));
                        continue block5;
                    }
                    default: {
                        TransactionDUnit.assertFalse((boolean)hasNext);
                        this.getLogWriter().info((Object)("no result for id=" + id));
                        break;
                    }
                }
                continue;
            }
            if (id <= 4) {
                TransactionDUnit.assertTrue((boolean)rs.next());
                this.getLogWriter().info((Object)("result for id=" + id + ": " + rs.getInt(1) + ", " + rs.getInt(2)));
                TransactionDUnit.assertEquals((int)(id * 2), (int)rs.getInt(1));
                TransactionDUnit.assertEquals((int)id, (int)rs.getInt(2));
                continue;
            }
            TransactionDUnit.assertFalse((boolean)rs.next());
            this.getLogWriter().info((Object)("no result for id=" + id));
        }
    }

    public void createDiskStore(boolean useClient, int vmNum) throws Exception {
        SerializableRunnable csr = TransactionDUnit.getDiskStoreCreator(DISKSTORE);
        if (useClient) {
            if (vmNum == 1) {
                csr.run();
            } else {
                this.clientExecute(vmNum, (Runnable)csr);
            }
        } else {
            this.serverExecute(vmNum, (Runnable)csr);
        }
    }

    public static void installObservers() {
        final CyclicBarrier testBarrier = new CyclicBarrier(2);
        final ConcurrentHashMap waitDone = new ConcurrentHashMap(2);
        TransactionObserverAdapter txOb1 = new TransactionObserverAdapter(){
            boolean firstCall = true;

            public void beforeIndividualLockUpgradeInCommit(TXStateProxy tx, TXEntryState entry) {
                if (this.firstCall) {
                    this.firstCall = false;
                    return;
                }
                if (waitDone.putIfAbsent(tx, Boolean.TRUE) == null) {
                    SanityManager.DEBUG_PRINT((String)"info:TEST", (String)("TXObserver: waiting on testBarrier, count=" + testBarrier.getNumberWaiting()));
                    try {
                        testBarrier.await();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void afterIndividualRollback(TXStateProxy tx, Object callbackArg) {
                if (waitDone.putIfAbsent(tx, Boolean.TRUE) == null) {
                    try {
                        testBarrier.await();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        GemFireXDQueryObserverAdapter ob2 = new GemFireXDQueryObserverAdapter(){

            public void lockingRowForTX(TXStateProxy tx, GemFireContainer container, RegionEntry entry, boolean writeLock) {
                if (!writeLock && ExclusiveSharedSynchronizer.isExclusive((int)entry.getState()) && waitDone.putIfAbsent(tx, Boolean.TRUE) == null) {
                    SanityManager.DEBUG_PRINT((String)"info:TEST", (String)("GFXDObserver: waiting on testBarrier, count=" + testBarrier.getNumberWaiting()));
                    try {
                        testBarrier.await();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        TXManagerImpl txMgr = GemFireCacheImpl.getExisting().getTxManager();
        for (TXStateProxy tx : txMgr.getHostedTransactionsInProgress()) {
            tx.setObserver((TransactionObserver)txOb1);
        }
        txMgr.setObserver((TransactionObserver)txOb1);
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)ob2);
    }

    protected int getIsolationLevel() {
        return 2;
    }

    public void test49667() throws Exception {
        this.startVMs(1, 2);
        Connection conn = TestUtil.jdbcConn;
        this.clientSQLExecute(1, "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, constraint portf_pk primary key (cid, sid))");
        this.clientSQLExecute(1, "create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict)");
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("insert into trade.portfolio values(1, 1, 1, 1)");
        conn.commit();
        stmt = conn.createStatement();
        stmt.execute("insert into trade.sellorders values(1, 1, 1, 1)");
        try {
            this.addExpectedException(new int[]{1}, new int[]{1}, ConflictException.class);
            stmt.execute("insert into trade.portfolio values(1, 1, 10, 10)");
            TransactionDUnit.fail((String)"the above insert should have failed");
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
        }
        this.removeExpectedException(new int[0], new int[0], ConflictException.class);
        stmt.close();
        conn.rollback();
        Connection newConn = TestUtil.getConnection();
        newConn.setTransactionIsolation(this.getIsolationLevel());
        newConn.setAutoCommit(false);
        Statement newstmt = newConn.createStatement();
        newstmt.execute("insert into trade.sellorders values(2, 1, 1, 1)");
        newstmt.close();
        newConn.commit();
    }

    static class CheckIndexOperations
    extends GemFireXDQueryObserverAdapter {
        private static final long serialVersionUID = -549170799818823122L;
        int numInserts = 0;
        int numDeletes = 0;
        final String indexName;
        final TXId txId;

        CheckIndexOperations(String name, TXId txId) {
            this.indexName = name;
            this.txId = txId;
        }

        public void keyAndContainerAfterLocalIndexInsert(Object key, Object rowLocation, GemFireContainer container) {
            if (this.checkTX()) {
                TestCase.assertNotNull((Object)key);
                TestCase.assertNotNull((Object)rowLocation);
                TestCase.assertTrue((boolean)this.indexName.equalsIgnoreCase(container.getSchemaName() + "." + container.getTableName().toString()));
                ++this.numInserts;
            }
        }

        public void keyAndContainerAfterLocalIndexDelete(Object key, Object rowLocation, GemFireContainer container) {
            if (this.checkTX()) {
                TestCase.assertNotNull((Object)key);
                TestCase.assertNotNull((Object)rowLocation);
                TestCase.assertTrue((boolean)this.indexName.equalsIgnoreCase(container.getSchemaName() + "." + container.getTableName().toString()));
                ++this.numDeletes;
            }
        }

        private void checkNumInserts(int expected) {
            TestCase.assertEquals((int)expected, (int)this.numInserts);
        }

        private void checkNumDeletes(int expected) {
            TestCase.assertEquals((int)expected, (int)this.numDeletes);
        }

        private boolean checkTX() {
            return this.txId == null || this.txId.equals(TXManagerImpl.getCurrentTXId());
        }
    }
}

