/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.transactions;

import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gnu.trove.TIntHashSet;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.transactions.TransactionTest;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;

public class TransactionBugsReportedDUnit
extends DistributedSQLTestBase {
    static volatile boolean gotException = false;

    public TransactionBugsReportedDUnit(String name) {
        super(name);
    }

    public void testPkNonPkUpdates() throws Exception {
        this.startServerVMs(3, 0, null);
        this.serverExecute(1, (Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    String addr;
                    int id;
                    int i;
                    Connection conn = TestUtil.getConnection();
                    conn.setAutoCommit(false);
                    conn.setTransactionIsolation(TransactionBugsReportedDUnit.this.getIsolationLevel());
                    Statement stmt = conn.createStatement();
                    stmt.execute("create table t1 (id int primary key, addr varchar(20)) redundancy 2");
                    stmt.execute("create table t2 (id int, addr varchar(20)) redundancy 2");
                    PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?, ?)");
                    for (i = 0; i < 1000; ++i) {
                        pstmt.setInt(1, i);
                        pstmt.setString(2, "addr" + i);
                        TestCase.assertEquals((int)1, (int)pstmt.executeUpdate());
                    }
                    pstmt = conn.prepareStatement("insert into t2 values(?, ?)");
                    for (i = 0; i < 1000; ++i) {
                        pstmt.setInt(1, i);
                        pstmt.setString(2, "addr" + i);
                        TestCase.assertEquals((int)1, (int)pstmt.executeUpdate());
                    }
                    conn.commit();
                    pstmt = conn.prepareStatement("update t1 set addr = ? where id = ?");
                    for (i = 100; i < 200; ++i) {
                        pstmt.setString(1, "address" + i);
                        pstmt.setInt(2, i);
                        TestCase.assertEquals((int)1, (int)pstmt.executeUpdate());
                    }
                    pstmt = conn.prepareStatement("update t2 set addr = ? where id = ?");
                    for (i = 100; i < 200; ++i) {
                        pstmt.setString(1, "address" + i);
                        pstmt.setInt(2, i);
                        TestCase.assertEquals((int)1, (int)pstmt.executeUpdate());
                    }
                    TIntHashSet ids = new TIntHashSet(100);
                    ids.clear();
                    ResultSet rs = stmt.executeQuery("select * from t1 where id >= 100 and id < 200");
                    while (rs.next()) {
                        id = rs.getInt(1);
                        addr = rs.getString(2);
                        TestCase.assertFalse((String)("unexpected duplicate id=" + id), (boolean)ids.contains(id));
                        TestCase.assertEquals((String)("address" + id), (String)addr);
                        ids.add(id);
                    }
                    TestCase.assertEquals((int)100, (int)ids.size());
                    ids.clear();
                    rs = stmt.executeQuery("select * from t2 where id >= 100 and id < 200");
                    while (rs.next()) {
                        id = rs.getInt(1);
                        addr = rs.getString(2);
                        TestCase.assertFalse((String)("unexpected duplicate id=" + id), (boolean)ids.contains(id));
                        TestCase.assertEquals((String)("address" + id), (String)addr);
                        ids.add(id);
                    }
                    TestCase.assertEquals((int)100, (int)ids.size());
                    conn.commit();
                    rs = stmt.executeQuery("select * from t1 where id >= 100 and id < 200");
                    ids.clear();
                    while (rs.next()) {
                        id = rs.getInt(1);
                        addr = rs.getString(2);
                        TestCase.assertFalse((String)("unexpected duplicate id=" + id), (boolean)ids.contains(id));
                        TestCase.assertEquals((String)("address" + id), (String)addr);
                        ids.add(id);
                    }
                    TestCase.assertEquals((int)100, (int)ids.size());
                    ids.clear();
                    rs = stmt.executeQuery("select * from t2 where id >= 100 and id < 200");
                    while (rs.next()) {
                        id = rs.getInt(1);
                        addr = rs.getString(2);
                        TestCase.assertFalse((String)("unexpected duplicate id=" + id), (boolean)ids.contains(id));
                        TestCase.assertEquals((String)("address" + id), (String)addr);
                        ids.add(id);
                    }
                    TestCase.assertEquals((int)100, (int)ids.size());
                }
                catch (Exception ex) {
                    DistributedSQLTestBase.fail("failed with exception", ex);
                }
            }
        });
    }

    public void testBug42905() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, 0, null);
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create synonym synForT1 for t1");
        stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null)");
        stmt.execute("Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))");
        stmt.execute("insert into synForT1 values(1, 1, 1)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt = conn.createStatement();
        boolean gotException = false;
        try {
            stmt.execute("insert into t2 values(1, 1, 1)");
            stmt.execute("delete from synForT1 where c1 = 1");
            TransactionBugsReportedDUnit.fail((String)"the above delete should have thrown a constraint violation");
        }
        catch (SQLException sqle) {
            if (!"23503".equals(sqle.getSQLState())) {
                throw sqle;
            }
            gotException = true;
        }
        TransactionBugsReportedDUnit.assertTrue((boolean)gotException);
    }

    public void testBug42923_uniqButUpdateRequiresFnExn() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, 0, null);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3))");
        this.clientSQLExecute(1, "insert into t1 values (1, 1, 1), (2, 2, 2), (3, 3, 3)");
        Connection conn = TestUtil.getConnection();
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        conn.commit();
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection childConn = TestUtil.getConnection();
                    childConn.setTransactionIsolation(TransactionBugsReportedDUnit.this.getIsolationLevel());
                    childConn.setAutoCommit(false);
                    Statement childStmnt = childConn.createStatement();
                    childStmnt.execute("update t1 set c3 = 4 where c3 > 2");
                    latch.countDown();
                }
                catch (Exception e) {
                    DistributedSQLTestBase.fail("got exception in the spawned thread", e);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        latch.await();
        conn.setTransactionIsolation(this.getIsolationLevel());
        stmt = conn.createStatement();
        boolean gotException = false;
        try {
            stmt.execute("update t1 set c3 = 4 where c3 > 2");
        }
        catch (SQLException sqle) {
            if (!"X0Z02".equals(sqle.getSQLState())) {
                throw sqle;
            }
            gotException = true;
        }
        TransactionBugsReportedDUnit.assertTrue((boolean)gotException);
    }

    public void testBug42923_uniqButUpdateIsPutConvertible() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, 0, null);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3))");
        this.clientSQLExecute(1, "insert into t1 values (1, 1, 1), (2, 2, 2), (3, 3, 3)");
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        conn.commit();
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection childConn = TestUtil.getConnection();
                    childConn.setTransactionIsolation(TransactionBugsReportedDUnit.this.getIsolationLevel());
                    childConn.setAutoCommit(false);
                    Statement childStmnt = childConn.createStatement();
                    childStmnt.execute("update t1 set c3 = 4 where c1 = 2");
                    latch.countDown();
                }
                catch (Exception e) {
                    DistributedSQLTestBase.fail("got exception in the spawned thread", e);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        latch.await();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt = conn.createStatement();
        boolean gotException = false;
        try {
            stmt.execute("update t1 set c3 = 4 where c1 = 2");
        }
        catch (SQLException sqle) {
            if (!"X0Z02".equals(sqle.getSQLState())) {
                throw sqle;
            }
            gotException = true;
        }
        TransactionBugsReportedDUnit.assertTrue((boolean)gotException);
    }

    public void testTxnInsertUniqueIndexOnPartCol() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, 0, null);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3)) partition by column(c3)");
        this.clientSQLExecute(1, "insert into t1 values (1, 1, 1), (2, 2, 2), (3, 3, 3)");
        Connection conn = TestUtil.getConnection();
        conn.commit();
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean gotException = false;
                try {
                    Connection childConn = TestUtil.getConnection();
                    childConn.setTransactionIsolation(TransactionBugsReportedDUnit.this.getIsolationLevel());
                    childConn.setAutoCommit(false);
                    Statement childStmnt = childConn.createStatement();
                    childStmnt.execute("insert into t1 values(4, 4, 2)");
                    latch.countDown();
                }
                catch (Exception e) {
                    gotException = true;
                    TestCase.assertTrue((boolean)(e instanceof SQLException));
                    TestCase.assertEquals((String)"23505", (String)((SQLException)e).getSQLState());
                }
                TestCase.assertTrue((boolean)gotException);
                latch.countDown();
            }
        };
        Thread t = new Thread(r);
        t.start();
        latch.await();
    }

    public void testTxnInsertUniqueIndexOnPartColButFirstAlsoUncommitted() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, 0, null);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3)) partition by column(c3)");
        this.clientSQLExecute(1, "create synonym synForT1 for t1");
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection childConn = TestUtil.getConnection();
                    childConn.setTransactionIsolation(TransactionBugsReportedDUnit.this.getIsolationLevel());
                    childConn.setAutoCommit(false);
                    Statement childStmnt = childConn.createStatement();
                    childStmnt.execute("insert into synForT1 values(4, 4, 2)");
                    latch.countDown();
                }
                catch (Exception e) {
                    DistributedSQLTestBase.fail("should not have got exception", e);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        latch.await();
        Connection childConn = TestUtil.getConnection();
        childConn.setTransactionIsolation(this.getIsolationLevel());
        childConn.setAutoCommit(false);
        Statement stmt = childConn.createStatement();
        boolean gotException = false;
        try {
            stmt.execute("insert into synForT1 values(4, 4, 2)");
        }
        catch (Exception e) {
            gotException = true;
            gotException = true;
            TransactionBugsReportedDUnit.assertTrue((boolean)(e instanceof SQLException));
            TransactionBugsReportedDUnit.assertEquals((String)"X0Z02", (String)((SQLException)e).getSQLState());
        }
        TransactionBugsReportedDUnit.assertTrue((boolean)gotException);
    }

    public void testTxnInsertUniqueIndexOnNonPartCol() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, 0, null);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3)) partition by column(c3)");
        this.clientSQLExecute(1, "insert into t1 values (1, 1, 1), (2, 2, 2), (3, 3, 3)");
        Connection conn = TestUtil.getConnection();
        conn.commit();
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean gotException = false;
                try {
                    Connection childConn = TestUtil.getConnection();
                    childConn.setTransactionIsolation(TransactionBugsReportedDUnit.this.getIsolationLevel());
                    childConn.setAutoCommit(false);
                    Statement childStmnt = childConn.createStatement();
                    childStmnt.execute("insert into t1 values(4, 4, 2)");
                    latch.countDown();
                }
                catch (Exception e) {
                    gotException = true;
                    TestCase.assertTrue((boolean)(e instanceof SQLException));
                    TestCase.assertEquals((String)"23505", (String)((SQLException)e).getSQLState());
                }
                TestCase.assertTrue((boolean)gotException);
                latch.countDown();
            }
        };
        Thread t = new Thread(r);
        t.start();
        latch.await();
    }

    public void testTxnInsertUniqueIndexOnNonPartColButFirstAlsoUncommitted() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, 0, null);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3)) partition by column(c3)");
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection childConn = TestUtil.getConnection();
                    childConn.setTransactionIsolation(TransactionBugsReportedDUnit.this.getIsolationLevel());
                    childConn.setAutoCommit(false);
                    Statement childStmnt = childConn.createStatement();
                    childStmnt.execute("insert into t1 values(4, 4, 2)");
                    latch.countDown();
                }
                catch (Exception e) {
                    DistributedSQLTestBase.fail("should not have got exception", e);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        latch.await();
        t.join();
        Connection childConn = TestUtil.getConnection();
        childConn.setTransactionIsolation(this.getIsolationLevel());
        childConn.setAutoCommit(false);
        Statement stmt = childConn.createStatement();
        boolean gotException = false;
        try {
            stmt.execute("insert into t1 values(4, 4, 2)");
        }
        catch (Exception e) {
            gotException = true;
            TransactionBugsReportedDUnit.assertTrue((boolean)(e instanceof SQLException));
            TransactionBugsReportedDUnit.assertEquals((String)"X0Z02", (String)((SQLException)e).getSQLState());
        }
        TransactionBugsReportedDUnit.assertTrue((boolean)gotException);
    }

    public void testTxnDeleteParentRow() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, 0, null);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3))");
        this.clientSQLExecute(1, "Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))");
        this.clientSQLExecute(1, "insert into t1 values(1, 1, 1)");
        Connection conn = TestUtil.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement stmnt = conn.createStatement();
        stmnt.execute("delete from t1 where c1 = 1");
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Connection childConn = TestUtil.getConnection();
                    childConn.setTransactionIsolation(TransactionBugsReportedDUnit.this.getIsolationLevel());
                    childConn.setAutoCommit(false);
                    Statement childStmnt = childConn.createStatement();
                    childStmnt.execute("insert into t2 values(1, 1, 1)");
                    latch.countDown();
                }
                catch (Exception e) {
                    TestCase.assertTrue((boolean)(e instanceof SQLException));
                    TestCase.assertEquals((String)"X0Z02", (String)((SQLException)e).getSQLState());
                    gotException = true;
                }
                TestCase.assertTrue((boolean)gotException);
                latch.countDown();
            }
        };
        Thread t = new Thread(r);
        this.addExpectedException((int[])null, new int[]{1, 2}, new Object[]{ConflictException.class});
        t.start();
        latch.await();
        TransactionBugsReportedDUnit.assertTrue((boolean)gotException);
        this.removeExpectedException((int[])null, new int[]{1, 2}, new Object[]{ConflictException.class});
    }

    public void testTxnDeleteParentRow_bothCaseOfChildCommittedAndUncommitted() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(3, 0, null);
        Connection conn = TestUtil.getConnection();
        Connection conn2 = TestUtil.getConnection();
        Connection conn3 = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create synonym synForT2 for t2");
        stmt.execute("create synonym synForT3 for t3");
        stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3))");
        stmt.execute("create synonym synForT1 for t1");
        stmt.execute("Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))");
        stmt.execute("Create table t3 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))");
        stmt.execute("insert into t1 values(1, 1, 1), (2, 2, 2)");
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        conn2.setTransactionIsolation(this.getIsolationLevel());
        conn2.setAutoCommit(false);
        conn3.setTransactionIsolation(this.getIsolationLevel());
        conn3.setAutoCommit(false);
        Statement stmt2 = conn2.createStatement();
        Statement stmt3 = conn2.createStatement();
        stmt2.execute("insert into t2 values(1, 1, 1), (2, 2, 2)");
        stmt3.execute("insert into synForT3 values(1, 1, 1), (2, 2, 2)");
        for (int i = 0; i < 2; ++i) {
            if (i == 1) {
                conn2.commit();
                conn3.commit();
            }
            boolean gotex = false;
            try {
                stmt.execute("delete from synForT1");
                TransactionBugsReportedDUnit.fail((String)"expected a conflict or constraint violation");
            }
            catch (SQLException e) {
                if (i == 0 ? !"X0Z02".equals(e.getSQLState()) : !"23503".equals(e.getSQLState())) {
                    throw e;
                }
                gotex = true;
            }
            TransactionBugsReportedDUnit.assertTrue((boolean)gotex);
        }
    }

    public void testTxnUpdateToSameValueOnSameRow() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(3, 0, null);
        Connection conn = TestUtil.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, exchange varchar(20), symbol varchar(20), constraint sym_ex unique (symbol, exchange))");
        stmt.execute("insert into t1 values(1, 10, 'nyse', 'o'), (2, 20, 'amex', 'g')");
        conn.commit();
        stmt.execute("update t1 set exchange = 'nyse', symbol = 'o' where c1 = 1");
        conn.commit();
    }

    public void testTransactionsAndUniqueIndexes_43152() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(3, 0, null);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Connection nonTxconn = TestUtil.getConnection();
        Statement nonTxst = nonTxconn.createStatement();
        Connection conn2 = TestUtil.getConnection();
        conn2.setTransactionIsolation(this.getIsolationLevel());
        conn2.setAutoCommit(false);
        Statement st2 = conn2.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, c3 int not null, primary key(c1), constraint C3_Unique unique (c3)) replicate ");
        conn.commit();
        st.execute("insert into tran.t1 values(1, 1, 1)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st.execute("update tran.t1 set c3 = 1, c2 = 4 where c1 = 1");
        st.execute("select * from tran.t1 where c3 = 1");
        ResultSet rs = st.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(1));
            TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(2));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(3));
        }
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)cnt);
        nonTxst.execute("select * from tran.t1");
        ResultSet rsNonTx = nonTxst.getResultSet();
        int cntNonTx = 0;
        while (rsNonTx.next()) {
            ++cntNonTx;
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsNonTx.getInt(1));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsNonTx.getInt(2));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsNonTx.getInt(3));
        }
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)cntNonTx);
        st2.execute("select * from tran.t1");
        ResultSet rsTx2 = st2.getResultSet();
        int cntTx2 = 0;
        while (rsTx2.next()) {
            ++cntTx2;
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsTx2.getInt(1));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsTx2.getInt(2));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsTx2.getInt(3));
        }
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)cntTx2);
        st2.execute("select * from tran.t1 where c3 = 1");
        rsTx2 = st2.getResultSet();
        cntTx2 = 0;
        while (rsTx2.next()) {
            ++cntTx2;
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsTx2.getInt(1));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsTx2.getInt(2));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsTx2.getInt(3));
        }
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)cntTx2);
        try {
            st2.execute("update tran.t1 set c3 = 1, c2 = 5 where c1 = 1");
            TransactionBugsReportedDUnit.fail((String)"the above update should have thrown conflict exception");
        }
        catch (SQLException sqle) {
            TransactionBugsReportedDUnit.assertTrue((boolean)"X0Z02".equals(sqle.getSQLState()));
        }
        Connection conn3 = TestUtil.getConnection();
        conn3.setTransactionIsolation(this.getIsolationLevel());
        conn3.setAutoCommit(false);
        Statement st3 = conn3.createStatement();
        try {
            st3.execute("delete from tran.t1");
            TransactionBugsReportedDUnit.fail((String)"the above delete should have thrown conflict exception");
        }
        catch (SQLException sqle) {
            TransactionBugsReportedDUnit.assertTrue((boolean)"X0Z02".equals(sqle.getSQLState()));
        }
        Connection conn4 = TestUtil.getConnection();
        conn4.setTransactionIsolation(this.getIsolationLevel());
        conn4.setAutoCommit(false);
        Statement st4 = conn4.createStatement();
        try {
            st4.execute("delete from tran.t1 where c1 = 1");
            TransactionBugsReportedDUnit.fail((String)"the above delete should have thrown conflict exception");
        }
        catch (SQLException sqle) {
            TransactionBugsReportedDUnit.assertTrue((boolean)"X0Z02".equals(sqle.getSQLState()));
        }
        st.execute("update tran.t1 set c3 = 1, c2 = 5 where c1 = 1");
        st.execute("select * from tran.t1");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(1));
            TransactionBugsReportedDUnit.assertEquals((int)5, (int)rs.getInt(2));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(3));
        }
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)cnt);
        nonTxst.execute("select * from tran.t1");
        rsNonTx = nonTxst.getResultSet();
        cntNonTx = 0;
        while (rsNonTx.next()) {
            ++cntNonTx;
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsNonTx.getInt(1));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsNonTx.getInt(2));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsNonTx.getInt(3));
        }
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)cntNonTx);
        conn.commit();
        nonTxst.execute("select * from tran.t1");
        rsNonTx = nonTxst.getResultSet();
        cntNonTx = 0;
        while (rsNonTx.next()) {
            ++cntNonTx;
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsNonTx.getInt(1));
            TransactionBugsReportedDUnit.assertEquals((int)5, (int)rsNonTx.getInt(2));
            TransactionBugsReportedDUnit.assertEquals((int)1, (int)rsNonTx.getInt(3));
        }
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)cntNonTx);
        conn.commit();
        st.execute("insert into tran.t1 values(2, 2, 2)");
        st.execute("insert into tran.t1 values(3, 3, 3)");
        st.execute("insert into tran.t1 values(4, 4, 4)");
        st.execute("update tran.t1 set c3 = 1, c2 = 4 where c1 = 1");
        st.execute("update tran.t1 set c3 = 2, c2 = 5 where c1 = 2");
        st.execute("update tran.t1 set c3 = 3, c2 = 6 where c1 = 3");
        conn.commit();
        rs = st.executeQuery("select c1, c2, c3 from tran.t1 order by c1");
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)2, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)5, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)2, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)3, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)6, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)3, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertFalse((boolean)rs.next());
        st.execute("update tran.t1 set c3 = 1, c2 = 5 where c1 = 1");
        st.execute("update tran.t1 set c3 = 2, c2 = 5 where c1 = 2");
        st.execute("update tran.t1 set c3 = 3, c2 = 5 where c1 = 3");
        rs = st.executeQuery("select c1, c2, c3 from tran.t1 order by c1");
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)5, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)2, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)5, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)2, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)3, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)5, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)3, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertFalse((boolean)rs.next());
        conn.commit();
        rs = st.executeQuery("select c1, c2, c3 from tran.t1 order by c1");
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)5, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)2, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)5, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)2, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)3, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)5, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)3, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertFalse((boolean)rs.next());
        st.execute("update tran.t1 set c3 = 1, c2 = 6 where c1 = 1");
        st.execute("update tran.t1 set c3 = 2, c2 = 6 where c1 = 2");
        st.execute("update tran.t1 set c3 = 3, c2 = 6 where c1 = 3");
        rs = st.executeQuery("select c1, c2, c3 from tran.t1 order by c1");
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)6, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)2, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)6, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)2, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)3, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)6, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)3, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertFalse((boolean)rs.next());
        conn.commit();
        rs = st.executeQuery("select c1, c2, c3 from tran.t1 order by c1");
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)6, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)1, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)2, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)6, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)2, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)3, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)6, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)3, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertTrue((boolean)rs.next());
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(1));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(2));
        TransactionBugsReportedDUnit.assertEquals((int)4, (int)rs.getInt(3));
        TransactionBugsReportedDUnit.assertFalse((boolean)rs.next());
        conn.commit();
    }

    public void testPutAllInTxnAfterMerge_43733() throws Exception {
        this.startClientVMs(1, 0, null);
        this.startServerVMs(3, 0, null);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, c3 int not null, primary key(c1), constraint C3_Unique unique (c3)) partition by primary key ");
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st.execute("insert into tran.t1 values(1, 1, 1), (2, 2, 2), (5, 10, 30), (100, 11, 12)");
        for (int i = 0; i < 10; ++i) {
            st.execute("select * from tran.t1");
            ResultSet rs = st.getResultSet();
            int cnt = 0;
            while (rs.next()) {
                ++cnt;
                if (rs.getInt(1) == 1) {
                    TransactionBugsReportedDUnit.assertEquals((Object)1, (Object)rs.getObject(2));
                    TransactionBugsReportedDUnit.assertEquals((Object)1, (Object)rs.getObject(3));
                    continue;
                }
                if (rs.getInt(1) == 2) {
                    TransactionBugsReportedDUnit.assertEquals((Object)2, (Object)rs.getObject(2));
                    TransactionBugsReportedDUnit.assertEquals((Object)2, (Object)rs.getObject(3));
                    continue;
                }
                if (rs.getInt(1) == 5) {
                    TransactionBugsReportedDUnit.assertEquals((Object)10, (Object)rs.getObject(2));
                    TransactionBugsReportedDUnit.assertEquals((Object)30, (Object)rs.getObject(3));
                    continue;
                }
                if (rs.getInt(1) == 100) {
                    TransactionBugsReportedDUnit.assertEquals((Object)11, (Object)rs.getObject(2));
                    TransactionBugsReportedDUnit.assertEquals((Object)12, (Object)rs.getObject(3));
                    continue;
                }
                TransactionBugsReportedDUnit.fail((String)("unexpected result: " + rs.getInt(1)));
            }
            TransactionBugsReportedDUnit.assertEquals((int)4, (int)cnt);
        }
        conn.commit();
        Connection conn2 = TestUtil.getConnection();
        Statement st2 = conn2.createStatement();
        for (int i = 0; i < 10; ++i) {
            st2.execute("select * from tran.t1");
            ResultSet rs = st2.getResultSet();
            int cnt = 0;
            while (rs.next()) {
                ++cnt;
                if (rs.getInt(1) == 1) {
                    TransactionBugsReportedDUnit.assertEquals((Object)1, (Object)rs.getObject(2));
                    TransactionBugsReportedDUnit.assertEquals((Object)1, (Object)rs.getObject(3));
                    continue;
                }
                if (rs.getInt(1) == 2) {
                    TransactionBugsReportedDUnit.assertEquals((Object)2, (Object)rs.getObject(2));
                    TransactionBugsReportedDUnit.assertEquals((Object)2, (Object)rs.getObject(3));
                    continue;
                }
                if (rs.getInt(1) == 5) {
                    TransactionBugsReportedDUnit.assertEquals((Object)10, (Object)rs.getObject(2));
                    TransactionBugsReportedDUnit.assertEquals((Object)30, (Object)rs.getObject(3));
                    continue;
                }
                if (rs.getInt(1) == 100) {
                    TransactionBugsReportedDUnit.assertEquals((Object)11, (Object)rs.getObject(2));
                    TransactionBugsReportedDUnit.assertEquals((Object)12, (Object)rs.getObject(3));
                    continue;
                }
                TransactionBugsReportedDUnit.fail((String)("unexpected result: " + rs.getInt(1)));
            }
            TransactionBugsReportedDUnit.assertEquals((int)4, (int)cnt);
        }
    }

    public void testBug41168() throws Exception {
        this.startVMs(2, 3);
        this.clientSQLExecute(1, "create table BinaryTree (id int primary key, leftId int, rightId int, depth int not null, foreign key (leftId) references BinaryTree(id), foreign key (rightId) references BinaryTree(id)) replicate");
        Connection conn = TestUtil.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        this.addExpectedException(new int[]{1, 2}, new int[]{1, 2, 3}, SQLIntegrityConstraintViolationException.class);
        TransactionTest.doBinaryTreeChecks(conn, true);
        this.removeExpectedException(new int[]{1, 2}, new int[]{1, 2, 3}, SQLIntegrityConstraintViolationException.class);
        this.serverSQLExecute(2, "drop table BinaryTree");
        this.clientSQLExecute(1, "create table BinaryTree (id int primary key, leftId int, rightId int, depth int not null, foreign key (leftId) references BinaryTree(id), foreign key (rightId) references BinaryTree(id))");
        this.addExpectedException(new int[]{1, 2}, new int[]{1, 2, 3}, SQLIntegrityConstraintViolationException.class);
        TransactionTest.doBinaryTreeChecks(conn, false);
        this.removeExpectedException(new int[]{1, 2}, new int[]{1, 2, 3}, SQLIntegrityConstraintViolationException.class);
    }

    public void testBug44731() throws Exception {
        int i;
        this.startClientVMs(1, 0, null);
        this.startServerVMs(2, 0, null);
        this.clientSQLExecute(1, "Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null)");
        this.clientSQLExecute(1, "Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c2) references t1(c1)) partition by primary key");
        for (int i2 = 1; i2 <= 10; ++i2) {
            this.serverSQLExecute(1, "insert into t1 values (" + i2 + ',' + (i2 + 5) + ',' + (i2 + 3) + ')');
            if (i2 > 5) continue;
            this.serverSQLExecute(2, "insert into t2 values (" + (i2 + 5) + ',' + i2 + ',' + (i2 + 2) + ')');
        }
        Connection conn = TestUtil.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        for (int i3 = 6; i3 <= 10; ++i3) {
            stmt.execute("insert into t2 values (" + (i3 + 5) + ',' + i3 + ',' + (i3 + 2) + ')');
        }
        Connection conn2 = TestUtil.getConnection();
        conn2.setTransactionIsolation(this.getIsolationLevel());
        conn2.setAutoCommit(false);
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{ConflictException.class, "X0Z02"});
        Statement stmt2 = conn2.createStatement();
        for (i = 6; i <= 10; ++i) {
            try {
                stmt2.execute("delete from t1 where c2=" + (i + 5));
                TransactionBugsReportedDUnit.fail((String)"expected a conflict");
                continue;
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) continue;
                throw sqle;
            }
        }
        conn.rollback();
        for (i = 6; i <= 10; ++i) {
            stmt2.execute("delete from t1 where c2=" + (i + 5));
        }
        for (i = 6; i <= 10; ++i) {
            try {
                stmt.execute("insert into t2 values (" + (i + 5) + ',' + i + ',' + (i + 2) + ')');
                TransactionBugsReportedDUnit.fail((String)"expected a conflict");
                continue;
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) continue;
                throw sqle;
            }
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, new Object[]{ConflictException.class, "X0Z02"});
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, "23503");
        conn2.commit();
        for (i = 6; i <= 10; ++i) {
            try {
                stmt.execute("insert into t2 values (" + (i + 5) + ',' + i + ',' + (i + 2) + ')');
                TransactionBugsReportedDUnit.fail((String)"expected constraint violation");
                continue;
            }
            catch (SQLException sqle) {
                if ("23503".equals(sqle.getSQLState())) continue;
                throw sqle;
            }
        }
        conn.commit();
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, "23503");
    }

    protected int getIsolationLevel() {
        return 2;
    }
}

