/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.transactions;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.locks.LockMode;
import com.gemstone.gemfire.internal.cache.locks.LockingPolicy;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import io.snappydata.test.dunit.VM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;

public class SelectForUpdateInTransactionDUnit
extends DistributedSQLTestBase {
    private final String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";

    public SelectForUpdateInTransactionDUnit(String name) {
        super(name);
    }

    public static void executeSelectForUpdateQuery(String sql, boolean exception, int isolationLevel) {
        block5: {
            try {
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement(1003, 1008, 2);
                if (isolationLevel != 0) {
                    conn.setTransactionIsolation(isolationLevel);
                }
                stmt.execute(sql);
                ResultSet rs = stmt.getResultSet();
                while (rs.next()) {
                }
                if (exception) {
                    stmt.close();
                    conn.commit();
                    SelectForUpdateInTransactionDUnit.fail((String)"The execution should have thrown exception");
                }
                stmt.close();
                conn.commit();
            }
            catch (Exception e) {
                if (exception) break block5;
                SelectForUpdateInTransactionDUnit.fail((String)"should have got exception");
            }
        }
    }

    public static void installObserver() {
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
    }

    public static void checkIfTheseKeysLocked(Object[] keys) {
        SelectForUpdateObserver observer = (SelectForUpdateObserver)GemFireXDQueryObserverHolder.getInstance();
        if (!observer.checkIfTheseKeysLocked(keys)) {
            SelectForUpdateInTransactionDUnit.fail((String)"Keys not locked as expected");
        }
    }

    public static void checkIfTheseKeysSent(Object[] keys) {
        SelectForUpdateObserver observer = (SelectForUpdateObserver)GemFireXDQueryObserverHolder.getInstance();
        if (!observer.checkIfTheseKeysSent(keys)) {
            SelectForUpdateInTransactionDUnit.fail((String)"Keys not sent as expected");
        }
    }

    public void testSelectForUpdate_PR_key_not_in_projection_and_whereClause() throws Exception {
        this.startVMs(2, 1);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname))";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee where lastname = 'kumar'";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)1, (int)cnt);
        conn.commit();
    }

    public void testSelectForUpdate_PR_key_not_in_projection() throws Exception {
        this.startVMs(2, 2);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname))";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "installObserver");
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdate_PR_key_in_projection() throws Exception {
        this.startVMs(2, 2);
        this.runSelectForUpdate_PR_key_in_projection(TestUtil.getConnection());
    }

    public void testSelectForUpdate_directDelete() throws Exception {
        this.startVMs(2, 1);
        Connection conn = TestUtil.getConnection();
        conn.setTransactionIsolation(0);
        conn.setAutoCommit(false);
        Statement stmtForTableAndInsert = conn.createStatement();
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname))");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        Statement stmt = conn.createStatement(1003, 1008, 2);
        ResultSet uprs = stmt.executeQuery("SELECT workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS");
        while (uprs.next()) {
            uprs.deleteRow();
        }
        SQLWarning w = uprs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertTrue((boolean)"0A000".equals(w.getSQLState()));
        uprs.close();
        Statement stmt2 = conn.createStatement();
        ResultSet rs = stmt2.executeQuery("select * from employee");
        w = rs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        rs = stmt2.executeQuery("select * from employee");
        SelectForUpdateInTransactionDUnit.assertFalse((boolean)rs.next());
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt = conn.createStatement(1003, 1008, 2);
        stmt.execute("insert into employee values('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        uprs = stmt.executeQuery("SELECT * FROM EMPLOYEE FOR UPDATE of BONUS");
        while (uprs.next()) {
            if (!uprs.getString(1).equalsIgnoreCase("asif")) continue;
            uprs.deleteRow();
        }
        w = uprs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        uprs.close();
        conn.commit();
        stmt2 = conn.createStatement();
        rs = stmt2.executeQuery("select * from employee");
        w = rs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        SelectForUpdateInTransactionDUnit.assertTrue((boolean)rs.next());
        SelectForUpdateInTransactionDUnit.assertTrue((rs.getString(1).equalsIgnoreCase("sum") || rs.getString(1).equalsIgnoreCase("dada") ? 1 : 0) != 0);
        SelectForUpdateInTransactionDUnit.assertTrue((boolean)rs.next());
        SelectForUpdateInTransactionDUnit.assertTrue((rs.getString(1).equalsIgnoreCase("sum") || rs.getString(1).equalsIgnoreCase("dada") ? 1 : 0) != 0);
        SelectForUpdateInTransactionDUnit.assertFalse((boolean)rs.next());
    }

    public void testSelectForUpdate_directDeleteNoPK() throws Exception {
        this.startVMs(2, 1);
        Connection conn = TestUtil.getConnection();
        conn.setTransactionIsolation(0);
        conn.setAutoCommit(false);
        Statement stmtForTableAndInsert = conn.createStatement();
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4))");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        Statement stmt = conn.createStatement(1003, 1008, 2);
        ResultSet uprs = stmt.executeQuery("SELECT workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS");
        while (uprs.next()) {
            uprs.deleteRow();
        }
        SQLWarning w = uprs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertTrue((boolean)"0A000".equals(w.getSQLState()));
        uprs.close();
        Statement stmt2 = conn.createStatement();
        ResultSet rs = stmt2.executeQuery("select * from employee");
        w = rs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        rs = stmt2.executeQuery("select * from employee");
        SelectForUpdateInTransactionDUnit.assertFalse((boolean)rs.next());
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt = conn.createStatement(1003, 1008, 2);
        stmt.execute("insert into employee values('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        uprs = stmt.executeQuery("SELECT * FROM EMPLOYEE FOR UPDATE of BONUS");
        while (uprs.next()) {
            if (!uprs.getString(1).equalsIgnoreCase("asif")) continue;
            uprs.deleteRow();
        }
        w = uprs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        uprs.close();
        conn.commit();
        stmt2 = conn.createStatement();
        rs = stmt2.executeQuery("select * from employee");
        w = rs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        SelectForUpdateInTransactionDUnit.assertTrue((boolean)rs.next());
        SelectForUpdateInTransactionDUnit.assertTrue((rs.getString(1).equalsIgnoreCase("sum") || rs.getString(1).equalsIgnoreCase("dada") ? 1 : 0) != 0);
        SelectForUpdateInTransactionDUnit.assertTrue((boolean)rs.next());
        SelectForUpdateInTransactionDUnit.assertTrue((rs.getString(1).equalsIgnoreCase("sum") || rs.getString(1).equalsIgnoreCase("dada") ? 1 : 0) != 0);
        SelectForUpdateInTransactionDUnit.assertFalse((boolean)rs.next());
    }

    public void DISABLED_43188_testSelectForUpdate_PR_key_in_projection_client() throws Exception {
        this.startVMs(2, 2);
        int netPort = this.startNetworkServer(2, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        this.runSelectForUpdate_PR_key_in_projection(conn);
    }

    protected void runSelectForUpdate_PR_key_in_projection(Connection conn) throws Exception {
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname))";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT firstname, workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdate_PR_composite_key_in_projection() throws Exception {
        this.startVMs(2, 2);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname, lastname))";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT firstname, workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdate_PR_composite_key_partially_in_projection() throws Exception {
        this.startVMs(2, 2);
        this.runSelectForUpdate_PR_composite_key_partially_in_projection(TestUtil.getConnection());
    }

    public void DISABLED_43188_testSelectForUpdate_PR_composite_key_partially_in_projection_client() throws Exception {
        this.startVMs(2, 2);
        int netPort = this.startNetworkServer(2, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        this.runSelectForUpdate_PR_composite_key_partially_in_projection(conn);
    }

    protected void runSelectForUpdate_PR_composite_key_partially_in_projection(Connection conn) throws Exception {
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname, lastname))";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT firstname, workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdate_PR_composite_key_not_in_projection() throws Exception {
        this.startVMs(2, 2);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname, lastname))";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT firstname, workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdate_PR_no_primary_key() throws Exception {
        this.startVMs(2, 2);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null)";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT firstname, workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        stmt.execute(sql);
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public static void verifyUpdateConflict(String sql, Boolean exception, int isolationLevel) throws SQLException {
        block3: {
            try {
                Connection conn = TestUtil.getConnection();
                conn.setTransactionIsolation(isolationLevel);
                conn.setAutoCommit(false);
                Statement stmt = conn.createStatement(1003, 1008, 2);
                int updateCnt = stmt.executeUpdate(sql);
                conn.commit();
                conn.close();
                if (exception.booleanValue()) {
                    SelectForUpdateInTransactionDUnit.fail((String)("The execution should have thrown exception instead it updated " + updateCnt + " rows"));
                }
            }
            catch (Exception e) {
                SQLException sqle = (SQLException)e;
                if ("X0Z02".equals(sqle.getSQLState())) break block3;
                throw sqle;
            }
        }
    }

    public static void verifyLocalConflict(String regionPath, String key, Boolean exception) throws SQLException, StandardException {
        LocalRegion reg = (LocalRegion)Misc.getRegion((String)regionPath, (boolean)true, (boolean)false);
        RegionKey sqlkey = GemFireXDUtils.convertIntoGemfireRegionKey((DataValueDescriptor)new SQLVarchar(key), (GemFireContainer)((GemFireContainer)reg.getUserAttribute()), (boolean)false);
        RegionEntry entry = reg.basicGetEntryForLock(reg, (Object)sqlkey);
        boolean locked = entry.attemptLock(LockMode.EX_SH, 0, LockingPolicy.FAIL_FAST_TX, 0L, (Object)Thread.currentThread(), (Object)reg);
        if (exception.booleanValue()) {
            SelectForUpdateInTransactionDUnit.assertFalse((boolean)locked);
        } else {
            SelectForUpdateInTransactionDUnit.assertTrue((boolean)locked);
        }
    }

    public void testSelectForUpdate_RR_key_not_in_projection_and_whereClause() throws Exception {
        this.startVMs(2, 2);
        this.clientSQLExecute(1, "create schema myapp");
        String jdbcSQL = "create table myapp.Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname)) replicate";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into myapp.employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT workdept, bonus FROM myapp.EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        String conflictSql = "update myapp.employee set workdept = 'xxx' where lastname = 'kumar'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyLocalConflict", new Object[]{"/MYAPP/EMPLOYEE", "neeraj", Boolean.TRUE});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyLocalConflict", new Object[]{"/MYAPP/EMPLOYEE", "neeraj", Boolean.TRUE});
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        String noConflictSql = "update myapp.employee set workdept = 'xxx' where lastname = 'wale'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.FALSE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.FALSE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from myapp.employee where lastname = 'kumar'";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)1, (int)cnt);
        conn.commit();
    }

    public void testSelectForUpdate_RR_key_not_in_projection() throws Exception {
        this.startVMs(2, 2);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname)) replicate";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        String conflictSql = "update employee set workdept = 'xxx' where lastname = 'kumar'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        String noConflictSql = "update employee set workdept = 'xxx' where lastname = 'wale'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "installObserver");
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdate_RR_key_in_projection() throws Exception {
        this.startVMs(2, 2);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname)) replicate";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT firstname, workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        String conflictSql = "update employee set workdept = 'xxx' where lastname = 'kumar'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        String noConflictSql = "update employee set workdept = 'xxx' where lastname = 'wale'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdate_RR_composite_key_in_projection() throws Exception {
        this.startVMs(2, 2);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname, lastname)) replicate";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT firstname, workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        String conflictSql = "update employee set workdept = 'xxx' where lastname = 'kumar'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        String noConflictSql = "update employee set workdept = 'xxx' where lastname = 'wale'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdate_RR_composite_key_partially_in_projection() throws Exception {
        this.startVMs(2, 2);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname, lastname)) replicate";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT firstname, workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        String conflictSql = "update employee set workdept = 'xxx' where lastname = 'kumar'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        String noConflictSql = "update employee set workdept = 'xxx' where lastname = 'wale'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdate_RR_composite_key_not_in_projection() throws Exception {
        this.startVMs(2, 2);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname, lastname)) replicate";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT firstname, workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        String conflictSql = "update employee set workdept = 'xxx' where lastname = 'kumar'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        String noConflictSql = "update employee set workdept = 'xxx' where lastname = 'wale'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdate_RR_no_primary_key() throws Exception {
        this.startVMs(2, 2);
        String jdbcSQL = "create table Employee (firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null) replicate";
        this.clientSQLExecute(1, jdbcSQL);
        jdbcSQL = "insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)";
        this.clientSQLExecute(1, jdbcSQL);
        String sql = "SELECT firstname, workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS";
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt.execute(sql);
        String conflictSql = "update employee set workdept = 'xxx' where lastname = 'kumar'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{conflictSql, Boolean.TRUE, this.getIsolationLevel()});
        String noConflictSql = "update employee set workdept = 'xxx' where lastname = 'wale'";
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(1)).invoke(((Object)((Object)this)).getClass(), "verifyUpdateConflict", new Object[]{noConflictSql, Boolean.TRUE, this.getIsolationLevel()});
        ((VM)this.serverVMs.get(0)).invoke(((Object)((Object)this)).getClass(), "executeSelectForUpdateQuery", new Object[]{sql, Boolean.TRUE, this.getIsolationLevel()});
        ResultSet uprs = stmt.getResultSet();
        String theDept = "rnd";
        while (uprs.next()) {
            String workDept = uprs.getString("WORKDEPT");
            if (!workDept.equals(theDept)) continue;
            uprs.updateInt("bonus", 10);
            uprs.updateRow();
        }
        conn.commit();
        sql = "select * from employee";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            int bonus = rs.getInt(4);
            SelectForUpdateInTransactionDUnit.assertEquals((int)10, (int)bonus);
        }
        SelectForUpdateInTransactionDUnit.assertEquals((int)4, (int)cnt);
        conn.commit();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, sql, this.goldenTextFile, "equal_bonus");
    }

    public void testSelectForUpdateWarnings() throws Exception {
        int bonus;
        this.startVMs(2, 2);
        Connection conn = TestUtil.getConnection();
        conn.setTransactionIsolation(0);
        conn.setAutoCommit(false);
        Statement stmtForTableAndInsert = conn.createStatement();
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus int not null, primary key (firstname, lastname))");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0), ('asif', 'shahid', 'rnd', 0), ('dada', 'ji', 'rnd', 0), ('sum', 'wale', 'rnd', 0)");
        Statement stmt = conn.createStatement(1003, 1008, 2);
        ResultSet uprs = stmt.executeQuery("SELECT workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS");
        while (uprs.next()) {
            uprs.getString("WORKDEPT");
            int bonus2 = uprs.getInt("BONUS");
            uprs.updateInt("BONUS", bonus2 + 250);
            uprs.updateRow();
        }
        SQLWarning w = uprs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertTrue((boolean)"0A000".equals(w.getSQLState()));
        uprs.close();
        Statement stmt2 = conn.createStatement();
        ResultSet rs = stmt2.executeQuery("select * from employee");
        w = rs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        conn.commit();
        stmt.executeUpdate("update Employee set bonus = 1000 where lastname <> 'kumar'");
        w = stmt.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)rs.getWarnings());
        stmt2.executeUpdate("update Employee set bonus = bonus + 1000 where lastname <> 'kumar'");
        w = stmt2.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        PreparedStatement ps = conn.prepareStatement("SELECT workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS", 1003, 1008);
        ps.execute();
        ResultSet prs = ps.getResultSet();
        while (prs.next()) {
            prs.getString("WORKDEPT");
            bonus = prs.getInt("BONUS");
            prs.updateInt("BONUS", bonus + 1250);
            prs.updateRow();
        }
        w = prs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertTrue((boolean)"0A000".equals(w.getSQLState()));
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        conn.createStatement(1003, 1008, 2);
        uprs = stmt.executeQuery("SELECT workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS");
        while (uprs.next()) {
            uprs.getString("WORKDEPT");
            bonus = uprs.getInt("BONUS");
            uprs.updateInt("BONUS", bonus + 250);
            uprs.updateRow();
        }
        w = uprs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        uprs.close();
        stmt2 = conn.createStatement();
        rs = stmt2.executeQuery("select * from employee");
        w = rs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        conn.commit();
        stmt.executeUpdate("update Employee set bonus = 1000 where lastname <> 'kumar'");
        w = stmt.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)rs.getWarnings());
        stmt2.executeUpdate("update Employee set bonus = bonus + 1000 where lastname <> 'kumar'");
        w = stmt2.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        ps = conn.prepareStatement("SELECT workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS", 1003, 1008);
        ps.execute();
        prs = ps.getResultSet();
        while (prs.next()) {
            prs.getString("WORKDEPT");
            bonus = prs.getInt("BONUS");
            prs.updateInt("BONUS", bonus + 1250);
            prs.updateRow();
        }
        conn.commit();
        w = prs.getWarnings();
        SelectForUpdateInTransactionDUnit.assertNull((Object)w);
        this.sqlExecuteVerify(new int[]{1}, new int[]{1}, "select * from employee", this.goldenTextFile, "non_equal_bonus");
    }

    protected int getIsolationLevel() {
        return 2;
    }

    static class SelectForUpdateObserver
    extends GemFireXDQueryObserverAdapter {
        private HashMap<Object, Object> keysLocked;
        private HashMap<Object, Object> keysInfoAttached;

        SelectForUpdateObserver() {
        }

        public void lockingRowForTX(TXStateProxy tx, GemFireContainer container, RegionEntry entry, boolean writeLock) {
            if (writeLock) {
                if (this.keysLocked == null) {
                    this.keysLocked = new HashMap();
                }
                this.keysLocked.put(entry.getKeyCopy(), null);
            }
        }

        public void attachingKeyInfoForUpdate(GemFireContainer container, RegionEntry entry) {
            if (this.keysInfoAttached == null) {
                this.keysInfoAttached = new HashMap();
            }
            this.keysInfoAttached.put(entry.getKeyCopy(), null);
        }

        public boolean checkIfTheseKeysLocked(Object[] keys) {
            for (int i = 0; i < keys.length; ++i) {
                if (this.keysLocked.containsKey(keys[i])) continue;
                return false;
            }
            return true;
        }

        public boolean checkIfTheseKeysSent(Object[] keys) {
            for (int i = 0; i < keys.length; ++i) {
                if (this.keysInfoAttached.containsKey(keys[i])) continue;
                return false;
            }
            return true;
        }
    }
}

