/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.transactions;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.transactions.LocalIndexTransactionDUnit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class LocalIndexTransactionRRDUnit
extends LocalIndexTransactionDUnit {
    public LocalIndexTransactionRRDUnit(String name) {
        super(name);
    }

    public void testIndexesInCommitConflict_44435() throws Exception {
        int i;
        ResultSet rs;
        Statement st;
        Connection conn;
        block10: {
            this.startVMs(1, 1);
            conn = TestUtil.getConnection();
            conn.setTransactionIsolation(this.getIsolationLevel());
            conn.setAutoCommit(false);
            st = conn.createStatement();
            st.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, c4 int not null, c5 int not null)");
            st.execute("create index i1 on t1 (c5)");
            conn.commit();
            int numRows = 20;
            PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
            for (int c1 = 1; c1 <= 20; ++c1) {
                pstmt.setInt(1, c1);
                pstmt.setInt(2, c1);
                pstmt.setInt(3, c1);
                pstmt.setInt(4, c1);
                pstmt.setInt(5, c1);
                pstmt.executeUpdate();
            }
            conn.commit();
            rs = st.executeQuery("select * from t1");
            while (rs.next()) {
                LocalIndexTransactionRRDUnit.assertEquals((int)rs.getInt(1), (int)rs.getInt(2));
            }
            rs.close();
            Connection conn2 = TestUtil.getConnection();
            conn2.setTransactionIsolation(this.getIsolationLevel());
            conn2.setAutoCommit(false);
            Statement st2 = conn2.createStatement();
            LocalIndexTransactionRRDUnit.assertEquals((int)1, (int)st2.executeUpdate("update t1 set c5 = 5 where c5 = 1"));
            try {
                conn2.commit();
                LocalIndexTransactionRRDUnit.fail((String)"expected conflict exception");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) break block10;
                throw sqle;
            }
        }
        LocalIndexTransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 5 where c5 = 1"));
        conn.commit();
        boolean foundOne = false;
        rs = st.executeQuery("select * from t1 where c5 = 5");
        for (i = 1; i <= 2; ++i) {
            LocalIndexTransactionRRDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionRRDUnit.assertEquals((int)5, (int)rs.getInt(5));
            if (foundOne) {
                LocalIndexTransactionRRDUnit.assertEquals((int)5, (int)rs.getInt(1));
                continue;
            }
            if (rs.getInt(1) == 1) {
                foundOne = true;
                continue;
            }
            LocalIndexTransactionRRDUnit.assertEquals((int)5, (int)rs.getInt(1));
        }
        LocalIndexTransactionRRDUnit.assertFalse((boolean)rs.next());
        LocalIndexTransactionRRDUnit.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 10 where c1 = 1"));
        conn.commit();
        rs = st.executeQuery("select * from t1 where c5 = 10");
        foundOne = false;
        for (i = 1; i <= 2; ++i) {
            LocalIndexTransactionRRDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionRRDUnit.assertEquals((int)10, (int)rs.getInt(5));
            if (foundOne) {
                LocalIndexTransactionRRDUnit.assertEquals((int)10, (int)rs.getInt(1));
                continue;
            }
            if (rs.getInt(1) == 1) {
                foundOne = true;
                continue;
            }
            LocalIndexTransactionRRDUnit.assertEquals((int)10, (int)rs.getInt(1));
        }
        conn.commit();
    }

    @Override
    protected int getIsolationLevel() {
        return 4;
    }
}

