/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.transactions;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexScanController;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.util.TestException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.CyclicBarrier;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalIndexTransactionDUnit
extends DistributedSQLTestBase {
    public LocalIndexTransactionDUnit(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(LocalIndexTransactionDUnit.class));
    }

    public void testTransactionalUpdateWithLocalIndexModified_EqualityCondition_PR() throws Exception {
        this.transactionalUpdateWithLocalIndexModified_EqualityCondition(true);
    }

    public void testTransactionalUpdateWithLocalIndexModified_EqualityCondition_RR() throws Exception {
        this.transactionalUpdateWithLocalIndexModified_EqualityCondition(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transactionalUpdateWithLocalIndexModified_EqualityCondition(boolean isPR) throws Exception {
        this.startVMs(1, 1);
        String baseTable = "T1";
        Connection conn = TestUtil.getConnection();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) " + (isPR ? "" : "replicate"));
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (int i = 1; i < 21; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        SerializableRunnable csr = this.getObserverInitializer(schema, "T1", "I1");
        try {
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            LocalIndexTransactionDUnit.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 =5 where c5 =1"));
            LocalIndexTransactionDUnit.assertEquals((int)2, (int)st.executeUpdate("update t1 set c2 = 8  where c5 = 5"));
            conn.commit();
            ResultSet rs = st.executeQuery("Select c2 from t1 where c5 =5");
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionDUnit.assertEquals((int)8, (int)rs.getInt(1));
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionDUnit.assertEquals((int)8, (int)rs.getInt(1));
            conn.commit();
            csr = this.verifyIndexScan(3);
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
        }
    }

    public void testTransactionalUpdateWithLocalIndexModified_Range_1_PR() throws Exception {
        this.transactionalUpdateWithLocalIndexModified_Range_1(true);
    }

    public void testTransactionalUpdateWithLocalIndexModified_Range_1_RR() throws Exception {
        this.transactionalUpdateWithLocalIndexModified_Range_1(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transactionalUpdateWithLocalIndexModified_Range_1(boolean isPR) throws Exception {
        this.startVMs(1, 3);
        String baseTable = "T1";
        Connection conn = TestUtil.getConnection();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int  , c2 int , c3 int ,c4 int  , c5 int , primary key(c1)) " + (isPR ? "redundancy 2" : "replicate"));
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (int i = 1; i < 31; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        SerializableRunnable csr = this.getObserverInitializer(schema, "T1", "I1");
        try {
            int i;
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            LocalIndexTransactionDUnit.assertEquals((int)11, (int)st.executeUpdate("update t1 set c5 = 25 where c5  > 9 and c5 < 21"));
            LocalIndexTransactionDUnit.assertEquals((int)21, (int)st.executeUpdate("update t1 set c2 = 8  where c5 > 20"));
            conn.commit();
            ResultSet rs = st.executeQuery("Select c2 from t1 where c5 > 20");
            for (i = 1; i < 22; ++i) {
                LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
                LocalIndexTransactionDUnit.assertEquals((int)8, (int)rs.getInt(1));
            }
            LocalIndexTransactionDUnit.assertFalse((boolean)rs.next());
            conn.commit();
            if (isPR) {
                csr = this.verifyIndexScan(3);
                this.serverExecute(1, (Runnable)csr);
            }
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            LocalIndexTransactionDUnit.assertEquals((int)4, (int)st.executeUpdate("update t1 set c5 = 10  where c1 > 15 and c1 < 20"));
            csr = this.getObserverInitializer(schema, "T1", "I1");
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            LocalIndexTransactionDUnit.assertEquals((int)4, (int)st.executeUpdate("update t1 set c2 = 1   where c5 > 9 and c5 < 13"));
            conn.commit();
            rs = st.executeQuery("Select c2 from t1 where c5 > 9 and c5 < 13");
            for (i = 1; i < 5; ++i) {
                LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
                LocalIndexTransactionDUnit.assertEquals((int)1, (int)rs.getInt(1));
            }
            LocalIndexTransactionDUnit.assertFalse((boolean)rs.next());
            if (isPR) {
                csr = this.verifyIndexScan(2);
                this.serverExecute(1, (Runnable)csr);
            }
        }
        finally {
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
        }
    }

    public void testTxUpdateOnTxInsert_Bug42177_PR() throws Exception {
        this.txUpdateOnTxInsert_Bug42177(true);
    }

    public void testTxUpdateOnTxInsert_Bug42177_RR_Bug42266() throws Exception {
        this.txUpdateOnTxInsert_Bug42177(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txUpdateOnTxInsert_Bug42177(boolean isPR) throws Exception {
        int i;
        this.startVMs(1, 3);
        String baseTable = "T1";
        Connection conn = TestUtil.getConnection();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null, c5 int not null , primary key(c1)) " + (isPR ? "redundancy 1" : "replicate"));
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (i = 1; i < 10; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (i = 10; i < 21; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        SerializableRunnable csr = this.getObserverInitializer(schema, "T1", "I1");
        try {
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            LocalIndexTransactionDUnit.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 =5 where c5 =1"));
            LocalIndexTransactionDUnit.assertEquals((int)2, (int)st.executeUpdate("update t1 set c2 = 8  where c5 = 5"));
            conn.commit();
            ResultSet rs = st.executeQuery("Select c2 from t1 where c5 =5");
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionDUnit.assertEquals((int)8, (int)rs.getInt(1));
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionDUnit.assertEquals((int)8, (int)rs.getInt(1));
            conn.commit();
            if (isPR) {
                csr = this.verifyIndexScan(3);
                this.serverExecute(1, (Runnable)csr);
            }
        }
        finally {
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
        }
    }

    public void testTxInsertUpdateDeleteCombo_PR() throws Exception {
        this.txInsertUpdateDeleteCombo(true);
    }

    public void testTxInsertUpdateDeleteCombo_RR() throws Exception {
        this.txInsertUpdateDeleteCombo(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txInsertUpdateDeleteCombo(boolean isPR) throws Exception {
        int i;
        this.startVMs(1, 2);
        String baseTable = "T1";
        Connection conn = TestUtil.getConnection();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null, c2 int not null, c3 int not null, c4 int not null, c5 int not null , primary key(c1)) " + (isPR ? "redundancy 1" : "replicate"));
        st.execute("create index i1 on t1 (c5) ");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (i = 1; i < 6; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        for (i = 31; i < 41; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (i = 6; i < 31; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        SerializableRunnable csr = this.getObserverInitializer(schema, "T1", "I1");
        try {
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            LocalIndexTransactionDUnit.assertEquals((int)10, (int)st.executeUpdate("update t1 set c5 = 5 where c5 > 0 and c5 < 11"));
            LocalIndexTransactionDUnit.assertEquals((int)16, (int)st.executeUpdate("update t1 set c2 = 8  where c5 = 5 or ( c5 > 14 and c5 < 21)"));
            LocalIndexTransactionDUnit.assertEquals((int)22, (int)st.executeUpdate("delete from t1 where c2 = 8 or c2 > 34"));
            conn.commit();
            if (isPR) {
                csr = this.verifyIndexScan(2);
                this.serverExecute(1, (Runnable)csr);
            }
        }
        finally {
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
        }
    }

    public void testTxInsertUpdateDeleteComboForBatching_PR() throws Exception {
        this.txInsertUpdateDeleteComboForBatching(true);
    }

    public void testTxInsertUpdateDeleteComboForBatching_RR() throws Exception {
        this.txInsertUpdateDeleteComboForBatching(false);
    }

    private void txInsertUpdateDeleteComboForBatching(boolean isPR) throws Exception {
        int i;
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        final String defaultSchema = TestUtil.getCurrentDefaultSchemaName();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null, c2 int not null, c3 int not null, c4 int not null, c5 int not null , primary key(c1)) " + (isPR ? "redundancy 1" : "replicate"));
        st.execute("create index i1 on t1 (c5)");
        st.execute("create index i2 on t1 (c2)");
        conn.commit();
        this.serverExecute(PartitionedRegion.rand.nextInt(3) + 1, (Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    int i;
                    Connection conn = TestUtil.getConnection();
                    conn.setTransactionIsolation(LocalIndexTransactionDUnit.this.getIsolationLevel());
                    PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
                    for (i = 1; i < 6; ++i) {
                        pstmt.setInt(1, i);
                        pstmt.setInt(2, i);
                        pstmt.setInt(3, i);
                        pstmt.setInt(4, i);
                        pstmt.setInt(5, i);
                        pstmt.executeUpdate();
                    }
                    for (i = 31; i < 41; ++i) {
                        pstmt.setInt(1, i);
                        pstmt.setInt(2, i);
                        pstmt.setInt(3, i);
                        pstmt.setInt(4, i);
                        pstmt.setInt(5, i);
                        pstmt.executeUpdate();
                    }
                    conn.commit();
                }
                catch (SQLException sqle) {
                    throw new TestException("unexpected exception", (Throwable)sqle);
                }
            }
        });
        this.serverExecute(1, (Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    conn.setTransactionIsolation(LocalIndexTransactionDUnit.this.getIsolationLevel());
                    PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
                    for (int i = 6; i < 31; ++i) {
                        pstmt.setInt(1, i);
                        pstmt.setInt(2, i);
                        pstmt.setInt(3, i);
                        pstmt.setInt(4, i);
                        pstmt.setInt(5, i);
                        pstmt.executeUpdate();
                    }
                }
                catch (SQLException sqle) {
                    throw new TestException("unexpected exception", (Throwable)sqle);
                }
            }
        });
        this.serverExecute(1, (Runnable)new SerializableRunnable(){

            public void run() {
                try {
                    Connection conn = TestUtil.jdbcConn;
                    Statement st = conn.createStatement();
                    TestCase.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 5 where c1 = 1"));
                    TestCase.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 6 where c1 = 2"));
                    TestCase.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 6 where c1 = 7"));
                    TestCase.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 5 where c1 = 9"));
                    TestCase.assertEquals((int)8, (int)st.executeUpdate("update t1 set c5 = 5 where c1 > 2 and c1 < 11"));
                    TestCase.assertEquals((int)1, (int)st.executeUpdate("update t1 set c2 = 8 where c1 = 1"));
                    TestCase.assertEquals((int)1, (int)st.executeUpdate("update t1 set c2 = 8 where c1 = 2"));
                    TestCase.assertEquals((int)1, (int)st.executeUpdate("update t1 set c2 = 8 where c1 = 7"));
                    TestCase.assertEquals((int)1, (int)st.executeUpdate("update t1 set c2 = 8 where c1 = 9"));
                    TestCase.assertEquals((int)15, (int)st.executeUpdate("update t1 set c2 = 8  where c5 = 5 or ( c5 > 14 and c5 < 21)"));
                    TestCase.assertEquals((int)22, (int)st.executeUpdate("delete from t1 where c2 = 8 or c2 > 34"));
                    conn.commit();
                    TXManagerImpl.waitForPendingCommitForTest();
                }
                catch (SQLException sqle) {
                    ((GfxdIndexManager)((LocalRegion)GemFireCacheImpl.getInstance().getRegion("/" + defaultSchema + "/T1")).getIndexUpdater()).dumpAllIndexes();
                    throw new TestException("unexpected exception", (Throwable)sqle);
                }
            }
        });
        ResultSet rs = st.executeQuery("select c5 from t1 where c5 > 0 order by c5");
        for (i = 11; i < 15; ++i) {
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionDUnit.assertEquals((int)i, (int)rs.getInt(1));
        }
        for (i = 21; i < 35; ++i) {
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionDUnit.assertEquals((int)i, (int)rs.getInt(1));
        }
        LocalIndexTransactionDUnit.assertFalse((boolean)rs.next());
        rs = st.executeQuery("select c2 from t1 where c2 > 0 order by c2");
        for (i = 11; i < 15; ++i) {
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionDUnit.assertEquals((int)i, (int)rs.getInt(1));
        }
        for (i = 21; i < 35; ++i) {
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionDUnit.assertEquals((int)i, (int)rs.getInt(1));
        }
        LocalIndexTransactionDUnit.assertFalse((boolean)rs.next());
        conn.commit();
    }

    public void testTxDeleteImpactOnLocalIndex_PR() throws Exception {
        this.txDeleteImpactOnLocalIndex(true);
    }

    public void testTxDeleteImpactOnLocalIndex_RR() throws Exception {
        this.txDeleteImpactOnLocalIndex(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txDeleteImpactOnLocalIndex(boolean isPR) throws Exception {
        this.startVMs(1, 1);
        String baseTable = "T1";
        Connection conn = TestUtil.getConnection();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) " + (isPR ? "" : "replicate"));
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (int i = 1; i < 41; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        SerializableRunnable csr = this.getObserverInitializer(schema, "T1", "I1");
        try {
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            LocalIndexTransactionDUnit.assertEquals((int)6, (int)st.executeUpdate("Delete from t1  where c5 > 14 and c5 <= 20"));
            LocalIndexTransactionDUnit.assertEquals((int)14, (int)st.executeUpdate("update t1 set c2 = 8  where c5 >= 1 and c5 < 21 "));
            conn.commit();
            csr = this.verifyIndexScan(2);
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
        }
    }

    public void testTxPKDeleteImpactOnLocalIndex_PR() throws Exception {
        this.txPKDeleteImpactOnLocalIndex(true);
    }

    public void testTxPKDeleteImpactOnLocalIndex_RR() throws Exception {
        this.txPKDeleteImpactOnLocalIndex(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txPKDeleteImpactOnLocalIndex(boolean isPR) throws Exception {
        this.startVMs(1, 1);
        String baseTable = "T1";
        Connection conn = TestUtil.getConnection();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) " + (isPR ? "" : "replicate"));
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (int i = 1; i < 31; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        LocalIndexTransactionDUnit.assertEquals((int)1, (int)st.executeUpdate("Delete from t1  where c1 = 10"));
        SerializableRunnable csr = this.getObserverInitializer(schema, "T1", "I1");
        try {
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            LocalIndexTransactionDUnit.assertEquals((int)19, (int)st.executeUpdate("update t1 set c2 = 8  where c5 >= 1 and c5 < 21 "));
            conn.commit();
            csr = this.verifyIndexScan(1);
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
        }
    }

    public void testTxPKUpdateImpactOnLocalIndex_PR() throws Exception {
        this.txPKUpdateImpactOnLocalIndex(true);
    }

    public void testTtxPKUpdateImpactOnLocalIndex_RR() throws Exception {
        this.txPKUpdateImpactOnLocalIndex(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txPKUpdateImpactOnLocalIndex(boolean isPR) throws Exception {
        this.startVMs(1, 1);
        String baseTable = "T1";
        Connection conn = TestUtil.getConnection();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) " + (isPR ? "" : "replicate"));
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (int i = 1; i < 31; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        LocalIndexTransactionDUnit.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 20   where c1 = 15"));
        SerializableRunnable csr = this.getObserverInitializer(schema, "T1", "I1");
        try {
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            LocalIndexTransactionDUnit.assertEquals((int)9, (int)st.executeUpdate("update t1 set c2 = 8  where c5 >= 18 and c5 < 26 "));
            conn.commit();
            csr = this.verifyIndexScan(1);
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTXIndexData_43299() throws Exception {
        int v2;
        int v1;
        ResultSet rs;
        Thread t;
        Throwable[] failEx;
        CyclicBarrier barrier;
        Statement st;
        Connection conn;
        block15: {
            block14: {
                Properties props = new Properties();
                props.setProperty(GfxdConstants.MAX_LOCKWAIT, "10000");
                this.startVMs(1, 1, 0, null, props);
                String schema = "TEST";
                String tableName = "T1";
                String table = "TEST.T1";
                conn = TestUtil.getConnection();
                conn.setTransactionIsolation(this.getIsolationLevel());
                conn.setAutoCommit(false);
                st = conn.createStatement();
                st.execute("Create table TEST.T1 (c1 int not null, c2 int not null, c3 int not null, c4 int not null, c5 int not null, primary key(c1))");
                PreparedStatement pstmt = conn.prepareStatement("insert into TEST.T1 values(?,?,?,?,?)");
                for (int i = 1; i < 31; ++i) {
                    pstmt.setInt(1, i);
                    pstmt.setInt(2, i);
                    pstmt.setInt(3, i);
                    pstmt.setInt(4, i);
                    pstmt.setInt(5, i);
                    pstmt.executeUpdate();
                }
                barrier = new CyclicBarrier(2);
                failEx = new Throwable[]{null};
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Connection conn = TestUtil.getConnection();
                            conn.setTransactionIsolation(LocalIndexTransactionDUnit.this.getIsolationLevel());
                            conn.setAutoCommit(false);
                            conn.createStatement().execute("insert into TEST.T1 values(100, 100, 100, 100, 100)");
                            barrier.await();
                            barrier.await();
                            conn.commit();
                        }
                        catch (Throwable t) {
                            failEx[0] = t;
                            LocalIndexTransactionDUnit.this.getLogWriter().error((Object)"unexpected exception", t);
                        }
                    }
                });
                t.start();
                barrier.await();
                try {
                    st.execute("create index i1 on TEST.T1 (c5)");
                    LocalIndexTransactionDUnit.fail((String)"expected an unsupported exception");
                }
                catch (SQLException sqle) {
                    if ("0A000".equals(sqle.getSQLState())) break block14;
                    throw sqle;
                }
            }
            conn.commit();
            st = conn.createStatement();
            try {
                st.execute("create index i1 on TEST.T1 (c5)");
                LocalIndexTransactionDUnit.fail((String)"expected a timeout exception");
            }
            catch (SQLException sqle) {
                if ("40XL1".equals(sqle.getSQLState())) break block15;
                throw sqle;
            }
        }
        barrier.await();
        LocalIndexTransactionDUnit.assertEquals((int)1, (int)st.executeUpdate("update TEST.T1 set c5 = 20 where c1 = 15"));
        LocalIndexTransactionDUnit.assertEquals((int)5, (int)st.executeUpdate("update TEST.T1 set c2 = 70  where c5 >= 18 and c5 < 22"));
        conn.commit();
        st = conn.createStatement();
        st.execute("create index i1 on TEST.T1 (c5)");
        t.join();
        LocalIndexTransactionDUnit.assertNull((Object)failEx[0]);
        SerializableRunnable csr = this.getObserverInitializer("TEST", "T1", "I1");
        try {
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            LocalIndexTransactionDUnit.assertEquals((int)9, (int)st.executeUpdate("update TEST.T1 set c2 = 8  where c5 >= 18 and c5 < 26 "));
            csr = this.verifyIndexScan(1);
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
        }
        csr = this.getObserverInitializer("TEST", "T1", "I1");
        try {
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            rs = st.executeQuery("select c1, c2 from TEST.T1 where c5 = 20");
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            v1 = rs.getInt(1);
            LocalIndexTransactionDUnit.assertEquals((int)8, (int)rs.getInt(2));
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            v2 = rs.getInt(1);
            LocalIndexTransactionDUnit.assertEquals((int)8, (int)rs.getInt(2));
            LocalIndexTransactionDUnit.assertFalse((boolean)rs.next());
            LocalIndexTransactionDUnit.assertTrue((String)("unexpected values v1=" + v1 + ", v2=" + v2), (v1 == 15 && v2 == 20 || v1 == 20 && v2 == 15 ? 1 : 0) != 0);
            csr = this.verifyIndexScan(1);
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
        }
        rs = st.executeQuery("select c1, c2, c5 from TEST.T1 where c1 = 15 or c1 = 20");
        LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
        v1 = rs.getInt(1);
        LocalIndexTransactionDUnit.assertEquals((int)8, (int)rs.getInt(2));
        LocalIndexTransactionDUnit.assertEquals((int)20, (int)rs.getInt(3));
        LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
        v2 = rs.getInt(1);
        LocalIndexTransactionDUnit.assertEquals((int)8, (int)rs.getInt(2));
        LocalIndexTransactionDUnit.assertEquals((int)20, (int)rs.getInt(3));
        LocalIndexTransactionDUnit.assertFalse((boolean)rs.next());
        LocalIndexTransactionDUnit.assertTrue((String)("unexpected values v1=" + v1 + ", v2=" + v2), (v1 == 15 && v2 == 20 || v1 == 20 && v2 == 15 ? 1 : 0) != 0);
        csr = this.getObserverInitializer("TEST", "T1", "I1");
        try {
            csr.run();
            this.serverExecute(1, (Runnable)csr);
            rs = st.executeQuery("select c1, c2 from TEST.T1 where c5 = 100");
            LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
            LocalIndexTransactionDUnit.assertEquals((int)100, (int)rs.getInt(1));
            LocalIndexTransactionDUnit.assertEquals((int)100, (int)rs.getInt(2));
            LocalIndexTransactionDUnit.assertFalse((boolean)rs.next());
            csr = this.verifyIndexScan(1);
            this.serverExecute(1, (Runnable)csr);
        }
        finally {
            csr = this.clearObserver();
            csr.run();
            this.serverExecute(1, (Runnable)csr);
        }
        rs = st.executeQuery("select c1, c2, c5 from TEST.T1 where c3 = 100");
        LocalIndexTransactionDUnit.assertTrue((boolean)rs.next());
        LocalIndexTransactionDUnit.assertEquals((int)100, (int)rs.getInt(1));
        LocalIndexTransactionDUnit.assertEquals((int)100, (int)rs.getInt(2));
        LocalIndexTransactionDUnit.assertEquals((int)100, (int)rs.getInt(3));
        LocalIndexTransactionDUnit.assertFalse((boolean)rs.next());
    }

    protected int getIsolationLevel() {
        return 2;
    }

    private SerializableRunnable getObserverInitializer(final String schema, final String baseTable, final String indexName) {
        return new SerializableRunnable("Observer Initializer"){

            public void run() throws CacheException {
                try {
                    IndexInvocationObserver observer = new IndexInvocationObserver(schema, baseTable, indexName);
                    GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private SerializableRunnable clearObserver() {
        return new SerializableRunnable("clear Observer"){

            public void run() throws CacheException {
                try {
                    GemFireXDQueryObserverHolder.clearInstance();
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private SerializableRunnable verifyIndexScan(final int minimumINumInvocation) {
        return new SerializableRunnable("verify and clear Observer"){

            public void run() throws CacheException {
                try {
                    IndexInvocationObserver ico = (IndexInvocationObserver)GemFireXDQueryObserverHolder.getObserver(IndexInvocationObserver.class);
                    try {
                        TestCase.assertTrue((ico.getNumInvocation() >= minimumINumInvocation ? 1 : 0) != 0);
                    }
                    catch (AssertionFailedError afe) {
                        LocalIndexTransactionDUnit.this.getLogWriter().error((Object)("Inequality not satisfied: minimum Num invocation expected = " + minimumINumInvocation + "; actual invocations =" + ico.getNumInvocation()));
                        throw afe;
                    }
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private static class IndexInvocationObserver
    extends GemFireXDQueryObserverAdapter {
        private final String qualifiedIndexName;
        private volatile int numInvocations;

        IndexInvocationObserver(String schema, String baseTable, String indexName) {
            this.qualifiedIndexName = schema.toUpperCase() + "." + indexName.toUpperCase() + ":base-table:" + schema.toUpperCase() + "." + baseTable.toUpperCase();
            DistributedTestBase.getGlobalLogger().info((Object)("Qualified index name to compare=" + this.qualifiedIndexName));
        }

        public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
            return Double.MAX_VALUE;
        }

        public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
            return Double.MAX_VALUE;
        }

        public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
            return 1.0;
        }

        public void scanControllerOpened(Object sc, Conglomerate conglom) {
            SortedMap2IndexScanController smisc;
            if (sc instanceof SortedMap2IndexScanController && (smisc = (SortedMap2IndexScanController)sc).getQualifiedIndexName().equals(this.qualifiedIndexName)) {
                ++this.numInvocations;
            }
        }

        int getNumInvocation() {
            return this.numInvocations;
        }
    }
}

