/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.stats;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.util.TestException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.TestCase;

public class StatementStatsDUnit
extends DistributedSQLTestBase {
    private static StatementStatsObserver ob1;
    private static StatementStatsObserver ob2;

    public StatementStatsDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatementStats() throws Exception {
        try {
            Properties serverInfo = new Properties();
            serverInfo.setProperty("gemfire.enable-time-statistics", "true");
            serverInfo.setProperty("statistic-sample-rate", "100");
            serverInfo.setProperty("statistic-sampling-enabled", "true");
            this.startServerVMs(1, 0, null, serverInfo);
            Properties info = new Properties();
            info.setProperty("host-data", "false");
            info.setProperty("gemfire.enable-time-statistics", "true");
            this.startClientVMs(1, 0, null, info);
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
            Connection conn = TestUtil.getConnection(info);
            this.runAndCheckStats(conn, true, 1);
            conn.close();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
            info.setProperty("enable-stats", "false");
            conn = TestUtil.getConnection(info);
            this.runAndCheckStats(conn, false, 1);
            conn.close();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
            info.setProperty("enable-stats", "true");
            conn = TestUtil.getConnection(info);
            this.runAndCheckStats(conn, true, 2);
            conn.close();
            System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "false");
            conn = TestUtil.getConnection(info);
            this.runAndCheckStats(conn, false, 2);
            conn.close();
            info.setProperty("enable-stats", "true");
            Connection conn2 = TestUtil.getConnection(info);
            this.runAndCheckStats(conn2, false, 2);
            conn2.close();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
            info.remove("enable-stats");
            conn = TestUtil.getConnection(info);
            this.runAndCheckStats(conn, false, 2);
            conn.close();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
            Properties info2 = new Properties();
            info2.setProperty("enable-stats", "true");
            info2.setProperty("enable-timestats", "true");
            info2.setProperty("gemfire.enable-time-statistics", "true");
            info2.setProperty("statistic-sample-rate", "100");
            info2.setProperty("statistic-sampling-enabled", "true");
            conn = TestUtil.getConnection(info2);
            this.runAndCheckUpdateSelectStats(conn, true, true);
            info2.remove("enable-timestats");
            info2.remove("enable-stats");
            conn.close();
            this.stopVMNums(1, -1);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
            System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
        }
    }

    private void runAndCheckStats(Connection conn, final boolean enableStats, final int numTimesSampled) throws Exception {
        VM serverVM = (VM)this.serverVMs.get(0);
        StatementStatsDUnit.checkUniqueStatistics();
        serverVM.invoke(((Object)((Object)this)).getClass(), "checkUniqueStatistics");
        Statement stmt = conn.createStatement();
        SerializableRunnable setObserver1 = new SerializableRunnable("set a stats observer1"){

            public void run() throws CacheException {
                ob1 = new StatementStatsObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)ob1);
            }
        };
        setObserver1.run();
        this.serverExecute(1, (Runnable)setObserver1);
        stmt.execute("create schema trade");
        SerializableRunnable checkStats1 = new SerializableRunnable("check observer1"){

            public void run() throws CacheException {
                StatementStatsDUnit.this.checkDDLStatistics(ob1, numTimesSampled, enableStats);
            }
        };
        checkStats1.run();
        this.serverExecute(1, (Runnable)checkStats1);
        SerializableRunnable setObserver2 = new SerializableRunnable("set a stats observer2"){

            public void run() throws CacheException {
                ob2 = new StatementStatsObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)ob2);
            }
        };
        setObserver2.run();
        this.serverExecute(1, (Runnable)setObserver2);
        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
        SerializableRunnable checkStats2 = new SerializableRunnable("check observer2"){

            public void run() throws CacheException {
                Statistics s1 = ob1.getStatistics();
                Statistics s2 = ob2.getStatistics();
                if (enableStats) {
                    TestCase.assertNotSame((String)"Statistics object from different execution cannot be same", (Object)s1, (Object)s2);
                }
                StatementStatsDUnit.this.checkDDLStatistics(ob2, numTimesSampled, enableStats);
                GemFireXDQueryObserverHolder.clearInstance();
            }
        };
        checkStats2.run();
        this.serverExecute(1, (Runnable)checkStats2);
        Date since = new Date(System.currentTimeMillis());
        PreparedStatement psInsertCust = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        InternalDistributedSystem dsys = Misc.getDistributedSystem();
        StatisticsType st = dsys.findType("StatementStats");
        Statistics[] stats = dsys.findStatisticsByType(st);
        Statistics psInsertStat = null;
        String search = "";
        if (enableStats) {
            search = ((EmbedStatement)psInsertCust).getStatementStats().getStatsId();
            StatementStatsDUnit.assertTrue((stats.length >= 1 ? 1 : 0) != 0);
            for (Statistics s : stats) {
                if (!search.equals(s.getTextId())) continue;
                psInsertStat = s;
                this.getLogWriter().info((Object)("Got statistics for " + psInsertStat.getTextId()));
                break;
            }
        }
        for (int i = 0; i < 10; ++i) {
            psInsertCust.setInt(1, i);
            psInsertCust.setString(2, "XXXX" + i);
            since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i);
            psInsertCust.setInt(5, i);
            psInsertCust.executeUpdate();
            if (enableStats) {
                stats = dsys.findStatisticsByType(st);
                StatementStatsDUnit.assertNotNull((Object)stats);
                StatementStatsDUnit.checkInsertUpdateStatistics(psInsertStat, i + 1, numTimesSampled, true, search, 10);
            }
            if (i != 5) continue;
            psInsertCust = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        }
        PreparedStatement psSelectCust = conn.prepareStatement("select * from trade.customers where cust_name = ?");
        Statistics psSelectStats = null;
        if (enableStats) {
            search = ((EmbedStatement)psSelectCust).getStatementStats().getStatsId();
            stats = dsys.findStatisticsByType(st);
            StatementStatsDUnit.assertTrue((stats.length >= 1 ? 1 : 0) != 0);
            for (Statistics s : stats) {
                if (!search.equals(s.getTextId())) continue;
                psSelectStats = s;
                this.getLogWriter().info((Object)("Got statistics for " + psSelectStats.getTextId()));
                break;
            }
            StatementStatsDUnit.assertNotSame((Object)psInsertStat, psSelectStats);
        }
        for (int i = 0; i < 10; ++i) {
            psSelectCust.setString(1, "XXXX" + i);
            ResultSet rs = psSelectCust.executeQuery();
            StatementStatsDUnit.assertTrue((String)"Should return one row", (boolean)rs.next());
            StatementStatsDUnit.assertFalse((String)"Should not return more than one row", (boolean)rs.next());
            rs.close();
            if (!enableStats) continue;
            StatementStatsDUnit.checkSelectStatistics(psSelectStats, i + 1, false, true, numTimesSampled, search, 10);
            String query = search;
            serverVM.invoke(((Object)((Object)this)).getClass(), "checkSelectStatistics", new Object[]{null, i + 1, Boolean.FALSE, Boolean.FALSE, numTimesSampled, query, 10});
        }
        Statistics psSelect2Stats = null;
        PreparedStatement psSelectCust2 = conn.prepareStatement("select * from trade.customers where cid = ?");
        if (enableStats) {
            search = ((EmbedStatement)psSelectCust2).getStatementStats().getStatsId();
            stats = dsys.findStatisticsByType(st);
            StatementStatsDUnit.assertTrue((stats.length >= 1 ? 1 : 0) != 0);
            for (Statistics s : stats) {
                if (!search.equals(s.getTextId())) continue;
                psSelect2Stats = s;
                this.getLogWriter().info((Object)("Got statistics for " + psSelect2Stats.getTextId()));
                break;
            }
            StatementStatsDUnit.assertNotSame((Object)psSelectStats, psSelect2Stats);
        }
        for (int i = 0; i < 10; ++i) {
            psSelectCust2.setInt(1, i);
            ResultSet rs = psSelectCust2.executeQuery();
            StatementStatsDUnit.assertTrue((String)"Should return one row", (boolean)rs.next());
            StatementStatsDUnit.assertFalse((String)"Should not return more than one row", (boolean)rs.next());
            rs.close();
            if (!enableStats) continue;
            StatementStatsDUnit.checkSelectStatistics(psSelect2Stats, i + 1, true, true, numTimesSampled, search, 10);
        }
        psSelectCust.close();
        psInsertCust.close();
        psSelectCust2.close();
        PreparedStatement psDeleteCust = conn.prepareStatement("delete from trade.customers where cid > ?");
        psDeleteCust.setInt(1, 8);
        psDeleteCust.executeUpdate();
        Statistics psDeleteStats = null;
        if (enableStats) {
            stats = dsys.findStatisticsByType(st);
            StatementStatsDUnit.assertNotNull((Object)stats);
            StatementStatsDUnit.assertTrue((stats.length >= 1 ? 1 : 0) != 0);
            search = ((EmbedStatement)psDeleteCust).getStatementStats().getStatsId();
            for (Statistics s : stats) {
                if (!search.equals(s.getTextId())) continue;
                psDeleteStats = s;
                this.getLogWriter().info((Object)("Got statistics for " + psDeleteStats.getTextId()));
                break;
            }
            String query = search;
            StatementStatsDUnit.checkInsertUpdateStatistics(psDeleteStats, 1, numTimesSampled, true, query, 1);
            StatementStatsDUnit.checkDmlWriteStatistics(psDeleteStats, true, query, false);
            serverVM.invoke(((Object)((Object)this)).getClass(), "checkDmlWriteStatistics", new Object[]{null, Boolean.FALSE, query, Boolean.FALSE});
        }
        psDeleteCust.close();
        Statistics sSelect3Stats = null;
        Statement sSelectCust3 = conn.createStatement();
        for (int i = 0; i < 10; ++i) {
            ResultSet rs = sSelectCust3.executeQuery("select count(*) from trade.customers");
            StatementStatsDUnit.assertTrue((String)"Should return one row", (boolean)rs.next());
            StatementStatsDUnit.assertFalse((String)"Should not return more than one row", (boolean)rs.next());
            if (enableStats) {
                String query = ((EmbedStatement)rs.getStatement()).getStatementStats().getStatsId();
                stats = dsys.findStatisticsByType(st);
                StatementStatsDUnit.assertTrue((stats.length >= 1 ? 1 : 0) != 0);
                for (Statistics s : stats) {
                    if (!query.equals(s.getTextId())) continue;
                    sSelect3Stats = s;
                    this.getLogWriter().info((Object)("Got statistics for " + sSelect3Stats.getTextId()));
                    break;
                }
                StatementStatsDUnit.checkSelectCountStarStatistics(sSelect3Stats);
            }
            rs.close();
        }
        sSelectCust3.close();
        stmt.execute("drop table trade.customers");
        stmt.execute("drop schema trade restrict");
    }

    private void runAndCheckUpdateSelectStats(Connection conn, boolean enableStats, boolean debugSubQuery) throws Exception {
        VM serverVM = (VM)this.serverVMs.get(0);
        Statement stmt = conn.createStatement();
        stmt.execute("create schema utrade");
        stmt.execute("create table utrade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
        PreparedStatement psInsertCust = conn.prepareStatement("insert into utrade.customers values (?,?,?,?,?)");
        for (int i = 0; i < 10; ++i) {
            psInsertCust.setInt(1, i);
            psInsertCust.setString(2, "XXXX" + i);
            psInsertCust.setDate(3, new Date(System.currentTimeMillis()));
            psInsertCust.setString(4, "XXXX" + i);
            psInsertCust.setInt(5, i);
            psInsertCust.executeUpdate();
        }
        Statement sSelectCust4 = conn.createStatement();
        sSelectCust4.execute("create table utrade.customers2 (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, foreign key (cid) references utrade.customers(cid))");
        PreparedStatement psInsertCust4 = conn.prepareStatement("insert into utrade.customers2 values (?,?,?,?,?)");
        for (int i = 0; i < 9; ++i) {
            psInsertCust4.setInt(1, i);
            psInsertCust4.setString(2, "XXXX" + i);
            psInsertCust4.setDate(3, new Date(System.currentTimeMillis()));
            psInsertCust4.setString(4, "XXXX" + i);
            psInsertCust4.setInt(5, i);
            psInsertCust4.executeUpdate();
        }
        psInsertCust4.close();
        PreparedStatement psUpdateCust4 = conn.prepareStatement("update utrade.customers2 set tid = 5 where cid in (select tid from utrade.customers where cid > ?)");
        psUpdateCust4.setInt(1, 1);
        psUpdateCust4.executeUpdate();
        InternalDistributedSystem dsys = Misc.getDistributedSystem();
        StatisticsType st = dsys.findType("StatementStats");
        Statistics[] stats = dsys.findStatisticsByType(st);
        String search = null;
        if (enableStats) {
            stats = dsys.findStatisticsByType(st);
            StatementStatsDUnit.assertNotNull((Object)stats);
            search = ((EmbedStatement)psUpdateCust4).getStatementStats().getStatsId();
            StatementStatsDUnit.assertTrue((stats.length >= 1 ? 1 : 0) != 0);
            Statistics psUpdate4Stats = null;
            for (Statistics s : stats) {
                if (!search.equals(s.getTextId())) continue;
                psUpdate4Stats = s;
                this.getLogWriter().info((Object)("Got statistics for " + psUpdate4Stats.getTextId()));
                break;
            }
            String query = search;
            StatementStatsDUnit.checkDmlWriteStatistics(psUpdate4Stats, true, query, debugSubQuery);
            serverVM.invoke(((Object)((Object)this)).getClass(), "checkDmlWriteStatistics", new Object[]{null, Boolean.FALSE, query, debugSubQuery ? Boolean.TRUE : Boolean.FALSE});
        }
        psUpdateCust4.close();
        if (enableStats) {
            search = "select_tid__UTRADE.CUSTOMERS/";
            serverVM.invoke(((Object)((Object)this)).getClass(), "checkSubQueryStatistics", new Object[]{null, Boolean.FALSE, search, debugSubQuery ? Boolean.TRUE : Boolean.FALSE});
        }
        Thread.sleep(1000L);
        stmt.execute("drop table utrade.customers2");
        stmt.execute("drop table utrade.customers");
        stmt.execute("drop schema utrade restrict");
    }

    public void DISABLED_testUseCase6() throws Exception {
        Properties serverInfo = new Properties();
        serverInfo.setProperty("gemfire.enable-time-statistics", "true");
        serverInfo.setProperty("statistic-sample-rate", "100");
        serverInfo.setProperty("statistic-sampling-enabled", "true");
        this.startServerVMs(1, 0, null, serverInfo);
        Properties info = new Properties();
        info.setProperty("host-data", "false");
        info.setProperty("gemfire.enable-time-statistics", "true");
        System.setProperty(GfxdConstants.GFXD_ENABLE_STATS, "true");
        this.startClientVMs(1, 0, null, info);
        Connection conn = TestUtil.getConnection(info);
        Statement stmt = conn.createStatement();
        stmt.execute("create schema trade");
        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int ) replicate");
        Date since = new Date(System.currentTimeMillis());
        PreparedStatement psInsertCust = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        int cid = 10;
        for (int i = 0; i < 10; ++i) {
            if (i == 5) {
                cid = 15;
            }
            psInsertCust.setInt(1, cid);
            psInsertCust.setString(2, "XXXX" + i);
            since = new Date(System.currentTimeMillis());
            psInsertCust.setDate(3, since);
            psInsertCust.setString(4, "XXXX" + i);
            psInsertCust.setInt(5, i);
            psInsertCust.executeUpdate();
        }
        PreparedStatement psSelect = conn.prepareStatement("select * from trade.customers where cid = ? order by cid");
        for (int j = 0; j < 1; ++j) {
            psSelect.setInt(1, 10);
            ResultSet rs = psSelect.executeQuery();
            int k = 0;
            while (rs.next()) {
                ++k;
            }
            Thread.sleep(3000L);
            StatementStatsDUnit.assertEquals((String)"Should have 5 rows", (int)5, (int)k);
        }
        System.clearProperty(GfxdConstants.GFXD_ENABLE_STATS);
    }

    private void checkDDLStatistics(StatementStatsObserver ob, int numTimesSampled, boolean enableStats) {
        StatementStatsDUnit.assertTrue((boolean)ob.statsEnabled());
        long numTimesOptimize = ob.getNumTimesCompiled();
        StatementStatsDUnit.assertEquals((String)"DDLs should only be compiled once", (long)(ob == ob2 ? (long)numTimesSampled : 1L), (long)numTimesOptimize);
        long executeTime = ob.getExecuteTime();
        if (enableStats && executeTime < 0L) {
            throw new TestException("Execution time cannot be less than zero");
        }
        if (!enableStats && executeTime != 0L) {
            throw new TestException("Execution time shouldn't have been incremented");
        }
        long openTimes = ob.getOpenTimes();
        if (enableStats && openTimes < 0L) {
            throw new TestException("Open time cannot be less than zero");
        }
        if (!enableStats && openTimes != 0L) {
            throw new TestException("Open time shouldn't have been incremented");
        }
        long numExecutesStarted = ob.getNumExecutes();
        StatementStatsDUnit.assertEquals((String)"Number of execution started does match the expected  number of exections with stats enabled ", (long)numTimesSampled, (long)numExecutesStarted);
        long numExecutesInProgress = ob.getNumExecutesInProgress();
        StatementStatsDUnit.assertEquals((String)"Number of executions started should always be equal to number of executions ended ", (long)0L, (long)numExecutesInProgress);
    }

    public static void checkInsertUpdateStatistics(Statistics s, int numEx, int numTimesSampled, boolean isQueryNode, String query, int maxCount) {
        long bindTime = s.getLong("QNBindTime");
        if (bindTime < 0L) {
            throw new TestException("Bind time cannot be lest than or equalto zero");
        }
        long optimizeTime = s.getLong("QNOptimizeTime");
        if (optimizeTime < 0L) {
            throw new TestException("Time to optimize dml should never be less than zero");
        }
        long routingInfoTime = s.getLong("QNRoutingInfoTime");
        if (routingInfoTime < 0L) {
            throw new TestException("Time to compute routing info of the dml should never be less than zero");
        }
        long numTimesCompiled = s.getLong("QNNumTimesCompiled");
        StatementStatsDUnit.assertEquals((String)"The statment should only be compiled as many times it got executed statistics enabled ", (long)numTimesSampled, (long)numTimesCompiled);
        long executeTime = s.getLong("QNExecuteTime");
        if (executeTime < 0L) {
            throw new TestException("Execution time cannot be zero");
        }
        long numExecutes = s.getLong("QNNumExecutions");
        StatementStatsDUnit.assertEquals((String)"Number of executions ", (long)(numEx + maxCount * (numTimesSampled - 1)), (long)numExecutes);
        long numExecutesInProgress = s.getLong("QNNumExecutionsInProgress");
        StatementStatsDUnit.assertEquals((String)"Number of executions in progress cannnot be greater than or less than zero ", (long)0L, (long)numExecutesInProgress);
        long totalexecuteTime = s.getLong("QNTotalExecutionTime");
        if (totalexecuteTime < 0L) {
            throw new TestException("Execution time cannot be zero");
        }
        long rowsModificationNum = s.getLong("QNNumRowsModified");
        if (rowsModificationNum < 0L) {
            throw new TestException("Rows Modification number cannot be less than or equal to zero");
        }
        long rowsModificationTime = s.getLong("QNRowsModificationTime");
        if (rowsModificationTime < 0L) {
            throw new TestException("Rows Modification time cannot be less than or equal to zero");
        }
        long rowsSeenCount = s.getLong("QNNumRowsSeen");
        if (rowsSeenCount < 0L) {
            throw new TestException("Rows handled by GemFireResultSet i.e. converted to Put cannot be less than or equal to zero");
        }
    }

    public static void checkSelectStatistics(Statistics s, int numEx, boolean isLocalGet, boolean isQueryNode, int numTimesSampled, String query, int maxCount) {
        String prefix;
        long bindTime;
        if (s == null) {
            StatementStatsDUnit.assertNotNull((Object)query);
            InternalDistributedSystem dsys = Misc.getDistributedSystem();
            StatisticsType st = dsys.findType("StatementStats");
            Statistics[] stats = dsys.findStatisticsByType(st);
            StatementStatsDUnit.assertTrue((stats.length >= 1 ? 1 : 0) != 0);
            for (Statistics _s : stats) {
                StatementStatsDUnit.getGlobalLogger().info((Object)("Searching statistics for " + query + " and looking into " + _s.getTextId()));
                if (!query.equals(_s.getTextId())) continue;
                s = _s;
                StatementStatsDUnit.getGlobalLogger().info((Object)("Got statistics for " + s.getTextId()));
                break;
            }
        }
        if ((bindTime = s.getLong((prefix = isQueryNode ? "QN" : "DN") + "BindTime")) < 0L) {
            throw new TestException("Bind time cannot be lest than or equalto zero");
        }
        long optimizeTime = s.getLong(prefix + "OptimizeTime");
        if (optimizeTime < 0L) {
            throw new TestException("Time to optimize dml should never be less than zero");
        }
        long numTimesCompiled = s.getLong(prefix + "NumTimesCompiled");
        StatementStatsDUnit.assertEquals((String)("The statment should only be compiled as many times it got executed statistics enabled. " + prefix + "NumTimesCompiled"), (long)numTimesSampled, (long)numTimesCompiled);
        long computeQueryInfoTime = s.getLong(prefix + "RoutingInfoTime");
        if (computeQueryInfoTime < 0L) {
            throw new TestException("Time taken to compute query info cannot be zero");
        }
        long executeTime = s.getLong(prefix + "ExecuteTime");
        if (executeTime < 0L) {
            throw new TestException("Execution time cannot be less than zero");
        }
        long numExecutions = s.getLong(prefix + "NumExecutions");
        StatementStatsDUnit.assertEquals((String)"Number of select executions ", (long)(numEx + maxCount * (numTimesSampled - 1)), (long)numExecutions);
        long numExecutesInProgress = s.getLong(prefix + "NumExecutionsInProgress");
        StatementStatsDUnit.assertEquals((String)"Number of execution not equal to expected", (long)0L, (long)numExecutesInProgress);
        long totExecTime = s.getLong(prefix + "TotalExecutionTime");
        if (totExecTime < executeTime) {
            throw new TestException("Total Execution time cannot be less than execute time");
        }
    }

    public static void checkDmlWriteStatistics(Statistics s, boolean isQueryNode, String query, boolean debug) {
        if (s == null) {
            StatementStatsDUnit.assertNotNull((Object)query);
            InternalDistributedSystem dsys = Misc.getDistributedSystem();
            StatisticsType st = dsys.findType("StatementStats");
            Statistics[] stats = dsys.findStatisticsByType(st);
            StatementStatsDUnit.assertTrue((stats.length >= 1 ? 1 : 0) != 0);
            for (Statistics _s : stats) {
                if (!query.equals(_s.getTextId())) continue;
                s = _s;
                StatementStatsDUnit.getGlobalLogger().info((Object)("Got statistics for " + s.getTextId()));
                break;
            }
        }
        if (isQueryNode) {
            long rowsSeenCount;
            long rowsModificationTime;
            long rowsModificationNum;
            long executeTime;
            long totalExecuteTime = s.getLong("QNTotalExecutionTime");
            if (totalExecuteTime < 0L) {
                throw new TestException("Execution time cannot be less than zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteL QNTotalExecutionTime " + totalExecuteTime + " Query " + query));
            }
            if ((executeTime = s.getLong("QNExecuteTime")) < 0L) {
                throw new TestException("Execution time cannot be less than zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteL QNExecuteTime " + executeTime + " Query " + query));
            }
            if ((rowsModificationNum = s.getLong("QNNumRowsModified")) < 0L) {
                throw new TestException("Rows Modification number cannot be less than or equal to zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteL QNNumRowsModified " + rowsModificationNum + " Query " + query));
            }
            if ((rowsModificationTime = s.getLong("QNRowsModificationTime")) < 0L) {
                throw new TestException("Rows Modification time cannot be less than or equal to zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteL QNRowsModificationTime " + rowsModificationTime + " Query " + query));
            }
            if ((rowsSeenCount = s.getLong("QNNumRowsSeen")) < 0L) {
                throw new TestException("Rows handled by GemFireResultSet i.e. converted to Put cannot be less than or equal to zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteL QNNumRowsSeen " + rowsSeenCount + " Query " + query));
            }
        } else {
            long subQueryExecutionTime;
            long numRowsSeenInSubQuery;
            long rowsModificationTime;
            long rowsModificationNum;
            long executeTime;
            long totalExecuteTime = s.getLong("DNTotalExecutionTime");
            if (totalExecuteTime < 0L) {
                throw new TestException("Execution time cannot be less than zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteR DNTotalExecutionTime " + totalExecuteTime + " Query " + query));
            }
            if ((executeTime = s.getLong("DNExecuteTime")) < 0L) {
                throw new TestException("Execution time cannot be less than zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteR DNExecuteTime " + executeTime + " Query " + query));
            }
            if ((rowsModificationNum = s.getLong("DNNumRowsModified")) < 0L) {
                throw new TestException("Rows Modification number cannot be lest than or equalto zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteR DNNumRowsModified " + rowsModificationNum + " Query " + query));
            }
            if ((rowsModificationTime = s.getLong("DNRowsModificationTime")) < 0L) {
                throw new TestException("Rows Modification time cannot be lest than or equalto zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteR DNRowsModificationTime " + rowsModificationTime + " Query " + query));
            }
            if ((numRowsSeenInSubQuery = s.getLong("DNSubQueryNumRowsSeen")) < 0L) {
                throw new TestException("Number of rows cannot be less than zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteR DNSubQueryNumRowsSeen " + numRowsSeenInSubQuery + " Query " + query));
            }
            if ((subQueryExecutionTime = s.getLong("DNSubQueryExecutionTime")) < 0L) {
                throw new TestException("Execution time cannot be less than zero");
            }
            if (debug) {
                SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" DmlWriteR DNSubQueryExecutionTime " + subQueryExecutionTime + " Query " + query));
            }
        }
    }

    public static void checkSubQueryStatistics(Statistics s, boolean isQueryNode, String query, boolean debug) {
        long numTableRowsScanned;
        long numRowsProjected;
        long executeTime;
        long totalExecuteTime;
        assert (!isQueryNode);
        if (s == null) {
            StatementStatsDUnit.assertNotNull((Object)query);
            InternalDistributedSystem dsys = Misc.getDistributedSystem();
            StatisticsType st = dsys.findType("StatementStats");
            Statistics[] stats = dsys.findStatisticsByType(st);
            StatementStatsDUnit.assertTrue((stats.length >= 1 ? 1 : 0) != 0);
            for (Statistics _s : stats) {
                if (!_s.getTextId().startsWith(query)) continue;
                s = _s;
                StatementStatsDUnit.getGlobalLogger().info((Object)("Got statistics for " + s.getTextId()));
                break;
            }
        }
        if ((totalExecuteTime = s.getLong("DNTotalExecutionTime")) < 0L) {
            throw new TestException("Execution time cannot be less than zero");
        }
        if (debug) {
            SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" SubQueryR DNTotalExecutionTime " + totalExecuteTime + " Query " + query));
        }
        if ((executeTime = s.getLong("DNExecuteTime")) < 0L) {
            throw new TestException("Execution time cannot be less than zero");
        }
        if (debug) {
            SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" SubQueryR DNExecuteTime " + executeTime + " Query " + query));
        }
        if ((numRowsProjected = s.getLong("DNNumProjectedRows")) < 0L) {
            throw new TestException("Number of rows cannot be less than zero");
        }
        if (debug) {
            SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" SubQueryR DNNumProjectedRows " + numRowsProjected + " Query " + query));
        }
        if ((numTableRowsScanned = s.getLong("DNNumTableRowsScanned")) < 0L) {
            throw new TestException("Execution time cannot be less than zero");
        }
        if (debug) {
            SanityManager.DEBUG_PRINT((String)"DunitTraceStatsGeneration", (String)(" SubQueryR DNNumTableRowsScanned " + numTableRowsScanned + " Query " + query));
        }
    }

    private static void checkSelectCountStarStatistics(Statistics s) {
        long selectExecuteTime = s.getLong("QNExecuteTime");
        if (selectExecuteTime < 0L) {
            throw new TestException("Time to handle rows by GemFireRegionSizeResultSet cannot be less than or equal to zero");
        }
    }

    public static void checkUniqueStatistics() {
        InternalDistributedSystem dsys = Misc.getDistributedSystem();
        StatisticsType st = dsys.findType("StatementStats");
        Statistics[] stats = dsys.findStatisticsByType(st);
        ArrayList<String> statList = new ArrayList<String>();
        for (Statistics s : stats) {
            StatementStatsDUnit.assertFalse((String)("Non-unique stat item: " + s.getTextId()), (boolean)statList.contains(s.getTextId()));
            statList.add(s.getTextId());
        }
    }

    @Override
    public void tearDown2() throws Exception {
        ob1 = null;
        ob2 = null;
        super.tearDown2();
    }

    public static class StatementStatsObserver
    extends GemFireXDQueryObserverAdapter {
        private Statistics statistics = null;
        private long numTimesOptimize;
        private long executeTime;
        private long openTimes;
        private long numExecutes;
        private long numExecutesEnded;

        public Statistics getStatistics() {
            return this.statistics;
        }

        public void statementStatsBeforeExecutingStatement(StatementStats s) {
            if (s == null) {
                this.statistics = null;
                return;
            }
            this.statistics = s.getStatistics();
            this.numTimesOptimize = this.statistics.getLong("QNNumTimesCompiled");
            this.executeTime = this.statistics.getLong("QNExecuteTime");
        }

        public boolean afterQueryExecution(CallbackStatement stmt, SQLException sqle) {
            if (this.statistics == null) {
                TestCase.assertFalse((boolean)((EmbedStatement)stmt).getEmbedConnection().getLanguageConnection().statsEnabled());
                return false;
            }
            this.numExecutesEnded = this.statistics.getLong("QNNumExecutionsInProgress");
            this.numExecutes = this.statistics.getLong("QNNumExecutions");
            return false;
        }

        public boolean statsEnabled() {
            return this.statistics != null;
        }

        public long getNumTimesCompiled() {
            return this.numTimesOptimize;
        }

        public long getExecuteTime() {
            return this.executeTime;
        }

        public long getOpenTimes() {
            return this.openTimes;
        }

        public long getNumExecutes() {
            return this.numExecutes;
        }

        public long getNumExecutesInProgress() {
            return this.numExecutesEnded;
        }
    }
}

