/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.stats;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.stats.StatementPlanDUnit;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StatementPlanWithNativeTimerDUnit
extends StatementPlanDUnit {
    public StatementPlanWithNativeTimerDUnit(String name) {
        super(name);
    }

    @Override
    public void setNativeNanoTimer() throws SQLException {
        Connection conn = TestUtil.getConnection();
        CallableStatement st = conn.prepareCall("CALL SYS.SET_NANOTIMER_TYPE(?, ?)");
        st.setBoolean(1, true);
        st.setString(2, "CLOCK_PROCESS_CPUTIME_ID");
        st.execute();
    }

    public void testNanoTimerSPs() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        ResultSet rs = conn.createStatement().executeQuery("values SYS.GET_NATIVE_NANOTIMER_TYPE()");
        StatementPlanWithNativeTimerDUnit.assertTrue((boolean)rs.next());
        String defaultTimeType = rs.getString(1);
        StatementPlanWithNativeTimerDUnit.assertFalse((boolean)rs.next());
        this.setNativeNanoTimer();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "values SYS.GET_IS_NATIVE_NANOTIMER()", null, "true");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "values SYS.GET_NATIVE_NANOTIMER_TYPE()", null, "CLOCK_PROCESS_CPUTIME_ID");
        CallableStatement st = conn.prepareCall("CALL SYS.SET_NANOTIMER_TYPE(?, ?)");
        st.setBoolean(1, true);
        st.setString(2, "CLOCK_REALTIME");
        st.execute();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "values SYS.GET_IS_NATIVE_NANOTIMER()", null, "true");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "values SYS.GET_NATIVE_NANOTIMER_TYPE()", null, "CLOCK_REALTIME");
        st = conn.prepareCall("CALL SYS.SET_NANOTIMER_TYPE(?, ?)");
        st.setBoolean(1, true);
        st.setString(2, "DEFAULT");
        st.execute();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "values SYS.GET_IS_NATIVE_NANOTIMER()", null, "false");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "values SYS.GET_NATIVE_NANOTIMER_TYPE()", null, defaultTimeType);
        st = conn.prepareCall("CALL SYS.SET_NANOTIMER_TYPE(?, ?)");
        st.setBoolean(1, false);
        st.setString(2, "CLOCK_THREAD_CPUTIME_ID");
        st.execute();
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "values SYS.GET_IS_NATIVE_NANOTIMER()", null, "false");
        this.sqlExecuteVerify(new int[]{1}, new int[]{1, 2, 3}, "values SYS.GET_NATIVE_NANOTIMER_TYPE()", null, "CLOCK_MONOTONIC");
    }
}

