/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.stats;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.XPLAINDistPropsDescriptor;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINResultSetDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINScanPropsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINSortPropsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINStatementDescriptor;
import com.pivotal.gemfirexd.tools.planexporter.AccessDistributedSystem;
import com.pivotal.gemfirexd.tools.planexporter.StatisticsCollectionObserver;
import com.pivotal.gemfirexd.tools.planexporter.TreeNode;
import com.pivotal.gemfirexd.tools.utils.ExecutionPlanUtils;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import java.io.BufferedReader;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.w3c.dom.Element;

@FixMethodOrder(value=MethodSorters.JVM)
public class StatementPlanDUnit
extends DistributedSQLTestBase {
    static final boolean[] isLocalnode = new boolean[]{false};
    static final long TotalRows = 100L;
    final StatisticsCollectionObserver checker = new PlanStatisticsCollectionObserver();
    private boolean allExecutionsDone = false;
    private static final String timeStampPattern = "[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}(\\.\\d+)?";
    private static final String memberIdPattern = ".*\\<v[0-9]([0-9]*)?\\>:[0-9]([0-9]*)?";
    private static final String executeMillis = "\\d+(\\.\\d+)?(E.\\d*)?\\s*ms";
    private static final String optionalPercentage = "\\s+(\\(.*?\\))?";
    private static final String optionalRank = "(\\(\\d\\))?";
    private static final String uuid = "[0-9[a-f]]{8}-[a-f]{4}-[a-f]{4}-[a-f]{4}-[0-9[a-f]]{12}";
    private static final String pipes = "(\\|\\s*)*";
    private static final String plus = "\\s+\\+\\s+";
    private static final String construct = "\\(construct=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+open=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+next=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+close=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\)";
    private static final String serialize = "\\(serialize/deserialize=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+process=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+throttle=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\)";
    private static final String opitonalExpansion = "(\\(construct=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+open=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+next=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+close=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\)|\\(serialize/deserialize=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+process=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+throttle=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\))?";
    private static Connection st_conn = null;

    public StatementPlanDUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.loadLibrary.debug", "true");
    }

    @Override
    public void tearDown2() throws Exception {
        StatisticsCollectionObserver.setInstance(null);
        super.tearDown2();
        System.clearProperty("gemfire.loadLibrary.debug");
    }

    public void setNativeNanoTimer() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_51271_testSingleNodePlanGeneration() throws Exception {
        Logger log = this.getLogWriter();
        this.startVMs(0, 4, 0, null, null);
        this.startVMs(1, 0, 0, null, null);
        this.setNativeNanoTimer();
        final Properties p = new Properties();
        p.setProperty("log-level", this.getLogLevel());
        Thread[] parallelEx = new Thread[10];
        try {
            int ti;
            final int netPort = this.startNetworkServer(1, null, p);
            this.checkLoadLib(StatementPlanDUnit.getTestName());
            Connection conn = TestUtil.getNetConnection(netPort, null, p);
            ResultSet rs = conn.getMetaData().getTables(null, null, "course".toUpperCase(), new String[]{"TABLE"});
            boolean found = rs.next();
            rs.close();
            Statement st = conn.createStatement();
            if (found) {
                st.execute("drop table if exists course ");
            }
            st.execute("create table course (course_id int, course_name varchar(2048),  primary key(course_id)) ");
            String sql = "insert into course values( ";
            StringBuilder ins = new StringBuilder(sql);
            int i = 0;
            while ((long)i < 100L) {
                ins.append(i).append(", '");
                ins.append(TestUtil.numstr(i)).append("' )");
                if ((i + 1) % 100 == 0) {
                    st.execute(ins.toString());
                    log.info((Object)(i + 1 + "th insert done .. "));
                    ins = new StringBuilder(sql);
                } else {
                    ins.append(", ( ");
                }
                ++i;
            }
            st.close();
            log.info((Object)"configuring plan checker ");
            StatementPlanDUnit.isLocalnode[0] = true;
            StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable("setting plan checker"){

                public void run() {
                    StatisticsCollectionObserver.setInstance((StatisticsCollectionObserver)StatementPlanDUnit.this.checker);
                }
            });
            log.info((Object)"preparing for plan generation ");
            for (ti = parallelEx.length - 1; ti >= 0; --ti) {
                parallelEx[ti] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Connection conn = TestUtil.getNetConnection(netPort, null, p);
                            Statement st = conn.createStatement();
                            PreparedStatement ps = conn.prepareStatement("select * from course where course_name like '%' ");
                            st.execute("call sys.SET_TRACE_FLAG('TracePlanGeneration', 'true')");
                            st.execute("call syscs_util.set_statistics_timing(1)");
                            st.execute("call syscs_util.set_explain_connection(1)");
                            ResultSet r = ps.executeQuery();
                            while (r.next()) {
                            }
                            r.close();
                            st.execute("call syscs_util.set_explain_connection(0)");
                            st.execute("call syscs_util.set_statistics_timing(0)");
                            st.execute("call sys.SET_TRACE_FLAG('TracePlanGeneration', 'false')");
                        }
                        catch (SQLException e) {
                            DistributedSQLTestBase.fail("UnExpected Exception " + e, e);
                        }
                    }
                }, " Execution Thread - " + ti);
            }
            for (ti = parallelEx.length - 1; ti >= 0; --ti) {
                parallelEx[ti].start();
            }
            for (ti = parallelEx.length - 1; ti >= 0; --ti) {
                parallelEx[ti].join();
            }
            conn.close();
            Connection eConn = TestUtil.getConnection(p);
            Statement stmt = eConn.createStatement();
            ArrayList<Integer> expectedPlans = new ArrayList<Integer>();
            expectedPlans.add(38);
            ResultSet r = stmt.executeQuery("select STMT_ID, STMT_TEXT from SYS.STATEMENTPLANS");
            log.info((Object)"Extracting query plans");
            int numQueryPlans = 0;
            while (r.next()) {
                ++numQueryPlans;
                String stmt_id = r.getString("STMT_ID");
                String stmtInfo = "stmt_id = " + stmt_id + " statement = " + r.getString("STMT_TEXT");
                ExecutionPlanUtils plan = new ExecutionPlanUtils(eConn, stmt_id, null, true);
                Vector<String> v = new Vector<String>();
                StringTokenizer stz = new StringTokenizer(new String(plan.getPlanAsText(null)), "\n");
                while (stz.hasMoreTokens()) {
                    v.addElement(stz.nextToken());
                }
                int l = v.size();
                log.info((Object)("Received query plan with " + l + " lines "));
                for (int i2 = 0; i2 < l; ++i2) {
                    log.info(v.elementAt(i2));
                }
                for (Element e : plan.getPlanAsXML()) {
                    log.info((Object)(e != null ? e.toString() : "null"));
                }
                log.info((Object)("Query plan...\n" + stmtInfo + "\n" + String.valueOf(plan.getPlanAsText(null)).trim()));
                StatementPlanDUnit.assertEquals((int)38, (int)l);
            }
            StatementPlanDUnit.assertEquals((int)parallelEx.length, (int)numQueryPlans);
            log.info((Object)("Total query plans: " + numQueryPlans));
        }
        catch (Throwable throwable) {
            StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable("clearing plan checker"){

                public void run() {
                    StatisticsCollectionObserver.setInstance(null);
                }
            });
            StatisticsCollectionObserver.setInstance(null);
            throw throwable;
        }
        StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
        StatisticsCollectionObserver.setInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecutionPlanGeneration() throws Exception {
        Properties p = new Properties();
        p.setProperty("log-level", this.getLogLevel());
        this.startServerVMs(4, 0, null, p);
        this.startClientVMs(1, 0, null, p);
        this.setNativeNanoTimer();
        Connection conn = TestUtil.getConnection(p);
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        ResultSet rs = conn.getMetaData().getTables(null, null, "course".toUpperCase(), new String[]{"TABLE"});
        boolean found = rs.next();
        rs.close();
        Statement st = conn.createStatement();
        if (found) {
            st.execute("drop table if exists course");
        }
        st.execute("create table course (course_id int, course_name varchar(2048),  primary key(course_id)) ");
        String sql = "insert into course values( ";
        StringBuilder ins = new StringBuilder(sql);
        Logger log = this.getLogWriter();
        int i = 0;
        while ((long)i < 100L) {
            ins.append(i).append(", '");
            ins.append(TestUtil.numstr(i)).append("' )");
            if ((i + 1) % 100 == 0) {
                st.execute(ins.toString());
                log.info((Object)(i + 1 + "th insert done .. "));
                ins = new StringBuilder(sql);
            } else {
                ins.append(", ( ");
            }
            ++i;
        }
        log.info((Object)"preparing for plan generation ");
        conn.createStatement().execute("call SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
        String q = "select * from course where course_name like '%' ";
        log.info((Object)"configuring plan checker ");
        StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable("setting plan checker"){

            public void run() {
                StatisticsCollectionObserver.setInstance((StatisticsCollectionObserver)StatementPlanDUnit.this.checker);
            }
        });
        StatementPlanDUnit.isLocalnode[0] = true;
        StatisticsCollectionObserver.setInstance((StatisticsCollectionObserver)this.checker);
        try {
            log.info((Object)"about to access plan ");
            ExecutionPlanUtils plan = new ExecutionPlanUtils(conn, q, null, true);
            Vector<String> v = new Vector<String>();
            StringTokenizer stz = new StringTokenizer(new String(plan.getPlanAsText(null)), "\n");
            while (stz.hasMoreTokens()) {
                v.addElement(stz.nextToken());
            }
            int l = v.size();
            log.info((Object)("Received query plan with " + l + " lines "));
            for (int i2 = 0; i2 < l; ++i2) {
                log.info(v.elementAt(i2));
            }
            for (Element e : plan.getPlanAsXML()) {
                log.info((Object)(e != null ? e.toString() : "null"));
            }
            StatementPlanDUnit.assertEquals((int)42, (int)l);
        }
        catch (Throwable throwable) {
            StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable("clearing plan checker"){

                public void run() {
                    StatisticsCollectionObserver.setInstance(null);
                }
            });
            StatisticsCollectionObserver.setInstance(null);
            throw throwable;
        }
        StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)new /* invalid duplicate definition of identical inner class */);
        StatisticsCollectionObserver.setInstance(null);
    }

    public void testExecutionPlanGenerationAcrossConnections() throws Exception {
        final Properties p = new Properties();
        p.setProperty("log-level", this.getLogLevel());
        this.startServerVMs(4, 0, null, p);
        this.startClientVMs(1, 0, null, p);
        this.setNativeNanoTimer();
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        Connection conn = TestUtil.getConnection(p);
        ResultSet rs = conn.getMetaData().getTables(null, null, "course".toUpperCase(), new String[]{"TABLE"});
        boolean found = rs.next();
        rs.close();
        Statement st = conn.createStatement();
        if (found) {
            st.execute("drop table if exists course ");
        }
        st.execute("create table course (course_id int, course_name varchar(2048),  primary key(course_id)) ");
        String sql = "insert into course values( ";
        StringBuilder ins = new StringBuilder(sql);
        Logger log = this.getLogWriter();
        long TotalRows = 100L;
        int i = 0;
        while ((long)i < 100L) {
            ins.append(i).append(", '");
            ins.append(TestUtil.numstr(i)).append("' )");
            if ((i + 1) % 100 == 0) {
                st.execute(ins.toString());
                log.info((Object)(i + 1 + "th insert done .. "));
                ins = new StringBuilder(sql);
            } else {
                ins.append(", ( ");
            }
            ++i;
        }
        log.info((Object)"preparing for plan generation");
        SerializableRunnable c = new SerializableRunnable("acquire connection"){

            public void run() {
                try {
                    st_conn = TestUtil.getConnection(p);
                    TestCase.assertTrue((st_conn != null ? 1 : 0) != 0);
                    st_conn.createStatement().execute("call syscs_util.set_explain_connection(1)");
                    TestCase.assertTrue((GemFireXDQueryObserverHolder.getInstance() != null ? 1 : 0) != 0);
                    st_conn.createStatement().execute("call SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
                    StatisticsCollectionObserver.setInstance((StatisticsCollectionObserver)StatementPlanDUnit.this.checker);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Exception is acquiring connection ", e);
                }
            }
        };
        StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)c);
        StatementPlanDUnit.isLocalnode[0] = true;
        c.run();
        log.info((Object)"Executing query ");
        SerializableRunnable r = new SerializableRunnable("execute query 1"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    TestCase.assertTrue((st_conn != null ? 1 : 0) != 0);
                    TestCase.assertTrue((boolean)((EmbedConnection)st_conn).getLanguageConnection().getRunTimeStatisticsMode());
                    TestCase.assertTrue((boolean)((EmbedConnection)st_conn).getLanguageConnection().explainConnection());
                    TestCase.assertTrue((GemFireXDQueryObserverHolder.getInstance() != null ? 1 : 0) != 0);
                    ResultSet rs = st_conn.createStatement().executeQuery("select course_name , course_id from course group by course_name, course_id order by course_id ");
                    while (rs.next()) {
                    }
                    rs.close();
                    StatementPlanDUnit.this.getLogWriter().info((Object)("query plan captured for " + ((EmbedResultSet)rs).getSourceResultSet().getExecutionPlanID().toString()));
                    return;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Exception is running queries ", e);
                }
                finally {
                    try {
                        if (!st_conn.isClosed()) {
                            st_conn.createStatement().execute("call syscs_util.set_explain_connection(0)");
                        }
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Exception is switching off explain connection ", e);
                    }
                    finally {
                        try {
                            st_conn.close();
                        }
                        catch (SQLException e) {
                            throw new RuntimeException("Connection close exception ", e);
                        }
                        st_conn = null;
                    }
                }
            }
        };
        StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)r);
        r.run();
        log.info((Object)"Extracting plan ");
        SerializableRunnable r2 = new SerializableRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Connection conn = TestUtil.getConnection(p);
                    ResultSet st_id = conn.createStatement().executeQuery("select STMT_ID, ORIGIN_MEMBER_ID from sys.statementplans ");
                    while (st_id.next()) {
                        StatementPlanDUnit.this.getLogWriter().info((Object)("Finding query plan for " + st_id.getString(1) + " originated in " + st_id.getString(2)));
                        ExecutionPlanUtils plan = new ExecutionPlanUtils(conn, st_id.getString(1), null, true);
                        Vector<String> v = new Vector<String>();
                        StringTokenizer stz = new StringTokenizer(new String(plan.getPlanAsText(null)), "\n");
                        while (stz.hasMoreTokens()) {
                            v.addElement(stz.nextToken());
                        }
                        int l = v.size();
                        StatementPlanDUnit.this.getLogWriter().info((Object)("Received query plan with " + l + " lines "));
                        for (int i = 0; i < l; ++i) {
                            StatementPlanDUnit.this.getLogWriter().info(v.elementAt(i));
                        }
                        for (Element e : plan.getPlanAsXML()) {
                            StatementPlanDUnit.this.getLogWriter().info((Object)(e != null ? e.toString() : "null"));
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    StatisticsCollectionObserver.setInstance(null);
                    StatementPlanDUnit.this.allExecutionsDone = true;
                }
            }
        };
        StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)r2);
        r2.run();
        log.info((Object)"Checking all activity completion ");
        SerializableRunnable checkFinish = new SerializableRunnable(){

            public void run() {
                while (!StatementPlanDUnit.this.allExecutionsDone) {
                    StatementPlanDUnit.this.getLogWriter().info((Object)"Waiting for this VM to finish its work ... ");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)checkFinish);
        checkFinish.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug43228() throws Exception {
        this.startVMs(1, 3);
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        Properties cp = new Properties();
        cp.setProperty("log-level", this.getLogLevel());
        this.setNativeNanoTimer();
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        if (GemFireXDUtils.hasTable((Connection)conn, (String)"test_globalindex_plan_check")) {
            st.execute("drop table test_globalindex_plan_check");
        }
        st.execute("create table test_globalindex_plan_check (col1 int primary key, col2 varchar(100), col3 int ) partition by column (col2) ");
        st.execute("insert into test_globalindex_plan_check values (1, 'one',  0), (2 , 'two',  0), (3, 'three',  0) ");
        st.execute("insert into test_globalindex_plan_check values (11, 'one', 0), (12 , 'two', 0), (13, 'three', 0) ");
        st.execute("insert into test_globalindex_plan_check values (21, 'one', 0), (22 , 'two', 0), (23, 'three', 0) ");
        st.execute("insert into test_globalindex_plan_check values (31, 'one', 0), (32 , 'two', 0), (33, 'three', 0) ");
        String query = "update test_globalindex_plan_check set col3 = 1 where col1 in (11, 21, 31) ";
        ExecutionPlanUtils planner = new ExecutionPlanUtils(conn, query, null, true);
        String p = new String(planner.getPlanAsText(null));
        this.getLogWriter().info((Object)("plan = " + p));
    }

    public void testBug43219_VTITablesRouting() throws Exception {
        this.startVMs(1, 3);
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        this.setNativeNanoTimer();
        Properties cp = new Properties();
        cp.setProperty("log-level", this.getLogLevel());
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        if (GemFireXDUtils.hasTable((Connection)conn, (String)"countries")) {
            st.execute("drop table countries");
        }
        st.execute("CREATE TABLE COUNTRIES ( COUNTRY VARCHAR(26) NOT NULL, COUNTRY_ISO_CODE CHAR(2) NOT NULL , REGION VARCHAR(26) ) REPLICATE");
        String query = "select t.tablename, t.datapolicy, m.hostdata, m.id from sys.systables t , sys.members m  where t.tablename = 'COUNTRIES'";
        ExecutionPlanUtils planner = new ExecutionPlanUtils(conn, query, null, true);
        this.getLogWriter().info((Object)("received plan : " + new String(planner.getPlanAsText(null))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSecondaryBucketsVTIQuery() throws Exception {
        this.startVMs(1, 2);
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        this.setNativeNanoTimer();
        Properties cp = new Properties();
        cp.setProperty("log-level", this.getLogLevel());
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        st.execute("create table course (course_id int, i int,  primary key(course_id)) partition by column (i) redundancy 1");
        st.execute("insert into course values (1, 1), (2, 2), (3, 1), (4, 3), (5, 1)");
        ResultSet r = st.executeQuery("select dsid() , count(i) from course, sys.members m --gemfirexd-properties withSecondaries = true \n group by dsid()");
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)r.getInt(2));
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)r.getInt(2));
        StatementPlanDUnit.assertFalse((boolean)r.next());
        r = st.executeQuery("select dsid(), count(*) from course, sys.members m --gemfirexd-properties withSecondaries = true \n group by dsid()");
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)r.getInt(2));
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)r.getInt(2));
        StatementPlanDUnit.assertFalse((boolean)r.next());
        r = st.executeQuery("select count(*), dsid() from course, sys.members m --gemfirexd-properties withSecondaries = true \n group by dsid()");
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)r.getInt(1));
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)r.getInt(1));
        StatementPlanDUnit.assertFalse((boolean)r.next());
        r = st.executeQuery("select dsid(), count(i) from course");
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)r.getInt(2));
        StatementPlanDUnit.assertFalse((boolean)r.next());
        r = st.executeQuery("select dsid(), count(*) from course");
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)r.getInt(2));
        StatementPlanDUnit.assertFalse((boolean)r.next());
        r = st.executeQuery("select count(*), dsid() from course");
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)r.getInt(1));
        StatementPlanDUnit.assertFalse((boolean)r.next());
        r = st.executeQuery("select dsid() , count(i) from course, sys.members m --gemfirexd-properties withSecondaries = false \n group by dsid()");
        int totalrows = 0;
        StatementPlanDUnit.assertTrue((boolean)r.next());
        totalrows += r.getInt(2);
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertFalse((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)(totalrows += r.getInt(2)));
        r = st.executeQuery("select count(i), dsid() from course, sys.members m --gemfirexd-properties withSecondaries = false \n group by dsid()");
        totalrows = 0;
        StatementPlanDUnit.assertTrue((boolean)r.next());
        totalrows += r.getInt(1);
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertFalse((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)(totalrows += r.getInt(1)));
        r = st.executeQuery("select count(*), dsid() from course, sys.members m --gemfirexd-properties withSecondaries = false \n group by dsid()");
        totalrows = 0;
        StatementPlanDUnit.assertTrue((boolean)r.next());
        totalrows += r.getInt(1);
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertFalse((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)(totalrows += r.getInt(1)));
        r = st.executeQuery("select count(*) from course, sys.members m --gemfirexd-properties withSecondaries = false \n group by dsid()");
        totalrows = 0;
        StatementPlanDUnit.assertTrue((boolean)r.next());
        totalrows += r.getInt(1);
        StatementPlanDUnit.assertTrue((boolean)r.next());
        StatementPlanDUnit.assertFalse((boolean)r.next());
        StatementPlanDUnit.assertEquals((int)5, (int)(totalrows += r.getInt(1)));
    }

    public void testPerConnectionPlanGeneration() throws Exception {
        this.startVMs(1, 2);
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        this.setNativeNanoTimer();
        Properties cp = new Properties();
        cp.setProperty("log-level", this.getLogLevel());
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        st.execute("create table course (course_id int, i int,  primary key(course_id)) partition by column (i)");
        st.execute("insert into course values (1, 1), (2, 2), (3, 1), (4, 3), (5, 1)");
        conn.createStatement().execute("call SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
        st.execute("call syscs_util.set_explain_connection(1)");
        ResultSet rs = conn.createStatement().executeQuery("select * from course where course_id > 1");
        int row = 0;
        while (rs.next()) {
            this.getLogWriter().info((Object)("row = " + ++row));
        }
        rs.close();
        ResultSet qp = conn.createStatement().executeQuery("select stmt_id, stmt_text from sys.statementplans");
        StatementPlanDUnit.assertTrue((boolean)qp.next());
        String uuid = qp.getString(1);
        this.getLogWriter().info((Object)("Extracting plan for " + uuid));
        ExecutionPlanUtils plan = new ExecutionPlanUtils(conn, uuid, null, true);
        this.getLogWriter().info((Object)("plan : " + new String(plan.getPlanAsText(null))));
        StatementPlanDUnit.assertEquals((String)"Three nodes should respond with its own query plans ", (int)3, (int)plan.getPlanAsXML().size());
        StatementPlanDUnit.assertFalse((boolean)qp.next());
    }

    public void test43863() throws Exception {
        this.startVMs(0, 3);
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        this.setNativeNanoTimer();
        Properties cp = new Properties();
        cp.setProperty("log-level", this.getLogLevel());
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        st.execute("create table course (course_id int, i int,  primary key(course_id)) partition by column (i) redundancy 1");
        st.execute("insert into course values (1, 1), (2, 2), (3, 1), (4, 3), (5, 1)");
        conn.createStatement().execute("call SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
        st.execute("call syscs_util.set_explain_connection(1)");
        StatisticsCollectionObserver checker = new StatisticsCollectionObserver(){

            public void processedDistPropsDescriptor(XPLAINDistPropsDescriptor distP) {
                for (XPLAINDistPropsDescriptor msg : distP.memberSentMappedDesc) {
                    TestCase.assertTrue((msg.getTargetMember() != null ? 1 : 0) != 0);
                    if (!msg.locallyExecuted) continue;
                    TestCase.assertTrue((boolean)msg.getTargetMember().equals(msg.getOriginator()));
                }
            }
        };
        StatisticsCollectionObserver.setInstance((StatisticsCollectionObserver)checker);
        ResultSet rs = conn.createStatement().executeQuery("select sum(i) from course where course_id > 1");
        boolean row = false;
        while (rs.next()) {
            this.getLogWriter().info((Object)("row = " + rs.getString(1)));
            StatementPlanDUnit.assertEquals((int)7, (int)rs.getInt(1));
        }
        rs.close();
        ResultSet qp = conn.createStatement().executeQuery("select stmt_id, stmt_text from sys.statementplans");
        StatementPlanDUnit.assertTrue((boolean)qp.next());
        String uuid = qp.getString(1);
        this.getLogWriter().info((Object)("Extracting plan for " + uuid));
        ExecutionPlanUtils plan = new ExecutionPlanUtils(conn, uuid, null, true);
        String queryPlan = new String(plan.getPlanAsText(null));
        this.getLogWriter().info((Object)("plan : " + queryPlan));
        StatementPlanDUnit.assertTrue((boolean)queryPlan.startsWith("stmt_id"));
        int firstProjection = queryPlan.indexOf("PROJECTION");
        StatementPlanDUnit.assertTrue((firstProjection > 0 ? 1 : 0) != 0);
        StatementPlanDUnit.assertTrue((queryPlan.indexOf("AGGREGATION", firstProjection) > 0 ? 1 : 0) != 0);
        int secondProjection = queryPlan.indexOf("PROJECTION", firstProjection + 1);
        StatementPlanDUnit.assertTrue((secondProjection > 0 ? 1 : 0) != 0);
        StatementPlanDUnit.assertTrue((queryPlan.indexOf("TABLESCAN", secondProjection + 1) > 0 ? 1 : 0) != 0);
        StatementPlanDUnit.assertFalse((boolean)qp.next());
    }

    public void tmp_SB_testExplainKeyword() throws Exception {
        this.startVMs(0, 3);
        this.startVMs(1, 0);
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        Properties cp = new Properties();
        cp.setProperty("log-level", this.getLogLevel());
        Connection conn = TestUtil.getConnection(cp);
        String currentPlanLine = null;
        Statement st = conn.createStatement();
        st.execute("create table course (course_id int, i int,  primary key(course_id)) partition by primary key");
        st.execute("insert into course values (1, 1), (2, 2), (3, 1), (4, 3), (5, 1)");
        ResultSet rs = conn.createStatement().executeQuery("explain select * from course c join course d on c.course_id = d.course_id where c.course_id > 1 or d.course_id <= 1 order by c.i desc");
        StatementPlanDUnit.assertTrue((boolean)rs.next());
        String queryPlan = rs.getString(1);
        this.getLogWriter().info((Object)queryPlan);
        currentPlanLine = null;
        currentPlanLine = StatementPlanDUnit.statement(queryPlan);
        currentPlanLine = StatementPlanDUnit.distribution(currentPlanLine, 3);
        currentPlanLine = StatementPlanDUnit.roundrobin(currentPlanLine, 5);
        currentPlanLine = StatementPlanDUnit.ordered(currentPlanLine, 5);
        StatementPlanDUnit.assertTrue((boolean)rs.next());
        this.getLogWriter().info((Object)rs.getString(1));
        this.checkSlowestPlan(rs.getString(1));
        StatementPlanDUnit.assertTrue((boolean)rs.next());
        this.getLogWriter().info((Object)rs.getString(1));
        StatementPlanDUnit.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void tmp_SB_test47380() throws Exception {
        this.startVMs(1, 3);
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        Properties cp = new Properties();
        cp.setProperty("log-level", this.getLogLevel());
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.t1 ( id int primary key, name varchar(10), type int) partition by primary key");
        st.execute("Insert into  trade.t1 values(1,'a',21)");
        st.execute("Insert into  trade.t1 values(2,'b',22)");
        st.execute("Insert into  trade.t1 values(3,'c',23)");
        ResultSet rs = conn.createStatement().executeQuery("explain select id, type from trade.t1 A where id in (2,1)");
        StatementPlanDUnit.assertTrue((boolean)rs.next());
        this.getLogWriter().info((Object)rs.getString(1));
        String currentPlanLine = StatementPlanDUnit.originator(rs.getString(1));
        currentPlanLine = StatementPlanDUnit.regiongetall(currentPlanLine, 2);
        StatementPlanDUnit.assertFalse((boolean)rs.next());
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tmp_SB_testSimpleStats() throws Exception {
        Properties p = new Properties();
        int netPort = this.startNetworkServer(1, null, p);
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        boolean secondServerStarted = false;
        try {
            Statement s = conn.createStatement();
            s.execute("Create Table TEST_TABLE(idx numeric(12),AccountID varchar(10),OrderNo varchar(20),primary key(idx))PARTITION BY COLUMN ( AccountID )");
            s.execute("CREATE INDEX idx_AccountID ON test_Table (AccountID ASC)");
            PreparedStatement insps = conn.prepareStatement("insert into test_table values(?,?,?)");
            int base = 1;
            for (int i = 0; i < 1000; ++i) {
                insps.setInt(1, base + i);
                insps.setString(2, String.valueOf(i % 9));
                insps.setString(3, String.valueOf(i));
                insps.executeUpdate();
            }
            ResultSet r = conn.createStatement().executeQuery("explain select * from test_table where accountid > '7' order by idx desc ");
            StatementPlanDUnit.assertTrue((boolean)r.next());
            Clob c = r.getClob(1);
            BufferedReader reader = new BufferedReader(c.getCharacterStream());
            int sz = (int)c.length();
            char[] charArray = new char[sz];
            reader.read(charArray, 0, sz);
            String pl = new String(charArray);
            this.getLogWriter().info((Object)("Plan: " + pl));
            String currentPlanLine = null;
            currentPlanLine = StatementPlanDUnit.originator(pl);
            currentPlanLine = StatementPlanDUnit.distribution(currentPlanLine, 1);
            currentPlanLine = StatementPlanDUnit.sequential(currentPlanLine, 111);
            currentPlanLine = StatementPlanDUnit.localPlan(currentPlanLine);
            currentPlanLine = StatementPlanDUnit.planMember(currentPlanLine);
            currentPlanLine = StatementPlanDUnit.sort(currentPlanLine, "111", 1);
            currentPlanLine = StatementPlanDUnit.rowidscan(currentPlanLine, "111", "1");
            currentPlanLine = StatementPlanDUnit.indexscan(currentPlanLine, 111, 1, "None", "IDX_ACCOUNTID");
            r.close();
            this.startNetworkServer(2, null, p);
            secondServerStarted = true;
            conn.createStatement().execute("call sys.REBALANCE_ALL_BUCKETS()");
            r = conn.createStatement().executeQuery("explain select * from test_table where accountid like '8' order by idx desc ");
            StatementPlanDUnit.assertTrue((boolean)r.next());
            c = r.getClob(1);
            reader = new BufferedReader(c.getCharacterStream());
            sz = (int)c.length();
            charArray = new char[sz];
            reader.read(charArray, 0, sz);
            pl = new String(charArray);
            this.getLogWriter().info((Object)("Plan: " + pl));
            currentPlanLine = null;
            currentPlanLine = StatementPlanDUnit.originator(pl);
            currentPlanLine = StatementPlanDUnit.distribution(currentPlanLine, 1);
            currentPlanLine = StatementPlanDUnit.sequential(currentPlanLine, 111);
            currentPlanLine = StatementPlanDUnit.localPlan(currentPlanLine);
            currentPlanLine = StatementPlanDUnit.planMember(currentPlanLine);
            currentPlanLine = StatementPlanDUnit.sort(currentPlanLine, "111", 1);
            currentPlanLine = this.filter2(currentPlanLine, "111", "1", "SELECT :IDX ACCOUNTID ORDERNO WHERE :ACCOUNTID LIKE CONSTANT:8");
            currentPlanLine = StatementPlanDUnit.rowidscan(currentPlanLine, "111", "1");
            currentPlanLine = StatementPlanDUnit.indexscan(currentPlanLine, 111, 1, "None", "IDX_ACCOUNTID");
            r.close();
            s.execute("Create Table TEST_TABLE_1(idx numeric(12),AccountID varchar(10),OrderNo varchar(20),primary key(idx))REPLICATE ");
            insps = conn.prepareStatement("insert into test_table_1 values(?,?,?)");
            base = 1;
            for (int i = 0; i < 1000; ++i) {
                insps.setInt(1, base + i);
                insps.setString(2, String.valueOf(i % 9));
                insps.setString(3, String.valueOf(i));
                insps.executeUpdate();
            }
            r = conn.createStatement().executeQuery("explain select * from test_table_1 ");
            StatementPlanDUnit.assertTrue((boolean)r.next());
            c = r.getClob(1);
            reader = new BufferedReader(c.getCharacterStream());
            sz = (int)c.length();
            charArray = new char[sz];
            reader.read(charArray, 0, sz);
            pl = new String(charArray);
            this.getLogWriter().info((Object)("Result:\n " + pl));
            currentPlanLine = null;
            currentPlanLine = StatementPlanDUnit.localPlan(pl);
            currentPlanLine = StatementPlanDUnit.planMember(currentPlanLine);
            currentPlanLine = StatementPlanDUnit.tablescan(currentPlanLine, "1000", 1, "None", "APP.TEST_TABLE_1", "HEAP", 1);
            StatementPlanDUnit.assertNull((Object)currentPlanLine);
            r.close();
        }
        finally {
            if (secondServerStarted) {
                this.stopNetworkServer(2);
            }
            this.stopNetworkServer(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tmp_SB_test44550() throws Exception {
        Properties p = new Properties();
        Connection systemconn = TestUtil.getConnection();
        try {
            CallableStatement cusr = systemconn.prepareCall("call SYSCS_UTIL.SET_DATABASE_PROPERTY(?,?)");
            cusr.setString(1, "gemfirexd.enable-getall-local-index-embed-gfe");
            cusr.setString(2, "true");
            cusr.execute();
            cusr.close();
            int netPort = this.startNetworkServer(1, null, p);
            this.startNetworkServer(2, null, p);
            this.checkLoadLib(StatementPlanDUnit.getTestName());
            Connection conn = TestUtil.getNetConnection(netPort, null, null);
            Statement s = conn.createStatement();
            s.execute("Create Table TEST_TABLE(idx numeric(12),AccountID varchar(10),OrderNo varchar(20),primary key(idx))PARTITION BY COLUMN ( AccountID )");
            s.execute("CREATE INDEX idx_AccountID ON test_Table (AccountID ASC)");
            PreparedStatement insps = conn.prepareStatement("insert into test_table values(?,?,?)");
            int base = 1;
            for (int i = 0; i < 1000; ++i) {
                insps.setInt(1, base + i);
                insps.setString(2, String.valueOf(i % 9));
                insps.setString(3, String.valueOf(i));
                insps.executeUpdate();
            }
            ResultSet r = conn.createStatement().executeQuery("explain select * from test_table where accountid = '8' order by idx desc ");
            StatementPlanDUnit.assertTrue((boolean)r.next());
            Clob c = r.getClob(1);
            BufferedReader reader = new BufferedReader(c.getCharacterStream());
            int sz = (int)c.length();
            char[] charArray = new char[sz];
            reader.read(charArray, 0, sz);
            String pl = new String(charArray);
            this.getLogWriter().info((Object)("Plan: " + pl));
            String currentPlanLine = null;
            currentPlanLine = StatementPlanDUnit.localPlan(pl);
            currentPlanLine = StatementPlanDUnit.planMember(currentPlanLine);
            currentPlanLine = StatementPlanDUnit.sort(currentPlanLine, "111", 1);
            currentPlanLine = StatementPlanDUnit.localindexgetall(currentPlanLine, "111", 1);
            r.close();
        }
        finally {
            if (systemconn != null) {
                systemconn.close();
            }
            this.stopNetworkServer(2);
            this.stopNetworkServer(1);
        }
    }

    public void tmp_SB_test47798() throws Exception {
        this.startVMs(1, 3);
        this.checkLoadLib(StatementPlanDUnit.getTestName());
        Properties cp = new Properties();
        cp.setProperty("log-level", this.getLogLevel());
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid)) partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) replicate");
        st.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty)) replicate");
        st.execute("insert into trade.customers values(1, 'vivek', null, 'pune', 1)");
        st.execute("insert into trade.securities values(9, 'vb', null, 'lse', 1)");
        st.execute("insert into trade.portfolio values(1, 1, 10, 1, null, 1)");
        st.execute("call SYSCS_UTIL.SET_EXPLAIN_CONNECTION(1)");
        st.execute("call SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
        String query = "Select sec_id, symbol, s.tid, cid, cust_name, c.tid from trade.securities s, trade.customers c where c.cid = (select f.cid from trade.portfolio f where c.cid = f.cid and f.tid = 1 group by f.cid having count(*) < 5) and sec_id in (select sid from trade.portfolio f where availQty > 0 and availQty < 927)";
        ResultSet rs = conn.createStatement().executeQuery("explain " + query);
        StatementPlanDUnit.assertTrue((boolean)rs.next());
        this.getLogWriter().info((Object)rs.getString(1));
        String currentPlanLine = StatementPlanDUnit.originator(rs.getString(1));
        currentPlanLine = StatementPlanDUnit.distribution(currentPlanLine, 1);
        currentPlanLine = StatementPlanDUnit.sequential(currentPlanLine, 0);
        StatementPlanDUnit.assertTrue((boolean)rs.next());
        this.getLogWriter().info((Object)rs.getString(1));
        StatementPlanDUnit.assertTrue((boolean)rs.next());
        this.getLogWriter().info((Object)rs.getString(1));
        StatementPlanDUnit.assertFalse((boolean)rs.next());
        rs.close();
    }

    public static final String statement(String input) {
        Pattern planMatcher = Pattern.compile("stmt_id\\s+[0-9[a-f]]{8}-[a-f]{4}-[a-f]{4}-[a-f]{4}-[0-9[a-f]]{12}", 8);
        Object[] stmnt_id = planMatcher.split(input);
        TestUtil.getLogger().info((Object)Arrays.toString(stmnt_id));
        StatementPlanDUnit.assertEquals((int)2, (int)stmnt_id.length);
        planMatcher = Pattern.compile("SQL_stmt.*", 8);
        stmnt_id = planMatcher.split((CharSequence)stmnt_id[1]);
        TestUtil.getLogger().info((Object)Arrays.toString(stmnt_id));
        StatementPlanDUnit.assertEquals((int)2, (int)stmnt_id.length);
        planMatcher = Pattern.compile("begin_execution\\s+[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}(\\.\\d+)?\\s+end_execution\\s+[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}(\\.\\d+)?\\s+\\(\\d+ .*seconds elapsed\\)");
        stmnt_id = planMatcher.split((CharSequence)stmnt_id[1]);
        TestUtil.getLogger().info((Object)Arrays.toString(stmnt_id));
        StatementPlanDUnit.assertEquals((int)2, (int)stmnt_id.length);
        return stmnt_id[1];
    }

    public static final String originator(String input) {
        StringBuilder patternString = new StringBuilder();
        patternString.append("ORIGINATOR ").append(memberIdPattern).append(" BEGIN\\sTIME\\s").append(timeStampPattern).append(".*END\\sTIME\\s").append(timeStampPattern);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] originatorDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(originatorDone));
        StatementPlanDUnit.assertEquals((int)2, (int)originatorDone.length);
        return originatorDone[1];
    }

    public static final String distribution(String input, int numMembers) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*DISTRIBUTION to\\s*" + numMembers + "\\s*members took [0-9]([0-9]*)? microseconds\\s*\\( " + "message sending min/max/avg time [0-9]([0-9]*)?/[0-9]([0-9]*)?/[0-9]([0-9]*)? microseconds and " + "receiving min/max/avg time [0-9]([0-9]*)?/[0-9]([0-9]*)?/[0-9]([0-9]*)? microseconds \\)");
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] distributionDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(distributionDone));
        StatementPlanDUnit.assertEquals((int)2, (int)distributionDone.length);
        return distributionDone[1];
    }

    public static final String sequential(String input, int numRows) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*SEQUENTIAL-ITERATION of\\s*" + numRows + "\\s*rows took [0-9]([0-9]*)? microseconds");
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] sequentialDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(sequentialDone));
        StatementPlanDUnit.assertEquals((int)2, (int)sequentialDone.length);
        return sequentialDone[1];
    }

    public static final String roundrobin(String input, int numRows) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*ROUNDROBIN-ITERATION of\\s*" + numRows + "\\s*rows took [0-9]([0-9]*)? microseconds");
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] roundRobinDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(roundRobinDone));
        StatementPlanDUnit.assertEquals((int)2, (int)roundRobinDone.length);
        return roundRobinDone[1];
    }

    public static final String ordered(String input, int numRows) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("ORDERED-ITERATION of\\s*" + numRows + "\\s*rows with\\s*" + numRows + "\\s*input rows took [0-9]([0-9]*)? microseconds");
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] orderedDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(orderedDone));
        StatementPlanDUnit.assertEquals((int)2, (int)orderedDone.length);
        return orderedDone[1];
    }

    public static final String regiongetall(String input, int numRows) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*REGION-GETALL of\\s*" + numRows + "\\s*rows took [0-9]([0-9]*)? ");
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] getallDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)("regiongetall:" + Arrays.toString(getallDone)));
        StatementPlanDUnit.assertEquals((String)"microseconds", (String)((String)getallDone[1]).trim());
        return getallDone[1];
    }

    public static final String localindexgetall(String input, String rows, int numOpens) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("LOCAL-INDEX-GETALL ").append(optionalPercentage).append(" execute_time\\s*").append(executeMillis).append("\\s*returned_rows\\s*" + rows + "\\s*no_opens\\s*" + numOpens);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] getallDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)("localindexgetall:" + Arrays.toString(getallDone)));
        StatementPlanDUnit.assertEquals((int)2, (int)getallDone.length);
        return getallDone[1];
    }

    public static final String slowestMemberPlan(String input) {
        Pattern planMatcher = Pattern.compile("Slowest Member Plan:", 8);
        Object[] introLineDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(introLineDone));
        StatementPlanDUnit.assertEquals((int)2, (int)introLineDone.length);
        return introLineDone[1];
    }

    public static final String fastestMemberPlan(String input) {
        Pattern planMatcher = Pattern.compile("Fastest Member Plan:", 8);
        Object[] introLineDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(introLineDone));
        StatementPlanDUnit.assertEquals((int)2, (int)introLineDone.length);
        return introLineDone[1];
    }

    public static final String localPlan(String input) {
        StringBuilder patternString = new StringBuilder();
        patternString.append("Local plan:");
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] localPlanDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(localPlanDone));
        StatementPlanDUnit.assertEquals((int)2, (int)localPlanDone.length);
        return localPlanDone[1];
    }

    public static final String planMember(String input) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*member\\s*").append(memberIdPattern).append("\\s*begin_execution\\s*").append(timeStampPattern).append("\\s*end_execution\\s*").append(timeStampPattern);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] planMemberDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(planMemberDone));
        StatementPlanDUnit.assertEquals((int)2, (int)planMemberDone.length);
        return planMemberDone[1];
    }

    public static final String queryReceiveResultSend(String input) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*QUERY-RECEIVE\\s*execute_time\\s*").append(executeMillis).append("\\s*member_node\\s*").append(memberIdPattern).append("\\s*RESULT-SEND\\s*execute_time\\s*").append(executeMillis).append(" member_node ").append(memberIdPattern);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] queryRecRespSendDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(queryRecRespSendDone));
        assert (queryRecRespSendDone.length == 2);
        return queryRecRespSendDone[1];
    }

    public static final String queryReceive(String input) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*QUERY-RECEIVE\\s*execute_time\\s*").append(executeMillis).append("\\s*member_node\\s*").append(memberIdPattern);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] queryReceiveDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(queryReceiveDone));
        assert (queryReceiveDone.length == 2);
        return queryReceiveDone[1];
    }

    public static final String querySend(String input) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*QUERY-SEND\\s*execute_time\\s*").append(executeMillis).append("\\s*member_node\\s*").append(memberIdPattern);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] querySendDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(querySendDone));
        assert (querySendDone.length == 2);
        return querySendDone[1];
    }

    public static final String resultSend(String input) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*RESULT-SEND\\s*execute_time ").append(executeMillis).append("\\s*member_node\\s*").append(memberIdPattern);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] resultSendDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(resultSendDone));
        StatementPlanDUnit.assertEquals((int)2, (int)resultSendDone.length);
        return resultSendDone[1];
    }

    public static final String resultHolder(String input, String rows, int numOpens) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*RESULT-HOLDER\\s*execute_time ").append(executeMillis).append(" returned_rows\\s*" + rows + "\\s*no_opens\\s*" + numOpens);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] resultHolderDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(resultHolderDone));
        StatementPlanDUnit.assertEquals((int)2, (int)resultHolderDone.length);
        return resultHolderDone[1];
    }

    public static final String resultHolder2(String input, String rows, int numOpens) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("\\s*RESULT-HOLDER\\s*execute_time ").append(executeMillis).append(" returned_rows\\s*" + rows + "\\s*no_opens\\s*" + numOpens);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] resultHolderDone = planMatcher.split(input, 2);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(resultHolderDone));
        StatementPlanDUnit.assertEquals((int)2, (int)resultHolderDone.length);
        return resultHolderDone[1];
    }

    public static final String sort(String input, String rows, int numOpens) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("SORT ").append(optionalPercentage).append(" execute_time\\s*").append(executeMillis).append("\\s*input_rows " + rows + "\\s*returned_rows\\s*" + rows + "\\s*no_opens\\s*" + numOpens + " sort_type IN sorter_output\\s*" + rows);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] sortDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(sortDone));
        StatementPlanDUnit.assertEquals((int)2, (int)sortDone.length);
        return sortDone[1];
    }

    public static final String rowidscan(String input, String rows, String numOpens) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("ROWIDSCAN ").append(optionalPercentage).append(" execute_time\\s*").append(executeMillis).append("\\s*returned_rows\\s*" + rows + "\\s*no_opens\\s*" + numOpens);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] rowIDScanDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(rowIDScanDone));
        StatementPlanDUnit.assertEquals((int)2, (int)rowIDScanDone.length);
        return rowIDScanDone[1];
    }

    public static final String tablescan(String input, String rows, int numOpens, String scanQualifier, String scannedObject, String scanType, int expected) {
        Pattern planMatcher = Pattern.compile("\\s+(\\|\\s*)*(\\(\\d\\))?TABLESCAN\\s+(\\(.*?\\))?\\s+execute_time\\s+\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+(\\(construct=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+open=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+next=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+close=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\)|\\(serialize/deserialize=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+process=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\s+\\+\\s+throttle=\\d+(\\.\\d+)?(E.\\d*)?\\s*ms\\))?\\s*returned_rows\\s*" + rows + "\\s*no_opens\\s*" + numOpens + "\\s*visited_rows\\s*" + rows + "\\s*scan_qualifiers\\s*" + ".*" + scanQualifier + ".*" + "\\s*scanned_object\\s*" + ".*" + scannedObject + ".*" + "\\s*scan_type\\s*" + scanType + "\\s*");
        Object[] tableScanDone = planMatcher.split(input);
        TestUtil.getLogger().info((Object)Arrays.toString(tableScanDone));
        StatementPlanDUnit.assertEquals((int)expected, (int)tableScanDone.length);
        if (expected == 0) {
            return null;
        }
        return tableScanDone[1];
    }

    private String filter(String input, String rows, String numOpens) {
        StringBuilder patternString = new StringBuilder();
        patternString.append("FILTER ").append(optionalPercentage).append(" execute_time\\s*").append(executeMillis).append(" returned_rows " + rows + " no_opens " + numOpens);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] filterDone = planMatcher.split(input);
        this.getLogWriter().info((Object)Arrays.toString(filterDone));
        StatementPlanDUnit.assertEquals((int)2, (int)filterDone.length);
        return filterDone[1];
    }

    private String filter2(String input, String rows, String numOpens, String nodeDetails) {
        StringBuilder patternString = new StringBuilder();
        patternString.append("FILTER ").append(optionalPercentage).append(" execute_time\\s*").append(executeMillis).append(" returned_rows " + rows + " no_opens " + numOpens).append(" node_details ").append(nodeDetails);
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] filterDone = planMatcher.split(input);
        this.getLogWriter().info((Object)Arrays.toString(filterDone));
        StatementPlanDUnit.assertEquals((int)2, (int)filterDone.length);
        return filterDone[1];
    }

    public static final String indexscan(String input, int rows, int numOpens, String scanQualifier, String scannedObject) {
        StringBuilder patternString = new StringBuilder();
        patternString = new StringBuilder();
        patternString.append("INDEXSCAN ").append(optionalPercentage).append(" execute_time\\s*").append(executeMillis).append(" returned_rows\\s*" + rows + "\\s*no_opens\\s*" + numOpens + "\\s*scan_qualifiers\\s*" + scanQualifier + "\\s*scanned_object\\s*" + scannedObject + "\\s*scan_type");
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] indexScanDone = planMatcher.split(input);
        StatementPlanDUnit.getGlobalLogger().info((Object)Arrays.toString(indexScanDone));
        StatementPlanDUnit.assertEquals((int)2, (int)indexScanDone.length);
        return indexScanDone[1];
    }

    private void checkSlowestPlan(String planOutput) {
        StringBuilder patternString = new StringBuilder();
        String slowestMemberDone = StatementPlanDUnit.slowestMemberPlan(planOutput);
        String planMemberDone = StatementPlanDUnit.planMember(slowestMemberDone);
        String queryRecRespSendDone = StatementPlanDUnit.queryReceiveResultSend(planMemberDone);
        String resultHolderDone = StatementPlanDUnit.resultHolder(queryRecRespSendDone, "[1-2]", 1);
        String sortDone = StatementPlanDUnit.sort(resultHolderDone, "[1-2]", 1);
        patternString = new StringBuilder();
        patternString.append("NLJOIN ").append(optionalPercentage).append(" execute_time\\s*").append(executeMillis).append(" returned_rows [1-2] no_opens 1");
        Pattern planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] nlJoinDone = planMatcher.split(sortDone);
        this.getLogWriter().info((Object)Arrays.toString(nlJoinDone));
        assert (nlJoinDone.length == 2);
        String tableScanDone = StatementPlanDUnit.tablescan((String)nlJoinDone[1], "[1-2]", 1, "None", "COURSE", "HEAP", 2);
        String filterDone = this.filter(tableScanDone, "[1-2]", "[1-2]");
        String rowIDScanDone = StatementPlanDUnit.rowidscan(filterDone, "[1-2]", "[1-2]");
        patternString = new StringBuilder();
        patternString.append("CONSTRAINTSCAN\\s*").append(optionalPercentage).append("\\s*execute_time\\s*").append(executeMillis).append(" returned_rows [1-2] no_opens [1-2]\\s*scan_qualifiers None scanned_object SQL[0-9]([0-9]*)?\\s*scan_type\\s*");
        planMatcher = Pattern.compile(patternString.toString(), 8);
        Object[] constraintScanDone = planMatcher.split(rowIDScanDone);
        this.getLogWriter().info((Object)Arrays.toString(constraintScanDone));
        assert (constraintScanDone.length == 1) : constraintScanDone.length;
    }

    private void checkLoadLib(String testName) {
        StatementPlanDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable("verifying for " + testName){

            public void run() {
                GemFireStore store = Misc.getMemStoreBootingNoThrow();
                Logger log = StatementPlanDUnit.this.getLogWriter();
                if (store == null) {
                    log.info((Object)"SB: server not booted");
                    return;
                }
                if (!store.getMyVMKind().isAccessorOrStore()) {
                    log.info((Object)"SB: not a server or accessor.");
                    return;
                }
                TestUtil.assertTimerLibraryLoaded();
            }
        });
    }

    static class PlanStatisticsCollectionObserver
    extends StatisticsCollectionObserver {
        private transient boolean isRootEntryFound = false;
        private transient TreeNode cn;
        static transient ThreadLocal<PlanArtifacts> plans = new ThreadLocal();

        PlanStatisticsCollectionObserver() {
        }

        public void reset() {
            plans.get().reset();
        }

        public <T extends Serializable> void processSelectMessage(XPLAINStatementDescriptor stmt, ArrayList<XPLAINResultSetDescriptor> rsets, List<XPLAINResultSetTimingsDescriptor> rsetsTimings, List<XPLAINScanPropsDescriptor> scanProps, List<XPLAINSortPropsDescriptor> sortProps, List<XPLAINDistPropsDescriptor> distProps) {
            TestCase.assertTrue((stmt != null ? 1 : 0) != 0);
            PlanArtifacts a = plans.get();
            if (a == null) {
                a = new PlanArtifacts();
                plans.set(a);
            }
            TestCase.assertTrue((boolean)a.orsets.isEmpty());
            a.orsets.addAll(rsets);
            a.orsetsTimings.addAll(rsetsTimings);
            a.oscanProps.addAll(scanProps);
            a.osortProps.addAll(sortProps);
            a.odistProps.addAll(distProps);
        }

        public void processedResultSetDescriptor(XPLAINResultSetDescriptor rdesc) {
            TestCase.assertTrue((boolean)PlanStatisticsCollectionObserver.plans.get().orsets.remove(rdesc));
        }

        public void processedResultSetTimingDescriptor(XPLAINResultSetTimingsDescriptor rdescT) {
            TestCase.assertTrue((boolean)PlanStatisticsCollectionObserver.plans.get().orsetsTimings.remove(rdescT));
        }

        public void processedScanPropsDescriptor(XPLAINScanPropsDescriptor scanP) {
            TestCase.assertTrue((boolean)PlanStatisticsCollectionObserver.plans.get().oscanProps.remove(scanP));
        }

        public void processedSortPropsDescriptor(XPLAINSortPropsDescriptor sortP) {
            TestCase.assertTrue((boolean)PlanStatisticsCollectionObserver.plans.get().osortProps.remove(sortP));
        }

        public void processedDistPropsDescriptor(XPLAINDistPropsDescriptor distP) {
            TestCase.assertTrue((boolean)PlanStatisticsCollectionObserver.plans.get().odistProps.remove(distP));
        }

        public void end() {
            PlanArtifacts a = plans.get();
            if (a == null) {
                return;
            }
            TestCase.assertTrue((String)a.orsets.toString(), (boolean)a.orsets.isEmpty());
            TestCase.assertTrue((String)a.orsetsTimings.toString(), (boolean)a.orsetsTimings.isEmpty());
            TestCase.assertTrue((boolean)a.oscanProps.isEmpty());
            TestCase.assertTrue((boolean)a.osortProps.isEmpty());
            TestCase.assertTrue((boolean)a.odistProps.isEmpty());
        }

        public void observeXMLData(TreeNode[] dataArr) {
            TestCase.assertTrue((String)"Atleast few entries should be found on the datanode.", (dataArr.length > 0 ? 1 : 0) != 0);
            TreeNode[] arr$ = dataArr;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                TreeNode data;
                this.cn = data = arr$[i$];
                DistributedTestBase.getGlobalLogger().info((Object)("checking " + this.cn));
                String text = data.getId();
                TestCase.assertTrue((text != null ? 1 : 0) != 0);
                String id = text.split("\"")[1];
                TestCase.assertTrue((id.split("-").length == 5 ? 1 : 0) != 0);
                text = data.getParent();
                if (text == null) {
                    TestCase.assertTrue((String)this.emsg("duplicate root entry"), (!this.isRootEntryFound ? 1 : 0) != 0);
                    this.isRootEntryFound = true;
                }
                text = data.getNodeType();
                TestCase.assertTrue((String)this.emsg("node_type is null"), (text != null ? 1 : 0) != 0);
                String n = text.split("\"")[1];
                if (!(isLocalnode[0] || !"RESULT-HOLDER".equals(n) && AccessDistributedSystem.isMessagingEntry((String)n))) {
                    text = data.getReturnedRows();
                    TestCase.assertTrue((String)this.emsg("returned_rows is null"), (text != null ? 1 : 0) != 0);
                    int ret_rows = Integer.valueOf(text.split("\"")[1]);
                    TestCase.assertTrue((String)this.emsg(ret_rows + " <= 0 "), (ret_rows > 0 ? 1 : 0) != 0);
                } else if (isLocalnode[0] && !AccessDistributedSystem.isMessagingEntry((String)n)) {
                    text = data.getReturnedRows();
                    TestCase.assertTrue((String)this.emsg("returned_rows is null"), (text != null ? 1 : 0) != 0);
                    int ret_rows = Integer.valueOf(text.split("\"")[1]);
                    TestCase.assertTrue((String)this.emsg(ret_rows + " != " + 100L), ((long)ret_rows == 100L ? 1 : 0) != 0);
                }
                text = data.getExecTime();
                TestCase.assertTrue((text != null ? 1 : 0) != 0);
                Object[] split = text.split("[\"\\s]");
                if (split.length < 2) {
                    TestCase.fail((String)("got exec_time text=" + text + " with split=" + Arrays.toString(split) + " unexpected len=" + split.length + " < 2 for " + data));
                }
                double exec_time = Double.valueOf(split[1]);
                TestCase.assertTrue((String)this.emsg("exec_time=" + exec_time), (exec_time > 0.0 ? 1 : 0) != 0);
                if (!AccessDistributedSystem.isMessagingEntry((String)n) || !isLocalnode[0] && "RESULT-HOLDER".equals(n)) continue;
                text = data.getMemberNode();
                TestCase.assertTrue((text != null ? 1 : 0) != 0);
                TestCase.assertTrue((String)this.emsg("member_node is null"), (text.split("\"")[1].length() > 0 ? 1 : 0) != 0);
            }
        }

        private String emsg(String a) {
            return a + " for [" + this.cn + "] in " + Misc.getDistributedSystem().getMemberId();
        }

        static class PlanArtifacts {
            List<XPLAINResultSetDescriptor> orsets = new ArrayList<XPLAINResultSetDescriptor>();
            List<XPLAINResultSetTimingsDescriptor> orsetsTimings = new ArrayList<XPLAINResultSetTimingsDescriptor>();
            List<XPLAINScanPropsDescriptor> oscanProps = new ArrayList<XPLAINScanPropsDescriptor>();
            List<XPLAINSortPropsDescriptor> osortProps = new ArrayList<XPLAINSortPropsDescriptor>();
            List<XPLAINDistPropsDescriptor> odistProps = new ArrayList<XPLAINDistPropsDescriptor>();

            PlanArtifacts() {
            }

            public void reset() {
                this.orsets.clear();
                this.orsetsTimings.clear();
                this.oscanProps.clear();
                this.osortProps.clear();
                this.odistProps.clear();
            }
        }
    }
}

