/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.stats;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import io.snappydata.test.util.TestException;
import java.sql.Connection;
import java.util.Properties;

public class EmbeddedConnectionStatsDUnit
extends DistributedSQLTestBase {
    public EmbeddedConnectionStatsDUnit(String name) {
        super(name);
    }

    public void testConnectionStats() throws Exception {
        Properties info = new Properties();
        info.setProperty("gemfire.enable-time-statistics", "true");
        this.startClientVMs(1, 0, null, info);
        this.startServerVMs(2, 0, null);
        InternalDistributedSystem sys = Misc.getGemFireCache().getDistributedSystem();
        StatisticsType st = sys.findType(ConnectionStats.name);
        Statistics[] stats = sys.findStatisticsByType(st);
        int totalConnections = 100;
        for (int i = 1; i <= totalConnections; ++i) {
            Connection conn = TestUtil.getConnection(info);
            for (Statistics s : stats) {
                long numPeerConnections = s.getLong("peerConnectionsOpened");
                long peerConnectionsAttempted = s.getLong("peerConnectionsAttempted");
                long numNestedConnections = s.getLong("nestedConnectionsOpened");
                long numInternalConnections = s.getLong("internalConnectionsOpened");
                this.getLogWriter().info((Object)("numPeerConnections=" + numPeerConnections));
                this.getLogWriter().info((Object)("peerConnectionsAttempted=" + peerConnectionsAttempted));
                this.getLogWriter().info((Object)("numNestedConnections=" + numNestedConnections));
                this.getLogWriter().info((Object)("numInternalConnections=" + numInternalConnections));
                long connectionTime = s.getLong("peerConnectionsOpenTime");
                EmbeddedConnectionStatsDUnit.assertEquals((String)"Number of connections doesnt match ", (long)(i + 1), (long)(numPeerConnections + numNestedConnections));
                EmbeddedConnectionStatsDUnit.assertEquals((String)"Connections in progress should equal connections done", (long)numPeerConnections, (long)peerConnectionsAttempted);
                if (connectionTime <= 0L) {
                    throw new TestException("Time taken to connect should never be less than or equal to zero");
                }
                if (connectionTime <= 705032704L) continue;
                throw new TestException("Time taken to connect is too long, beyond 5 seconds... " + connectionTime + " nanos");
            }
            conn.close();
        }
        for (Statistics s : stats) {
            long numConnections = s.getLong("peerConnectionsOpened");
            long connectionsInProgress = s.getLong("peerConnectionsAttempted");
            this.getLogWriter().info((Object)("Number of connections : " + numConnections));
            this.getLogWriter().info((Object)("Number of connections in progress " + connectionsInProgress));
            EmbeddedConnectionStatsDUnit.assertEquals((String)"Number of connections doesnt match ", (long)(totalConnections + 1), (long)numConnections);
            EmbeddedConnectionStatsDUnit.assertEquals((String)"Connections in progress and connections done should be equal", (long)0L, (long)(connectionsInProgress - numConnections));
        }
        this.stopVMNums(1, -2);
    }
}

