/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.security;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.security.LdapTestServer;
import io.snappydata.test.dunit.AvailablePortHelper;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.standalone.DUnitBB;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class SecurityTestUtils
extends DistributedSQLTestBase {
    public static final String commonSchemaName = "shared_TestSchema".toUpperCase();

    public SecurityTestUtils(String name) {
        super(name);
    }

    public static void assertCurrentSchema(Statement stmts, String schemaName) throws SQLException {
        String currentschema = SecurityTestUtils.currentSchema(stmts);
        SecurityTestUtils.assertEquals((String)schemaName.toLowerCase(), (String)currentschema.toLowerCase());
    }

    public static String currentSchema(Statement stmts) throws SQLException {
        ResultSet rs = stmts.executeQuery("SELECT x from (VALUES(CURRENT SCHEMA)) as mySch(x) ");
        rs.next();
        return (String)rs.getObject(1);
    }

    public static void setupAuthentication(final AuthenticationSchemes scheme, final Properties sysprop) {
        SecurityTestUtils.invokeInEveryVM((SerializableRunnable)new SerializableRunnable("setupAuthentication"){

            public void run() {
                SecurityTestUtils.setSystemProperties(sysprop, scheme);
            }
        });
        SecurityTestUtils.setSystemProperties(sysprop, scheme);
    }

    public static void setSystemProperties(Properties sysprop, AuthenticationSchemes scheme) {
        Enumeration<?> e = sysprop.propertyNames();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            System.setProperty(k, sysprop.getProperty(k));
            SecurityTestUtils.getGlobalLogger().info((Object)("setting " + k + " = " + sysprop.getProperty(k)));
        }
        Properties connAtt = scheme.bootCredentials();
        TestUtil.bootUserName = connAtt.getProperty("user");
        TestUtil.bootUserName = TestUtil.bootUserName == null ? connAtt.getProperty("UserName") : TestUtil.bootUserName;
        TestUtil.bootUserPassword = connAtt.getProperty("password");
        SecurityTestUtils.getGlobalLogger().info((Object)("Recorded bootUserName " + TestUtil.bootUserName));
        SecurityTestUtils.getGlobalLogger().info((Object)"System properties definition done .... ");
    }

    public static void clearAuthenticationSetUp(final Properties sysprop, final AuthenticationSchemes scheme) {
        SecurityTestUtils.invokeInEveryVM((SerializableRunnable)new SerializableRunnable("clearAuthenticationSetup"){

            public void run() {
                scheme.clear();
                TestUtil.bootUserName = null;
                Enumeration<?> e = sysprop.propertyNames();
                while (e.hasMoreElements()) {
                    String k = (String)e.nextElement();
                    DistributedTestBase.getGlobalLogger().info((Object)("clearing " + k));
                    System.clearProperty(k);
                }
                DistributedTestBase.getGlobalLogger().info((Object)"System user definition cleared on VM.... ");
            }
        });
        TestUtil.bootUserName = null;
        Enumeration<?> e = sysprop.propertyNames();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            SecurityTestUtils.getGlobalLogger().info((Object)("clearing " + k));
            System.clearProperty(k);
        }
        scheme.clear();
        SecurityTestUtils.getGlobalLogger().info((Object)"System user definition cleared on local VM ");
    }

    public static void grantPrivilege(String schema, String dist_user, Statement stmts, ArrayList<Integer> grantList, priv_set ... privileges) throws SQLException {
        int rightsGranted = 0;
        for (priv_set p : privileges) {
            StringBuilder sb = new StringBuilder();
            sb.append(p.privilege()).append(" ");
            List<String> columnlist = p.getAllowedColumnList();
            if (!columnlist.isEmpty()) {
                sb.append("(").append(columnlist.get(0));
                for (int idx = 1; idx < columnlist.size(); ++idx) {
                    sb.append(",").append(columnlist.get(idx));
                }
                sb.append(")");
            }
            String priv = sb.toString();
            SecurityTestUtils.getGlobalLogger().info((Object)("GRANTING " + priv + " to " + dist_user));
            stmts.execute("grant " + priv + " on " + schema + "." + tables.SharedTable.name() + " to " + dist_user);
            rightsGranted |= p.priv_bit;
        }
        grantList.add(rightsGranted);
    }

    public static void checkDistUser(Properties dist_user_conn_props, String sharedSchemaName, int privileges, boolean readOnlyConnection) throws SQLException {
        Statement stmts;
        Connection conn;
        Properties connectionProp;
        block6: {
            String tab22;
            SecurityTestUtils.getGlobalLogger().info((Object)("Got privileges " + priv_set.privString(privileges) + " (" + privileges + ") schemaName " + sharedSchemaName + " dist_user props " + dist_user_conn_props));
            assert (dist_user_conn_props != null) : " this should have been set ";
            connectionProp = new Properties();
            connectionProp.putAll((Map<?, ?>)dist_user_conn_props);
            String currentUser = connectionProp.getProperty("user");
            currentUser = currentUser == null ? connectionProp.getProperty("UserName") : currentUser;
            SecurityTestUtils.getGlobalLogger().info((Object)("getting local connection using distributed system user " + connectionProp));
            conn = TestUtil.getConnection(connectionProp);
            SecurityTestUtils.getGlobalLogger().info((Object)"connection successfull. ");
            stmts = conn.createStatement();
            String distTable = "dist_table_1";
            SecurityTestUtils.getGlobalLogger().info((Object)("Check table dist_table_1 in " + currentUser + " current schema"));
            ResultSet tabexist = stmts.executeQuery("select tablename from sys.systables where tablename = 'dist_table_1'");
            if (tabexist.next() && (tab22 = tabexist.getString(1)) != null) {
                SecurityTestUtils.getGlobalLogger().info((Object)(tab22 + " exists in " + currentUser + " current schema"));
            }
            try {
                stmts.execute("drop table dist_table_1");
            }
            catch (SQLException tab22) {
                // empty catch block
            }
            try {
                SecurityTestUtils.getGlobalLogger().info((Object)("creating tables in OWN schema (" + currentUser + ")"));
                stmts.execute("create table dist_table_1 ( col1 int, col2 int, primary key (col1))");
            }
            catch (SQLException sqe) {
                if (readOnlyConnection && sqe.getSQLState().equals("25503")) break block6;
                throw sqe;
            }
        }
        SecurityTestUtils.getGlobalLogger().info((Object)("switching to schema " + sharedSchemaName));
        stmts.execute("SET SCHEMA " + sharedSchemaName);
        SecurityTestUtils.assertCurrentSchema(stmts, sharedSchemaName);
        SecurityTestUtils.getGlobalLogger().info((Object)("browsing " + (Object)((Object)tables.SharedTable)));
        tables.SharedTable.rowCount(conn.createStatement(), privileges);
        SecurityTestUtils.checkSelect(tables.SharedTable, conn, stmts, privileges, dist_user_conn_props);
        SecurityTestUtils.checkInsert(tables.SharedTable, conn, stmts, privileges, dist_user_conn_props, readOnlyConnection);
        SecurityTestUtils.checkUpdate(tables.SharedTable, conn, stmts, privileges, dist_user_conn_props, readOnlyConnection);
        connectionProp.clear();
        conn.close();
        conn = null;
    }

    static void checkSelect(tables tab, Connection conn, Statement stmts, int privileges, Properties props) throws SQLException {
        block14: {
            int rows;
            block13: {
                int rowsSelected;
                block12: {
                    SecurityTestUtils.getGlobalLogger().info((Object)("executing row count on " + (Object)((Object)tab)));
                    rows = tab.rowCount(stmts, privileges);
                    SecurityTestUtils.getGlobalLogger().info((Object)("Checking select of ALL columns in " + (Object)((Object)tab)));
                    try {
                        rowsSelected = tab.doSelect(stmts, tab.columns());
                        if (!priv_set.hasPriv(privileges, priv_set.SELECT_ALL)) {
                            SanityManager.THROWASSERT((String)("must have failed as dist_user don't have access to all the columns of table " + tab.name()));
                        }
                        SecurityTestUtils.assertEquals((int)rows, (int)rowsSelected);
                    }
                    catch (SQLException expected) {
                        if (priv_set.hasPriv(privileges, priv_set.SELECT_ALL)) {
                            SanityManager.THROWASSERT((String)(expected.getSQLState() + " shouldn't have failed " + expected));
                        }
                        if (priv_set.getAllowedSQLStates(privileges).contains(expected.getSQLState())) break block12;
                        SanityManager.THROWASSERT((String)(expected.getSQLState() + " unexpected exception received " + expected));
                    }
                }
                SecurityTestUtils.getGlobalLogger().info((Object)("Checking select of few columns in " + (Object)((Object)tab)));
                try {
                    rowsSelected = tab.doSelect(stmts, priv_set.SELECT_ST_1.getAllowedColumnList().toArray(new String[0]));
                    if (!priv_set.hasAnyPriv(privileges, priv_set.SELECT_ST_1, priv_set.SELECT_ST_1_ST_2, priv_set.SELECT_ALL)) {
                        SanityManager.THROWASSERT((String)("must have failed as selective columns privileges is not there in " + tab.name()));
                    }
                    SecurityTestUtils.assertEquals((int)rows, (int)rowsSelected);
                }
                catch (SQLException expected) {
                    if (priv_set.hasAnyPriv(privileges, priv_set.SELECT_ALL, priv_set.SELECT_ST_1_ST_2, priv_set.SELECT_ST_1)) {
                        SanityManager.THROWASSERT((String)(expected.getSQLState() + " granted columns couldn't be selected " + expected));
                    }
                    if (priv_set.getAllowedSQLStates(privileges).contains(expected.getSQLState())) break block13;
                    SanityManager.THROWASSERT((String)(expected.getSQLState() + " unexpected exception received " + expected));
                }
            }
            SecurityTestUtils.getGlobalLogger().info((Object)("Checking select of few other columns in " + (Object)((Object)tab)));
            try {
                int rowsSelected = tab.doSelect(stmts, priv_set.SELECT_ST_1_ST_2.getAllowedColumnList().toArray(new String[0]));
                SecurityTestUtils.assertEquals((int)rows, (int)rowsSelected);
                if (!priv_set.hasAnyPriv(privileges, priv_set.SELECT_ST_1_ST_2, priv_set.SELECT_ALL)) {
                    SanityManager.THROWASSERT((String)("must have failed as selective columns privileges is not there in " + tab.name()));
                }
            }
            catch (SQLException expected) {
                if (priv_set.hasAnyPriv(privileges, priv_set.SELECT_ALL, priv_set.SELECT_ST_1_ST_2)) {
                    SanityManager.THROWASSERT((String)(expected.getSQLState() + " shouldn't have failed " + expected));
                }
                if (priv_set.getAllowedSQLStates(privileges).contains(expected.getSQLState())) break block14;
                SanityManager.THROWASSERT((String)(expected.getSQLState() + " unexpected exception received " + expected));
            }
        }
    }

    static void checkInsert(tables tab, Connection conn, Statement stmts, int privileges, Properties props, boolean readOnlyConnection) throws SQLException {
        try {
            SecurityTestUtils.getGlobalLogger().info((Object)("Checking insert into " + (Object)((Object)tab)));
            tab.doInsert(stmts, "(4,4,4)", "(5,5,5)", "(6,6,6)");
            if (!priv_set.hasPriv(privileges, priv_set.INSERT)) {
                String userName = props.getProperty("user");
                userName = userName == null ? props.getProperty("UserName") : userName;
                SanityManager.THROWASSERT((String)("expected insert to fail as " + userName + " have priveleges to be " + priv_set.privString(privileges)));
            }
        }
        catch (SQLException expected) {
            SecurityTestUtils.handleException(privileges, priv_set.INSERT, readOnlyConnection, expected, conn);
        }
        tab.rowCount(stmts, privileges);
    }

    static void checkUpdate(tables tab, Connection conn, Statement stmts, int privileges, Properties props, boolean readOnlyConnection) throws SQLException {
        try {
            SecurityTestUtils.getGlobalLogger().info((Object)("Checking update into " + (Object)((Object)tab)));
            tab.doUpdate(stmts, null);
            if (!priv_set.hasPriv(privileges, priv_set.UPDATE_ALL)) {
                String userName = props.getProperty("user");
                userName = userName == null ? props.getProperty("UserName") : userName;
                SanityManager.THROWASSERT((String)("expected update to fail as " + userName + " have priveleges to be " + priv_set.privString(privileges)));
            }
        }
        catch (SQLException expected) {
            SecurityTestUtils.handleException(privileges, priv_set.UPDATE_ALL, readOnlyConnection, expected, conn);
        }
        tab.rowCount(stmts, privileges);
    }

    private static void handleException(int privileges, priv_set targetPriv, boolean readOnlyConnection, SQLException expected, Connection conn) throws SQLException {
        if (!readOnlyConnection && priv_set.hasPriv(privileges, targetPriv)) {
            SanityManager.THROWASSERT((String)(expected.getSQLState() + " shouldn't have failed " + expected));
        } else if (readOnlyConnection) {
            if (!conn.isReadOnly()) {
                SanityManager.THROWASSERT((String)"Connection NOT READONLY ...");
            }
            if (!expected.getSQLState().equals("25502")) {
                SanityManager.THROWASSERT((String)("Connection IS READONLY, expecting " + expected.getSQLState() + " (Write with readonly connection exception) but received - " + expected));
            }
        } else if (!priv_set.getAllowedSQLStates(privileges).contains(expected.getSQLState())) {
            SanityManager.THROWASSERT((String)(expected.getSQLState() + " unexpected exception received " + expected));
        } else {
            SecurityTestUtils.getGlobalLogger().info((Object)("Ignoring " + (Object)((Object)targetPriv) + " exeception " + expected));
        }
    }

    public static void checkDistUser_everywhere(Properties props, String sharedSchemaName, int privileges, boolean readOnlyConnection) throws SQLException {
        SecurityTestUtils.invokeInEveryVM(SecurityTestUtils.class, (String)"checkForDistUser", (Object[])new Object[]{props, sharedSchemaName, privileges, readOnlyConnection});
    }

    public static void checkForDistUser(Properties props, String sharedSchemaName, int privileges, boolean readOnlyConnection) {
        try {
            SecurityTestUtils.checkDistUser(props, sharedSchemaName, privileges, readOnlyConnection);
        }
        catch (SQLException e) {
            e.printStackTrace();
            GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
            throw GemFireXDRuntimeException.newRuntimeException((String)("Check Exception in " + (cache != null ? cache.getDistributedSystem().getDistributedMember() : "cache is null")), (Throwable)e);
        }
    }

    public static Properties startLdapServerAndGetBootProperties(int locatorPort, int mcastPort, String sysUser) throws Exception {
        return SecurityTestUtils.startLdapServerAndGetBootProperties(locatorPort, mcastPort, sysUser, null);
    }

    public static Properties startLdapServerAndGetBootProperties(int locatorPort, int mcastPort, String sysUser, String ldifFilePath) throws Exception {
        LdapTestServer server = ldifFilePath != null ? LdapTestServer.getInstance(ldifFilePath) : LdapTestServer.getInstance();
        if (!server.isServerStarted()) {
            server.startServer();
        }
        Properties bootProps = new Properties();
        SecurityTestUtils.setLdapServerBootProperties(server, locatorPort, mcastPort, sysUser, bootProps);
        return bootProps;
    }

    public static void setLdapServerBootProperties(LdapTestServer server, int locatorPort, int mcastPort, String sysUser, Properties bootProps) {
        int serverPort = server.getServerPort();
        if (locatorPort > 0) {
            bootProps.setProperty("locators", "localhost[" + locatorPort + ']');
        } else if (mcastPort > 0) {
            bootProps.setProperty("mcast-port", Integer.toString(mcastPort));
        }
        bootProps.setProperty("security-log-level", "finest");
        bootProps.setProperty("gemfirexd.debug.true", "TraceAuthentication,TraceSystemProcedures,TraceFabricServiceBoot");
        bootProps.setProperty("auth-provider", "LDAP");
        bootProps.setProperty("gemfirexd.auth-ldap-search-base", "ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
        bootProps.setProperty("gemfirexd.group-ldap-search-base", "ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
        bootProps.setProperty("gemfirexd.auth-ldap-server", "ldap://localhost:" + serverPort);
        SecurityTestUtils.setUserProps(sysUser, bootProps);
    }

    public static void setUserProps(String user, Properties props) {
        props.setProperty("user", user);
        props.setProperty("password", user);
    }

    public static enum priv_set {
        INSERT(1){

            @Override
            public void addAuthFailureException(Set<String> expect) {
                expect.add("42500");
            }

            @Override
            public String privilege() {
                return "INSERT";
            }
        }
        ,
        DELETE(2){

            @Override
            public void addAuthFailureException(Set<String> expect) {
            }

            @Override
            public String privilege() {
                return "DELETE";
            }
        }
        ,
        TRIGGER(4){

            @Override
            public void addAuthFailureException(Set<String> expect) {
            }

            @Override
            public String privilege() {
                return "TRIGGER";
            }
        }
        ,
        SELECT_ALL(8){

            @Override
            public void addAuthFailureException(Set<String> expect) {
            }

            @Override
            public String privilege() {
                return "SELECT";
            }
        }
        ,
        SELECT_ST_1(16, (List)Arrays.asList("st_1")){

            @Override
            public void addAuthFailureException(Set<String> expect) {
                expect.add("42502");
            }

            @Override
            public String privilege() {
                return "SELECT";
            }
        }
        ,
        SELECT_ST_1_ST_2(32, (List)Arrays.asList("st_1", "st_2")){

            @Override
            public void addAuthFailureException(Set<String> expect) {
                expect.add("42502");
            }

            @Override
            public String privilege() {
                return "SELECT";
            }
        }
        ,
        UPDATE_ALL(64){

            @Override
            public void addAuthFailureException(Set<String> expect) {
            }

            @Override
            public String privilege() {
                return "UPDATE";
            }
        }
        ,
        UPDATE_ST_2(128, (List)Arrays.asList("st_2")){

            @Override
            public void addAuthFailureException(Set<String> expect) {
                expect.add("42502");
            }

            @Override
            public String privilege() {
                return "UPDATE";
            }
        }
        ,
        REFERENCES(256, (List)Arrays.asList("st_3")){

            @Override
            public void addAuthFailureException(Set<String> expect) {
            }

            @Override
            public String privilege() {
                return "REFERENCES";
            }
        };

        private int priv_bit;
        private List<String> collist;

        abstract void addAuthFailureException(Set<String> var1);

        abstract String privilege();

        private priv_set(int privbit) {
            this.priv_bit = privbit;
            this.collist = Collections.emptyList();
        }

        private priv_set(int priv_bit, List<String> collist) {
            this.priv_bit = priv_bit;
            this.collist = collist;
        }

        public List<String> getAllowedColumnList() {
            return this.collist;
        }

        public static boolean hasPriv(int userPriv, priv_set targetPriv) {
            return (userPriv & targetPriv.priv_bit) != 0;
        }

        public static boolean hasAnyPriv(int userPriv, priv_set ... targetPriv) {
            boolean result = false;
            for (priv_set p : targetPriv) {
                result |= (userPriv & p.priv_bit) != 0;
            }
            return result;
        }

        public static int clearPriv(int userPriv, priv_set targetPriv) {
            return userPriv & ~targetPriv.priv_bit;
        }

        public static String privString(int userPriv) {
            StringBuilder sb = new StringBuilder();
            do {
                sb.append((userPriv & 1) == 1 ? "1" : "0");
            } while ((userPriv >>>= 1) != 0);
            return sb.toString();
        }

        public static Set<String> getAllowedSQLStates(int privileges) {
            HashSet<String> exceptionStates = new HashSet<String>();
            for (priv_set p : priv_set.values()) {
                if (priv_set.hasPriv(privileges, p)) continue;
                p.addAuthFailureException(exceptionStates);
            }
            return exceptionStates;
        }
    }

    public static enum tables {
        SharedTable{
            private String tableschema = commonSchemaName;
            private volatile int num_rows = 0;
            private final String tabnm = this.name();
            private final String[] cols = new String[]{"st_1", "st_2", "st_3"};
            private final String[] updateAlllist = new String[]{"update " + this.tabnm + " set st_1=100, st_2=200", "update " + this.tabnm + " set st_1=101, st_2=201", "update " + this.tabnm + " set st_1=102, st_2=202", "update " + this.tabnm + " set st_1=103, st_2=210", "update " + this.tabnm + " set st_1=104, st_2=220", "update " + this.tabnm + " set st_1=105, st_2=230"};
            private int currentUpIdx = 0;

            @Override
            public void createTable(Statement stmts) throws SQLException {
                ResultSet rs = stmts.executeQuery("VALUES CURRENT_USER");
                rs.next();
                this.tableschema = rs.getString(1);
                stmts.execute("create table " + this.tabnm + "(st_1 int, st_2 int, st_3 int)");
            }

            @Override
            public void doInsert(Statement stmts, String ... valueList) throws SQLException {
                String query = "insert into " + this.tabnm + " values";
                if (valueList == null) {
                    stmts.execute(query + "(1,1,1), (2,2,2), (3,3,3)");
                } else {
                    for (String s : valueList) {
                        query = query + s + (s.equals(valueList[valueList.length - 1]) ? "" : ",");
                    }
                    DistributedTestBase.getGlobalLogger().info((Object)("executing " + query));
                    stmts.execute(query);
                }
            }

            @Override
            public void doDelete(Statement stmts) {
                --this.num_rows;
            }

            @Override
            public void doUpdate(Statement stmts, String[] col_list) throws SQLException {
                if (col_list == null || col_list.length == 0) {
                    int rowsEffected = stmts.executeUpdate(this.updateAlllist[this.currentUpIdx++]);
                    this.refreshNumRows();
                    TestCase.assertEquals((int)this.num_rows, (int)rowsEffected);
                }
            }

            @Override
            public int rowCount(Statement stmts, int privileges) throws SQLException {
                int rowCount = 0;
                try {
                    ResultSet rs = stmts.executeQuery("select count(1) from " + this.tabnm);
                    TestCase.assertTrue((String)((Object)((Object)this) + "rowCount: "), (boolean)rs.next());
                    rowCount = rs.getInt(1);
                }
                catch (SQLException sqle) {
                    if (priv_set.hasAnyPriv(privileges, priv_set.SELECT_ALL, priv_set.SELECT_ST_1, priv_set.SELECT_ST_1_ST_2)) {
                        throw sqle;
                    }
                    if (!"42502".equals(sqle.getSQLState())) {
                        throw sqle;
                    }
                    rowCount = -1;
                }
                this.refreshNumRows();
                TestCase.assertEquals((int)this.num_rows, (int)rowCount);
                return this.num_rows;
            }

            private void refreshNumRows() throws SQLException {
                String regionPath = Misc.getRegionPath((String)this.tableschema, (String)this.tabnm.toUpperCase(), null);
                DistributedTestBase.getGlobalLogger().info((Object)("getting region " + regionPath));
                Region reg = Misc.getGemFireCache().getRegion(regionPath);
                TestCase.assertTrue((String)("Region expected " + regionPath), (reg != null ? 1 : 0) != 0);
                this.num_rows = reg.size();
            }

            @Override
            public void reset() {
                this.num_rows = 0;
                this.currentUpIdx = 0;
            }

            @Override
            public int doSelect(Statement stmts, String[] col_list) throws SQLException {
                StringBuilder query = new StringBuilder("select ");
                if (col_list == null || col_list.length == 0) {
                    query.append("*");
                } else {
                    for (int i = 0; i < col_list.length; ++i) {
                        if (i != 0) {
                            query.append(",");
                        }
                        query.append(col_list[i]);
                    }
                }
                query.append(" from ");
                query.append(this.tabnm);
                DistributedTestBase.getGlobalLogger().info((Object)query.toString());
                ResultSet rs = stmts.executeQuery(query.toString());
                int rows = 0;
                while (rs.next()) {
                    ++rows;
                }
                return rows;
            }

            @Override
            public String[] columns() {
                return this.cols;
            }

            @Override
            public String getSchema() {
                return this.tableschema;
            }
        };


        abstract void createTable(Statement var1) throws SQLException;

        abstract void doInsert(Statement var1, String ... var2) throws SQLException;

        abstract void doUpdate(Statement var1, String[] var2) throws SQLException;

        abstract void doDelete(Statement var1);

        abstract int rowCount(Statement var1, int var2) throws SQLException;

        abstract int doSelect(Statement var1, String[] var2) throws SQLException;

        abstract String[] columns();

        abstract String getSchema();

        abstract void reset();

        static void clearHistory() {
            for (tables t : tables.values()) {
                t.reset();
            }
        }
    }

    public static enum AuthenticationSchemes {
        BUILTIN{

            @Override
            public Properties startupProps(boolean setExplicitPeerAuth, boolean forStartup, boolean withAuthorization, boolean withOnlyNewSysUser, boolean readOnlyDistUser) {
                String u;
                if (withOnlyNewSysUser) {
                    u = GemFireXDUtils.getRandomString((boolean)false);
                    this.sysUser = "SYSTEM_" + u;
                    this.sysPwd = AuthenticationSchemes.pwdPrefix + this.sysUser;
                    DUnitBB.getBB().put((Object)AuthenticationSchemes.sysMapKey, (Object)this.sysUser);
                    DistributedTestBase.getGlobalLogger().info((Object)("generating only a new sys user " + this.sysUser + " pwd " + this.sysPwd));
                    String userlist = (String)DUnitBB.getBB().get((Object)AuthenticationSchemes.csMapKey);
                    DistributedTestBase.getGlobalLogger().info((Object)("dist-sys users present in GFXDAuthenticationClusterUsers = " + userlist));
                } else if (forStartup) {
                    u = GemFireXDUtils.getRandomString((boolean)false);
                    this.sysUser = "SYSTEM_" + u;
                    this.sysPwd = AuthenticationSchemes.pwdPrefix + this.sysUser;
                    DUnitBB.getBB().put((Object)AuthenticationSchemes.sysMapKey, (Object)this.sysUser);
                    DistributedTestBase.getGlobalLogger().info((Object)("recorded sys user " + this.sysUser + " pwd " + this.sysPwd));
                    StringBuilder sb = new StringBuilder();
                    for (int i = 1; i <= 10; ++i) {
                        if (i != 1) {
                            sb.append(",");
                        }
                        sb.append("DIST_SYS_").append(i < 10 ? "0" : "").append(i).append("_");
                        u = GemFireXDUtils.getRandomString((boolean)false);
                        sb.append(u.toUpperCase());
                    }
                    String userlist = sb.toString();
                    DistributedTestBase.getGlobalLogger().info((Object)("Creating dist-sys users  " + userlist));
                    this.clusterUsers = new String[10];
                    this.clusterUsers = SharedUtils.toSortedSet((String)userlist, (boolean)false).toArray(this.clusterUsers);
                    TestCase.assertTrue((this.clusterUsers.length == 10 ? 1 : 0) != 0);
                    DistributedTestBase.getGlobalLogger().info((Object)("putting into shared map with key GFXDAuthenticationClusterUsers = " + userlist));
                    DUnitBB.getBB().put((Object)AuthenticationSchemes.csMapKey, (Object)userlist);
                }
                Properties props = new Properties();
                this.setCommonProperties(props, withAuthorization, readOnlyDistUser);
                try {
                    props.setProperty("gemfirexd.user." + this.sysUser, AuthenticationServiceBase.encryptPassword((String)this.sysUser, (String)this.sysPwd));
                }
                catch (StandardException se) {
                    throw new IllegalArgumentException(se);
                }
                props.setProperty("gemfirexd.auth-provider", "BUILTIN");
                if (setExplicitPeerAuth) {
                    props.setProperty("gemfirexd.server-auth-provider", "BUILTIN");
                }
                return props;
            }

            @Override
            Properties bootCredentials() {
                if (this.sysUser == null) {
                    this.sysUser = (String)DUnitBB.getBB().get((Object)AuthenticationSchemes.sysMapKey);
                    this.sysPwd = AuthenticationSchemes.pwdPrefix + this.sysUser;
                    DistributedTestBase.getGlobalLogger().info((Object)("boot credentials sysUser " + this.sysUser));
                }
                Properties props = new Properties();
                props.setProperty(PartitionedRegion.rand.nextBoolean() ? "user" : "UserName", this.sysUser);
                props.setProperty("password", this.sysPwd);
                return props;
            }

            @Override
            public Properties connectionCredentials(boolean dbUsersOnly, boolean randomizeUsers) {
                Properties props = new Properties();
                if (this.clusterUsers == null) {
                    String userlist = (String)DUnitBB.getBB().get((Object)AuthenticationSchemes.csMapKey);
                    DistributedTestBase.getGlobalLogger().info((Object)("read from shared map with key GFXDAuthenticationClusterUsers = " + userlist));
                    TestCase.assertTrue((userlist != null ? 1 : 0) != 0);
                    this.clusterUsers = userlist.split(",");
                }
                for (String s : this.clusterUsers) {
                    TestCase.assertTrue((s != null ? 1 : 0) != 0);
                }
                String usr = null;
                usr = randomizeUsers ? this.clusterUsers[PartitionedRegion.rand.nextInt(this.clusterUsers.length)] : this.clusterUsers[this.disUsrIdx++];
                assert (usr != null);
                props.setProperty(PartitionedRegion.rand.nextBoolean() ? "UserName" : "user", usr);
                props.setProperty("password", AuthenticationSchemes.pwdPrefix + usr);
                return props;
            }

            @Override
            public void clear() {
                this.clusterUsers = null;
                this.sysUser = null;
                this.sysPwd = null;
                this.comonclear();
            }
        }
        ,
        LDAP{
            private static final String gf1 = "gemfire1";
            private static final String gf10 = "gemfire10";
            private static final String gf2 = "gemfire2";
            private static final String gf3 = "gemfire3";
            private static final String gf4 = "gemfire4";
            private static final String gf5 = "gemfire5";
            {
                this.clusterUsers = new String[4];
                this.clusterUsers[0] = gf2;
                this.clusterUsers[1] = gf3;
                this.clusterUsers[2] = gf4;
                this.clusterUsers[3] = gf5;
                TestCase.assertTrue((this.clusterUsers.length == 4 ? 1 : 0) != 0);
            }

            @Override
            public Properties startupProps(boolean setExplicitPeerAuth, boolean forStartup, boolean withAuthorization, boolean withOnlyNewSysUser, boolean readOnlyDistUser) {
                if (withOnlyNewSysUser) {
                    TestCase.assertTrue((String)"with this flag expected only once. add more sysUser if need more.", (boolean)this.sysUser.equals(gf1));
                    this.sysPwd = this.sysUser = gf10;
                } else if (forStartup) {
                    this.sysPwd = this.sysUser = gf1;
                }
                Properties props = new Properties();
                this.setCommonProperties(props, withAuthorization, readOnlyDistUser);
                try {
                    SecurityTestUtils.setLdapServerBootProperties(LdapTestServer.getInstance(), -1, -1, this.sysUser, props);
                }
                catch (Exception e) {
                    DistributedSQLTestBase.fail("failed to get LDAP server instance", e);
                }
                if (setExplicitPeerAuth) {
                    props.setProperty("gemfirexd.server-auth-provider", "LDAP");
                }
                props.setProperty("SYS-USER", this.sysUser);
                return props;
            }

            @Override
            public Properties bootCredentials() {
                if (this.sysUser == null) {
                    for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                        String k = (String)e.getKey();
                        String v = (String)e.getValue();
                        if (!k.equals("SYS-USER")) continue;
                        this.sysPwd = this.sysUser = v;
                        break;
                    }
                }
                Properties props = new Properties();
                props.setProperty("user", this.sysUser);
                props.setProperty("password", this.sysPwd);
                return props;
            }

            @Override
            public Properties connectionCredentials(boolean dbUsersOnly, boolean randomizeUsers) {
                Properties props = new Properties();
                for (String s : this.clusterUsers) {
                    TestCase.assertTrue((s != null ? 1 : 0) != 0);
                }
                String usr = null;
                usr = randomizeUsers ? this.clusterUsers[PartitionedRegion.rand.nextInt(this.clusterUsers.length)] : this.clusterUsers[this.disUsrIdx++];
                assert (usr != null);
                props.setProperty("user", usr);
                props.setProperty("password", usr);
                return props;
            }

            @Override
            public void clear() {
                this.sysUser = null;
                this.sysPwd = null;
                this.comonclear();
            }
        };

        protected static final String csMapKey = "GFXDAuthenticationClusterUsers";
        protected static final String sysMapKey = "GFXDAuthenticationSystemUser";
        private static final String pwdPrefix = "_PWD_";
        protected String[] clusterUsers = null;
        protected String sysUser = null;
        protected String sysPwd = null;
        protected int disUsrIdx = 0;

        abstract Properties startupProps(boolean var1, boolean var2, boolean var3, boolean var4, boolean var5);

        abstract Properties bootCredentials();

        abstract Properties connectionCredentials(boolean var1, boolean var2);

        public void CreateUsers(Connection conn) throws SQLException {
            if (this.clusterUsers == null) {
                String userlist = (String)DUnitBB.getBB().get((Object)csMapKey);
                DistributedTestBase.getGlobalLogger().info((Object)("Won't need to create users ... initializing existing cluster users GFXDAuthenticationClusterUsers = " + userlist));
                TestCase.assertTrue((userlist != null ? 1 : 0) != 0);
                this.clusterUsers = userlist.split(",");
                return;
            }
            DistributedTestBase.getGlobalLogger().info((Object)"about to create distributed sys users ");
            CallableStatement cusr = conn.prepareCall("call sys.create_user(?,?)");
            CallableStatement cpwd = conn.prepareCall("call sys.change_password(?,?,?)");
            int i = 0;
            for (String u : this.clusterUsers) {
                if (++i % 2 == 0) {
                    block5: {
                        cusr.setString(1, u);
                        cusr.setString(2, "random_" + u);
                        cusr.execute();
                        DistributedTestBase.getGlobalLogger().info((Object)("created distributed system user with random password " + u));
                        try {
                            cusr.setString(1, u);
                            cusr.setString(2, pwdPrefix + u);
                            cusr.execute();
                            TestCase.fail((String)"User already exists exception expected.");
                        }
                        catch (SQLException sqle) {
                            if ("28504".equals(sqle.getSQLState())) break block5;
                            throw sqle;
                        }
                    }
                    if (this != BUILTIN) continue;
                    cpwd.setString(1, u);
                    cpwd.setString(2, "random_" + u);
                    cpwd.setString(3, pwdPrefix + u);
                    cpwd.execute();
                    DistributedTestBase.getGlobalLogger().info((Object)("changed password of distributed system user " + u));
                    continue;
                }
                cusr.setString(1, u);
                cusr.setString(2, pwdPrefix + u);
                cusr.execute();
                DistributedTestBase.getGlobalLogger().info((Object)("created distributed system user " + u));
            }
        }

        protected void setCommonProperties(Properties props, boolean withAuthorization, boolean readOnly) {
            props.setProperty("gemfirexd.authentication.required", Boolean.toString(true));
            props.setProperty("gemfire.log-level", "fine");
            props.setProperty("gemfire.security-log-level", "finest");
            props.setProperty("gemfirexd.debug.true", "TraceAuthentication,TraceSystemProcedures,TraceFabricServiceBoot");
            if (withAuthorization) {
                props.setProperty("gemfirexd.sql-authorization", "true");
                if (readOnly) {
                    props.setProperty("gemfirexd.authz-default-connection-mode", "READONLYACCESS");
                } else {
                    props.setProperty("gemfirexd.authz-default-connection-mode", "FULLACCESS");
                }
                props.setProperty("gemfirexd.authz-full-access-users", this.sysUser);
                if (readOnly) {
                    String clusterUserList = (String)DUnitBB.getBB().get((Object)csMapKey);
                    props.setProperty("gemfirexd.authz-read-only-access-users", clusterUserList);
                }
            } else {
                props.setProperty("gemfirexd.sql-authorization", "false");
            }
        }

        public abstract void clear();

        protected void comonclear() {
            this.disUsrIdx = 0;
            tables.clearHistory();
        }

        public void resetDistUserIndex() {
            this.disUsrIdx = 0;
        }

        public void DropUsers(Connection conn) throws SQLException {
            DistributedTestBase.getGlobalLogger().info((Object)"Dropping distributed sys users ");
            DUnitBB.getBB().remove((Object)csMapKey);
            CallableStatement cusr = conn.prepareCall("call sys.drop_user(?)");
            for (String u : this.clusterUsers) {
                cusr.setString(1, u);
                cusr.execute();
                DistributedTestBase.getGlobalLogger().info((Object)("dropped distributed system user " + u));
            }
        }

        public String getLocatorString() {
            String available_port = String.valueOf(AvailablePortHelper.getRandomAvailableTCPPort());
            return "localhost[" + available_port + "]";
        }
    }
}

