/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.security;

import com.pivotal.gemfirexd.TestUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.ldif.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.shared.ldap.schema.loader.ldif.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.shared.ldap.schema.registries.SchemaLoader;

public class LdapTestServer {
    private static volatile LdapTestServer instance;
    private static final Object instLock;
    private DirectoryService service;
    private LdapServer server;
    private String serverAddress;
    private int serverPort = 10389;
    private final String ldifLoadFile;

    public static LdapTestServer getInstance() throws Exception {
        return LdapTestServer.getInstance("./apacheds", TestUtil.getResourcesDir() + "/lib/ldap/auth.ldif");
    }

    public static LdapTestServer getInstance(String ldifFilePath) throws Exception {
        return LdapTestServer.getInstance("./apacheds", ldifFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LdapTestServer getInstance(String workingDir, String ldifFilePath) throws Exception {
        LdapTestServer inst = instance;
        if (inst != null) {
            return inst;
        }
        Object object = instLock;
        synchronized (object) {
            inst = instance;
            if (inst == null) {
                inst = instance = new LdapTestServer(workingDir, ldifFilePath);
            }
            return inst;
        }
    }

    private Partition addPartition(String partitionId, String partitionDn) throws Exception {
        JdbmPartition partition = new JdbmPartition();
        partition.setId(partitionId);
        partition.setPartitionDir(new File(this.service.getWorkingDirectory(), partitionId));
        partition.setSuffix(partitionDn);
        this.service.addPartition((Partition)partition);
        return partition;
    }

    private void initSchemaPartition() throws Exception {
        SchemaPartition schemaPartition = this.service.getSchemaService().getSchemaPartition();
        LdifPartition ldifPartition = new LdifPartition();
        String workingDirectory = this.service.getWorkingDirectory().getPath();
        ldifPartition.setWorkingDirectory(workingDirectory + "/schema");
        File schemaRepository = new File(workingDirectory, "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(new File(workingDirectory));
        extractor.extractOrCopy(true);
        schemaPartition.setWrappedPartition((Partition)ldifPartition);
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        this.service.setSchemaManager((SchemaManager)schemaManager);
        schemaManager.loadAllEnabled();
        schemaPartition.setSchemaManager((SchemaManager)schemaManager);
        List errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception("Schema load failed : " + errors);
        }
    }

    private void initDirectoryService(File workDir) throws Exception {
        this.service = new DefaultDirectoryService();
        this.service.setWorkingDirectory(workDir);
        this.initSchemaPartition();
        Partition systemPartition = this.addPartition("system", "ou=system");
        this.service.setSystemPartition(systemPartition);
        Partition testingPartition = this.addPartition("ldapTesting", "ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
        this.service.setShutdownHookEnabled(false);
        this.service.getChangeLog().setEnabled(false);
        this.service.setDenormalizeOpAttrsEnabled(true);
        this.service.startup();
        if (!this.service.getAdminSession().exists(testingPartition.getSuffixDn())) {
            DN dnTesting = new DN("ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            ServerEntry entryTesting = this.service.newEntry(dnTesting);
            entryTesting.add("objectClass", new String[]{"top", "domain", "extensibleObject"});
            entryTesting.add("dc", new String[]{"pune"});
            this.service.getAdminSession().add(entryTesting);
        }
        if (this.ldifLoadFile != null) {
            LdifFileLoader ldifLoader = new LdifFileLoader(this.service.getAdminSession(), this.ldifLoadFile);
            int numLoaded = ldifLoader.execute();
            if (numLoaded <= 0) {
                throw new Exception("Failed to load any entries from " + this.ldifLoadFile);
            }
            System.out.println("LDAP loaded " + numLoaded + " entries from " + this.ldifLoadFile);
        }
    }

    private LdapTestServer(String workingDir, String ldifFilePath) throws Exception {
        File workingDirF = new File(workingDir);
        FileUtils.deleteQuietly((File)workingDirF);
        workingDirF.mkdirs();
        this.ldifLoadFile = ldifFilePath;
        this.initDirectoryService(workingDirF);
    }

    public void startServer() throws Exception {
        this.server = new LdapServer();
        TcpTransport transport = this.serverAddress != null ? new TcpTransport(this.serverAddress, this.serverPort) : new TcpTransport(this.serverPort);
        this.server.setTransports(new Transport[]{transport});
        this.server.setDirectoryService(this.service);
        this.server.start();
    }

    public void startServer(int port) throws Exception {
        this.serverPort = port;
        this.startServer();
    }

    public void startServer(String address, int port) throws Exception {
        this.serverAddress = address;
        this.serverPort = port;
        this.startServer();
    }

    public boolean isServerStarted() {
        LdapServer server = this.server;
        return server != null && server.isStarted();
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void addAttribute(String dn, String attrName, String attrValue) throws Exception {
        DefaultClientAttribute attr = new DefaultClientAttribute(attrName, new String[]{attrValue});
        ClientModification addValue = new ClientModification(ModificationOperation.ADD_ATTRIBUTE, (EntryAttribute)attr);
        this.service.getAdminSession().modify(new DN(dn), Collections.singletonList(addValue));
    }

    public void removeAttribute(String dn, String attrName, String attrValue) throws Exception {
        DefaultClientAttribute attr = new DefaultClientAttribute(attrName, new String[]{attrValue});
        ClientModification removeValue = new ClientModification(ModificationOperation.REMOVE_ATTRIBUTE, (EntryAttribute)attr);
        this.service.getAdminSession().modify(new DN(dn), Collections.singletonList(removeValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        LdapServer server = this.server;
        if (server != null && server.isStarted()) {
            server.stop();
        }
        try {
            this.service.shutdown();
        }
        finally {
            FileUtils.deleteQuietly((File)this.service.getWorkingDirectory());
            instance = null;
        }
    }

    static {
        instLock = new Object();
    }
}

