/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.security;

import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.auth.callback.UserAuthenticator;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TablePermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ScanQualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.LDAPAuthenticationSchemeImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GranteeIterator;
import com.pivotal.gemfirexd.jdbc.JUnit4TestBase;
import com.pivotal.gemfirexd.security.LdapTestServer;
import com.pivotal.gemfirexd.security.SecurityTestUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import javax.naming.NameNotFoundException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LdapGroupAuthTest
extends JUnit4TestBase {
    private static final String sysUser = "gemfire10";
    private static int netPort;
    private static final Connection[] conns;
    private static final Statement[] stmts;

    @BeforeClass
    public static void startServer() throws Exception {
        Properties bootProperties = SecurityTestUtils.startLdapServerAndGetBootProperties(0, 0, sysUser);
        TestUtil.setupConnection(bootProperties, LdapGroupAuthTest.class);
        netPort = TestUtil.startNetserverAndReturnPort();
        TestUtil.currentUserName = sysUser;
        TestUtil.currentUserPassword = sysUser;
        TestUtil.bootUserName = sysUser;
        TestUtil.bootUserPassword = sysUser;
    }

    @AfterClass
    public static void stopServer() throws Exception {
        SQLException failure = LdapGroupAuthTest.closeStatements(conns, stmts);
        LdapGroupAuthTest.classTearDown();
        TestUtil.shutDown();
        netPort = 0;
        LdapTestServer server = LdapTestServer.getInstance();
        if (server.isServerStarted()) {
            server.stopService();
        }
        if (failure != null) {
            throw failure;
        }
    }

    @Test
    public void ldapGroupMembers() throws Exception {
        HashSet<String> expectedGroup1Members = new HashSet<String>(Arrays.asList("GEMFIRE1", "GEMFIRE2", "GEMFIRE3"));
        HashSet<String> expectedGroup2Members = new HashSet<String>(Arrays.asList("GEMFIRE3", "GEMFIRE4", "GEMFIRE5"));
        HashSet<String> expectedGroup3Members = new HashSet<String>(Arrays.asList("GEMFIRE6", "GEMFIRE7", "GEMFIRE8"));
        HashSet<String> expectedGroup4Members = new HashSet<String>(Arrays.asList("GEMFIRE1", "GEMFIRE3", "GEMFIRE9"));
        HashSet<String> expectedGroup5Members = new HashSet<String>(Arrays.asList("GEMFIRE4", "GEMFIRE6", "GEMFIRE7", "GEMFIRE8"));
        HashSet<String> expectedGroup6Members = new HashSet<String>(Arrays.asList("GEMFIRE2", "GEMFIRE6", "GEMFIRE1", "GEMFIRE3", "GEMFIRE9"));
        Set expectedGroup7Members = Collections.emptySet();
        Set<String> group1Members = this.getLdapGroupMembers("gemGroup1");
        Assert.assertEquals(expectedGroup1Members, group1Members);
        Set<String> group2Members = this.getLdapGroupMembers("GemGroup2");
        Assert.assertEquals(expectedGroup2Members, group2Members);
        Set<String> group3Members = this.getLdapGroupMembers("GEMGROUP3");
        Assert.assertEquals(expectedGroup3Members, group3Members);
        Set<String> group4Members = this.getLdapGroupMembers("gemGroup4");
        Assert.assertEquals(expectedGroup4Members, group4Members);
        Set<String> group5Members = this.getLdapGroupMembers("gemGroup5");
        Assert.assertEquals(expectedGroup5Members, group5Members);
        Set<String> group6Members = this.getLdapGroupMembers("gemgroup6");
        Assert.assertEquals(expectedGroup6Members, group6Members);
        Set<String> group7Members = this.getLdapGroupMembers("gemgroup7");
        Assert.assertEquals(expectedGroup7Members, group7Members);
    }

    @Test
    public void ldapADGroupMembers() throws Exception {
        LdapGroupAuthTest.stopServer();
        Properties bootProperties = SecurityTestUtils.startLdapServerAndGetBootProperties(0, 0, sysUser, TestUtil.getResourcesDir() + "/lib/ldap/authAD.ldif");
        bootProperties.setProperty("gemfirexd.auth-ldap-search-filter", "(&(objectClass=inetOrgPerson)(givenName=%USERNAME%))");
        TestUtil.setupConnection(bootProperties, LdapGroupAuthTest.class);
        HashSet<String> expectedGroup1Members = new HashSet<String>(Arrays.asList("GEMFIRE1", "GEMFIRE2", "GEMFIRE3"));
        HashSet<String> expectedGroup2Members = new HashSet<String>(Arrays.asList("GEMFIRE3", "GEMFIRE4", "GEMFIRE5"));
        HashSet<String> expectedGroup3Members = new HashSet<String>(Arrays.asList("GEMFIRE6", "GEMFIRE7", "GEMFIRE8"));
        HashSet<String> expectedGroup4Members = new HashSet<String>(Arrays.asList("GEMFIRE1", "GEMFIRE3", "GEMFIRE9"));
        HashSet<String> expectedGroup5Members = new HashSet<String>(Arrays.asList("GEMFIRE4", "GEMFIRE6", "GEMFIRE7", "GEMFIRE8"));
        HashSet<String> expectedGroup6Members = new HashSet<String>(Arrays.asList("GEMFIRE2", "GEMFIRE6", "GEMFIRE1", "GEMFIRE3", "GEMFIRE9"));
        Set expectedGroup7Members = Collections.emptySet();
        Set<String> group1Members = this.getLdapGroupMembers("gemGroup1");
        Assert.assertEquals(expectedGroup1Members, group1Members);
        Set<String> group2Members = this.getLdapGroupMembers("GemGroup2");
        Assert.assertEquals(expectedGroup2Members, group2Members);
        Set<String> group3Members = this.getLdapGroupMembers("GEMGROUP3");
        Assert.assertEquals(expectedGroup3Members, group3Members);
        Set<String> group4Members = this.getLdapGroupMembers("gemGroup4");
        Assert.assertEquals(expectedGroup4Members, group4Members);
        Set<String> group5Members = this.getLdapGroupMembers("gemGroup5");
        Assert.assertEquals(expectedGroup5Members, group5Members);
        Set<String> group6Members = this.getLdapGroupMembers("gemgroup6");
        Assert.assertEquals(expectedGroup6Members, group6Members);
        Set<String> group7Members = this.getLdapGroupMembers("gemgroup7");
        Assert.assertEquals(expectedGroup7Members, group7Members);
        LdapGroupAuthTest.stopServer();
        LdapGroupAuthTest.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void grantRevokeTraverseGroupPermissions() throws Exception {
        Properties props = new Properties();
        SecurityTestUtils.setUserProps("gemfire9", props);
        EmbedConnection conn = (EmbedConnection)TestUtil.getConnection(props);
        Statement stmt = conn.createStatement();
        LanguageConnectionContext lcc = conn.getLanguageConnection();
        conn.getTR().setupContextStack();
        DataDictionaryImpl dd = (DataDictionaryImpl)lcc.getDataDictionary();
        try {
            stmt.execute("create table test1 (id1 int primary key, v1 int)");
            lcc.beginNestedTransaction(true);
            TransactionController tc = lcc.getTransactionCompile();
            SchemaDescriptor sd = dd.getSchemaDescriptor("GEMFIRE9", tc, true);
            TableDescriptor td = dd.getTableDescriptor("TEST1", sd, tc);
            TablePermsDescriptor perm = new TablePermsDescriptor((DataDictionary)dd, null, sysUser, td.getUUID(), "N", "N", "y", "N", "N", "N", "N");
            List<String> grantees = Arrays.asList("GEMFIRE1", "LDAPGROUP:GEMGROUP3");
            GranteeIterator iter = new GranteeIterator(grantees, (PermissionsDescriptor)perm, true, 16, 2, 12, (DataDictionary)dd, tc);
            this.checkGrantees(iter, "GEMFIRE1", null, "LDAPGROUP:GEMGROUP3", "GEMGROUP3", "GEMFIRE8", "GEMGROUP3", "GEMFIRE7", "GEMGROUP3", "GEMFIRE6", "GEMGROUP3");
            grantees = Arrays.asList("GEMFIRE3", "LDAPGROUP:GEMGROUP2");
            iter = new GranteeIterator(grantees, (PermissionsDescriptor)perm, true, 16, 2, 12, (DataDictionary)dd, tc);
            this.checkGrantees(iter, "GEMFIRE3", null, "LDAPGROUP:GEMGROUP2", "GEMGROUP2", "GEMFIRE3", "GEMGROUP2", "GEMFIRE4", "GEMGROUP2", "GEMFIRE5", "GEMGROUP2");
            grantees = Arrays.asList("LDAPGROUP:GEMGROUP1", "GEMFIRE2", "GEMFIRE5");
            iter = new GranteeIterator(grantees, (PermissionsDescriptor)perm, true, 16, 2, 12, (DataDictionary)dd, tc);
            this.checkGrantees(iter, "LDAPGROUP:GEMGROUP1", "GEMGROUP1", "GEMFIRE1", "GEMGROUP1", "GEMFIRE2", "GEMGROUP1", "GEMFIRE3", "GEMGROUP1", "GEMFIRE2", null, "GEMFIRE5", null);
            grantees = Arrays.asList("GEMFIRE5", "LDAPGROUP:GEMGROUP3", "GEMFIRE6");
            iter = new GranteeIterator(grantees, (PermissionsDescriptor)perm, true, 16, 2, 12, (DataDictionary)dd, tc);
            this.checkGrantees(iter, "GEMFIRE5", null, "LDAPGROUP:GEMGROUP3", "GEMGROUP3", "GEMFIRE6", "GEMGROUP3", "GEMFIRE7", "GEMGROUP3", "GEMFIRE8", "GEMGROUP3", "GEMFIRE6", null);
            grantees = Arrays.asList("GEMGROUP2:GEMFIRE5", "GEMFIRE2", "LDAPGROUP:GEMGROUP3", "GEMGROUP7:GEMFIRE8", "GEMFIRE6");
            iter = new GranteeIterator(grantees, (PermissionsDescriptor)perm, true, 16, 2, 12, (DataDictionary)dd, tc);
            this.checkGrantees(iter, "GEMFIRE5", "GEMGROUP2", "GEMFIRE2", null, "LDAPGROUP:GEMGROUP3", "GEMGROUP3", "GEMFIRE6", "GEMGROUP3", "GEMFIRE7", "GEMGROUP3", "GEMFIRE8", "GEMGROUP3", "GEMFIRE8", "GEMGROUP7", "GEMFIRE6", null);
            stmt.execute("grant insert on table test1 to gemfire1, ldapGroup: gemGroup3");
            stmt.execute("grant select on table test1 to gemfire3, ldapGroup: gemGroup2");
            stmt.execute("grant update on table test1 to ldapGroup: gemGroup1, gemfire2, gemfire5");
            stmt.execute("grant delete on table test1 to gemfire5, ldapGroup:gemGroup3, gemfire6");
            grantees = Arrays.asList("GEMFIRE1", "LDAPGROUP:GEMGROUP3");
            iter = new GranteeIterator(grantees, (PermissionsDescriptor)perm, false, 16, 2, 12, (DataDictionary)dd, tc);
            this.checkGrantees(iter, "GEMFIRE1", null, "LDAPGROUP:GEMGROUP3", "GEMGROUP3", "GEMFIRE8", "GEMGROUP3", "GEMFIRE7", "GEMGROUP3");
            perm = new TablePermsDescriptor((DataDictionary)dd, null, sysUser, td.getUUID(), "y", "N", "N", "N", "N", "N", "N");
            grantees = Arrays.asList("GEMFIRE3", "LDAPGROUP:GEMGROUP2");
            iter = new GranteeIterator(grantees, (PermissionsDescriptor)perm, false, 16, 2, 12, (DataDictionary)dd, tc);
            this.checkGrantees(iter, "GEMFIRE3", null, "LDAPGROUP:GEMGROUP2", "GEMGROUP2", "GEMFIRE4", "GEMGROUP2");
            perm = new TablePermsDescriptor((DataDictionary)dd, null, sysUser, td.getUUID(), "N", "N", "N", "y", "N", "N", "N");
            grantees = Arrays.asList("LDAPGROUP:GEMGROUP1", "GEMFIRE2", "GEMFIRE5");
            iter = new GranteeIterator(grantees, (PermissionsDescriptor)perm, false, 16, 2, 12, (DataDictionary)dd, tc);
            this.checkGrantees(iter, "LDAPGROUP:GEMGROUP1", "GEMGROUP1", "GEMFIRE2", null, "GEMFIRE5", null);
            grantees = Arrays.asList("LDAPGROUP:GEMGROUP1");
            iter = new GranteeIterator(grantees, (PermissionsDescriptor)perm, false, 16, 2, 12, (DataDictionary)dd, tc);
            this.checkGrantees(iter, "LDAPGROUP:GEMGROUP1", "GEMGROUP1");
            perm = new TablePermsDescriptor((DataDictionary)dd, null, sysUser, td.getUUID(), "N", "y", "N", "N", "N", "N", "N");
            grantees = Arrays.asList("GEMFIRE5", "LDAPGROUP:GEMGROUP3", "GEMFIRE6");
            iter = new GranteeIterator(grantees, (PermissionsDescriptor)perm, false, 16, 2, 12, (DataDictionary)dd, tc);
            this.checkGrantees(iter, "GEMFIRE5", null, "LDAPGROUP:GEMGROUP3", "GEMGROUP3", "GEMFIRE7", "GEMGROUP3", "GEMFIRE8", "GEMGROUP3", "GEMFIRE6", null);
            ArrayList<PermissionsDescriptor> outDescriptors = new ArrayList<PermissionsDescriptor>();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP1", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[][]{{"LDAPGROUP:GEMGROUP1", "GEMGROUP1", "N", "N", "N", "N", "N", "N", "y"}});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP2", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, {"GEMFIRE4", "GEMGROUP2", "N", "N", "N", "N", "y", "N", "N"}, {"LDAPGROUP:GEMGROUP2", "GEMGROUP2", "N", "N", "N", "N", "y", "N", "N"});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP3", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, {"GEMFIRE7", "GEMGROUP3", "N", "y", "y", "N", "N", "N", "N"}, {"GEMFIRE8", "GEMGROUP3", "N", "y", "y", "N", "N", "N", "N"}, {"LDAPGROUP:GEMGROUP3", "GEMGROUP3", "N", "y", "y", "N", "N", "N", "N"});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP4", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP5", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            stmt.execute("revoke insert on table test1 from ldapGroup: gemGroup3, ldapGroup: gemGroup1");
            stmt.execute("revoke select on table test1 from gemfire3, gemfire4");
            stmt.execute("revoke update on table test1 from ldapGroup: gemGroup1, gemfire5");
            stmt.execute("revoke delete on table test1 from gemfire6, ldapGroup:gemGroup3, gemfire5");
            outDescriptors.clear();
            TabInfoImpl ti = dd.getNonCoreTI(16);
            ScanQualifier[][] qualifier = dd.getExecutionFactory().getScanQualifier(1);
            qualifier[0][0].setQualifier(3, null, (DataValueDescriptor)new SQLChar(td.getUUID().toString()), 2, false, false, false);
            dd.getDescriptorViaHeap(qualifier, ti, null, outDescriptors);
            this.checkTablePermissions(outDescriptors, {"GEMFIRE1", null, "N", "N", "y", "N", "N", "N", "y"}, {"GEMFIRE2", null, "N", "N", "N", "N", "N", "N", "y"}, {"GEMFIRE3", null, "N", "N", "N", "N", "N", "N", "y"}, {"GEMFIRE5", null, "N", "N", "N", "N", "y", "N", "N"}, {"GEMFIRE6", null, "N", "N", "y", "N", "N", "N", "N"}, {"LDAPGROUP:GEMGROUP2", "GEMGROUP2", "N", "N", "N", "N", "y", "N", "N"});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP1", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP2", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[][]{{"LDAPGROUP:GEMGROUP2", "GEMGROUP2", "N", "N", "N", "N", "y", "N", "N"}});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP3", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP4", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP5", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
        }
        finally {
            stmt.execute("drop table test1");
            stmt.close();
            lcc.commitNestedTransaction();
            conn.getTR().restoreContextStack();
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshLdapGroup() throws Exception {
        Statement stmt;
        EmbedConnection conn;
        Statement sysStmt;
        Connection sysConn;
        block8: {
            Properties props = new Properties();
            SecurityTestUtils.setUserProps(sysUser, props);
            sysConn = TestUtil.getConnection(props);
            sysStmt = sysConn.createStatement();
            SecurityTestUtils.setUserProps("gemfire9", props);
            conn = (EmbedConnection)TestUtil.getConnection(props);
            stmt = conn.createStatement();
            try {
                stmt.execute("call SYS.REFRESH_LDAP_GROUP('gemGroup5')");
            }
            catch (SQLException sqle) {
                if ("42504".equals(sqle.getSQLState())) break block8;
                throw sqle;
            }
        }
        sysStmt.execute("grant execute on PROCEDURE SYS.REFRESH_LDAP_GROUP to gemfire9");
        LanguageConnectionContext lcc = conn.getLanguageConnection();
        conn.getTR().setupContextStack();
        DataDictionaryImpl dd = (DataDictionaryImpl)lcc.getDataDictionary();
        try {
            stmt.execute("create table test1 (id1 int primary key, v1 int)");
            lcc.beginNestedTransaction(true);
            TransactionController tc = lcc.getTransactionCompile();
            ArrayList<PermissionsDescriptor> outDescriptors = new ArrayList<PermissionsDescriptor>();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP3", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP5", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP7", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP3", 18, 6, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP5", 18, 6, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP7", 18, 6, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[0][]);
            stmt.execute("grant insert on table test1 to ldapGroup: gemGroup3, gemfire1");
            stmt.execute("grant select on table test1 to gemfire3, ldapGroup: gemGroup5");
            stmt.execute("grant delete on table test1 to ldapGroup: gemGroup3");
            stmt.execute("grant update on table test1 to ldapGroup: gemGroup7, gemfire3");
            sysStmt.execute("grant execute on procedure SYS.DROP_USER to ldapGroup: gemGroup7");
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP3", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, {"GEMFIRE6", "GEMGROUP3", "N", "y", "y", "N", "y", "N", "N"}, {"GEMFIRE7", "GEMGROUP3", "N", "y", "y", "N", "y", "N", "N"}, {"GEMFIRE8", "GEMGROUP3", "N", "y", "y", "N", "y", "N", "N"}, {"LDAPGROUP:GEMGROUP3", "GEMGROUP3", "N", "y", "y", "N", "N", "N", "N"});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP5", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, {"GEMFIRE4", "GEMGROUP5", "N", "N", "N", "N", "y", "N", "N"}, {"LDAPGROUP:GEMGROUP5", "GEMGROUP5", "N", "N", "N", "N", "y", "N", "N"});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP7", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[][]{{"LDAPGROUP:GEMGROUP7", "GEMGROUP7", "N", "N", "N", "N", "N", "N", "y"}});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP7", 18, 6, tc, outDescriptors);
            this.checkRoutinePermissions(outDescriptors, new String[][]{{"LDAPGROUP:GEMGROUP7", "GEMGROUP7"}});
            stmt.execute("call SYS.REFRESH_LDAP_GROUP('gemGroup3')");
            stmt.execute("call SYS.REFRESH_LDAP_GROUP('gemGroup7')");
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP3", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, {"GEMFIRE6", "GEMGROUP3", "N", "y", "y", "N", "y", "N", "N"}, {"GEMFIRE7", "GEMGROUP3", "N", "y", "y", "N", "y", "N", "N"}, {"GEMFIRE8", "GEMGROUP3", "N", "y", "y", "N", "y", "N", "N"}, {"LDAPGROUP:GEMGROUP3", "GEMGROUP3", "N", "y", "y", "N", "N", "N", "N"});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP5", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, {"GEMFIRE4", "GEMGROUP5", "N", "N", "N", "N", "y", "N", "N"}, {"LDAPGROUP:GEMGROUP5", "GEMGROUP5", "N", "N", "N", "N", "y", "N", "N"});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP7", 16, 12, tc, outDescriptors);
            this.checkTablePermissions(outDescriptors, new String[][]{{"LDAPGROUP:GEMGROUP7", "GEMGROUP7", "N", "N", "N", "N", "N", "N", "y"}});
            outDescriptors.clear();
            dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP7", 18, 6, tc, outDescriptors);
            this.checkRoutinePermissions(outDescriptors, new String[][]{{"LDAPGROUP:GEMGROUP7", "GEMGROUP7"}});
            LdapTestServer server = LdapTestServer.getInstance();
            server.removeAttribute("cn=gemGroup3,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "uniqueMember", "uid=gemfire8,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            server.addAttribute("cn=gemGroup3,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "uniqueMember", "uid=gemfire5,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            server.addAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "uid=gemfire3,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            server.addAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "cn=gemGroup1,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            server.addAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "uid=gemfire5,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            try {
                HashSet<String> expectedGroup3Members = new HashSet<String>(Arrays.asList("GEMFIRE5", "GEMFIRE6", "GEMFIRE7"));
                Set<String> group3Members = this.getLdapGroupMembers("gemgroup3");
                Assert.assertEquals(expectedGroup3Members, group3Members);
                HashSet<String> expectedGroup7Members = new HashSet<String>(Arrays.asList("GEMFIRE3", "GEMFIRE1", "GEMFIRE2", "GEMFIRE5"));
                Set<String> group7Members = this.getLdapGroupMembers("gemgroup7");
                Assert.assertEquals(expectedGroup7Members, group7Members);
                stmt.execute("call SYS.REFRESH_LDAP_GROUP('gemGroup3')");
                sysStmt.execute("call SYS.REFRESH_LDAP_GROUP('gemGroup7')");
                outDescriptors.clear();
                dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP3", 16, 12, tc, outDescriptors);
                this.checkTablePermissions(outDescriptors, {"GEMFIRE6", "GEMGROUP3", "N", "y", "y", "N", "y", "N", "N"}, {"GEMFIRE7", "GEMGROUP3", "N", "y", "y", "N", "y", "N", "N"}, {"GEMFIRE5", "GEMGROUP3", "N", "y", "y", "N", "N", "N", "y"}, {"GEMFIRE8", "GEMGROUP3", "N", "N", "N", "N", "y", "N", "N"}, {"LDAPGROUP:GEMGROUP3", "GEMGROUP3", "N", "y", "y", "N", "N", "N", "N"});
                outDescriptors.clear();
                dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP5", 16, 12, tc, outDescriptors);
                this.checkTablePermissions(outDescriptors, {"GEMFIRE4", "GEMGROUP5", "N", "N", "N", "N", "y", "N", "N"}, {"LDAPGROUP:GEMGROUP5", "GEMGROUP5", "N", "N", "N", "N", "y", "N", "N"});
                outDescriptors.clear();
                dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP7", 16, 12, tc, outDescriptors);
                this.checkTablePermissions(outDescriptors, {"GEMFIRE2", "GEMGROUP7", "N", "N", "N", "N", "N", "N", "y"}, {"LDAPGROUP:GEMGROUP7", "GEMGROUP7", "N", "N", "N", "N", "N", "N", "y"});
                outDescriptors.clear();
                dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP7", 18, 6, tc, outDescriptors);
                this.checkRoutinePermissions(outDescriptors, {"GEMFIRE1", "GEMGROUP7"}, {"GEMFIRE2", "GEMGROUP7"}, {"GEMFIRE3", "GEMGROUP7"}, {"GEMFIRE5", "GEMGROUP7"}, {"LDAPGROUP:GEMGROUP7", "GEMGROUP7"});
                sysStmt.execute("revoke execute on procedure SYS.DROP_USER from ldapGroup: gemGroup7 restrict");
                outDescriptors.clear();
                dd.getAllLDAPDescriptorsHavingPermissions("GEMGROUP7", 18, 6, tc, outDescriptors);
                this.checkRoutinePermissions(outDescriptors, new String[0][]);
            }
            finally {
                server.addAttribute("cn=gemGroup3,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "uniqueMember", "uid=gemfire8,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
                server.removeAttribute("cn=gemGroup3,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "uniqueMember", "uid=gemfire5,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
                server.removeAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "uid=gemfire3,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
                server.removeAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "cn=gemGroup1,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
                server.removeAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "uid=gemfire5,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            }
        }
        finally {
            sysStmt.execute("revoke execute on PROCEDURE SYS.REFRESH_LDAP_GROUP from gemfire9 restrict");
            sysStmt.execute("revoke execute on PROCEDURE SYS.REFRESH_LDAP_GROUP from gemfire9 restrict");
            sysStmt.execute("revoke execute on procedure SYS.DROP_USER from ldapGroup: gemGroup7 restrict");
            sysStmt.execute("drop table gemfire9.test1");
            sysStmt.close();
            sysConn.close();
            stmt.close();
            conn.getTR().restoreContextStack();
            conn.close();
        }
    }

    @Test
    public void groupAuthAddRemove() throws Exception {
        LdapGroupAuthTest.checkGroupAuthAddRemove(netPort, conns, stmts);
    }

    @Test
    public void groupAuthRefresh() throws Exception {
        LdapGroupAuthTest.checkGroupAuthRefresh(netPort, conns, stmts);
    }

    public static void createStatements(int numStmts, int netPort, Connection[] conns, Statement[] stmts) throws SQLException {
        Properties props = new Properties();
        for (int i = 0; i < numStmts; ++i) {
            SecurityTestUtils.setUserProps("gemfire" + (i + 1), props);
            if (stmts[i] != null) {
                try {
                    stmts[i].close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (conns[i] != null) {
                try {
                    conns[i].rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    conns[i].close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            conns[i] = TestUtil.getNetConnection(netPort, null, props);
            stmts[i] = conns[i].createStatement();
        }
    }

    public static SQLException closeStatements(Connection[] conns, Statement[] stmts) throws SQLException {
        int i;
        SQLException failure = null;
        for (i = 0; i < stmts.length; ++i) {
            Statement stmt = stmts[i];
            if (stmt == null) continue;
            try {
                stmt.getConnection().commit();
                stmt.close();
            }
            catch (SQLException sqle) {
                failure = sqle;
            }
            stmts[i] = null;
        }
        for (i = 0; i < conns.length; ++i) {
            Connection conn = conns[i];
            if (conn == null) continue;
            try {
                conn.rollback();
                conn.close();
            }
            catch (SQLException sqle) {
                failure = sqle;
            }
            conns[i] = null;
        }
        return failure;
    }

    private Set<String> getLdapGroupMembers(String ldapGroup) throws Exception {
        UserAuthenticator auth = ((AuthenticationServiceBase)Misc.getMemStoreBooting().getDatabase().getAuthenticationService()).getAuthenticationScheme();
        if (!(auth instanceof LDAPAuthenticationSchemeImpl)) {
            throw new NameNotFoundException("Require LDAP authentication scheme for LDAP group support but is " + auth);
        }
        LDAPAuthenticationSchemeImpl ldapAuth = (LDAPAuthenticationSchemeImpl)auth;
        return ldapAuth.getLDAPGroupMembers(ldapGroup);
    }

    private void checkGrantees(GranteeIterator granteeIter, String ... expectedGrantees) {
        LinkedList<String> expected = new LinkedList<String>(Arrays.asList(expectedGrantees));
        while (granteeIter.hasNext()) {
            String grantee = granteeIter.next();
            String group = granteeIter.getCurrentLdapGroup();
            ListIterator expectedIter = expected.listIterator();
            while (expectedIter.hasNext()) {
                String expectedGrantee = (String)expectedIter.next();
                String expectedGroup = (String)expectedIter.next();
                if (!grantee.equals(expectedGrantee) || !ArrayUtils.objectEquals((Object)granteeIter.getCurrentLdapGroup(), (Object)expectedGroup)) continue;
                grantee = null;
                expectedIter.previous();
                expectedIter.previous();
                expectedIter.remove();
                expectedIter.next();
                expectedIter.remove();
                break;
            }
            if (grantee == null) continue;
            Assert.fail((String)("Failed to find grantee=" + grantee + " group=" + group + " among expected: " + expected));
        }
        if (!expected.isEmpty()) {
            Assert.fail((String)("No match found for expected elements: " + expected));
        }
    }

    private void checkTablePermissions(List<PermissionsDescriptor> descs, String[] ... expectedGrantees) {
        if (descs.size() != expectedGrantees.length) {
            Assert.fail((String)("Expected " + expectedGrantees.length + " descriptors " + Arrays.deepToString((Object[])expectedGrantees) + ", got: " + descs));
        }
        HashMap<String, String[]> granteePerms = new HashMap<String, String[]>(expectedGrantees.length);
        for (String[] e : expectedGrantees) {
            granteePerms.put(e[0], e);
        }
        for (PermissionsDescriptor perm : descs) {
            TablePermsDescriptor desc = (TablePermsDescriptor)perm;
            String[] perms = (String[])granteePerms.get(desc.getGrantee());
            if (perms[1] == null) {
                Assert.assertNull((Object)desc.getLdapGroup());
            } else {
                Assert.assertEquals((Object)perms[1], (Object)desc.getLdapGroup());
            }
            Assert.assertEquals((Object)perms[2], (Object)desc.getAlterPriv());
            Assert.assertEquals((Object)perms[3], (Object)desc.getDeletePriv());
            Assert.assertEquals((Object)perms[4], (Object)desc.getInsertPriv());
            Assert.assertEquals((Object)perms[5], (Object)desc.getReferencesPriv());
            Assert.assertEquals((Object)perms[6], (Object)desc.getSelectPriv());
            Assert.assertEquals((Object)perms[7], (Object)desc.getTriggerPriv());
            Assert.assertEquals((Object)perms[8], (Object)desc.getUpdatePriv());
        }
    }

    private void checkRoutinePermissions(List<PermissionsDescriptor> descs, String[] ... expectedGrantees) {
        if (descs.size() != expectedGrantees.length) {
            Assert.fail((String)("Expected " + expectedGrantees.length + " descriptors " + Arrays.deepToString((Object[])expectedGrantees) + ", got: " + descs));
        }
        HashMap<String, String[]> granteePerms = new HashMap<String, String[]>(expectedGrantees.length);
        for (String[] e : expectedGrantees) {
            granteePerms.put(e[0], e);
        }
        for (PermissionsDescriptor desc : descs) {
            String[] perms = (String[])granteePerms.get(desc.getGrantee());
            if (perms[1] == null) {
                Assert.assertNull((Object)desc.getLdapGroup());
                continue;
            }
            Assert.assertEquals((Object)perms[1], (Object)desc.getLdapGroup());
        }
    }

    public static void checkAuthzFailure(String sql, Statement stmt) throws SQLException {
        block2: {
            try {
                stmt.execute(sql);
                Assert.fail((String)"expected to fail with authorization exception");
            }
            catch (SQLException sqle) {
                if ("42500".equals(sqle.getSQLState()) || "42502".equals(sqle.getSQLState()) || "42504".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
    }

    public static void checkGroupAuthAddRemove(int netPort, Connection[] conns, Statement[] stmts) throws Exception {
        Statement sysStmt;
        Connection sysConn;
        block14: {
            block13: {
                Statement ostmt;
                block12: {
                    block11: {
                        block10: {
                            try {
                                DriverManager.getConnection(TestUtil.getNetProtocol(SocketCreator.getLocalHost().getHostName(), netPort));
                                Assert.fail((String)"expected connection failure with no credentials");
                            }
                            catch (SQLException sqle) {
                                if ("08004".equals(sqle.getSQLState())) break block10;
                                throw sqle;
                            }
                        }
                        Properties props = new Properties();
                        SecurityTestUtils.setUserProps(sysUser, props);
                        sysConn = TestUtil.getConnection(props);
                        sysStmt = sysConn.createStatement();
                        LdapGroupAuthTest.createStatements(8, netPort, conns, stmts);
                        ostmt = stmts[6];
                        ostmt.execute("create table gemfire7.test1 (id1 int primary key, v1 int)");
                        ostmt.execute("create table gemfire7.test2 (id2 int, v2 varchar(10))");
                        ostmt.execute("insert into gemfire7.test2 values (5, 'v5')");
                        LdapGroupAuthTest.checkAuthzFailure("insert into gemfire7.test1 values (1, 1), (2, 2)", stmts[0]);
                        LdapGroupAuthTest.checkAuthzFailure("update gemfire7.test2 set v2='v5_1' where id2=5", stmts[1]);
                        LdapGroupAuthTest.checkAuthzFailure("delete from gemfire7.test2", stmts[2]);
                        try {
                            ostmt.execute("grant insert on table gemfire7.test1 to gemfire1, ldapGroup: nogroup");
                            Assert.fail((String)"expected failure when granting on a non-existent group");
                        }
                        catch (SQLException sqle) {
                            if ("4251B".equals(sqle.getSQLState())) break block11;
                            throw sqle;
                        }
                    }
                    LdapGroupAuthTest.checkAuthzFailure("delete from gemfire7.test2 where id2=5", stmts[0]);
                    LdapGroupAuthTest.checkAuthzFailure("update gemfire7.test2 set v2='v5_1' where id2=5", stmts[2]);
                    ostmt.execute("grant insert on table gemfire7.test1 to gemfire1, ldapGroup: gemGroup2");
                    ostmt.execute("grant insert on table gemfire7.test2 to ldapGroup : gemGroup1, gemfire4");
                    stmts[0].execute("insert into gemfire7.test1 values (1, 1), (2, 2)");
                    stmts[2].execute("insert into gemfire7.test2 values (1, 'v1'), (2, 'v2')");
                    try {
                        stmts[3].execute("insert into gemfire7.test1 values (1, 1), (2, 2)");
                        Assert.fail((String)"expected primary key constraint violation");
                    }
                    catch (SQLException sqle) {
                        if ("23505".equals(sqle.getSQLState())) break block12;
                        throw sqle;
                    }
                }
                stmts[3].execute("insert into gemfire7.test2 values (2, 'v2'), (3, 'v3')");
                stmts[4].execute("insert into gemfire7.test1 values (3, 3), (4, 4)");
                LdapGroupAuthTest.checkAuthzFailure("update gemfire7.test1 set v1=2 where id1=1", stmts[0]);
                LdapGroupAuthTest.checkAuthzFailure("delete from gemfire7.test1", stmts[1]);
                LdapGroupAuthTest.checkAuthzFailure("update gemfire7.test2 set v2='v2_1' where v2='v2'", stmts[2]);
                LdapGroupAuthTest.checkAuthzFailure("alter table gemfire7.test1 add column c1 double", stmts[3]);
                LdapGroupAuthTest.checkAuthzFailure("alter table gemfire7.test2 add column c1 bigint", stmts[4]);
                LdapGroupAuthTest.checkAuthzFailure("select * from gemfire7.test1", stmts[5]);
                LdapGroupAuthTest.checkAuthzFailure("select * from gemfire7.test2 where id2 > 1", stmts[3]);
                ostmt.execute("grant alter on gemfire7.test1 to gemfire8, ldapGroup: gemGroup3, gemfire4");
                stmts[3].execute("alter table gemfire7.test1 add column c1 double");
                stmts[6].execute("alter table gemfire7.test2 add column c1 bigint");
                stmts[5].execute("alter table gemfire7.test1 add column c2 bigint");
                stmts[5].execute("alter table gemfire7.test1 drop column c1");
                stmts[7].execute("alter table gemfire7.test1 drop column c2");
                stmts[7].execute("alter table gemfire7.test1 add column c2 bigint");
                stmts[3].execute("alter table gemfire7.test1 add column c1 double");
                LdapGroupAuthTest.checkAuthzFailure("alter table gemfire7.test2 drop column c1", stmts[2]);
                LdapGroupAuthTest.checkAuthzFailure("alter table gemfire7.test1 drop column c1", stmts[2]);
                LdapGroupAuthTest.checkAuthzFailure("alter table gemfire7.test1 drop column c2", stmts[0]);
                LdapGroupAuthTest.checkAuthzFailure("alter table gemfire7.test1 drop column c1", stmts[1]);
                LdapGroupAuthTest.checkAuthzFailure("alter table gemfire7.test1 drop column c2", stmts[4]);
                stmts[3].execute("alter table gemfire7.test1 drop column c2");
                stmts[5].execute("alter table gemfire7.test1 drop column c1");
                LdapGroupAuthTest.checkAuthzFailure("alter table gemfire7.test2 drop column c1", stmts[3]);
                LdapGroupAuthTest.checkAuthzFailure("alter table gemfire7.test2 drop column c1", stmts[5]);
                LdapGroupAuthTest.checkAuthzFailure("alter table gemfire7.test2 drop column c1", stmts[7]);
                stmts[6].execute("alter table gemfire7.test2 drop column c1");
                ostmt.execute("revoke insert on gemfire7.test1 from ldapGroup : gemGroup2");
                stmts[0].execute("insert into gemfire7.test1 values (5, 5), (6, 6)");
                try {
                    stmts[3].execute("insert into gemfire7.test1 values (5, 5), (6, 6)");
                    Assert.fail((String)"expected primary key constraint violation");
                }
                catch (SQLException sqle) {
                    if ("23505".equals(sqle.getSQLState())) break block13;
                    throw sqle;
                }
            }
            stmts[3].execute("insert into gemfire7.test1 values (8, 8), (9, 9)");
            LdapGroupAuthTest.checkAuthzFailure("update gemfire7.test1 set v1=2 where id1=2", stmts[0]);
            LdapGroupAuthTest.checkAuthzFailure("insert into gemfire7.test1 values (5, 5), (6, 6)", stmts[2]);
            LdapGroupAuthTest.checkAuthzFailure("insert into gemfire7.test1 values (5, 5), (6, 6)", stmts[4]);
            LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire8')", stmts[0]);
            try {
                sysStmt.execute("grant execute on procedure sys.drop_user to gemfire7, ldapGroup: nogroup");
                Assert.fail((String)"expected failure when granting on a non-existent group");
            }
            catch (SQLException sqle) {
                if ("4251B".equals(sqle.getSQLState())) break block14;
                throw sqle;
            }
        }
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire8')", stmts[0]);
        sysStmt.execute("grant execute on procedure sys.drop_user to gemfire7, ldapGroup: gemGroup2");
        stmts[2].execute("call sys.drop_user('gemfire8')");
        stmts[3].execute("call sys.drop_user('gemfire9')");
        stmts[4].execute("call sys.drop_user('gemfire1')");
        stmts[6].execute("call sys.drop_user('gemfire2')");
        stmts[6].execute("call sys.drop_user('gemfire2')");
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[0]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[1]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[5]);
        LdapGroupAuthTest.checkAuthzFailure("insert into gemfire7.test1 values (9, 9)", stmts[0]);
        sysStmt.execute("revoke execute on procedure sys.drop_user from ldapGroup: gemGroup2 restrict");
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire8')", stmts[2]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire9')", stmts[3]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire1')", stmts[4]);
        stmts[6].execute("call sys.drop_user('gemfire2')");
        stmts[6].execute("call sys.drop_user('gemfire8')");
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[0]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[1]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[5]);
        sysStmt.execute("grant execute on procedure sys.drop_user to gemfire7, ldapGroup: gemGroup2");
        stmts[2].execute("call sys.drop_user('gemfire8')");
        stmts[3].execute("call sys.drop_user('gemfire9')");
        stmts[4].execute("call sys.drop_user('gemfire1')");
        stmts[6].execute("call sys.drop_user('gemfire2')");
        stmts[6].execute("call sys.drop_user('gemfire2')");
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[0]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[1]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[5]);
        sysStmt.execute("revoke execute on procedure sys.drop_user from ldapGroup: gemGroup2, gemfire7 restrict");
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire8')", stmts[0]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire9')", stmts[1]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire1')", stmts[2]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[3]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[4]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[5]);
        LdapGroupAuthTest.checkAuthzFailure("call sys.drop_user('gemfire2')", stmts[6]);
        stmts[6].execute("drop table gemfire7.test1");
        stmts[6].execute("drop table gemfire7.test2");
        sysStmt.close();
        sysConn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkGroupAuthRefresh(int netPort, Connection[] conns, Statement[] stmts) throws Exception {
        Properties props = new Properties();
        SecurityTestUtils.setUserProps(sysUser, props);
        Connection sysConn = TestUtil.getNetConnection(netPort, null, props);
        Statement sysStmt = sysConn.createStatement();
        LdapGroupAuthTest.createStatements(9, netPort, conns, stmts);
        sysStmt.execute("grant execute on PROCEDURE SYS.REFRESH_LDAP_GROUP to gemfire9");
        Statement stmt = stmts[8];
        stmt.execute("create table test1 (id1 int primary key, v1 int)");
        stmt.execute("create table test2 (id2 int, v2 varchar(10))");
        try {
            block12: {
                stmt.execute("insert into gemfire9.test2 values (5, 'v5')");
                LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test1 values (1, 1), (2, 2)", stmts[0]);
                LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test2 set v2='v5_1' where id2=5", stmts[1]);
                LdapGroupAuthTest.checkAuthzFailure("delete from gemfire9.test2", stmts[2]);
                stmt.execute("grant insert on table test1 to ldapGroup: gemGroup2, gemfire1");
                stmt.execute("grant insert on table gemfire9.test2 to ldapGroup : gemGroup3, gemfire3");
                stmt.execute("grant select on table test1 to gemfire3, ldapGroup: gemGroup5");
                stmt.execute("grant delete on table test1 to ldapGroup: gemGroup3");
                stmt.execute("grant update on table test1 to ldapGroup: gemGroup7, gemfire3");
                sysStmt.execute("grant execute on procedure SYS.DROP_USER to ldapGroup: gemGroup7");
                stmts[0].execute("insert into gemfire9.test1 values (1, 1), (2, 2)");
                stmts[2].execute("insert into gemfire9.test2 values (1, 'v1'), (2, 'v2')");
                try {
                    stmts[4].execute("insert into gemfire9.test1 values (1, 1), (2, 2)");
                    Assert.fail((String)"expected primary key constraint violation");
                }
                catch (SQLException sqle) {
                    if ("23505".equals(sqle.getSQLState())) break block12;
                    throw sqle;
                }
            }
            stmts[5].execute("insert into gemfire9.test2 values (2, 'v2'), (3, 'v3')");
            stmts[6].execute("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')");
            stmts[7].execute("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')");
            stmts[4].execute("insert into gemfire9.test1 values (3, 3), (4, 4)");
            LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')", stmts[0]);
            LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')", stmts[4]);
            LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=2 where id1=1", stmts[0]);
            LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=3 where id1=2", stmts[1]);
            stmts[2].execute("update gemfire9.test1 set v1=4 where id1=3");
            LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=5 where id1=4", stmts[3]);
            LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=5 where id1=4", stmts[4]);
            LdapGroupAuthTest.checkAuthzFailure("delete from gemfire9.test1", stmts[1]);
            LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test2 set v2='v2_1' where v2='v2'", stmts[2]);
            LdapGroupAuthTest.checkAuthzFailure("select * from gemfire9.test1", stmts[1]);
            stmts[3].executeQuery("select * from gemfire9.test1").close();
            stmts[5].executeQuery("select * from gemfire9.test1").close();
            LdapGroupAuthTest.checkAuthzFailure("select * from gemfire9.test2 where id2 > 1", stmts[3]);
            stmts[6].execute("delete from gemfire9.test1");
            for (int i = 0; i < 9; ++i) {
                LdapGroupAuthTest.checkAuthzFailure("call SYS.DROP_USER('gemfire8')", stmts[i]);
            }
            LdapTestServer server = LdapTestServer.getInstance();
            server.removeAttribute("cn=gemGroup3,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "uniqueMember", "uid=gemfire8,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            server.addAttribute("cn=gemGroup3,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "uniqueMember", "uid=gemfire5,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            server.addAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "uid=gemfire4,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            server.addAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "cn=gemGroup1,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            server.addAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "uid=gemfire6,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            try {
                block13: {
                    stmt.execute("call SYS.REFRESH_LDAP_GROUP('gemGroup3')");
                    sysStmt.execute("call SYS.REFRESH_LDAP_GROUP('gemGroup7')");
                    stmts[0].execute("insert into gemfire9.test1 values (1, 1), (2, 2)");
                    stmts[2].execute("insert into gemfire9.test2 values (1, 'v1'), (2, 'v2')");
                    try {
                        stmts[4].execute("insert into gemfire9.test1 values (1, 1), (2, 2)");
                        Assert.fail((String)"expected primary key constraint violation");
                    }
                    catch (SQLException sqle) {
                        if ("23505".equals(sqle.getSQLState())) break block13;
                        throw sqle;
                    }
                }
                stmts[4].execute("insert into gemfire9.test2 values (2, 'v2'), (3, 'v3')");
                stmts[5].execute("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')");
                stmts[6].execute("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')");
                stmts[4].execute("insert into gemfire9.test1 values (3, 3), (4, 4)");
                LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')", stmts[0]);
                LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')", stmts[7]);
                LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=2 where id1=1", stmts[0]);
                LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=3 where id1=2", stmts[1]);
                stmts[2].execute("update gemfire9.test1 set v1=4 where id1=3");
                stmts[3].execute("update gemfire9.test1 set v1=2 where id1=1");
                LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=4 where id1=3", stmts[4]);
                stmts[5].execute("update gemfire9.test1 set v1=5 where id1=4");
                LdapGroupAuthTest.checkAuthzFailure("delete from gemfire9.test1", stmts[1]);
                LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test2 set v2='v2_1' where v2='v2'", stmts[2]);
                LdapGroupAuthTest.checkAuthzFailure("select * from gemfire9.test1", stmts[1]);
                stmts[3].executeQuery("select * from gemfire9.test1").close();
                stmts[5].executeQuery("select * from gemfire9.test1").close();
                LdapGroupAuthTest.checkAuthzFailure("select * from gemfire9.test2 where id2 > 1", stmts[3]);
                stmts[6].execute("delete from gemfire9.test1");
                LdapGroupAuthTest.checkAuthzFailure("call SYS.DROP_USER('gemfire8')", stmts[4]);
                LdapGroupAuthTest.checkAuthzFailure("call SYS.DROP_USER('gemfire8')", stmts[6]);
                LdapGroupAuthTest.checkAuthzFailure("call SYS.DROP_USER('gemfire8')", stmts[7]);
                LdapGroupAuthTest.checkAuthzFailure("call SYS.DROP_USER('gemfire8')", stmts[8]);
                stmts[5].execute("call SYS.DROP_USER('gemfire8')");
                stmts[0].execute("call SYS.DROP_USER('gemfire6')");
                stmts[1].execute("call SYS.DROP_USER('gemfire1')");
                stmts[2].execute("call SYS.DROP_USER('gemfire6')");
                stmts[3].execute("call SYS.DROP_USER('gemfire6')");
                LdapGroupAuthTest.checkAuthzFailure("call SYS.DROP_USER('gemfire8')", stmts[5]);
                LdapGroupAuthTest.checkAuthzFailure("call SYS.DROP_USER('gemfire8')", stmts[5]);
                stmt.execute("revoke insert on gemfire9.test2 from ldapGroup : gemGroup3");
                sysStmt.execute("revoke execute on procedure SYS.DROP_USER from ldapGroup: gemGroup7 restrict");
                LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test1 values (1, 1), (2, 2)", stmts[0]);
                stmts[2].execute("insert into gemfire9.test2 values (1, 'v1'), (2, 'v2')");
                stmts[4].execute("insert into gemfire9.test1 values (1, 1), (2, 2)");
                stmts[2].execute("insert into gemfire9.test2 values (2, 'v2'), (3, 'v3')");
                LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test2 values (2, 'v2'), (3, 'v3')", stmts[4]);
                LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')", stmts[5]);
                LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')", stmts[6]);
                stmts[4].execute("insert into gemfire9.test1 values (3, 3), (4, 4)");
                LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')", stmts[0]);
                LdapGroupAuthTest.checkAuthzFailure("insert into gemfire9.test2 values (5, 'v5'), (6, 'v6')", stmts[7]);
                LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=2 where id1=1", stmts[0]);
                LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=3 where id1=2", stmts[1]);
                stmts[2].execute("update gemfire9.test1 set v1=4 where id1=3");
                stmts[3].execute("update gemfire9.test1 set v1=2 where id1=1");
                LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=4 where id1=3", stmts[4]);
                LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test1 set v1=5 where id1=4", stmts[5]);
                LdapGroupAuthTest.checkAuthzFailure("delete from gemfire9.test1", stmts[1]);
                LdapGroupAuthTest.checkAuthzFailure("update gemfire9.test2 set v2='v2_1' where v2='v2'", stmts[2]);
                LdapGroupAuthTest.checkAuthzFailure("select * from gemfire9.test1", stmts[1]);
                stmts[3].executeQuery("select * from gemfire9.test1").close();
                LdapGroupAuthTest.checkAuthzFailure("select * from gemfire9.test1", stmts[5]);
                LdapGroupAuthTest.checkAuthzFailure("select * from gemfire9.test2 where id2 > 1", stmts[3]);
                stmts[6].execute("delete from gemfire9.test1");
                for (int i = 0; i < 9; ++i) {
                    LdapGroupAuthTest.checkAuthzFailure("call SYS.DROP_USER('gemfire8')", stmts[i]);
                }
            }
            finally {
                server.addAttribute("cn=gemGroup3,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "uniqueMember", "uid=gemfire8,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
                server.removeAttribute("cn=gemGroup3,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "uniqueMember", "uid=gemfire5,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
                server.removeAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "uid=gemfire4,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
                server.removeAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "cn=gemGroup1,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
                server.removeAttribute("cn=gemGroup7,ou=ldapTesting,dc=pune,dc=gemstone,dc=com", "member", "uid=gemfire6,ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
            }
        }
        finally {
            stmt.execute("drop table gemfire9.test1");
            stmt.execute("drop table gemfire9.test2");
            sysStmt.execute("revoke execute on procedure SYS.DROP_USER from ldapGroup: gemGroup7 restrict");
            sysStmt.close();
            sysConn.close();
        }
    }

    static {
        conns = new Connection[10];
        stmts = new Statement[10];
    }
}

