/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.security;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.security.LdapGroupAuthTest;
import com.pivotal.gemfirexd.security.LdapTestServer;
import com.pivotal.gemfirexd.security.SecurityTestUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class LdapGroupAuthDUnit
extends DistributedSQLTestBase {
    private final int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
    private static final String sysUser = "gemfire10";
    private static final int[] netPorts = new int[2];
    private final Connection[][] conns = new Connection[2][10];
    private final Statement[][] stmts = new Statement[2][10];

    public LdapGroupAuthDUnit(String name) {
        super(name);
    }

    @Override
    public void beforeClass() throws Exception {
        Properties bootProps = SecurityTestUtils.startLdapServerAndGetBootProperties(this.locatorPort, 0, sysUser);
        super.baseSetUp();
        this.startLocatorVM("localhost", this.locatorPort, null, bootProps);
        this.startVMs(1, 3, 0, null, bootProps);
        LdapGroupAuthDUnit.netPorts[0] = this.startNetworkServer(3, null, null);
        LdapGroupAuthDUnit.netPorts[1] = this.startNetworkServer(4, null, null);
        TestUtil.currentUserName = sysUser;
        TestUtil.currentUserPassword = sysUser;
        TestUtil.bootUserName = sysUser;
        TestUtil.bootUserPassword = sysUser;
    }

    public void afterClass() throws Exception {
        super.baseShutDownAll();
        LdapTestServer server = LdapTestServer.getInstance();
        if (server.isServerStarted()) {
            server.stopService();
        }
    }

    @Override
    protected void baseSetUp() {
    }

    @Override
    public void baseShutDownAll() throws Exception {
        SQLException failure1 = LdapGroupAuthTest.closeStatements(this.conns[0], this.stmts[0]);
        SQLException failure2 = LdapGroupAuthTest.closeStatements(this.conns[1], this.stmts[1]);
        if (failure1 != null) {
            throw failure1;
        }
        if (failure2 != null) {
            throw failure2;
        }
    }

    public void testGroupAuthAddRemove() throws Exception {
        LdapGroupAuthTest.checkGroupAuthAddRemove(netPorts[0], this.conns[0], this.stmts[0]);
        LdapGroupAuthTest.checkGroupAuthAddRemove(netPorts[1], this.conns[1], this.stmts[1]);
    }

    public void testGroupAuthRefresh() throws Exception {
        LdapGroupAuthTest.checkGroupAuthRefresh(netPorts[0], this.conns[0], this.stmts[0]);
        LdapGroupAuthTest.checkGroupAuthRefresh(netPorts[1], this.conns[1], this.stmts[1]);
    }
}

