/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.security;

import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.monitor.FileMonitor;
import com.pivotal.gemfirexd.security.LdapTestServer;
import com.pivotal.gemfirexd.security.SecurityTestUtils;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.Host;
import io.snappydata.test.dunit.SerializableCallable;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.security.InvalidAlgorithmParameterException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import junit.framework.TestCase;

public class GemFireXDAuthenticationDUnit
extends DistributedSQLTestBase {
    String origdebugtrue;
    String origmonitorverbose;

    public GemFireXDAuthenticationDUnit(String name) {
        super(name);
        if (this.getLogLevel().startsWith("fine")) {
            this.origdebugtrue = System.setProperty("gemfirexd.debug.true", "TraceAuthentication,TraceFabricServerBoot");
            this.origmonitorverbose = System.setProperty("gemfirexd.monitor.verbose", "true");
        }
    }

    @Override
    public void beforeClass() throws Exception {
        LdapTestServer server = LdapTestServer.getInstance();
        if (!server.isServerStarted()) {
            server.startServer();
        }
    }

    public void afterClass() throws Exception {
        LdapTestServer server = LdapTestServer.getInstance();
        if (server.isServerStarted()) {
            server.stopService();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        Connection conn = TestUtil.jdbcConn;
        if (conn == null && GemFireStore.getBootedInstance() != null) {
            conn = TestUtil.getConnection();
        }
        if (conn != null) {
            TestUtil.dropAllUsers(conn);
        }
        if (this.getLogLevel().startsWith("fine")) {
            if (this.origdebugtrue == null) {
                System.clearProperty("gemfirexd.debug.true");
            } else {
                System.setProperty("gemfirexd.debug.true", this.origdebugtrue);
            }
            if (this.origmonitorverbose == null) {
                System.clearProperty("gemfirexd.monitor.verbose");
            } else {
                System.setProperty("gemfirexd.monitor.verbose", this.origmonitorverbose);
            }
        }
        super.tearDown2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void testAuthenticationFailureDueToCredentialMismatch() throws Exception {
        scheme = SecurityTestUtils.AuthenticationSchemes.BUILTIN;
        locatorPort = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
        diffSystemProps = scheme.startupProps(false, true, false, true, false);
        locatorConnectionCredentials = scheme.bootCredentials();
        userName = locatorConnectionCredentials.getProperty("user");
        userName = userName == null ? locatorConnectionCredentials.getProperty("UserName") : userName;
        diffSystemProps.setProperty("gemfirexd.user." + userName, locatorConnectionCredentials.getProperty("password"));
        diffSystemProps.putAll((Map<?, ?>)locatorConnectionCredentials);
        this.getLogWriter().info((Object)("diffSystem " + diffSystemProps));
        locatorBootProperties = new Properties();
        locatorBootProperties.putAll((Map<?, ?>)diffSystemProps);
        startlocator = new SerializableCallable("starting locator"){

            public Object call() {
                String currentHost = DistributedTestBase.getIPLiteral();
                try {
                    TestUtil.doCommonSetup(locatorBootProperties);
                    String sysDirName = GemFireXDAuthenticationDUnit.getSysDirName();
                    locatorBootProperties.setProperty("sys-disk-dir", sysDirName);
                    FabricLocator locator = FabricServiceManager.getFabricLocatorInstance();
                    locator.start(currentHost, Integer.parseInt(locatorPort), locatorBootProperties);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    GemFireXDAuthenticationDUnit.this.getLogWriter().error((Object)"NumberFormatException occurred ", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    GemFireXDAuthenticationDUnit.this.getLogWriter().error((Object)"SQLException occurred ", (Throwable)e);
                    throw new RuntimeException(e);
                }
                return currentHost;
            }
        };
        vm1 = Host.getHost((int)0).getVM(0);
        this.getLogWriter().info((Object)("Choosen vm1 pid = " + vm1.getPid() + " as locator VM and adding it to serverVM list. PropertyList " + locatorBootProperties));
        locatorhost = (String)vm1.invoke((Callable)startlocator);
        expectedexceptionlist = new Class[]{SQLException.class, AuthenticationFailedException.class};
        try {
            this.serverVMs.add(vm1);
            locator = locatorhost + "[" + locatorPort + "]";
            vm2 = Host.getHost((int)0).getVM(1);
            expectedException = new SerializableRunnable("GemFireXDAuthenticationDUnit: add expected exception", (Class[])expectedexceptionlist){
                final /* synthetic */ Class[] val$expectedexceptionlist;
                {
                    this.val$expectedexceptionlist = classArray;
                    super(x0);
                }

                public void run() {
                    for (Class c : this.val$expectedexceptionlist) {
                        FileMonitor monitor = (FileMonitor)Monitor.getCachedMonitorLite((boolean)false);
                        monitor.report("<ExpectedException action=add>" + c.getName() + "</ExpectedException>");
                    }
                    TestUtil.addExpectedException(this.val$expectedexceptionlist);
                }
            };
            vm1.invoke((Runnable)expectedException);
            vm2.invoke((Runnable)expectedException);
            serverprops = scheme.startupProps(false, true, false, true, false);
            connprops = scheme.bootCredentials();
            userName = connprops.getProperty("user");
            userName = userName == null ? connprops.getProperty("UserName") : userName;
            serverprops.setProperty("gemfirexd.user." + userName, connprops.getProperty("password"));
            serverprops.putAll((Map<?, ?>)scheme.bootCredentials());
            TestUtil.doCommonSetup(serverprops);
            serverprops.setProperty("locators", locator);
            vminfo = " vm2 pid = " + vm2.getPid();
            this.getLogWriter().info((Object)("Attempt 1 to start server " + vminfo + " with properties .... " + serverprops));
            isSuccess = false;
            try {
                this.startVMs(0, 1, 0, null, serverprops);
                isSuccess = true;
            }
            catch (Throwable e) {
                t = e;
                while ((t = t.getCause()) != null && !(t instanceof AuthenticationFailedException)) {
                }
                if (t == null || !(t instanceof AuthenticationFailedException)) {
                    GemFireXDAuthenticationDUnit.fail("Unexpected exception occurred. must have failed due to credential mismatch... ", e);
                } else {
                    this.getLogWriter().info((Object)("Got expected exception " + t));
                }
            }
            finally {
                if (isSuccess) {
                    SanityManager.THROWASSERT((String)"server start failure is expected.... ");
                }
            }
            try {
                userName = locatorBootProperties.getProperty("user");
                userName = userName == null ? locatorBootProperties.getProperty("UserName") : userName;
                serverprops.put("user", userName);
                serverprops.put("password", locatorBootProperties.getProperty("password"));
                this.getLogWriter().info((Object)("Attempt 2 to start server " + vminfo + " with properties .... " + serverprops));
                tryServerStart = new SerializableCallable("starting server without password"){

                    public Object call() {
                        expectedException.run();
                        String currentHost = DistributedTestBase.getIPLiteral();
                        try {
                            TestUtil.doCommonSetup(serverprops);
                            String sysDirName = GemFireXDAuthenticationDUnit.getSysDirName();
                            serverprops.setProperty("sys-disk-dir", sysDirName);
                            FabricServer server = FabricServiceManager.getFabricServerInstance();
                            server.start(serverprops);
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException(e);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                        return currentHost;
                    }
                };
                vm2.invoke((Callable)tryServerStart);
                isSuccess = true;
            }
            catch (Throwable e) {
                t = e;
                foundExpectedException = false;
                do {
                    if (!(t instanceof AuthenticationFailedException) && (!(t instanceof SQLException) || !"08004".equals(((SQLException)t).getSQLState()))) continue;
                    foundExpectedException = true;
                    break;
                } while ((t = t.getCause()) != null);
                if (!foundExpectedException) {
                    SanityManager.THROWASSERT((String)"UnExpected exception occurred. must have failed due to credential mismatch locally ... ", (Throwable)e);
                } else {
                    this.getLogWriter().info((Object)("Got expected exception " + t));
                }
            }
            finally {
                if (isSuccess) {
                    SanityManager.THROWASSERT((String)"server start failure is expected.... ");
                }
            }
            try {
                serverprops.remove("password");
                this.getLogWriter().info((Object)("Attempt 3 to start server " + vminfo + " with properties .... " + serverprops));
                tryServerStart = new SerializableCallable("starting server without password"){

                    public Object call() {
                        expectedException.run();
                        String currentHost = DistributedTestBase.getIPLiteral();
                        try {
                            TestUtil.doCommonSetup(serverprops);
                            String sysDirName = GemFireXDAuthenticationDUnit.getSysDirName();
                            serverprops.setProperty("sys-disk-dir", sysDirName);
                            FabricServer server = FabricServiceManager.getFabricServerInstance();
                            server.start(serverprops);
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException(e);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                        return currentHost;
                    }
                };
                vm2.invoke((Callable)tryServerStart);
                isSuccess = true;
            }
            catch (Throwable e) {
                t = e;
                while ((t = t.getCause()) != null && !(t instanceof AuthenticationFailedException)) {
                }
                if (t == null || !(t instanceof AuthenticationFailedException)) {
                    SanityManager.THROWASSERT((String)"UnExpected exception occurred. must have failed due to password missing... ", (Throwable)e);
                } else {
                    this.getLogWriter().info((Object)("Got expected exception " + t));
                }
            }
            finally {
                if (isSuccess) {
                    SanityManager.THROWASSERT((String)"server start failure is expected.... ");
                }
            }
            TestUtil.doCommonSetup(diffSystemProps);
            diffSystemProps.setProperty("locators", locator);
            try {
                noUser = new Properties();
                noUser.putAll((Map<?, ?>)diffSystemProps);
                noUser.remove("user");
                noUser.remove("UserName");
                GemFireXDAuthenticationDUnit.assertFalse((boolean)(noUser.containsKey("user") != false || noUser.containsKey("UserName") != false));
                this.getLogWriter().info((Object)("Attempt 4 to start server " + vminfo + " with properties .... " + noUser));
                tryServerStart = new SerializableCallable("starting server without user"){

                    public Object call() {
                        expectedException.run();
                        String currentHost = DistributedTestBase.getIPLiteral();
                        try {
                            TestUtil.doCommonSetup(noUser);
                            String sysDirName = GemFireXDAuthenticationDUnit.getSysDirName();
                            noUser.setProperty("sys-disk-dir", sysDirName);
                            FabricServer server = FabricServiceManager.getFabricServerInstance();
                            server.start(noUser);
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException(e);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                        return currentHost;
                    }
                };
                vm2.invoke((Callable)tryServerStart);
                isSuccess = true;
            }
            catch (Throwable e) {
                block43: {
                    try {
                        t = e;
                        while ((t = t.getCause()) != null && !(t instanceof SQLException)) {
                        }
                        this.getLogWriter().info((Object)("received " + t));
                        if (t == null || !(t instanceof SQLException)) {
                            SanityManager.THROWASSERT((String)"UnExpected exception occurred... ", (Throwable)e);
                            break block43;
                        }
                        if (!"XJ040".equals(((SQLException)t).getSQLState())) {
                            SanityManager.THROWASSERT((String)"UnExpected SQLException ... ", (Throwable)t);
                            break block43;
                        }
                        GemFireXDAuthenticationDUnit.assertTrue((String)"expecting 08001 nested exception", (boolean)((t = t.getCause()) != null));
                        if (!"08001".equals(((SQLException)t).getSQLState())) {
                            SanityManager.THROWASSERT((String)"UnExpected nested SQLException ... ", (Throwable)t);
                        }
                        this.getLogWriter().info((Object)("Got expected exception " + t));
                    }
                    catch (Throwable var23_28) {
                        this.removeExpectedException((int[])null, new int[]{1, 2}, expectedexceptionlist);
                        if (isSuccess) {
                            SanityManager.THROWASSERT((String)"server start failure is expected due to user id missing.... ");
                        }
                        throw var23_28;
                    }
                }
                this.removeExpectedException((int[])null, new int[]{1, 2}, expectedexceptionlist);
                if (isSuccess) {
                    SanityManager.THROWASSERT((String)"server start failure is expected due to user id missing.... ");
                } else {
                    ** GOTO lbl159
                }
            }
            this.removeExpectedException((int[])null, new int[]{1, 2}, expectedexceptionlist);
            if (isSuccess) {
                SanityManager.THROWASSERT((String)"server start failure is expected due to user id missing.... ");
            }
            this.serverVMs.remove(vm2);
            this.getLogWriter().info((Object)("Attempt 5 to start server " + vminfo + " with properties .... " + diffSystemProps));
            sysDirName = GemFireXDAuthenticationDUnit.getSysDirName();
            diffSystemProps.setProperty("sys-disk-dir", sysDirName);
            this.startVMs(0, 1, 0, null, diffSystemProps);
        }
        catch (Throwable var24_29) {
            stoplocator = new SerializableRunnable("stopping locator", locatorConnectionCredentials, scheme){
                final /* synthetic */ Properties val$locatorConnectionCredentials;
                final /* synthetic */ SecurityTestUtils.AuthenticationSchemes val$scheme;
                {
                    this.val$locatorConnectionCredentials = properties;
                    this.val$scheme = authenticationSchemes;
                    super(x0);
                }

                public void run() {
                    try {
                        FabricService service = FabricServiceManager.currentFabricServiceInstance();
                        if (service != null) {
                            service.stop(this.val$locatorConnectionCredentials);
                        }
                        this.val$scheme.clear();
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        GemFireXDAuthenticationDUnit.this.getLogWriter().error((Object)"NumberFormatException occurred ", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        GemFireXDAuthenticationDUnit.this.getLogWriter().error((Object)"SQLException occurred ", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            };
            vm1.invoke((Runnable)stoplocator);
            throw var24_29;
        }
        stoplocator = new /* invalid duplicate definition of identical inner class */;
        vm1.invoke((Runnable)stoplocator);
    }

    public void testBUILTINSchemeWithValidCredentials() throws Exception {
        this.runAuthentication(SecurityTestUtils.AuthenticationSchemes.BUILTIN);
    }

    public void testLDAPSchemeWithValidCredentials() throws Exception {
        this.runAuthentication(SecurityTestUtils.AuthenticationSchemes.LDAP);
    }

    public void testSkipBUILTINAuthenticationForMemberConnections() throws Exception {
        this.runAuthentication(SecurityTestUtils.AuthenticationSchemes.BUILTIN, true);
    }

    public void testSkipLDAPAuthenticationForMemberConnections() throws Exception {
        this.runAuthentication(SecurityTestUtils.AuthenticationSchemes.LDAP, true);
    }

    private void runAuthentication(SecurityTestUtils.AuthenticationSchemes scheme) throws Exception {
        this.runAuthentication(scheme, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void runAuthentication(final SecurityTestUtils.AuthenticationSchemes scheme, boolean checkAuthSkipping) throws Exception {
        boolean reStartRequired = false;
        this.getLogWriter().info((Object)("Testing for " + (Object)((Object)scheme)));
        for (int i = 1; i <= 2; ++i) {
            Properties extraServerProps = new Properties();
            this.getLogWriter().info((Object)("With " + (i == 1 ? "Implicit" : "Explicit") + " peer authentication system property set "));
            this.prepareServers(extraServerProps, scheme, i != 1, reStartRequired, false, true, false, false);
            if (checkAuthSkipping) {
                GemFireXDQueryObserverAdapter notSkippedObserver = new GemFireXDQueryObserverAdapter(){

                    public void userConnectionAuthenticationSkipped(boolean skipped) {
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("Skipped authentication:" + skipped));
                        TestCase.assertFalse((boolean)skipped);
                    }
                };
                Object[] args = new Object[]{notSkippedObserver};
                this.getLogWriter().info((Object)("SERVER VMS:" + this.serverVMs.size()));
                ((VM)this.serverVMs.get(0)).invoke(GemFireXDQueryObserverHolder.class, new String("setInstance"), args);
                GemFireXDQueryObserverAdapter skippedObserver = new GemFireXDQueryObserverAdapter(){

                    public void memberConnectionAuthenticationSkipped(boolean skipped) {
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("Skipped authentication:" + skipped));
                        TestCase.assertTrue((boolean)skipped);
                    }
                };
                Object[] args2 = new Object[]{skippedObserver};
                this.getLogWriter().info((Object)("SERVER VMS:" + this.serverVMs.size()));
                ((VM)this.serverVMs.get(1)).invoke(GemFireXDQueryObserverHolder.class, new String("setInstance"), args2);
            }
            String locator = extraServerProps.getProperty("locators");
            Connection systemconn = null;
            systemconn = this.bootRestAsPeerClient(scheme, locator, reStartRequired);
            scheme.CreateUsers(systemconn);
            systemconn.createStatement().execute("create table dummy (k int) ");
            SerializableRunnable check = new SerializableRunnable("Round " + i + " Check AuthenticationScheme = " + (Object)((Object)scheme)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block20: {
                        TestUtil.loadDriver();
                        Connection conn = null;
                        String tableName = null;
                        Properties connectionProp = new Properties();
                        connectionProp.putAll((Map<?, ?>)scheme.connectionCredentials(true, true));
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("getting local connection using distributed system user " + connectionProp));
                        conn = TestUtil.getConnection(connectionProp);
                        String userName = connectionProp.getProperty("user");
                        userName = userName == null ? connectionProp.getProperty("UserName") : userName;
                        tableName = "dummy__" + userName;
                        String crTab = "create table " + tableName + " (k int) ";
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("creating tab : " + crTab));
                        conn.createStatement().execute(crTab);
                        connectionProp.clear();
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)"Done checking ");
                        this.dropTab(conn, tableName);
                        try {
                            if (conn != null) {
                                conn.close();
                            }
                        }
                        catch (SQLException e) {
                            DistributedSQLTestBase.fail("unexpected exception ", e);
                        }
                        conn = null;
                        break block20;
                        catch (SQLException ex) {
                            if (!ex.getSQLState().equals("X0Y32")) {
                                DistributedSQLTestBase.fail("Some exception ", ex);
                            } else {
                                this.dropTab(conn, tableName);
                                this.run();
                            }
                            this.dropTab(conn, tableName);
                            try {
                                if (conn != null) {
                                    conn.close();
                                }
                            }
                            catch (SQLException e) {
                                DistributedSQLTestBase.fail("unexpected exception ", e);
                            }
                            conn = null;
                        }
                        catch (Exception ex2) {
                            TestCase.fail((String)("Test Failed with " + ex2));
                            this.dropTab(conn, tableName);
                            {
                                catch (Throwable throwable) {
                                    this.dropTab(conn, tableName);
                                    try {
                                        if (conn != null) {
                                            conn.close();
                                        }
                                    }
                                    catch (SQLException e) {
                                        DistributedSQLTestBase.fail("unexpected exception ", e);
                                    }
                                    conn = null;
                                    throw throwable;
                                }
                            }
                            try {
                                if (conn != null) {
                                    conn.close();
                                }
                            }
                            catch (SQLException e) {
                                DistributedSQLTestBase.fail("unexpected exception ", e);
                            }
                            conn = null;
                        }
                    }
                }

                private void dropTab(Connection conn, String tableName) {
                    block3: {
                        if (conn != null) {
                            String dpTab = "drop table " + tableName;
                            GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("dropping tab : " + dpTab));
                            try {
                                conn.createStatement().execute(dpTab);
                            }
                            catch (SQLException e) {
                                if (e.getSQLState().equals("42Y55")) break block3;
                                DistributedSQLTestBase.fail("Exception while resetting ", e);
                            }
                        }
                    }
                }
            };
            this.getLogWriter().info((Object)("Round " + i + " Verifying local connections on every VM "));
            GemFireXDAuthenticationDUnit.invokeInEveryVM((SerializableRunnable)check);
            reStartRequired = true;
            if (systemconn == null) continue;
            TestUtil.deletePersistentFiles = true;
            try {
                this.shutDownEverything(systemconn, scheme, i != 1, true, true, 0);
                systemconn.close();
            }
            catch (Exception e) {
                this.getLogWriter().error((Object)"unexpected exception in close", (Throwable)e);
            }
            continue;
            catch (Exception ex) {
                try {
                    this.getLogWriter().error((Object)("Round " + i + "Exception happened "), (Throwable)ex);
                    GemFireXDAuthenticationDUnit.fail("Round " + i + " got error ", ex);
                    reStartRequired = true;
                    if (systemconn == null) continue;
                    TestUtil.deletePersistentFiles = true;
                }
                catch (Throwable throwable) {
                    reStartRequired = true;
                    if (systemconn != null) {
                        TestUtil.deletePersistentFiles = true;
                        try {
                            this.shutDownEverything(systemconn, scheme, i != 1, true, true, 0);
                            systemconn.close();
                        }
                        catch (Exception e) {
                            this.getLogWriter().error((Object)"unexpected exception in close", (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                try {
                    this.shutDownEverything(systemconn, scheme, i != 1, true, true, 0);
                    systemconn.close();
                }
                catch (Exception e) {
                    this.getLogWriter().error((Object)"unexpected exception in close", (Throwable)e);
                }
                continue;
            }
        }
    }

    public void DISABLED_GEMXD11_testSchemaSharedBetweenUsersWithoutAuthorization() throws Exception {
        Properties extraServerProps = new Properties();
        final SecurityTestUtils.AuthenticationSchemes scheme = SecurityTestUtils.AuthenticationSchemes.BUILTIN;
        this.prepareServers(extraServerProps, scheme, true, false, false, false, false, false);
        this.startVMs(0, 1, 0, null, extraServerProps);
        String locator = extraServerProps.getProperty("locators");
        final Properties commonProps = new Properties();
        commonProps.setProperty("mcast-port", "0");
        commonProps.setProperty("start-locator", locator);
        commonProps.setProperty("locators", locator);
        commonProps.setProperty("host-data", "true");
        commonProps.setProperty("log-level", this.getLogLevel());
        final String sharedSchemaName = SecurityTestUtils.commonSchemaName;
        Connection systemconn = null;
        try {
            VM v;
            int i;
            systemconn = this.bootRestAsPeerClient(scheme, locator, false);
            scheme.CreateUsers(systemconn);
            Statement stmts = systemconn.createStatement();
            String systemSchema = scheme.sysUser.toUpperCase();
            SecurityTestUtils.assertCurrentSchema(stmts, systemSchema);
            this.getLogWriter().info((Object)("creating sample table on " + systemSchema));
            stmts.execute("create table SampleTable (i int, j int)");
            Properties prop = scheme.bootCredentials();
            this.getLogWriter().info((Object)("Connecting to ds using system user " + prop));
            Connection conn = DriverManager.getConnection(TestUtil.getProtocol(), prop);
            this.getLogWriter().info((Object)("creating common schema " + sharedSchemaName));
            conn.createStatement().execute("create schema " + sharedSchemaName);
            conn.close();
            this.getLogWriter().info((Object)("switching to common schema " + sharedSchemaName + " from " + systemSchema));
            stmts.execute("SET SCHEMA " + sharedSchemaName);
            SecurityTestUtils.assertCurrentSchema(stmts, sharedSchemaName);
            this.getLogWriter().info((Object)("creating SharedTable on " + sharedSchemaName));
            stmts.execute("create table SharedTable (i int, j int) PERSISTENT redundancy 2");
            this.getLogWriter().info((Object)("inserting to SharedTable on " + sharedSchemaName));
            stmts.execute("insert into SharedTable values(1,1), (2,2), (3,3)");
            this.getLogWriter().info((Object)"switching to current user schema");
            stmts.execute("SET CURRENT SCHEMA USER");
            SecurityTestUtils.assertCurrentSchema(stmts, systemSchema);
            stmts.close();
            GemFireXDAuthenticationDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable("log current disk directory"){

                public void run() {
                    TestUtil.deletePersistentFiles = false;
                    GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)(GfxdConstants.SYS_PERSISTENT_DIR_PROP + " = " + System.getProperty(GfxdConstants.SYS_PERSISTENT_DIR_PROP)));
                }
            });
            TestUtil.deletePersistentFiles = false;
            this.getLogWriter().info((Object)(GfxdConstants.SYS_PERSISTENT_DIR_PROP + " = " + System.getProperty(GfxdConstants.SYS_PERSISTENT_DIR_PROP)));
            this.shutDownEverything(systemconn, scheme, true, false, false, -1);
            systemconn.close();
            final Class[] expectedexceptionlist = new Class[]{SQLException.class, AuthenticationFailedException.class};
            final VM locatorvm = (VM)this.serverVMs.get(0);
            this.getLogWriter().info((Object)("booting with first connection in vm " + ((VM)this.serverVMs.get(0)).getPid() + " using system user with implicit locator "));
            locatorvm.invoke((Runnable)new SerializableRunnable("bringing up server 0 with embeded locator"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Properties distBootProp = new Properties();
                    distBootProp.putAll((Map<?, ?>)scheme.startupProps(false, false, false, false, false));
                    distBootProp.putAll((Map<?, ?>)commonProps);
                    distBootProp.putAll((Map<?, ?>)scheme.bootCredentials());
                    TestUtil.doCommonSetup(distBootProp);
                    distBootProp.setProperty("sys-disk-dir", System.getProperty(GfxdConstants.SYS_PERSISTENT_DIR_PROP));
                    for (Class c : expectedexceptionlist) {
                        FileMonitor monitor = (FileMonitor)Monitor.getCachedMonitorLite((boolean)false);
                        monitor.report("<ExpectedException action=add>" + c.getName() + "</ExpectedException>");
                    }
                    Properties failProp = new Properties();
                    failProp.putAll((Map<?, ?>)distBootProp);
                    failProp.setProperty("password", "giberrish");
                    try {
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("attempting to fail bootstrap with first connection using dist user " + failProp));
                        TestUtil.getConnection(failProp);
                        TestCase.fail((String)"Supposed to fail for improper system user credential");
                    }
                    catch (SQLException sqle) {
                        Throwable t = sqle;
                        boolean foundExpectedException = false;
                        do {
                            if (t instanceof SQLException && "08004".equals(t.getSQLState())) {
                                foundExpectedException = true;
                                break;
                            }
                            if (!(t instanceof StandardException) || !"08004".equals(((StandardException)t).getSQLState())) continue;
                            foundExpectedException = true;
                            break;
                        } while ((t = t.getCause()) != null);
                        if (!foundExpectedException) {
                            SanityManager.THROWASSERT((String)("UnExpected exception occurred. must have failed due to system user password mismatch... " + sqle.getSQLState()), (Throwable)sqle);
                        }
                    }
                    finally {
                        TestUtil.removeExpectedException(expectedexceptionlist);
                    }
                    try {
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("booting with first connection using system user in implicit locator " + distBootProp));
                        Connection conn = TestUtil.getConnection(distBootProp);
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)"got a local connection, trying to switch to shared schema ");
                        conn.createStatement().execute("SET SCHEMA " + sharedSchemaName);
                        SecurityTestUtils.assertCurrentSchema(conn.createStatement(), sharedSchemaName);
                    }
                    catch (SQLException e) {
                        GemFireXDAuthenticationDUnit.this.getLogWriter().error((Object)("got unexpected exception " + e));
                        e.printStackTrace();
                        DistributedSQLTestBase.fail("unexpected exception ", e);
                    }
                }
            });
            SerializableRunnable check = new SerializableRunnable("verifying distributed user"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Properties distConnectionProp = new Properties();
                    distConnectionProp.putAll((Map<?, ?>)commonProps);
                    distConnectionProp.remove("start-locator");
                    distConnectionProp.putAll((Map<?, ?>)scheme.connectionCredentials(true, true));
                    TestUtil.doCommonSetup(distConnectionProp);
                    distConnectionProp.setProperty("sys-disk-dir", System.getProperty(GfxdConstants.SYS_PERSISTENT_DIR_PROP));
                    Properties failProp = new Properties();
                    failProp.putAll((Map<?, ?>)distConnectionProp);
                    failProp.putAll((Map<?, ?>)scheme.connectionCredentials(true, false));
                    failProp.setProperty("password", "giberrish");
                    try {
                        for (Class c : expectedexceptionlist) {
                            FileMonitor monitor = (FileMonitor)Monitor.getCachedMonitorLite((boolean)false);
                            monitor.report("<ExpectedException action=add>" + c.getName() + "</ExpectedException>");
                        }
                        locatorvm.invoke((Runnable)new SerializableRunnable("Add expected exception"){

                            public void run() {
                                TestUtil.addExpectedException(expectedexceptionlist);
                            }
                        });
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("attempting to fail bootstrap with first connection using dist user " + failProp));
                        TestUtil.getConnection(failProp);
                        TestCase.fail((String)"Supposed to fail for improper distributed user credential");
                    }
                    catch (SQLException sqle) {
                        block9: {
                            try {
                                Throwable t = sqle;
                                boolean foundExpectedException = false;
                                do {
                                    if (!(t instanceof AuthenticationFailedException) && (!(t instanceof SQLException) || !"08004".equals(t.getSQLState()))) continue;
                                    foundExpectedException = true;
                                    break;
                                } while ((t = t.getCause()) != null);
                                if (!foundExpectedException) {
                                    SanityManager.THROWASSERT((String)("UnExpected exception occurred. must have failed due to dist user password mismatch... " + sqle.getSQLState()), (Throwable)sqle);
                                    break block9;
                                }
                                GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("got expected exception " + t));
                            }
                            catch (Throwable throwable) {
                                locatorvm.invoke((Runnable)new SerializableRunnable("remove expected exception"){

                                    public void run() {
                                        TestUtil.removeExpectedException(expectedexceptionlist);
                                    }
                                });
                                TestUtil.removeExpectedException(expectedexceptionlist);
                                throw throwable;
                            }
                        }
                        locatorvm.invoke((Runnable)new /* invalid duplicate definition of identical inner class */);
                        TestUtil.removeExpectedException(expectedexceptionlist);
                    }
                    locatorvm.invoke((Runnable)new /* invalid duplicate definition of identical inner class */);
                    TestUtil.removeExpectedException(expectedexceptionlist);
                    try {
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("booting with first connection using dist user " + distConnectionProp));
                        Connection conn = TestUtil.getConnection(distConnectionProp);
                        Statement stmts = conn.createStatement();
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)"got a local connection, trying to switch to shared schema ");
                        stmts.execute("SET SCHEMA " + sharedSchemaName);
                        SecurityTestUtils.assertCurrentSchema(stmts, sharedSchemaName);
                        ResultSet rs = conn.createStatement().executeQuery("select count(1) from SharedTable");
                        rs.next();
                        TestCase.assertEquals((int)3, (int)rs.getInt(1));
                        GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)"shared table browsed successfully via local dist user connection ");
                        rs.close();
                        stmts.close();
                        distConnectionProp.clear();
                        conn.close();
                        conn = null;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        DistributedSQLTestBase.fail("unexpected exception ", e);
                    }
                }
            };
            for (i = 1; i < this.serverVMs.size(); ++i) {
                v = (VM)this.serverVMs.get(i);
                this.getLogWriter().info((Object)("testing local connection (host-data=true) using dist user on " + v.getPid()));
                v.invoke((Runnable)check);
            }
            commonProps.setProperty("host-data", "false");
            for (i = 1; i < this.clientVMs.size(); ++i) {
                v = (VM)this.clientVMs.get(i);
                this.getLogWriter().info((Object)("testing local connection (host-data=false) using dist user on " + v.getPid()));
                v.invoke((Runnable)check);
            }
            check.run();
            Properties distConnectionProp = new Properties();
            distConnectionProp.putAll((Map<?, ?>)commonProps);
            distConnectionProp.remove("start-locator");
            distConnectionProp.putAll((Map<?, ?>)scheme.connectionCredentials(true, true));
            TestUtil.doCommonSetup(distConnectionProp);
            distConnectionProp.setProperty("sys-disk-dir", System.getProperty(GfxdConstants.SYS_PERSISTENT_DIR_PROP));
            conn = TestUtil.getConnection(distConnectionProp);
            this.getLogWriter().info((Object)("dropping table " + sharedSchemaName + ".SharedTable "));
            conn.createStatement().execute("drop table " + sharedSchemaName + ".SharedTable ");
            this.getLogWriter().info((Object)("dropping schema " + sharedSchemaName));
            conn.createStatement().execute("drop schema " + sharedSchemaName + " RESTRICT ");
            this.shutDownEverything(conn, scheme, true, false, true, -1);
            conn.close();
        }
        catch (SQLException sqle) {
            this.getLogWriter().error((Object)"Unexpected error ", (Throwable)sqle);
            GemFireXDAuthenticationDUnit.fail("Got error ", sqle);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleAuthorization() throws Exception {
        SecurityTestUtils.AuthenticationSchemes scheme = SecurityTestUtils.AuthenticationSchemes.BUILTIN;
        Connection systemconn = null;
        try {
            this.getLogWriter().info((Object)"booting with system user ... ");
            Properties sysprop = scheme.startupProps(true, true, true, false, false);
            Properties connprops = scheme.bootCredentials();
            String userName = connprops.getProperty("user");
            userName = userName == null ? connprops.getProperty("UserName") : userName;
            sysprop.setProperty("gemfirexd.user." + userName, connprops.getProperty("password"));
            sysprop.putAll((Map<?, ?>)scheme.bootCredentials());
            sysprop.remove("gemfirexd.authz-default-connection-mode");
            sysprop.remove("gemfirexd.authz-full-access-users");
            String locator = scheme.getLocatorString();
            sysprop.setProperty("mcast-port", "0");
            sysprop.setProperty("start-locator", locator);
            sysprop.setProperty("locators", locator);
            sysprop.setProperty("host-data", "true");
            this.getLogWriter().info((Object)("About to start with properties .... " + sysprop));
            this.startVMs(0, 1, 0, null, sysprop);
            sysprop.remove("start-locator");
            this.startVMs(0, 1, 0, null, sysprop);
            this.getLogWriter().info((Object)("should have started with system user " + scheme.sysUser + " pwd " + scheme.sysPwd));
            sysprop.setProperty("host-data", "false");
            int thst = Host.getHostCount();
            for (int h = thst - 1; h >= 0; --h) {
                int tvms = Host.getHost((int)h).getVMCount() - this.serverVMs.size();
                this.getLogWriter().info((Object)("starting " + tvms + " clients of host " + h + " with " + sysprop));
                this.startVMs(tvms, 0, 0, null, sysprop);
            }
            this.getLogWriter().info((Object)("Connecting to distributed system using system user " + scheme.bootCredentials()));
            systemconn = TestUtil.getConnection(scheme.bootCredentials());
            scheme.CreateUsers(systemconn);
            Statement stmts = systemconn.createStatement();
            SecurityTestUtils.tables.SharedTable.createTable(stmts);
            SecurityTestUtils.tables.SharedTable.doInsert(stmts, "(1,1,1)", "(2,2,2)", "(3,3,3)");
            String sharedSchemaName = scheme.sysUser;
            Properties propsFirstuser = scheme.connectionCredentials(true, false);
            this.getLogWriter().info((Object)("getting local connection using distributed system user " + propsFirstuser));
            Connection conn = TestUtil.getConnection(propsFirstuser);
            this.getLogWriter().info((Object)"connection successfull. ");
            Statement stmts2 = conn.createStatement();
            this.getLogWriter().info((Object)("Switching to schema of System User " + sharedSchemaName));
            stmts2.execute("SET SCHEMA " + sharedSchemaName);
            try {
                SecurityTestUtils.tables.SharedTable.doInsert(stmts2, "(4,4,4)", "(5,5,5)", "(6,6,6)");
                GemFireXDAuthenticationDUnit.fail((String)"supposed to fail ... ");
            }
            catch (SQLException ex) {
                if (!SecurityTestUtils.priv_set.getAllowedSQLStates(0).contains(ex.getSQLState())) {
                    GemFireXDAuthenticationDUnit.fail((String)(ex.getSQLState() + " unexpected exception received " + ex));
                }
                this.getLogWriter().info((Object)("Got expected exeception " + ex.getSQLState() + " message: " + ex));
            }
            SecurityTestUtils.checkDistUser(propsFirstuser, sharedSchemaName, 0, false);
            this.getLogWriter().info((Object)"Testing 41781 .............. ");
            Properties propsSeconduser = scheme.connectionCredentials(true, false);
            this.getLogWriter().info((Object)("getting local connection using 2nd distributed system user " + propsSeconduser));
            Connection dist_user1_conn = TestUtil.getConnection(propsSeconduser);
            String distuser1 = propsSeconduser.getProperty("user");
            distuser1 = distuser1 == null ? propsSeconduser.getProperty("UserName") : distuser1;
            Statement user1stmt = dist_user1_conn.createStatement();
            user1stmt.execute("create table dist_user1_table (col1 int primary key) ");
            user1stmt.execute("insert into dist_user1_table values (1), (2), (3), (4) ");
            this.getLogWriter().info((Object)("data populated on " + distuser1 + ".dist_user1_table, switching to another dist_user "));
            Properties propsThirduser = scheme.connectionCredentials(true, false);
            this.getLogWriter().info((Object)("getting local connection using 3rd distributed system user " + propsThirduser));
            Connection dist_user2_conn = TestUtil.getConnection(propsThirduser);
            Statement user2stmt = dist_user2_conn.createStatement();
            try {
                ResultSet rs1;
                block18: {
                    block17: {
                        block16: {
                            user2stmt.execute("SET SCHEMA " + distuser1);
                            rs1 = user2stmt.executeQuery("select count(1) from dist_user1_table");
                            rs1.next();
                            try {
                                rs1 = user2stmt.executeQuery("select count(col1) from dist_user1_table");
                                rs1.next();
                                SanityManager.THROWASSERT((String)"This query should have failed ...  ");
                            }
                            catch (SQLException sqle) {
                                if ("42502".equals(sqle.getSQLState())) break block16;
                                SanityManager.THROWASSERT((String)"Got some other exception than expected .. ", (Throwable)sqle);
                            }
                        }
                        try {
                            rs1 = user2stmt.executeQuery("select * from dist_user1_table");
                            while (rs1.next()) {
                            }
                        }
                        catch (SQLException sqle) {
                            if ("42502".equals(sqle.getSQLState())) break block17;
                            SanityManager.THROWASSERT((String)"Got some other exception than expected .. ", (Throwable)sqle);
                        }
                    }
                    try {
                        user2stmt.execute("DROP TABLE dist_user1_table");
                        SanityManager.THROWASSERT((String)"This query should have failed with exception 42507...  ");
                    }
                    catch (SQLException sqle) {
                        if ("42507".equals(sqle.getSQLState())) break block18;
                        SanityManager.THROWASSERT((String)"Got some other exception than expected .. ", (Throwable)sqle);
                    }
                }
                user2stmt.execute("SET SCHEMA " + sharedSchemaName);
                rs1 = user2stmt.executeQuery("select count(1) from " + SecurityTestUtils.tables.SharedTable.name());
                while (rs1.next()) {
                }
            }
            catch (SQLException sqle) {
                this.getLogWriter().error((Object)("got exception state " + sqle.getSQLState() + " exception " + sqle));
                throw sqle;
            }
            TestUtil.shutDown();
        }
        catch (Throwable throwable) {
            this.shutDownEverything(systemconn, scheme, true, false, true, 0);
            systemconn = null;
            throw throwable;
        }
        this.shutDownEverything(systemconn, scheme, true, false, true, 0);
        systemconn = null;
    }

    public void testWithAuthorizationSchemaSharingWithoutStmtCaching() throws Exception {
        GemFireXDAuthenticationDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
            }
        });
        System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
        this.verifyAuthorizationChecks();
        GemFireXDAuthenticationDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
            }
        });
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
    }

    public void testWithAuthorizationSchemaSharingWithStmtCaching() throws Exception {
        GemFireXDAuthenticationDUnit.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
            }
        });
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        this.verifyAuthorizationChecks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAuthorizationChecks() throws Exception {
        SecurityTestUtils.AuthenticationSchemes scheme = SecurityTestUtils.AuthenticationSchemes.BUILTIN;
        String sharedSchemaName = SecurityTestUtils.commonSchemaName;
        this.configureUsers(scheme, sharedSchemaName);
        String locator = null;
        ArrayList<Integer> checkPrivList = new ArrayList<Integer>();
        Connection systemconn = null;
        Properties extraServerProps = new Properties();
        this.getLogWriter().info((Object)"rebooting with different system user ... ");
        this.prepareServers(extraServerProps, scheme, true, true, true, false, true, false);
        this.getLogWriter().info((Object)("should have started with system user " + scheme.sysUser + " pwd " + scheme.sysPwd));
        locator = extraServerProps.getProperty("locators");
        systemconn = this.bootRestAsPeerClient(scheme, locator, true);
        Statement stmts = systemconn.createStatement();
        stmts.execute("SET SCHEMA " + sharedSchemaName);
        SecurityTestUtils.tables.SharedTable.doInsert(stmts, "(4,4,4)", "(5,5,5)", "(6,6,6)");
        Properties connProps = scheme.connectionCredentials(true, false);
        String dist_user = connProps.getProperty("user");
        dist_user = dist_user == null ? connProps.getProperty("UserName") : dist_user;
        SecurityTestUtils.grantPrivilege(sharedSchemaName, dist_user, stmts, checkPrivList, SecurityTestUtils.priv_set.INSERT, SecurityTestUtils.priv_set.SELECT_ST_1_ST_2);
        connProps = scheme.connectionCredentials(true, false);
        dist_user = connProps.getProperty("user");
        dist_user = dist_user == null ? connProps.getProperty("UserName") : dist_user;
        SecurityTestUtils.grantPrivilege(sharedSchemaName, dist_user, stmts, checkPrivList, SecurityTestUtils.priv_set.SELECT_ALL);
        connProps = scheme.connectionCredentials(true, false);
        dist_user = connProps.getProperty("user");
        dist_user = dist_user == null ? connProps.getProperty("UserName") : dist_user;
        SecurityTestUtils.grantPrivilege(sharedSchemaName, dist_user, stmts, checkPrivList, SecurityTestUtils.priv_set.UPDATE_ALL, SecurityTestUtils.priv_set.SELECT_ST_1);
        connProps = scheme.connectionCredentials(true, false);
        dist_user = connProps.getProperty("user");
        dist_user = dist_user == null ? connProps.getProperty("UserName") : dist_user;
        SecurityTestUtils.grantPrivilege(sharedSchemaName, dist_user, stmts, checkPrivList, SecurityTestUtils.priv_set.UPDATE_ST_2);
        this.getLogWriter().info((Object)("CheckPrivList built into " + checkPrivList));
        systemconn.close();
        try {
            this.doPrivilegeChecks(scheme, checkPrivList, sharedSchemaName, false);
        }
        catch (SQLException sqle) {
            this.getLogWriter().error((Object)("Got error " + sqle.getSQLState() + "  " + sqle.getErrorCode() + "  " + sqle.getMessage()));
            this.getLogWriter().error((Object)SanityManager.getStackTrace((Throwable)sqle));
        }
        finally {
            this.shutDownEverything(systemconn, scheme, true, false, true, -1);
            systemconn = null;
        }
        try {
            extraServerProps = new Properties();
            this.getLogWriter().info((Object)"rebooting with different system user ... ");
            this.prepareServers(extraServerProps, scheme, true, true, true, false, true, false);
            this.getLogWriter().info((Object)("should have started with system user " + scheme.sysUser + " pwd " + scheme.sysPwd));
            locator = extraServerProps.getProperty("locators");
            systemconn = this.bootRestAsPeerClient(scheme, locator, true);
            this.doPrivilegeChecks(scheme, checkPrivList, sharedSchemaName, false);
        }
        finally {
            this.shutDownEverything(systemconn, scheme, true, false, true, -1);
            systemconn = null;
        }
        try {
            extraServerProps = new Properties();
            this.getLogWriter().info((Object)"rebooting with different system user ... ");
            this.prepareServers(extraServerProps, scheme, true, true, true, false, true, true);
            this.getLogWriter().info((Object)("should have started with system user " + scheme.sysUser + " pwd " + scheme.sysPwd));
            locator = extraServerProps.getProperty("locators");
            systemconn = this.bootRestAsPeerClient(scheme, locator, true);
            this.doPrivilegeChecks(scheme, checkPrivList, sharedSchemaName, true);
        }
        finally {
            this.shutDownEverything(systemconn, scheme, true, false, true, 0);
            systemconn = null;
        }
    }

    private void doPrivilegeChecks(SecurityTestUtils.AuthenticationSchemes scheme, ArrayList<Integer> checkPrivList, String sharedSchemaName, boolean readOnlyConnection) throws SQLException {
        scheme.resetDistUserIndex();
        Properties propsFirstuser = scheme.connectionCredentials(true, false);
        this.getLogWriter().info((Object)("invoking for first user " + propsFirstuser));
        SecurityTestUtils.checkDistUser_everywhere(propsFirstuser, sharedSchemaName, checkPrivList.get(0), readOnlyConnection);
        Properties propsSeconduser = scheme.connectionCredentials(true, false);
        this.getLogWriter().info((Object)("invoking for second user " + propsSeconduser));
        SecurityTestUtils.checkDistUser_everywhere(propsSeconduser, sharedSchemaName, checkPrivList.get(1), readOnlyConnection);
        Properties propsThirduser = scheme.connectionCredentials(true, false);
        this.getLogWriter().info((Object)("invoking for third user " + propsThirduser));
        SecurityTestUtils.checkDistUser_everywhere(propsThirduser, sharedSchemaName, checkPrivList.get(2), readOnlyConnection);
        propsThirduser = scheme.connectionCredentials(true, false);
        this.getLogWriter().info((Object)("invoking for fourth user " + propsThirduser));
        SecurityTestUtils.checkDistUser_everywhere(propsThirduser, sharedSchemaName, checkPrivList.get(3), readOnlyConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClientFailoverWithAuthentication() throws Exception {
        SerializableRunnable expectedException = new SerializableRunnable("GemFireXDAuthenticationDUnit: add expected exception"){

            public void run() {
                FileMonitor monitor = (FileMonitor)Monitor.getCachedMonitorLite((boolean)false);
                monitor.report("<ExpectedException action=add>" + InvalidAlgorithmParameterException.class.getName() + "</ExpectedException>");
                TestUtil.addExpectedException(InvalidAlgorithmParameterException.class);
            }
        };
        SecurityTestUtils.AuthenticationSchemes scheme = SecurityTestUtils.AuthenticationSchemes.LDAP;
        final String locatorPort = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
        final Properties locatorSystemProps = scheme.startupProps(false, true, false, false, false);
        locatorSystemProps.setProperty("gemfirexd.log-level", this.getLogLevel());
        locatorSystemProps.remove("SYS-USER");
        final Properties locatorConnectionCredentials = scheme.bootCredentials();
        TestUtil.bootUserName = locatorConnectionCredentials.getProperty("user");
        TestUtil.bootUserName = TestUtil.bootUserName == null ? locatorConnectionCredentials.getProperty("UserName") : TestUtil.bootUserName;
        TestUtil.bootUserPassword = locatorConnectionCredentials.getProperty("password");
        this.getLogWriter().info((Object)("Recorded bootUserName " + TestUtil.bootUserName));
        String userName = locatorConnectionCredentials.getProperty("user");
        userName = userName == null ? locatorConnectionCredentials.getProperty("UserName") : userName;
        locatorSystemProps.setProperty("gemfirexd.user." + userName, locatorConnectionCredentials.getProperty("password"));
        locatorSystemProps.putAll((Map<?, ?>)locatorConnectionCredentials);
        this.getLogWriter().info((Object)("locator system props " + locatorSystemProps));
        SerializableCallable startlocator = new SerializableCallable("starting locator"){

            public Object call() {
                String currentHost = DistributedTestBase.getIPLiteral();
                try {
                    Enumeration<?> e = locatorSystemProps.propertyNames();
                    while (e.hasMoreElements()) {
                        Object k = e.nextElement();
                        if (k == null || !(k instanceof String) || !((String)k).contains("auth-ldap")) continue;
                        String v = locatorSystemProps.getProperty((String)k);
                        System.setProperty((String)k, v);
                    }
                    TestUtil.doCommonSetup(locatorSystemProps);
                    String sysDirName = GemFireXDAuthenticationDUnit.getSysDirName();
                    locatorSystemProps.setProperty("sys-disk-dir", sysDirName);
                    FabricLocator locator = FabricServiceManager.getFabricLocatorInstance();
                    locator.start(currentHost, Integer.parseInt(locatorPort), locatorSystemProps);
                    TestUtil.bootUserName = locatorConnectionCredentials.getProperty("user");
                    TestUtil.bootUserName = TestUtil.bootUserName == null ? locatorConnectionCredentials.getProperty("UserName") : TestUtil.bootUserName;
                    TestUtil.bootUserPassword = locatorConnectionCredentials.getProperty("password");
                    GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("Recorded bootUserName " + TestUtil.bootUserName));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    GemFireXDAuthenticationDUnit.this.getLogWriter().error((Object)"NumberFormatException occurred ", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    GemFireXDAuthenticationDUnit.this.getLogWriter().error((Object)"SQLException occurred ", (Throwable)e);
                    throw new RuntimeException(e);
                }
                GemFireXDAuthenticationDUnit.this.getLogWriter().info((Object)("returning currentHost" + currentHost));
                return currentHost;
            }
        };
        VM vm1 = Host.getHost((int)0).getVM(0);
        this.getLogWriter().info((Object)("Choosen vm1 pid = " + vm1.getPid() + " as locator VM and adding it to serverVM list. PropertyList " + locatorSystemProps));
        vm1.invoke((Runnable)expectedException);
        String locatorhost = (String)vm1.invoke((Callable)startlocator);
        this.serverVMs.add(vm1);
        Properties networkServerProperties = new Properties();
        int locatorNetPort = this.startNetworkServer(1, null, networkServerProperties);
        this.getLogWriter().info((Object)("n/w server on Locator with " + locatorNetPort));
        String locator = locatorhost + "[" + locatorPort + "]";
        this.getLogWriter().info((Object)("locator string " + locator));
        VM vm2 = Host.getHost((int)0).getVM(1);
        vm2.invoke((Runnable)expectedException);
        Properties serverSystemProps = new Properties();
        serverSystemProps.putAll((Map<?, ?>)locatorSystemProps);
        TestUtil.doCommonSetup(serverSystemProps);
        serverSystemProps.setProperty("locators", locator);
        String vm2info = " vm2 pid = " + vm2.getPid();
        this.getLogWriter().info((Object)("start server " + vm2info + " with properties .... " + serverSystemProps));
        this.startVMs(0, 1, 0, null, serverSystemProps);
        int server1NetPort = this.startNetworkServer(2, null, networkServerProperties);
        this.getLogWriter().info((Object)("connecting to n/w server with " + locatorConnectionCredentials));
        Connection netConn = TestUtil.getNetConnection(locatorNetPort, "", locatorConnectionCredentials);
        netConn.setTransactionIsolation(0);
        netConn.setAutoCommit(false);
        this.getLogWriter().info((Object)("n/w server started with " + server1NetPort));
        Statement netSt = netConn.createStatement();
        ResultSet rs = netSt.executeQuery("select * from sys.systables");
        while (rs.next()) {
            this.getLogWriter().info((Object)String.valueOf(rs.getObject(1)));
        }
        VM vm3 = Host.getHost((int)0).getVM(2);
        vm3.invoke((Runnable)expectedException);
        String vm3info = " vm3 pid = " + vm3.getPid();
        this.getLogWriter().info((Object)("start server " + vm3info + " with properties .... " + serverSystemProps));
        this.startVMs(0, 1, 0, null, serverSystemProps);
        int server2NetPort = this.startNetworkServer(3, null, networkServerProperties);
        this.getLogWriter().info((Object)("n/w server started with " + server2NetPort));
        this.stopVMNum(-2);
        this.getLogWriter().info((Object)"Checking after failover ");
        rs = netSt.executeQuery("select * from sys.systables");
        while (rs.next()) {
            this.getLogWriter().info((Object)String.valueOf(rs.getObject(1)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testDERBY_WithAuthorizationSchemaSharing() throws Exception {
        block53: {
            Statement dbStmt;
            Connection dbconn;
            String bootUserPassword;
            String bootUserName;
            Properties propsToClear;
            block51: {
                block50: {
                    ResultSet rs;
                    block49: {
                        block48: {
                            block47: {
                                SecurityTestUtils.AuthenticationSchemes scheme = SecurityTestUtils.AuthenticationSchemes.BUILTIN;
                                String sharedSchemaName = "derbySharedTest".toUpperCase();
                                Connection systemconn = null;
                                Properties props = new Properties();
                                propsToClear = new Properties();
                                bootUserName = null;
                                bootUserPassword = null;
                                Properties sysprop = scheme.startupProps(true, true, true, false, false);
                                Enumeration<?> e = sysprop.propertyNames();
                                while (e.hasMoreElements()) {
                                    Object k = (String)e.nextElement();
                                    String val = sysprop.getProperty((String)k);
                                    if (((String)(k = "gemfirexd.authentication.required".equals(k) ? "derby.connection.requireAuthentication" : ("gemfirexd.auth-provider".equals(k) ? "derby.authentication.provider" : ("gemfirexd.sql-authorization".equals(k) ? "derby.database.sqlAuthorization" : ("gemfirexd.authz-default-connection-mode".equals(k) ? "derby.database.defaultConnectionMode" : ("gemfirexd.authz-full-access-users".equals(k) ? "derby.database.fullAccessUsers" : ((String)k).replace("gemfirexd.", "derby."))))))).contains("UserName")) {
                                        k = ((String)k).replace("UserName", "user");
                                    }
                                    if (((String)k).startsWith("derby.user.SYSTEM_")) {
                                        val = scheme.bootCredentials().getProperty("password");
                                    }
                                    this.getLogWriter().info((Object)("setting property " + (String)k + " = " + val));
                                    System.setProperty((String)k, val);
                                    propsToClear.put(k, val);
                                }
                                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                                props.putAll((Map<?, ?>)scheme.bootCredentials());
                                this.getLogWriter().info((Object)("About to start with properties .... " + props));
                                bootUserName = props.getProperty("user");
                                bootUserName = bootUserName == null ? props.getProperty("UserName") : bootUserName;
                                bootUserPassword = props.getProperty("password");
                                String derbyConn = "jdbc:derby:newDerbySecDB;";
                                String sysConnUrl = "jdbc:derby:newDerbySecDB;create=true;user=" + bootUserName + ";password=" + bootUserPassword;
                                this.getLogWriter().info((Object)("Connecting system user with " + sysConnUrl));
                                systemconn = DriverManager.getConnection(sysConnUrl);
                                Statement stmts = systemconn.createStatement();
                                stmts.execute("create table SampleTable (i int, j int)");
                                stmts.execute("create schema " + sharedSchemaName);
                                stmts.execute("insert into " + bootUserName + ".SampleTable values(1,1)");
                                stmts.execute("SET SCHEMA " + sharedSchemaName);
                                stmts.execute("create table SharedTable (i int, j int)");
                                stmts.execute("insert into SharedTable values(1,1), (2,2), (3,3)");
                                stmts.close();
                                this.getLogWriter().info((Object)"about to create distributed sys users ");
                                CallableStatement cusr = systemconn.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?,?)");
                                for (String u : scheme.clusterUsers) {
                                    cusr.setString(1, "derby.user." + u);
                                    cusr.setString(2, "PWD_" + u);
                                    cusr.execute();
                                    this.getLogWriter().info((Object)("created database user " + u));
                                }
                                systemconn.close();
                                String connUrl = "jdbc:derby:newDerbySecDB;user=" + scheme.clusterUsers[2] + ";password=PWD_" + scheme.clusterUsers[2];
                                this.getLogWriter().info((Object)("Connection using database user " + connUrl));
                                dbconn = DriverManager.getConnection(connUrl);
                                dbStmt = dbconn.createStatement();
                                SecurityTestUtils.assertCurrentSchema(dbStmt, scheme.clusterUsers[2]);
                                this.getLogWriter().info((Object)"switching to shared schema ");
                                dbStmt.execute("SET SCHEMA " + sharedSchemaName);
                                SecurityTestUtils.assertCurrentSchema(dbStmt, sharedSchemaName);
                                try {
                                    this.getLogWriter().info((Object)"browsing SharedTable ");
                                    rs = dbconn.createStatement().executeQuery("select count(1) from SharedTable");
                                    GemFireXDAuthenticationDUnit.fail((String)"expected derby table authorization exception ");
                                }
                                catch (SQLException sqle) {
                                    if (sqle.getSQLState().equals("42500")) break block47;
                                    GemFireXDAuthenticationDUnit.fail((String)(sqle.getSQLState() + " unexpected exception received " + sqle));
                                }
                            }
                            try {
                                this.getLogWriter().info((Object)"expecting auth failure while inserting to SharedTable ");
                                dbStmt.execute("insert into SharedTable values(4,4), (5,5), (6,6)");
                                GemFireXDAuthenticationDUnit.fail((String)"expected derby authorization exception ");
                            }
                            catch (SQLException expected) {
                                if (dbconn.isReadOnly() && !expected.getSQLState().equals("25502")) {
                                    GemFireXDAuthenticationDUnit.fail((String)(expected.getSQLState() + " unexpected exception on readonly connection received " + expected));
                                }
                                if (expected.getSQLState().equals("42500")) break block48;
                                GemFireXDAuthenticationDUnit.fail((String)(expected.getSQLState() + " unexpected exception received " + expected));
                            }
                        }
                        try {
                            rs = dbconn.createStatement().executeQuery("select count(1) from SharedTable");
                            GemFireXDAuthenticationDUnit.fail((String)"expected derby table authorization exception ");
                        }
                        catch (SQLException sqle) {
                            if (sqle.getSQLState().equals("42500")) break block49;
                            GemFireXDAuthenticationDUnit.fail((String)(sqle.getSQLState() + " unexpected exception received " + sqle));
                        }
                    }
                    try {
                        this.getLogWriter().info((Object)("browsing " + bootUserName + ".SampleTable "));
                        rs = dbconn.createStatement().executeQuery("select count(1) from " + bootUserName + ".SampleTable");
                        GemFireXDAuthenticationDUnit.fail((String)"expected derby table authorization exception ");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getSQLState().equals("42500")) break block50;
                        GemFireXDAuthenticationDUnit.fail((String)(sqle.getSQLState() + " unexpected exception received " + sqle));
                    }
                }
                try {
                    this.getLogWriter().info((Object)("expecting auth failure while  inserting to " + bootUserName + ".SampleTable "));
                    dbconn.createStatement().execute("insert into " + bootUserName + ".SampleTable values(1,1)");
                    GemFireXDAuthenticationDUnit.fail((String)"expected derby authorization exception ");
                }
                catch (SQLException expected) {
                    if (dbconn.isReadOnly() && !expected.getSQLState().equals("25502")) {
                        GemFireXDAuthenticationDUnit.fail((String)(expected.getSQLState() + " unexpected exception on readonly connection received " + expected));
                    }
                    if (expected.getSQLState().equals("42500")) break block51;
                    GemFireXDAuthenticationDUnit.fail((String)(expected.getSQLState() + " unexpected exception received " + expected));
                }
            }
            dbStmt.close();
            dbconn.close();
            String shuturl = "jdbc:derby:;shutdown=true;user=" + bootUserName + ";password=" + bootUserPassword + ";";
            this.getLogWriter().info((Object)("Shutting down the apache EmbeddedDriver " + shuturl));
            try {
                DriverManager.getConnection(shuturl);
            }
            catch (SQLException ex) {
                this.getLogWriter().info((Object)("sqlstate " + ex.getSQLState() + "  " + ex.getErrorCode()));
                if (!ex.getSQLState().equals("XJ015")) {
                    if (ex.getErrorCode() != 50000) {
                        this.getLogWriter().error((Object)SanityManager.getStackTrace((Throwable)ex));
                        throw ex;
                    }
                }
            }
            finally {
                for (Object k : propsToClear.keySet()) {
                    System.clearProperty((String)k);
                }
            }
            break block53;
            catch (SQLException sqle) {
                this.getLogWriter().error((Object)("Got error " + sqle.getSQLState() + "  " + sqle.getErrorCode() + "  " + sqle.getMessage()));
                this.getLogWriter().error((Object)SanityManager.getStackTrace((Throwable)sqle));
                shuturl = "jdbc:derby:;shutdown=true;user=" + bootUserName + ";password=" + bootUserPassword + ";";
                this.getLogWriter().info((Object)("Shutting down the apache EmbeddedDriver " + shuturl));
                try {
                    DriverManager.getConnection(shuturl);
                }
                catch (SQLException ex) {
                    this.getLogWriter().info((Object)("sqlstate " + ex.getSQLState() + "  " + ex.getErrorCode()));
                    if (!ex.getSQLState().equals("XJ015")) {
                        if (ex.getErrorCode() != 50000) {
                            this.getLogWriter().error((Object)SanityManager.getStackTrace((Throwable)ex));
                            throw ex;
                        }
                    }
                }
                finally {
                    for (Object k2 : propsToClear.keySet()) {
                        System.clearProperty((String)k2);
                    }
                }
                catch (Throwable throwable) {
                    String shuturl2 = "jdbc:derby:;shutdown=true;user=" + bootUserName + ";password=" + bootUserPassword + ";";
                    this.getLogWriter().info((Object)("Shutting down the apache EmbeddedDriver " + shuturl2));
                    try {
                        DriverManager.getConnection(shuturl2);
                    }
                    catch (SQLException ex) {
                        this.getLogWriter().info((Object)("sqlstate " + ex.getSQLState() + "  " + ex.getErrorCode()));
                        if (!ex.getSQLState().equals("XJ015")) {
                            if (ex.getErrorCode() != 50000) {
                                this.getLogWriter().error((Object)SanityManager.getStackTrace((Throwable)ex));
                                throw ex;
                            }
                        }
                    }
                    finally {
                        for (Object k3 : propsToClear.keySet()) {
                            System.clearProperty((String)k3);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureUsers(SecurityTestUtils.AuthenticationSchemes scheme, String sharedSchemaName) throws Exception {
        Connection systemconn = null;
        try {
            Properties extraServerProps = new Properties();
            this.prepareServers(extraServerProps, scheme, true, false, true, false, false, false);
            String locator = extraServerProps.getProperty("locators");
            this.getLogWriter().info((Object)"booting all clients ");
            systemconn = this.bootRestAsPeerClient(scheme, locator, false);
            scheme.CreateUsers(systemconn);
            this.getLogWriter().info((Object)"Acquired Connection, will create tables/schemas");
            Statement stmts = systemconn.createStatement();
            stmts.execute("create table SampleTable (i int, j int)");
            if (sharedSchemaName != null) {
                stmts.execute("create schema " + sharedSchemaName);
                stmts.execute("SET SCHEMA " + sharedSchemaName);
            }
            SecurityTestUtils.tables.SharedTable.createTable(stmts);
            SecurityTestUtils.tables.SharedTable.doInsert(stmts, "(1,1,1)", "(2,2,2)", "(3,3,3)");
            stmts.execute("SET CURRENT SCHEMA USER");
            if (systemconn == null) return;
        }
        catch (Exception ex) {
            try {
                GemFireXDAuthenticationDUnit.fail("Got exception ", ex);
                if (systemconn == null) return;
            }
            catch (Throwable throwable) {
                if (systemconn == null) throw throwable;
                this.shutDownEverything(systemconn, scheme, true, false, true, -1);
                systemconn.close();
                systemconn = null;
                throw throwable;
            }
            this.shutDownEverything(systemconn, scheme, true, false, true, -1);
            systemconn.close();
            return;
        }
        this.shutDownEverything(systemconn, scheme, true, false, true, -1);
        systemconn.close();
        return;
    }

    private void prepareServers(Properties props, SecurityTestUtils.AuthenticationSchemes scheme, boolean setExplicitPeerAuth, boolean restart, boolean withAuthorization, boolean skipPersistedDDLReplay, boolean generateOnlyNewSysUser, boolean createReadOnlyConnection) throws Exception {
        Properties sysprop = scheme.startupProps(setExplicitPeerAuth, true, withAuthorization, generateOnlyNewSysUser, createReadOnlyConnection);
        SecurityTestUtils.setupAuthentication(scheme, sysprop);
        String locator = scheme.getLocatorString();
        props.setProperty("mcast-port", "0");
        props.setProperty("start-locator", locator);
        props.setProperty("locators", locator);
        props.setProperty("host-data", "true");
        TestUtil.deletePersistentFiles = skipPersistedDDLReplay;
        props.putAll((Map<?, ?>)scheme.bootCredentials());
        this.getLogWriter().info((Object)("About to start with properties .... " + props));
        if (!restart) {
            this.startVMs(0, 1, 0, null, props);
        } else {
            this.restartServerVMNums(new int[]{1}, 0, null, props);
        }
        props.remove("start-locator");
        if (!restart) {
            this.startVMs(0, 1, 0, null, props);
        } else {
            this.restartServerVMNums(new int[]{2}, 0, null, props);
        }
    }

    private Connection bootRestAsPeerClient(SecurityTestUtils.AuthenticationSchemes scheme, String locator, boolean restart) throws Exception {
        Properties connectionProp = new Properties();
        connectionProp.putAll((Map<?, ?>)scheme.bootCredentials());
        connectionProp.setProperty("locators", locator);
        connectionProp.setProperty("mcast-port", "0");
        connectionProp.setProperty("host-data", "false");
        TestUtil.deletePersistentFiles = false;
        int thst = Host.getHostCount();
        for (int h = thst - 1; h >= 0; --h) {
            int tvms;
            if (!restart) {
                tvms = Host.getHost((int)h).getVMCount() - this.serverVMs.size() + 1;
                this.getLogWriter().info((Object)("starting " + tvms + " clients because there are " + this.serverVMs.size() + " serverVMs. client start properties: " + connectionProp));
                this.startVMs(tvms, 0, 0, null, connectionProp);
                continue;
            }
            tvms = this.clientVMs.size();
            int[] vms = new int[tvms];
            for (int i = 1; i <= tvms; ++i) {
                this.getLogWriter().info((Object)("restarting clients " + i + " of host " + h + " with " + connectionProp));
                vms[i - 1] = i;
            }
            this.restartClientVMNums(vms, 0, null, connectionProp);
        }
        connectionProp = scheme.bootCredentials();
        this.getLogWriter().info((Object)("Connecting to distributed system using system user " + connectionProp));
        TestUtil.loadDriver();
        Connection conn = DriverManager.getConnection(TestUtil.getProtocol(), connectionProp);
        return conn;
    }

    private void shutDownEverything(Connection systemconn, SecurityTestUtils.AuthenticationSchemes scheme, boolean explicitAuthentication, boolean dropDistUser, boolean clearSystemUser, int lastVMNum) throws Exception {
        this.getLogWriter().info((Object)"Shutting down the servers and local EmbeddedDriver ");
        if (dropDistUser) {
            scheme.DropUsers(systemconn);
        }
        try {
            this.stopAllVMsAsync(lastVMNum);
        }
        catch (Throwable t) {
            throw new Exception("exception while shutting down", t);
        }
        if (clearSystemUser) {
            Properties sysprop = scheme.startupProps(explicitAuthentication, false, false, false, false);
            SecurityTestUtils.clearAuthenticationSetUp(sysprop, scheme);
        }
    }

    public void test48314AlterPriv() throws Exception {
        ResultSet rs;
        Statement systemUser_stmt;
        block8: {
            Statement user1_stmt;
            block7: {
                int locPort = AvailablePort.getRandomAvailablePort((int)0);
                Properties props = new Properties();
                props.setProperty("start-locator", "localhost[" + locPort + ']');
                props.setProperty("auth-provider", "BUILTIN");
                props.setProperty("gemfirexd.user.sd", "pwd");
                props.setProperty("user", "sd");
                props.setProperty("password", "pwd");
                props.setProperty("gemfirexd.sql-authorization", "true");
                this.startVMs(0, 1, 0, null, props);
                props.remove("start-locator");
                props.setProperty("locators", "localhost[" + locPort + ']');
                this.startVMs(1, 3, 0, null, props);
                Properties props2 = new Properties();
                props2.setProperty("user", "sd");
                props2.setProperty("password", "pwd");
                Connection conn1 = TestUtil.getConnection(props2);
                systemUser_stmt = conn1.createStatement();
                systemUser_stmt.execute("call sys.create_user('user1', 'a')");
                systemUser_stmt.execute("create table t1(col1 int not null, col2 int)");
                systemUser_stmt.execute("insert into t1 values (1, 1)");
                props2.setProperty("user", "user1");
                props2.setProperty("password", "a");
                Connection conn2 = TestUtil.getConnection(props2);
                user1_stmt = conn2.createStatement();
                user1_stmt.execute("create table user1.t2(col1 int)");
                user1_stmt.execute("insert into user1.t2 values (1)");
                user1_stmt.execute("alter table user1.t2 add column col2 int");
                rs = user1_stmt.executeQuery("select col1 from user1.t2");
                GemFireXDAuthenticationDUnit.assertTrue((boolean)rs.next());
                rs.close();
                user1_stmt.execute("alter table user1.t2 drop column col2 restrict");
                try {
                    user1_stmt.execute("alter table sd.t1 add column col3 int");
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("42500")) break block7;
                    throw se;
                }
            }
            systemUser_stmt.execute("grant select, alter on sd.t1 to user1");
            user1_stmt.execute("alter table sd.t1 add column col3 int");
            rs = user1_stmt.executeQuery("select col1 from sd.t1");
            GemFireXDAuthenticationDUnit.assertTrue((boolean)rs.next());
            GemFireXDAuthenticationDUnit.assertFalse((boolean)rs.next());
            rs.close();
            user1_stmt.execute("alter table sd.t1 drop column col3 restrict");
            systemUser_stmt.execute("revoke alter on sd.t1 from user1");
            try {
                user1_stmt.execute("alter table sd.t1 add column col3 int");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42500")) {
                    rs = user1_stmt.executeQuery("select col1 from sd.t1");
                    GemFireXDAuthenticationDUnit.assertTrue((boolean)rs.next());
                    GemFireXDAuthenticationDUnit.assertFalse((boolean)rs.next());
                    rs.close();
                }
                throw se;
            }
            systemUser_stmt.execute("grant all privileges on sd.t1 to user1");
            user1_stmt.execute("alter table sd.t1 add column col3 int");
            rs = user1_stmt.executeQuery("select col1 from sd.t1");
            GemFireXDAuthenticationDUnit.assertTrue((boolean)rs.next());
            GemFireXDAuthenticationDUnit.assertFalse((boolean)rs.next());
            rs.close();
            user1_stmt.execute("alter table sd.t1 drop column col3 restrict");
            systemUser_stmt.execute("revoke all privileges on sd.t1 from user1");
            try {
                user1_stmt.execute("alter table sd.t1 add column col3 int");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42500")) break block8;
                throw se;
            }
        }
        systemUser_stmt.execute("alter table sd.t1 add column col3 int");
        rs = systemUser_stmt.executeQuery("select col1 from sd.t1");
        GemFireXDAuthenticationDUnit.assertTrue((boolean)rs.next());
        GemFireXDAuthenticationDUnit.assertFalse((boolean)rs.next());
        rs.close();
        systemUser_stmt.execute("alter table sd.t1 drop column col3 restrict");
        systemUser_stmt.execute("alter table user1.t2 add column col2 int");
        rs = systemUser_stmt.executeQuery("select col1 from user1.t2");
        GemFireXDAuthenticationDUnit.assertTrue((boolean)rs.next());
        GemFireXDAuthenticationDUnit.assertFalse((boolean)rs.next());
        rs.close();
        systemUser_stmt.execute("alter table user1.t2 drop column col2 restrict");
    }

    public void testTempTableBug50505() throws Exception {
        int locPort = AvailablePort.getRandomAvailablePort((int)0);
        Properties props = new Properties();
        props.setProperty("start-locator", "localhost[" + locPort + ']');
        props.setProperty("auth-provider", "BUILTIN");
        props.setProperty("sqlfire.user.sd", "pwd");
        props.setProperty("user", "sd");
        props.setProperty("password", "pwd");
        props.setProperty("sqlfire.sql-authorization", "true");
        this.startVMs(0, 1, 0, null, props);
        props.remove("start-locator");
        props.setProperty("locators", "localhost[" + locPort + ']');
        this.startVMs(1, 3, 0, null, props);
        Properties props2 = new Properties();
        props2.setProperty("user", "sd");
        props2.setProperty("password", "pwd");
        Connection conn1 = TestUtil.getConnection(props2);
        conn1.setAutoCommit(true);
        Statement systemUser_stmt = conn1.createStatement();
        systemUser_stmt.execute("call sys.create_user('user1', 'a')");
        props2.setProperty("user", "user1");
        props2.setProperty("password", "a");
        Connection conn2 = TestUtil.getConnection(props2);
        conn2.setAutoCommit(false);
        Statement user1_stmt = conn2.createStatement();
        systemUser_stmt.execute("DECLARE GLOBAL TEMPORARY TABLE session.test_A_P (aa varchar(20)) NOT LOGGED");
        systemUser_stmt.execute("insert into session.test_A_P values ('aaa')");
        systemUser_stmt.execute("select * from session.test_A_P");
        ResultSet rs = systemUser_stmt.getResultSet();
        GemFireXDAuthenticationDUnit.assertFalse((boolean)rs.next());
        rs.close();
        systemUser_stmt.execute("drop table session.test_A_P");
        systemUser_stmt.execute("DECLARE GLOBAL TEMPORARY TABLE session.test_A_P (aa varchar(20)) ON COMMIT PRESERVE ROWS NOT LOGGED");
        systemUser_stmt.execute("insert into session.test_A_P values ('aaa')");
        systemUser_stmt.execute("select * from session.test_A_P");
        rs = systemUser_stmt.getResultSet();
        GemFireXDAuthenticationDUnit.assertTrue((boolean)rs.next());
        GemFireXDAuthenticationDUnit.assertEquals((String)"aaa", (String)rs.getString(1));
        rs.close();
        systemUser_stmt.execute("drop table session.test_A_P");
        user1_stmt.execute("DECLARE GLOBAL TEMPORARY TABLE session.test_A_U (aa varchar(20)) NOT LOGGED");
        user1_stmt.execute("insert into session.test_A_U values ('aaa')");
        user1_stmt.execute("select * from session.test_A_U");
        rs = user1_stmt.getResultSet();
        GemFireXDAuthenticationDUnit.assertTrue((boolean)rs.next());
        GemFireXDAuthenticationDUnit.assertEquals((String)"aaa", (String)rs.getString(1));
        rs.close();
        conn2.commit();
        user1_stmt.execute("insert into session.test_A_U values ('aaa')");
        conn2.commit();
        user1_stmt.execute("select * from session.test_A_U");
        rs = user1_stmt.getResultSet();
        GemFireXDAuthenticationDUnit.assertFalse((boolean)rs.next());
        rs.close();
        user1_stmt.execute("drop table session.test_A_U");
    }

    public void testset_fullaccess() throws Exception {
        int locPort = AvailablePort.getRandomAvailablePort((int)0);
        Properties props = new Properties();
        props.setProperty("start-locator", "localhost[" + locPort + ']');
        props.setProperty("auth-provider", "BUILTIN");
        props.setProperty("sqlfire.user.sd", "pwd");
        props.setProperty("user", "sd");
        props.setProperty("password", "pwd");
        props.setProperty("gemfirexd.sql-authorization", "false");
        props.setProperty("gemfirexd.authz-default-connection-mode", "FULLACCESS");
        this.startVMs(0, 1, 0, null, props);
        props.remove("start-locator");
        props.setProperty("locators", "localhost[" + locPort + ']');
        this.startVMs(1, 3, 0, null, props);
        Properties props2 = new Properties();
        props2.setProperty("user", "sd");
        props2.setProperty("password", "pwd");
        Connection conn1 = TestUtil.getConnection(props2);
        Statement systemUser_stmt = conn1.createStatement();
        systemUser_stmt.execute("call sys.create_user('user1', 'a')");
        systemUser_stmt.execute("call sys.create_user('user2', 'b')");
        systemUser_stmt.execute("create table s1(col1 int)");
        props2.setProperty("user", "user1");
        props2.setProperty("password", "a");
        Connection conn2 = TestUtil.getConnection(props2);
        Statement user1_stmt = conn2.createStatement();
        user1_stmt.execute("create table t1(col1 int)");
        user1_stmt.execute("insert into t1 values(1)");
        conn2.close();
        props2.setProperty("user", "user2");
        props2.setProperty("password", "b");
        Connection conn3 = TestUtil.getConnection(props2);
        Statement user2_stmt = conn3.createStatement();
        user2_stmt.execute("insert into user1.t1 values(1)");
    }

    public void testset_readonlyaccess() throws Exception {
        Connection conn2;
        block2: {
            int locPort = AvailablePort.getRandomAvailablePort((int)0);
            Properties props = new Properties();
            props.setProperty("start-locator", "localhost[" + locPort + ']');
            props.setProperty("auth-provider", "BUILTIN");
            props.setProperty("sqlfire.user.sd", "pwd");
            props.setProperty("user", "sd");
            props.setProperty("password", "pwd");
            props.setProperty("gemfirexd.sql-authorization", "false");
            props.setProperty("gemfirexd.authz-default-connection-mode", "READONLYACCESS");
            props.setProperty("authz-full-access-users", "sd");
            this.startVMs(0, 1, 0, null, props);
            props.remove("start-locator");
            props.setProperty("locators", "localhost[" + locPort + ']');
            this.startVMs(1, 3, 0, null, props);
            Properties props2 = new Properties();
            props2.setProperty("user", "sd");
            props2.setProperty("password", "pwd");
            Connection conn1 = TestUtil.getConnection(props2);
            Statement systemUser_stmt = conn1.createStatement();
            systemUser_stmt.execute("call sys.create_user('user1', 'a')");
            systemUser_stmt.execute("create table s1(col1 int)");
            props2.setProperty("user", "user1");
            props2.setProperty("password", "a");
            conn2 = TestUtil.getConnection(props2);
            Statement user1_stmt = conn2.createStatement();
            user1_stmt.execute("select * from sd.s1");
            try {
                user1_stmt.execute("create table t1(col1 int)");
                GemFireXDAuthenticationDUnit.fail((String)"should throw exception");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("25503")) break block2;
                throw se;
            }
        }
        conn2.close();
    }

    public void testset_noaccess() throws Exception {
        block2: {
            int locPort = AvailablePort.getRandomAvailablePort((int)0);
            Properties props = new Properties();
            props.setProperty("start-locator", "localhost[" + locPort + ']');
            props.setProperty("auth-provider", "BUILTIN");
            props.setProperty("sqlfire.user.sd", "pwd");
            props.setProperty("user", "sd");
            props.setProperty("password", "pwd");
            props.setProperty("gemfirexd.sql-authorization", "false");
            props.setProperty("gemfirexd.authz-default-connection-mode", "NOACCESS");
            props.setProperty("authz-full-access-users", "sd");
            this.startVMs(0, 1, 0, null, props);
            props.remove("start-locator");
            props.setProperty("locators", "localhost[" + locPort + ']');
            this.startVMs(1, 3, 0, null, props);
            Properties props2 = new Properties();
            props2.setProperty("user", "sd");
            props2.setProperty("password", "pwd");
            Connection conn1 = TestUtil.getConnection(props2);
            Statement systemUser_stmt = conn1.createStatement();
            systemUser_stmt.execute("call sys.create_user('user1', 'a')");
            systemUser_stmt.execute("create table s1(col1 int)");
            props2.setProperty("user", "user1");
            props2.setProperty("password", "a");
            try {
                Connection connection = TestUtil.getConnection(props2);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("08004")) break block2;
                throw se;
            }
        }
    }

    public void testset_user_access_proc() throws Exception {
        Statement systemUser_stmt;
        block11: {
            Properties props2;
            block10: {
                Connection conn3;
                block9: {
                    Statement user2_stmt;
                    Statement user1_stmt;
                    Connection conn2;
                    Properties startupProps;
                    int locPort;
                    block8: {
                        locPort = AvailablePort.getRandomAvailablePort((int)0);
                        startupProps = new Properties();
                        startupProps.setProperty("start-locator", "localhost[" + locPort + ']');
                        Properties authProperties = new Properties();
                        authProperties.setProperty("auth-provider", "BUILTIN");
                        authProperties.setProperty("sqlfire.user.sd", "pwd");
                        authProperties.setProperty("user", "sd");
                        authProperties.setProperty("password", "pwd");
                        authProperties.setProperty("gemfirexd.sql-authorization", "true");
                        authProperties.setProperty("gemfirexd.authz-default-connection-mode", "NOACCESS");
                        authProperties.setProperty("authz-full-access-users", "sd");
                        startupProps.putAll((Map<?, ?>)authProperties);
                        this.startVMs(0, 1, 0, null, startupProps);
                        startupProps.remove("start-locator");
                        startupProps.setProperty("locators", "localhost[" + locPort + ']');
                        this.startVMs(1, 3, 0, null, startupProps);
                        props2 = new Properties();
                        props2.setProperty("user", "sd");
                        props2.setProperty("password", "pwd");
                        Connection conn1 = TestUtil.getConnection(props2);
                        systemUser_stmt = conn1.createStatement();
                        systemUser_stmt.execute("call sys.create_user('user1', 'a')");
                        systemUser_stmt.execute("call sys.create_user('user2', 'b')");
                        systemUser_stmt.execute("CALL SYSCS_UTIL.SET_USER_ACCESS ('user1', 'FULLACCESS')");
                        systemUser_stmt.execute("CALL SYSCS_UTIL.SET_USER_ACCESS ('USER2', 'READONLYACCESS')");
                        this.verifyUserAccess(systemUser_stmt, "user1", "FULLACCESS");
                        this.verifyUserAccess(systemUser_stmt, "USER2", "READONLYACCESS");
                        systemUser_stmt.execute("create table s1(col1 int)");
                        props2.setProperty("user", "user1");
                        props2.setProperty("password", "a");
                        conn2 = TestUtil.getConnection(props2);
                        user1_stmt = conn2.createStatement();
                        user1_stmt.execute("create table t1(col1 int)");
                        user1_stmt.execute("insert into t1 values(1)");
                        user1_stmt.execute("drop table t1");
                        conn2.close();
                        props2.setProperty("user", "user2");
                        props2.setProperty("password", "b");
                        conn3 = TestUtil.getConnection(props2);
                        user2_stmt = conn3.createStatement();
                        try {
                            user2_stmt.execute("create table t1(col1 int)");
                            GemFireXDAuthenticationDUnit.fail((String)"should throw exception");
                        }
                        catch (SQLException se) {
                            if (se.getSQLState().equals("25503")) break block8;
                            throw se;
                        }
                    }
                    conn3.close();
                    startupProps.setProperty("start-locator", "localhost[" + locPort + ']');
                    startupProps.remove("locators");
                    this.restartServerVMNums(new int[]{1}, 0, null, null);
                    startupProps.remove("start-locator");
                    startupProps.setProperty("locators", "localhost[" + locPort + ']');
                    this.restartServerVMNums(new int[]{2, 3, 4}, 0, null, null);
                    this.restartClientVMNums(new int[]{1}, 0, null, startupProps);
                    props2.setProperty("user", "user1");
                    props2.setProperty("password", "a");
                    conn2 = TestUtil.getConnection(props2);
                    user1_stmt = conn2.createStatement();
                    user1_stmt.execute("create table t1(col1 int)");
                    user1_stmt.execute("insert into t1 values(1)");
                    user1_stmt.execute("drop table t1");
                    conn2.close();
                    props2.setProperty("user", "user2");
                    props2.setProperty("password", "b");
                    conn3 = TestUtil.getConnection(props2);
                    user2_stmt = conn3.createStatement();
                    try {
                        user2_stmt.execute("create table t1(col1 int)");
                        GemFireXDAuthenticationDUnit.fail((String)"should throw exception");
                    }
                    catch (SQLException se) {
                        if (se.getSQLState().equals("25503")) break block9;
                        throw se;
                    }
                }
                conn3.close();
                systemUser_stmt.execute("CALL SYSCS_UTIL.SET_USER_ACCESS ('USER1', NULL)");
                systemUser_stmt.execute("CALL SYSCS_UTIL.SET_USER_ACCESS ('USER2', NULL)");
                props2.setProperty("user", "user1");
                props2.setProperty("password", "a");
                try {
                    TestUtil.getConnection(props2);
                    GemFireXDAuthenticationDUnit.fail((String)"should not have allowed a connection");
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("08004")) break block10;
                    throw se;
                }
            }
            props2.setProperty("user", "user2");
            props2.setProperty("password", "b");
            try {
                TestUtil.getConnection(props2);
                GemFireXDAuthenticationDUnit.fail((String)"should not have allowed a connection");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("08004")) break block11;
                throw se;
            }
        }
        this.verifyUserAccess(systemUser_stmt, "user1", "NOACCESS");
        this.verifyUserAccess(systemUser_stmt, "user2", "NOACCESS");
    }

    private void verifyUserAccess(Statement systemUser_stmt, String user, String expectedAccessLevel) throws SQLException {
        systemUser_stmt.execute("VALUES SYSCS_UTIL.GET_USER_ACCESS ('" + user + "')");
        ResultSet rs = systemUser_stmt.getResultSet();
        GemFireXDAuthenticationDUnit.assertTrue((boolean)rs.next());
        GemFireXDAuthenticationDUnit.assertEquals((String)expectedAccessLevel, (String)rs.getString(1));
        rs.close();
    }

    public void testset_user_access_proc2() throws Exception {
        Statement user1_stmt;
        Statement systemUser_stmt;
        Properties props2;
        block5: {
            Connection conn2;
            block4: {
                int locPort = AvailablePort.getRandomAvailablePort((int)0);
                Properties startupProps = new Properties();
                startupProps.setProperty("start-locator", "localhost[" + locPort + ']');
                Properties authProperties = new Properties();
                authProperties.setProperty("auth-provider", "BUILTIN");
                authProperties.setProperty("sqlfire.user.sd", "pwd");
                authProperties.setProperty("user", "sd");
                authProperties.setProperty("password", "pwd");
                authProperties.setProperty("gemfirexd.sql-authorization", "true");
                authProperties.setProperty("gemfirexd.authz-default-connection-mode", "NOACCESS");
                authProperties.setProperty("authz-full-access-users", "sd,user1");
                startupProps.putAll((Map<?, ?>)authProperties);
                this.startVMs(0, 1, 0, null, startupProps);
                startupProps.remove("start-locator");
                startupProps.setProperty("locators", "localhost[" + locPort + ']');
                this.startVMs(1, 3, 0, null, startupProps);
                props2 = new Properties();
                props2.setProperty("user", "sd");
                props2.setProperty("password", "pwd");
                Connection conn1 = TestUtil.getConnection(props2);
                systemUser_stmt = conn1.createStatement();
                systemUser_stmt.execute("call sys.create_user('user1', 'a')");
                systemUser_stmt.execute("call sys.create_user('user2', 'b')");
                props2.setProperty("user", "user1");
                props2.setProperty("password", "a");
                conn2 = TestUtil.getConnection(props2);
                user1_stmt = conn2.createStatement();
                systemUser_stmt.execute("CALL SYSCS_UTIL.SET_USER_ACCESS ('USER1', NULL)");
                try {
                    user1_stmt.execute("create table t1(col1 int)");
                    GemFireXDAuthenticationDUnit.fail((String)"should not have allowed a connection");
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("08004")) break block4;
                    throw se;
                }
            }
            conn2.close();
            try {
                Connection conn3 = TestUtil.getConnection(props2);
                GemFireXDAuthenticationDUnit.fail((String)"should not have allowed a connection");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("08004")) break block5;
                throw se;
            }
        }
        systemUser_stmt.execute("CALL SYSCS_UTIL.SET_USER_ACCESS ('USER1', 'FULLACCESS')");
        Connection conn4 = TestUtil.getConnection(props2);
        user1_stmt = conn4.createStatement();
        user1_stmt.execute("create table t1(col1 int)");
    }
}

