/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.query;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import io.snappydata.test.dunit.AsyncInvocation;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import junit.framework.TestCase;

public class StatementMatchingDUnit
extends DistributedSQLTestBase {
    public StatementMatchingDUnit(String name) {
        super(name);
    }

    public void testStatement_PreparedStatementMixing() throws Exception {
        this.startVMs(2, 3);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        conn.createStatement().execute(" create table course ( course_id int, course_name varchar(20),primary key(course_id, course_name)) partition by column (course_id) ");
        conn.createStatement().execute(" create table student ( st_id varchar(10), c_id int,primary key(st_id, c_id)) replicate ");
        st.execute("insert into student values('x', 1)");
        st.execute("insert into student values('x', 2)");
        st.execute("insert into student values('x', 3)");
        st.execute("insert into student values('a', 1)");
        st.execute("insert into student values('bb', 4)");
        st.execute("insert into course values(4, 'FOUR')");
        st.execute("insert into course values(5, 'FIVE')");
        st.execute("insert into course values(6, 'SIX')");
        conn.createStatement().execute(" create table course_1 ( course_id int, course_name varchar(20),primary key(course_id, course_name)) partition by column (course_id) ");
        conn.createStatement().execute(" create table student_1 ( st_id varchar(10), c_id int,primary key(st_id, c_id) )  partition by column (c_id)  colocate with (course_1) ");
        st.execute("insert into student_1 values('y', 1)");
        st.execute("insert into student_1 values('y', 2)");
        st.execute("insert into student_1 values('y', 3)");
        st.execute("insert into student_1 values('a', 1)");
        st.execute("insert into student_1 values('bb', 4)");
        st.execute("insert into course_1 values(1, 'ONE')");
        st.execute("insert into course_1 values(2, 'TWO')");
        st.execute("insert into course_1 values(3, 'THREE')");
        st.execute("insert into course_1 values(4, 'FOUR')");
        st.execute("insert into course_1 values(5, 'FIVE')");
        st.execute("insert into course_1 values(6, 'SIX')");
        st.close();
        conn.close();
        SerializableRunnable selects = new SerializableRunnable(){
            long[] res = new long[]{6L, 5L, 4L};

            public void run() {
                try {
                    Connection conn = TestUtil.getConnection();
                    Statement st = conn.createStatement();
                    ResultSet st_st = st.executeQuery("select c_id from student where st_id = 'x' order by c_id desc NULLS first ");
                    PreparedStatement c_ps = conn.prepareStatement("select * from course where course_id = ? ");
                    conn.createStatement().executeQuery("select c_id from student_1 where st_id = 'y' and c_id not in (select distinct course_id from course_1) order by c_id desc NULLS first ");
                    conn.prepareStatement("select * from course_1 where course_id = ? ");
                    int r = -1;
                    while (st_st.next()) {
                        int param = st_st.getInt(1);
                        c_ps.setInt(1, param + 3);
                        ResultSet rc = c_ps.executeQuery();
                        assert (r < this.res.length);
                        TestCase.assertTrue((boolean)rc.next());
                        long received = rc.getLong("course_id");
                        StatementMatchingDUnit.this.getLogWriter().info((Object)("Received course row " + received + " passed in param " + param));
                        TestCase.assertEquals((long)this.res[++r], (long)received);
                        TestCase.assertFalse((boolean)rc.next());
                    }
                    TestCase.assertTrue((r != -1 ? 1 : 0) != 0);
                }
                catch (SQLException e) {
                    DistributedSQLTestBase.fail("Exception occured ", e);
                }
            }
        };
        ArrayList<AsyncInvocation> runlist1 = this.executeTaskAsync(new int[]{2}, new int[]{1, 2, 3}, (Runnable)selects);
        selects.run();
        this.joinAsyncInvocation(runlist1);
    }

    public void testBug42482_reprepare() throws Exception {
        this.startVMs(1, 3);
        SerializableRunnable installReprepare = new SerializableRunnable("Installing reprepare hook "){

            public void run() {
                SanityManager.DEBUG_SET((String)"StatementMatching");
                GemFireXDUtils.initFlags();
                GemFireXDQueryObserverAdapter prepReprepare = new GemFireXDQueryObserverAdapter(){
                    private int numTimesCompiled = 0;

                    public void beforeGemFireResultSetOpen(AbstractGemFireResultSet rs, LanguageConnectionContext lcc) throws StandardException {
                        ++this.numTimesCompiled;
                        if (this.numTimesCompiled == 1) {
                            StatementMatchingDUnit.this.getLogWriter().info((Object)"Raising re-compile exception");
                            Activation act = rs.getActivation();
                            act.getPreparedStatement().makeInvalid(11, act.getLanguageConnectionContext());
                            throw StandardException.newException((String)"XCL32.S");
                        }
                    }

                    public void afterGemFireResultSetOpen(AbstractGemFireResultSet rs, LanguageConnectionContext lcc) {
                        TestCase.assertTrue((String)"numTimesCompiled is expected more than once due to recompile exception ", (this.numTimesCompiled > 1 ? 1 : 0) != 0);
                    }
                };
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)prepReprepare);
            }
        };
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        conn.createStatement().execute(" create table course_1 ( course_id int, course_name varchar(30),primary key(course_id)) partition by column (course_id) ");
        st.execute("insert into course_1 values(11, 'ONE')");
        st.execute("insert into course_1 values(12, 'TWO')");
        st.execute("insert into course_1 values(13, 'THREE')");
        st.execute("insert into course_1 values(14, 'FOUR')");
        st.execute("insert into course_1 values(15, 'FIVE')");
        st.execute("insert into course_1 values(16, 'SIX')");
        st.execute("update course_1 set course_name = 'MURRAY' where course_id > 10 ");
        st.execute("update course_1 set course_name = 'MURRAY BLVD' where course_id > 5 ");
        ArrayList<AsyncInvocation> runlist1 = this.executeTaskAsync(null, new int[]{1, 2, 3}, (Runnable)installReprepare);
        installReprepare.run();
        this.joinAsyncInvocation(runlist1);
        st.execute("update course_1 set course_name = 'HURRY.FAIL.ME' where course_id > 8 ");
    }

    public void testBug42488() throws Exception {
        this.startVMs(1, 1);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        conn.createStatement().execute(" create table course ( course_id int, course_name varchar(20),primary key(course_id, course_name)) partition by column (course_id) ");
        conn.createStatement().execute(" create table student ( st_id varchar(10), c_id int,primary key(st_id, c_id)) replicate ");
        st.execute("insert into student values('x', 1)");
        st.execute("insert into student values('x', 2)");
        st.execute("insert into student values('x', 3)");
        st.execute("insert into student values('a', 1)");
        st.execute("insert into student values('bb', 4)");
        st.execute("insert into course values(4, 'FOUR')");
        st.execute("insert into course values(5, 'FIVE')");
        st.execute("insert into course values(6, 'SIX')");
        String query1 = "Select * from course where  course_id >= 4";
        ResultSet rs = st.executeQuery(query1);
        int num = 0;
        while (rs.next()) {
            rs.getInt(1);
            ++num;
        }
        StatementMatchingDUnit.assertEquals((int)3, (int)num);
        this.startVMs(0, 1);
        num = 0;
        String query2 = "Select * from course where  course_id >= 8";
        st.execute("insert into course values(7, 'Seven')");
        st.execute("insert into course values(8, 'Eight')");
        st.execute("insert into course values(9, 'Nine')");
        rs = st.executeQuery(query2);
        while (rs.next()) {
            rs.getInt(1);
            ++num;
        }
        StatementMatchingDUnit.assertEquals((int)2, (int)num);
        st.close();
        conn.close();
    }
}

