/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.query;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import io.snappydata.test.dunit.SerializableRunnable;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;

public class QueryTimeOutDUnit
extends DistributedSQLTestBase {
    final String PROP_FILE_NAME = "gfxd-querytimeout.properties";

    public QueryTimeOutDUnit(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleSelectQuery() throws Exception {
        this.startVMs(1, 2);
        Connection cxn = TestUtil.getConnection();
        Statement stmt = cxn.createStatement();
        stmt.execute("create table MyTable(x int, y int) partition by column(x)");
        PreparedStatement pstmt1 = cxn.prepareStatement("insert into MyTable values (?, ?)");
        for (int i = 1; i <= 10; ++i) {
            pstmt1.setInt(1, i);
            pstmt1.setInt(2, i);
            pstmt1.execute();
        }
        PreparedStatement pstmt2 = cxn.prepareStatement("select * from MyTable where x > ?");
        pstmt2.setInt(1, 0);
        SerializableRunnable csr2 = new SerializableRunnable("_testSimpleSelectQuery_"){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void onGetNextRowCoreOfBulkTableScan(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        try {
                            QueryTimeOutDUnit.this.getLogWriter().info((Object)"onGetNextRowCoreOfBulkTableScan called");
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.clientExecute(1, (Runnable)csr2);
        this.serverExecute(1, (Runnable)csr2);
        this.serverExecute(2, (Runnable)csr2);
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
        try {
            pstmt2.setQueryTimeout(1);
            ResultSet rs = pstmt2.executeQuery();
            while (rs.next()) {
                System.out.println(rs.getInt(1));
                System.out.println(rs.getInt(2));
            }
            QueryTimeOutDUnit.fail((String)"This test should have thrown exception due to query cancellation (exception state XCL52)");
        }
        catch (SQLException se) {
            block6: {
                try {
                    if (se.getSQLState().equals("XCL52")) break block6;
                    throw se;
                }
                catch (Throwable throwable) {
                    this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
                    throw throwable;
                }
            }
            this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryTimeOutTestTSMC(boolean useThinClient) throws Exception {
        this.startVMs(1, 3);
        Connection conn = null;
        if (useThinClient) {
            int clientPort = this.startNetworkServer(1, null, null);
            conn = TestUtil.getNetConnection(clientPort, null, null);
        } else {
            conn = TestUtil.getConnection();
        }
        Statement st = conn.createStatement();
        st.execute("create table FDC_NRT_CNTXT_HIST (EQP_ID VARCHAR(40) NOT NULL, CNTXT_ID INTEGER NOT NULL, STOP_DT TIMESTAMP NOT NULL,  primary key(eqp_id, cntxt_id, stop_dt) ) partition by column (eqp_id, cntxt_id, stop_dt)");
        st.execute("insert into FDC_NRT_CNTXT_HIST values  ('1', 1, '2014-01-24 18:48:00'),('2', 1, '2014-01-24 18:48:00'),('3', 1, '2014-01-24 18:48:00'),('4', 1, '2014-01-24 18:48:00'),('5', 1, '2014-01-24 18:48:00'),('6', 1, '2014-01-24 18:48:00'),('7', 1, '2014-01-24 18:48:00'),('8', 1, '2014-01-24 18:48:00'),('9', 1, '2014-01-24 18:48:00'),('10', 1, '2014-01-24 18:48:00'),('11', 1, '2014-01-24 18:48:00'),('12', 1, '2014-01-24 18:48:00'),('13', 1, '2014-01-24 18:48:00')");
        st.execute("create table FDC_NRT_TCHART_HIST (EQP_ID VARCHAR(40) NOT NULL, CNTXT_ID INTEGER NOT NULL, STOP_DT TIMESTAMP NOT NULL, SVID_NAME VARCHAR(64) NOT NULL,  primary key(eqp_id, cntxt_id, stop_dt, svid_name) ) partition by column (eqp_id, cntxt_id, stop_dt) COLOCATE WITH (FDC_NRT_CNTXT_HIST)");
        st.execute("insert into FDC_NRT_TCHART_HIST values  ('1', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('2', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('3', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('4', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('5', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('6', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('7', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('8', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('9', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('10', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('11', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('12', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('13', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59')");
        st.execute("create table FDC_NRT_PUMPER_HIST_LOG ( EQP_ID VARCHAR(40) NOT NULL, CNTXT_ID INTEGER NOT NULL, STOP_DT TIMESTAMP NOT NULL, UPDATE_DT TIMESTAMP NOT NULL, EXEC_TIME DOUBLE, primary key (eqp_id, cntxt_id, stop_dt, update_dt) ) partition by primary key");
        st.execute("insert into FDC_NRT_PUMPER_HIST_LOG values  ('1', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('2', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('3', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('4', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('5', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('6', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('7', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('8', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('9', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('10', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('11', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('12', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('13', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41)");
        SerializableRunnable csr = new SerializableRunnable("_testTimeOut_"){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void onGetNextRowCore(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.clientExecute(1, (Runnable)csr);
        this.serverExecute(1, (Runnable)csr);
        this.serverExecute(2, (Runnable)csr);
        this.serverExecute(3, (Runnable)csr);
        try {
            this.addExpectedException(new int[]{1}, new int[]{1, 2, 3}, SQLException.class);
            st.setQueryTimeout(1);
            ResultSet r = st.executeQuery("select a.eqp_id, a.cntxt_id, a.stop_dt, dsid() as datanode_id from FDC_NRT_CNTXT_HIST a left join FDC_NRT_TCHART_HIST b on (a.eqp_id =b.eqp_id and a.cntxt_id=b.cntxt_id and a.stop_dt=b.stop_dt) where a.eqp_id||cast(a.cntxt_id as char(100)) in ( select eqp_id||cast(t.cntxt_id as char(100)) from FDC_NRT_PUMPER_HIST_LOG t where 1=1 and exec_time > 40 and stop_dt > '2014-01-24 18:47:59' and stop_dt < '2014-01-24 18:49:59')");
            while (r.next()) {
            }
            QueryTimeOutDUnit.fail((String)"This test should have thrown exception due to query timeout (exception state XCL52)");
        }
        catch (SQLException se) {
            block7: {
                try {
                    if (se.getSQLState().equals("XCL52")) break block7;
                    throw se;
                }
                catch (Throwable throwable) {
                    this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, SQLException.class);
                    throw throwable;
                }
            }
            this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, SQLException.class);
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, SQLException.class);
    }

    public void testQueryTimeOutTSMC() throws Exception {
        this.queryTimeOutTestTSMC(false);
    }

    public void testQueryTimeOutTSMC_thin() throws Exception {
        this.queryTimeOutTestTSMC(true);
    }

    public static void myProc1(int timOutOnCallableStmt, int[] count, ResultSet[] resultSet1, ResultSet[] resultSet2, ProcedureExecutionContext ctx) throws SQLException, InterruptedException {
        Connection conn = ctx.getConnection();
        Statement stmt = conn.createStatement();
        QueryTimeOutDUnit.assertEquals((int)timOutOnCallableStmt, (int)stmt.getQueryTimeout());
        Thread.sleep(1500L);
        ctx.checkQueryCancelled();
        QueryTimeOutDUnit.fail((String)"The procedure should have failed due to query time out (SQLState:XCL52");
        stmt.execute("select * from mytable");
        resultSet1[0] = stmt.getResultSet();
        Statement stmt3 = conn.createStatement();
        stmt3.execute("select count(*) from mytable");
        stmt3.getResultSet().next();
        Integer cnt = stmt3.getResultSet().getInt(1);
        count[0] = cnt;
        Statement stmt2 = conn.createStatement();
        stmt2.execute("select count(*) from mytable");
        resultSet2[0] = stmt2.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeOutStoredProc_1() throws Exception {
        this.startVMs(1, 2);
        Connection cxn = TestUtil.getConnection();
        Statement stmt = cxn.createStatement();
        stmt.execute("CREATE PROCEDURE myProc1 (IN timOutOnCallableStmt INTEGER,  OUT count INTEGER)LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 2 EXTERNAL NAME '" + QueryTimeOutDUnit.class.getName() + ".myProc1'");
        stmt.execute("create table MyTable(x int, y int) partition by column(x)");
        stmt.execute("insert into MyTable values (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7)");
        int timOutOnCallableStmt = 1;
        CallableStatement callableStmt = cxn.prepareCall("{CALL myProc1(" + timOutOnCallableStmt + ", ?) ON TABLE MyTable}");
        callableStmt.registerOutParameter(1, 4);
        callableStmt.setQueryTimeout(timOutOnCallableStmt);
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
        try {
            callableStmt.execute();
            QueryTimeOutDUnit.fail((String)"This test should have thrown exception due to query timeout (exception state XCL52)");
        }
        catch (SQLException se) {
            block4: {
                try {
                    if (se.getSQLState().equals("XCL52")) break block4;
                    throw se;
                }
                catch (Throwable throwable) {
                    this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, SQLException.class);
                    throw throwable;
                }
            }
            this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, SQLException.class);
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2, 3}, SQLException.class);
    }

    public static void myProc2(int timOutOnCallableStmt, int[] count, ResultSet[] resultSet1, ResultSet[] resultSet2, ProcedureExecutionContext ctx) throws SQLException, InterruptedException {
        Connection conn = ctx.getConnection();
        Statement stmt = conn.createStatement();
        QueryTimeOutDUnit.assertEquals((int)timOutOnCallableStmt, (int)stmt.getQueryTimeout());
        stmt.setQueryTimeout(timOutOnCallableStmt + 1);
        SQLWarning sw = stmt.getWarnings();
        if (sw != null) {
            if (!sw.getSQLState().equals("01509")) {
                throw sw;
            }
        } else {
            QueryTimeOutDUnit.fail((String)"This test should have thrown a warning(01509) as query time out for statement in stored procedure can not be more than outer callable statement's time out");
        }
        QueryTimeOutDUnit.assertEquals((int)timOutOnCallableStmt, (int)stmt.getQueryTimeout());
        stmt.setQueryTimeout(1);
        QueryTimeOutDUnit.assertEquals((int)1, (int)stmt.getQueryTimeout());
        stmt.execute("select * from mytable");
        resultSet1[0] = stmt.getResultSet();
        Statement stmt3 = conn.createStatement();
        stmt3.execute("select count(*) from mytable");
        stmt3.getResultSet().next();
        Integer cnt = stmt3.getResultSet().getInt(1);
        count[0] = cnt;
        Statement stmt2 = conn.createStatement();
        stmt2.execute("select count(*) from mytable");
        resultSet2[0] = stmt2.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeOutStoredProc_2() throws Exception {
        this.startVMs(1, 2);
        Connection cxn = TestUtil.getConnection();
        Statement stmt = cxn.createStatement();
        stmt.execute("CREATE PROCEDURE myProc2 (IN timOutOnCallableStmt INTEGER,  OUT count INTEGER)LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 2 EXTERNAL NAME '" + QueryTimeOutDUnit.class.getName() + ".myProc2'");
        stmt.execute("create table MyTable(x int, y int) partition by column(x)");
        stmt.execute("insert into MyTable values (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7)");
        int timOutOnCallableStmt = 10;
        CallableStatement callableStmt = cxn.prepareCall("{CALL myProc2(" + timOutOnCallableStmt + ", ?) ON TABLE MyTable}");
        callableStmt.registerOutParameter(1, 4);
        callableStmt.setQueryTimeout(timOutOnCallableStmt);
        SerializableRunnable csr = new SerializableRunnable("_testTimeOut_"){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void onGetNextRowCoreOfBulkTableScan(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.serverExecute(1, (Runnable)csr);
        this.serverExecute(2, (Runnable)csr);
        this.addExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
        try {
            callableStmt.execute();
            QueryTimeOutDUnit.fail((String)"This test should have thrown exception due to query timeout (exception state XCL52)");
        }
        catch (SQLException se) {
            try {
                if (!se.getSQLState().equals("XCL52")) {
                    throw se;
                }
                QueryTimeOutDUnit.assertEquals((int)10, (int)callableStmt.getQueryTimeout());
            }
            catch (Throwable throwable) {
                this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
                throw throwable;
            }
            this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
        }
        this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
    }

    private File createPropertyFile() throws Exception {
        File file = new File("gfxd-querytimeout.properties");
        try (FileOutputStream fos = new FileOutputStream(file);){
            Properties props = new Properties();
            props.setProperty("gemfirexd.query-timeout", "2");
            props.store(fos, "-- gfxd properties file for testQueryTimeOutThruPropertiesFile");
            File file2 = file;
            return file2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTimeOutThruPropertiesFile() throws Exception {
        block9: {
            File propFile = this.createPropertyFile();
            try {
                Properties p1 = new Properties();
                p1.setProperty("gemfirexd.properties", propFile.getAbsolutePath());
                this.startVMs(1, 2, 0, null, p1);
                Connection cxn = TestUtil.getConnection();
                Statement stmt = cxn.createStatement();
                stmt.execute("create table MyTable(x int, y int) partition by column(x)");
                PreparedStatement pstmt1 = cxn.prepareStatement("insert into MyTable values (?, ?)");
                for (int i = 1; i <= 10; ++i) {
                    pstmt1.setInt(1, i);
                    pstmt1.setInt(2, i);
                    pstmt1.execute();
                }
                PreparedStatement pstmt2 = cxn.prepareStatement("select * from MyTable where x > ?");
                pstmt2.setInt(1, 0);
                QueryTimeOutDUnit.assertEquals((int)2, (int)pstmt2.getQueryTimeout());
                SerializableRunnable csr2 = new SerializableRunnable("testQueryTimeOutThruPropertiesFile"){

                    public void run() {
                        GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                            public void onGetNextRowCoreOfBulkTableScan(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                                try {
                                    QueryTimeOutDUnit.this.getLogWriter().info((Object)"onGetNextRowCoreOfBulkTableScan called");
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                };
                this.clientExecute(1, (Runnable)csr2);
                this.serverExecute(1, (Runnable)csr2);
                this.serverExecute(2, (Runnable)csr2);
                this.addExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
                try {
                    ResultSet rs = pstmt2.executeQuery();
                    while (rs.next()) {
                        System.out.println(rs.getInt(1));
                        System.out.println(rs.getInt(2));
                    }
                    QueryTimeOutDUnit.fail((String)"This test should have thrown exception due to query cancellation (exception state XCL52)");
                }
                catch (SQLException se) {
                    block10: {
                        try {
                            if (se.getSQLState().equals("XCL52")) break block10;
                            throw se;
                        }
                        catch (Throwable throwable) {
                            this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
                            throw throwable;
                        }
                    }
                    this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
                    break block9;
                }
                this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
            }
            finally {
                propFile.delete();
            }
        }
    }
}

