/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.query;

import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;

public class QueryChecksDUnit
extends DistributedSQLTestBase {
    public QueryChecksDUnit(String name) {
        super(name);
    }

    public void testSimpleAvg() throws Exception {
        this.startVMs(1, 2);
        Connection c = TestUtil.getConnection();
        c.createStatement().execute("create table test_t ( pk_col int primary key, col_ints int ) ");
        c.createStatement().execute("insert into test_t values ( 1, 2302), ( 2, 4690), ( 3, 4901)");
        ResultSet r = c.createStatement().executeQuery("select avg(cast(col_ints as real)) from test_t ");
        QueryChecksDUnit.assertTrue((boolean)r.next());
        QueryChecksDUnit.assertEquals((Object)Float.valueOf(3964.3333f), (Object)Float.valueOf(r.getFloat(1)));
    }

    public void testProjectionWithClobs() throws Exception {
        this.startVMs(1, 3);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table Layout (     uuid_ varchar(75),      plid bigint not null primary key,       groupId bigint, companyId bigint,       privateLayout smallint, layoutId bigint,        parentLayoutId bigint,  name varchar(4000),     title varchar(4000),    description varchar(4000),      type_ varchar(75),      typeSettings clob,      hidden_ smallint,       friendlyURL varchar(255),       iconImage smallint,     iconImageId bigint,     themeId varchar(75),    colorSchemeId varchar(75),      wapThemeId varchar(75), wapColorSchemeId varchar(75),   css varchar(4000),      priority integer,       layoutPrototypeId bigint,       dlFolderId bigint)");
        st.execute("insert into Layout (uuid_, groupId, companyId, privateLayout, layoutId, parentLayoutId, name, title, description, type_, typeSettings, hidden_, friendlyURL, iconImage, iconImageId, themeId, colorSchemeId, wapThemeId, wapColorSchemeId, css, priority, layoutPrototypeId, dlFolderId, plid) values ('3333-2332-3323-3332', 112, 3323, 33, 3323, 33232, 'NAME : CHAKRABORTY, KUMAR CHAKRABORTY, PRANAB KUMAR CHAKRABORTY, KUMAR PRANAB KUMAR CHAKRABORTY, SOUBHIK KUMAR PRANAB KUMAR CHAKRABORTY', 'title: MISTER, MONSIEUR, \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd (Dan''na), don, \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, ', ' description is self descriptive in name / title. what else ?', 'TYPE-1',  cast ( 'dafaafsasfasdfasdfasdfasdfasddfasfasdfasd' as clob), 1, 'http://sb.blogspot.com', 1, 1122, 'THEME-1', 'dfadfa',  'wapTheme-2' , 'wapColorScheme-11', '<html> <!css type fo scripts> ', 1, 1, 1, 1000) ");
        ResultSet rs = st.executeQuery("select layoutimpl0_.uuid_ as uuid2_13_0_, layoutimpl0_.plid as plid13_0_, layoutimpl0_.typeSettings as typeSet12_13_0_, layoutimpl0_.hidden_ as hidden13_13_0_ from Layout layoutimpl0_ where layoutimpl0_.plid=1000");
        while (rs.next()) {
            QueryChecksDUnit.assertEquals((String)rs.getString(1), (String)"3333-2332-3323-3332");
            QueryChecksDUnit.assertEquals((long)rs.getLong(2), (long)1000L);
            QueryChecksDUnit.assertEquals((String)rs.getString(3), (String)"dafaafsasfasdfasdfasdfasdfasddfasfasdfasd");
            QueryChecksDUnit.assertEquals((int)rs.getInt(4), (int)1);
        }
    }

    public void testForumIssue_OrderingWithJoin() throws Exception {
        Properties p = new Properties();
        p.setProperty("default-recovery-delay", "-1");
        this.startVMs(0, 1, 0, null, p);
        this.startVMs(1, 2, 0, null, p);
        int netPort = this.startNetworkServer(1, null, null);
        String hostName = SocketCreator.getLocalHost().getHostName();
        Connection netConn = TestUtil.getNetConnection(hostName, netPort, null, null);
        Statement st = netConn.createStatement();
        st.execute("create table Customers ( CustomerId integer not null generated always as identity,  CustomerCode    varchar(8)  not null,  constraint PKCustomers primary key (CustomerId), constraint UQCustomers unique (CustomerCode) ) partition by column (CustomerId) redundancy 1 persistent");
        st.execute("insert into Customers (CustomerCode) values ('CC1')");
        st.execute("insert into Customers (CustomerCode) values ('CC2')");
        st.execute("insert into Customers (CustomerCode) values ('CC3')");
        st.execute("insert into Customers (CustomerCode) values ('CC4')");
        st.execute("create table Devices ( DeviceId    integer     not null    generated always as identity,  CustomerId  integer     not null,MACAddress  varchar(12) not null,constraint PKDevices primary key (DeviceId),constraint UQDevices unique (CustomerId, MACAddress),constraint FKDevicesCustomers foreign key (CustomerId) references Customers (CustomerId)) partition by column (CustomerId) colocate with (Customers) redundancy 1 persistent");
        st.execute("insert into Devices (CustomerId, MACAddress) values (1, '000000000001')");
        st.execute("insert into Devices (CustomerId, MACAddress) values (1, '000000000002')");
        st.execute("insert into Devices (CustomerId, MACAddress) values (2, '000000000001')");
        st.execute("insert into Devices (CustomerId, MACAddress) values (2, '000000000002')");
        ResultSet res = st.executeQuery("select c.*, d.DeviceId as devId from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by c.CustomerId");
        res.next();
        int cid = res.getInt(1);
        int did = res.getInt("devId");
        QueryChecksDUnit.assertTrue((cid == 1 && (did == 2 || did == 1) && !res.wasNull() ? 1 : 0) != 0);
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue((cid == 1 && (did == 2 || did == 1) && !res.wasNull() ? 1 : 0) != 0);
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue((cid == 2 && (did == 3 || did == 4) && !res.wasNull() ? 1 : 0) != 0);
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue((cid == 2 && (did == 3 || did == 4) && !res.wasNull() ? 1 : 0) != 0);
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue(((cid == 4 || cid == 3) && did == 0 && res.wasNull() ? 1 : 0) != 0);
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue(((cid == 4 || cid == 3) && did == 0 && res.wasNull() ? 1 : 0) != 0);
        res = st.executeQuery("select c.*, d.DeviceId as devId from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by d.DeviceId");
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue((cid == 1 && (did == 1 || did == 2) && !res.wasNull() ? 1 : 0) != 0);
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue((cid == 1 && (did == 1 || did == 2) && !res.wasNull() ? 1 : 0) != 0);
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue((cid == 2 && (did == 3 || did == 4) && !res.wasNull() ? 1 : 0) != 0);
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue((cid == 2 && (did == 3 || did == 4) && !res.wasNull() ? 1 : 0) != 0);
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue(((cid == 4 || cid == 3) && did == 0 && res.wasNull() ? 1 : 0) != 0);
        res.next();
        cid = res.getInt(1);
        did = res.getInt("devId");
        QueryChecksDUnit.assertTrue(((cid == 4 || cid == 3) && did == 0 && res.wasNull() ? 1 : 0) != 0);
        res = st.executeQuery("select c.*, d.MACAddress as macAd from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by c.CustomerId");
        while (res.next()) {
            this.getLogWriter().info((Object)(res.getInt(1) + " order by custId macAd = " + res.getString("macAd")));
        }
        res = st.executeQuery("select c.*, d.MACAddress as macAd from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by d.DeviceId");
        while (res.next()) {
            this.getLogWriter().info((Object)(res.getInt(1) + " order by devId macAd = " + res.getString("macAd")));
        }
        st.execute("drop table Devices");
        st.execute("drop table Customers");
    }
}

