/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.query;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.standalone.DUnitBB;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.TestCase;
import org.junit.Ignore;

@Ignore
public abstract class QueryCancelTestHelper
extends DistributedSQLTestBase {
    public static boolean serversReadyForCancellation(String key, Integer expectedNumOfServers) {
        Integer value = (Integer)DUnitBB.getBB().get((Object)key);
        QueryCancelTestHelper.getGlobalLogger().info((Object)(" serversReadyForCancellation: value in BB map for key: " + key + " value is " + value));
        return value != null && value.equals(expectedNumOfServers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void incrementValueInBBMap(String key, int expectedMaxValue) {
        DUnitBB bb = DUnitBB.getBB();
        try {
            bb.acquireSharedLock();
            Integer v = (Integer)bb.get((Object)key);
            if (v == null) {
                QueryCancelTestHelper.getGlobalLogger().info((Object)("incrementValueInBBMap: putting value=1 for key=" + key));
                bb.put((Object)key, (Object)1);
            } else {
                if (v.equals(expectedMaxValue)) {
                    return;
                }
                QueryCancelTestHelper.getGlobalLogger().info((Object)("incrementValueInBBMap: putting value=" + (v + 1) + " for key=" + key));
                bb.put((Object)key, (Object)(v + 1));
            }
        }
        finally {
            bb.releaseSharedLock();
        }
    }

    public static void putStatementUUIDinBBMap(String testKey, long connId, long stmtId, long execId) {
        DUnitBB bb = DUnitBB.getBB();
        bb.put((Object)(testKey + "_stmtUUID"), (Object)(connId + "-" + stmtId + "-" + execId));
    }

    public static String getStatementUUIDfromBBMap(String testKey) {
        return (String)DUnitBB.getBB().get((Object)(testKey + "_stmtUUID"));
    }

    private static void waitForCancellationSignal(final String testKey, final int numNodesToBeWaited) {
        QueryCancelTestHelper.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                return QueryCancelTestHelper.serversReadyForCancellation(testKey, numNodesToBeWaited);
            }

            public String description() {
                return "waiting for signal from data nodes to cancel the query";
            }
        }, (long)20000L, (long)500L, (boolean)true);
    }

    public QueryCancelTestHelper(String name) {
        super(name);
    }

    private void cancelQuery(Statement stmt, String testKey, boolean useCancelProc) throws SQLException {
        if (!useCancelProc) {
            stmt.cancel();
        } else {
            String stmtUUID = QueryCancelTestHelper.getStatementUUIDfromBBMap(testKey);
            this.getLogWriter().info((Object)("UUID for " + testKey + "=" + stmtUUID));
            Connection c = TestUtil.getConnection();
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery("select current_statement_UUID, CURRENT_STATEMENT from sys.sessions");
            boolean UUIDfound = false;
            while (rs.next()) {
                if (rs.getString(1).equals(stmtUUID)) {
                    UUIDfound = true;
                    continue;
                }
                this.getLogWriter().info((Object)("UUID in the sessions is :" + rs.getString(1) + "and statement text is : " + rs.getString(2)));
            }
            QueryCancelTestHelper.assertTrue((String)("Statement UUID " + stmtUUID + " is not present in sessions VTI"), (boolean)UUIDfound);
            rs.close();
            String cancelStmt = "CALL SYS.CANCEL_STATEMENT(?)";
            CallableStatement cs = c.prepareCall(cancelStmt);
            cs.setString(1, stmtUUID);
            cs.execute();
        }
    }

    public void executeAndCancelQuery(final Statement stmt, final StatementType stmtType, int numNodesToBeWaited, String testKey, final String query, boolean useCancelProc) throws Throwable {
        final Throwable[] failure = new Throwable[1];
        Runnable doExecute = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                QueryCancelTestHelper.this.addExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
                try {
                    boolean hasResult = false;
                    switch (stmtType) {
                        case STATEMENT: {
                            hasResult = stmt.execute(query);
                            if (!hasResult) break;
                            ResultSet rs = stmt.getResultSet();
                            while (rs.next()) {
                            }
                            break;
                        }
                        case PREPARED_STATEMENT: {
                            hasResult = ((PreparedStatement)stmt).execute();
                            int count = 0;
                            if (hasResult) {
                                ResultSet rs = stmt.getResultSet();
                                while (rs.next()) {
                                    ++count;
                                }
                            }
                            QueryCancelTestHelper.this.getLogWriter().info((Object)("Num rows retrieved=" + count));
                            break;
                        }
                        case BATCH_STATEMENT: {
                            stmt.executeBatch();
                        }
                    }
                    TestCase.fail((String)"This test should have thrown exception due to query cancellation (exception state XCL56)");
                }
                catch (Throwable t) {
                    try {
                        QueryCancelTestHelper.this.getLogWriter().info((Object)("1. received failure: " + t));
                        failure[0] = t;
                    }
                    catch (Throwable throwable) {
                        QueryCancelTestHelper.this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
                        throw throwable;
                    }
                    QueryCancelTestHelper.this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
                }
                QueryCancelTestHelper.this.removeExpectedException(new int[]{1}, new int[]{1, 2}, SQLException.class);
            }
        };
        Thread t12 = new Thread(doExecute);
        t12.start();
        if (numNodesToBeWaited > 0) {
            QueryCancelTestHelper.waitForCancellationSignal(testKey, numNodesToBeWaited);
        }
        this.cancelQuery(stmt, testKey, useCancelProc);
        t12.join();
        this.getLogWriter().info((Object)("2. received failure: " + failure[0]));
        if (failure[0] != null) {
            if (failure[0] instanceof SQLException) {
                SQLException se = (SQLException)failure[0];
                if (!se.getSQLState().equals("XCL56")) {
                    this.getLogWriter().info((Object)se);
                    throw se;
                }
            } else {
                this.getLogWriter().info((Object)failure[0]);
                throw failure[0];
            }
        }
    }

    public Connection _getConnection(boolean useThinClient) throws Throwable {
        Connection cxn = null;
        if (useThinClient) {
            Properties props = new Properties();
            int clientPort = this.startNetworkServer(1, null, null);
            cxn = TestUtil.getNetConnection(clientPort, null, props);
        } else {
            Properties props = new Properties();
            cxn = TestUtil.getConnection(props);
        }
        return cxn;
    }

    protected static enum StatementType {
        STATEMENT,
        PREPARED_STATEMENT,
        BATCH_STATEMENT;

    }
}

