/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.query;

import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericActivationHolder;
import com.pivotal.gemfirexd.query.QueryCancelDUnit;
import com.pivotal.gemfirexd.query.QueryCancelTestHelper;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Properties;

public class QueryCancelDUnit_DJ
extends QueryCancelTestHelper {
    public QueryCancelDUnit_DJ(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
        QueryCancelDUnit_DJ.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "true");
            }
        });
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
        QueryCancelDUnit_DJ.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

            public void run() {
                System.setProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false");
            }
        });
        super.tearDown2();
    }

    public void selectQueryTest_PR_PR(boolean usePrepStatement, boolean useCancelSProc, boolean useThinClient, String testName) throws Throwable {
        int numServers = 3;
        Properties props = new Properties();
        this.startVMs(1, 3, 0, null, props);
        Connection cxn = this._getConnection(useThinClient);
        Statement st = cxn.createStatement();
        st.execute("create table tglobalindex ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        st.execute("create table tdriver ( id int primary key, vid varchar(10), sid int) partition by column(sid)");
        cxn.commit();
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        for (int i = 0; i < 10; ++i) {
            String s = securities[i % 10];
            st.execute("Insert into tglobalindex values(" + i + ",'" + s + "'," + 2 * i + ")");
            s = "D" + s;
            st.execute("Insert into tdriver values(" + i + ",'" + s + "'," + 2 * i + ")");
        }
        Statement stmt = null;
        String testQueryString = "Select A.ID, A.VID, B.ID, B.VID from  tglobalindex A inner join tdriver B  on A.ID = B.ID  where A.SID > 16 and B.SID < 16 ";
        if (usePrepStatement) {
            PreparedStatement pstmt2 = cxn.prepareStatement(testQueryString);
            stmt = pstmt2;
        } else {
            stmt = cxn.createStatement();
        }
        final String key = testName;
        SerializableRunnable csr1 = new SerializableRunnable(testName){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private boolean flag = false;

                    public void beforeQueryExecution(EmbedStatement stmt, Activation activation) {
                        long connId = ((GenericActivationHolder)activation).getActivation().getLanguageConnectionContext().getConnectionId();
                        if (connId != -2L) {
                            long rootID = ((GenericActivationHolder)activation).getActivation().getStatementID();
                            long execId = 1L;
                            QueryCancelDUnit.putStatementUUIDinBBMap(key, connId, rootID, execId);
                        }
                        QueryCancelDUnit_DJ.this.getLogWriter().info((Object)("beforeQueryExecution called connId=" + connId));
                    }

                    public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                        QueryCancelDUnit_DJ.this.getLogWriter().info((Object)"onGetNextRowCoreOfBulkTableScan called");
                        if (!this.flag) {
                            QueryCancelDUnit.incrementValueInBBMap(key, 3);
                            this.flag = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.serverExecute(1, (Runnable)csr1);
        this.serverExecute(2, (Runnable)csr1);
        this.serverExecute(3, (Runnable)csr1);
        this.executeAndCancelQuery(stmt, usePrepStatement ? QueryCancelTestHelper.StatementType.PREPARED_STATEMENT : QueryCancelTestHelper.StatementType.STATEMENT, 3, key, testQueryString, useCancelSProc);
    }

    public void testPRPRQuery_prepStmt() throws Throwable {
        this.selectQueryTest_PR_PR(true, false, false, "testPRPRQuery_prepStmt");
    }

    public void testPRPRQuery_prepStmt_thin() throws Throwable {
        this.selectQueryTest_PR_PR(true, false, true, "testPRPRQuery_prepStmt_thin");
    }

    public void testPRPRQueryUsingCancelSproc_thin() throws Throwable {
        this.selectQueryTest_PR_PR(false, true, true, "testPRPRQueryUsingCancelSproc_thin");
    }

    public void testPRPRQuery() throws Throwable {
        this.selectQueryTest_PR_PR(false, false, false, "testPRPRQuery");
    }

    public void selectQueryTest_PRpk_COLoth_COLoth_COLoth_REP(boolean usePrepStatement, boolean useCancelSProc, boolean useThinClient, String testName) throws Throwable {
        int numServers = 3;
        this.startVMs(1, 3);
        Connection cxn = this._getConnection(useThinClient);
        Statement st = cxn.createStatement();
        st.execute("create table tpk ( id int not null, vid varchar(10) primary key, sid int not null) partition by primary key");
        st.execute("create table tcol ( id int not null, vid varchar(10), sid int primary key) partition by column(id)");
        st.execute("create table tcol2 ( id int not null, vid varchar(10), sid int primary key) partition by column(id) colocate with (tcol)");
        st.execute("create table tcol3 ( id int not null, vid varchar(10), sid int primary key) partition by column(id) colocate with (tcol)");
        st.execute("create table trep ( id int primary key, vid varchar(10), sid int not null) replicate");
        cxn.commit();
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        int baseId = 50;
        for (int i = 0; i < 10; ++i) {
            st.execute("Insert into tpk values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
            st.execute("Insert into trep values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
            st.execute("Insert into tcol values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
            st.execute("Insert into tcol2 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
            st.execute("Insert into tcol3 values(" + i + ",'" + securities[i % 10] + "'," + baseId * i + ")");
        }
        Statement stmt = null;
        String testQueryString = "Select A.ID, A.VID, B.ID, B.VID, C.ID, C.VID, D.ID, D.VID, E.ID, E.VID from  tpk A inner join tcol B on A.VID = B.VID and A.ID = B.ID inner join tcol2 C on B.ID = C.ID and B.VID = C.VID inner join tcol3 D on C.ID = D.ID and D.VID = C.VID inner join trep E on E.ID = D.ID and E.VID = D.VID where A.SID < 450 and B.SID != 200 ";
        if (usePrepStatement) {
            PreparedStatement pstmt2 = cxn.prepareStatement(testQueryString);
            stmt = pstmt2;
        } else {
            stmt = cxn.createStatement();
        }
        final String key = testName;
        SerializableRunnable csr1 = new SerializableRunnable(testName){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private boolean flag = false;

                    public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                        QueryCancelDUnit_DJ.this.getLogWriter().info((Object)"onGetNextRowCoreOfBulkTableScan called");
                        if (!this.flag) {
                            QueryCancelDUnit.incrementValueInBBMap(key, 3);
                            Activation a = resultSet.getActivation();
                            long connId = a.getConnectionID();
                            long rootID = a.getRootID();
                            long execId = a.getExecutionID();
                            QueryCancelDUnit.putStatementUUIDinBBMap(key, connId, rootID, execId);
                            this.flag = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.serverExecute(1, (Runnable)csr1);
        this.serverExecute(2, (Runnable)csr1);
        this.serverExecute(3, (Runnable)csr1);
        this.executeAndCancelQuery(stmt, usePrepStatement ? QueryCancelTestHelper.StatementType.PREPARED_STATEMENT : QueryCancelTestHelper.StatementType.STATEMENT, 3, key, testQueryString, useCancelSProc);
    }

    public void testPRpk_COLoth_COLoth_COLoth_REP_prepStmt() throws Throwable {
        this.selectQueryTest_PRpk_COLoth_COLoth_COLoth_REP(true, false, false, "testPRpk_COLoth_COLoth_COLoth_REP_prepStmt");
    }

    public void testPRpk_COLoth_COLoth_COLoth_REP_prepStmt_thin() throws Throwable {
        this.selectQueryTest_PRpk_COLoth_COLoth_COLoth_REP(true, false, true, "testPRpk_COLoth_COLoth_COLoth_REP_prepStmt_thin");
    }
}

