/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.query;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import com.pivotal.gemfirexd.query.QueryCancelTestHelper;
import io.snappydata.test.dunit.SerializableRunnable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;

public class QueryCancelDUnit
extends QueryCancelTestHelper {
    public QueryCancelDUnit(String name) {
        super(name);
    }

    public void createTables(Connection cxn, int numRows) throws Exception {
        Statement stmt = cxn.createStatement();
        stmt.execute("create table MyTable(x int, y int) partition by column(x)");
        PreparedStatement pstmt1 = cxn.prepareStatement("insert into MyTable values (?, ?)");
        for (int i = 1; i <= numRows; ++i) {
            pstmt1.setInt(1, i);
            pstmt1.setInt(2, i);
            pstmt1.execute();
        }
        pstmt1.close();
        stmt.close();
    }

    public void selectQueryTest(boolean usePrepStatement, boolean useCancelSProc, boolean useThinClient, String testName) throws Throwable {
        int numServers = 2;
        int tableSize = 40;
        this.startVMs(1, 2);
        Connection cxn = this._getConnection(useThinClient);
        this.createTables(cxn, tableSize);
        Statement stmt = null;
        String testQueryString = "select * from MyTable where x > 0";
        if (usePrepStatement) {
            PreparedStatement pstmt2 = cxn.prepareStatement("select * from MyTable where x > ?");
            pstmt2.setInt(1, 0);
            stmt = pstmt2;
        } else {
            stmt = cxn.createStatement();
        }
        final String key = testName;
        SerializableRunnable csr1 = new SerializableRunnable(testName){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private boolean flag = false;

                    public void onGetNextRowCoreOfBulkTableScan(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        QueryCancelDUnit.this.getLogWriter().info((Object)"onGetNextRowCoreOfBulkTableScan called");
                        if (!this.flag) {
                            QueryCancelTestHelper.incrementValueInBBMap(key, 2);
                            Activation a = resultSet.getActivation();
                            long connId = a.getConnectionID();
                            long stmtId = a.getStatementID();
                            long execId = a.getExecutionID();
                            QueryCancelTestHelper.putStatementUUIDinBBMap(key, connId, stmtId, execId);
                            this.flag = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.serverExecute(1, (Runnable)csr1);
        this.serverExecute(2, (Runnable)csr1);
        this.executeAndCancelQuery(stmt, usePrepStatement ? QueryCancelTestHelper.StatementType.PREPARED_STATEMENT : QueryCancelTestHelper.StatementType.STATEMENT, 2, key, testQueryString, useCancelSProc);
        ResultSet rs = null;
        rs = usePrepStatement ? ((PreparedStatement)stmt).executeQuery() : stmt.executeQuery(testQueryString);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        QueryCancelDUnit.assertEquals((int)tableSize, (int)numRows);
    }

    public void testSelectQuery_prepStmt() throws Throwable {
        this.selectQueryTest(true, false, false, "testSelectQuery_prepStmt");
    }

    public void testSelectQuery_prepStmt_thinClient() throws Throwable {
        this.selectQueryTest(true, false, true, "testSelectQuery_prepStmt_thinClient");
    }

    public void testSelectQuery() throws Throwable {
        this.selectQueryTest(false, false, false, "testSelectQuery");
    }

    public void testSelectQuery_thinClient() throws Throwable {
        this.selectQueryTest(false, false, true, "testSelectQuery_thinClient");
    }

    public void testSelectQueryUsingCancelSproc_thin() throws Throwable {
        this.selectQueryTest(false, true, true, "testSelectQueryUsingCancelSproc_thin");
    }

    public void testTxRollbackOnQueryCancellation() throws Throwable {
        this.deleteQueryTestWithTx(true, false, false, "testTxRollbackOnQueryCancellation");
    }

    public void deleteQueryTestWithTx(boolean usePrepStatement, boolean useCancelProc, boolean useThinClient, String testName) throws Throwable {
        int numServers = 2;
        int tableSize = 40;
        this.startVMs(1, 2);
        Connection cxn = this._getConnection(useThinClient);
        this.createTables(cxn, tableSize);
        cxn.setTransactionIsolation(2);
        cxn.setAutoCommit(false);
        Statement st = cxn.createStatement();
        st.execute("insert into MyTable values(1, 1)");
        st.execute("insert into MyTable values(2, 2)");
        st.execute("insert into MyTable values(3, 3)");
        st.execute("insert into MyTable values(4, 4)");
        ResultSet rs = st.executeQuery("select count(*) from MyTable");
        QueryCancelDUnit.assertTrue((boolean)rs.next());
        int count = rs.getInt(1);
        QueryCancelDUnit.assertEquals((int)44, (int)count);
        Statement stmt = null;
        String testQueryString = "delete from MyTable where x > 0";
        if (usePrepStatement) {
            PreparedStatement pstmt2 = cxn.prepareStatement("delete from MyTable where x > ?");
            pstmt2.setInt(1, 0);
            stmt = pstmt2;
        } else {
            stmt = cxn.createStatement();
        }
        final String key = testName;
        SerializableRunnable csr1 = new SerializableRunnable(testName){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private boolean flag = false;

                    public void onDeleteResultSetOpen(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        QueryCancelDUnit.this.getLogWriter().info((Object)"onDeleteResultSetOpen called");
                        if (!this.flag) {
                            QueryCancelTestHelper.incrementValueInBBMap(key, 2);
                            Activation a = resultSet.getActivation();
                            long connId = a.getConnectionID();
                            long stmtId = a.getStatementID();
                            long execId = a.getExecutionID();
                            QueryCancelTestHelper.putStatementUUIDinBBMap(key, connId, stmtId, execId);
                            this.flag = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.serverExecute(1, (Runnable)csr1);
        this.serverExecute(2, (Runnable)csr1);
        this.executeAndCancelQuery(stmt, usePrepStatement ? QueryCancelTestHelper.StatementType.PREPARED_STATEMENT : QueryCancelTestHelper.StatementType.STATEMENT, 2, key, testQueryString, useCancelProc);
        rs = st.executeQuery("select count(*) from MyTable");
        QueryCancelDUnit.assertTrue((boolean)rs.next());
        count = rs.getInt(1);
        QueryCancelDUnit.assertEquals((int)40, (int)count);
    }

    public void deleteQueryTest1(boolean usePrepStatement, boolean useCancelProc, boolean useThinClient, String testName) throws Throwable {
        int numServers = 2;
        int tableSize = 40;
        this.startVMs(1, 2);
        Connection cxn = this._getConnection(useThinClient);
        this.createTables(cxn, tableSize);
        Statement stmt = null;
        String testQueryString = "delete from MyTable where x > 0";
        if (usePrepStatement) {
            PreparedStatement pstmt2 = cxn.prepareStatement("delete from MyTable where x > ?");
            pstmt2.setInt(1, 0);
            stmt = pstmt2;
        } else {
            stmt = cxn.createStatement();
        }
        final String key = testName;
        SerializableRunnable csr1 = new SerializableRunnable(testName){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private boolean flag = false;

                    public void onDeleteResultSetOpen(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        QueryCancelDUnit.this.getLogWriter().info((Object)"onDeleteResultSetOpen called");
                        if (!this.flag) {
                            QueryCancelTestHelper.incrementValueInBBMap(key, 2);
                            Activation a = resultSet.getActivation();
                            long connId = a.getConnectionID();
                            long stmtId = a.getStatementID();
                            long execId = a.getExecutionID();
                            QueryCancelTestHelper.putStatementUUIDinBBMap(key, connId, stmtId, execId);
                            this.flag = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.serverExecute(1, (Runnable)csr1);
        this.serverExecute(2, (Runnable)csr1);
        this.executeAndCancelQuery(stmt, usePrepStatement ? QueryCancelTestHelper.StatementType.PREPARED_STATEMENT : QueryCancelTestHelper.StatementType.STATEMENT, 2, key, testQueryString, useCancelProc);
    }

    public void testDeleteQuery1_thinClient() throws Throwable {
        try {
            this.deleteQueryTest1(false, false, true, "testDeleteQuery1_thinClient");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testDeleteQuery1() throws Throwable {
        this.deleteQueryTest1(true, false, false, "testDeleteQuery1");
    }

    public void testDeleteQuery1_prepStmt() throws Throwable {
        this.deleteQueryTest1(true, false, false, "testDeleteQuery1_prepStmt");
    }

    public void testDeleteQuery1_prepStmt_thinClient() throws Throwable {
        this.deleteQueryTest1(true, false, true, "testDeleteQuery1_prepStmt_thinClient");
    }

    public void testDeleteQuery1UsingCancelProc_prepStmt_thinClient() throws Throwable {
        this.deleteQueryTest1(true, true, true, "testDeleteQuery1UsingCancelProc_prepStmt_thinClient");
    }

    public void deleteQueryTest2(boolean useCancelProc, boolean useThinClient, String testName) throws Throwable {
        int i;
        int numServers = 2;
        int tableSize = 40;
        this.startVMs(1, 2);
        Connection cxn = this._getConnection(useThinClient);
        Statement stmt = cxn.createStatement();
        stmt.execute("create table MyTable_parent(x int, y int primary key) partition by column(x)");
        stmt.execute("create table MyTable_child(a int, b int, foreign key (b) references MyTable_parent(y)) partition by column(a)");
        PreparedStatement pstmt1 = cxn.prepareStatement("insert into MyTable_parent values (?, ?)");
        for (i = 1; i <= tableSize * 2; ++i) {
            pstmt1.setInt(1, i);
            pstmt1.setInt(2, i);
            pstmt1.execute();
        }
        pstmt1 = cxn.prepareStatement("insert into MyTable_child values (?, ?)");
        for (i = 1; i <= tableSize; ++i) {
            pstmt1.setInt(1, i);
            pstmt1.setInt(2, i);
            pstmt1.execute();
        }
        pstmt1.close();
        stmt.close();
        PreparedStatement pstmt2 = cxn.prepareStatement("delete from MyTable_parent where x > ?");
        pstmt2.setInt(1, tableSize);
        final String key = testName;
        SerializableRunnable csr1 = new SerializableRunnable(testName){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private boolean flag = false;

                    public void onDeleteResultSetOpenAfterRefChecks(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        QueryCancelDUnit.this.getLogWriter().info((Object)"onDeleteResultSetOpenAfterRefChecks called");
                        if (!this.flag) {
                            QueryCancelTestHelper.incrementValueInBBMap(key, 2);
                            Activation a = resultSet.getActivation();
                            long connId = a.getConnectionID();
                            long stmtId = a.getStatementID();
                            long execId = a.getExecutionID();
                            QueryCancelTestHelper.putStatementUUIDinBBMap(key, connId, stmtId, execId);
                            this.flag = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.serverExecute(1, (Runnable)csr1);
        this.serverExecute(2, (Runnable)csr1);
        this.executeAndCancelQuery(pstmt2, QueryCancelTestHelper.StatementType.PREPARED_STATEMENT, 2, key, null, useCancelProc);
    }

    public void testDeleteQuery2() throws Throwable {
        this.deleteQueryTest2(false, false, "testDeleteQuery2");
    }

    public void testDeleteQuery2UsingCancelProc_thin() throws Throwable {
        this.deleteQueryTest2(true, true, "testDeleteQuery2UsingCancelProc_thin");
    }

    public void updateQueryTest(boolean useCancelProc, boolean useThinClient, String testName) throws Throwable {
        int numServers = 2;
        int tableSize = 40;
        this.startVMs(1, 2);
        Connection cxn = this._getConnection(useThinClient);
        this.createTables(cxn, tableSize);
        PreparedStatement pstmt2 = cxn.prepareStatement("select * from MyTable where x > ?");
        pstmt2.setInt(1, 0);
        final String key = testName;
        SerializableRunnable csr1 = new SerializableRunnable(testName){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private boolean flag = false;

                    public void onGetNextRowCoreOfBulkTableScan(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        QueryCancelDUnit.this.getLogWriter().info((Object)"onGetNextRowCoreOfBulkTableScan called");
                        if (!this.flag) {
                            QueryCancelTestHelper.incrementValueInBBMap(key, 2);
                            Activation a = resultSet.getActivation();
                            long connId = a.getConnectionID();
                            long stmtId = a.getStatementID();
                            long execId = a.getExecutionID();
                            QueryCancelTestHelper.putStatementUUIDinBBMap(key, connId, stmtId, execId);
                            this.flag = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.serverExecute(1, (Runnable)csr1);
        this.serverExecute(2, (Runnable)csr1);
        this.executeAndCancelQuery(pstmt2, QueryCancelTestHelper.StatementType.PREPARED_STATEMENT, 2, key, null, useCancelProc);
    }

    public void testUpdateQuery() throws Throwable {
        this.updateQueryTest(false, false, "testUpdateQuery");
    }

    public void testUpdateQueryUsingCancelProc_thin() throws Throwable {
        this.updateQueryTest(true, true, "testUpdateQueryUsingCancelProc_thin");
    }

    public void __testExecuteBatch() throws Throwable {
    }

    public void testBatchInsert() throws Throwable {
        int numServers = 2;
        boolean numClients = true;
        int tableSize = 10;
        this.startVMs(1, 2);
        Connection cxn = TestUtil.getConnection();
        this.createTables(cxn, 0);
        PreparedStatement pstmt2 = cxn.prepareStatement("insert into mytable values (?, ?)");
        for (int i = 1; i < tableSize; ++i) {
            pstmt2.setInt(1, i);
            pstmt2.setInt(2, i);
            pstmt2.addBatch();
        }
        String key = "testBatchInsert";
        SerializableRunnable csr1 = new SerializableRunnable("_testBatchInsert_"){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private boolean flag = false;

                    public void beforeFlushBatch(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet, LanguageConnectionContext lcc) {
                        QueryCancelDUnit.this.getLogWriter().info((Object)"beforeFlushBatch called");
                        if (!this.flag) {
                            QueryCancelTestHelper.incrementValueInBBMap("testBatchInsert", 1);
                            this.flag = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.clientExecute(1, (Runnable)csr1);
        this.executeAndCancelQuery(pstmt2, QueryCancelTestHelper.StatementType.BATCH_STATEMENT, 1, "testBatchInsert", null, false);
    }

    public static void proc2(int[] count, String testName, ResultSet[] resultSet1, ResultSet[] resultSet2, ProcedureExecutionContext ctx) throws SQLException, InterruptedException {
        Connection conn = ctx.getConnection();
        PreparedStatement ps1 = conn.prepareStatement("select * from mytable");
        ps1.execute();
        resultSet1[0] = ps1.getResultSet();
        QueryCancelDUnit.incrementValueInBBMap(testName, 2);
        Thread.sleep(3000L);
        ctx.checkQueryCancelled();
        QueryCancelDUnit.fail((String)"The procedure should have failed due to a user initiated cancellation (SQLState:XCL56)");
        PreparedStatement ps2 = conn.prepareStatement("select count(*) from mytable");
        ps2.execute();
        ps2.getResultSet().next();
        Integer cnt = ps2.getResultSet().getInt(1);
        count[0] = cnt;
        PreparedStatement ps3 = conn.prepareStatement("select count(*) from mytable");
        ps3.execute();
        resultSet2[0] = ps3.getResultSet();
    }

    public void storedProcTest(boolean useCancelProc, String testName) throws Throwable {
        int numServers = 2;
        this.startVMs(1, 2);
        Connection cxn = TestUtil.getConnection();
        Statement stmt = cxn.createStatement();
        stmt.execute("CREATE PROCEDURE Proc2 (OUT count INTEGER, IN testName varchar(50))LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 2 EXTERNAL NAME '" + QueryCancelDUnit.class.getName() + ".proc2'");
        stmt.execute("create table MyTable(x int, y int) partition by column(x)");
        stmt.execute("insert into MyTable values (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7)");
        CallableStatement callableStmt = cxn.prepareCall("{CALL Proc2(?, ?) ON TABLE MyTable}");
        callableStmt.registerOutParameter(1, 4);
        callableStmt.setString(2, testName);
        this.executeAndCancelQuery(callableStmt, QueryCancelTestHelper.StatementType.PREPARED_STATEMENT, 2, testName, null, useCancelProc);
    }

    public void testStoredProc() throws Throwable {
        this.storedProcTest(false, "testStoredProc");
    }

    public void DISABLED__testStoredProcUsingCancelProc() throws Throwable {
        this.storedProcTest(true, "testStoredProcUsingCancelProc");
    }

    public void TSMCSubSelectQueryTest(boolean useThinClient, String testName, boolean useCancelProc) throws Throwable {
        int numServers = 2;
        this.startVMs(1, 2);
        Connection conn = this._getConnection(useThinClient);
        Statement st = conn.createStatement();
        st.execute("create table FDC_NRT_CNTXT_HIST (EQP_ID VARCHAR(40) NOT NULL, CNTXT_ID INTEGER NOT NULL, STOP_DT TIMESTAMP NOT NULL,  primary key(eqp_id, cntxt_id, stop_dt) ) partition by column (eqp_id, cntxt_id, stop_dt)");
        st.execute("insert into FDC_NRT_CNTXT_HIST values  ('1', 1, '2014-01-24 18:48:00'),('2', 1, '2014-01-24 18:48:00'),('3', 1, '2014-01-24 18:48:00'),('4', 1, '2014-01-24 18:48:00'),('5', 1, '2014-01-24 18:48:00'),('6', 1, '2014-01-24 18:48:00'),('7', 1, '2014-01-24 18:48:00'),('8', 1, '2014-01-24 18:48:00'),('9', 1, '2014-01-24 18:48:00'),('10', 1, '2014-01-24 18:48:00'),('11', 1, '2014-01-24 18:48:00'),('12', 1, '2014-01-24 18:48:00'),('13', 1, '2014-01-24 18:48:00')");
        st.execute("create table FDC_NRT_TCHART_HIST (EQP_ID VARCHAR(40) NOT NULL, CNTXT_ID INTEGER NOT NULL, STOP_DT TIMESTAMP NOT NULL, SVID_NAME VARCHAR(64) NOT NULL,  primary key(eqp_id, cntxt_id, stop_dt, svid_name) ) partition by column (eqp_id, cntxt_id, stop_dt) COLOCATE WITH (FDC_NRT_CNTXT_HIST)");
        st.execute("insert into FDC_NRT_TCHART_HIST values  ('1', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('2', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('3', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('4', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('5', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('6', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('7', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('8', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('9', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('10', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('11', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('12', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('13', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59')");
        st.execute("create table FDC_NRT_PUMPER_HIST_LOG ( EQP_ID VARCHAR(40) NOT NULL, CNTXT_ID INTEGER NOT NULL, STOP_DT TIMESTAMP NOT NULL, UPDATE_DT TIMESTAMP NOT NULL, EXEC_TIME DOUBLE, primary key (eqp_id, cntxt_id, stop_dt, update_dt) ) partition by primary key");
        st.execute("insert into FDC_NRT_PUMPER_HIST_LOG values  ('1', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('2', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('3', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('4', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('5', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('6', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('7', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('8', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('9', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('10', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('11', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('12', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('13', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41)");
        PreparedStatement pstmt = conn.prepareStatement("select a.eqp_id, a.cntxt_id, a.stop_dt, dsid() as datanode_id from FDC_NRT_CNTXT_HIST a left join FDC_NRT_TCHART_HIST b on (a.eqp_id =b.eqp_id and a.cntxt_id=b.cntxt_id and a.stop_dt=b.stop_dt) where a.eqp_id||cast(a.cntxt_id as char(100)) in ( select eqp_id||cast(t.cntxt_id as char(100)) from FDC_NRT_PUMPER_HIST_LOG t where 1=1 and exec_time > 40 and stop_dt > '2014-01-24 18:47:59' and stop_dt < '2014-01-24 18:49:59')");
        final String key = testName;
        SerializableRunnable csr1 = new SerializableRunnable(testName){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private boolean flag = false;

                    public void onGetNextRowCoreOfBulkTableScan(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        QueryCancelDUnit.this.getLogWriter().info((Object)"onGetNextRowCoreOfBulkTableScan called");
                        if (!this.flag) {
                            QueryCancelTestHelper.incrementValueInBBMap(key, 2);
                            Activation a = resultSet.getActivation();
                            long connId = a.getConnectionID();
                            long stmtId = a.getStatementID();
                            long execId = a.getExecutionID();
                            QueryCancelTestHelper.putStatementUUIDinBBMap(key, connId, stmtId, execId);
                            this.flag = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.serverExecute(1, (Runnable)csr1);
        this.serverExecute(2, (Runnable)csr1);
        this.executeAndCancelQuery(pstmt, QueryCancelTestHelper.StatementType.PREPARED_STATEMENT, 2, key, null, useCancelProc);
    }

    public void testTSMCSubSelectQuery() throws Throwable {
        this.TSMCSubSelectQueryTest(true, "testTSMCSubSelectQuery", false);
    }

    public void selectQueryWithSubSelectTest(boolean useCancelProc, boolean useThinClient, String testName) throws Throwable {
        int numServers = 2;
        this.startVMs(1, 2);
        Connection cxn = this._getConnection(useThinClient);
        Statement st = cxn.createStatement();
        String subquery = "Select SUM(ID2) from Testtable2 where description2 = 'desc2_'";
        String query = "select ID1, DESCRIPTION1 from TESTTABLE1 where ID1 IN (Select SUM(ID2) from Testtable2 where description2 = 'desc2_')";
        st.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null, primary key (ID1))PARTITION BY COLUMN ( ID1 )");
        st.execute("create table TESTTABLE2 (ID2 int not null,  DESCRIPTION2 varchar(1024) not null, ADDRESS2 varchar(1024) not null, primary key (ID2)) partition by column( ID2)  colocate with (TESTTABLE1) ");
        for (int i = 1; i < 40; ++i) {
            st.execute("Insert into  TESTTABLE1 values(" + i + ",'desc1_" + i + "', 'ADD_1" + i + "')");
            st.execute("Insert into  TESTTABLE2 values(" + i + ",'desc2_" + "', 'ADD_2" + i + "')");
        }
        PreparedStatement pstmt = cxn.prepareStatement(query);
        final String key = testName;
        SerializableRunnable csr1 = new SerializableRunnable(testName){

            public void run() {
                GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private boolean flag = false;

                    public void onGetNextRowCoreOfGfxdSubQueryResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet resultSet) {
                        QueryCancelDUnit.this.getLogWriter().info((Object)"onGetNextRowCoreOfBulkTableScan called");
                        if (!this.flag) {
                            QueryCancelTestHelper.incrementValueInBBMap(key, 2);
                            Activation a = resultSet.getActivation();
                            long connId = a.getConnectionID();
                            long stmtId = a.getStatementID();
                            long execId = a.getExecutionID();
                            QueryCancelTestHelper.putStatementUUIDinBBMap(key, connId, stmtId, execId);
                            this.flag = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.serverExecute(1, (Runnable)csr1);
        this.serverExecute(2, (Runnable)csr1);
        this.executeAndCancelQuery(pstmt, QueryCancelTestHelper.StatementType.PREPARED_STATEMENT, 2, key, null, useCancelProc);
    }

    public void testSubQuery() throws Throwable {
        this.selectQueryWithSubSelectTest(false, false, "testSubQuery");
    }

    public void testSubQueryUsingCancelProc_thin() throws Throwable {
        this.selectQueryWithSubSelectTest(true, true, "testSubQueryUsingCancelProc_thin");
    }
}

