/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.query;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.control.ResourceAdvisor;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.query.HeapThresholdHelper;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDistributedResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import io.snappydata.test.dunit.standalone.DUnitBB;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class HeapThresholdDUnit
extends DistributedSQLTestBase {
    private static final Map<String, String> queryExecutionErrorStatus = new HashMap<String, String>();

    public HeapThresholdDUnit(String name) {
        super(name);
    }

    @Override
    protected void vmTearDown() throws Exception {
        queryExecutionErrorStatus.clear();
        super.vmTearDown();
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testBug41438() throws Exception {
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        this.startServerVMs(2, 0, null);
        TestUtil.jdbcConn = conn;
        HeapThresholdDUnit.assertTrue((String)"Connection shouldn't be null", (conn != null ? 1 : 0) != 0);
        HeapThresholdHelper.prepareTables(conn);
        conn.close();
        this.stopNetworkServer(1);
        this.stopVMNums(-2, -3);
        TestUtil.shutDown();
        this.restartVMNums(-1, -2, -3);
        netPort = this.startNetworkServer(1, null, null);
        TestUtil.jdbcConn = conn = TestUtil.getNetConnection(netPort, null, null);
        HeapThresholdDUnit.assertTrue((String)"Connection shouldn't be null", (conn != null ? 1 : 0) != 0);
        HeapThresholdHelper.prepareTables(conn);
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCancelation() throws Exception {
        this.startVMs(1, 3);
        HeapThresholdHelper.prepareTables(null);
        String[] queries = new String[]{"Select ID1 from testtable1 where id1 > 12", "Select * from testtable1 where id1 > 10", "Select ID1 from testtable1 where id1 > 9 order by description1", "Select ID1 from testtable1 order by description1", "Select ID1, ADDRESS1 from testtable1 order by address1", "Select ID1 from testtable1 t1 join testtable2 t2 on t1.id1 = t2.id2", "Select t1.id1, t2.id2 from testtable1 t1 left outer join testtable2 t2 on t1.id1 = t2.id2", "Select * from testtable1 t1 join testtable2 t2 on t1.id1 = t2.id2"};
        DistributedTestQueryExecutor[] executors = new DistributedTestQueryExecutor[queries.length];
        VM pausevm = (VM)this.serverVMs.get(0);
        Object[] expectedEx = new Object[]{SQLException.class, "heap critical threshold"};
        this.addExpectedException(null, expectedEx);
        this.addExpectedException(pausevm, expectedEx);
        Thread[] executionThrds = new Thread[queries.length];
        try {
            for (int i = 0; i < queries.length; ++i) {
                executors[i] = new DistributedTestQueryExecutor(0, queries[i], HeapThresholdHelper.PauseVariants.PAUSE_AFTER_QUERY_EXECUTE, null);
                executionThrds[i] = HeapThresholdDUnit.executeQueryInVM(pausevm, executors[i]);
            }
            HeapThresholdDUnit.dumpSharedMap("Going to wait for compilation ");
            for (DistributedTestQueryExecutor distributedTestQueryExecutor : executors) {
                ((HeapThresholdHelper.QueryExecutor)distributedTestQueryExecutor).waitForCompilation();
            }
            HeapThresholdDUnit.dumpSharedMap("Done Waiting for compilation ");
            this.getLogWriter().info((Object)("About to raise CRITICAL_UP event in VM " + pausevm.getPid()));
            pausevm.invoke(HeapThresholdHelper.class, "raiseMemoryEvent", new Object[]{true, false});
            HeapThresholdDUnit.waitForCriticalUpMembers(10000L);
            for (DistributedTestQueryExecutor distributedTestQueryExecutor : executors) {
                ((HeapThresholdHelper.QueryExecutor)distributedTestQueryExecutor).notifyMemoryEvent();
            }
            HeapThresholdDUnit.dumpSharedMap("Notified Memory Status ");
            for (Runnable runnable : executionThrds) {
                this.getLogWriter().info((Object)("Waiting for thread " + ((Thread)runnable).getName()));
                ((Thread)runnable).join();
            }
            HeapThresholdDUnit.dumpSharedMap("Done Memory Status processing ");
            this.getLogWriter().info((Object)("About to raise CRITICAL_DOWN event in VM " + pausevm.getPid()));
            pausevm.invoke(HeapThresholdHelper.class, "raiseMemoryEvent", new Object[]{false, true});
            if (queryExecutionErrorStatus.size() > 0) {
                for (Map.Entry<String, String> mapEnt : queryExecutionErrorStatus.entrySet()) {
                    this.getLogWriter().error((Object)("Query " + mapEnt.getKey() + " FailMessage " + mapEnt.getValue()));
                }
                HeapThresholdDUnit.fail((String)("Execution failed with errors: " + queryExecutionErrorStatus));
            }
        }
        catch (Throwable throwable) {
            pausevm.invoke((Runnable)new SerializableRunnable("reset observer"){

                public void run() throws CacheException {
                    try {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            });
            this.removeExpectedException(pausevm, expectedEx);
            this.removeExpectedException(null, expectedEx);
            throw throwable;
        }
        pausevm.invoke((Runnable)new /* invalid duplicate definition of identical inner class */);
        this.removeExpectedException(pausevm, expectedEx);
        this.removeExpectedException(null, expectedEx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNetworkQueryCancelation() throws Exception {
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        this.startServerVMs(2, 0, null);
        TestUtil.jdbcConn = conn;
        HeapThresholdDUnit.assertTrue((String)"Connection shouldn't be null", (conn != null ? 1 : 0) != 0);
        HeapThresholdHelper.prepareTables(conn);
        String[] queries = new String[]{"Select ID1 from testtable1 where id1 > 12", "Select * from testtable1 where id1 > 10", "Select ID1 from testtable1 where id1 > 9 order by description1", "Select ID1 from testtable1 order by description1", "Select ID1, ADDRESS1 from testtable1 order by address1", "Select ID1 from testtable1 t1 join testtable2 t2 on t1.id1 = t2.id2", "Select t1.id1, t2.id2 from testtable1 t1 left outer join testtable2 t2 on t1.id1 = t2.id2", "Select * from testtable1 t1 join testtable2 t2 on t1.id1 = t2.id2"};
        DistributedTestQueryExecutor[] executors = new DistributedTestQueryExecutor[queries.length];
        VM pausevm = (VM)this.serverVMs.get(1);
        Object[] expectedEx = new Object[]{SQLException.class, "heap critical threshold"};
        this.addExpectedException(null, expectedEx);
        this.addExpectedException(pausevm, expectedEx);
        Thread[] executionThrds = new Thread[queries.length];
        try {
            for (int i = 0; i < queries.length; ++i) {
                executors[i] = new DistributedTestQueryExecutor(netPort, queries[i], HeapThresholdHelper.PauseVariants.PAUSE_AFTER_QUERY_EXECUTE, null);
                executionThrds[i] = HeapThresholdDUnit.executeQueryInVM(pausevm, executors[i]);
            }
            HeapThresholdDUnit.dumpSharedMap("Going to wait for compilation ");
            for (DistributedTestQueryExecutor distributedTestQueryExecutor : executors) {
                ((HeapThresholdHelper.QueryExecutor)distributedTestQueryExecutor).waitForCompilation();
            }
            HeapThresholdDUnit.dumpSharedMap("Done Waiting for compilation ");
            this.getLogWriter().info((Object)("About to raise CRITICAL_UP event in VM " + pausevm.getPid()));
            pausevm.invoke(HeapThresholdHelper.class, "raiseMemoryEvent", new Object[]{true, false});
            HeapThresholdDUnit.waitForCriticalUpMembers(5000L);
            for (DistributedTestQueryExecutor distributedTestQueryExecutor : executors) {
                ((HeapThresholdHelper.QueryExecutor)distributedTestQueryExecutor).notifyMemoryEvent();
            }
            HeapThresholdDUnit.dumpSharedMap("Notified Memory Status ");
            for (Runnable runnable : executionThrds) {
                this.getLogWriter().info((Object)("Waiting for thread " + ((Thread)runnable).getName()));
                ((Thread)runnable).join();
            }
            HeapThresholdDUnit.dumpSharedMap("Done Memory Status processing ");
            this.getLogWriter().info((Object)("About to raise CRITICAL_DOWN event in VM " + pausevm.getPid()));
            pausevm.invoke(HeapThresholdHelper.class, "raiseMemoryEvent", new Object[]{false, true});
            if (queryExecutionErrorStatus.size() > 0) {
                for (Map.Entry<String, String> mapEnt : queryExecutionErrorStatus.entrySet()) {
                    this.getLogWriter().error((Object)("Query " + mapEnt.getKey() + " FailMessage " + mapEnt.getValue()));
                }
                HeapThresholdDUnit.fail((String)("Execution failed with errors: " + queryExecutionErrorStatus));
            }
        }
        catch (Throwable throwable) {
            pausevm.invoke((Runnable)new SerializableRunnable("reset observer"){

                public void run() throws CacheException {
                    try {
                        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            });
            throw throwable;
        }
        pausevm.invoke((Runnable)new /* invalid duplicate definition of identical inner class */);
        this.removeExpectedException(pausevm, expectedEx);
        this.removeExpectedException(null, expectedEx);
    }

    public void testCancellationFromBufferExpansion() throws Exception {
        this.startVMs(1, 3);
        HeapThresholdHelper.prepareTables(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_testBug44265() throws Exception {
        this.startVMs(1, 3);
        HeapThresholdHelper.prepareTables(null);
        VM pausevm1 = (VM)this.serverVMs.get(0);
        SerializableRunnable pauseQuery = new SerializableRunnable(){

            public void run() {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private String queryStr;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public boolean afterQueryExecution(CallbackStatement stmt, SQLException sqle) {
                        this.queryStr = stmt.getSQLText();
                        TestUtil.getLogger().info((Object)("afterQueryExecution: honoring callback " + stmt.getSQLText()));
                        try {
                            while (true) {
                                HeapThresholdDUnit.updateQueryStatus("COMPILED", this.queryStr);
                                TestUtil.getLogger().info((Object)"Waiting forever .... ");
                                1 var3_3 = this;
                                synchronized (var3_3) {
                                    ((Object)((Object)this)).wait();
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, com.pivotal.gemfirexd.internal.iapi.sql.ResultSet theResults) {
                    }

                    public long estimatedMemoryUsage(String stmtText, long memused) {
                        TestUtil.getLogger().info((Object)("afterQueryExecution: estimated memory for " + stmtText + " is " + memused));
                        return memused;
                    }
                });
            }
        };
        pausevm1.invoke((Runnable)pauseQuery);
        final boolean[] hasMemoryEstimationTriggered = new boolean[]{false};
        String queryStr = "Select ID1 from testtable1 where id1 > 1";
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void estimatingMemoryUsage(String stmtText, Object resultSet) {
                if (!(resultSet instanceof GemFireDistributedResultSet)) {
                    TestUtil.getLogger().info((Object)" Not yet reached GemFireDistributedResultSet ... ", new Throwable());
                    return;
                }
                hasMemoryEstimationTriggered[0] = true;
                TestUtil.getLogger().info((Object)("estimating memory on query node for " + stmtText));
            }
        });
        Object[] expectedEx = new Object[]{SQLException.class, "heap critical threshold", CacheClosedException.class};
        this.addExpectedException(null, expectedEx);
        this.addExpectedException(pausevm1, expectedEx);
        Thread executionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        Connection c = TestUtil.getConnection();
                        TestCase.assertTrue((boolean)(c instanceof EmbedConnection));
                        EmbedConnection ec = (EmbedConnection)c;
                        ec.getLanguageConnection().setEnableStreaming(true);
                        PreparedStatement ps = c.prepareStatement("Select ID1 from testtable1 where id1 > 1");
                        ResultSet rs = ps.executeQuery();
                        TestUtil.getLogger().info((Object)"Execute Query done... doing rs.next ");
                        while (rs.next()) {
                        }
                        rs.close();
                    }
                    catch (SQLException e) {
                        if ("08006".equals(e.getSQLState())) break block3;
                        DistributedSQLTestBase.fail("Execution failed", e);
                    }
                }
            }
        });
        executionThread.start();
        HeapThresholdDUnit.waitForQueryStatus("COMPILED", "Select ID1 from testtable1 where id1 > 1");
        TestUtil.getLogger().info((Object)"Raising critical_up memory event ");
        HeapThresholdHelper.raiseMemoryEvent(true, false);
        while (!hasMemoryEstimationTriggered[0]) {
            Thread.sleep(100L);
        }
        Thread.sleep(1000L);
        TestUtil.getLogger().info((Object)"Shutting down the current VM ");
        this.stopVMNum(1);
        TestUtil.getLogger().info((Object)"Closing pending execution thread and exiting test. ");
        executionThread.interrupt();
        executionThread.join();
        this.removeExpectedException(null, expectedEx);
        this.removeExpectedException(pausevm1, expectedEx);
    }

    public static void updateQueryStatus(String qs, String queryStr) {
        DUnitBB.getBB().put((Object)queryStr, (Object)qs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void waitForQueryStatus(String expectedStatus, String queryStr) {
        long maxWait = System.currentTimeMillis() + 30000L;
        Thread t = Thread.currentThread();
        if (t.getName().startsWith("DRDA")) {
            return;
        }
        try {
            Object val;
            do {
                Thread.sleep(500L);
                if (System.currentTimeMillis() > maxWait) return;
                val = DUnitBB.getBB().get((Object)queryStr);
                HeapThresholdDUnit.assertTrue((String)"val not instance of String", (val == null || val instanceof String ? 1 : 0) != 0);
            } while (val == null || !val.equals(expectedStatus));
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static Thread executeQueryInVM(VM vm, final HeapThresholdHelper.QueryExecutor executor) throws SQLException, InterruptedException {
        HeapThresholdDUnit.getGlobalLogger().info((Object)("Installing observer for " + executor.query() + " on VM " + vm.getPid() + " Host " + vm.getHost()));
        vm.invoke((Runnable)new SerializableRunnable("set observer"){

            public void run() {
                DistributedTestBase.getGlobalLogger().info((Object)("Setting the observer for variant " + executor.variant().name() + " query " + executor.query()));
                GemFireXDQueryObserverHolder.putInstance((QueryObserver)executor.observer());
            }
        });
        HeapThresholdDUnit.getGlobalLogger().info((Object)("Executing Query ..." + executor.query()));
        Thread t = HeapThresholdHelper.executeQueryInThread(executor);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        DistributedSQLTestBase.reset();
        Map<String, String> map = queryExecutionErrorStatus;
        synchronized (map) {
            queryExecutionErrorStatus.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToExecutionErrorStatus(String query, String failmsg) {
        Map<String, String> map = queryExecutionErrorStatus;
        synchronized (map) {
            queryExecutionErrorStatus.put(query, failmsg);
        }
    }

    private static void waitForCriticalUpMembers(long maxWait) throws Exception {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            Thread.sleep(maxWait);
        } else {
            ResourceAdvisor adviser = cache.getResourceAdvisor();
            long start = System.currentTimeMillis();
            while (adviser.adviseCriticalMembers().size() == 0) {
                Thread.sleep(100L);
                if (maxWait < 0L || System.currentTimeMillis() - start <= maxWait) continue;
                break;
            }
        }
    }

    private static void dumpSharedMap(String msg) {
        Map map = DUnitBB.getBB().getMapCopy();
        TestUtil.getLogger().info((Object)("dumpSharedMap: " + msg + "Dumping shared map of size " + map.size()));
        for (Map.Entry entry : map.entrySet()) {
            HeapThresholdDUnit.getGlobalLogger().info((Object)("dumpSharedMap: Key=" + entry.getKey() + " value=" + entry.getValue()));
        }
    }

    class DistributedTestQueryExecutor
    extends HeapThresholdHelper.QueryExecutor
    implements Serializable {
        private final int netPort;

        DistributedTestQueryExecutor() {
            this.netPort = 0;
            this.useThreadLocal = false;
        }

        DistributedTestQueryExecutor(int netPort, String queryStr, HeapThresholdHelper.PauseVariants variant, String[] constantList) {
            super(queryStr, variant, constantList);
            this.netPort = netPort;
            this.useThreadLocal = false;
        }

        @Override
        protected Connection getConnection() throws SQLException {
            if (this.netPort != 0) {
                return TestUtil.getNetConnection(this.netPort, null, null);
            }
            return super.getConnection();
        }

        @Override
        protected void setFailedStatus(String query, String failmsg) {
            HeapThresholdDUnit.addToExecutionErrorStatus(query, failmsg);
        }

        @Override
        public void run() {
            try {
                this.execute(false);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void waitForCompilation() throws InterruptedException {
            TestUtil.getLogger().info((Object)("Start waiting for compilation " + this.queryStr));
            HeapThresholdDUnit.waitForQueryStatus("COMPILED", this.queryStr);
            TestUtil.getLogger().info((Object)("Done waiting for compilation " + this.queryStr));
        }

        @Override
        public void notifyCompilation() {
            TestUtil.getLogger().info((Object)("Done compilation of " + this.queryStr + " "));
            HeapThresholdDUnit.updateQueryStatus("COMPILED", this.queryStr);
        }

        @Override
        public void waitForMemoryEvent() {
            if (this.minRowsExpected != -1 && ++this.numOfNexts < this.minRowsExpected) {
                return;
            }
            this.notifyCompilation();
            TestUtil.getLogger().info((Object)("Start waiting for memory event from " + DUnitBB.getBB().get((Object)this.queryStr) + " state " + this.queryStr));
            HeapThresholdDUnit.waitForQueryStatus("EXECUTING", this.queryStr);
            TestUtil.getLogger().info((Object)("Done waiting for memory event " + this.queryStr));
        }

        @Override
        public void notifyMemoryEvent() {
            TestUtil.getLogger().info((Object)("Notifying memoryEvent for " + this.queryStr + " "));
            HeapThresholdDUnit.updateQueryStatus("EXECUTING", this.queryStr);
        }
    }

    class QueryStatus {
        static final String INIT = "INIT";
        static final String COMPILED = "COMPILED";
        static final String EXECUTING = "EXECUTING";
        static final String DONE = "DONE";

        QueryStatus() {
        }
    }
}

