/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.query;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.BlobTest;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class BlobTestsDUnit
extends DistributedSQLTestBase {
    private static int BUFFER_SIZE = 1024;
    private static int UPDATE_SIZE = 100;

    public BlobTestsDUnit(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testSetBytesLargeBlob() throws Exception {
        int i;
        int i2;
        this.startVMs(1, 4);
        Connection con = TestUtil.getConnection();
        Statement stmt = con.createStatement();
        stmt.execute("create table blobtest (id integer, data Blob)");
        stmt.close();
        con.setAutoCommit(false);
        PreparedStatement pstmt = con.prepareStatement("insert into blobtest (id, data) values (?,?)");
        Blob blob = con.createBlob();
        byte[] data = new byte[BUFFER_SIZE];
        for (i2 = 0; i2 < BUFFER_SIZE; ++i2) {
            data[i2] = (byte)(i2 % 255);
        }
        for (i2 = 0; i2 < 5; ++i2) {
            blob.setBytes(i2 * BUFFER_SIZE + 1, data);
        }
        BlobTestsDUnit.assertEquals((long)(BUFFER_SIZE * 5), (long)blob.length());
        byte[] data1 = new byte[UPDATE_SIZE];
        for (int i3 = 0; i3 < UPDATE_SIZE; ++i3) {
            data1[i3] = 120;
        }
        blob.setBytes(BUFFER_SIZE + 1, data1);
        blob.setBytes(BUFFER_SIZE * 5 + 1, data1);
        BlobTestsDUnit.assertEquals((long)(5 * BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        pstmt.setInt(1, 3);
        pstmt.setBlob(2, blob);
        pstmt.executeUpdate();
        stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select data from blobtest where id = 3");
        BlobTestsDUnit.assertEquals((boolean)true, (boolean)rs.next());
        blob = rs.getBlob(1);
        byte[] data2 = blob.getBytes(BUFFER_SIZE + 1, UPDATE_SIZE);
        BlobTestsDUnit.assertEquals((long)(5 * BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobTestsDUnit.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        data2 = blob.getBytes(5 * BUFFER_SIZE + 1, UPDATE_SIZE);
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobTestsDUnit.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        blob.truncate(BUFFER_SIZE);
        BlobTestsDUnit.assertEquals((String)"truncate failed", (long)BUFFER_SIZE, (long)blob.length());
        rs.close();
        con.commit();
        stmt.close();
        pstmt.close();
    }

    public void testSetBytesSmallBlob() throws Exception {
        int i;
        this.startVMs(1, 4);
        Connection con = TestUtil.getConnection();
        Statement stmt = con.createStatement();
        stmt.execute("create table blobtest (id integer, data Blob)");
        stmt.close();
        con.setAutoCommit(false);
        PreparedStatement pstmt = con.prepareStatement("insert into blobtest (id, data) values (?,?)");
        pstmt.setInt(1, 1);
        Blob blob = con.createBlob();
        byte[] data = new byte[BUFFER_SIZE];
        for (int i2 = 0; i2 < BUFFER_SIZE; ++i2) {
            data[i2] = (byte)(i2 % 255);
        }
        blob.setBytes(1L, data);
        BlobTestsDUnit.assertEquals((long)BUFFER_SIZE, (long)blob.length());
        pstmt.setBlob(2, blob);
        pstmt.executeUpdate();
        stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select data from blobtest where id = 1");
        BlobTestsDUnit.assertEquals((boolean)true, (boolean)rs.next());
        blob = rs.getBlob(1);
        BlobTestsDUnit.assertEquals((long)BUFFER_SIZE, (long)blob.length());
        byte[] data1 = new byte[UPDATE_SIZE];
        for (int i3 = 0; i3 < UPDATE_SIZE; ++i3) {
            data1[i3] = 120;
        }
        blob.setBytes(UPDATE_SIZE, data1);
        byte[] data2 = blob.getBytes(100L, UPDATE_SIZE);
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobTestsDUnit.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        blob.setBytes(BUFFER_SIZE + 1, data1);
        BlobTestsDUnit.assertEquals((long)(BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        data2 = blob.getBytes(BUFFER_SIZE + 1, UPDATE_SIZE);
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobTestsDUnit.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        pstmt.setInt(1, 2);
        pstmt.setBlob(2, blob);
        pstmt.executeUpdate();
        rs = stmt.executeQuery("select data from blobtest where id = 2");
        BlobTestsDUnit.assertEquals((boolean)true, (boolean)rs.next());
        blob = rs.getBlob(1);
        BlobTestsDUnit.assertEquals((long)(BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        data2 = blob.getBytes(100L, UPDATE_SIZE);
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobTestsDUnit.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        data2 = blob.getBytes(BUFFER_SIZE + 1, UPDATE_SIZE);
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobTestsDUnit.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        blob = con.createBlob();
        data = new byte[100];
        for (i = 0; i < 100; ++i) {
            data[i] = (byte)i;
        }
        blob.setBytes(1L, data);
        BlobTestsDUnit.assertEquals((long)blob.length(), (long)100L);
        blob.truncate(50L);
        BlobTestsDUnit.assertEquals((long)blob.length(), (long)50L);
        blob.setBytes(1L, data);
        BlobTestsDUnit.assertEquals((String)"set failed", (long)blob.length(), (long)100L);
        blob.truncate(50L);
        BlobTestsDUnit.assertEquals((String)"truncation failed", (long)blob.length(), (long)50L);
        rs.close();
        con.commit();
        stmt.close();
        pstmt.close();
        stmt = con.createStatement();
        stmt.execute("drop table blobtest");
        stmt.close();
    }

    public void testBug43623() throws Exception {
        this.startVMs(2, 2);
        int netPort = this.startNetworkServer(2, null, null);
        Connection conn = TestUtil.getConnection();
        this.runTests_43623(conn);
        conn.close();
        conn = TestUtil.getNetConnection(netPort, null, null);
        conn.createStatement().execute("drop table QUARTZ_TRIGGERS");
        this.runTests_43623(conn);
        conn.close();
    }

    private void runTests_43623(Connection conn) throws Exception {
        String tableDDL = "create table QUARTZ_TRIGGERS (TRIGGER_NAME varchar(80) not null, TRIGGER_GROUP varchar(80) not null, JOB_NAME varchar(80) not null, JOB_GROUP varchar(80) not null, IS_VOLATILE smallint, DESCRIPTION varchar(120), NEXT_FIRE_TIME bigint, PREV_FIRE_TIME bigint,  PRIORITY integer, TRIGGER_STATE varchar(16) not null, TRIGGER_TYPE varchar(8), START_TIME bigint, END_TIME bigint, CALENDAR_NAME varchar(80), MISFIRE_INSTR integer, JOB_DATA blob, primary key(TRIGGER_NAME, TRIGGER_GROUP))";
        Statement stmt = conn.createStatement();
        stmt.execute("create table QUARTZ_TRIGGERS (TRIGGER_NAME varchar(80) not null, TRIGGER_GROUP varchar(80) not null, JOB_NAME varchar(80) not null, JOB_GROUP varchar(80) not null, IS_VOLATILE smallint, DESCRIPTION varchar(120), NEXT_FIRE_TIME bigint, PREV_FIRE_TIME bigint,  PRIORITY integer, TRIGGER_STATE varchar(16) not null, TRIGGER_TYPE varchar(8), START_TIME bigint, END_TIME bigint, CALENDAR_NAME varchar(80), MISFIRE_INSTR integer, JOB_DATA blob, primary key(TRIGGER_NAME, TRIGGER_GROUP))");
        byte[] jobData = new byte[10000000];
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        stmt.execute("drop table QUARTZ_TRIGGERS");
        stmt.execute("create table QUARTZ_TRIGGERS (TRIGGER_NAME varchar(80) not null, TRIGGER_GROUP varchar(80) not null, JOB_NAME varchar(80) not null, JOB_GROUP varchar(80) not null, IS_VOLATILE smallint, DESCRIPTION varchar(120), NEXT_FIRE_TIME bigint, PREV_FIRE_TIME bigint,  PRIORITY integer, TRIGGER_STATE varchar(16) not null, TRIGGER_TYPE varchar(8), START_TIME bigint, END_TIME bigint, CALENDAR_NAME varchar(80), MISFIRE_INSTR integer, JOB_DATA blob, primary key(TRIGGER_NAME, TRIGGER_GROUP)) partition by primary key redundancy 1");
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        stmt.execute("drop table QUARTZ_TRIGGERS");
        stmt.execute("create table QUARTZ_TRIGGERS (TRIGGER_NAME varchar(80) not null, TRIGGER_GROUP varchar(80) not null, JOB_NAME varchar(80) not null, JOB_GROUP varchar(80) not null, IS_VOLATILE smallint, DESCRIPTION varchar(120), NEXT_FIRE_TIME bigint, PREV_FIRE_TIME bigint,  PRIORITY integer, TRIGGER_STATE varchar(16) not null, TRIGGER_TYPE varchar(8), START_TIME bigint, END_TIME bigint, CALENDAR_NAME varchar(80), MISFIRE_INSTR integer, JOB_DATA blob, primary key(TRIGGER_NAME, TRIGGER_GROUP)) partition by column (JOB_NAME) redundancy 1");
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        stmt.execute("drop table QUARTZ_TRIGGERS");
        stmt.execute("create table QUARTZ_TRIGGERS (TRIGGER_NAME varchar(80) not null, TRIGGER_GROUP varchar(80) not null, JOB_NAME varchar(80) not null, JOB_GROUP varchar(80) not null, IS_VOLATILE smallint, DESCRIPTION varchar(120), NEXT_FIRE_TIME bigint, PREV_FIRE_TIME bigint,  PRIORITY integer, TRIGGER_STATE varchar(16) not null, TRIGGER_TYPE varchar(8), START_TIME bigint, END_TIME bigint, CALENDAR_NAME varchar(80), MISFIRE_INSTR integer, JOB_DATA blob, primary key(TRIGGER_NAME, TRIGGER_GROUP))");
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
        stmt.execute("drop table QUARTZ_TRIGGERS");
        stmt.execute("create table QUARTZ_TRIGGERS (TRIGGER_NAME varchar(80) not null, TRIGGER_GROUP varchar(80) not null, JOB_NAME varchar(80) not null, JOB_GROUP varchar(80) not null, IS_VOLATILE smallint, DESCRIPTION varchar(120), NEXT_FIRE_TIME bigint, PREV_FIRE_TIME bigint,  PRIORITY integer, TRIGGER_STATE varchar(16) not null, TRIGGER_TYPE varchar(8), START_TIME bigint, END_TIME bigint, CALENDAR_NAME varchar(80), MISFIRE_INSTR integer, JOB_DATA blob, primary key(TRIGGER_NAME, TRIGGER_GROUP)) partition by primary key redundancy 1");
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
        stmt.execute("drop table QUARTZ_TRIGGERS");
        stmt.execute("create table QUARTZ_TRIGGERS (TRIGGER_NAME varchar(80) not null, TRIGGER_GROUP varchar(80) not null, JOB_NAME varchar(80) not null, JOB_GROUP varchar(80) not null, IS_VOLATILE smallint, DESCRIPTION varchar(120), NEXT_FIRE_TIME bigint, PREV_FIRE_TIME bigint,  PRIORITY integer, TRIGGER_STATE varchar(16) not null, TRIGGER_TYPE varchar(8), START_TIME bigint, END_TIME bigint, CALENDAR_NAME varchar(80), MISFIRE_INSTR integer, JOB_DATA blob, primary key(TRIGGER_NAME, TRIGGER_GROUP)) partition by column (JOB_NAME) redundancy 1");
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
    }
}

