/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.perf;

import com.pivotal.gemfirexd.ByteCompareTest;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.services.cache.ConcurrentCache;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;

public final class StatementMatchingPerfDUnit
extends DistributedSQLTestBase {
    private static final int numcolumns = 1;
    private static final int rowsperthrd = 1000;
    private static final int numthrd = 8;
    private String[][] psInsertValueSet;
    private String[][] stmtInsertSet;
    private String[][] stmtSelectSet;
    private final long[] psTiming = new long[8];
    private final long[] stmtTiming = new long[8];
    private boolean enableRuntimeStats = false;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (this.psInsertValueSet == null) {
            this.psInsertValueSet = new String[8][1000];
            this.stmtInsertSet = new String[8][1000];
            this.stmtSelectSet = new String[8][1000];
        }
        String ins = new String("insert into statement_optimization_checker values ('");
        for (int t = 0; t < 8; ++t) {
            for (int v = 0; v < 1000; ++v) {
                String value;
                this.psInsertValueSet[t][v] = value = ByteCompareTest.getRandomAlphaNumericString(-1);
                StringBuilder sb = new StringBuilder(ins);
                sb.append(value).append("','");
                for (int i = 1; i > 0; --i) {
                    sb.append(value).append("','");
                }
                sb.append(value).append("')");
                this.stmtInsertSet[t][v] = sb.toString();
                this.stmtSelectSet[t][v] = "select * from statement_optimization_checker where ID = '" + value + "'";
            }
        }
    }

    public StatementMatchingPerfDUnit(String name) {
        super(name);
    }

    public void testDummy() {
    }

    public void PERF_testStatementOptimizationUsingPuts() throws Exception {
        this.startVMs(1, 4);
        TestUtil.getLogger().info((Object)"creating table .... ");
        StringBuilder sql = new StringBuilder("create table statement_optimization_checker( ID varchar(100) primary key, ");
        for (int i = 1; i > 0; --i) {
            sql.append("col").append(i);
            sql.append(" varchar(100),");
        }
        sql.append("colEnd varchar(100) ) partition by column (ID, colEnd) ");
        this.clientSQLExecute(1, sql.toString());
        this.profileInserts();
    }

    public void PERF_testStatementOptimizationUsingGets() throws Exception {
        this.startVMs(1, 4);
        TestUtil.getLogger().info((Object)"creating table .... ");
        StringBuilder sql = new StringBuilder("create table statement_optimization_checker( ID varchar(100) primary key, ");
        for (int i = 1; i > 0; --i) {
            sql.append("col").append(i);
            sql.append(" varchar(100),");
        }
        sql.append("colEnd varchar(100) ) partition by column (ID, colEnd) ");
        this.clientSQLExecute(1, sql.toString());
        boolean runTimeStatsState = this.enableRuntimeStats;
        this.enableRuntimeStats = false;
        for (int i = 7; i >= 0; --i) {
            this.insertDataUsingPrepStmt(i, true);
        }
        this.enableRuntimeStats = runTimeStatsState;
        this.profileSelects();
    }

    private void profileInserts() throws SQLException, InterruptedException {
        int inst;
        int inst2;
        int i;
        Statement stmt = TestUtil.getConnection().createStatement();
        TestUtil.getLogger().info((Object)"Warming up with preparedstatement inserts");
        for (i = 7; i >= 0; --i) {
            this.insertDataUsingPrepStmt(i, false);
        }
        stmt.execute("delete from statement_optimization_checker");
        TestUtil.getLogger().info((Object)"Warming up with statement inserts");
        for (i = 7; i > 0; --i) {
            this.insertDataUsingStmt(i);
        }
        stmt.execute("delete from statement_optimization_checker");
        TestUtil.getLogger().info((Object)"Warmup done");
        Thread[] inserts = new Thread[8];
        for (inst2 = 0; inst2 < inserts.length; ++inst2) {
            inserts[inst2] = this.createPreparedStatementInsertThreads(inst2);
        }
        for (inst2 = 0; inst2 < inserts.length; ++inst2) {
            inserts[inst2].start();
        }
        for (inst2 = 0; inst2 < inserts.length; ++inst2) {
            if (!inserts[inst2].isAlive()) continue;
            inserts[inst2].join();
        }
        TestUtil.getLogger().info((Object)"PreparedStatement activities done");
        ResultSet rs = stmt.executeQuery("select count(1) from statement_optimization_checker");
        StatementMatchingPerfDUnit.assertTrue((String)"one row is expected ", (boolean)rs.next());
        TestUtil.getLogger().info((Object)("Got " + rs.getInt(1) + " number of rows "));
        StatementMatchingPerfDUnit.assertTrue((String)"expected 8000 rows ", (rs.getInt(1) == 8000 ? 1 : 0) != 0);
        rs.next();
        rs.close();
        stmt.execute("delete from statement_optimization_checker");
        Thread.sleep(1000L);
        TestUtil.getLogger().info((Object)"Resuming now with statements ...  ");
        inserts = new Thread[8];
        for (inst = 0; inst < inserts.length; ++inst) {
            inserts[inst] = this.createStatementInsertThreads(inst);
        }
        for (inst = 0; inst < inserts.length; ++inst) {
            inserts[inst].start();
        }
        for (inst = 0; inst < inserts.length; ++inst) {
            if (!inserts[inst].isAlive()) continue;
            TestUtil.getLogger().info((Object)("About to wait for " + inserts[inst] + " to join.... "));
            inserts[inst].join();
        }
        rs = stmt.executeQuery("select count(1) from statement_optimization_checker");
        StatementMatchingPerfDUnit.assertTrue((String)"one row is expected ", (boolean)rs.next());
        TestUtil.getLogger().info((Object)("Got " + rs.getInt(1) + " number of rows "));
        StatementMatchingPerfDUnit.assertTrue((String)"expected 8000 rows ", (rs.getInt(1) == 8000 ? 1 : 0) != 0);
        rs.next();
        rs.close();
        long totalPSTiming = 0L;
        for (long l : this.psTiming) {
            totalPSTiming += l;
        }
        long totalStmtTiming = 0L;
        for (long l : this.stmtTiming) {
            totalStmtTiming += l;
        }
        TestUtil.getLogger().info((Object)("INSERTs Avg PS Timing " + totalPSTiming / 8L + " Avg Stmt timing " + totalStmtTiming / 8L + " with Total Threads " + 8));
    }

    private void profileSelects() throws SQLException, InterruptedException {
        int inst;
        int i;
        boolean runTimeStatsState = this.enableRuntimeStats;
        this.enableRuntimeStats = false;
        Connection conn = TestUtil.getConnection();
        ConcurrentHashMap cache = ((ConcurrentCache)((EmbedConnection)conn).getLanguageConnection().getLanguageConnectionFactory().getStatementCache()).getCache();
        TestUtil.getLogger().info((Object)("Statement Cache Size BEGIN : " + cache.size()));
        TestUtil.getLogger().info((Object)"Warming up with preparedstatement selects");
        Statement stmt = conn.createStatement();
        for (i = 7; i >= 0; --i) {
            this.selectDataUsingPrepStmt(i);
        }
        this.enableRuntimeStats = runTimeStatsState;
        TestUtil.getLogger().info((Object)"Warming up with statement selects");
        for (i = 1; i <= 1000; ++i) {
            String str = this.stmtSelectSet[0][0];
            String value = this.psInsertValueSet[0][0];
            try {
                ResultSet rs = stmt.executeQuery(str);
                StatementMatchingPerfDUnit.assertTrue((String)"atleast 1 row is expected ", (boolean)rs.next());
                StatementMatchingPerfDUnit.assertTrue((String)("Value expected " + value + " got " + rs.getString(1)), (boolean)rs.getString(1).equals(value));
                rs.close();
                if (i % 1000 != 0) continue;
                TestUtil.getLogger().info((Object)("Selected " + i + " times for warm up"));
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                TestUtil.getLogger().error((Object)("Error " + e));
            }
        }
        TestUtil.getLogger().info((Object)"Warmup done");
        this.enableRuntimeStats = false;
        TestUtil.getLogger().info((Object)("Statement Cache Size After Warmup done : " + cache.size()));
        Thread[] selects = new Thread[8];
        for (inst = 0; inst < selects.length; ++inst) {
            selects[inst] = this.createPreparedStatementSelectThreads(inst);
        }
        for (inst = 0; inst < selects.length; ++inst) {
            selects[inst].start();
        }
        for (inst = 0; inst < selects.length; ++inst) {
            if (!selects[inst].isAlive()) continue;
            selects[inst].join();
        }
        TestUtil.getLogger().info((Object)"Select PreparedStatement activities done");
        TestUtil.getLogger().info((Object)("Statement Cache Size After PreparedStmt done : " + cache.size()));
        Thread.sleep(1000L);
        TestUtil.getLogger().info((Object)"sb: Waiting for 30 secs to attach profiler.... ");
        Thread.sleep(30000L);
        TestUtil.getLogger().info((Object)"Select Statement activities begin");
        this.enableRuntimeStats = runTimeStatsState;
        selects = new Thread[8];
        for (inst = 0; inst < selects.length; ++inst) {
            selects[inst] = this.createStatementSelectThreads(inst);
        }
        for (inst = 0; inst < selects.length; ++inst) {
            selects[inst].start();
        }
        for (inst = 0; inst < selects.length; ++inst) {
            if (!selects[inst].isAlive()) continue;
            selects[inst].join();
        }
        TestUtil.getLogger().info((Object)"Select Statement activities done");
        TestUtil.getLogger().info((Object)("Statement Cache Size After Statement done : " + cache.size()));
        long totalPSTiming = 0L;
        for (long l : this.psTiming) {
            totalPSTiming += l;
        }
        long totalStmtTiming = 0L;
        for (long l : this.stmtTiming) {
            totalStmtTiming += l;
        }
        TestUtil.getLogger().info((Object)("SELECTs Avg PS Timing " + totalPSTiming / 8L + " Avg Stmt timing " + totalStmtTiming / 8L + " with Total Threads " + 8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertDataUsingPrepStmt(int tid, boolean useBatchMode) {
        try {
            StringBuilder prepstmt = new StringBuilder("insert into statement_optimization_checker values (?,");
            for (int i = 1; i > 0; --i) {
                prepstmt.append("?,");
            }
            prepstmt.append("?)");
            Connection conn = TestUtil.getConnection();
            PreparedStatement pstmt = conn.prepareStatement("values SYSCS_UTIL.GET_RUNTIMESTATISTICS()");
            this.enableStatistics(conn);
            PreparedStatement insps = conn.prepareStatement(prepstmt.toString());
            long beginTime = System.currentTimeMillis();
            for (int i = 1; i <= 1000; ++i) {
                String value = this.psInsertValueSet[tid][i - 1];
                try {
                    insps.setString(1, value);
                    insps.setString(2, value);
                    insps.setString(3, value);
                    if (useBatchMode) {
                        insps.addBatch();
                        if (i % 1000 == 0 || i % 1000 == 0) {
                            insps.executeBatch();
                            insps.clearBatch();
                            conn.commit();
                        }
                    } else {
                        insps.executeUpdate();
                    }
                    if (i % 1000 == 0 || i % 1000 == 0) {
                        TestUtil.getLogger().info((Object)("Inserted uptil " + i));
                    }
                    if (!this.enableRuntimeStats) continue;
                    String stat = this.getStats(pstmt);
                    TestUtil.getLogger().info((Object)("ps_stat:" + prepstmt + "(" + value + ") ->>" + stat));
                    continue;
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            long timetaken = System.currentTimeMillis() - beginTime;
            TestUtil.getLogger().info((Object)("PREPSTMT Thread " + Thread.currentThread() + " took " + timetaken + " ms "));
            this.psTiming[tid] = timetaken;
        }
        catch (SQLException e) {
            e.printStackTrace();
            TestUtil.getLogger().error((Object)("Error " + e));
            return;
        }
        finally {
            TestUtil.getLogger().info((Object)("Done " + Thread.currentThread().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertDataUsingStmt(int tid) {
        try {
            Connection conn = TestUtil.getConnection();
            PreparedStatement pstmt = conn.prepareStatement("values SYSCS_UTIL.GET_RUNTIMESTATISTICS()");
            Statement stmt = conn.createStatement();
            this.enableStatistics(conn);
            long beginTime = System.currentTimeMillis();
            for (int i = 1; i <= 1000; ++i) {
                String str = this.stmtInsertSet[tid][i - 1];
                try {
                    stmt.executeUpdate(str);
                    if (i % 1000 == 0) {
                        TestUtil.getLogger().info((Object)("Inserted uptil " + i));
                    }
                    if (!this.enableRuntimeStats) continue;
                    String stat = this.getStats(pstmt);
                    TestUtil.getLogger().info((Object)("stmt_stat:" + str + "->>" + stat));
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    TestUtil.getLogger().error((Object)("Error " + e));
                }
            }
            long timetaken = System.currentTimeMillis() - beginTime;
            TestUtil.getLogger().info((Object)("STMT Thread " + Thread.currentThread() + " took " + timetaken + " ms "));
            this.stmtTiming[tid] = timetaken;
        }
        catch (SQLException e) {
            e.printStackTrace();
            TestUtil.getLogger().error((Object)("Error " + e));
            return;
        }
        finally {
            TestUtil.getLogger().info((Object)("Done " + Thread.currentThread().getName()));
        }
    }

    private Thread createPreparedStatementInsertThreads(final int tid) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                StatementMatchingPerfDUnit.this.insertDataUsingPrepStmt(tid, false);
            }
        }, "INSERT_PS_T" + tid);
        return t;
    }

    private Thread createStatementInsertThreads(final int tid) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                StatementMatchingPerfDUnit.this.insertDataUsingStmt(tid);
            }
        }, "INSERT_STMT_T" + tid);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectDataUsingPrepStmt(int tid) {
        try {
            String prepstmt = new String("select * from statement_optimization_checker where ID = ?");
            Connection conn = TestUtil.getConnection();
            PreparedStatement pstmt = conn.prepareStatement("values SYSCS_UTIL.GET_RUNTIMESTATISTICS()");
            this.enableStatistics(conn);
            PreparedStatement insps = conn.prepareStatement(prepstmt);
            long beginTime = System.currentTimeMillis();
            for (int i = 1; i <= 1000; ++i) {
                String value = this.psInsertValueSet[tid][i - 1];
                ResultSet rs = null;
                try {
                    insps.setString(1, value);
                    rs = insps.executeQuery();
                    StatementMatchingPerfDUnit.assertTrue((String)"atleast 1 row is expected ", (boolean)rs.next());
                    StatementMatchingPerfDUnit.assertEquals((String)value, (String)rs.getString(1));
                    rs.close();
                    rs = null;
                    if (i % 1000 == 0) {
                        TestUtil.getLogger().info((Object)("Selects uptil " + i));
                    }
                    if (!this.enableRuntimeStats) continue;
                    String stat = this.getStats(pstmt);
                    TestUtil.getLogger().info((Object)("select_ps_stat:" + prepstmt + "->>" + stat));
                    continue;
                }
                catch (SQLException e) {
                    if (rs != null) {
                        rs.close();
                    }
                    e.printStackTrace();
                    TestUtil.getLogger().error((Object)("Error " + e));
                }
            }
            long timetaken = System.currentTimeMillis() - beginTime;
            TestUtil.getLogger().info((Object)("PREPSTMT Thread " + Thread.currentThread() + " took " + timetaken + " ms "));
            this.psTiming[tid] = timetaken;
        }
        catch (Throwable e) {
            e.printStackTrace();
            TestUtil.getLogger().error((Object)("Error " + e));
            return;
        }
        finally {
            TestUtil.getLogger().info((Object)("Done " + Thread.currentThread().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectDataUsingStmt(int tid) {
        try {
            Connection conn = TestUtil.getConnection();
            PreparedStatement pstmt = conn.prepareStatement("values SYSCS_UTIL.GET_RUNTIMESTATISTICS()");
            Statement stmt = conn.createStatement();
            this.enableStatistics(conn);
            long beginTime = System.currentTimeMillis();
            for (int i = 1; i <= 1000; ++i) {
                String str = this.stmtSelectSet[tid][i - 1];
                String value = this.psInsertValueSet[tid][i - 1];
                try {
                    ResultSet rs = stmt.executeQuery(str);
                    StatementMatchingPerfDUnit.assertTrue((String)"atleast 1 row is expected ", (boolean)rs.next());
                    StatementMatchingPerfDUnit.assertEquals((String)value, (String)rs.getString(1));
                    rs.close();
                    if (i % 1000 == 0) {
                        TestUtil.getLogger().info((Object)("Selects uptil " + i));
                    }
                    if (!this.enableRuntimeStats) continue;
                    String stat = this.getStats(pstmt);
                    TestUtil.getLogger().info((Object)("select_stmt_stat:" + str + "->>" + stat));
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    TestUtil.getLogger().error((Object)("Error " + e));
                }
            }
            long timetaken = System.currentTimeMillis() - beginTime;
            TestUtil.getLogger().info((Object)("STMT Thread " + Thread.currentThread() + " took " + timetaken + " ms "));
            this.stmtTiming[tid] = timetaken;
        }
        catch (Throwable e) {
            e.printStackTrace();
            TestUtil.getLogger().error((Object)("Error " + e));
            return;
        }
        finally {
            TestUtil.getLogger().info((Object)("Done " + Thread.currentThread().getName()));
        }
    }

    private Thread createPreparedStatementSelectThreads(final int tid) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                StatementMatchingPerfDUnit.this.selectDataUsingPrepStmt(tid);
            }
        }, "SELECT_PS_T" + tid);
        return t;
    }

    private Thread createStatementSelectThreads(final int tid) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                StatementMatchingPerfDUnit.this.selectDataUsingStmt(tid);
            }
        }, "SELECT_STMT_T" + tid);
        return t;
    }

    private void enableStatistics(Connection conn) throws SQLException {
        if (!this.enableRuntimeStats) {
            return;
        }
        conn.prepareCall("call SYSCS_UTIL.SET_RUNTIMESTATISTICS(1)").execute();
        conn.prepareCall("call SYSCS_UTIL.SET_STATISTICS_TIMING(1)").execute();
    }

    private String getStats(PreparedStatement ps) throws SQLException {
        if (!this.enableRuntimeStats) {
            return "";
        }
        ResultSet rs = ps.executeQuery();
        rs.next();
        String rts = rs.getString(1);
        rs.close();
        return rts;
    }
}

