/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.perf;

import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import io.snappydata.test.dunit.VM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;

public class SelectsToGetPerfDUnit
extends DistributedSQLTestBase {
    public SelectsToGetPerfDUnit(String name) {
        super(name);
    }

    public void testDummy() {
    }

    public void PERF_testPrimayKeyGets() throws Exception {
        this.startVMs(1, 2);
        int totalRows = 20;
        ((VM)this.serverVMs.get(0)).invoke(SelectsToGetPerfDUnit.class, "prepareTableWithOneKey", new Object[]{new Integer(totalRows)});
        ((VM)this.serverVMs.get(1)).invoke(SelectsToGetPerfDUnit.class, "prepareTableWithTwoKey", new Object[]{new Integer(totalRows)});
        Random rand = new Random(System.currentTimeMillis());
        Object[][][] queries = new Object[][][]{{{TestUtil.jdbcConn.prepareStatement("select * from Account where id = ?")}, {new Integer(4)}}, {{TestUtil.jdbcConn.prepareStatement("select * from finOrder where id = ? and account = ?")}, {new Integer(4)}, {new Integer(12), new Integer(1), "Account "}}, {{TestUtil.jdbcConn.prepareStatement("select * from finOrder where account = ? and id = ?")}, {new Integer(12), new Integer(1), "Account "}, {new Integer(4)}}};
        int qps = 0;
        int totqry = queries.length;
        long startQ = System.currentTimeMillis();
        long stopQ = System.currentTimeMillis();
        long samplingTimes = 100L;
        for (int iterations = 1; iterations <= 5; ++iterations) {
            startQ = System.currentTimeMillis();
            int j = 1;
            while ((long)j <= samplingTimes) {
                int pkey = rand.nextInt(totalRows) + 1;
                ResultSet rs = null;
                int qryRow = rand.nextInt(totqry);
                PreparedStatement ps = (PreparedStatement)queries[qryRow][0][0];
                block5: for (int prm_1 = 1; prm_1 < queries[qryRow].length; ++prm_1) {
                    int paramType = (Integer)queries[qryRow][prm_1][0];
                    switch (paramType) {
                        case 12: {
                            if ((Integer)queries[qryRow][prm_1][1] != 1) continue block5;
                            ps.setObject(prm_1, (Object)(String.valueOf(queries[qryRow][prm_1][2]) + String.valueOf(pkey)), 12);
                            continue block5;
                        }
                        default: {
                            ps.setObject(prm_1, (Object)new Integer(pkey), (Integer)queries[qryRow][prm_1][0]);
                        }
                    }
                }
                rs = ps.executeQuery();
                SelectsToGetPerfDUnit.assertTrue((rs != null ? 1 : 0) != 0);
                rs.next();
                SelectsToGetPerfDUnit.assertEquals((String)rs.getObject("id").toString(), (String)String.valueOf(pkey));
                SelectsToGetPerfDUnit.assertTrue((!rs.next() ? 1 : 0) != 0);
                rs.close();
                ++j;
            }
            stopQ = System.currentTimeMillis();
            if (iterations <= 4 || (stopQ - startQ) / 1000L <= 0L || (qps = (int)(samplingTimes / ((stopQ - startQ) / 1000L))) >= 5000) continue;
            SelectsToGetPerfDUnit.getGlobalLogger().warn((Object)(" [Get query/sec dropped to ] " + String.valueOf(qps)));
        }
    }

    public static void prepareTableWithOneKey(int rows) throws SQLException {
        Statement s = TestUtil.jdbcConn.createStatement();
        SelectsToGetPerfDUnit.getGlobalLogger().info((Object)" creating tables ");
        s.execute("create table Account ( id varchar(10) primary key, name varchar(100), type int )");
        TestUtil.jdbcConn.commit();
        SelectsToGetPerfDUnit.getGlobalLogger().info((Object)" populating values ");
        PreparedStatement ps = TestUtil.jdbcConn.prepareStatement("insert into Account values(?,?,?)");
        while (rows > 0) {
            ps.setString(1, String.valueOf(rows));
            ps.setString(2, "Dummy Account " + String.valueOf(rows));
            ps.setInt(3, rows % 2);
            ps.executeUpdate();
            --rows;
        }
    }

    public static void prepareTableWithTwoKey(int rows) throws SQLException {
        Statement s = TestUtil.jdbcConn.createStatement();
        s.execute("create table finOrder ( id bigint, name varchar(100), type int, account varchar(100),  constraint order_pk primary key(account, id ) )");
        TestUtil.jdbcConn.commit();
        SelectsToGetPerfDUnit.getGlobalLogger().info((Object)" populating values ");
        PreparedStatement ps = TestUtil.jdbcConn.prepareStatement("insert into finOrder values(?,?,?,?)");
        while (rows > 0) {
            ps.setLong(1, rows);
            ps.setString(2, "Dummy Order " + String.valueOf(rows));
            ps.setInt(3, rows % 4);
            ps.setString(4, "Account " + String.valueOf(rows));
            ps.executeUpdate();
            --rows;
        }
    }
}

