/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.perf;

import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gnu.trove.TIntIntHashMap;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import org.apache.log4j.Logger;

public class PerfTicketDUnit
extends DistributedSQLTestBase {
    int netPort;
    private volatile boolean allInsertsDone = false;
    private final Random random = new Random();

    public PerfTicketDUnit(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testDummy() {
    }

    public void __testBug44550() throws Exception {
        Properties props = new Properties();
        props.setProperty("log-level", "config");
        System.setProperty("gemfire.statsDisabled", "true");
        this.startVMs(1, 1, 0, null, props);
        this.netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(this.netPort, null, null);
        Statement stmt = conn.createStatement();
        stmt.execute("create table customer (c_w_id         integer        not null,c_d_id         integer        not null,c_id           integer        not null,c_discount     decimal(4,4),c_credit       char(2),c_last         varchar(16),c_first        varchar(16),c_credit_lim   decimal(12,2),c_balance      decimal(12,2),c_ytd_payment  float,c_payment_cnt  integer,c_delivery_cnt integer,c_street_1     varchar(20),c_street_2     varchar(20),c_city         varchar(20),c_state        char(2),c_zip          char(9),c_phone        char(16),c_since        timestamp,c_middle       char(2),c_data         varchar(500)) partition by (c_w_id) redundancy 1");
        stmt.execute("create table new_order (no_w_id  integer   not null,no_d_id  integer   not null,no_o_id  integer   not null) partition by (no_w_id) colocate with (customer) redundancy 1");
        stmt.execute("alter table customer add constraint pk_customer primary key (c_w_id, c_d_id, c_id)");
        stmt.execute("create index ndx_customer_name on customer (c_w_id, c_d_id, c_last)");
        stmt.execute("alter table new_order add constraint pk_new_order primary key (no_w_id, no_d_id, no_o_id)");
        stmt.execute("create index ndx_neworder_w_id_d_id on new_order (no_w_id, no_d_id)");
        stmt.execute("create index ndx_neworder_w_id_d_id_o_id on new_order (no_w_id, no_d_id, no_o_id)");
        conn.setTransactionIsolation(2);
        int numRows = 10000;
        PreparedStatement pstmt = conn.prepareStatement("insert into new_order values (?, ?, ?)");
        for (int id = 1; id <= 10000; ++id) {
            pstmt.setInt(1, id % 98);
            pstmt.setInt(2, id % 98);
            pstmt.setInt(3, id);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        conn.commit();
        pstmt = conn.prepareStatement("SELECT no_o_id FROM new_order WHERE no_d_id = ? AND no_w_id = ? ORDER BY no_o_id ASC");
        int numRuns = 50000;
        for (int i = 1; i <= 50000; ++i) {
            pstmt.setInt(1, i % 98);
            pstmt.setInt(2, i % 98);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                rs.getInt(1);
            }
        }
        conn.commit();
        this.getLogWriter().info((Object)"Starting sleep...");
        Thread.sleep(60000L);
        this.getLogWriter().info((Object)"Waking up.");
        conn = TestUtil.getNetConnection(this.netPort, null, null);
        pstmt = conn.prepareStatement("SELECT no_o_id FROM new_order WHERE no_d_id = ? AND no_w_id = ? ORDER BY no_o_id ASC");
        long start = System.nanoTime();
        for (int i = 1; i <= 50000; ++i) {
            pstmt.setInt(1, i % 98);
            pstmt.setInt(2, i % 98);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                rs.getInt(1);
            }
        }
        long end = System.nanoTime();
        this.getLogWriter().info((Object)("Time taken: " + (end - start) + "ns"));
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __testBug41443Or41444Or41445() throws Exception {
        this.netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(this.netPort, null, null);
        try {
            int i;
            Statement s = conn.createStatement();
            s.execute("Create Table TEST_TABLE(idx numeric(12),AccountID varchar(10),OrderNo varchar(20),primary key(idx))PARTITION BY COLUMN ( AccountID ) REDUNDANCY 1");
            s.execute("CREATE INDEX idx_AccountID ON test_Table (AccountID ASC)");
            Thread[] execs = new Thread[400];
            int mid = execs.length / 2 + 1;
            for (i = 1; i < mid; ++i) {
                execs[i - 1] = this.createInsertThreadAndExecute(i);
            }
            for (i = 1; i < mid; ++i) {
                execs[i + (mid - 2)] = this.createSelectThreadAndExecute(i);
            }
            for (i = 1; i < mid; ++i) {
                TestUtil.getLogger().info((Object)("waiting for " + execs[i - 1].getName()));
                execs[i - 1].join();
            }
            this.allInsertsDone = true;
            for (i = 1; i < mid; ++i) {
                TestUtil.getLogger().info((Object)("waiting for " + execs[i + (mid - 2)].getName()));
                execs[i + (mid - 2)].join();
            }
        }
        finally {
            this.stopNetworkServer(1);
        }
    }

    private Thread createSelectThreadAndExecute(final int tid) {
        Thread t = new Thread(new Runnable(){
            private int maxRowsFetched = 0;
            private int totalRuns = 0;
            private int successRuns = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Connection conn = TestUtil.getNetConnection(PerfTicketDUnit.this.netPort, null, null);
                    PreparedStatement selps = conn.prepareStatement("select * from test_table where accountid=?");
                    while (!PerfTicketDUnit.this.allInsertsDone) {
                        selps.setString(1, String.valueOf(tid - 1));
                        ResultSet rs = selps.executeQuery();
                        ++this.totalRuns;
                        int rows = 0;
                        while (rs.next()) {
                            ++rows;
                        }
                        if (rows == 0) {
                            TestUtil.getLogger().info((Object)("Got " + (tid - 1) + " rows=" + rows));
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        } else if (rows > this.maxRowsFetched) {
                            this.maxRowsFetched = rows;
                            ++this.successRuns;
                        } else {
                            ++this.successRuns;
                        }
                        if (this.successRuns % 1000 != 0) continue;
                        TestUtil.getLogger().info((Object)("1000 queries succeeded maxRows uptil now " + this.maxRowsFetched));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return;
                }
                finally {
                    TestUtil.getLogger().info((Object)("totalRuns=" + this.totalRuns + " successRuns=" + this.successRuns + " maxRowsFetched=" + this.maxRowsFetched + " Done " + Thread.currentThread().getName()));
                }
            }
        }, "SELECT_T" + tid);
        t.start();
        return t;
    }

    private Thread createInsertThreadAndExecute(final int tid) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Connection conn = TestUtil.getNetConnection(PerfTicketDUnit.this.netPort, null, null);
                    PreparedStatement insps = conn.prepareStatement("insert into test_table values(?,?,?)");
                    int base = tid * 10000;
                    for (int i = 0; i < 5000; ++i) {
                        insps.setInt(1, base + i);
                        insps.setString(2, String.valueOf(i % tid));
                        insps.setString(3, String.valueOf(i));
                        insps.executeUpdate();
                        if (i % 1000 != 0) continue;
                        TestUtil.getLogger().info((Object)("Inserted uptil " + i));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return;
                }
                finally {
                    TestUtil.getLogger().info((Object)("Done " + Thread.currentThread().getName()));
                }
            }
        }, "INSERT_T" + tid);
        t.start();
        return t;
    }

    public void __testuseCase4_1server() throws Exception {
        this.getLogWriter().info((Object)"Testing with 1 server ............");
        InetAddress localHost = SocketCreator.getLocalHost();
        Properties locProps = new Properties();
        this.setCommonTestProperties(locProps);
        this.setCommonProperties(locProps, 0, null, null);
        locProps.remove("locators");
        this.netPort = AvailablePort.getRandomAvailablePort((int)0);
        int locPort = TestUtil.startLocator(localHost.getHostAddress(), this.netPort, locProps);
        Properties serverProps = new Properties();
        serverProps.setProperty("locators", localHost.getHostName() + '[' + locPort + ']');
        this.setCommonTestProperties(serverProps);
        this.startServerVMs(1, 0, null, serverProps);
        this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(this.netPort, null, null);
        this.profileuseCase4Queries(conn);
        conn.close();
        this.getLogWriter().info((Object)"Done with 1 server ............");
    }

    public void __testuseCase4_2peerServer() throws Exception {
        this.getLogWriter().info((Object)"Testing with peer connection with 2 server ............");
        Properties props = new Properties();
        this.setCommonTestProperties(props);
        this.startVMs(1, 2, 0, null, props);
        Connection conn = TestUtil.getConnection();
        this.profileuseCase4Queries(conn);
        conn.close();
        this.getLogWriter().info((Object)"Done with peer with 2 server evaluation ............");
    }

    public void __testuseCase4_3peerServer() throws Exception {
        this.getLogWriter().info((Object)"Testing with peer connection with 3 server ............");
        Properties props = new Properties();
        this.setCommonTestProperties(props);
        this.startVMs(1, 3, 0, null, props);
        Connection conn = TestUtil.getConnection();
        Thread.sleep(2000L);
        this.profileuseCase4Queries(conn);
        conn.close();
        this.getLogWriter().info((Object)"Done with peer with 3 server evaluation ............");
    }

    public void __testuseCase4_4peerServer() throws Exception {
        this.getLogWriter().info((Object)"Testing with peer connection with 4 server ............");
        Properties props = new Properties();
        this.setCommonTestProperties(props);
        this.startVMs(1, 4, 0, null, props);
        Connection conn = TestUtil.getConnection();
        Thread.sleep(2000L);
        this.profileuseCase4Queries(conn);
        conn.close();
        this.getLogWriter().info((Object)"Done with peer with 4 server evaluation ............");
    }

    public void __testuseCase4_2networkServer() throws Exception {
        this.getLogWriter().info((Object)"Testing with 2 n/w server ............");
        InetAddress localHost = SocketCreator.getLocalHost();
        Properties locProps = new Properties();
        this.setCommonTestProperties(locProps);
        this.setCommonProperties(locProps, 0, null, null);
        locProps.remove("locators");
        this.netPort = AvailablePort.getRandomAvailablePort((int)0);
        int locPort = TestUtil.startLocator(localHost.getHostAddress(), this.netPort, locProps);
        Properties serverProps = new Properties();
        serverProps.setProperty("locators", localHost.getHostName() + '[' + locPort + ']');
        this.setCommonTestProperties(serverProps);
        this.startServerVMs(2, 0, null, serverProps);
        this.startNetworkServer(2, null, null);
        this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(this.netPort, null, null);
        this.profileuseCase4Queries(conn);
        conn.close();
        this.getLogWriter().info((Object)"Done with 2 n/w server ............");
    }

    public void __testuseCase4_3networkServer() throws Exception {
        this.getLogWriter().info((Object)"Testing with 3 n/w server ............");
        InetAddress localHost = SocketCreator.getLocalHost();
        Properties locProps = new Properties();
        this.setCommonTestProperties(locProps);
        this.setCommonProperties(locProps, 0, null, null);
        locProps.remove("locators");
        this.netPort = AvailablePort.getRandomAvailablePort((int)0);
        int locPort = TestUtil.startLocator(localHost.getHostAddress(), this.netPort, locProps);
        Properties serverProps = new Properties();
        serverProps.setProperty("locators", localHost.getHostName() + '[' + locPort + ']');
        this.setCommonTestProperties(serverProps);
        this.startServerVMs(3, 0, null, serverProps);
        this.startNetworkServer(3, null, null);
        this.startNetworkServer(2, null, null);
        this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.getNetConnection(this.netPort, null, null);
        Thread.sleep(2000L);
        this.profileuseCase4Queries(conn);
        conn.close();
        this.getLogWriter().info((Object)"Done with 3 n/w server ............");
    }

    public void __testBug46727() throws Exception {
        ResultSet rs;
        this.startVMs(1, 2);
        int netPort = this.startNetworkServer(1, null, null);
        Connection conn = TestUtil.jdbcConn;
        String scriptsDir = TestUtil.getResourcesDir() + "/lib/";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{scriptsDir + "rsa_schema.sql"}, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)false);
        this.getLogWriter().info((Object)"Loading data ...");
        conn.createStatement().execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'DEVICE', '" + scriptsDir + "rsa_data.dat', ',', NULL, NULL, 0, 0, 6, 0, NULL, NULL)");
        this.getLogWriter().info((Object)"Done data load.");
        Connection netConn = TestUtil.getNetConnection(netPort, null, null);
        PreparedStatement pstmt1 = netConn.prepareStatement("SELECT risk_rating, count(risk_rating) from app.device -- GEMFIREXD-PROPERTIES index=DEVICE_RISK_RATING\n group by risk_rating");
        PreparedStatement pstmt2 = netConn.prepareStatement("SELECT risk_rating, count(risk_rating) from app.device -- GEMFIREXD-PROPERTIES index=DEVICE_RISK_RATING\n group by risk_rating");
        PreparedStatement pstmt12 = conn.prepareStatement("SELECT risk_rating, count(risk_rating) from app.device -- GEMFIREXD-PROPERTIES index=DEVICE_RISK_RATING\n group by risk_rating");
        PreparedStatement pstmt22 = conn.prepareStatement("SELECT risk_rating, count(risk_rating) from app.device -- GEMFIREXD-PROPERTIES index=DEVICE_RISK_RATING\n group by risk_rating");
        TIntIntHashMap expectedResults = new TIntIntHashMap();
        TIntIntHashMap gotResults = new TIntIntHashMap();
        for (int i = 1; i <= 5; ++i) {
            int risk;
            rs = pstmt1.executeQuery();
            if (expectedResults.isEmpty()) {
                while (rs.next()) {
                    risk = rs.getInt(1);
                    if (expectedResults.containsKey(risk)) {
                        throw new RuntimeException("duplicate results for risk=" + risk);
                    }
                    expectedResults.put(risk, rs.getInt(2));
                }
            } else {
                while (rs.next()) {
                    risk = rs.getInt(1);
                    if (gotResults.containsKey(risk)) {
                        throw new RuntimeException("duplicate results for risk=" + risk);
                    }
                    gotResults.put(risk, rs.getInt(2));
                }
                PerfTicketDUnit.assertEquals((Object)expectedResults, (Object)gotResults);
                gotResults.clear();
            }
            rs = pstmt2.executeQuery();
            while (rs.next()) {
                risk = rs.getInt(1);
                if (gotResults.containsKey(risk)) {
                    throw new RuntimeException("duplicate results for risk=" + risk);
                }
                gotResults.put(risk, rs.getInt(2));
            }
            PerfTicketDUnit.assertEquals((Object)expectedResults, (Object)gotResults);
            gotResults.clear();
            rs = pstmt12.executeQuery();
            while (rs.next()) {
                risk = rs.getInt(1);
                if (gotResults.containsKey(risk)) {
                    throw new RuntimeException("duplicate results for risk=" + risk);
                }
                gotResults.put(risk, rs.getInt(2));
            }
            PerfTicketDUnit.assertEquals((Object)expectedResults, (Object)gotResults);
            gotResults.clear();
            rs = pstmt22.executeQuery();
            while (rs.next()) {
                risk = rs.getInt(1);
                if (gotResults.containsKey(risk)) {
                    throw new RuntimeException("duplicate results for risk=" + risk);
                }
                gotResults.put(risk, rs.getInt(2));
            }
            PerfTicketDUnit.assertEquals((Object)expectedResults, (Object)gotResults);
            gotResults.clear();
        }
        for (int i = 1; i <= 10; ++i) {
            int numResults = 0;
            long start = System.nanoTime();
            rs = pstmt1.executeQuery();
            while (rs.next()) {
                ++numResults;
            }
            long end = System.nanoTime();
            PerfTicketDUnit.assertEquals((int)expectedResults.size(), (int)numResults);
            this.getLogWriter().info((Object)("Time taken for pstmt1: " + (end - start) + "ns"));
            numResults = 0;
            start = System.nanoTime();
            rs = pstmt2.executeQuery();
            while (rs.next()) {
                ++numResults;
            }
            end = System.nanoTime();
            PerfTicketDUnit.assertEquals((int)expectedResults.size(), (int)numResults);
            this.getLogWriter().info((Object)("Time taken for pstmt2: " + (end - start) + "ns"));
            numResults = 0;
            start = System.nanoTime();
            rs = pstmt12.executeQuery();
            while (rs.next()) {
                ++numResults;
            }
            end = System.nanoTime();
            PerfTicketDUnit.assertEquals((int)expectedResults.size(), (int)numResults);
            this.getLogWriter().info((Object)("Time taken for pstmt12: " + (end - start) + "ns"));
            numResults = 0;
            start = System.nanoTime();
            rs = pstmt22.executeQuery();
            while (rs.next()) {
                ++numResults;
            }
            end = System.nanoTime();
            PerfTicketDUnit.assertEquals((int)expectedResults.size(), (int)numResults);
            this.getLogWriter().info((Object)("Time taken for pstmt22: " + (end - start) + "ns"));
        }
    }

    private void setCommonTestProperties(Properties props) {
        props.setProperty("table-default-partitioned", Boolean.toString(false));
        props.setProperty("log-level", "config");
        props.setProperty("conserve-sockets", "false");
    }

    private void profileuseCase4Queries(Connection conn) throws Exception {
        this.getLogWriter().info((Object)"About to create schema objects ");
        String useCase4Script = TestUtil.getResourcesDir() + "/lib/useCase4/schema.sql";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{useCase4Script}, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)false);
        this.getLogWriter().info((Object)"Schema creation done.. about to import data.");
        String baseImportPath = TestUtil.getResourcesDir() + "/lib/useCase4/";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{baseImportPath + "import-10k.sql"}, (boolean)false, (Logger)this.getLogWriter(), (String)"<path>", (String)TestUtil.getResourcesDir(), (boolean)true);
        this.getLogWriter().info((Object)"10k Data import done.. about to determine holding's no. of rows.");
        this.runQueries(conn);
        this.getLogWriter().info((Object)"About to zap all the data");
        String useCase4DropScript = TestUtil.getResourcesDir() + "/lib/useCase4/drop.sql";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{useCase4DropScript}, (boolean)false, (Logger)this.getLogWriter(), null, null, (boolean)true);
        this.getLogWriter().info((Object)"All artifacts dropped successfully. Waiting for couple of seconds .. ");
        this.getLogWriter().info((Object)"All artifacts dropped successfully. Waiting for couple of seconds .. ");
        Thread.sleep(2000L);
    }

    private void runQueries(Connection conn) throws Exception {
        ResultSet r = conn.createStatement().executeQuery("select count(*) from app.holding");
        r.next();
        int totalAccounts = r.getInt(1);
        r.close();
        int[] listOfAccounts = new int[totalAccounts];
        this.getLogWriter().info((Object)("Caching " + totalAccounts + " APP.HOLDING.ACCOUNT_ACCOUNTID information."));
        r = conn.createStatement().executeQuery("select distinct account_accountid from app.holding");
        for (int i = 0; i < listOfAccounts.length && r.next(); ++i) {
            listOfAccounts[i] = r.getInt(1);
        }
        r.close();
        ResultSet plan = conn.createStatement().executeQuery("explain SELECT h.quote_symbol, sum(q.price * h.quantity) - SUM(h.purchaseprice * h.quantity) as gain FROM app.Holding h, app.Quote q Where h.account_accountid = " + listOfAccounts[this.random.nextInt(totalAccounts - 1)] + " and h.quote_symbol=q.symbol " + "GROUP BY  h.quote_symbol HAVING  SUM(q.price * h.quantity) - SUM(h.purchaseprice * h.quantity) > 0 " + "ORDER BY gain desc");
        PerfTicketDUnit.assertTrue((boolean)plan.next());
        this.getLogWriter().info((Object)("Plan for holdingAgg:\n" + this.getPlanAsText(plan.getClob(1))));
        while (plan.next()) {
            this.getLogWriter().info((Object)this.getPlanAsText(plan.getClob(1)));
        }
        plan = conn.createStatement().executeQuery("explain SELECT SUM(h.purchaseprice * h.quantity) as purchaseBasis, sum(q.price * h.quantity) as marketValue, count(*) FROM app.Holding h, app.Quote q Where h.account_accountid =" + listOfAccounts[this.random.nextInt(totalAccounts - 1)] + " and h.quote_symbol=q.symbol " + "ORDER BY marketValue desc");
        PerfTicketDUnit.assertTrue((boolean)plan.next());
        this.getLogWriter().info((Object)("Plan for PortSummary:\n" + this.getPlanAsText(plan.getClob(1))));
        while (plan.next()) {
            this.getLogWriter().info((Object)this.getPlanAsText(plan.getClob(1)));
        }
        plan = conn.createStatement().executeQuery("explain SELECT SUM(q.price)/count(*) as tradeStockIndexAverage, SUM(q.open1)/count(*) as tradeStockIndexOpenAverage, SUM(q.volume) as tradeStockIndexVolume, COUNT(*) as cnt , SUM(q.change1) FROM app.Quote q");
        PerfTicketDUnit.assertTrue((boolean)plan.next());
        this.getLogWriter().info((Object)("Plan for mktSummary:\n" + this.getPlanAsText(plan.getClob(1))));
        while (plan.next()) {
            this.getLogWriter().info((Object)this.getPlanAsText(plan.getClob(1)));
        }
        ResultSet uptableRow = conn.createStatement().executeQuery("select orderid, account_accountid from app.orders where orderstatus = 'closed' ");
        int accId = -1;
        if (uptableRow.next()) {
            accId = uptableRow.getInt(2);
        }
        uptableRow.close();
        this.getLogWriter().info((Object)("Profiling update with account id " + accId));
        plan = conn.createStatement().executeQuery("explain UPDATE app.Orders o SET o.orderstatus = 'completed' WHERE o.account_accountid  = " + accId + " AND o.orderid " + "IN (SELECT o2.orderid FROM app.Orders o2 WHERE o2.orderstatus = 'closed' AND o2.account_accountid = " + accId + ")");
        PerfTicketDUnit.assertTrue((boolean)plan.next());
        this.getLogWriter().info((Object)("Plan for update orderstatus completed :\n" + this.getPlanAsText(plan.getClob(1))));
        while (plan.next()) {
            this.getLogWriter().info((Object)this.getPlanAsText(plan.getClob(1)));
        }
    }

    private void executeTxn(Connection conn, int[] listOfAccounts, int iterations, boolean profile) throws Exception {
        int totalAccounts = listOfAccounts.length;
        PreparedStatement psHoldingAgg = conn.prepareStatement("SELECT h.quote_symbol, sum(q.price * h.quantity) - SUM(h.purchaseprice * h.quantity) as gain FROM app.Holding h, app.Quote q Where h.account_accountid = ? and h.quote_symbol=q.symbol GROUP BY  h.quote_symbol HAVING  SUM(q.price * h.quantity) - SUM(h.purchaseprice * h.quantity) > 0 ORDER BY gain desc");
        PreparedStatement psPortSumm = conn.prepareStatement("SELECT SUM(h.purchaseprice * h.quantity) as purchaseBasis, sum(q.price * h.quantity) as marketValue, count(*) FROM app.Holding h, app.Quote q Where h.account_accountid =? and h.quote_symbol=q.symbol ORDER BY marketValue desc");
        PreparedStatement psMktSumm = conn.prepareStatement("SELECT SUM(q.price)/count(*) as tradeStockIndexAverage, SUM(q.open1)/count(*) as tradeStockIndexOpenAverage, SUM(q.volume) as tradeStockIndexVolume, COUNT(*) as cnt , SUM(q.change1) FROM app.Quote q");
        PreparedStatement psHoldingCount = conn.prepareStatement("SELECT count(*) FROM app.Holding h WHERE h.account_Accountid = ?");
        PreparedStatement psUptClosedOrder = conn.prepareStatement("UPDATE app.Orders o SET o.orderstatus = 'completed' WHERE o.account_accountid  = ? AND o.orderid IN (SELECT o2.orderid FROM app.Orders o2 WHERE o2.orderstatus = 'closed' AND o2.account_accountid = ?)");
        PreparedStatement psFindOrderByStatus = conn.prepareStatement("SELECT o.* FROM app.Orders o WHERE o.orderstatus = ? AND o.account_accountid = ? order by orderid DESC");
        PreparedStatement psFindOrderByAccAccId = conn.prepareStatement("SELECT o.* FROM app.Orders o WHERE o.account_accountid  = ? order by orderid DESC");
        PreparedStatement psFindOrderIdAndAccAccId = conn.prepareStatement("SELECT o.* FROM app.Orders o WHERE o.orderid = ? AND o.account_accountid  = ?");
        PreparedStatement psFindOrderCntAccAccId = conn.prepareStatement("SELECT count(*) FROM app.Orders o WHERE o.account_accountid  = ?");
        PreparedStatement psFindOrderCntAccAccIdAndStatus = conn.prepareStatement("SELECT count(*) FROM app.Orders o WHERE o.account_accountid  = ? and o.orderstatus = ?");
        int mktSummFreqMod = iterations;
        this.getLogWriter().info((Object)((profile ? "Profiling for " : "Warming up for ") + iterations + " iterations with every " + mktSummFreqMod + " iteration having market Summary Report. "));
        long totHoldingExecTime = 0L;
        long totMktSummExecTime = 0L;
        long totPortSummExecTime = 0L;
        long totHoldingCntExecTime = 0L;
        long totUptClosedOrderExecTime = 0L;
        long totFindOrderByStatusExecTime = 0L;
        long totFindOrderByAccAccIdExecTime = 0L;
        long totFindOrderIdAndAccAccIdExecTime = 0L;
        long totFindOrderCntAccAccIdExecTime = 0L;
        long totFindOrderCntAccAccIdAndStatusExecTime = 0L;
        int numFetchedHolding = 0;
        int numFetchedPortSumm = 0;
        int numTimesMktSummExecuted = 0;
        TIntIntHashMap orderIdAccId = new TIntIntHashMap();
        ResultSet r = conn.createStatement().executeQuery("select orderid, account_accountid from app.orders");
        while (r.next()) {
            orderIdAccId.put(r.getInt(1), r.getInt(2));
        }
        r.close();
        int[] listOfOrderIds = orderIdAccId.keys();
        int[] listOfOrderAccAccId = orderIdAccId.getValues();
        for (int idx = 0; idx < iterations; ++idx) {
            boolean mktSummExecuted = false;
            long beginProfile = System.nanoTime();
            int acc = listOfAccounts[this.random.nextInt(totalAccounts - 1)];
            psHoldingAgg.setInt(1, acc);
            ResultSet holdingAggRepo = psHoldingAgg.executeQuery();
            if (holdingAggRepo.next()) {
                ++numFetchedHolding;
                holdingAggRepo.getString(1);
                holdingAggRepo.getFloat(2);
            }
            while (holdingAggRepo.next()) {
                holdingAggRepo.getString(1);
                holdingAggRepo.getFloat(2);
            }
            long holdingExecDone = System.nanoTime();
            if (idx != 0 && (mktSummFreqMod == iterations || idx % mktSummFreqMod == 0)) {
                mktSummExecuted = true;
                ++numTimesMktSummExecuted;
                ResultSet mktSummRepo = psMktSumm.executeQuery();
                if (mktSummRepo.next()) {
                    mktSummRepo.getFloat(1);
                    mktSummRepo.getFloat(2);
                    mktSummRepo.getFloat(3);
                    mktSummRepo.getInt(4);
                    mktSummRepo.getFloat(5);
                }
                PerfTicketDUnit.assertFalse((boolean)mktSummRepo.next());
            }
            long mktSummRepoExecDone = System.nanoTime();
            acc = listOfAccounts[this.random.nextInt(totalAccounts - 1)];
            psPortSumm.setInt(1, acc);
            ResultSet portSummRepo = psPortSumm.executeQuery();
            if (portSummRepo.next()) {
                ++numFetchedPortSumm;
                portSummRepo.getFloat(1);
                portSummRepo.getFloat(2);
                portSummRepo.getInt(3);
            }
            while (portSummRepo.next()) {
                portSummRepo.getFloat(1);
                portSummRepo.getFloat(2);
                portSummRepo.getInt(3);
            }
            long portSummRepoExecDone = System.nanoTime();
            acc = listOfAccounts[this.random.nextInt(totalAccounts - 1)];
            psHoldingCount.setInt(1, acc);
            ResultSet holdingCntRepo = psHoldingCount.executeQuery();
            while (holdingCntRepo.next()) {
                holdingCntRepo.getInt(1);
            }
            long holdingCntRepoExecDone = System.nanoTime();
            psUptClosedOrder.setInt(1, acc);
            psUptClosedOrder.setInt(2, acc);
            psUptClosedOrder.execute();
            long uptClosedOrderExecDone = System.nanoTime();
            psFindOrderByStatus.setString(1, "open");
            psFindOrderByStatus.setInt(2, acc);
            psFindOrderByStatus.executeQuery();
            long findOrderByStatusExecDone = System.nanoTime();
            psFindOrderByAccAccId.setInt(1, acc);
            psFindOrderByAccAccId.executeQuery();
            long findOrderByAccAccIdExecDone = System.nanoTime();
            int qOrderIdx = this.random.nextInt(listOfOrderIds.length - 1);
            psFindOrderIdAndAccAccId.setInt(1, listOfOrderIds[qOrderIdx]);
            psFindOrderIdAndAccAccId.setInt(2, listOfOrderAccAccId[qOrderIdx]);
            psFindOrderIdAndAccAccId.executeQuery();
            long findOrderIdAndAccAccIdExecDone = System.nanoTime();
            psFindOrderCntAccAccId.setInt(1, acc);
            psFindOrderCntAccAccId.executeQuery();
            long findOrderCntAccAccIdExecDone = System.nanoTime();
            psFindOrderCntAccAccIdAndStatus.setInt(1, acc);
            psFindOrderCntAccAccIdAndStatus.setString(2, "open");
            psFindOrderCntAccAccIdAndStatus.executeQuery();
            long findOrderCntAccAccIdAndStatusExecDone = System.nanoTime();
            totHoldingExecTime += holdingExecDone - beginProfile;
            if (mktSummExecuted) {
                totMktSummExecTime += mktSummRepoExecDone - holdingExecDone;
            }
            totPortSummExecTime += portSummRepoExecDone - mktSummRepoExecDone;
            totHoldingCntExecTime += holdingCntRepoExecDone - portSummRepoExecDone;
            totUptClosedOrderExecTime += uptClosedOrderExecDone - holdingCntRepoExecDone;
            totFindOrderByStatusExecTime += findOrderByStatusExecDone - uptClosedOrderExecDone;
            totFindOrderByAccAccIdExecTime += findOrderByAccAccIdExecDone - findOrderByStatusExecDone;
            totFindOrderIdAndAccAccIdExecTime += findOrderIdAndAccAccIdExecDone - findOrderByAccAccIdExecDone;
            totFindOrderCntAccAccIdExecTime += findOrderCntAccAccIdExecDone - findOrderIdAndAccAccIdExecDone;
            totFindOrderCntAccAccIdAndStatusExecTime += findOrderCntAccAccIdAndStatusExecDone - findOrderCntAccAccIdExecDone;
            if (idx == 0 || idx % mktSummFreqMod != 0) continue;
            this.getLogWriter().info((Object)(idx + " iterations " + (profile ? "profiling" : "warmup") + " done."));
        }
        if (profile) {
            StringBuilder sb = new StringBuilder("Profile Summary:\n");
            int prevLen = sb.length();
            sb = this.appendInfo(sb.append("holdingAggRepo"), totHoldingExecTime, iterations, sb.length() - prevLen);
            prevLen = sb.length();
            sb = this.appendInfo(sb.append("mktSummRepo"), totMktSummExecTime, numTimesMktSummExecuted, sb.length() - prevLen);
            prevLen = sb.length();
            sb = this.appendInfo(sb.append("portSummaryReport"), totPortSummExecTime, iterations, sb.length() - prevLen);
            prevLen = sb.length();
            sb = this.appendInfo(sb.append("holdingCountReport"), totHoldingCntExecTime, iterations, sb.length() - prevLen);
            prevLen = sb.length();
            sb = this.appendInfo(sb.append("uptClosedOrder"), totUptClosedOrderExecTime, iterations, sb.length() - prevLen);
            prevLen = sb.length();
            sb = this.appendInfo(sb.append("findOrderByStatus"), totFindOrderByStatusExecTime, iterations, sb.length() - prevLen);
            prevLen = sb.length();
            sb = this.appendInfo(sb.append("findOrderByAccAccId"), totFindOrderByAccAccIdExecTime, iterations, sb.length() - prevLen);
            prevLen = sb.length();
            sb = this.appendInfo(sb.append("findOrderByOrderIdAndAccAccId"), totFindOrderIdAndAccAccIdExecTime, iterations, sb.length() - prevLen);
            prevLen = sb.length();
            sb = this.appendInfo(sb.append("findOrderCntAccAccId"), totFindOrderCntAccAccIdExecTime, iterations, sb.length() - prevLen);
            prevLen = sb.length();
            sb = this.appendInfo(sb.append("findOrderCntAccAccIdAndStatus"), totFindOrderCntAccAccIdAndStatusExecTime, iterations, sb.length() - prevLen);
            this.getLogWriter().info((Object)sb.toString());
        } else {
            this.getLogWriter().info((Object)("Warm up done, found \n" + numFetchedHolding + " valid holding accounts & \n" + numFetchedPortSumm + " valid portfolio summary accounts.\n Profiling for " + iterations + " iterations with every " + mktSummFreqMod + " iteration having market Summary Report. "));
        }
    }

    StringBuilder appendInfo(StringBuilder sb, long totExecTime, int iterations, int lableLength) {
        for (int align = 40 - lableLength; align >= 0; --align) {
            sb.append(' ');
        }
        sb.append("avgExecTime=").append(totExecTime / (long)iterations).append('\n');
        return sb;
    }

    String getPlanAsText(Clob c) throws SQLException, IOException {
        BufferedReader reader = new BufferedReader(c.getCharacterStream());
        int sz = (int)c.length();
        char[] charArray = new char[sz];
        reader.read(charArray, 0, sz);
        return new String(charArray);
    }
}

