/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.transactions;

import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.client.ClientXid;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.impl.services.monitor.FileMonitor;
import com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource;
import com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.derbyTesting.junit.XATestUtil;

public class XATransactionTest
extends JdbcTestBase {
    public XATransactionTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmbeddedXADataSource() throws Exception {
        FileMonitor monitor;
        EmbeddedXADataSource xaDataSource = (EmbeddedXADataSource)TestUtil.getXADataSource("com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource");
        byte[] gid = new byte[64];
        byte[] bid = new byte[64];
        for (int i = 0; i < 64; ++i) {
            gid[i] = (byte)i;
            bid[i] = (byte)(64 - i);
        }
        ClientXid xid = new ClientXid(4660, gid, bid);
        try {
            xaDataSource.setDatabaseName("gemfirexd");
            xaDataSource.setConnectionAttributes("mcast-port=2223;portNumber=0");
            monitor = (FileMonitor)Monitor.getCachedMonitorLite((boolean)false);
            monitor.report("<ExpectedException action=add>" + IllegalArgumentException.class.getName() + "</ExpectedException>");
            XAConnection xAConnection = xaDataSource.getXAConnection();
        }
        catch (SQLException sqle) {
            Throwable t = sqle.getCause();
            IllegalArgumentException expected = null;
            do {
                if (!(t instanceof IllegalArgumentException)) continue;
                expected = (IllegalArgumentException)t;
                break;
            } while ((t = t.getCause()) != null);
            if (expected == null || !expected.getMessage().contains("portNumber")) {
                throw sqle;
            }
        }
        finally {
            monitor = (FileMonitor)Monitor.getCachedMonitorLite((boolean)false);
            monitor.report("<ExpectedException action=remove>" + IllegalArgumentException.class.getName() + "</ExpectedException>");
        }
        xaDataSource.setConnectionAttributes("mcast-port=0");
        XAConnection xaConn = xaDataSource.getXAConnection();
    }

    public void testFromNetClient() throws Exception {
        XATransactionTest.setupConnection();
        int netport = XATransactionTest.startNetserverAndReturnPort("create table XATT2 (i int, text char(10))");
        ClientXADataSource xaDataSource = (ClientXADataSource)TestUtil.getXADataSource("com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource");
        byte[] gid = new byte[64];
        byte[] bid = new byte[64];
        for (int i = 0; i < 64; ++i) {
            gid[i] = (byte)i;
            bid[i] = (byte)(64 - i);
        }
        ClientXid xid = new ClientXid(4660, gid, bid);
        String localhost = SocketCreator.getLocalHost().getHostName();
        xaDataSource.setServerName(localhost);
        xaDataSource.setPortNumber(netport);
        xaDataSource.setDatabaseName("gemfirexd");
        XAConnection xaConn = xaDataSource.getXAConnection();
        XAResource xaRes = xaConn.getXAResource();
        Connection conn = xaConn.getConnection();
        xaRes.start((Xid)xid, 0);
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement stm = conn.createStatement();
        stm.execute("insert into XATT2 values (1234, 'Test_Entry')");
        stm.close();
        stm = XATransactionTest.getConnection().createStatement();
        stm.execute("select * from XATT2");
        ResultSet rs = stm.getResultSet();
        XATransactionTest.assertFalse((boolean)rs.next());
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        xaRes.commit((Xid)xid, false);
        stm.execute("select * from XATT2");
        rs = stm.getResultSet();
        XATransactionTest.assertTrue((boolean)rs.next());
    }

    public void testJTA_localTransaction() throws Exception {
        Properties props = new Properties();
        String jndiBindingsXmlFile = TestUtil.getResourcesDir() + "/lib/gfxdCacheJta.xml";
        props.put("cache-xml-file", jndiBindingsXmlFile);
        Connection c = TestUtil.getConnection(props);
        Statement stmnt = c.createStatement();
        stmnt.execute("create table XATT2 (i int primary key, text char(10))");
        String tableName = "testtable";
        Context ctx = Misc.getGemFireCache().getJNDIContext();
        String sql = "create table " + tableName + " (id integer NOT NULL primary key, name varchar(50))";
        DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
        Connection cxn = ds.getConnection();
        Statement sm = cxn.createStatement();
        try {
            sm.execute("drop table " + tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sm.execute(sql);
        sm.close();
        UserTransaction ta = (UserTransaction)ctx.lookup("java:/UserTransaction");
        ta.begin();
        Connection sm_conn = null;
        DataSource sds = (DataSource)ctx.lookup("java:/SimpleDataSource");
        DataSource gemfirexdXADataSource = (DataSource)ctx.lookup("java:/GemfirexdXADataSource");
        Connection conn = gemfirexdXADataSource.getConnection();
        Statement stm = conn.createStatement();
        stm.execute("insert into XATT2 values (1234, 'Test_Entry')");
        stm.close();
        sm_conn = sds.getConnection();
        Statement sm_stmt = sm_conn.createStatement();
        sm_stmt.execute("insert into " + tableName + " values (1, 'first')");
        sm_stmt.close();
        sm_conn.close();
        Connection connBeforeCommit = TestUtil.getConnection();
        stmnt = connBeforeCommit.createStatement();
        stmnt.execute("select * from XATT2");
        XATransactionTest.assertFalse((boolean)stmnt.getResultSet().next());
        stmnt.execute("select * from XATT2 where i = 1234");
        XATransactionTest.assertFalse((boolean)stmnt.getResultSet().next());
        ta.commit();
        stmnt.execute("select * from XATT2");
        XATransactionTest.assertTrue((boolean)stmnt.getResultSet().next());
    }

    public void testSimpleXATransaction() throws Exception {
        Statement stm = XATransactionTest.getConnection().createStatement();
        stm.execute("create table XATT2 (i int, text char(10))");
        XADataSource xaDataSource = (XADataSource)TestUtil.getXADataSource("com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource");
        byte[] gid = new byte[64];
        byte[] bid = new byte[64];
        for (int i = 0; i < 64; ++i) {
            gid[i] = (byte)i;
            bid[i] = (byte)(64 - i);
        }
        ClientXid xid = new ClientXid(4660, gid, bid);
        XAConnection xaConn = xaDataSource.getXAConnection();
        XAResource xaRes = xaConn.getXAResource();
        Connection conn = xaConn.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        xaRes.start((Xid)xid, 0);
        stm = conn.createStatement();
        stm.execute("insert into XATT2 values (1234, 'Test_Entry')");
        stm.close();
        stm = XATransactionTest.getConnection().createStatement();
        stm.execute("select * from XATT2");
        ResultSet rs = stm.getResultSet();
        XATransactionTest.assertFalse((boolean)rs.next());
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        xaRes.commit((Xid)xid, false);
        stm.execute("select * from XATT2");
        rs = stm.getResultSet();
        XATransactionTest.assertTrue((boolean)rs.next());
    }

    public void testSingleConnectionOnePhaseCommit() throws SQLException, XAException {
        Statement stm = XATransactionTest.getConnection().createStatement();
        stm.execute("create table XATT2 (i int, text char(10))");
        XADataSource xads = (XADataSource)TestUtil.getXADataSource("com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource");
        XAConnection xac = xads.getXAConnection();
        XAResource xar = xac.getXAResource();
        Xid xid = XATestUtil.getXid(0, 32, 46);
        xar.start(xid, 0);
        Connection conn = xac.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        XATransactionTest.assertEquals((int)2, (int)conn.getHoldability());
        Statement s = conn.createStatement();
        XATransactionTest.assertEquals((int)2, (int)s.getResultSetHoldability());
        s.execute("create table foo (a int)");
        s.executeUpdate("insert into foo values (0)");
        ResultSet rs = s.executeQuery("select * from foo");
        XATransactionTest.assertTrue((boolean)rs.next());
        XATransactionTest.assertFalse((boolean)rs.next());
        String[][] expectedRows = new String[][]{{"(0", "ACTIVE", "false", "APP", "UserTransaction"}};
        s.close();
        xar.end(xid, 0x4000000);
        xar.commit(xid, true);
        conn.close();
        xac.close();
    }

    public void testInterleavingTransactions() throws SQLException, XAException {
        Statement s;
        Connection conn;
        XAConnection xac;
        block8: {
            String[][] expectedRows;
            Xid xid2;
            Xid xid1;
            XAResource xar;
            block7: {
                Statement stm = XATransactionTest.getConnection().createStatement();
                stm.execute("create table foo (a int)");
                XADataSource xads = (XADataSource)TestUtil.getXADataSource("com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource");
                xac = xads.getXAConnection("sku", "testxa");
                xar = xac.getXAResource();
                xid1 = XATestUtil.getXid(1, 93, 18);
                xid2 = XATestUtil.getXid(2, 45, 77);
                xar.start(xid1, 0);
                conn = xac.getConnection();
                conn.setTransactionIsolation(this.getIsolationLevel());
                s = conn.createStatement();
                s.executeUpdate("insert into APP.foo values (1)");
                xar.end(xid1, 0x2000000);
                xar.start(xid2, 0);
                s.executeUpdate("insert into APP.foo values (2)");
                xar.end(xid2, 0x2000000);
                xar.start(xid1, 0x8000000);
                s.executeUpdate("insert into APP.foo values (3)");
                xar.end(xid1, 0x2000000);
                xar.start(xid2, 0x8000000);
                s.executeUpdate("insert into APP.foo values (4)");
                expectedRows = new String[][]{{"(1", "ACTIVE", "false", "SKU", "UserTransaction"}, {"(2", "ACTIVE", "false", "SKU", "UserTransaction"}};
                try {
                    xar.prepare(xid1);
                    XATransactionTest.fail("FAIL - prepare on suspended transaction");
                }
                catch (XAException e) {
                    if (e.errorCode == -6) break block7;
                    XATestUtil.dumpXAException("FAIL - prepare on suspended transaction", e);
                }
            }
            xar.end(xid2, 0x4000000);
            xar.end(xid1, 0x4000000);
            xar.prepare(xid1);
            xar.prepare(xid2);
            expectedRows = new String[][]{{"(1", "PREPARED", "false", "SKU", "UserTransaction"}, {"(2", "PREPARED", "false", "SKU", "UserTransaction"}};
            Xid[] recoveredStart = xar.recover(0x1000000);
            XATransactionTest.assertEquals((int)2, (int)recoveredStart.length);
            Xid[] recovered = xar.recover(0);
            XATransactionTest.assertEquals((int)0, (int)recovered.length);
            Xid[] recoveredEnd = xar.recover(0x800000);
            XATransactionTest.assertEquals((int)0, (int)recoveredEnd.length);
            for (int i = 0; i < recoveredStart.length; ++i) {
                Xid xid = recoveredStart[i];
                if (xid.getFormatId() == 1) {
                    xar.commit(xid, false);
                    continue;
                }
                if (xid.getFormatId() == 2) {
                    xar.rollback(xid);
                    continue;
                }
                XATransactionTest.fail("FAIL: unknown xact");
            }
            Xid xid3 = XATestUtil.getXid(3, 2, 101);
            xar.start(xid3, 0);
            expectedRows = new String[][]{{"(3", "IDLE", "NULL", "SKU", "UserTransaction"}};
            xar.end(xid3, 0x4000000);
            int pr = xar.prepare(xid3);
            try {
                xar.commit(xid3, false);
            }
            catch (XAException e) {
                if (e.errorCode == -4) break block8;
                throw e;
            }
        }
        s.close();
        conn.close();
        xac.close();
    }

    public void testNoTransaction() throws SQLException, XAException {
        block29: {
            Xid xid11;
            XAResource xar;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                Statement stm = XATransactionTest.getConnection().createStatement();
                                                stm.execute("create table foo (a int)");
                                                XADataSource xads = (XADataSource)TestUtil.getXADataSource("com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource");
                                                XAConnection xac = xads.getXAConnection();
                                                xar = xac.getXAResource();
                                                xid11 = XATestUtil.getXid(11, 3, 128);
                                                try {
                                                    xar.start(xid11, 0x200000);
                                                }
                                                catch (XAException e) {
                                                    if (e.errorCode == -4) break block20;
                                                    throw e;
                                                }
                                            }
                                            try {
                                                xar.start(xid11, 0x8000000);
                                            }
                                            catch (XAException e) {
                                                if (e.errorCode == -4) break block21;
                                                throw e;
                                            }
                                        }
                                        try {
                                            xar.end(xid11, 0x4000000);
                                        }
                                        catch (XAException e) {
                                            if (e.errorCode == -4) break block22;
                                            throw e;
                                        }
                                    }
                                    try {
                                        xar.end(xid11, 0x20000000);
                                    }
                                    catch (XAException e) {
                                        if (e.errorCode == -4) break block23;
                                        throw e;
                                    }
                                }
                                try {
                                    xar.end(xid11, 0x2000000);
                                }
                                catch (XAException e) {
                                    if (e.errorCode == -4) break block24;
                                    throw e;
                                }
                            }
                            try {
                                xar.prepare(xid11);
                            }
                            catch (XAException e) {
                                if (e.errorCode == -4) break block25;
                                throw e;
                            }
                        }
                        try {
                            xar.commit(xid11, false);
                        }
                        catch (XAException e) {
                            if (e.errorCode == -4) break block26;
                            throw e;
                        }
                    }
                    try {
                        xar.commit(xid11, true);
                    }
                    catch (XAException e) {
                        if (e.errorCode == -4) break block27;
                        throw e;
                    }
                }
                try {
                    xar.rollback(xid11);
                }
                catch (XAException e) {
                    if (e.errorCode == -4) break block28;
                    throw e;
                }
            }
            try {
                xar.forget(xid11);
            }
            catch (XAException e) {
                if (e.errorCode == -4) break block29;
                throw e;
            }
        }
    }

    protected int getIsolationLevel() {
        return 2;
    }
}

