/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.transactions;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gnu.trove.TIntHashSet;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.jdbc.CreateTableTest;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;

public class TransactionTest
extends JdbcTestBase {
    private GemFireCacheImpl cache;
    private boolean gotConflict = false;
    private volatile Throwable threadEx;
    private static Statement childStmnt = null;
    static volatile int updateCnt = 0;

    public TransactionTest(String name) {
        super(name);
    }

    public void _testDebugTwoDeltas() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, primary key(c1)) replicate" + this.getSuffix());
        conn.commit();
        conn = TransactionTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        st = conn.createStatement();
        st.execute("insert into t1 values (10, 10)");
        conn.commit();
        st.execute("update t1 set c2 = 20 where c1 = 10");
        st.execute("update t1 set c2 = 30 where c1 = 10");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionTest.assertEquals((String)"ResultSet should contain one row ", (int)1, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testCommitOnReplicatedTable() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, primary key(c1)) replicate" + this.getSuffix());
        conn.commit();
        conn = TransactionTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st = conn.createStatement();
        st.execute("insert into t1 values (10, 10)");
        conn.rollback();
        ResultSet rs = st.executeQuery("Select * from t1");
        TransactionTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into t1 values (10, 10)");
        st.execute("insert into t1 values (20, 20)");
        conn.commit();
        rs = st.executeQuery("Select * from t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionTest.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    public void testTransactionalInsertOnReplicatedTable() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, primary key(c1)) replicate" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st.execute("insert into t1 values (10, 10)");
        conn.rollback();
        ResultSet rs = st.executeQuery("Select * from t1");
        TransactionTest.assertFalse((String)"ResultSet should be empty ", (boolean)rs.next());
        rs.close();
        st.execute("insert into t1 values (10, 10)");
        st.execute("insert into t1 values (20, 20)");
        conn.commit();
        rs = st.executeQuery("Select * from t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionTest.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    public void Debug_testGFCommit() throws Exception {
        this.createCache();
        TXManagerImpl ctm = this.cache.getCacheTransactionManager();
        for (int i = 0; i < 10; ++i) {
            TXManagerImpl txManager = ctm;
            txManager.begin();
            Misc.getCacheLogWriter().info("XXXX started transaction : " + txManager.getTransactionId());
            TXStateInterface txState = txManager.internalSuspend();
            Misc.getCacheLogWriter().info("XXXX started transaction : " + txState.getTransactionId());
        }
    }

    private void createCache() throws Exception {
        Properties p = new Properties();
        p.setProperty("mcast-port", "0");
        this.cache = (GemFireCacheImpl)new CacheFactory(p).create();
        this.createRegion("TXTest");
    }

    protected final void createRegion(String name) throws Exception {
        AttributesFactory af = new AttributesFactory();
        af.setScope(Scope.DISTRIBUTED_NO_ACK);
        af.setIndexMaintenanceSynchronous(true);
        af.setDataPolicy(DataPolicy.REPLICATE);
        af.setPartitionAttributes(new PartitionAttributesFactory().setLocalMaxMemory(0).create());
        this.cache.createRegion(name, af.create());
    }

    private void doT1T2Inserts(Statement stmt) throws SQLException {
        stmt.execute("insert into t1 values(1, 1, 1)");
        stmt.execute("insert into t1 values(2, 2, 2)");
        stmt.execute("insert into t2 values(1, 1, 1)");
        stmt.execute("insert into t2 values(2, 2, 2)");
    }

    public void testCommitWithConflicts() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1)) replicate" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st.execute("insert into tran.t1 values (10, 1)");
        GemFireCacheImpl cache = Misc.getGemFireCache();
        final TXManagerImpl txMgrImpl = (TXManagerImpl)cache.getCacheTransactionManager();
        final Region r = Misc.getRegionForTable((String)"TRAN.T1", (boolean)true);
        final RegionKey key = TransactionTest.getGemFireKey(10, r);
        this.gotConflict = false;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                TestCase.assertNotNull((Object)r);
                txMgrImpl.begin();
                try {
                    r.put(key, (Object)new SQLInteger(20));
                    TestUtil.fail("expected a conflict here");
                }
                catch (ConflictException ce) {
                    TransactionTest.this.gotConflict = true;
                }
                TestCase.assertNull((Object)r.get(key));
                TXStateInterface txi = txMgrImpl.internalSuspend();
                TestCase.assertNotNull((Object)txi);
                txMgrImpl.resume(txi);
                txMgrImpl.commit();
            }
        });
        thread.start();
        thread.join();
        conn.commit();
        st.close();
        TransactionTest.assertTrue((String)"expected conflict", (boolean)this.gotConflict);
        this.gotConflict = false;
        r.destroy((Object)key);
        Statement st2 = conn.createStatement();
        st2.execute("insert into tran.t1 values (10, 10)");
        conn.commit();
        ResultSet rs = st2.executeQuery("select * from tran.t1");
        int numRow = 0;
        while (rs.next()) {
            ++numRow;
            TransactionTest.assertEquals((String)"Primary Key coloumns should be 10 ", (int)10, (int)rs.getInt(1));
            TransactionTest.assertEquals((String)"Second columns should be 10 , ", (int)10, (int)rs.getInt(2));
        }
        TransactionTest.assertEquals((String)"ResultSet should have two rows ", (int)1, (int)numRow);
        rs.close();
        st2.close();
        conn.commit();
        conn.close();
    }

    public void testCommitWithConflictsOnGlobalIndex() throws Exception {
        int numRows;
        ResultSet rs;
        Statement st2;
        Connection conn2;
        Statement st;
        Connection conn;
        block10: {
            block9: {
                block8: {
                    conn = TransactionTest.getConnection();
                    st = conn.createStatement();
                    st.execute("Create table tran.t1 (c1 int not null, c2 int not null, c3 int not null, primary key(c1), unique(c3)) partition by column (c2)" + this.getSuffix());
                    conn.commit();
                    conn.setTransactionIsolation(this.getIsolationLevel());
                    conn.setAutoCommit(false);
                    st.execute("insert into tran.t1 values (10, 1, 2)");
                    conn2 = TransactionTest.getConnection();
                    conn2.setTransactionIsolation(this.getIsolationLevel());
                    conn2.setAutoCommit(false);
                    st2 = conn2.createStatement();
                    try {
                        st2.execute("insert into tran.t1 values (10, 20, 30)");
                        conn2.commit();
                        TransactionTest.fail("expected conflict");
                    }
                    catch (SQLException sqle) {
                        if ("X0Z02".equals(sqle.getSQLState())) break block8;
                        throw sqle;
                    }
                }
                conn.commit();
                rs = st2.executeQuery("select * from tran.t1");
                numRows = 0;
                while (rs.next()) {
                    ++numRows;
                    TransactionTest.assertEquals((String)"Primary Key coloumn should be 10 ", (int)10, (int)rs.getInt(1));
                    TransactionTest.assertEquals((String)"Second column should be 1", (int)1, (int)rs.getInt(2));
                    TransactionTest.assertEquals((String)"Third column should be 2", (int)2, (int)rs.getInt(3));
                }
                TransactionTest.assertEquals((String)"ResultSet should have one row ", (int)1, (int)numRows);
                conn2.commit();
                st.execute("insert into tran.t1 values (20, 2, 3)");
                st2.execute("insert into tran.t1 values (30, 30, 40)");
                try {
                    st2.execute("update tran.t1 set c3=3 where c1=30");
                    TransactionTest.fail("expected conflict");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block9;
                    throw sqle;
                }
            }
            conn.rollback();
            st2.execute("insert into tran.t1 values (20, 2, 3)");
            try {
                st2.execute("update tran.t1 set c3=2 where c1=20");
                TransactionTest.fail("expected constraint violation");
            }
            catch (SQLException sqle) {
                if ("23505".equals(sqle.getSQLState())) break block10;
                throw sqle;
            }
        }
        st2.execute("insert into tran.t1 values (20, 2, 3)");
        st2.execute("insert into tran.t1 values (30, 3, 4)");
        conn2.commit();
        rs = st.executeQuery("select * from tran.t1 order by c1");
        numRows = 0;
        while (rs.next()) {
            TransactionTest.assertEquals((String)("Primary Key coloumn should be " + ++numRows * 10), (int)(numRows * 10), (int)rs.getInt(1));
            TransactionTest.assertEquals((String)("Second column should be " + numRows), (int)numRows, (int)rs.getInt(2));
            TransactionTest.assertEquals((String)("Third column should be " + (numRows + 1)), (int)(numRows + 1), (int)rs.getInt(3));
        }
        TransactionTest.assertEquals((String)"ResultSet should have one row ", (int)3, (int)numRows);
        conn.commit();
        conn.close();
        conn2.close();
    }

    public void testCommitOnPartitionedAndReplicatedTables() throws Exception {
        Connection conn = TransactionTest.getConnection();
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, primary key(c1)) replicate" + this.getSuffix());
        st.execute("Create table t2 (c1 int not null , c2 int not null, primary key(c1)) " + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        st.execute("insert into t2 values(10,10)");
        st.execute("insert into t1 values (10, 10)");
        st.execute("insert into t1 values (20, 20)");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionTest.assertEquals((String)"ResultSet should contain two rows ", (int)2, (int)numRows);
        numRows = 0;
        rs = st.executeQuery("Select * from t2");
        while (rs.next()) {
            ++numRows;
        }
        TransactionTest.assertEquals((String)"ResultSet should have one row", (int)1, (int)numRows);
        rs.close();
        st.close();
        this.checkConnCloseExceptionForReadsOnly(conn);
        conn.commit();
        conn.close();
    }

    public void testCommitWithIndex() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, primary key(c1)) replicate" + this.getSuffix());
        st.execute("Create index c2Index on t1(c2)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        st.execute("insert into t1 values (10, 10)");
        st.execute("insert into t1 values (20, 20)");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from t1 where t1.c2 = 10");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionTest.assertEquals((String)"ResultSet should contain two rows ", (int)1, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    public void testTransactionalKeyBasedUpdates() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema test");
        st.execute("create table test.t1 ( PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key (PkCol1) ) Partition by column (PkCol1)" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        st.execute("insert into test.t1 values(10, 10, 10, 10, 'XXXX1')");
        this.doOffHeapValidations();
        conn.commit();
        this.doOffHeapValidations();
        ResultSet rs = st.executeQuery("select * from test.t1");
        int numRows = 0;
        while (rs.next()) {
            TransactionTest.assertEquals((String)"Column value should be 10", (int)10, (int)rs.getInt(3));
            TransactionTest.assertEquals((String)"Column value should be 10", (int)10, (int)rs.getInt(4));
            TransactionTest.assertEquals((String)"Column value should be XXXX1", (String)"XXXX1", (String)rs.getString(5).trim());
            ++numRows;
        }
        this.doOffHeapValidations();
        TransactionTest.assertEquals((String)"Numbers of rows in resultset should be one", (int)1, (int)numRows);
        conn.commit();
        this.doOffHeapValidations();
        st.execute("update test.t1 set col3 = 20, col4 = 20, col5 = 'changed' where PkCol1=10");
        conn.commit();
        this.doOffHeapValidations();
        rs = st.executeQuery("select * from test.t1");
        numRows = 0;
        while (rs.next()) {
            TransactionTest.assertEquals((String)"Column value should change", (int)20, (int)rs.getInt(3));
            TransactionTest.assertEquals((String)"Columns value should change", (int)20, (int)rs.getInt(4));
            TransactionTest.assertEquals((String)"Columns value should change", (String)"changed", (String)rs.getString(5).trim());
            ++numRows;
        }
        this.doOffHeapValidations();
        TransactionTest.assertEquals((String)"Numbers of rows in resultset should be one", (int)1, (int)numRows);
        rs.close();
        st.close();
        conn.commit();
        conn.close();
    }

    public void testTruncate() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema test");
        st.execute("create table test.t1 ( PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key (PkCol1) ) Partition by column (PkCol1)" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        st.execute("insert into test.t1 values(10, 10, 10, 10, 'XXXX1')");
        conn.commit();
        st.execute("truncate table test.t1");
        conn.commit();
        ResultSet rs = st.executeQuery("select * from test.t1");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        TransactionTest.assertEquals((String)"ResultSet should have zero rows", (int)0, (int)numRows);
        st.close();
        conn.commit();
    }

    public void testIsolationLevels() throws Exception {
        Connection conn;
        block2: {
            conn = TransactionTest.getConnection();
            conn.setTransactionIsolation(0);
            conn.setTransactionIsolation(1);
            conn.setTransactionIsolation(2);
            conn.setTransactionIsolation(4);
            try {
                conn.setTransactionIsolation(8);
                TransactionTest.fail("expected failure in unsupported isolation-level SERIALIZABLE");
            }
            catch (SQLException ex) {
                if (ex.getSQLState().equalsIgnoreCase("XJ045")) break block2;
                throw ex;
            }
        }
        conn.close();
    }

    public void testNewGFETransactionNotCreatedForPKBasedOp() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) )  partition by column (tid) " + this.getSuffix());
        conn.setTransactionIsolation(this.getIsolationLevel());
        PreparedStatement ps = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?, ?)");
        for (int i = 0; i < 1; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "XXXX" + i);
            ps.setDouble(3, i);
            ps.setString(4, "nasdaq");
            ps.setInt(5, i);
            ps.executeUpdate();
        }
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionsAndIndexMaintenance() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema test");
        st.execute("create table test.t1 ( PkCol1 int not null, PkCol2 int not null , col3 int, col4 int, col5 varchar(10), Primary Key (PkCol1) ) Partition by column (PkCol1)" + this.getSuffix());
        conn.commit();
        st.execute("create index IndexCol4 on test.t1 (col4)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        int rows = 1000;
        CheckIndexOperations checkIndex = new CheckIndexOperations("Test.IndexCol4");
        try {
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)checkIndex);
            PreparedStatement psInsert = conn.prepareStatement("insert into test.t1 values (?,10,10,10,'XXXX1')");
            for (int i = 0; i < 1000; ++i) {
                psInsert.setInt(1, i);
                psInsert.executeUpdate();
                conn.commit();
            }
            checkIndex.checkNumInserts(1000);
        }
        finally {
            GemFireXDQueryObserverHolder.removeObserver((QueryObserver)checkIndex);
        }
        ResultSet rs = st.executeQuery("select * from test.t1 where col4 = 10");
        int numRows = 0;
        while (rs.next()) {
            TransactionTest.assertEquals((String)"Should return correct result ", (int)10, (int)rs.getInt("COL4"));
            ++numRows;
        }
        TransactionTest.assertEquals((String)"Should return 1000 rows ", (int)1000, (int)numRows);
        rs.close();
        PreparedStatement psUpdate = conn.prepareStatement("update test.t1 set col3 = 20, col4 = 20, col5 = 'changed' where PkCol1=?");
        try {
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)checkIndex);
            for (int i = 0; i < 1000; ++i) {
                psUpdate.setInt(1, i);
                psUpdate.executeUpdate();
                conn.commit();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.removeObserver((QueryObserver)checkIndex);
        }
        rs = st.executeQuery("select * from test.t1 where col4 = 20 order by PkCol1 asc");
        numRows = 0;
        while (rs.next()) {
            TransactionTest.assertEquals((String)"Should return correct result ", (int)20, (int)rs.getInt("COL4"));
            TransactionTest.assertEquals((String)"Should return correct result ", (int)20, (int)rs.getInt("COL3"));
            TransactionTest.assertEquals((String)"Should return correct result ", (String)"changed", (String)rs.getString("COL5").trim());
            TransactionTest.assertEquals((String)"Should return correct result ", (int)numRows, (int)rs.getInt("PKCOL1"));
            ++numRows;
        }
        TransactionTest.assertEquals((String)"Should return 1000 rows ", (int)1000, (int)numRows);
        st.close();
        conn.commit();
    }

    public void testTransactionalDeletes() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))" + this.getSuffix());
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        st.execute("insert into tran.t1 values (10, 10)");
        conn.commit();
        ResultSet rs = st.executeQuery("select * from tran.t1");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertFalse((boolean)rs.next());
        st.execute("delete from tran.t1 where c1 = 10");
        rs = st.executeQuery("select * from tran.t1");
        TransactionTest.assertFalse((boolean)rs.next());
        conn.commit();
        rs = st.executeQuery("select * from tran.t1");
        TransactionTest.assertFalse((boolean)rs.next());
        conn.commit();
        rs.close();
        st.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalDeleteWithLocalIndexes() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, primary key(c1))" + this.getSuffix());
        conn.commit();
        st.execute("create index IndexCol2 on tran.t1 (c2)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        int numRows = 1000;
        PreparedStatement ps = conn.prepareStatement("insert into tran.t1 values (?, ?)");
        for (int i = 0; i < numRows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        conn.commit();
        CheckIndexOperations checkIndex = new CheckIndexOperations("Tran.IndexCol2");
        PreparedStatement psDelete = conn.prepareStatement("delete from tran.t1 where c1 = ?");
        try {
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)checkIndex);
            for (int i = 0; i < numRows; ++i) {
                psDelete.setInt(1, i);
                psDelete.executeUpdate();
            }
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.removeObserver((QueryObserver)checkIndex);
        }
        st.close();
        conn.close();
    }

    public void testTransactionsAndUniqueIndexes() throws Exception {
        Connection conn;
        block3: {
            conn = TransactionTest.getConnection();
            Statement st = conn.createStatement();
            st.execute("create schema tran");
            st.execute("Create table tran.t1 (c1 int not null , c2 int not null, c3 int not null, primary key(c1), constraint C3_Unique unique (c3)) replicate" + this.getSuffix());
            conn.commit();
            st.execute("create index IndexCol2 on tran.t1 (c2)");
            conn.commit();
            conn.setTransactionIsolation(this.getIsolationLevel());
            int numRows = 2;
            PreparedStatement ps = conn.prepareStatement("insert into tran.t1 values (?, ?, ?)");
            try {
                for (int i = 0; i < numRows; ++i) {
                    ps.setInt(1, i);
                    ps.setInt(2, i);
                    ps.setInt(3, 2);
                    ps.executeUpdate();
                }
                conn.commit();
                TransactionTest.fail("Commit should throw an exception for unique key violation");
            }
            catch (SQLException ex) {
                if ("23505".equalsIgnoreCase(ex.getSQLState())) break block3;
                throw ex;
            }
        }
        conn.rollback();
        conn.close();
    }

    public void testTransactionalUpdate() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) )  partition by column (tid) " + this.getSuffix());
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        int numRows = 5;
        PreparedStatement ps = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?, ?)");
        for (int i = 0; i < 5; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "XXXX" + i);
            ps.setDouble(3, i);
            ps.setString(4, "nasdaq");
            ps.setInt(5, i);
            ps.executeUpdate();
        }
        conn.commit();
        this.doOffHeapValidations();
        PreparedStatement psUpdate = conn.prepareStatement("update trade.securities set symbol = ? where sec_id = ? and tid = ?");
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        ResultSet rs = st.executeQuery("select * from trade.securities");
        int numRowsReturned = 0;
        while (rs.next()) {
            TransactionTest.assertTrue((String)"Value should be YYY", (boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
            ++numRowsReturned;
        }
        TransactionTest.assertEquals((String)("Expected 5 row but found " + numRowsReturned), (int)5, (int)numRowsReturned);
        conn.rollback();
        this.doOffHeapValidations();
        rs = st.executeQuery("select * from trade.securities");
        numRowsReturned = 0;
        while (rs.next()) {
            TransactionTest.assertTrue((String)"Value should be XXXX", (boolean)rs.getString("SYMBOL").trim().startsWith("XXXX"));
            ++numRowsReturned;
        }
        this.doOffHeapValidations();
        TransactionTest.assertEquals((String)("Expected 5 row but found " + numRowsReturned), (int)5, (int)numRowsReturned);
        for (int i = 0; i < 5; ++i) {
            psUpdate.setString(1, "YYY" + i);
            psUpdate.setInt(2, i);
            psUpdate.setInt(3, i);
            psUpdate.executeUpdate();
        }
        conn.commit();
        this.doOffHeapValidations();
        rs = st.executeQuery("select * from trade.securities");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertTrue((boolean)rs.getString("SYMBOL").trim().startsWith("YYY"));
        conn.commit();
        rs.close();
        this.doOffHeapValidations();
        st.close();
        psUpdate.close();
        ps.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42178() throws Exception {
        Connection conn = TransactionTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) " + this.getSuffix());
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (int i = 1; i < 21; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return 1.0;
            }
        };
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)observer);
        TransactionTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 =5 where c5 =1"));
        TransactionTest.assertEquals((int)2, (int)st.executeUpdate("update t1 set c2 = 8  where c5 = 5"));
        conn.commit();
        try {
            ResultSet rs = st.executeQuery("Select c2 from t1 where c5 =5");
            TransactionTest.assertTrue((boolean)rs.next());
            TransactionTest.assertEquals((int)8, (int)rs.getInt(1));
            TransactionTest.assertTrue((boolean)rs.next());
            TransactionTest.assertEquals((int)8, (int)rs.getInt(1));
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.removeObserver((QueryObserver)observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42323() throws Exception {
        Connection conn = TransactionTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null, primary key(c1)) partition by column(c2)" + this.getSuffix());
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (int i = 1; i < 3; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        final boolean[] validTestPath = new boolean[]{false};
        final Exception[] e = new Exception[]{null, null};
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return 1.0;
            }

            public void beforeInvokingContainerGetTxRowLocation(RowLocation regionEntry) {
                if (!validTestPath[0]) {
                    Thread th = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Connection conn1 = TestUtil.getConnection();
                                conn1.setTransactionIsolation(TransactionTest.this.getIsolationLevel());
                                Statement st1 = conn1.createStatement();
                                TestCase.assertEquals((int)1, (int)st1.executeUpdate("delete from T1 where c5 = 1"));
                                conn1.commit();
                            }
                            catch (SQLException excep) {
                                e[0] = excep;
                            }
                        }
                    });
                    validTestPath[0] = true;
                    th.start();
                    try {
                        th.join();
                    }
                    catch (InterruptedException ie) {
                        e[1] = ie;
                    }
                }
            }
        };
        st.executeUpdate("update T1 set c3 = 7 where c2 = 2");
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)observer);
        try {
            TransactionTest.assertEquals((int)0, (int)st.executeUpdate("delete from T1 where c5 = 1"));
            conn.commit();
            TransactionTest.assertTrue((boolean)validTestPath[0]);
            if (e[0] != null) {
                TransactionTest.fail(e[0].toString());
            } else if (e[1] != null) {
                TransactionTest.fail(e[1].toString());
            }
        }
        finally {
            GemFireXDQueryObserverHolder.removeObserver((QueryObserver)observer);
        }
    }

    public void testBugDifferentThreadDifferentConnection42323() throws Exception {
        Connection conn = TransactionTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null)" + this.getSuffix());
        stmt.execute("Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
        stmt.execute("insert into t1 values(1, 1, 1)");
        stmt = conn.createStatement();
        stmt.execute("insert into t2 values(1, 1, 1)");
        try {
            stmt.execute("insert into t2 values(2, 2, 2)");
            TransactionTest.fail("the above insert should have failed");
        }
        catch (SQLException ex) {
            TransactionTest.assertTrue((boolean)"23503".equalsIgnoreCase(ex.getSQLState()));
        }
        this.doT1T2Inserts(stmt);
        this.threadEx = null;
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Connection newConn = TestUtil.getConnection();
                    newConn.setTransactionIsolation(TransactionTest.this.getIsolationLevel());
                    newConn.setAutoCommit(false);
                    Statement newstmt = newConn.createStatement();
                    try {
                        newstmt.execute("insert into t2 values(2, 2, 2)");
                        TestUtil.fail("ConflictException should have come");
                    }
                    catch (SQLException sqle) {
                        if (!"X0Z02".equals(sqle.getSQLState())) {
                            throw sqle;
                        }
                    }
                }
                catch (Throwable t) {
                    TransactionTest.this.threadEx = t;
                    TestUtil.fail("unexpected exception", t);
                }
            }
        });
        th.start();
        th.join();
        if (this.threadEx != null) {
            TransactionTest.fail("unexpected exception in thread", this.threadEx);
        }
        ResultSet rs = stmt.executeQuery("select count(*) from t1");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((int)2, (int)rs.getInt(1));
        stmt.execute("insert into t1 values(3, 3, 3)");
        rs = stmt.executeQuery("select count(*) from t1");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((int)3, (int)rs.getInt(1));
        conn.commit();
        rs = stmt.executeQuery("select count(*) from t1");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((int)3, (int)rs.getInt(1));
        conn.commit();
    }

    public void testBugSameThreadDifferentConnection42323() throws Exception {
        Statement stmt;
        Connection conn;
        block16: {
            block15: {
                Statement newstmt;
                block14: {
                    Connection newConn;
                    block13: {
                        block12: {
                            conn = TransactionTest.getConnection();
                            conn.setTransactionIsolation(this.getIsolationLevel());
                            conn.setAutoCommit(false);
                            stmt = conn.createStatement();
                            stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null)" + this.getSuffix());
                            stmt.execute("Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
                            stmt.execute("insert into t1 values(1, 1, 1)");
                            stmt = conn.createStatement();
                            stmt.execute("insert into t2 values(1, 1, 1)");
                            try {
                                stmt.execute("insert into t2 values(2, 2, 2)");
                                TransactionTest.fail("the above insert should have failed");
                            }
                            catch (SQLException ex) {
                                TransactionTest.assertTrue((boolean)"23503".equalsIgnoreCase(ex.getSQLState()));
                            }
                            this.doT1T2Inserts(stmt);
                            newConn = TestUtil.getConnection();
                            try {
                                stmt.execute("insert into t2 values(2, 2, 2)");
                                TransactionTest.fail("constraint violation should have come");
                            }
                            catch (SQLException sqle) {
                                if ("23505".equals(sqle.getSQLState())) break block12;
                                throw sqle;
                            }
                        }
                        newConn.setTransactionIsolation(this.getIsolationLevel());
                        newConn.setAutoCommit(false);
                        this.doT1T2Inserts(stmt);
                        try {
                            stmt.execute("insert into t2 values(2, 2, 2)");
                            TransactionTest.fail("constraint violation should have come");
                        }
                        catch (SQLException sqle) {
                            if ("23505".equals(sqle.getSQLState())) break block13;
                            throw sqle;
                        }
                    }
                    newstmt = newConn.createStatement();
                    this.doT1T2Inserts(stmt);
                    try {
                        stmt.execute("insert into t2 values(2, 2, 2)");
                        TransactionTest.fail("constraint violation should have come");
                    }
                    catch (SQLException sqle) {
                        if ("23505".equals(sqle.getSQLState())) break block14;
                        throw sqle;
                    }
                }
                this.doT1T2Inserts(stmt);
                try {
                    newstmt.execute("insert into t2 values(2, 2, 2)");
                    TransactionTest.fail("ConflictException should have come");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block15;
                    throw sqle;
                }
            }
            try {
                stmt.execute("insert into t2 values(2, 2, 2)");
                TransactionTest.fail("constraint violation should have come");
            }
            catch (SQLException sqle) {
                if ("23505".equals(sqle.getSQLState())) break block16;
                throw sqle;
            }
        }
        this.doT1T2Inserts(stmt);
        ResultSet rs = stmt.executeQuery("select count(*) from t1");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((int)2, (int)rs.getInt(1));
        stmt.execute("insert into t1 values(3, 3, 3)");
        rs = stmt.executeQuery("select count(*) from t1");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((int)3, (int)rs.getInt(1));
        conn.commit();
        rs = stmt.executeQuery("select count(*) from t1");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((int)3, (int)rs.getInt(1));
        conn.commit();
    }

    public void testBug42905() throws Exception {
        Connection conn = TransactionTest.getConnection();
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null)" + this.getSuffix());
        stmt.execute("Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
        stmt.execute("insert into t1 values(1, 1, 1)");
        stmt = conn.createStatement();
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        boolean gotException = false;
        try {
            stmt.execute("insert into t2 values(1, 1, 1)");
            stmt.execute("delete from t1 where c1 = 1");
            TransactionTest.fail("the above delete should have thrown a constraint violation");
        }
        catch (SQLException sqle) {
            if (!"23503".equals(sqle.getSQLState())) {
                throw sqle;
            }
            gotException = true;
        }
        TransactionTest.assertTrue((boolean)gotException);
    }

    public void testBug42915() throws Exception {
        Statement stmt;
        Connection conn;
        block11: {
            Connection childConn;
            block10: {
                block9: {
                    conn = TransactionTest.getConnection();
                    conn.setTransactionIsolation(this.getIsolationLevel());
                    conn.setAutoCommit(false);
                    stmt = conn.createStatement();
                    stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null)" + this.getSuffix());
                    stmt.execute("Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
                    conn.commit();
                    childConn = TransactionTest.getConnection();
                    childConn.setTransactionIsolation(this.getIsolationLevel());
                    childConn.setAutoCommit(false);
                    childStmnt = childConn.createStatement();
                    childStmnt.execute("insert into t1 values(1, 1, 1)");
                    stmt = conn.createStatement();
                    boolean gotException = false;
                    try {
                        stmt.execute("insert into t2 values(1, 1, 1)");
                    }
                    catch (SQLException sqle) {
                        if (!"X0Z02".equals(sqle.getSQLState())) {
                            throw sqle;
                        }
                        gotException = true;
                    }
                    TransactionTest.assertTrue((boolean)gotException);
                    childConn.commit();
                    stmt.execute("insert into t2 values(1, 1, 1)");
                    try {
                        childStmnt.execute("update t1 set c2 = 2 where c1 = 1");
                        childConn.commit();
                        TransactionTest.fail("expected conflict exception");
                    }
                    catch (SQLException sqle) {
                        if ("X0Z02".equals(sqle.getSQLState())) break block9;
                        throw sqle;
                    }
                }
                try {
                    childStmnt.execute("delete from t1 where c1 = 1");
                    TransactionTest.fail("expected conflict exception");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block10;
                    throw sqle;
                }
            }
            conn.rollback();
            childStmnt.execute("update t1 set c2 = 2 where c1 = 1");
            childStmnt.execute("delete from t1 where c1 = 1");
            childConn.commit();
            stmt.execute("delete from t2 where c1 = 1");
            stmt.execute("insert into t1 values(1, 1, 1)");
            conn.commit();
            stmt.execute("insert into t2 values(1, 1, 1)");
            try {
                stmt.execute("delete from t1 where c1 = 1");
                TransactionTest.fail("expected a constraint violation");
            }
            catch (SQLException sqle) {
                if ("23503".equals(sqle.getSQLState())) break block11;
                throw sqle;
            }
        }
        stmt.execute("update t1 set c2 = 3 where c1 = 1");
        conn.commit();
        ResultSet rs = stmt.executeQuery("select c2, c3 from t1 where c1 = 1");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((int)3, (int)rs.getInt(1));
        TransactionTest.assertEquals((int)1, (int)rs.getInt(2));
        TransactionTest.assertFalse((boolean)rs.next());
        rs.close();
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42923_uniqButUpdateRequiresFnExn() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        Connection conn = TransactionTest.getConnection();
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3))" + this.getSuffix());
        stmt.execute("insert into t1 values (1, 1, 1), (2, 2, 2), (3, 3, 3)");
        conn.commit();
        this.doOffHeapValidations();
        final boolean[] shouldThreadCommit = new boolean[]{false};
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Connection childConn = TestUtil.getConnection();
                    childConn.setTransactionIsolation(TransactionTest.this.getIsolationLevel());
                    childConn.setAutoCommit(false);
                    childStmnt = childConn.createStatement();
                    childStmnt.execute("update t1 set c3 = 4 where c3 > 2");
                    latch.countDown();
                    TransactionTest transactionTest = TransactionTest.this;
                    synchronized (transactionTest) {
                        if (!shouldThreadCommit[0]) {
                            ((Object)((Object)TransactionTest.this)).wait();
                        }
                    }
                    childConn.commit();
                }
                catch (Exception e) {
                    TestUtil.fail("got exception in the spawned thread", e);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        latch.await();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt = conn.createStatement();
        boolean gotException = false;
        try {
            stmt.execute("update t1 set c3 = 4 where c3 > 2");
            conn.commit();
        }
        catch (SQLException sqle) {
            if (!"X0Z02".equals(sqle.getSQLState())) {
                throw sqle;
            }
            gotException = true;
        }
        TransactionTest transactionTest = this;
        synchronized (transactionTest) {
            shouldThreadCommit[0] = true;
            ((Object)((Object)this)).notify();
        }
        TransactionTest.assertTrue((boolean)gotException);
        t.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42923_uniqButUpdateIsPutConvertible() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        Connection conn = TransactionTest.getConnection();
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3))" + this.getSuffix());
        stmt.execute("insert into t1 values (1, 1, 1), (2, 2, 2), (3, 3, 3)");
        conn.commit();
        final boolean[] shouldThreadCommit = new boolean[]{false};
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Connection childConn = TestUtil.getConnection();
                    childConn.setTransactionIsolation(TransactionTest.this.getIsolationLevel());
                    childConn.setAutoCommit(false);
                    childStmnt = childConn.createStatement();
                    childStmnt.execute("update t1 set c3 = 4 where c1 = 2");
                    latch.countDown();
                    TransactionTest transactionTest = TransactionTest.this;
                    synchronized (transactionTest) {
                        if (!shouldThreadCommit[0]) {
                            ((Object)((Object)TransactionTest.this)).wait();
                        }
                    }
                    childConn.commit();
                }
                catch (Exception e) {
                    TestUtil.getLogger().error((Object)"unexpected exception", (Throwable)e);
                    TestUtil.fail("got exception in the spawned thread", e);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        latch.await();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        stmt = conn.createStatement();
        boolean gotException = false;
        try {
            stmt.execute("update t1 set c3 = 4 where c1 = 2");
            conn.commit();
        }
        catch (SQLException sqle) {
            if (!"X0Z02".equals(sqle.getSQLState())) {
                throw sqle;
            }
            gotException = true;
        }
        TransactionTest transactionTest = this;
        synchronized (transactionTest) {
            shouldThreadCommit[0] = true;
            ((Object)((Object)this)).notify();
        }
        TransactionTest.assertTrue((boolean)gotException);
        t.join();
    }

    public void testTransactionErrorBatch() throws Exception {
        Statement stmt3;
        Statement stmt2;
        Statement stmt;
        Connection conn3;
        Connection conn2;
        Connection conn;
        block5: {
            block4: {
                conn = TransactionTest.getConnection();
                conn2 = TransactionTest.getConnection();
                conn3 = TransactionTest.startNetserverAndGetLocalNetConnection();
                conn.setAutoCommit(false);
                conn2.setAutoCommit(false);
                conn.setTransactionIsolation(this.getIsolationLevel());
                conn2.setTransactionIsolation(this.getIsolationLevel());
                conn3.setTransactionIsolation(this.getIsolationLevel());
                stmt = conn.createStatement();
                stmt2 = conn2.createStatement();
                stmt3 = conn3.createStatement();
                TransactionTest.getLogger().info((Object)"Negative Statement: statement testing eager fail while getting the lock in the batch");
                stmt.execute("create table t1 (c1 int not null primary key, c2 int)" + this.getSuffix());
                conn.commit();
                stmt.execute("insert into t1 values(1, 1)");
                stmt2.execute("insert into t1 values(2, 2)");
                stmt.addBatch("update t1 set c2=3 where c1=2");
                stmt2.addBatch("update t1 set c2=4 where c1=1");
                try {
                    stmt.executeBatch();
                    TransactionTest.fail("Batch is expected to fail");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState()) && sqle instanceof BatchUpdateException) break block4;
                    throw sqle;
                }
            }
            stmt3.addBatch("update t1 set c2=3 where c1=2");
            try {
                stmt3.executeBatch();
                TransactionTest.fail("Batch is expected to fail");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState()) && sqle instanceof BatchUpdateException) break block5;
                throw sqle;
            }
        }
        int[] updateCount = stmt2.executeBatch();
        TransactionTest.assertNotNull((Object)updateCount);
        TransactionTest.assertEquals((int)1, (int)updateCount.length);
        TransactionTest.assertEquals((int)0, (int)updateCount[0]);
        conn.rollback();
        conn2.rollback();
        conn3.rollback();
        stmt.clearBatch();
        stmt2.clearBatch();
        stmt3.clearBatch();
        stmt.close();
        stmt2.close();
        stmt3.close();
        conn.close();
        conn2.close();
        conn3.close();
    }

    public void testTxnDeleteParentRow() throws Exception {
        Statement childStmnt;
        Connection childConn;
        Connection conn;
        block2: {
            conn = TransactionTest.getConnection();
            Statement stmtp1 = conn.createStatement();
            stmtp1.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3))" + this.getSuffix());
            stmtp1.execute("Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
            stmtp1.execute("insert into t1 values(1, 1, 1)");
            conn.setTransactionIsolation(this.getIsolationLevel());
            conn.setAutoCommit(false);
            Statement stmtp2 = conn.createStatement();
            stmtp2.execute("delete from t1 where c1 = 1");
            childConn = TestUtil.getConnection();
            childConn.setTransactionIsolation(this.getIsolationLevel());
            childStmnt = childConn.createStatement();
            TransactionTest.addExpectedException(ConflictException.class);
            try {
                childStmnt.execute("insert into t2 values(1, 1, 1)");
                TransactionTest.fail("expected conflict exception");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
        TransactionTest.removeExpectedException(ConflictException.class);
        conn.rollback();
        childStmnt.execute("insert into t2 values(1, 1, 1)");
        childConn.commit();
    }

    public void testTxnDeleteParentRow_bothCaseOfChildCommittedAndUncommitted() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Connection conn2 = TransactionTest.getConnection();
        Connection conn3 = TransactionTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("Create table t1 (c1 int not null primary key, c2 int not null, c3 int not null, constraint C3_Unique unique (c3))" + this.getSuffix());
        stmt.execute("Create table t2 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
        stmt.execute("Create table t3 (c1 int not null primary key, c2 int not null, c3 int not null, foreign key (c1) references t1(c1))" + this.getSuffix());
        stmt.execute("insert into t1 values(1, 1, 1), (2, 2, 2)");
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        conn2.setTransactionIsolation(this.getIsolationLevel());
        conn2.setAutoCommit(false);
        conn3.setTransactionIsolation(this.getIsolationLevel());
        conn3.setAutoCommit(false);
        Statement stmt2 = conn2.createStatement();
        Statement stmt3 = conn2.createStatement();
        stmt2.execute("insert into t2 values(1, 1, 1), (2, 2, 2)");
        stmt3.execute("insert into t3 values(1, 1, 1), (2, 2, 2)");
        for (int i = 0; i < 2; ++i) {
            if (i == 1) {
                conn2.commit();
                conn3.commit();
            }
            try {
                stmt.execute("delete from t1");
                continue;
            }
            catch (SQLException e) {
                if (i == 0) {
                    TransactionTest.assertEquals((String)"X0Z02", (String)e.getSQLState());
                    continue;
                }
                TransactionTest.assertEquals((String)"23503", (String)e.getSQLState());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTxnUpdateBehaviorForLocking() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch barrier = new CountDownLatch(2);
        final Connection childConn = TransactionTest.getConnection();
        Connection conn = TransactionTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement stmt = conn.createStatement();
        stmt.execute("Create table t1 (c1 int not null primary key, qty int not null, c3 int not null, exchange varchar(20), c4 int not null, constraint C3_Unique unique (c3), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex')), constraint qty_ck check (qty >= 5))" + this.getSuffix());
        stmt.execute("insert into t1 values(1, 10, 1, 'nye', 4), (2, 20, 2, 'amex', 4)");
        conn.commit();
        MemHeapScanController.setWaitObjectAfterFirstQualifyForTEST((CountDownLatch)latch);
        MemHeapScanController.setWaitBarrierBeforeFirstScanForTEST((CountDownLatch)barrier);
        MemHeapScanController.setWaitForLatchForTEST((int)0);
        try {
            final Exception[] ex = new Exception[]{null};
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        childConn.setTransactionIsolation(TransactionTest.this.getIsolationLevel());
                        Statement cstmt = childConn.createStatement();
                        MemHeapScanController.setWaitForLatchForTEST((int)3);
                        cstmt.execute("update t1 set c4 = 40 where c4 = 4");
                        updateCnt = cstmt.getUpdateCount();
                    }
                    catch (Exception e) {
                        ex[0] = e;
                    }
                    finally {
                        MemHeapScanController.setWaitForLatchForTEST((int)0);
                    }
                }
            };
            Thread t = new Thread(r);
            t.start();
            Connection conn2 = TransactionTest.getConnection();
            conn2.setTransactionIsolation(this.getIsolationLevel());
            Statement stmt2 = conn2.createStatement();
            stmt2.execute("update t1 set c4 = 10");
            conn2.commit();
            latch.countDown();
            t.join();
            TransactionTest.assertEquals((int)0, (int)updateCnt);
            TransactionTest.assertNotNull((Object)ex[0]);
            if (!(ex[0] instanceof SQLException)) {
                throw ex[0];
            }
            if (!"X0Z02".equals(((SQLException)ex[0]).getSQLState())) {
                throw ex[0];
            }
        }
        finally {
            MemHeapScanController.setWaitBarrierBeforeFirstScanForTEST(null);
            MemHeapScanController.setWaitObjectAfterFirstQualifyForTEST(null);
        }
        childConn.commit();
    }

    public void testTxnUpdateToSameValueOnSameRow() throws Exception {
        Connection conn = TransactionTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement stmt = conn.createStatement();
        stmt.execute("Create table t1 (c1 int primary key, c2 int not null, exchange varchar(20), symbol varchar(20), constraint sym_ex unique (symbol, exchange))" + this.getSuffix());
        stmt.execute("insert into t1 values(1, 10, 'nyse', 'o'), (2, 20, 'amex', 'g')");
        conn.commit();
        stmt.execute("update t1 set exchange = 'nyse', symbol = 'o' where c1 = 1");
        conn.commit();
    }

    public void testTxnUpdateGettingLostBug2_43222_44096() throws Exception {
        String sql;
        Statement stmt;
        Connection conn;
        block3: {
            conn = TransactionTest.getConnection();
            conn.setTransactionIsolation(this.getIsolationLevel());
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt.execute("create schema TXN");
            sql = " create table TXN.customer (c_w_id integer not null, c_d_id integer not null, c_id integer not null, c_last varchar(16), c_first varchar(16), c_balance decimal(12,2), c_delivery_cnt integer) partition by column(c_w_id) redundancy 1" + this.getSuffix();
            stmt.execute(sql);
            sql = "alter table TXN.customer add constraint pk_customer primary key (c_w_id, c_d_id, c_id)";
            stmt.execute(sql);
            stmt.execute("insert into TXN.customer values(1, 1, 2, 'bara', 'alan', -10.0, 0), (2, 5, 5, 'para', 'bhalan', -10.0, 0), (2, 5, 17, 'cara', 'jhalan', -10.0, 0)");
            conn.commit();
            TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)observer);
            Connection conn2 = TransactionTest.getConnection();
            conn2.setTransactionIsolation(this.getIsolationLevel());
            conn2.setAutoCommit(false);
            Statement stmt2 = conn2.createStatement();
            String sql2 = "UPDATE TXN.customer SET c_balance = 4510.63 WHERE c_w_id = 2 AND c_d_id = 5 AND c_id = 5";
            stmt2.executeUpdate(sql2);
            observer.addExpectedScanType("TXN.customer", TestUtil.ScanType.NONE);
            observer.checkAndClear();
            conn2.commit();
            sql = " UPDATE TXN.customer SET c_balance = c_balance + 3415.52, c_delivery_cnt = c_delivery_cnt + 1 WHERE c_id = 5 AND c_d_id = 5 AND c_w_id = 2";
            int cnt = stmt.executeUpdate(sql);
            TransactionTest.assertEquals((int)1, (int)cnt);
            observer.addExpectedScanType("TXN.customer", TestUtil.ScanType.HASH1INDEX);
            observer.checkAndClear();
            conn.commit();
            stmt.execute("create index TXN.ndx_customer_name on customer (c_w_id, c_d_id, c_last, c_first)");
            cnt = stmt.executeUpdate(sql);
            TransactionTest.assertEquals((int)1, (int)cnt);
            try {
                stmt2.executeUpdate(sql);
                TransactionTest.fail("expected conflict exception");
            }
            catch (SQLException sq) {
                if ("X0Z02".equals(sq.getSQLState())) break block3;
                throw sq;
            }
        }
        sql = "select * from TXN.customer WHERE c_id = 5 AND c_d_id = 5 AND c_w_id = 2";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int sel_cnt = 0;
        while (rs.next()) {
            ++sel_cnt;
            System.out.println(rs.getObject(1) + ", " + rs.getObject(2) + ", " + rs.getObject(3) + ", " + rs.getObject(4) + ", " + rs.getObject(5) + ", " + rs.getObject(6) + ", " + rs.getObject(7));
        }
        TransactionTest.assertEquals((int)1, (int)sel_cnt);
        conn.commit();
    }

    public void testTxnUpdateGettingLostBug_43222() throws Exception {
        int cnt;
        String sql;
        Statement stmt;
        Connection conn;
        block3: {
            conn = TransactionTest.getConnection();
            conn.setTransactionIsolation(this.getIsolationLevel());
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt.execute("create schema TXN");
            sql = " create table TXN.customer (c_w_id integer not null, c_d_id integer not null, c_id integer not null, c_last varchar(16), c_first varchar(16), c_balance decimal(12,2), c_delivery_cnt integer) partition by column(c_w_id) redundancy 1" + this.getSuffix();
            stmt.execute(sql);
            sql = "alter table TXN.customer add constraint pk_customer primary key (c_w_id, c_d_id, c_id)";
            stmt.execute(sql);
            sql = "create index TXN.ndx_customer_name on customer (c_w_id, c_d_id, c_last, c_first)";
            stmt.execute(sql);
            stmt.execute("insert into TXN.customer values(1, 1, 2, 'bara', 'alan', -10.0, 0), (2, 6, 13, 'para', 'bhalan', -10.0, 0), (2, 5, 17, 'cara', 'jhalan', -10.0, 0)");
            conn.commit();
            sql = "UPDATE TXN.customer SET c_balance = c_balance + 56503.58, c_delivery_cnt = c_delivery_cnt + 1 WHERE c_id = 13 AND c_d_id = 6 AND c_w_id = 2";
            TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)observer);
            cnt = stmt.executeUpdate(sql);
            observer.addExpectedScanType("TXN.customer", TestUtil.ScanType.HASH1INDEX);
            observer.checkAndClear();
            Connection conn2 = TestUtil.getConnection();
            conn2.setTransactionIsolation(this.getIsolationLevel());
            conn2.setAutoCommit(false);
            Statement stmt2 = conn2.createStatement();
            try {
                stmt2.executeUpdate(sql);
                TransactionTest.fail("expected conflict exception");
            }
            catch (SQLException sq) {
                if ("X0Z02".equals(sq.getSQLState())) break block3;
                throw sq;
            }
        }
        TransactionTest.assertEquals((int)1, (int)cnt);
        sql = "select * from TXN.customer WHERE c_id = 13 AND c_d_id = 6 AND c_w_id = 2";
        stmt.execute(sql);
        ResultSet rs = stmt.getResultSet();
        int sel_cnt = 0;
        while (rs.next()) {
            ++sel_cnt;
        }
        TransactionTest.assertEquals((int)1, (int)sel_cnt);
        conn.commit();
    }

    public void testDeleteLockBeforeReferenceKeyCheck() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement stmt = conn.createStatement();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        CreateTableTest.createTables(conn);
        CreateTableTest.populateData(conn, false, false);
        conn.commit();
        stmt.execute("create index cust_1 on trade.customers(tid)");
        stmt.execute("create index port_1 on trade.portfolio(sid)");
        Connection conn2 = TransactionTest.getConnection();
        conn2.setTransactionIsolation(this.getIsolationLevel());
        conn2.setAutoCommit(false);
        Statement stmt2 = conn2.createStatement();
        TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)observer);
        TransactionTest.assertEquals((int)1, (int)stmt2.executeUpdate("update trade.customers set addr = 'addr20' where cid = 10"));
        observer.addExpectedScanType("trade.customers", TestUtil.ScanType.NONE);
        observer.checkAndClear();
        this.checkConflictsWithDifferentScanTypes(stmt, 10, observer);
        TransactionTest.assertEquals((int)1, (int)stmt2.executeUpdate("update trade.customers set tid = tid + 100 where cid = 11"));
        observer.addExpectedScanType("trade.customers", TestUtil.ScanType.HASH1INDEX);
        observer.checkAndClear();
        this.checkConflictsWithDifferentScanTypes(stmt, 11, observer);
        TransactionTest.assertEquals((int)1, (int)stmt2.executeUpdate("update trade.customers set tid = tid + 100 where cid > 11 and cid < 13"));
        observer.addExpectedScanType("trade.customers", TestUtil.ScanType.TABLE);
        observer.checkAndClear();
        this.checkConflictsWithDifferentScanTypes(stmt, 12, observer);
        TransactionTest.assertEquals((int)6, (int)stmt2.executeUpdate("update trade.customers set tid = tid + 100 where tid >= 13 and tid < 20"));
        observer.addExpectedScanType("trade.customers", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        this.checkConflictsWithDifferentScanTypes(stmt, 14, observer);
        conn.rollback();
        conn2.rollback();
    }

    public void testWrongConsecutiveUpdates_42647() throws SQLException {
        Connection conn = TransactionTest.getConnection();
        Statement stmt = conn.createStatement();
        conn.setTransactionIsolation(this.getIsolationLevel());
        stmt.execute("create schema TXN");
        String sql = " create table TXN.customer (c_w_id integer not null, c_d_id integer not null, c_id integer not null, c_last varchar(16), c_first varchar(16), c_balance decimal(12,2), c_delivery_cnt integer) partition by column(c_w_id) redundancy 1" + this.getSuffix();
        stmt.execute(sql);
        stmt.execute("create index cust_idx1 on TXN.customer(c_w_id)");
        conn.commit();
        stmt.execute("insert into TXN.customer values(1, 1, 2, 'bara', 'alan', -10.0, 0), (2, 6, 13, 'para', 'bhalan', -10.0, 0), (2, 5, 17, 'cara', 'jhalan', -10.0, 0)");
        conn.commit();
        stmt.execute("update TXN.customer set c_balance = c_balance - 40.6 where c_w_id = 1");
        stmt.execute("update TXN.customer set c_balance = c_balance - 49.4 where c_w_id = 1");
        conn.commit();
        stmt.execute("select * from TXN.customer where c_w_id = 1");
        ResultSet rs = stmt.getResultSet();
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((Object)-100.0, (Object)rs.getDouble(6));
        TransactionTest.assertFalse((boolean)rs.next());
    }

    public void testTransactionsAndUniqueIndexes_43152() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        Connection nonTxconn = TransactionTest.getConnection();
        nonTxconn.setTransactionIsolation(0);
        Statement nonTxst = nonTxconn.createStatement();
        Connection conn2 = TransactionTest.getConnection();
        conn2.setTransactionIsolation(this.getIsolationLevel());
        conn2.setAutoCommit(false);
        Statement st2 = conn2.createStatement();
        st.execute("create schema tran");
        st.execute("Create table tran.t1 (c1 int not null , c2 int not null, c3 int not null, primary key(c1), constraint C3_Unique unique (c3)) replicate " + this.getSuffix());
        conn.commit();
        st.execute("insert into tran.t1 values(1, 1, 1)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        st.execute("update tran.t1 set c3 = 1, c2 = 4 where c1 = 1");
        st.execute("select * from tran.t1 where c3 = 1");
        ResultSet rs = st.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            TransactionTest.assertEquals((int)1, (int)rs.getInt(1));
            TransactionTest.assertEquals((int)4, (int)rs.getInt(2));
            TransactionTest.assertEquals((int)1, (int)rs.getInt(3));
        }
        TransactionTest.assertEquals((int)1, (int)cnt);
        nonTxst.execute("select * from tran.t1");
        ResultSet rsNonTx = nonTxst.getResultSet();
        int cntNonTx = 0;
        while (rsNonTx.next()) {
            ++cntNonTx;
            TransactionTest.assertEquals((int)1, (int)rsNonTx.getInt(1));
            TransactionTest.assertEquals((int)1, (int)rsNonTx.getInt(2));
            TransactionTest.assertEquals((int)1, (int)rsNonTx.getInt(3));
        }
        TransactionTest.assertEquals((int)1, (int)cntNonTx);
        st2.execute("select * from tran.t1");
        ResultSet rsTx2 = st2.getResultSet();
        int cntTx2 = 0;
        while (rsTx2.next()) {
            ++cntTx2;
            TransactionTest.assertEquals((int)1, (int)rsTx2.getInt(1));
            TransactionTest.assertEquals((int)1, (int)rsTx2.getInt(2));
            TransactionTest.assertEquals((int)1, (int)rsTx2.getInt(3));
        }
        TransactionTest.assertEquals((int)1, (int)cntTx2);
        st2.execute("select * from tran.t1 where c3 = 1");
        rsTx2 = st2.getResultSet();
        cntTx2 = 0;
        while (rsTx2.next()) {
            ++cntTx2;
            TransactionTest.assertEquals((int)1, (int)rsTx2.getInt(1));
            TransactionTest.assertEquals((int)1, (int)rsTx2.getInt(2));
            TransactionTest.assertEquals((int)1, (int)rsTx2.getInt(3));
        }
        TransactionTest.assertEquals((int)1, (int)cntTx2);
        try {
            st2.execute("update tran.t1 set c3 = 1, c2 = 5 where c1 = 1");
            TransactionTest.fail("the above update should have thrown conflict exception");
        }
        catch (SQLException sqle) {
            TransactionTest.assertTrue((boolean)"X0Z02".equals(sqle.getSQLState()));
        }
        Connection conn3 = TransactionTest.getConnection();
        conn3.setTransactionIsolation(this.getIsolationLevel());
        Statement st3 = conn3.createStatement();
        try {
            st3.execute("delete from tran.t1");
            TransactionTest.fail("the above delete should have thrown conflict exception");
        }
        catch (SQLException sqle) {
            TransactionTest.assertTrue((boolean)"X0Z02".equals(sqle.getSQLState()));
        }
        Connection conn4 = TransactionTest.getConnection();
        conn4.setTransactionIsolation(this.getIsolationLevel());
        Statement st4 = conn4.createStatement();
        try {
            st4.execute("delete from tran.t1 where c1 = 1");
            TransactionTest.fail("the above delete should have thrown conflict exception");
        }
        catch (SQLException sqle) {
            TransactionTest.assertTrue((boolean)"X0Z02".equals(sqle.getSQLState()));
        }
        st.execute("update tran.t1 set c3 = 1, c2 = 5 where c1 = 1");
        st.execute("select * from tran.t1");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            TransactionTest.assertEquals((int)1, (int)rs.getInt(1));
            TransactionTest.assertEquals((int)5, (int)rs.getInt(2));
            TransactionTest.assertEquals((int)1, (int)rs.getInt(3));
        }
        TransactionTest.assertEquals((int)1, (int)cnt);
        nonTxst.execute("select * from tran.t1");
        rsNonTx = nonTxst.getResultSet();
        cntNonTx = 0;
        while (rsNonTx.next()) {
            ++cntNonTx;
            TransactionTest.assertEquals((int)1, (int)rsNonTx.getInt(1));
            TransactionTest.assertEquals((int)1, (int)rsNonTx.getInt(2));
            TransactionTest.assertEquals((int)1, (int)rsNonTx.getInt(3));
        }
        TransactionTest.assertEquals((int)1, (int)cntNonTx);
        conn.commit();
        nonTxst.execute("select * from tran.t1");
        rsNonTx = nonTxst.getResultSet();
        cntNonTx = 0;
        while (rsNonTx.next()) {
            ++cntNonTx;
            TransactionTest.assertEquals((int)1, (int)rsNonTx.getInt(1));
            TransactionTest.assertEquals((int)5, (int)rsNonTx.getInt(2));
            TransactionTest.assertEquals((int)1, (int)rsNonTx.getInt(3));
        }
        TransactionTest.assertEquals((int)1, (int)cntNonTx);
        ObserverForBug43152 observer = new ObserverForBug43152();
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)observer);
        conn.commit();
        TransactionTest.assertFalse((boolean)observer.wasMethodCalled());
    }

    public void testPkNonPkUpdates() throws Exception {
        String addr;
        int id;
        int i;
        Connection conn = TransactionTest.getConnection();
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1 (id int primary key, addr varchar(20))" + this.getSuffix());
        stmt.execute("create table t2 (id int, addr varchar(20))" + this.getSuffix());
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?, ?)");
        for (i = 0; i < 1000; ++i) {
            pstmt.setInt(1, i);
            pstmt.setString(2, "addr" + i);
            TransactionTest.assertEquals((int)1, (int)pstmt.executeUpdate());
        }
        pstmt = conn.prepareStatement("insert into t2 values(?, ?)");
        for (i = 0; i < 1000; ++i) {
            pstmt.setInt(1, i);
            pstmt.setString(2, "addr" + i);
            TransactionTest.assertEquals((int)1, (int)pstmt.executeUpdate());
        }
        conn.commit();
        pstmt = conn.prepareStatement("update t1 set addr = ? where id = ?");
        for (i = 100; i < 200; ++i) {
            pstmt.setString(1, "address" + i);
            pstmt.setInt(2, i);
            TransactionTest.assertEquals((int)1, (int)pstmt.executeUpdate());
        }
        pstmt = conn.prepareStatement("update t2 set addr = ? where id = ?");
        for (i = 100; i < 200; ++i) {
            pstmt.setString(1, "address" + i);
            pstmt.setInt(2, i);
            TransactionTest.assertEquals((int)1, (int)pstmt.executeUpdate());
        }
        TIntHashSet ids = new TIntHashSet(100);
        ids.clear();
        ResultSet rs = stmt.executeQuery("select * from t1 where id >= 100 and id < 200");
        while (rs.next()) {
            id = rs.getInt(1);
            addr = rs.getString(2);
            TransactionTest.assertFalse((String)("unexpected duplicate id=" + id), (boolean)ids.contains(id));
            TransactionTest.assertEquals((String)("address" + id), (String)addr);
            ids.add(id);
        }
        TransactionTest.assertEquals((int)100, (int)ids.size());
        ids.clear();
        rs = stmt.executeQuery("select * from t2 where id >= 100 and id < 200");
        while (rs.next()) {
            id = rs.getInt(1);
            addr = rs.getString(2);
            TransactionTest.assertFalse((String)("unexpected duplicate id=" + id), (boolean)ids.contains(id));
            TransactionTest.assertEquals((String)("address" + id), (String)addr);
            ids.add(id);
        }
        TransactionTest.assertEquals((int)100, (int)ids.size());
        conn.commit();
        rs = stmt.executeQuery("select * from t1 where id >= 100 and id < 200");
        ids.clear();
        while (rs.next()) {
            id = rs.getInt(1);
            addr = rs.getString(2);
            TransactionTest.assertFalse((String)("unexpected duplicate id=" + id), (boolean)ids.contains(id));
            TransactionTest.assertEquals((String)("address" + id), (String)addr);
            ids.add(id);
        }
        TransactionTest.assertEquals((int)100, (int)ids.size());
        ids.clear();
        rs = stmt.executeQuery("select * from t2 where id >= 100 and id < 200");
        while (rs.next()) {
            id = rs.getInt(1);
            addr = rs.getString(2);
            TransactionTest.assertFalse((String)("unexpected duplicate id=" + id), (boolean)ids.contains(id));
            TransactionTest.assertEquals((String)("address" + id), (String)addr);
            ids.add(id);
        }
        TransactionTest.assertEquals((int)100, (int)ids.size());
    }

    public void testExceptionAtCommit() throws Exception {
        Connection conn = TransactionTest.getConnection();
        conn.setAutoCommit(false);
        Statement stmt1 = conn.createStatement();
        stmt1.execute("create table BlogsStatsUser ( statsUserId bigint not null primary key,        groupId bigint, companyId bigint,userId bigint,  entryCount integer,     ratingsTotalEntries integer)" + this.getSuffix());
        stmt1.execute("create index IX1 on BlogsStatsUser (companyId, entryCount)");
        stmt1.execute("create index IX2 on BlogsStatsUser (companyId, ratingsTotalEntries)");
        stmt1.execute("create unique index IX3 on BlogsStatsUser (groupId, userId)");
        stmt1.execute("create index IX4 on BlogsStatsUser (groupId, ratingsTotalEntries)");
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement stmt = conn.createStatement();
        stmt.execute("insert into BlogsStatsUser values(1, 1, 1, 1, 1, 1)");
        stmt.execute("update BlogsStatsUser set groupId=1, companyId=10, userId=1, entryCount=1, ratingsTotalEntries=7 where statsUserId=1");
        conn.commit();
        stmt = conn.createStatement();
        stmt.execute("update BlogsStatsUser set groupId=3, companyId=3, userId=7, entryCount=50, ratingsTotalEntries=100 where statsUserId=1");
        conn.commit();
    }

    public void testOverflowTableWithNoEviction() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c_w_id int not null, c1 int not null , c2 int not null, primary key(c1)) partition by (c_w_id) redundancy 1  eviction by lruheappercent evictaction overflow  synchronous;");
        conn.commit();
        conn = TransactionTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        st = conn.createStatement();
        st.execute("insert into t1 values (5, 10, 15)");
        conn.commit();
        st.execute("update t1 set c2 = 16 where c_w_id=5");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from t1");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((int)5, (int)rs.getInt("c_w_id"));
        TransactionTest.assertEquals((int)10, (int)rs.getInt("c1"));
        TransactionTest.assertEquals((int)16, (int)rs.getInt("c2"));
        TransactionTest.assertFalse((boolean)rs.next());
    }

    public void testSelectOnOverflowTableWithEviction() throws Exception {
        Connection conn = TransactionTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c_w_id int not null, c1 int not null , c2 int not null, primary key(c1)) partition by (c_w_id) redundancy 1  eviction by lrucount 1 evictaction overflow  synchronous;");
        conn.commit();
        conn = TransactionTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        st = conn.createStatement();
        st.execute("insert into t1 values (5, 10, 15)");
        st.execute("insert into t1 values (5, 11, 16)");
        conn.commit();
        st.execute("update t1 set c2 = 17 where c_w_id=5");
        conn.commit();
        ResultSet rs = st.executeQuery("Select * from t1 order by c1");
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((int)5, (int)rs.getInt("c_w_id"));
        TransactionTest.assertEquals((int)10, (int)rs.getInt("c1"));
        TransactionTest.assertEquals((int)17, (int)rs.getInt("c2"));
        TransactionTest.assertTrue((boolean)rs.next());
        TransactionTest.assertEquals((int)5, (int)rs.getInt("c_w_id"));
        TransactionTest.assertEquals((int)11, (int)rs.getInt("c1"));
        TransactionTest.assertEquals((int)17, (int)rs.getInt("c2"));
        TransactionTest.assertFalse((boolean)rs.next());
    }

    public void testMultipleInsertFromThinClient_bug44242() throws Exception {
        TransactionTest.setupConnection();
        int port = TransactionTest.startNetserverAndReturnPort("create schema emp");
        for (int i = 0; i < 2; ++i) {
            Connection netConn1 = TestUtil.getNetConnection(port, null, null);
            Connection netConn2 = TestUtil.getNetConnection(port, null, null);
            Statement s = netConn1.createStatement();
            String ext = "";
            if (i == 1) {
                ext = "replicate";
            }
            s.execute("create table emp.EMPLOYEE_parent(lastname varchar(30) primary key, depId int)" + ext + this.getSuffix());
            s.execute("create table emp.EMPLOYEE(lastname varchar(30) primary key, depId int, foreign key(lastname) references emp.EMPLOYEE_parent(lastname) on delete restrict)" + ext + this.getSuffix());
            s.execute("insert into emp.EMPLOYEE_parent values('Jones', 10), ('Rafferty', 50), ('Robinson', 100)");
            netConn2.setTransactionIsolation(2);
            netConn2.setAutoCommit(false);
            Statement s2 = netConn2.createStatement();
            s2.execute("delete from emp.EMPLOYEE_parent");
            s2.execute("select * from emp.employee_parent");
            netConn1.setTransactionIsolation(2);
            netConn1.setAutoCommit(false);
            PreparedStatement pstmnt = netConn1.prepareStatement("INSERT INTO emp.employee VALUES (?, ?)");
            pstmnt.setString(1, "Jones");
            pstmnt.setInt(2, 33);
            pstmnt.addBatch();
            pstmnt.setString(1, "Rafferty");
            pstmnt.setInt(2, 31);
            pstmnt.addBatch();
            pstmnt.setString(1, "Robinson");
            pstmnt.setInt(2, 34);
            pstmnt.addBatch();
            try {
                pstmnt.executeBatch();
                netConn1.commit();
                TransactionTest.fail("commit should have failed");
            }
            catch (SQLException e) {
                TransactionTest.assertEquals((String)"X0Z02", (String)e.getSQLState());
            }
            netConn2.commit();
            s.execute("drop table emp.employee");
            this.waitTillAllClear();
            s.execute("drop table emp.employee_parent");
            this.waitTillAllClear();
        }
    }

    public void testBug44312() throws Exception {
        int id;
        int id2;
        TransactionTest.setupConnection();
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (cid int primary key, cust_name varchar(100) not null, tid int not null)" + this.getSuffix());
        for (id2 = 1; id2 <= 40; ++id2) {
            stmt.execute("insert into trade.customers values (" + id2 + ", 'cust" + id2 + "', " + id2 * 2 + ')');
        }
        conn.setTransactionIsolation(this.getIsolationLevel());
        for (id2 = 10; id2 <= 20; ++id2) {
            int updated = stmt.executeUpdate("delete from trade.customers where cid=" + id2 + " and tid <=" + id2);
            TransactionTest.assertEquals((int)0, (int)updated);
        }
        Connection conn2 = TestUtil.getConnection();
        conn2.setTransactionIsolation(this.getIsolationLevel());
        Statement stmt2 = conn2.createStatement();
        for (id = 5; id <= 15; ++id) {
            TransactionTest.assertEquals((int)1, (int)stmt2.executeUpdate("delete from trade.customers where cid=" + id));
        }
        conn2.commit();
        for (id = 5; id <= 15; ++id) {
            stmt.execute("insert into trade.customers values (" + id + ", 'cust" + id + "', " + id * 2 + ')');
        }
        conn.commit();
        for (id = 10; id <= 20; ++id) {
            int updated = stmt.executeUpdate("update trade.customers set cust_name='customer" + id + "' where cid=" + id + " and tid <=" + id);
            TransactionTest.assertEquals((int)0, (int)updated);
        }
        for (id = 5; id <= 15; ++id) {
            TransactionTest.assertEquals((int)1, (int)stmt2.executeUpdate("delete from trade.customers where cid=" + id));
        }
        conn2.commit();
        conn.commit();
        for (int id3 = 1; id3 <= 40; ++id3) {
            ResultSet rs = stmt.executeQuery("select cust_name, tid from trade.customers where cid=" + id3);
            if (id3 >= 5 && id3 <= 15) {
                TransactionTest.assertFalse((boolean)rs.next());
                continue;
            }
            TransactionTest.assertTrue((boolean)rs.next());
            TransactionTest.assertEquals((String)("cust" + id3), (String)rs.getString(1));
            TransactionTest.assertEquals((int)(id3 * 2), (int)rs.getInt(2));
            TransactionTest.assertFalse((boolean)rs.next());
        }
    }

    public void test45938() throws SQLException {
        Properties cp = new Properties();
        cp.setProperty("host-data", "true");
        cp.setProperty("mcast-port", String.valueOf(AvailablePort.getRandomAvailablePort((int)1)));
        Connection conn = TestUtil.getConnection(cp);
        Statement stmt = conn.createStatement();
        stmt.execute("create table customer (oid int, cid int, sid int, tid int, primary key(oid)) partition by column(cid, sid)");
        ResultSet rs = stmt.executeQuery("select count(*) from customer");
        rs.next();
        TransactionTest.assertEquals((int)0, (int)rs.getInt(1));
        rs.close();
        conn.setTransactionIsolation(2);
        PreparedStatement ps = conn.prepareStatement("insert into customer values (?, ?, ?, ?)");
        ps.setInt(1, 1);
        ps.setInt(2, 1);
        ps.setInt(3, 1);
        ps.setInt(4, 1);
        ps.execute();
        PreparedStatement dps = conn.prepareStatement("delete from customer where sid = ? and tid = ?");
        dps.setInt(1, 1);
        dps.setInt(2, 1);
        dps.execute();
        conn.commit();
        rs = stmt.executeQuery("select count(*) from customer");
        rs.next();
        TransactionTest.assertEquals((int)0, (int)rs.getInt(1));
        Region r = Misc.getRegionForTable((String)(Misc.getSchemaName(null, (LanguageConnectionContext)((EmbedConnection)conn).getLanguageConnection()) + ".customer".toUpperCase()), (boolean)true);
        TransactionTest.assertEquals((int)0, (int)r.size());
        rs.close();
    }

    public void testBug41168() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        conn.setTransactionIsolation(this.getIsolationLevel());
        stmt.execute("create table BinaryTree (id int primary key, leftId int, rightId int, depth int not null, foreign key (leftId) references BinaryTree(id), foreign key (rightId) references BinaryTree(id)) replicate" + this.getSuffix());
        TransactionTest.addExpectedException(SQLIntegrityConstraintViolationException.class);
        TransactionTest.doBinaryTreeChecks(conn, true);
        TransactionTest.removeExpectedException(SQLIntegrityConstraintViolationException.class);
        stmt.execute("drop table BinaryTree");
        this.waitTillAllClear();
        stmt.execute("create table BinaryTree (id int primary key, leftId int, rightId int, depth int not null, foreign key (leftId) references BinaryTree(id), foreign key (rightId) references BinaryTree(id))" + this.getSuffix());
        TransactionTest.addExpectedException(SQLIntegrityConstraintViolationException.class);
        TransactionTest.doBinaryTreeChecks(conn, true);
        TransactionTest.removeExpectedException(SQLIntegrityConstraintViolationException.class);
    }

    public void Debug_tests_43222() throws SQLException {
        Connection conn = TransactionTest.getConnection();
        Statement stmt = conn.createStatement();
        conn.setTransactionIsolation(this.getIsolationLevel());
        stmt.execute("create table warehouse (    w_id        integer   not null,    w_ytd       decimal(12,2),    w_tax       decimal(4,4),    w_name      varchar(10)) replicate" + this.getSuffix());
        stmt.execute("alter table warehouse add constraint pk_warehouse primary key (w_id)");
        stmt.execute("insert into warehouse values(1, 0.0, 0.0, 'name1'), (2, 0.2, 0.0, 'name2')");
        conn.commit();
        int i = stmt.executeUpdate("UPDATE warehouse SET w_ytd = w_ytd + 4998.73 WHERE w_id = 1");
        System.out.println(i);
        SQLNonTransientConnectionException ex = new SQLNonTransientConnectionException();
        System.out.println("ex.getSQLState returned: " + ex.getSQLState());
    }

    public static void doBinaryTreeChecks(Connection conn, boolean doSelfJoins) throws Exception {
        ResultSet rs;
        Statement stmt = conn.createStatement();
        conn.commit();
        stmt.execute("insert into BinaryTree values (3, null, null, 2)");
        stmt.execute("insert into BinaryTree values (2, null, null, 1)");
        stmt.execute("insert into BinaryTree values (1, 3, null, 1)");
        stmt.execute("insert into BinaryTree values (0, 1, 2, 0)");
        conn.commit();
        TransactionTest.checkFKViolation(stmt, "insert into BinaryTree values (4, 5, null, 2)");
        TransactionTest.checkFKViolation(stmt, "insert into BinaryTree values (5, null, 4, 2)");
        TransactionTest.checkFKViolation(stmt, "update BinaryTree set leftId=4 where id=2");
        TransactionTest.checkFKViolation(stmt, "update BinaryTree set rightId=5 where id=2");
        stmt.execute("insert into BinaryTree values (10, 10, 10, 3)");
        stmt.execute("insert into BinaryTree values (11, 10, 11, 4)");
        stmt.execute("insert into BinaryTree values (12, 11, 12, 3)");
        stmt.execute("insert into BinaryTree values (13, 13, 3, 4)");
        stmt.execute("insert into BinaryTree values (4, null, null, 2)");
        stmt.execute("insert into BinaryTree values (5, null, null, 2)");
        stmt.execute("update BinaryTree set leftId=4 where id=2");
        stmt.execute("update BinaryTree set rightId=5 where id=2");
        if (doSelfJoins) {
            rs = stmt.executeQuery("select t1.id from BinaryTree t1, BinaryTree t2 where t1.leftId = t2.id and t2.id = 3");
            TransactionTest.assertTrue((String)"expected one result", (boolean)rs.next());
            TransactionTest.assertEquals((int)1, (int)rs.getInt(1));
            TransactionTest.assertFalse((String)"expected one result", (boolean)rs.next());
            rs.close();
        }
        conn.commit();
        TransactionTest.checkFKViolation(stmt, "delete from BinaryTree where id=4");
        TransactionTest.checkFKViolation(stmt, "delete from BinaryTree where id=5");
        stmt.execute("delete from BinaryTree where id=13");
        TransactionTest.checkFKViolation(stmt, "delete from BinaryTree where id=11");
        stmt.execute("delete from BinaryTree where id=12");
        TransactionTest.checkFKViolation(stmt, "delete from BinaryTree where id=10");
        try {
            stmt.execute("update BinaryTree set depth=null where id=2");
        }
        catch (SQLException sqle) {
            TransactionTest.assertEquals((String)sqle.toString(), (String)"23502", (String)sqle.getSQLState());
        }
        stmt.execute("update BinaryTree set leftId=null where id=2");
        stmt.execute("update BinaryTree set rightId=null where id=2");
        stmt.execute("delete from BinaryTree where id=5");
        stmt.execute("delete from BinaryTree where id=4");
        if (doSelfJoins) {
            rs = stmt.executeQuery("select t1.id from BinaryTree t1, BinaryTree t2 where t1.leftId = t2.id and t2.id = 4");
            TransactionTest.assertFalse((String)"expected no result", (boolean)rs.next());
            rs = stmt.executeQuery("select t1.id from BinaryTree t1, BinaryTree t2 where t1.leftId = t2.id and t2.id = 5");
            TransactionTest.assertFalse((String)"expected no result", (boolean)rs.next());
            rs.close();
        }
        conn.commit();
    }

    public static void checkFKViolation(Statement stmt, String sql) throws SQLException {
        block2: {
            try {
                stmt.execute(sql);
                TransactionTest.fail("expected FK violation");
            }
            catch (SQLException sqle) {
                if ("23503".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
    }

    protected int getIsolationLevel() {
        return 2;
    }

    protected void checkConnCloseExceptionForReadsOnly(Connection conn) throws SQLException {
    }

    private void checkConflictsWithDifferentScanTypes(Statement stmt, int cid, TestUtil.ScanTypeQueryObserver observer) throws SQLException {
        block8: {
            block7: {
                block6: {
                    try {
                        stmt.execute("delete from trade.customers where cid = " + cid);
                        TransactionTest.fail("expected conflict exception");
                    }
                    catch (SQLException sqle) {
                        if ("X0Z02".equals(sqle.getSQLState())) break block6;
                        throw sqle;
                    }
                }
                observer.addExpectedScanType("trade.customers", TestUtil.ScanType.HASH1INDEX);
                observer.checkAndClear();
                try {
                    stmt.execute("delete from trade.customers where cid >= 10 and cid < 15");
                    TransactionTest.fail("expected conflict exception");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block7;
                    throw sqle;
                }
            }
            observer.addExpectedScanType("trade.customers", TestUtil.ScanType.TABLE);
            observer.checkAndClear();
            try {
                stmt.execute("delete from trade.customers where tid >= 10 and tid < 20");
                TransactionTest.fail("expected conflict exception");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) break block8;
                throw sqle;
            }
        }
        observer.addExpectedScanType("trade.customers", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
    }

    public void waitTillAllClear() {
    }

    protected String getSuffix() {
        return " ";
    }

    class ObserverForBug43152
    extends GemFireXDQueryObserverAdapter {
        private boolean methodCalled;

        ObserverForBug43152() {
        }

        public void callAtOldValueSameAsNewValueCheckInSM2IIOp() {
            this.methodCalled = true;
        }

        boolean wasMethodCalled() {
            return this.methodCalled;
        }
    }

    class CheckIndexOperations
    extends GemFireXDQueryObserverAdapter {
        int numInserts = 0;
        int numDeletes = 0;
        private final String indexName;

        private CheckIndexOperations(String name) {
            this.indexName = name;
        }

        public void keyAndContainerAfterLocalIndexInsert(Object key, Object rowLocation, GemFireContainer container) {
            TestCase.assertNotNull((Object)key);
            TestCase.assertNotNull((Object)rowLocation);
            TestCase.assertTrue((boolean)this.indexName.equalsIgnoreCase(container.getSchemaName() + "." + container.getTableName().toString()));
            ++this.numInserts;
        }

        public void keyAndContainerAfterLocalIndexDelete(Object key, Object rowLocation, GemFireContainer container) {
            TestCase.assertNotNull((Object)key);
            TestCase.assertNotNull((Object)rowLocation);
            TestCase.assertTrue((boolean)this.indexName.equalsIgnoreCase(container.getSchemaName() + "." + container.getTableName().toString()));
            ++this.numDeletes;
        }

        void checkNumInserts(int expected) {
            System.out.println("XXXX the number of call : " + this.numInserts);
            TestCase.assertEquals((int)expected, (int)this.numInserts);
        }

        void checkNumDeletes(int expected) {
            TestCase.assertEquals((int)expected, (int)this.numDeletes);
        }
    }
}

