/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.transactions;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapScanController;
import com.pivotal.gemfirexd.jdbc.transactions.TransactionTest;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;

public class TransactionRRTest
extends TransactionTest {
    public TransactionRRTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testTxnUpdateBehaviorForLocking() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch barrier = new CountDownLatch(2);
        final Connection childConn = TransactionRRTest.getConnection();
        Connection conn = TransactionRRTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("Create table t1 (c1 int not null primary key, qty int not null, c3 int not null, exchange varchar(20), c4 int not null, constraint C3_Unique unique (c3), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex')), constraint qty_ck check (qty >= 5))");
        stmt.execute("insert into t1 values(1, 10, 1, 'nye', 4), (2, 20, 2, 'amex', 4)");
        conn.commit();
        MemHeapScanController.setWaitObjectAfterFirstQualifyForTEST((CountDownLatch)latch);
        MemHeapScanController.setWaitBarrierBeforeFirstScanForTEST((CountDownLatch)barrier);
        MemHeapScanController.setWaitForLatchForTEST((int)0);
        try {
            Statement stmt2;
            Thread t;
            Exception[] ex;
            block7: {
                ex = new Exception[]{null};
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            childConn.setTransactionIsolation(TransactionRRTest.this.getIsolationLevel());
                            Statement cstmt = childConn.createStatement();
                            MemHeapScanController.setWaitForLatchForTEST((int)3);
                            cstmt.execute("update t1 set c4 = 40 where c4 = 4");
                            TransactionTest.updateCnt = cstmt.getUpdateCount();
                        }
                        catch (Exception e) {
                            ex[0] = e;
                        }
                        finally {
                            MemHeapScanController.setWaitForLatchForTEST((int)0);
                        }
                    }
                };
                t = new Thread(r);
                t.start();
                Connection conn2 = TransactionRRTest.getConnection();
                conn2.setTransactionIsolation(this.getIsolationLevel());
                conn2.setAutoCommit(false);
                stmt2 = conn2.createStatement();
                stmt2.execute("update t1 set c4 = 10");
                try {
                    conn2.commit();
                    TransactionRRTest.fail("expected conflict exception");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block7;
                    throw sqle;
                }
            }
            stmt2.execute("update t1 set c4 = 10");
            latch.countDown();
            t.join();
            TransactionRRTest.assertEquals((int)0, (int)updateCnt);
            TransactionRRTest.assertNotNull((Object)ex[0]);
            if (!(ex[0] instanceof SQLException)) {
                throw ex[0];
            }
            if (!"X0Z02".equals(((SQLException)ex[0]).getSQLState())) {
                throw ex[0];
            }
        }
        finally {
            MemHeapScanController.setWaitBarrierBeforeFirstScanForTEST(null);
            MemHeapScanController.setWaitObjectAfterFirstQualifyForTEST(null);
        }
        childConn.commit();
    }

    public void testBug44297_1() throws Exception {
        int id;
        int updated;
        Statement stmt2;
        Connection conn2;
        Statement stmt;
        Connection conn;
        block18: {
            block17: {
                block16: {
                    block15: {
                        TransactionRRTest.setupConnection();
                        conn = TestUtil.getConnection();
                        stmt = conn.createStatement();
                        stmt.execute("create table trade.customers (cid int primary key, cust_name varchar(100) not null, tid int not null)");
                        for (int id2 = 1; id2 <= 40; ++id2) {
                            stmt.execute("insert into trade.customers values (" + id2 + ", 'cust" + id2 + "', " + id2 * 2 + ')');
                        }
                        conn.setTransactionIsolation(this.getIsolationLevel());
                        conn.setAutoCommit(false);
                        TransactionRRTest.assertEquals((int)1, (int)stmt.executeUpdate("update trade.customers set cust_name='cust1' where cid = 2 and tid <= 100"));
                        ResultSet rs = stmt.executeQuery("select * from trade.customers where tid > 8 and cid > 9 and cid < 11");
                        TransactionRRTest.assertTrue((boolean)rs.next());
                        TransactionRRTest.assertEquals((int)10, (int)rs.getInt(1));
                        TransactionRRTest.assertEquals((int)20, (int)rs.getInt(3));
                        TransactionRRTest.assertFalse((boolean)rs.next());
                        conn2 = TestUtil.getConnection();
                        conn2.setTransactionIsolation(this.getIsolationLevel());
                        conn2.setAutoCommit(false);
                        stmt2 = conn2.createStatement();
                        for (int id3 = 5; id3 <= 15; ++id3) {
                            TransactionRRTest.assertEquals((int)1, (int)stmt2.executeUpdate("delete from trade.customers where cid=" + id3));
                        }
                        try {
                            conn2.commit();
                            TransactionRRTest.fail("expected a conflict exception");
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) break block15;
                            throw sqle;
                        }
                    }
                    TransactionRRTest.assertEquals((int)32, (int)stmt2.executeUpdate("delete from trade.customers where cid > 8"));
                    try {
                        conn2.commit();
                        TransactionRRTest.fail("expected a conflict exception");
                    }
                    catch (SQLException sqle) {
                        if ("X0Z02".equals(sqle.getSQLState())) break block16;
                        throw sqle;
                    }
                }
                for (int id4 = 10; id4 <= 20; ++id4) {
                    updated = stmt2.executeUpdate("update trade.customers set cust_name='customer" + id4 + "' where cid=" + id4 + " and tid >=" + id4);
                    TransactionRRTest.assertEquals((int)1, (int)updated);
                }
                try {
                    conn2.commit();
                    TransactionRRTest.fail("expected a conflict exception");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block17;
                    throw sqle;
                }
            }
            TransactionRRTest.assertEquals((int)32, (int)stmt2.executeUpdate("update trade.customers set cust_name='cust' where cid > 8"));
            try {
                conn2.commit();
                TransactionRRTest.fail("expected a conflict exception");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) break block18;
                throw sqle;
            }
        }
        conn.commit();
        for (id = 5; id <= 15; ++id) {
            TransactionRRTest.assertEquals((int)1, (int)stmt2.executeUpdate("delete from trade.customers where cid=" + id));
        }
        conn2.commit();
        for (id = 5; id <= 15; ++id) {
            stmt.execute("insert into trade.customers values (" + id + ", 'cust" + id + "', " + id * 2 + ')');
        }
        conn.commit();
        TransactionRRTest.assertEquals((int)32, (int)stmt2.executeUpdate("delete from trade.customers where cid > 8"));
        conn2.commit();
        for (id = 9; id <= 40; ++id) {
            stmt.execute("insert into trade.customers values (" + id + ", 'cust" + id + "', " + id * 2 + ')');
        }
        conn.commit();
        for (id = 10; id <= 20; ++id) {
            updated = stmt2.executeUpdate("update trade.customers set cust_name='customer" + id + "' where cid=" + id + " and tid >=" + id);
            TransactionRRTest.assertEquals((int)1, (int)updated);
        }
        conn2.commit();
        TransactionRRTest.assertEquals((int)32, (int)stmt2.executeUpdate("update trade.customers set cust_name='cust' where cid > 8"));
        conn2.commit();
        conn2.commit();
        conn.commit();
    }

    public void testBug44297_2() throws Exception {
        int id;
        int updated;
        Statement stmt2;
        Connection conn2;
        Statement stmt;
        Connection conn;
        block18: {
            block17: {
                block16: {
                    block15: {
                        TransactionRRTest.setupConnection();
                        conn = TestUtil.getConnection();
                        stmt = conn.createStatement();
                        stmt.execute("create table trade.customers (cid int primary key, cust_name varchar(100) not null, tid int not null)");
                        for (int id2 = 1; id2 <= 40; ++id2) {
                            stmt.execute("insert into trade.customers values (" + id2 + ", 'cust" + id2 + "', " + id2 * 2 + ')');
                        }
                        conn.setTransactionIsolation(this.getIsolationLevel());
                        conn.setAutoCommit(false);
                        TransactionRRTest.assertEquals((int)1, (int)stmt.executeUpdate("update trade.customers set cust_name='cust1' where cid = 2 and tid <= 100"));
                        ResultSet rs = stmt.executeQuery("select * from trade.customers where tid > 8 and cid=10");
                        TransactionRRTest.assertTrue((boolean)rs.next());
                        TransactionRRTest.assertEquals((int)10, (int)rs.getInt(1));
                        TransactionRRTest.assertEquals((int)20, (int)rs.getInt(3));
                        TransactionRRTest.assertFalse((boolean)rs.next());
                        conn2 = TestUtil.getConnection();
                        conn2.setTransactionIsolation(this.getIsolationLevel());
                        conn2.setAutoCommit(false);
                        stmt2 = conn2.createStatement();
                        for (int id3 = 5; id3 <= 15; ++id3) {
                            TransactionRRTest.assertEquals((int)1, (int)stmt2.executeUpdate("delete from trade.customers where cid=" + id3));
                        }
                        try {
                            conn2.commit();
                            TransactionRRTest.fail("expected a conflict exception");
                        }
                        catch (SQLException sqle) {
                            if ("X0Z02".equals(sqle.getSQLState())) break block15;
                            throw sqle;
                        }
                    }
                    TransactionRRTest.assertEquals((int)32, (int)stmt2.executeUpdate("delete from trade.customers where cid > 8"));
                    try {
                        conn2.commit();
                        TransactionRRTest.fail("expected a conflict exception");
                    }
                    catch (SQLException sqle) {
                        if ("X0Z02".equals(sqle.getSQLState())) break block16;
                        throw sqle;
                    }
                }
                for (int id4 = 10; id4 <= 20; ++id4) {
                    updated = stmt2.executeUpdate("update trade.customers set cust_name='customer" + id4 + "' where cid=" + id4 + " and tid >=" + id4);
                    TransactionRRTest.assertEquals((int)1, (int)updated);
                }
                try {
                    conn2.commit();
                    TransactionRRTest.fail("expected a conflict exception");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block17;
                    throw sqle;
                }
            }
            TransactionRRTest.assertEquals((int)32, (int)stmt2.executeUpdate("update trade.customers set cust_name='cust' where cid > 8"));
            try {
                conn2.commit();
                TransactionRRTest.fail("expected a conflict exception");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) break block18;
                throw sqle;
            }
        }
        conn.commit();
        for (id = 5; id <= 15; ++id) {
            TransactionRRTest.assertEquals((int)1, (int)stmt2.executeUpdate("delete from trade.customers where cid=" + id));
        }
        conn2.commit();
        for (id = 5; id <= 15; ++id) {
            stmt.execute("insert into trade.customers values (" + id + ", 'cust" + id + "', " + id * 2 + ')');
        }
        conn.commit();
        TransactionRRTest.assertEquals((int)32, (int)stmt2.executeUpdate("delete from trade.customers where cid > 8"));
        conn2.commit();
        for (id = 9; id <= 40; ++id) {
            stmt.execute("insert into trade.customers values (" + id + ", 'cust" + id + "', " + id * 2 + ')');
        }
        conn.commit();
        for (id = 10; id <= 20; ++id) {
            updated = stmt2.executeUpdate("update trade.customers set cust_name='customer" + id + "' where cid=" + id + " and tid >=" + id);
            TransactionRRTest.assertEquals((int)1, (int)updated);
        }
        conn2.commit();
        TransactionRRTest.assertEquals((int)32, (int)stmt2.executeUpdate("update trade.customers set cust_name='cust' where cid > 8"));
        conn2.commit();
        conn2.commit();
        conn.commit();
    }

    public void testBug44297_3() throws Exception {
        Statement stmt2;
        Connection conn2;
        Connection conn;
        block4: {
            TransactionRRTest.setupConnection();
            conn = TestUtil.getConnection();
            Statement stmt = conn.createStatement();
            stmt.execute("create table trade.networth (cid int not null, cash decimal (30, 1), securities decimal (30, 1), loanlimit int, availloan decimal (30, 1),  tid int, constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))");
            for (int id = 650; id <= 700; ++id) {
                stmt.execute("insert into trade.networth values (" + id + ", " + id * 50 + ", " + id * 10 + ", " + id * 20 + ", " + id * 20 + ", 5)");
            }
            conn.setTransactionIsolation(this.getIsolationLevel());
            conn.setAutoCommit(false);
            TransactionRRTest.assertEquals((int)51, (int)stmt.executeUpdate("update trade.networth set availloan = 10500 where tid = 5"));
            conn.commit();
            ResultSet rs = stmt.executeQuery("select cid, loanlimit, availloan from trade.networth where (loanlimit > 5000 and loanlimit-availloan <= 3000) and tid = 5");
            int numResults = 0;
            while (rs.next()) {
                ++numResults;
            }
            TransactionRRTest.assertEquals((int)26, (int)numResults);
            conn2 = TestUtil.getConnection();
            conn2.setTransactionIsolation(this.getIsolationLevel());
            conn2.setAutoCommit(false);
            stmt2 = conn2.createStatement();
            TransactionRRTest.assertEquals((int)1, (int)stmt2.executeUpdate("delete from trade.networth where cid=650"));
            try {
                conn2.commit();
                TransactionRRTest.fail("expected a conflict exception");
            }
            catch (SQLException sqle) {
                if ("X0Z02".equals(sqle.getSQLState())) break block4;
                throw sqle;
            }
        }
        TransactionRRTest.assertEquals((int)1, (int)stmt2.executeUpdate("delete from trade.networth where cid=700"));
        conn2.commit();
        conn.commit();
        TransactionRRTest.assertEquals((int)1, (int)stmt2.executeUpdate("delete from trade.networth where cid=650"));
        conn2.commit();
    }

    @Override
    protected int getIsolationLevel() {
        return 4;
    }

    @Override
    protected void checkConnCloseExceptionForReadsOnly(Connection conn) throws SQLException {
        block2: {
            try {
                conn.close();
                TransactionRRTest.fail("expected connection active exception in close");
            }
            catch (SQLException e) {
                String state = e.getSQLState();
                if (state.equals("25001")) break block2;
                throw e;
            }
        }
    }
}

