/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.transactions;

import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;

public class SelectForUpdateTest
extends JdbcTestBase {
    private volatile boolean callbackInvoked;
    private HashMap<Object, Object> keyMap;

    public SelectForUpdateTest(String name) {
        super(name);
    }

    public void testSelectForUpdate_whereCurrentOFUnsupported_fromClient() throws Exception {
        SelectForUpdateTest.setupConnection();
        Connection conn = SelectForUpdateTest.startNetserverAndGetLocalNetConnection();
        this.runWhereCurrentOf(conn);
    }

    public void testSelectForUpdate_whereCurrentOFUnsupported() throws Exception {
        Connection conn = TestUtil.getConnection();
        this.runWhereCurrentOf(conn);
    }

    private void runWhereCurrentOf(Connection conn) throws SQLException {
        block2: {
            Statement stmtForTableAndInsert = conn.createStatement();
            stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname))");
            stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
            conn.setTransactionIsolation(this.getIsolationLevel());
            PreparedStatement ps = conn.prepareStatement("SELECT workdept, bonus FROM EMPLOYEE FOR UPDATE of workdept");
            ps.setCursorName("C1");
            ps.executeQuery();
            try {
                conn.prepareStatement("update employee set workdept = ? where current of C1");
                SelectForUpdateTest.fail("exception expected");
            }
            catch (SQLException e) {
                if ("0A000".equalsIgnoreCase(e.getSQLState())) break block2;
                throw e;
            }
        }
    }

    public void testSelectForUpdateDirectDelete() throws Exception {
        Connection conn = TestUtil.getConnection();
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(0);
        Statement stmtForTableAndInsert = conn.createStatement();
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname))");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        Statement stmt = conn.createStatement(1003, 1008, 2);
        ResultSet uprs = stmt.executeQuery("SELECT workdept, bonus FROM EMPLOYEE FOR UPDATE of BONUS");
        while (uprs.next()) {
            uprs.deleteRow();
        }
        SQLWarning w = uprs.getWarnings();
        SelectForUpdateTest.assertTrue((boolean)"0A000".equals(w.getSQLState()));
        uprs.close();
        Statement stmt2 = conn.createStatement();
        ResultSet rs = stmt2.executeQuery("select * from employee");
        w = rs.getWarnings();
        SelectForUpdateTest.assertNull((Object)w);
        rs = stmt2.executeQuery("select * from employee");
        SelectForUpdateTest.assertFalse((boolean)rs.next());
        conn.setTransactionIsolation(this.getIsolationLevel());
        stmt = conn.createStatement(1003, 1008, 2);
        stmt.execute("insert into employee values('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        uprs = stmt.executeQuery("SELECT * FROM EMPLOYEE FOR UPDATE of BONUS");
        while (uprs.next()) {
            if (!uprs.getString(1).equalsIgnoreCase("asif")) continue;
            uprs.deleteRow();
        }
        w = uprs.getWarnings();
        SelectForUpdateTest.assertNull((Object)w);
        uprs.close();
        conn.commit();
        stmt2 = conn.createStatement();
        rs = stmt2.executeQuery("select * from employee");
        w = rs.getWarnings();
        SelectForUpdateTest.assertNull((Object)w);
        SelectForUpdateTest.assertTrue((boolean)rs.next());
        SelectForUpdateTest.assertTrue((rs.getString(1).equalsIgnoreCase("sum") || rs.getString(1).equalsIgnoreCase("dada") ? 1 : 0) != 0);
        SelectForUpdateTest.assertTrue((boolean)rs.next());
        SelectForUpdateTest.assertTrue((rs.getString(1).equalsIgnoreCase("sum") || rs.getString(1).equalsIgnoreCase("dada") ? 1 : 0) != 0);
        SelectForUpdateTest.assertFalse((boolean)rs.next());
    }

    public void testSelectForUpdateWarningsFromClient() throws Exception {
        SelectForUpdateTest.setupConnection();
        Connection conn = SelectForUpdateTest.startNetserverAndGetLocalNetConnection();
        this.runSelectForUpdateWarnings(conn, true);
    }

    public void testSelectForUpdateWarnings() throws Exception {
        Connection conn = SelectForUpdateTest.getConnection();
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(0);
        this.runSelectForUpdateWarnings(conn, false);
    }

    protected void runSelectForUpdateWarnings(Connection conn, boolean notImplemented) throws Exception {
        BigDecimal bonus;
        Statement stmtForTableAndInsert = conn.createStatement();
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname))");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        Statement stmt = conn.createStatement(1003, 1008, 2);
        ResultSet uprs = stmt.executeQuery("SELECT workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS");
        while (uprs.next()) {
            uprs.getString("WORKDEPT");
            BigDecimal bonus2 = uprs.getBigDecimal("BONUS");
            if (notImplemented) {
                block8: {
                    try {
                        uprs.updateBigDecimal("BONUS", bonus2.add(BigDecimal.valueOf(250L)));
                        uprs.updateRow();
                        SelectForUpdateTest.fail("expected not implemented exception");
                    }
                    catch (SQLException sqle) {
                        if ("0A000".equals(sqle.getSQLState())) break block8;
                        throw sqle;
                    }
                }
                return;
            }
            uprs.updateBigDecimal("BONUS", bonus2.add(BigDecimal.valueOf(250L)));
            uprs.updateRow();
        }
        SQLWarning w = uprs.getWarnings();
        SelectForUpdateTest.assertTrue((boolean)"0A000".equals(w.getSQLState()));
        uprs.close();
        Statement stmt2 = conn.createStatement();
        ResultSet rs = stmt2.executeQuery("select * from employee");
        w = rs.getWarnings();
        SelectForUpdateTest.assertNull((Object)w);
        conn.commit();
        stmt.executeUpdate("update Employee set bonus = 1000 where lastname <> 'kumar'");
        w = stmt.getWarnings();
        SelectForUpdateTest.assertNull((Object)rs.getWarnings());
        stmt2.executeUpdate("update Employee set bonus = bonus + 1000 where lastname <> 'kumar'");
        w = stmt2.getWarnings();
        SelectForUpdateTest.assertNull((Object)w);
        PreparedStatement ps = conn.prepareStatement("SELECT workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS", 1003, 1008);
        ps.execute();
        ResultSet prs = ps.getResultSet();
        while (prs.next()) {
            prs.getString("WORKDEPT");
            bonus = prs.getBigDecimal("BONUS");
            prs.updateBigDecimal("BONUS", bonus.add(BigDecimal.valueOf(1250L)));
            prs.updateRow();
        }
        w = prs.getWarnings();
        SelectForUpdateTest.assertTrue((boolean)"0A000".equals(w.getSQLState()));
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.setAutoCommit(false);
        conn.createStatement(1003, 1008, 2);
        uprs = stmt.executeQuery("SELECT workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS");
        while (uprs.next()) {
            uprs.getString("WORKDEPT");
            bonus = uprs.getBigDecimal("BONUS");
            uprs.updateBigDecimal("BONUS", bonus.add(BigDecimal.valueOf(250L)));
            uprs.updateRow();
        }
        w = uprs.getWarnings();
        SelectForUpdateTest.assertNull((Object)w);
        uprs.close();
        stmt2 = conn.createStatement();
        rs = stmt2.executeQuery("select * from employee");
        w = rs.getWarnings();
        SelectForUpdateTest.assertNull((Object)w);
        conn.commit();
        stmt.executeUpdate("update Employee set bonus = 1000 where lastname <> 'kumar'");
        w = stmt.getWarnings();
        SelectForUpdateTest.assertNull((Object)rs.getWarnings());
        stmt2.executeUpdate("update Employee set bonus = bonus + 1000 where lastname <> 'kumar'");
        w = stmt2.getWarnings();
        SelectForUpdateTest.assertNull((Object)w);
        ps = conn.prepareStatement("SELECT workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS", 1003, 1008);
        ps.execute();
        prs = ps.getResultSet();
        while (prs.next()) {
            prs.getString("WORKDEPT");
            bonus = prs.getBigDecimal("BONUS");
            prs.updateBigDecimal("BONUS", bonus.add(BigDecimal.valueOf(1250L)));
            prs.updateRow();
        }
        w = prs.getWarnings();
        SelectForUpdateTest.assertNull((Object)w);
        rs = stmt2.executeQuery("select * from employee");
        while (rs.next()) {
            System.out.println(rs.getObject(1) + ", " + rs.getObject(2) + ", " + rs.getObject(3) + ", " + rs.getObject(4));
        }
    }

    public void _testSelectForUpdateForDebugging() throws Exception {
        Connection conn = SelectForUpdateTest.getConnection();
        Statement stmtForTableAndInsert = conn.createStatement();
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname))");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement stmt = conn.createStatement(1003, 1008, 2);
        ResultSet uprs = stmt.executeQuery("SELECT workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS");
        while (uprs.next()) {
            uprs.getString("WORKDEPT");
            BigDecimal bonus = uprs.getBigDecimal("BONUS");
            uprs.updateBigDecimal("BONUS", bonus.add(BigDecimal.valueOf(250L)));
            uprs.updateRow();
        }
        conn.commit();
        uprs.close();
        ResultSet rs = stmt.executeQuery("select * from employee");
        while (rs.next()) {
            System.out.println(rs.getString(1) + ", " + rs.getString(2) + ", " + rs.getString(3) + ", " + rs.getBigDecimal(4));
        }
        conn.commit();
        stmt.close();
        conn.close();
    }

    public void testSelectForUpdateIndexScanFromClient() throws Exception {
        SelectForUpdateTest.setupConnection();
        Connection conn = SelectForUpdateTest.startNetserverAndGetLocalNetConnection();
        this.runSelectForUpdateIndexScan(conn);
    }

    public void testSelectForUpdateIndexScan() throws Exception {
        Connection conn = SelectForUpdateTest.getConnection();
        this.runSelectForUpdateIndexScan(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSelectForUpdateIndexScan(Connection conn) throws Exception {
        DataValueDescriptor[] dvds;
        CompactCompositeRegionKey ckey;
        ResultSet rs;
        String query;
        Statement stmtForTableAndInsert = conn.createStatement();
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname)) replicate");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        stmtForTableAndInsert.execute("create index lastNameIdx on Employee(lastname)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.createStatement(1003, 1008, 2);
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            rs = stmtForTableAndInsert.executeQuery(query);
            while (rs.next()) {
            }
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
            SelectForUpdateTest.assertNotNull(this.keyMap);
        }
        finally {
            this.callbackInvoked = false;
            if (this.keyMap != null) {
                SelectForUpdateTest.assertEquals((int)1, (int)this.keyMap.size());
                ckey = (CompactCompositeRegionKey)this.keyMap.keySet().iterator().next();
                dvds = new DataValueDescriptor[ckey.nCols()];
                ckey.getKeyColumns(dvds);
                SelectForUpdateTest.assertEquals((String)"neeraj", (String)dvds[0].getString());
                SelectForUpdateTest.assertEquals((String)"kumar", (String)dvds[1].getString());
                this.keyMap = null;
            }
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop index APP.LASTNAMEIDX");
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname))");
        stmtForTableAndInsert.execute("create index lastNameIdx on Employee(lastname)");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.createStatement(1003, 1008, 2);
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            rs = stmtForTableAndInsert.executeQuery(query);
            while (rs.next()) {
            }
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            SelectForUpdateTest.assertEquals((int)1, (int)this.keyMap.size());
            ckey = (CompactCompositeRegionKey)this.keyMap.keySet().iterator().next();
            dvds = new DataValueDescriptor[ckey.nCols()];
            ckey.getKeyColumns(dvds);
            SelectForUpdateTest.assertEquals((String)"neeraj", (String)dvds[0].getString());
            SelectForUpdateTest.assertEquals((String)"kumar", (String)dvds[1].getString());
            this.keyMap = null;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop index lastNameIdx");
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname))");
        stmtForTableAndInsert.execute("create index lastNameIdx on Employee(lastname)");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.createStatement(1003, 1008, 2);
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
            query = "SELECT firstname, bonus FROM EMPLOYEE where lastname <> 'kumar' FOR UPDATE of BONUS";
            rs = stmtForTableAndInsert.executeQuery(query);
            while (rs.next()) {
            }
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
            SelectForUpdateTest.assertNotNull(this.keyMap);
        }
        finally {
            this.callbackInvoked = false;
            if (this.keyMap != null) {
                SelectForUpdateTest.assertEquals((int)3, (int)this.keyMap.size());
                this.keyMap = null;
            }
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop index lastNameIdx");
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname)) replicate");
        stmtForTableAndInsert.execute("create index lastNameIdx on Employee(lastname)");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.createStatement(1003, 1008, 2);
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
            query = "SELECT * FROM EMPLOYEE where lastname <> 'kumar' FOR UPDATE of BONUS";
            rs = stmtForTableAndInsert.executeQuery(query);
            while (rs.next()) {
            }
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
            SelectForUpdateTest.assertNotNull(this.keyMap);
        }
        finally {
            this.callbackInvoked = false;
            if (this.keyMap != null) {
                SelectForUpdateTest.assertEquals((int)3, (int)this.keyMap.size());
                this.keyMap = null;
            }
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop index lastNameIdx");
            stmtForTableAndInsert.execute("drop table Employee");
        }
    }

    public void testSelectForUpdateHeapScanFromClient() throws Exception {
        SelectForUpdateTest.setupConnection();
        Connection conn = SelectForUpdateTest.startNetserverAndGetLocalNetConnection();
        this.runSelectForUpdateHeapScan(conn);
    }

    public void testSelectForUpdateHeapScan() throws Exception {
        Connection conn = SelectForUpdateTest.getConnection();
        this.runSelectForUpdateHeapScan(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSelectForUpdateHeapScan(Connection conn) throws Exception {
        DataValueDescriptor[] dvds;
        CompactCompositeRegionKey ckey;
        ResultSet rs;
        String query;
        Statement stmtForTableAndInsert = conn.createStatement();
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname)) replicate");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.createStatement(1003, 1008, 2);
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            rs = stmtForTableAndInsert.executeQuery(query);
            while (rs.next()) {
            }
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            SelectForUpdateTest.assertEquals((int)1, (int)this.keyMap.size());
            ckey = (CompactCompositeRegionKey)this.keyMap.keySet().iterator().next();
            dvds = new DataValueDescriptor[ckey.nCols()];
            ckey.getKeyColumns(dvds);
            SelectForUpdateTest.assertEquals((String)"neeraj", (String)dvds[0].getString());
            SelectForUpdateTest.assertEquals((String)"kumar", (String)dvds[1].getString());
            this.keyMap = null;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname))");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.createStatement(1003, 1008, 2);
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            rs = stmtForTableAndInsert.executeQuery(query);
            while (rs.next()) {
            }
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            SelectForUpdateTest.assertEquals((int)1, (int)this.keyMap.size());
            ckey = (CompactCompositeRegionKey)this.keyMap.keySet().iterator().next();
            dvds = new DataValueDescriptor[ckey.nCols()];
            ckey.getKeyColumns(dvds);
            SelectForUpdateTest.assertEquals((String)"neeraj", (String)dvds[0].getString());
            SelectForUpdateTest.assertEquals((String)"kumar", (String)dvds[1].getString());
            this.keyMap = null;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname))");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.createStatement(1003, 1008, 2);
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
            query = "SELECT * FROM EMPLOYEE where lastname <> 'kumar' FOR UPDATE of BONUS";
            rs = stmtForTableAndInsert.executeQuery(query);
            while (rs.next()) {
            }
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            SelectForUpdateTest.assertEquals((int)3, (int)this.keyMap.size());
            this.keyMap = null;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname)) replicate");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        conn.commit();
        conn.setTransactionIsolation(this.getIsolationLevel());
        conn.createStatement(1003, 1008, 2);
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
            query = "SELECT * FROM EMPLOYEE where lastname <> 'kumar' FOR UPDATE of BONUS";
            rs = stmtForTableAndInsert.executeQuery(query);
            while (rs.next()) {
            }
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            SelectForUpdateTest.assertEquals((int)3, (int)this.keyMap.size());
            this.keyMap = null;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop table Employee");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectForUpdateCasesForSelectQueryInfoState() throws Exception {
        String query;
        Connection conn = SelectForUpdateTest.getConnection();
        Statement stmtForTableAndInsert = conn.createStatement(1003, 1008, 2);
        conn.setTransactionIsolation(this.getIsolationLevel());
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4), primary key (firstname)) replicate");
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectForUpdateTest.this.callbackInvoked = true;
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isSelectForUpdateCase());
                        TestCase.assertFalse((boolean)sqi.needKeysForSelectForUpdate());
                        TestCase.assertFalse((boolean)sqi.isRoutingCalculationRequired());
                        int[] cols = sqi.getPartitioningColumnFromProjection();
                        TestCase.assertNull((Object)cols);
                    }
                }
            });
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            stmtForTableAndInsert.executeQuery(query);
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            stmtForTableAndInsert.execute("drop table Employee");
            conn.commit();
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4), primary key (firstname)) partition by primary key");
        old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectForUpdateTest.this.callbackInvoked = true;
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isSelectForUpdateCase());
                        TestCase.assertFalse((boolean)sqi.needKeysForSelectForUpdate());
                        TestCase.assertFalse((boolean)sqi.isRoutingCalculationRequired());
                        int[] cols = sqi.getPartitioningColumnFromProjection();
                        TestCase.assertNull((Object)cols);
                    }
                }
            });
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            stmtForTableAndInsert.executeQuery(query);
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4), primary key (firstname, lastname)) partition by primary key");
        old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectForUpdateTest.this.callbackInvoked = true;
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isSelectForUpdateCase());
                        TestCase.assertFalse((boolean)sqi.needKeysForSelectForUpdate());
                        TestCase.assertFalse((boolean)sqi.isRoutingCalculationRequired());
                        int[] cols = sqi.getPartitioningColumnFromProjection();
                        TestCase.assertNull((Object)cols);
                    }
                }
            });
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            stmtForTableAndInsert.executeQuery(query);
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4), primary key (firstname))");
        old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectForUpdateTest.this.callbackInvoked = true;
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isSelectForUpdateCase());
                        TestCase.assertFalse((boolean)sqi.needKeysForSelectForUpdate());
                        TestCase.assertFalse((boolean)sqi.isRoutingCalculationRequired());
                        int[] cols = sqi.getPartitioningColumnFromProjection();
                        TestCase.assertNull((Object)cols);
                    }
                }
            });
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            stmtForTableAndInsert.executeQuery(query);
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4), primary key (firstname, lastname))");
        old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectForUpdateTest.this.callbackInvoked = true;
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isSelectForUpdateCase());
                        TestCase.assertFalse((boolean)sqi.needKeysForSelectForUpdate());
                        TestCase.assertFalse((boolean)sqi.isRoutingCalculationRequired());
                        int[] cols = sqi.getPartitioningColumnFromProjection();
                        TestCase.assertNull((Object)cols);
                    }
                }
            });
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            stmtForTableAndInsert.executeQuery(query);
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            stmtForTableAndInsert.execute("drop table Employee");
            conn.commit();
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4), primary key (firstname, lastname)) partition by column(lastname, firstname)");
        old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectForUpdateTest.this.callbackInvoked = true;
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isSelectForUpdateCase());
                        TestCase.assertFalse((boolean)sqi.needKeysForSelectForUpdate());
                        TestCase.assertFalse((boolean)sqi.isRoutingCalculationRequired());
                        int[] cols = sqi.getPartitioningColumnFromProjection();
                        TestCase.assertNull((Object)cols);
                    }
                }
            });
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            stmtForTableAndInsert.executeQuery(query);
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            stmtForTableAndInsert.execute("drop table Employee");
            conn.commit();
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4), primary key (firstname, lastname)) partition by list(lastname) (values('kumar', 'ji'))");
        old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectForUpdateTest.this.callbackInvoked = true;
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isSelectForUpdateCase());
                        TestCase.assertFalse((boolean)sqi.needKeysForSelectForUpdate());
                        sqi.getPartitioningColumnFromProjection();
                    }
                }
            });
            query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            stmtForTableAndInsert.executeQuery(query);
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4), primary key (firstname)) partition by list(lastname) (values('kumar', 'ji'))");
        old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectForUpdateTest.this.callbackInvoked = true;
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isSelectForUpdateCase());
                        TestCase.assertFalse((boolean)sqi.needKeysForSelectForUpdate());
                        TestCase.assertTrue((boolean)sqi.isRoutingCalculationRequired());
                        int[] cols = sqi.getPartitioningColumnFromProjection();
                        TestCase.assertNull((Object)cols);
                    }
                }
            });
            query = "SELECT firstname, workdept FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            stmtForTableAndInsert.executeQuery(query);
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            stmtForTableAndInsert.execute("drop table Employee");
            conn.commit();
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4)) partition by column(lastname, firstname)");
        old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo) {
                        SelectForUpdateTest.this.callbackInvoked = true;
                        SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                        TestCase.assertTrue((boolean)sqi.isSelectForUpdateCase());
                        TestCase.assertTrue((boolean)sqi.needKeysForSelectForUpdate());
                        TestCase.assertTrue((boolean)sqi.isRoutingCalculationRequired());
                        int[] cols = sqi.getPartitioningColumnFromProjection();
                        TestCase.assertNull((Object)cols);
                    }
                }
            });
            query = "SELECT firstname, workdept, bonus FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
            stmtForTableAndInsert.executeQuery(query);
            SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            conn.commit();
            stmtForTableAndInsert.execute("drop table Employee");
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4), primary key (firstname)) partition by list(lastname) (values('kumar', 'ji'))");
        query = "SELECT firstname, workdept FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of firstname";
        boolean gotexception = false;
        try {
            stmtForTableAndInsert.execute(query);
        }
        catch (SQLException e) {
            e.getSQLState().equals("0A000");
            gotexception = true;
            stmtForTableAndInsert.execute("drop table Employee");
        }
        SelectForUpdateTest.assertTrue((boolean)gotexception);
        gotexception = false;
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50) not null, bonus decimal(10,4), primary key (firstname)) partition by list(lastname) (values('kumar', 'ji'))");
        query = "SELECT firstname, workdept FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of lastname";
        try {
            stmtForTableAndInsert.execute(query);
        }
        catch (SQLException e) {
            e.getSQLState().equals("0A000");
            gotexception = true;
            stmtForTableAndInsert.execute("drop table Employee");
        }
        conn.commit();
        stmtForTableAndInsert.close();
        conn.close();
    }

    public void testSelectForUpdateLockingFromClient() throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", String.valueOf(AvailablePort.getRandomAvailablePort((int)1)));
        SelectForUpdateTest.setupConnection(props);
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        SelectForUpdateTest.startNetServer(netPort, null);
        Connection conn1 = SelectForUpdateTest.getNetConnection(netPort, null, null);
        Connection conn2 = SelectForUpdateTest.getNetConnection(netPort, null, null);
        this.runSelectForUpdateLocking(conn1, conn2);
    }

    public void testSelectForUpdateLocking() throws Exception {
        Connection conn1 = SelectForUpdateTest.getConnection();
        Connection conn2 = SelectForUpdateTest.getConnection();
        this.runSelectForUpdateLocking(conn1, conn2);
    }

    protected int getIsolationLevel() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSelectForUpdateLocking(Connection conn1, Connection conn2) throws Exception {
        DataValueDescriptor[] dvds;
        CompactCompositeRegionKey ckey;
        Statement stmt2;
        ResultSet rs;
        String query;
        Statement stmtForTableAndInsert = conn1.createStatement();
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname)) replicate");
        stmtForTableAndInsert.execute("create index lastNameIdx on Employee(lastname)");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        conn1.commit();
        conn1.setTransactionIsolation(this.getIsolationLevel());
        conn1.setAutoCommit(false);
        Statement stmt = conn1.createStatement(1003, 1008, 2);
        GemFireXDQueryObserver old = null;
        try {
            block14: {
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
                query = "SELECT * FROM EMPLOYEE where firstname = 'neeraj' and lastname = 'kumar' FOR UPDATE of BONUS, workdept";
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                }
                SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
                conn2.setTransactionIsolation(this.getIsolationLevel());
                conn2.setAutoCommit(false);
                stmt2 = conn2.createStatement(1003, 1008, 2);
                try {
                    stmt2.execute("update employee set bonus=1.0 where lastname='kumar'");
                    SelectForUpdateTest.fail("expected a conflict");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block14;
                    throw sqle;
                }
            }
            conn1.commit();
            stmt2.execute("update employee set bonus=5.0 where lastname='kumar'");
            conn2.commit();
        }
        finally {
            this.callbackInvoked = false;
            SelectForUpdateTest.assertEquals((int)1, (int)this.keyMap.size());
            ckey = (CompactCompositeRegionKey)this.keyMap.keySet().iterator().next();
            dvds = new DataValueDescriptor[ckey.nCols()];
            ckey.getKeyColumns(dvds);
            SelectForUpdateTest.assertEquals((String)"neeraj", (String)dvds[0].getString());
            SelectForUpdateTest.assertEquals((String)"kumar", (String)dvds[1].getString());
            this.keyMap = null;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
            stmtForTableAndInsert.execute("drop index APP.LASTNAMEIDX");
            stmtForTableAndInsert.execute("drop table Employee");
            conn1.commit();
        }
        stmtForTableAndInsert.execute("create table Employee(firstname varchar(50) not null, lastname varchar(50) not null, workdept varchar(50), bonus decimal(10,4), primary key (firstname, lastname))");
        stmtForTableAndInsert.execute("create index lastNameIdx on Employee(lastname)");
        stmtForTableAndInsert.execute("insert into employee values('neeraj', 'kumar', 'rnd', 0.0), ('asif', 'shahid', 'rnd', 1.0), ('dada', 'ji', 'rnd', 2.0), ('sum', 'wale', 'rnd', 3.0)");
        conn1.commit();
        conn1.setTransactionIsolation(this.getIsolationLevel());
        stmt = conn1.createStatement(1003, 1008, 2);
        try {
            block16: {
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new SelectForUpdateObserver());
                query = "SELECT * FROM EMPLOYEE where lastname = 'kumar' FOR UPDATE of BONUS";
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                }
                SelectForUpdateTest.assertTrue((boolean)this.callbackInvoked);
                conn2.setTransactionIsolation(this.getIsolationLevel());
                stmt2 = conn2.createStatement();
                try {
                    stmt2.execute("update employee set bonus=1.0 where lastname='kumar'");
                    SelectForUpdateTest.fail("expected a conflict");
                }
                catch (SQLException sqle) {
                    if ("X0Z02".equals(sqle.getSQLState())) break block16;
                    throw sqle;
                }
            }
            stmt.execute("update employee set bonus=3.0 where lastname='kumar'");
            conn1.commit();
            rs = stmt2.executeQuery("select bonus from employee where lastname='kumar'");
            SelectForUpdateTest.assertTrue((boolean)rs.next());
            SelectForUpdateTest.assertEquals((Object)3.0, (Object)rs.getDouble(1));
            SelectForUpdateTest.assertFalse((boolean)rs.next());
            stmt2.execute("update employee set bonus=5.0 where lastname='kumar'");
            conn2.commit();
            rs = stmt.executeQuery("select bonus from employee where lastname='kumar'");
            SelectForUpdateTest.assertTrue((boolean)rs.next());
            SelectForUpdateTest.assertEquals((Object)5.0, (Object)rs.getDouble(1));
            SelectForUpdateTest.assertFalse((boolean)rs.next());
        }
        finally {
            this.callbackInvoked = false;
            SelectForUpdateTest.assertEquals((int)1, (int)this.keyMap.size());
            ckey = (CompactCompositeRegionKey)this.keyMap.keySet().iterator().next();
            dvds = new DataValueDescriptor[ckey.nCols()];
            ckey.getKeyColumns(dvds);
            SelectForUpdateTest.assertEquals((String)"neeraj", (String)dvds[0].getString());
            SelectForUpdateTest.assertEquals((String)"kumar", (String)dvds[1].getString());
            this.keyMap = null;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    class SelectForUpdateObserver
    extends GemFireXDQueryObserverAdapter {
        SelectForUpdateObserver() {
        }

        public void lockingRowForTX(TXStateProxy tx, GemFireContainer container, RegionEntry entry, boolean writeLock) {
            if (writeLock) {
                SelectForUpdateTest.this.callbackInvoked = true;
                if (SelectForUpdateTest.this.keyMap == null) {
                    SelectForUpdateTest.this.keyMap = new HashMap();
                }
                SelectForUpdateTest.this.keyMap.put(entry.getKeyCopy(), null);
            }
        }

        public void attachingKeyInfoForUpdate(GemFireContainer container, RegionEntry entry) {
            TestUtil.fail("This method should not have been invoked");
        }
    }
}

