/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.transactions;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LocalIndexTxTest
extends JdbcTestBase {
    public LocalIndexTxTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(LocalIndexTxTest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalUpdateWithLocalIndexModified_EqualityCondition() throws Exception {
        Connection conn = LocalIndexTxTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (int i = 1; i < 21; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return 1.0;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 =5 where c5 =1"));
        LocalIndexTxTest.assertEquals((int)2, (int)st.executeUpdate("update t1 set c2 = 8  where c5 = 5"));
        conn.commit();
        try {
            ResultSet rs = st.executeQuery("Select c2 from t1 where c5 =5");
            LocalIndexTxTest.assertTrue((boolean)rs.next());
            LocalIndexTxTest.assertEquals((int)8, (int)rs.getInt(1));
            LocalIndexTxTest.assertTrue((boolean)rs.next());
            LocalIndexTxTest.assertEquals((int)8, (int)rs.getInt(1));
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalUpdateWithLocalIndexModified_Range_1() throws Exception {
        Connection conn = LocalIndexTxTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int  , c2 int , c3 int , c4 int  , c5 int , primary key(c1)) ");
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (int i = 1; i < 31; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return 1.0;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        LocalIndexTxTest.assertEquals((int)11, (int)st.executeUpdate("update t1 set c5 = 25 where c5  > 9 and c5 < 21"));
        LocalIndexTxTest.assertEquals((int)21, (int)st.executeUpdate("update t1 set c2 = 8  where c5 > 20"));
        conn.commit();
        try {
            int i;
            ResultSet rs = st.executeQuery("Select c2 from t1 where c5 > 20");
            for (i = 1; i < 22; ++i) {
                LocalIndexTxTest.assertTrue((boolean)rs.next());
                LocalIndexTxTest.assertEquals((int)8, (int)rs.getInt(1));
            }
            LocalIndexTxTest.assertFalse((boolean)rs.next());
            conn.commit();
            GemFireXDQueryObserverHolder.clearInstance();
            LocalIndexTxTest.assertEquals((int)4, (int)st.executeUpdate("update t1 set c5 = 10  where c1 > 15 and c1 < 20"));
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
            LocalIndexTxTest.assertEquals((int)4, (int)st.executeUpdate("update t1 set c2 = 1   where c5 > 9 and c5 < 13"));
            conn.commit();
            rs = st.executeQuery("Select c2 from t1 where c5 > 9 and c5 < 13");
            for (i = 1; i < 5; ++i) {
                LocalIndexTxTest.assertTrue((boolean)rs.next());
                LocalIndexTxTest.assertEquals((int)1, (int)rs.getInt(1));
            }
            LocalIndexTxTest.assertFalse((boolean)rs.next());
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalUpdateWithLocalIndexModified_Range_DeferredUpdate() throws Exception {
        Connection conn = LocalIndexTxTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (int i = 1; i < 31; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return 1.0;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        LocalIndexTxTest.assertEquals((int)11, (int)st.executeUpdate("update t1 set c5 = 25 where c5  > 9 and c5 < 21"));
        LocalIndexTxTest.assertEquals((int)21, (int)st.executeUpdate("update t1 set c2 = 8  where c5 > 20"));
        conn.commit();
        try {
            ResultSet rs = st.executeQuery("Select c2 from t1 where c5 > 20");
            for (int i = 1; i < 22; ++i) {
                LocalIndexTxTest.assertTrue((boolean)rs.next());
                LocalIndexTxTest.assertEquals((int)8, (int)rs.getInt(1));
            }
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTxUpdateOnTxInsert_Bug42177() throws Exception {
        int i;
        Connection conn = LocalIndexTxTest.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (i = 1; i < 10; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (i = 10; i < 21; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return 1.0;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 =5 where c5 =1"));
        LocalIndexTxTest.assertEquals((int)2, (int)st.executeUpdate("update t1 set c2 = 8  where c5 = 5"));
        conn.commit();
        try {
            ResultSet rs = st.executeQuery("Select c2 from t1 where c5 =5");
            LocalIndexTxTest.assertTrue((boolean)rs.next());
            LocalIndexTxTest.assertEquals((int)8, (int)rs.getInt(1));
            LocalIndexTxTest.assertTrue((boolean)rs.next());
            LocalIndexTxTest.assertEquals((int)8, (int)rs.getInt(1));
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTxInsertUpdateDeleteCombo() throws Exception {
        try {
            int i;
            Connection conn = LocalIndexTxTest.getConnection();
            conn.setTransactionIsolation(this.getIsolationLevel());
            Statement st = conn.createStatement();
            st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
            st.execute("create index i1 on t1 (c5)");
            conn.commit();
            PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
            for (i = 1; i < 6; ++i) {
                pstmt.setInt(1, i);
                pstmt.setInt(2, i);
                pstmt.setInt(3, i);
                pstmt.setInt(4, i);
                pstmt.setInt(5, i);
                pstmt.executeUpdate();
            }
            for (i = 31; i < 41; ++i) {
                pstmt.setInt(1, i);
                pstmt.setInt(2, i);
                pstmt.setInt(3, i);
                pstmt.setInt(4, i);
                pstmt.setInt(5, i);
                pstmt.executeUpdate();
            }
            conn.commit();
            pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
            for (i = 6; i < 31; ++i) {
                pstmt.setInt(1, i);
                pstmt.setInt(2, i);
                pstmt.setInt(3, i);
                pstmt.setInt(4, i);
                pstmt.setInt(5, i);
                pstmt.executeUpdate();
            }
            GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return 1.0;
                }
            };
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
            LocalIndexTxTest.assertEquals((int)10, (int)st.executeUpdate("update t1 set c5 =5 where c5 > 0 and c5 < 11"));
            LocalIndexTxTest.assertEquals((int)16, (int)st.executeUpdate("update t1 set c2 = 8  where c5 = 5 or ( c5 > 14 and c5 < 21)"));
            LocalIndexTxTest.assertEquals((int)22, (int)st.executeUpdate("delete from t1 where c2 = 8 or c2 > 34"));
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTxDeleteImpactOnLocalIndex() throws Exception {
        try {
            Connection conn = LocalIndexTxTest.getConnection();
            conn.setTransactionIsolation(this.getIsolationLevel());
            Statement st = conn.createStatement();
            st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
            st.execute("create index i1 on t1 (c5)");
            conn.commit();
            PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
            for (int i = 1; i < 41; ++i) {
                pstmt.setInt(1, i);
                pstmt.setInt(2, i);
                pstmt.setInt(3, i);
                pstmt.setInt(4, i);
                pstmt.setInt(5, i);
                pstmt.executeUpdate();
            }
            conn.commit();
            GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return 1.0;
                }
            };
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
            LocalIndexTxTest.assertEquals((int)6, (int)st.executeUpdate("Delete from t1  where c5 > 14 and c5 <= 20"));
            LocalIndexTxTest.assertEquals((int)14, (int)st.executeUpdate("update t1 set c2 = 8  where c5 >= 1 and c5 < 21 "));
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTxPKDeleteImpactOnLocalIndex() throws Exception {
        try {
            Connection conn = LocalIndexTxTest.getConnection();
            conn.setTransactionIsolation(this.getIsolationLevel());
            Statement st = conn.createStatement();
            st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
            st.execute("create index i1 on t1 (c5)");
            conn.commit();
            PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
            for (int i = 1; i < 31; ++i) {
                pstmt.setInt(1, i);
                pstmt.setInt(2, i);
                pstmt.setInt(3, i);
                pstmt.setInt(4, i);
                pstmt.setInt(5, i);
                pstmt.executeUpdate();
            }
            conn.commit();
            LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("Delete from t1  where c1 = 10"));
            GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return 1.0;
                }
            };
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
            LocalIndexTxTest.assertEquals((int)19, (int)st.executeUpdate("update t1 set c2 = 8  where c5 >= 1 and c5 < 21 "));
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTxPKUpdateImpactOnLocalIndex() throws Exception {
        try {
            Connection conn = LocalIndexTxTest.getConnection();
            conn.setTransactionIsolation(this.getIsolationLevel());
            Statement st = conn.createStatement();
            st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
            st.execute("create index i1 on t1 (c5)");
            conn.commit();
            PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
            for (int i = 1; i < 31; ++i) {
                pstmt.setInt(1, i);
                pstmt.setInt(2, i);
                pstmt.setInt(3, i);
                pstmt.setInt(4, i);
                pstmt.setInt(5, i);
                pstmt.executeUpdate();
            }
            conn.commit();
            LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 20   where c1 = 15"));
            GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return 1.0;
                }
            };
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
            LocalIndexTxTest.assertEquals((int)9, (int)st.executeUpdate("update t1 set c2 = 8  where c5 >= 18 and c5 < 26 "));
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testTxInsertUpdateDeleteCombo_PR() throws Exception {
        this.txInsertUpdateDeleteComboForBatching(true);
    }

    public void testTxInsertUpdateDeleteCombo_RR() throws Exception {
        this.txInsertUpdateDeleteComboForBatching(false);
    }

    protected int getIsolationLevel() {
        return 2;
    }

    private void txInsertUpdateDeleteComboForBatching(boolean isPR) throws Exception {
        int i;
        Connection conn = TestUtil.getConnection();
        conn.setTransactionIsolation(this.getIsolationLevel());
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null, c2 int not null, c3 int not null, c4 int not null, c5 int not null , primary key(c1)) " + (isPR ? "redundancy 2" : "replicate"));
        st.execute("create index i1 on t1 (c5)");
        st.execute("create index i2 on t1 (c2)");
        conn.commit();
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (i = 1; i < 6; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        for (i = 31; i < 41; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        conn.commit();
        pstmt = conn.prepareStatement("insert into t1 values(?,?,?,?,?)");
        for (i = 6; i < 31; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i);
            pstmt.setInt(3, i);
            pstmt.setInt(4, i);
            pstmt.setInt(5, i);
            pstmt.executeUpdate();
        }
        st = conn.createStatement();
        LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 5 where c1 = 1"));
        LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 6 where c1 = 2"));
        LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 6 where c1 = 7"));
        LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 = 5 where c1 = 9"));
        LocalIndexTxTest.assertEquals((int)8, (int)st.executeUpdate("update t1 set c5 = 5 where c1 > 2 and c1 < 11"));
        LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c2 = 8 where c1 = 1"));
        LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c2 = 8 where c1 = 2"));
        LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c2 = 8 where c1 = 7"));
        LocalIndexTxTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c2 = 8 where c1 = 9"));
        LocalIndexTxTest.assertEquals((int)15, (int)st.executeUpdate("update t1 set c2 = 8  where c5 = 5 or ( c5 > 14 and c5 < 21)"));
        LocalIndexTxTest.assertEquals((int)22, (int)st.executeUpdate("delete from t1 where c2 = 8 or c2 > 34"));
        conn.commit();
    }
}

