/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.offheap.transactions;

import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.jdbc.transactions.TransactionTest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;

public class OffheapTransactionTest
extends TransactionTest {
    private JdbcTestBase.RegionMapClearDetector rmcd = null;

    public OffheapTransactionTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
        System.setProperty("gemfire.off-heap-memory-size", "500m");
        System.setProperty("gemfire.disableManagement", "true");
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
        this.rmcd = new JdbcTestBase.RegionMapClearDetector();
        CacheObserverHolder.setInstance((CacheObserver)this.rmcd);
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)this.rmcd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalIndexKeyBehaviour_1() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Object psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            conn.setTransactionIsolation(4);
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 3; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, -1 * i);
                psInsert2.setInt(4, 100 * i);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert2.setString(7, "cancelled");
                psInsert2.setInt(8, 5);
                OffheapTransactionTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            conn.commit();
            final GemFireContainer[] indexContainerI1 = new GemFireContainer[1];
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    indexContainerI1[0] = memIndex.getGemFireContainer();
                    return optimzerEvalutatedCost;
                }
            });
            Statement st = conn.createStatement();
            st.executeQuery("select * from trade.buyorders where status = 'cancelled'");
            OffheapTransactionTest.assertNotNull((Object)indexContainerI1[0]);
            ConcurrentSkipListMap indexMap = indexContainerI1[0].getSkipListMap();
            Iterator indexKeys = indexMap.keySet().iterator();
            int num = 0;
            while (indexKeys.hasNext()) {
                CompactCompositeIndexKey ccik = (CompactCompositeIndexKey)indexKeys.next();
                Object valueByteSource = ccik.getValueByteSource();
                OffheapTransactionTest.assertTrue((boolean)(valueByteSource instanceof OffHeapByteSource));
                ccik.releaseValueByteSource(valueByteSource);
                ++num;
            }
            OffheapTransactionTest.assertEquals((int)2, (int)num);
            st.executeUpdate("update trade.buyorders set status = 'xxxx' where cid =1");
            st.executeUpdate("update trade.buyorders set status = 'cancelled' where cid = 1");
            conn.commit();
            psInsert2.setInt(1, 4);
            psInsert2.setInt(2, 4);
            psInsert2.setInt(3, -4);
            psInsert2.setInt(4, 400);
            psInsert2.setFloat(5, 30.4f);
            psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            psInsert2.setString(7, "cancelled");
            psInsert2.setInt(8, 5);
            OffheapTransactionTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            this.doOffHeapValidations();
            conn.commit();
            s.executeUpdate("delete from trade.buyorders");
            conn.commit();
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.waitTillAllClear();
            }
        }
        finally {
            block11: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block11;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalIndexKeyBehaviour_2() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            conn.setTransactionIsolation(4);
            conn.setAutoCommit(false);
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 3; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                psInsert.setInt(4, 100 * i);
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffheapTransactionTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            conn.commit();
            Connection conn1 = TestUtil.getConnection();
            final PreparedStatement psInsert1 = conn1.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            Statement s1 = conn1.createStatement();
            Statement st = conn.createStatement();
            st.executeUpdate("update trade.buyorders set status = 'xxxx' where cid =1");
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        psInsert1.setInt(1, 4);
                        psInsert1.setInt(2, 4);
                        psInsert1.setInt(3, -4);
                        psInsert1.setInt(4, 400);
                        psInsert1.setFloat(5, 40.4f);
                        psInsert1.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                        psInsert1.setString(7, "xxxx");
                        psInsert1.setInt(8, 5);
                        psInsert1.executeUpdate();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TestUtil.fail(e.toString());
                    }
                }
            });
            th.start();
            th.join();
            conn.rollback();
            psInsert1.setInt(1, 5);
            psInsert1.setInt(2, 5);
            psInsert1.setInt(3, -5);
            psInsert1.setInt(4, 500);
            psInsert1.setFloat(5, 40.4f);
            psInsert1.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            psInsert1.setString(7, "xxxx");
            psInsert1.setInt(8, 5);
            psInsert1.executeUpdate();
            ResultSet rs1 = s1.executeQuery("select * from trade.buyorders where status = 'xxxx'");
            int num = 0;
            while (rs1.next()) {
                OffheapTransactionTest.assertEquals((String)"xxxx", (String)rs1.getString("status"));
                ++num;
            }
            OffheapTransactionTest.assertEquals((int)2, (int)num);
            psInsert1.setInt(1, 6);
            psInsert1.setInt(2, 6);
            psInsert1.setInt(3, -6);
            psInsert1.setInt(4, 600);
            psInsert1.setFloat(5, 40.4f);
            psInsert1.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            psInsert1.setString(7, "yyyy");
            psInsert1.setInt(8, 5);
            psInsert1.executeUpdate();
            s.executeUpdate("delete from trade.buyorders where status ='yyyy'");
            Thread th2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        psInsert1.setInt(1, 7);
                        psInsert1.setInt(2, 7);
                        psInsert1.setInt(3, -7);
                        psInsert1.setInt(4, 700);
                        psInsert1.setFloat(5, 40.4f);
                        psInsert1.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                        psInsert1.setString(7, "yyyy");
                        psInsert1.setInt(8, 5);
                        psInsert1.executeUpdate();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TestUtil.fail(e.toString());
                    }
                }
            });
            th2.start();
            th2.join();
            conn.commit();
            psInsert1.setInt(1, 8);
            psInsert1.setInt(2, 8);
            psInsert1.setInt(3, -8);
            psInsert1.setInt(4, 800);
            psInsert1.setFloat(5, 40.4f);
            psInsert1.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            psInsert1.setString(7, "yyyy");
            psInsert1.setInt(8, 5);
            psInsert1.executeUpdate();
            rs1 = s1.executeQuery("select * from trade.buyorders where status = 'yyyy'");
            num = 0;
            while (rs1.next()) {
                OffheapTransactionTest.assertEquals((String)"yyyy", (String)rs1.getString("status"));
                ++num;
            }
            OffheapTransactionTest.assertEquals((int)2, (int)num);
            this.doOffHeapValidations();
            psInsert.setInt(1, 9);
            psInsert.setInt(2, 9);
            psInsert.setInt(3, -9);
            psInsert.setInt(4, 900);
            psInsert.setFloat(5, 30.4f);
            psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            psInsert.setString(7, "wwww");
            psInsert.setInt(8, 5);
            psInsert.executeUpdate();
            Thread th3 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        psInsert1.setInt(1, 10);
                        psInsert1.setInt(2, 10);
                        psInsert1.setInt(3, -10);
                        psInsert1.setInt(4, 1000);
                        psInsert1.setFloat(5, 40.4f);
                        psInsert1.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                        psInsert1.setString(7, "wwww");
                        psInsert1.setInt(8, 5);
                        psInsert1.executeUpdate();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TestUtil.fail(e.toString());
                    }
                }
            });
            th3.start();
            th3.join();
            conn.rollback();
            psInsert1.setInt(1, 11);
            psInsert1.setInt(2, 11);
            psInsert1.setInt(3, -11);
            psInsert1.setInt(4, 1100);
            psInsert1.setFloat(5, 40.4f);
            psInsert1.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            psInsert1.setString(7, "wwww");
            psInsert1.setInt(8, 5);
            psInsert1.executeUpdate();
            rs1 = s1.executeQuery("select * from trade.buyorders where status = 'wwww'");
            num = 0;
            while (rs1.next()) {
                OffheapTransactionTest.assertEquals((String)"wwww", (String)rs1.getString("status"));
                ++num;
            }
            OffheapTransactionTest.assertEquals((int)2, (int)num);
            s1.executeUpdate("delete from trade.buyorders");
            psInsert1.setInt(1, 1);
            psInsert1.setInt(2, 1);
            psInsert1.setInt(3, -1);
            psInsert1.setInt(4, 100);
            psInsert1.setFloat(5, 40.4f);
            psInsert1.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            psInsert1.setString(7, "wwww");
            psInsert1.setInt(8, 5);
            psInsert1.executeUpdate();
            s.executeUpdate("update trade.buyorders set tid = 14");
            conn.commit();
            psInsert1.setInt(1, 2);
            psInsert1.setInt(2, 2);
            psInsert1.setInt(3, -2);
            psInsert1.setInt(4, 200);
            psInsert1.setFloat(5, 40.4f);
            psInsert1.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            psInsert1.setString(7, "wwww");
            psInsert1.setInt(8, 5);
            psInsert1.executeUpdate();
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.waitTillAllClear();
            }
        }
        finally {
            block13: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    @Override
    public String getSuffix() {
        return " offheap ";
    }

    @Override
    public void tearDown() throws Exception {
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
        CacheObserverHolder.setInstance(null);
        GemFireXDQueryObserverHolder.clearInstance();
        super.tearDown();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
        System.setProperty("gemfire.off-heap-memory-size", "");
        System.setProperty("gemfire.disableManagement", "");
    }

    @Override
    public void waitTillAllClear() {
        try {
            this.rmcd.waitTillAllClear();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new GemFireXDRuntimeException((Throwable)ie);
        }
    }
}

