/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.offheap;

import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRegionEntryUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TargetResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.SortResultSet;
import com.pivotal.gemfirexd.jdbc.LangScripts_OrderbyTest;
import java.lang.reflect.Field;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class Offheap_LangScripts_OrderbyTest
extends LangScripts_OrderbyTest {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(Offheap_LangScripts_OrderbyTest.class));
    }

    public Offheap_LangScripts_OrderbyTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
        System.setProperty("gemfire.off-heap-memory-size", "500m");
        System.setProperty("gemfire.disableManagement", "true");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
        System.setProperty("gemfire.off-heap-memory-size", "");
        System.setProperty("gemfire.disableManagement", "");
    }

    @Override
    public void testLangScript_OrderbyTestNoPartitioning() throws Exception {
        final HashMap addressAndBytes = new HashMap();
        final HashSet listOfRegions = new HashSet();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void beforeEmbedResultSetClose(EmbedResultSet rs, String query) {
                for (LocalRegion lr : listOfRegions) {
                    if (!lr.getEnableOffHeapMemory()) continue;
                    Collection entries = lr.getRegionMap().regionEntries();
                    for (RegionEntry re : entries) {
                        byte[] bytes;
                        Object o;
                        OffHeapRegionEntry ohre = (OffHeapRegionEntry)re;
                        long address = ohre.getAddress();
                        if (!addressAndBytes.containsKey(address) || !((o = OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])(bytes = (byte[])addressAndBytes.get(address)), (boolean)false)) instanceof OffHeapByteSource)) continue;
                        ohre.setAddress(address, ((OffHeapByteSource)o).getMemoryAddress());
                    }
                }
                addressAndBytes.clear();
                listOfRegions.clear();
            }

            public void onSortResultSetOpen(ResultSet resultSet) {
                try {
                    SortResultSet srs = (SortResultSet)resultSet;
                    NoPutResultSet source = srs.getSource();
                    source = Offheap_LangScripts_OrderbyTest.this.conditionSourceResultSet(source, addressAndBytes);
                    Class<SortResultSet> clazz = SortResultSet.class;
                    Field field = clazz.getDeclaredField("source");
                    field.setAccessible(true);
                    field.set(srs, source);
                    GemFireCacheImpl gc = Misc.getGemFireCacheNoThrow();
                    Set appRegions = gc.getApplicationRegions();
                    listOfRegions.addAll(appRegions);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        super.testLangScript_OrderbyTestNoPartitioning();
    }

    @Override
    public void testLangScript_OrderbyWithPartitioning() throws Exception {
        final HashMap addressAndBytes = new HashMap();
        final HashSet listOfRegions = new HashSet();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void beforeEmbedResultSetClose(EmbedResultSet rs, String query) {
                for (LocalRegion lr : listOfRegions) {
                    if (!lr.getEnableOffHeapMemory()) continue;
                    if (lr instanceof PartitionedRegion) {
                        Set brs;
                        PartitionedRegion pr = (PartitionedRegion)lr;
                        PartitionedRegionDataStore prs = pr.getDataStore();
                        if (prs == null || (brs = prs.getAllLocalBucketRegions()) == null) continue;
                        for (BucketRegion br : brs) {
                            if (br == null) continue;
                            this.checkEntries((LocalRegion)br);
                        }
                        continue;
                    }
                    this.checkEntries(lr);
                }
                addressAndBytes.clear();
                listOfRegions.clear();
            }

            private void checkEntries(LocalRegion lr) {
                Collection entries = lr.getRegionMap().regionEntries();
                for (RegionEntry re : entries) {
                    byte[] bytes;
                    Object o;
                    OffHeapRegionEntry ohre = (OffHeapRegionEntry)re;
                    long address = ohre.getAddress();
                    if (!addressAndBytes.containsKey(address) || !((o = OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])(bytes = (byte[])addressAndBytes.get(address)), (boolean)false)) instanceof OffHeapByteSource)) continue;
                    ohre.setAddress(address, ((OffHeapByteSource)o).getMemoryAddress());
                }
            }

            public void onSortResultSetOpen(ResultSet resultSet) {
                try {
                    SortResultSet srs = (SortResultSet)resultSet;
                    NoPutResultSet source = srs.getSource();
                    source = Offheap_LangScripts_OrderbyTest.this.conditionSourceResultSet(source, addressAndBytes);
                    Class<SortResultSet> clazz = SortResultSet.class;
                    Field field = clazz.getDeclaredField("source");
                    field.setAccessible(true);
                    field.set(srs, source);
                    GemFireCacheImpl gc = Misc.getGemFireCacheNoThrow();
                    Set appRegions = gc.getApplicationRegions();
                    listOfRegions.addAll(appRegions);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        super.testLangScript_OrderbyWithPartitioning();
    }

    private NoPutResultSet conditionSourceResultSet(final NoPutResultSet noputResultSet, final Map<Long, byte[]> addressAndBytes) {
        NoPutResultSet testResultSetPassThru = new NoPutResultSet(){
            private List<RowLocation> rowsScanned = new ArrayList<RowLocation>();

            public void deleteRowDirectly() throws StandardException {
                noputResultSet.deleteRowDirectly();
            }

            public boolean canUpdateInPlace() {
                return noputResultSet.canUpdateInPlace();
            }

            public boolean needsToClone() {
                return noputResultSet.needsToClone();
            }

            public FormatableBitSet getValidColumns() {
                return noputResultSet.getValidColumns();
            }

            public ExecRow getNextRowFromRowSource() throws StandardException {
                return noputResultSet.getNextRowFromRowSource();
            }

            public void closeRowSource() {
                noputResultSet.closeRowSource();
            }

            public void rowLocation(RowLocation rl) throws StandardException {
                noputResultSet.rowLocation(rl);
            }

            public boolean needsRowLocation() {
                return noputResultSet.needsRowLocation();
            }

            public ExecRow setBeforeFirstRow() throws StandardException {
                return noputResultSet.setBeforeFirstRow();
            }

            public ExecRow setAfterLastRow() throws StandardException {
                return noputResultSet.setAfterLastRow();
            }

            public boolean returnsRows() {
                return noputResultSet.returnsRows();
            }

            public void resetStatistics() {
                noputResultSet.resetStatistics();
            }

            public boolean releaseLocks(GemFireTransaction tran) {
                return noputResultSet.releaseLocks(tran);
            }

            public void open() throws StandardException {
                noputResultSet.open();
            }

            public int modifiedRowCount() {
                return noputResultSet.modifiedRowCount();
            }

            public void markLocallyExecuted() {
                noputResultSet.markLocallyExecuted();
            }

            public boolean isDistributedResultSet() {
                return noputResultSet.isDistributedResultSet();
            }

            public boolean isClosed() {
                return noputResultSet.isClosed();
            }

            public boolean hasAutoGeneratedKeysResultSet() {
                return noputResultSet.hasAutoGeneratedKeysResultSet();
            }

            public SQLWarning getWarnings() {
                return noputResultSet.getWarnings();
            }

            public long getTimeSpent(int type, int timeType) {
                return noputResultSet.getTimeSpent(type, timeType);
            }

            public NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
                return noputResultSet.getSubqueryTrackingArray(numSubqueries);
            }

            public int getRowNumber() {
                return noputResultSet.getRowNumber();
            }

            public ExecRow getRelativeRow(int row) throws StandardException {
                return noputResultSet.getRelativeRow(row);
            }

            public ExecRow getPreviousRow() throws StandardException {
                return noputResultSet.getPreviousRow();
            }

            public ExecRow getNextRow() throws StandardException {
                return noputResultSet.getNextRow();
            }

            public ExecRow getLastRow() throws StandardException {
                return noputResultSet.getLastRow();
            }

            public ExecRow getFirstRow() throws StandardException {
                return noputResultSet.getFirstRow();
            }

            public UUID getExecutionPlanID() {
                return noputResultSet.getExecutionPlanID();
            }

            public long getExecuteTime() {
                return noputResultSet.getExecuteTime();
            }

            public Timestamp getEndExecutionTimestamp() {
                return noputResultSet.getEndExecutionTimestamp();
            }

            public String getCursorName() {
                return noputResultSet.getCursorName();
            }

            public Timestamp getBeginExecutionTimestamp() {
                return noputResultSet.getBeginExecutionTimestamp();
            }

            public ResultSet getAutoGeneratedKeysResultset() {
                return noputResultSet.getAutoGeneratedKeysResultset();
            }

            public Activation getActivation() {
                return noputResultSet.getActivation();
            }

            public ExecRow getAbsoluteRow(int row) throws StandardException {
                return noputResultSet.getAbsoluteRow(row);
            }

            public void flushBatch() throws StandardException {
                noputResultSet.flushBatch();
            }

            public void finish() throws StandardException {
                noputResultSet.finish();
            }

            public void closeBatch() throws StandardException {
                noputResultSet.closeBatch();
            }

            public void close(boolean cleanupOnError) throws StandardException {
                noputResultSet.close(cleanupOnError);
            }

            public void clearCurrentRow() {
                noputResultSet.clearCurrentRow();
            }

            public void cleanUp(boolean cleanupOnError) throws StandardException {
                noputResultSet.cleanUp(cleanupOnError);
            }

            public boolean checkRowPosition(int isType) throws StandardException {
                return noputResultSet.checkRowPosition(isType);
            }

            public void checkCancellationFlag() throws StandardException {
                noputResultSet.checkCancellationFlag();
            }

            public boolean addLockReference(GemFireTransaction tran) {
                return noputResultSet.addLockReference(tran);
            }

            public void accept(ResultSetStatisticsVisitor visitor) {
                noputResultSet.accept(visitor);
            }

            public void upgradeReadLockToWrite(RowLocation rl, GemFireContainer container) throws StandardException {
                noputResultSet.upgradeReadLockToWrite(rl, container);
            }

            public void updateRowLocationPostRead() throws StandardException {
                noputResultSet.updateRowLocationPostRead();
            }

            public void updateRow(ExecRow row) throws StandardException {
                noputResultSet.updateRow(row);
            }

            public boolean supportsMoveToNextKey() {
                return noputResultSet.supportsMoveToNextKey();
            }

            public void setTargetResultSet(TargetResultSet trs) {
                noputResultSet.setTargetResultSet(trs);
            }

            public void setNeedsRowLocation(boolean needsRowLocation) {
                noputResultSet.setNeedsRowLocation(needsRowLocation);
            }

            public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> keys) throws StandardException {
                noputResultSet.setGfKeysForNCJoin(keys);
            }

            public void setCurrentRow(ExecRow row) {
                noputResultSet.setCurrentRow(row);
            }

            public int resultSetNumber() {
                return noputResultSet.resultSetNumber();
            }

            public boolean requiresRelocking() {
                return noputResultSet.requiresRelocking();
            }

            public void reopenCore() throws StandardException {
                noputResultSet.reopenCore();
            }

            public void releasePreviousByteSource() {
                noputResultSet.releasePreviousByteSource();
            }

            public void setMaxSortingLimit(long limit) {
                noputResultSet.setMaxSortingLimit(limit);
            }

            public void positionScanAtRowLocation(RowLocation rLoc) throws StandardException {
                noputResultSet.positionScanAtRowLocation(rLoc);
            }

            public void openCore() throws StandardException {
                noputResultSet.openCore();
            }

            public void markRowAsDeleted() throws StandardException {
                noputResultSet.markRowAsDeleted();
            }

            public void markAsTopResultSet() {
                noputResultSet.markAsTopResultSet();
            }

            public boolean isForUpdate() {
                return noputResultSet.isForUpdate();
            }

            public TXState initLocalTXState() {
                return noputResultSet.initLocalTXState();
            }

            public int getScanKeyGroupID() {
                return noputResultSet.getScanKeyGroupID();
            }

            public int getScanIsolationLevel() {
                return noputResultSet.getScanIsolationLevel();
            }

            public int getPointOfAttachment() {
                return noputResultSet.getPointOfAttachment();
            }

            public ExecRow getNextRowCore() throws StandardException {
                Object bs;
                ExecRow row = noputResultSet.getNextRowCore();
                if (row != null && row instanceof AbstractCompactExecRow && (bs = ((AbstractCompactExecRow)row).getByteSource()) instanceof OffHeapByteSource) {
                    OffHeapByteSource obs = (OffHeapByteSource)bs;
                    byte[] bytes = obs.getRowBytes();
                    addressAndBytes.put(obs.getMemoryAddress(), bytes);
                    ((OffHeapByteSource)bs).release();
                }
                return row;
            }

            public PlanUtils.Context getNewPlanContext() {
                return noputResultSet.getNewPlanContext();
            }

            public double getEstimatedRowCount() {
                return noputResultSet.getEstimatedRowCount();
            }

            public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
                noputResultSet.filteredRowLocationPostRead(localTXState);
            }

            public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
                return noputResultSet.fetch(loc, destRow, validColumns, faultIn, container);
            }

            public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
                return noputResultSet.buildQueryPlan(builder, context);
            }

            public void forceReOpenCore() throws StandardException {
                noputResultSet.forceReOpenCore();
            }
        };
        return testResultSetPassThru;
    }

    @Override
    protected String getOffHeapSuffix() {
        return " offheap ";
    }
}

