/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.offheap;

import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.jdbc.IndexConsistencyTest;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OffheapIndexConsistencyTest
extends IndexConsistencyTest {
    private JdbcTestBase.RegionMapClearDetector rmcd = null;

    public OffheapIndexConsistencyTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
        System.setProperty("gemfire.off-heap-memory-size", "500m");
        System.setProperty("gemfire.disableManagement", "true");
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
        this.rmcd = new JdbcTestBase.RegionMapClearDetector();
        CacheObserverHolder.setInstance((CacheObserver)this.rmcd);
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.rmcd);
    }

    @Override
    public void tearDown() throws Exception {
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
        CacheObserverHolder.setInstance(null);
        GemFireXDQueryObserverHolder.clearInstance();
        super.tearDown();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
        System.setProperty("gemfire.off-heap-memory-size", "");
        System.setProperty("gemfire.disableManagement", "");
    }

    @Override
    public String getSuffix() {
        return " offheap ";
    }

    @Override
    protected void additionalTableAttributes(RegionAttributesCreation expectedAttrs) {
        expectedAttrs.setEnableOffHeapMemory(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexKeysDelete() throws Exception {
        Connection conn = null;
        Statement s = null;
        String updateQuery = "update Child set sector_id2 = ? where id2 = ?";
        conn = OffheapIndexConsistencyTest.getConnection();
        s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int,  indexCol1 int)  replicate " + this.getSuffix());
        s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (sector_id2) references instruments (id1) ) replicate" + this.getSuffix());
        s.execute("create index index1 on instruments(indexCol1)");
        try {
            s.execute("insert into instruments values (1,1,1,1)");
            s.execute("insert into instruments values (2,2,2,1)");
            s.execute("delete from instruments where  id1 = 1");
            s.execute("delete from instruments where id1 = 2");
            s.execute("insert into instruments values (1,1,1,1)");
            s.execute("insert into instruments values (2,2,2,1)");
            s.execute("insert into instruments values (3,3,3,1)");
            s.execute("update  instruments set indexCol1 =2 where id1 = 1");
            s.execute("delete from instruments where id1 = 2");
            s.execute("delete from instruments where id1 = 3");
            s.execute("delete from instruments where id1 = 1");
        }
        finally {
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter());
            conn = OffheapIndexConsistencyTest.getConnection();
            s = conn.createStatement();
            s.execute("Drop table Child ");
            this.waitTillAllClear();
            s.execute("Drop table INSTRUMENTS ");
            this.waitTillAllClear();
        }
    }

    public void testIndexKeysUpdate() throws Exception {
        Connection conn = null;
        Statement s = null;
        conn = OffheapIndexConsistencyTest.getConnection();
        s = conn.createStatement();
        try {
            s.execute("create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int  )  replicate " + this.getSuffix());
            s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int,  indexCol1 int,foreign key (sector_id2) references instruments (id1) ) replicate" + this.getSuffix());
            s.execute("create index index1 on child(indexCol1)");
            s.execute("insert into instruments values (1,1,1)");
            s.execute("insert into child values (1,1,1,1)");
            s.execute("insert into child values (2,1,2,1)");
            s.execute("update  child set indexCol1 =2 where id2 = 1");
            ResultSet rs = s.executeQuery("select * from child where sector_id2 = 1");
            int count = 0;
            while (rs.next()) {
                rs.getInt(1);
                ++count;
            }
            OffheapIndexConsistencyTest.assertEquals((int)2, (int)count);
            s.execute("delete from child where  sector_id2 = 1");
            s.execute("delete from instruments where id1 = 1");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        finally {
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter());
            conn = OffheapIndexConsistencyTest.getConnection();
            s = conn.createStatement();
            s.execute("Drop table Child ");
            this.waitTillAllClear();
            s.execute("Drop table INSTRUMENTS ");
            this.waitTillAllClear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnyRaceOnIndexKeyForDelete() throws Exception {
        if (isTransactional) {
            return;
        }
        Connection conn = OffheapIndexConsistencyTest.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int  )  replicate " + this.getSuffix());
            s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int,  indexCol1 int,foreign key (sector_id2) references instruments (id1) ) replicate" + this.getSuffix());
            s.execute("create index index1 on child(indexCol1)");
            s.execute("insert into instruments values (1,1,1)");
            s.execute("insert into child values (1,1,1,1)");
            s.execute("insert into child values (2,1,2,1)");
            final boolean[] proceed = new boolean[]{false};
            final boolean[] exceptionOccured = new boolean[]{false};
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void keyAndContainerBeforeLocalIndexDelete(Object key, Object rowLocation, GemFireContainer container) {
                    OffheapIndexConsistencyTest offheapIndexConsistencyTest = OffheapIndexConsistencyTest.this;
                    synchronized (offheapIndexConsistencyTest) {
                        if (!proceed[0]) {
                            proceed[0] = true;
                            ((Object)((Object)OffheapIndexConsistencyTest.this)).notify();
                            try {
                                ((Object)((Object)OffheapIndexConsistencyTest.this)).wait();
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace();
                                exceptionOccured[0] = true;
                            }
                        }
                    }
                }
            });
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement stmt = conn1.createStatement();
                        stmt.execute("delete from  child  where id2 = 1");
                    }
                    catch (SQLException e) {
                        exceptionOccured[0] = true;
                    }
                }
            });
            th.start();
            OffheapIndexConsistencyTest offheapIndexConsistencyTest = this;
            synchronized (offheapIndexConsistencyTest) {
                if (!proceed[0]) {
                    ((Object)((Object)this)).wait();
                }
            }
            try {
                ResultSet rs = s.executeQuery("select * from child where sector_id2 = 1");
                int count = 0;
                while (rs.next()) {
                    rs.getInt(1);
                    ++count;
                }
                OffheapIndexConsistencyTest.assertEquals((int)2, (int)count);
            }
            finally {
                offheapIndexConsistencyTest = this;
                synchronized (offheapIndexConsistencyTest) {
                    ((Object)((Object)this)).notify();
                }
            }
            s.execute("delete from child where  sector_id2 = 1");
            s.execute("delete from instruments where id1 = 1");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        finally {
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter());
            s.execute("Drop table Child ");
            this.waitTillAllClear();
            s.execute("Drop table INSTRUMENTS ");
            this.waitTillAllClear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnyRaceOnIndexKeyForUpdate() throws Exception {
        Connection conn = OffheapIndexConsistencyTest.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int  )  replicate " + this.getSuffix());
            s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int,  indexCol1 int,foreign key (sector_id2) references instruments (id1) ) replicate" + this.getSuffix());
            s.execute("create index index1 on child(indexCol1)");
            s.execute("insert into instruments values (1,1,1)");
            s.execute("insert into instruments values (2,2,1)");
            s.execute("insert into child values (1,1,1,1)");
            s.execute("insert into child values (2,1,2,1)");
            final boolean[] proceed = new boolean[]{false};
            final boolean[] exceptionOccured = new boolean[]{false};
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void keyAndContainerBeforeLocalIndexDelete(Object key, Object rowLocation, GemFireContainer container) {
                    OffheapIndexConsistencyTest offheapIndexConsistencyTest = OffheapIndexConsistencyTest.this;
                    synchronized (offheapIndexConsistencyTest) {
                        if (!proceed[0]) {
                            proceed[0] = true;
                            ((Object)((Object)OffheapIndexConsistencyTest.this)).notify();
                            try {
                                ((Object)((Object)OffheapIndexConsistencyTest.this)).wait();
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace();
                                exceptionOccured[0] = true;
                            }
                        }
                    }
                }
            });
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement stmt = conn1.createStatement();
                        stmt.execute("update   child  set sector_id2 = 2 where id2 = 1");
                    }
                    catch (SQLException e) {
                        exceptionOccured[0] = true;
                    }
                }
            });
            th.start();
            OffheapIndexConsistencyTest offheapIndexConsistencyTest = this;
            synchronized (offheapIndexConsistencyTest) {
                if (!proceed[0]) {
                    ((Object)((Object)this)).wait();
                }
            }
            try {
                ResultSet rs = s.executeQuery("select * from child where sector_id2 = 1");
                int count = 0;
                while (rs.next()) {
                    rs.getInt(1);
                    ++count;
                }
                OffheapIndexConsistencyTest.assertTrue((count <= 2 && count >= 1 ? 1 : 0) != 0);
            }
            finally {
                offheapIndexConsistencyTest = this;
                synchronized (offheapIndexConsistencyTest) {
                    ((Object)((Object)this)).notify();
                }
            }
            s.execute("delete from child where  sector_id2 = 1");
            s.execute("delete from instruments where id1 = 1");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        finally {
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter());
            s.execute("Drop table Child ");
            this.waitTillAllClear();
            s.execute("Drop table INSTRUMENTS ");
            this.waitTillAllClear();
        }
    }

    public void testOffHeapMemoryReleaseOnUniqueConstraintViolation() throws Exception {
        Statement s;
        block5: {
            block4: {
                Connection conn = OffheapIndexConsistencyTest.getConnection();
                s = conn.createStatement();
                s.execute("create schema EMP");
                s.execute("create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRD int not null, FOURTH int not null, FIFTH int not null, primary key (ID, SECONDID)) PARTITION BY COLUMN (ID)" + this.getSuffix());
                s.execute("create unique index third_index on EMP.PARTITIONTESTTABLE (THIRD)");
                s.execute("INSERT INTO EMP.PARTITIONTESTTABLE values(1,2,3,4, 10)");
                s.execute("INSERT INTO EMP.PARTITIONTESTTABLE values(4,5,6,4, 11)");
                OffheapIndexConsistencyTest.addExpectedException(EntryExistsException.class);
                try {
                    s.execute("INSERT INTO EMP.PARTITIONTESTTABLE values(1,3,3,4,13)");
                    OffheapIndexConsistencyTest.fail("Exception is expected!");
                }
                catch (SQLException ex) {
                    if ("23505".equals(ex.getSQLState())) break block4;
                    throw ex;
                }
            }
            this.doOffHeapValidations();
            try {
                s.execute("UPDATE EMP.PARTITIONTESTTABLE SET third=6, fifth=20 where id=1 and secondid=2");
                OffheapIndexConsistencyTest.fail("Exception is expected!");
            }
            catch (SQLException ex) {
                if ("23505".equals(ex.getSQLState())) break block5;
                throw ex;
            }
        }
        this.doOffHeapValidations();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        this.waitTillAllClear();
        s.execute("drop schema EMP RESTRICT");
        this.waitTillAllClear();
        this.doOffHeapValidations();
    }

    @Override
    public void waitTillAllClear() {
        try {
            this.rmcd.waitTillAllClear();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new GemFireXDRuntimeException((Throwable)ie);
        }
    }
}

