/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.offheap;

import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.jdbc.BlobTest;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.junit.Assert;

public class OffheapBlobTest
extends BlobTest {
    private JdbcTestBase.RegionMapClearDetector rmcd = null;

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(OffheapBlobTest.class));
    }

    public OffheapBlobTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
        System.setProperty("gemfire.off-heap-memory-size", "500m");
        System.setProperty("gemfire.disableManagement", "true");
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
        this.rmcd = new JdbcTestBase.RegionMapClearDetector();
        CacheObserverHolder.setInstance((CacheObserver)this.rmcd);
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.rmcd);
    }

    @Override
    public void tearDown() throws Exception {
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
        CacheObserverHolder.setInstance(null);
        GemFireXDQueryObserverHolder.clearInstance();
        super.tearDown();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
        System.setProperty("gemfire.off-heap-memory-size", "");
        System.setProperty("gemfire.disableManagement", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGfxdByteSourceBlobSerializationDeserialization() throws Exception {
        OffheapBlobTest.setupConnection();
        Connection conn = jdbcConn;
        String tableDDL = "create table X (id int , bytes1 blob, bytes2 blob ) replicate" + this.getSuffix();
        Statement stmt = conn.createStatement();
        stmt.execute(tableDDL);
        try {
            byte[] bytes1 = new byte[100];
            for (int i = 0; i < bytes1.length; ++i) {
                bytes1[i] = (byte)(i % 127);
            }
            byte[] bytes2 = new byte[200];
            for (int i = 0; i < bytes2.length; ++i) {
                bytes2[i] = (byte)(i % 127);
            }
            PreparedStatement ps = conn.prepareStatement("insert into X values(?,?,?)");
            ps.setInt(1, 1);
            ps.setBytes(2, bytes1);
            ps.setBytes(3, bytes2);
            ps.executeUpdate();
            LocalRegion lr = (LocalRegion)Misc.getRegionForTable((String)"APP.X", (boolean)true);
            Iterator itr = lr.keySet().iterator();
            OffheapBlobTest.assertTrue((boolean)itr.hasNext());
            OffHeapRegionEntry ohe = (OffHeapRegionEntry)lr.basicGetEntry(itr.next());
            long address = ohe.getAddress();
            OffHeapRowWithLobs obs = (OffHeapRowWithLobs)OffHeapRegionEntryHelper.addressToObject((long)address, (boolean)false);
            byte[] byte1_ = obs.getGfxdBytes(1);
            byte[] byte2_ = obs.getGfxdBytes(2);
            Assert.assertArrayEquals((byte[])bytes1, (byte[])byte1_);
            Assert.assertArrayEquals((byte[])bytes2, (byte[])byte2_);
            obs.getSerializedValue();
        }
        finally {
            stmt.execute("drop table X");
        }
    }

    @Override
    protected void doEndOffHeapValidations() throws Exception {
    }

    @Override
    public String getSuffix() {
        return " offheap ";
    }

    @Override
    public void waitTillAllClear() {
        try {
            this.rmcd.waitTillAllClear();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new GemFireXDRuntimeException((Throwable)ie);
        }
    }
}

