/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.offheap;

import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.offheap.OffHeapMemoryStats;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.RowLoader;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheLoader;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.offheap.CollectionBasedOHAddressCache;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OHAddressCache;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRegionEntryUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.RowChanger;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TargetResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialBlob;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.compile.IndexToBaseRowNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DeleteConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DeleteResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexSetChanger;
import com.pivotal.gemfirexd.internal.impl.sql.execute.JoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ProjectRestrictResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowChangerImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UpdateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.WriteCursorConstantAction;
import com.pivotal.gemfirexd.jdbc.GfxdCallbacksTest;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.sql.rowset.serial.SerialClob;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;
import udtexamples.UDTPrice;

public class OffHeapTest
extends JdbcTestBase {
    private JdbcTestBase.RegionMapClearDetector rmcd = null;

    public OffHeapTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(OffHeapTest.class));
    }

    @Override
    public String reduceLogging() {
        return "config";
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
        System.setProperty("gemfire.off-heap-memory-size", "500m");
        System.setProperty("gemfire.disableManagement", "true");
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
        this.rmcd = new JdbcTestBase.RegionMapClearDetector();
        CacheObserverHolder.setInstance((CacheObserver)this.rmcd);
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.rmcd);
    }

    @Override
    public void tearDown() throws Exception {
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
        CacheObserverHolder.setInstance(null);
        GemFireXDQueryObserverHolder.clearInstance();
        super.tearDown();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
        System.setProperty("gemfire.off-heap-memory-size", "");
        System.setProperty("gemfire.disableManagement", "");
    }

    public void testOffHeapMemoryReleaseWithoutLobsForInsertDeletes() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        java.sql.ResultSet rs = null;
        st.execute("create table trade.securities (sec_id int not null, exchange varchar(10) not null,  tid int, constraint sec_pk primary key (sec_id),  constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  replicate offheap");
        OffHeapMemoryStats stats = SimpleMemoryAllocatorImpl.getAllocator().getStats();
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        long freeMemBeforeInsert = stats.getFreeMemory();
        long refCountBeforeInserts = JDBC.getTotalRefCount(ma);
        PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?)");
        boolean sec_limit = true;
        for (int i = 0; i < 1; ++i) {
            psSec.setInt(1, i);
            psSec.setString(2, exchanges[i % exchanges.length]);
            psSec.setInt(3, 1);
            psSec.executeUpdate();
        }
        long freeMemAfterInserts = stats.getFreeMemory();
        long refCountAfterInserts = JDBC.getTotalRefCount(ma);
        OffHeapTest.assertTrue((refCountBeforeInserts != refCountAfterInserts ? 1 : 0) != 0);
        OffHeapTest.assertTrue((freeMemBeforeInsert != freeMemAfterInserts ? 1 : 0) != 0);
        rs = st.executeQuery("select * from trade.securities");
        int numRows = 0;
        while (rs.next()) {
            rs.getInt(1);
            rs.getString(2);
            ++numRows;
        }
        OffHeapTest.assertEquals((int)1, (int)numRows);
        OffHeapTest.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInserts);
        rs = st.executeQuery("select * from trade.securities order by sec_id");
        numRows = 0;
        while (rs.next()) {
            OffHeapTest.assertEquals((String)exchanges[numRows % exchanges.length], (String)rs.getString(2));
            ++numRows;
        }
        OffHeapTest.assertEquals((int)1, (int)numRows);
        OffHeapTest.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInserts);
        int numDeletes = st.executeUpdate("delete from trade.securities");
        OffHeapTest.assertEquals((int)1, (int)numDeletes);
        OffHeapTest.assertEquals((long)freeMemBeforeInsert, (long)stats.getFreeMemory());
    }

    public void testOffHeapMemoryReleaseLobsForInsertDeletes() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange)) offheap");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid) values (?,?,?,?,?,?,?,?,?,?,?,?)");
        OffHeapMemoryStats stats = SimpleMemoryAllocatorImpl.getAllocator().getStats();
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        long refCountBeforeInsert = JDBC.getTotalRefCount(ma);
        long freeSizeBeforeInserts = stats.getFreeMemory();
        DataGenerator dg = new DataGenerator();
        dg.insertIntoCompanies(psComp, "SYMB1", "NSE", 0);
        dg.insertIntoCompanies(psComp, "SYMB2", "BSE", 0);
        dg.insertIntoCompanies(psComp, "SYMB3", "LSE", 0);
        long refCountAfterInsert = JDBC.getTotalRefCount(ma);
        long freesizeAfterInserts = stats.getFreeMemory();
        OffHeapTest.assertTrue((freesizeAfterInserts != freeSizeBeforeInserts ? 1 : 0) != 0);
        OffHeapTest.assertTrue((refCountBeforeInsert != refCountAfterInsert ? 1 : 0) != 0);
        rs = st.executeQuery("select * from trade.companies");
        int numRows = 0;
        while (rs.next()) {
            rs.getString(1);
            ++numRows;
        }
        OffHeapTest.assertEquals((int)3, (int)numRows);
        OffHeapTest.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInsert);
        int numDeletes = st.executeUpdate("delete from trade.companies");
        OffHeapTest.assertEquals((int)3, (int)numDeletes);
        OffHeapTest.assertEquals((long)freeSizeBeforeInserts, (long)stats.getFreeMemory());
    }

    public void testOffHeapMemoryReleaseNoLobsForUpdate() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        java.sql.ResultSet rs = null;
        st.execute("create table trade.securities (sec_id int not null, exchange varchar(10) not null,  tid int, constraint sec_pk primary key (sec_id),  constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  replicate offheap");
        OffHeapMemoryStats stats = SimpleMemoryAllocatorImpl.getAllocator().getStats();
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        long freeSizeBeforeInserts = stats.getFreeMemory();
        long refCountBeforeInsert = JDBC.getTotalRefCount(ma);
        PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?)");
        boolean sec_limit = true;
        for (int i = 0; i < 1; ++i) {
            psSec.setInt(1, i);
            psSec.setString(2, exchanges[i % exchanges.length]);
            psSec.setInt(3, 1);
            psSec.executeUpdate();
        }
        long refCountAfterInsert = JDBC.getTotalRefCount(ma);
        OffHeapTest.assertTrue((refCountBeforeInsert != refCountAfterInsert ? 1 : 0) != 0);
        long freesizeAfterInserts = stats.getFreeMemory();
        OffHeapTest.assertTrue((freesizeAfterInserts != freeSizeBeforeInserts ? 1 : 0) != 0);
        rs = st.executeQuery("select * from trade.securities");
        int numRows = 0;
        while (rs.next()) {
            rs.getInt(1);
            ++numRows;
        }
        OffHeapTest.assertEquals((int)1, (int)numRows);
        OffHeapTest.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInsert);
        int numUpdate = st.executeUpdate("update trade.securities set tid = 5");
        OffHeapTest.assertEquals((int)1, (int)numUpdate);
        OffHeapTest.assertEquals((long)refCountAfterInsert, (long)JDBC.getTotalRefCount(ma));
        int numDeletes = st.executeUpdate("delete from trade.securities");
        OffHeapTest.assertEquals((int)1, (int)numDeletes);
        OffHeapTest.assertEquals((long)freeSizeBeforeInserts, (long)stats.getFreeMemory());
    }

    public void testOffHeapMemoryUpdatesForLobTables_1() throws Exception {
        int i;
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange)) offheap");
        st.execute("create index company_tid on trade.companies(tid)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid) values (?,?,?,?,?,?,?,?,?,?,?,?)");
        OffHeapMemoryStats stats = SimpleMemoryAllocatorImpl.getAllocator().getStats();
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        long freeSizeBeforeInserts = stats.getFreeMemory();
        long refCountBeforeInsert = JDBC.getTotalRefCount(ma);
        for (int i2 = 1; i2 < 100; i2 += 3) {
            DataGenerator dg = new DataGenerator();
            dg.insertIntoCompanies(psComp, "SYMB" + i2, "NSE", 0);
            dg.insertIntoCompanies(psComp, "SYMB2" + (i2 + 1), "BSE", 0);
            dg.insertIntoCompanies(psComp, "SYMB3" + (i2 + 2), "LSE", 0);
        }
        long refCountAfterInsert = JDBC.getTotalRefCount(ma);
        OffHeapTest.assertTrue((refCountBeforeInsert != refCountAfterInsert ? 1 : 0) != 0);
        long freesizeAfterInserts = stats.getFreeMemory();
        OffHeapTest.assertTrue((freesizeAfterInserts != freeSizeBeforeInserts ? 1 : 0) != 0);
        rs = st.executeQuery("select * from trade.companies where companyname is not null ");
        int numRows = 0;
        int numCols = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            for (int i3 = 0; i3 < numCols; ++i3) {
                rs.getObject(i3 + 1);
            }
            ++numRows;
        }
        OffHeapTest.assertEquals((int)99, (int)numRows);
        OffHeapTest.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInsert);
        int numUpdate = st.executeUpdate("update trade.companies set companyname = 'xyzzz'");
        OffHeapTest.assertEquals((int)99, (int)numUpdate);
        OffHeapTest.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInsert);
        rs = st.executeQuery("select * from trade.companies");
        rs.next();
        StringBuilder sb = new StringBuilder(100);
        sb.append("xyzzz");
        for (i = 0; i < 95; ++i) {
            sb.append(' ');
        }
        OffHeapTest.assertEquals((String)sb.toString(), (String)rs.getString(6));
        numUpdate = st.executeUpdate("update trade.companies set companyname = 'zzz'");
        OffHeapTest.assertEquals((int)99, (int)numUpdate);
        OffHeapTest.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInsert);
        rs = st.executeQuery("select * from trade.companies where  tid = 10");
        numRows = 0;
        numCols = rs.getMetaData().getColumnCount();
        if (rs.next()) {
            for (i = 0; i < numCols; ++i) {
                rs.getObject(i + 1);
            }
            ++numRows;
        }
        OffHeapTest.assertEquals((int)1, (int)numRows);
        int numDeletes = st.executeUpdate("delete from trade.companies");
        OffHeapTest.assertEquals((int)99, (int)numDeletes);
        OffHeapTest.assertEquals((long)freeSizeBeforeInserts, (long)stats.getFreeMemory());
    }

    public void testLobMemoryReleaseOnRegionClose() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        Object rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange)) offheap");
        st.execute("create index company_tid on trade.companies(tid)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid) values (?,?,?,?,?,?,?,?,?,?,?,?)");
        OffHeapMemoryStats stats = SimpleMemoryAllocatorImpl.getAllocator().getStats();
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        long freeSizeBeforeInserts = stats.getFreeMemory();
        long refCountBeforeInsert = JDBC.getTotalRefCount(ma);
        for (int i = 1; i < 2; ++i) {
            DataGenerator dg = new DataGenerator();
            dg.insertIntoCompanies(psComp, "SYMB" + i, "NSE", 0);
        }
        long refCountAfterInsert = JDBC.getTotalRefCount(ma);
        OffHeapTest.assertTrue((refCountBeforeInsert != refCountAfterInsert ? 1 : 0) != 0);
        long freesizeAfterInserts = stats.getFreeMemory();
        OffHeapTest.assertTrue((freesizeAfterInserts != freeSizeBeforeInserts ? 1 : 0) != 0);
        int numUpdate = st.executeUpdate("update trade.companies set companyname = 'xyzzz'");
        OffHeapTest.assertEquals((int)1, (int)numUpdate);
        OffHeapTest.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInsert);
        numUpdate = st.executeUpdate("update trade.companies set companyname = 'zzz'");
        OffHeapTest.assertEquals((int)1, (int)numUpdate);
        OffHeapTest.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInsert);
    }

    public void testOffHeapMemoryReleaseOnUniqueConstraintViolation() throws Exception {
        Statement s;
        block2: {
            Connection conn = OffHeapTest.getConnection();
            s = conn.createStatement();
            s.execute("create schema EMP");
            s.execute("create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRD int not null, FOURTH int not null, FIFTH int not null, primary key (ID, SECONDID)) PARTITION BY COLUMN (ID)offheap");
            s.execute("create unique index third_index on EMP.PARTITIONTESTTABLE (THIRD)");
            s.execute("INSERT INTO EMP.PARTITIONTESTTABLE values(1,2,3,4, 10)");
            s.execute("INSERT INTO EMP.PARTITIONTESTTABLE values(4,5,6,4, 11)");
            OffHeapTest.addExpectedException(EntryExistsException.class);
            try {
                s.execute("UPDATE EMP.PARTITIONTESTTABLE SET third=6, fifth=20 where id=1 and secondid=2");
                OffHeapTest.fail("Exception is expected!");
            }
            catch (SQLException ex) {
                if ("23505".equals(ex.getSQLState())) break block2;
                throw ex;
            }
        }
        s.execute("delete from EMP.PARTITIONTESTTABLE  where id=1 and secondid=2");
        this.doOffHeapValidations();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        this.rmcd.waitTillAllClear();
        s.execute("drop schema EMP RESTRICT");
        this.doOffHeapValidations();
    }

    public void testLobCols() throws Exception {
        int i;
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        int lobColCount = 900;
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        String tableDef = "create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int,";
        for (int i2 = 0; i2 < lobColCount; ++i2) {
            tableDef = tableDef + " lob" + i2 + " varchar(100) for bit data, ";
        }
        tableDef = tableDef + " constraint comp_pk primary key (symbol, exchange)) offheap";
        st.execute(tableDef);
        String insertStatement = "insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid";
        for (i = 0; i < lobColCount; ++i) {
            insertStatement = insertStatement + ",lob" + i;
        }
        insertStatement = insertStatement + ") values(";
        for (i = 0; i < 12 + lobColCount; ++i) {
            insertStatement = insertStatement + "?,";
        }
        insertStatement = insertStatement.substring(0, insertStatement.length() - 1);
        insertStatement = insertStatement + ")";
        PreparedStatement psComp = conn.prepareStatement(insertStatement);
        OffHeapMemoryStats stats = SimpleMemoryAllocatorImpl.getAllocator().getStats();
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        long refCountBeforeInsert = JDBC.getTotalRefCount(ma);
        long freeSizeBeforeInserts = stats.getFreeMemory();
        DataGenerator dg = new DataGenerator();
        dg.insertIntoCompanies(psComp, "SYMB1", "NSE", lobColCount);
        dg.insertIntoCompanies(psComp, "SYMB2", "BSE", lobColCount);
        dg.insertIntoCompanies(psComp, "SYMB3", "LSE", lobColCount);
        long refCountAfterInsert = JDBC.getTotalRefCount(ma);
        long freesizeAfterInserts = stats.getFreeMemory();
        OffHeapTest.assertTrue((freesizeAfterInserts != freeSizeBeforeInserts ? 1 : 0) != 0);
        OffHeapTest.assertTrue((refCountBeforeInsert != refCountAfterInsert ? 1 : 0) != 0);
        rs = st.executeQuery("select * from trade.companies");
        int numRows = 0;
        while (rs.next()) {
            for (int i3 = 12; i3 < lobColCount + 12; ++i3) {
                byte[] bytes = rs.getBytes(i3 + 1);
                ByteBuffer buff = ByteBuffer.wrap(bytes);
                OffHeapTest.assertEquals((int)(i3 - 12), (int)buff.getInt());
            }
            ++numRows;
        }
        OffHeapTest.assertEquals((int)3, (int)numRows);
        OffHeapTest.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInsert);
        int numDeletes = st.executeUpdate("delete from trade.companies");
        OffHeapTest.assertEquals((int)3, (int)numDeletes);
        OffHeapTest.assertEquals((long)freeSizeBeforeInserts, (long)stats.getFreeMemory());
    }

    public void testOffHeapMemoryReleaseOnForeignkeyConstraintViolation() throws Exception {
        Statement s;
        Connection conn;
        block2: {
            conn = OffHeapTest.getConnection();
            s = conn.createStatement();
            int rowCount = 0;
            s.executeUpdate("create table t2(id int not null, primary key(id))OFFHEAP");
            s.executeUpdate("create table t1(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t2(id))replicate offheap");
            rowCount += s.executeUpdate("insert into t2 values(1)");
            rowCount += s.executeUpdate("insert into t2 values(2)");
            rowCount += s.executeUpdate("insert into t1 values(1, 1)");
            rowCount += s.executeUpdate("update t1 set fkId =2 ");
            try {
                s.executeUpdate("update t1 set fkId =3 where id =1");
                OffHeapTest.fail("should have thrown an SQLException");
            }
            catch (SQLException ex) {
                if ("23503".equals(ex.getSQLState())) break block2;
                throw ex;
            }
        }
        s.executeUpdate("delete from t1 where id = 1");
        conn.commit();
        s.close();
    }

    public void testOptimizedOHAddressCacheForUpdateNoIndexes() throws Exception {
        Connection conn = OffHeapTest.getConnection();
        Statement s = conn.createStatement();
        int rowCount = 0;
        s.executeUpdate("create table t2(id int not null, primary key(id))OFFHEAP");
        s.executeUpdate("create table t1(id int not null, fkId int not null,col1 int not null unique, primary key(id), foreign key (fkId) references t2(id))replicate offheap");
        rowCount += s.executeUpdate("insert into t2 values(2)");
        rowCount += s.executeUpdate("insert into t2 values(1)");
        rowCount += s.executeUpdate("insert into t2 values(3)");
        rowCount += s.executeUpdate("insert into t1 values(2, 2,2)");
        rowCount += s.executeUpdate("insert into t1 values(3, 2,3)");
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

            public void onUpdateResultSetOpen(ResultSet resultset) {
                try {
                    OffHeapTest.this.conditionResultSet((ResultSet)((UpdateResultSet)resultset));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        rowCount += s.executeUpdate("update t1 set fkId =3 ");
        s.executeUpdate("update t1 set col1 = col1 *3");
        s.executeUpdate("delete from t1 where id = 2");
        conn.commit();
        s.close();
    }

    public void testOptimizedOHAddressCacheForUpdateNoPK_1() throws Exception {
        if (isTransactional) {
            return;
        }
        Connection conn = OffHeapTest.getConnection();
        Statement s = conn.createStatement();
        int rowCount = 0;
        s.executeUpdate("create table t2(id int not null, primary key(id))OFFHEAP");
        s.executeUpdate("create table t1(id int not null, fkId int not null,col1 int not null ,  foreign key (fkId) references t2(id))replicate offheap");
        rowCount += s.executeUpdate("insert into t2 values(2)");
        rowCount += s.executeUpdate("insert into t2 values(1)");
        rowCount += s.executeUpdate("insert into t2 values(3)");
        rowCount += s.executeUpdate("insert into t1 values(2, 2,2)");
        rowCount += s.executeUpdate("insert into t1 values(3, 2,3)");
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

            public void onUpdateResultSetOpen(ResultSet resultset) {
                try {
                    OffHeapTest.this.conditionResultSet((ResultSet)((UpdateResultSet)resultset));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        rowCount += s.executeUpdate("update t1 set ID = 5,fkId =3, col1 = 7 ");
        s.executeUpdate("update t1 set col1 = col1 *3");
        s.executeUpdate("delete from t1 where id = 2");
        conn.commit();
        s.close();
    }

    public void testOptimizedOHAddressCacheForUpdateNoPK_2() throws Exception {
        if (isTransactional) {
            return;
        }
        Connection conn = OffHeapTest.getConnection();
        Statement s = conn.createStatement();
        int rowCount = 0;
        s.executeUpdate("create table t2(id int not null, primary key(id))OFFHEAP");
        s.executeUpdate("create table t1(id int not null, fkId int not null,col1 int not null unique ,  foreign key (fkId) references t2(id))replicate offheap");
        rowCount += s.executeUpdate("insert into t2 values(2)");
        rowCount += s.executeUpdate("insert into t2 values(1)");
        rowCount += s.executeUpdate("insert into t2 values(3)");
        rowCount += s.executeUpdate("insert into t1 values(2, 2,2)");
        rowCount += s.executeUpdate("insert into t1 values(3, 2,3)");
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

            public void onUpdateResultSetOpen(ResultSet resultset) {
                try {
                    OffHeapTest.this.conditionResultSet((ResultSet)((UpdateResultSet)resultset));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        rowCount += s.executeUpdate("update t1 set ID = 5,fkId =3, col1 = col1 *7 ");
        s.executeUpdate("update t1 set col1 = col1 *3");
        s.executeUpdate("delete from t1 where id = 2");
        conn.commit();
        s.close();
    }

    public void testOptimizedOHAddressCacheForNonDeferrredDelete() throws Exception {
        Connection conn = OffHeapTest.getConnection();
        Statement s = conn.createStatement();
        int rowCount = 0;
        s.executeUpdate("create table t2(id int not null, primary key(id))OFFHEAP");
        s.executeUpdate("create table t1(id int not null, fkId int not null,col1 int  ,  foreign key (fkId) references t2(id))replicate offheap");
        s.execute("create index t1_col1 on t1(col1)");
        rowCount += s.executeUpdate("insert into t2 values(2)");
        rowCount += s.executeUpdate("insert into t2 values(1)");
        rowCount += s.executeUpdate("insert into t2 values(3)");
        rowCount += s.executeUpdate("insert into t1 values(2, 2,2)");
        rowCount += s.executeUpdate("insert into t1 values(3, 2,3)");
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

            public void onDeleteResultSetOpen(ResultSet resultset) {
                try {
                    OffHeapTest.this.conditionResultSet((ResultSet)((DeleteResultSet)resultset));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        s.executeUpdate("delete from t1 where col1 = 2");
        conn.commit();
        s.close();
    }

    public void testOptimizedOHAddressCacheForUpdate() throws Exception {
        Connection conn = OffHeapTest.getConnection();
        Statement s = conn.createStatement();
        int rowCount = 0;
        s.executeUpdate("create table t2(id int not null, primary key(id))OFFHEAP");
        s.executeUpdate("create table t1(id int not null, fkId int not null,col1 int  ,  foreign key (fkId) references t2(id))replicate offheap");
        s.execute("create index t1_col1 on t1(col1)");
        rowCount += s.executeUpdate("insert into t2 values(2)");
        rowCount += s.executeUpdate("insert into t2 values(1)");
        rowCount += s.executeUpdate("insert into t2 values(3)");
        rowCount += s.executeUpdate("insert into t1 values(2, 2,2)");
        rowCount += s.executeUpdate("insert into t1 values(3, 2,3)");
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

            public void onUpdateResultSetOpen(ResultSet resultset) {
                try {
                    OffHeapTest.this.conditionResultSet((ResultSet)((UpdateResultSet)resultset));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        rowCount += s.executeUpdate("update t1 set ID = 5,fkId =3, col1 = 7 ");
        s.executeUpdate("update t1 set col1 = col1 *3");
        s.executeUpdate("delete from t1 where id = 2");
        conn.commit();
        s.close();
    }

    public void testOffHeapOHAddressCacheForDeferredDeleteRefConstraint() throws Exception {
        if (isTransactional) {
            return;
        }
        Connection conn = OffHeapTest.getConnection();
        Statement s = conn.createStatement();
        int rowCount = 0;
        s.executeUpdate("create table t2(id int not null, primary key(id), col1 int unique, fkId int not null ,  foreign key (fkId) references t2(col1))OFFHEAP");
        s.executeUpdate("create table t1(id int not null, fkId int not null,col1 int  ,  foreign key (fkId) references t2(col1))replicate offheap");
        s.execute("create index t1_col1 on t1(col1)");
        rowCount += s.executeUpdate("insert into t2 values(1,1,1)");
        rowCount += s.executeUpdate("insert into t2 values(2,2,1)");
        rowCount += s.executeUpdate("insert into t2 values(3,3,1)");
        rowCount += s.executeUpdate("insert into t1 values(2, 2,2)");
        rowCount += s.executeUpdate("insert into t1 values(3, 2,3)");
        s.executeUpdate("delete from t1 where fkid = 2");
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){
            private Map<RowLocation, byte[]> rowLocToBytes;
            private List<CompactCompositeIndexKey> indexKeys = new ArrayList<CompactCompositeIndexKey>();

            private void reflectAndAssert(ResultSet resultSet, Class<?> resultsetClass) throws Exception {
                Field sourceField = resultsetClass.getDeclaredField("source");
                sourceField.setAccessible(true);
                ProjectRestrictResultSet psRs = (ProjectRestrictResultSet)sourceField.get(resultSet);
                TableScanResultSet ts = (TableScanResultSet)psRs.getSource();
                Class<TableScanResultSet> tableScanClazz = TableScanResultSet.class;
                Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                field.setAccessible(true);
                OHAddressCache addressCache = (OHAddressCache)field.get(ts);
                Class<TableScanResultSet.SingleOHAddressCache> addressCacheClass = TableScanResultSet.SingleOHAddressCache.class;
                TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
            }

            public void onDeleteResultSetOpen(ResultSet resultset) {
                try {
                    this.reflectAndAssert(resultset, DeleteResultSet.class);
                    this.populateIndexKeys((DeleteResultSet)resultset);
                    this.rowLocToBytes = OffHeapTest.this.conditionResultSet((ResultSet)((DeleteResultSet)resultset));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void onDeleteResultSetOpenBeforeRefChecks(ResultSet resultSet) {
                try {
                    for (Map.Entry<RowLocation, byte[]> entry : this.rowLocToBytes.entrySet()) {
                        RowLocation rowLoc = entry.getKey();
                        SimpleMemoryAllocatorImpl.Chunk chunk = (SimpleMemoryAllocatorImpl.Chunk)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])entry.getValue(), (boolean)false);
                        Iterator<CompactCompositeIndexKey> keyIters = this.indexKeys.iterator();
                        ArrayList<OffHeapByteSource> matchedOHBS = new ArrayList<OffHeapByteSource>();
                        while (keyIters.hasNext()) {
                            long oldAddress;
                            OffHeapByteSource obs;
                            long address;
                            CompactCompositeIndexKey ccik = keyIters.next();
                            Class<CompactCompositeKey> compactCompositeKeyClass = CompactCompositeKey.class;
                            Field valueBytesField = compactCompositeKeyClass.getDeclaredField("valueBytes");
                            valueBytesField.setAccessible(true);
                            Object valueBytes = valueBytesField.get(ccik);
                            if (!(valueBytes instanceof OffHeapByteSource) || (address = (obs = (OffHeapByteSource)valueBytes).getMemoryAddress()) != (oldAddress = ((OffHeapRegionEntry)rowLoc).getAddress())) continue;
                            matchedOHBS.add(obs);
                            keyIters.remove();
                        }
                        if (!matchedOHBS.isEmpty()) {
                            Class<SimpleMemoryAllocatorImpl.Chunk> chunkClass = SimpleMemoryAllocatorImpl.Chunk.class;
                            Field memoryAddressField = chunkClass.getDeclaredField("memoryAddress");
                            memoryAddressField.setAccessible(true);
                            for (OffHeapByteSource ohbs : matchedOHBS) {
                                memoryAddressField.setLong(ohbs, chunk.getMemoryAddress());
                            }
                        }
                        Class<?> entryClass = rowLoc.getClass();
                        Field ohAddressField = entryClass.getDeclaredField("ohAddress");
                        ohAddressField.setAccessible(true);
                        ohAddressField.setLong(rowLoc, chunk.getMemoryAddress());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void populateIndexKeys(DeleteResultSet resultset) {
                try {
                    Class<DeleteResultSet> updateResultSetClass = DeleteResultSet.class;
                    Field containerField = updateResultSetClass.getDeclaredField("container");
                    containerField.setAccessible(true);
                    GemFireContainer container = (GemFireContainer)containerField.get(resultset);
                    List containers = container.getIndexManager().getAllIndexes();
                    for (GemFireContainer idxCont : containers) {
                        ConcurrentSkipListMap map = idxCont.getSkipListMap();
                        if (map == null) continue;
                        for (Object key : map.keySet()) {
                            if (!(key instanceof CompactCompositeIndexKey)) continue;
                            this.indexKeys.add((CompactCompositeIndexKey)key);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        s.executeUpdate("delete from t2 where col1 = 2");
        conn.commit();
        s.close();
    }

    public void testOffHeapOHAddressCacheForDeferredDeleteWithSubquery() throws Exception {
        Connection conn = OffHeapTest.getConnection();
        Statement s = conn.createStatement();
        int rowCount = 0;
        s.executeUpdate("create table t2(id int not null, primary key(id), col1 int unique)OFFHEAP");
        rowCount += s.executeUpdate("insert into t2 values(1,1)");
        rowCount += s.executeUpdate("insert into t2 values(2,2)");
        rowCount += s.executeUpdate("insert into t2 values(3,3)");
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){
            private Map<RowLocation, byte[]> rowLocToBytes;
            private List<CompactCompositeIndexKey> indexKeys = new ArrayList<CompactCompositeIndexKey>();

            private void reflectAndAssert(ResultSet resultSet, Class<?> resultsetClass) throws Exception {
                Field sourceField = resultsetClass.getDeclaredField("source");
                sourceField.setAccessible(true);
                ProjectRestrictResultSet psRs = (ProjectRestrictResultSet)sourceField.get(resultSet);
                JoinResultSet jrs = (JoinResultSet)psRs.getSource();
                TableScanResultSet ts = (TableScanResultSet)jrs.leftResultSet;
                Class<TableScanResultSet> tableScanClazz = TableScanResultSet.class;
                Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                field.setAccessible(true);
                OHAddressCache addressCache = (OHAddressCache)field.get(ts);
                Class<TableScanResultSet.SingleOHAddressCache> addressCacheClass = TableScanResultSet.SingleOHAddressCache.class;
                TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
            }

            public void onDeleteResultSetOpen(ResultSet resultset) {
                try {
                    this.reflectAndAssert(resultset, DeleteResultSet.class);
                    this.populateIndexKeys((DeleteResultSet)resultset);
                    this.rowLocToBytes = OffHeapTest.this.conditionResultSet((ResultSet)((DeleteResultSet)resultset));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void beforeDeferredDelete() {
                try {
                    for (Map.Entry<RowLocation, byte[]> entry : this.rowLocToBytes.entrySet()) {
                        RowLocation rowLoc = entry.getKey();
                        SimpleMemoryAllocatorImpl.Chunk chunk = (SimpleMemoryAllocatorImpl.Chunk)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])entry.getValue(), (boolean)false);
                        Iterator<CompactCompositeIndexKey> keyIters = this.indexKeys.iterator();
                        ArrayList<OffHeapByteSource> matchedOHBS = new ArrayList<OffHeapByteSource>();
                        while (keyIters.hasNext()) {
                            long oldAddress;
                            OffHeapByteSource obs;
                            long address;
                            CompactCompositeIndexKey ccik = keyIters.next();
                            Class<CompactCompositeKey> compactCompositeKeyClass = CompactCompositeKey.class;
                            Field valueBytesField = compactCompositeKeyClass.getDeclaredField("valueBytes");
                            valueBytesField.setAccessible(true);
                            Object valueBytes = valueBytesField.get(ccik);
                            if (!(valueBytes instanceof OffHeapByteSource) || (address = (obs = (OffHeapByteSource)valueBytes).getMemoryAddress()) != (oldAddress = ((OffHeapRegionEntry)rowLoc).getAddress())) continue;
                            matchedOHBS.add(obs);
                            keyIters.remove();
                        }
                        if (!matchedOHBS.isEmpty()) {
                            Class<SimpleMemoryAllocatorImpl.Chunk> chunkClass = SimpleMemoryAllocatorImpl.Chunk.class;
                            Field memoryAddressField = chunkClass.getDeclaredField("memoryAddress");
                            memoryAddressField.setAccessible(true);
                            for (OffHeapByteSource ohbs : matchedOHBS) {
                                memoryAddressField.setLong(ohbs, chunk.getMemoryAddress());
                            }
                        }
                        Class<?> entryClass = rowLoc.getClass();
                        Field ohAddressField = entryClass.getDeclaredField("ohAddress");
                        ohAddressField.setAccessible(true);
                        ohAddressField.setLong(rowLoc, chunk.getMemoryAddress());
                    }
                    TestCase.assertTrue((boolean)this.indexKeys.isEmpty());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void populateIndexKeys(DeleteResultSet resultset) {
                try {
                    Class<DeleteResultSet> updateResultSetClass = DeleteResultSet.class;
                    Field containerField = updateResultSetClass.getDeclaredField("container");
                    containerField.setAccessible(true);
                    GemFireContainer container = (GemFireContainer)containerField.get(resultset);
                    List containers = container.getIndexManager().getAllIndexes();
                    for (GemFireContainer idxCont : containers) {
                        ConcurrentSkipListMap map = idxCont.getSkipListMap();
                        if (map == null) continue;
                        for (Object key : map.keySet()) {
                            if (!(key instanceof CompactCompositeIndexKey)) continue;
                            this.indexKeys.add((CompactCompositeIndexKey)key);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        s.executeUpdate("delete from t2 where Col1 IN (select COL1 from t2 where ID in (1,2) )");
        conn.commit();
        s.close();
    }

    public void testOptimizedOHAddressCacheForDeferredUpdate() throws Exception {
        Connection conn = OffHeapTest.getConnection();
        Statement s = conn.createStatement();
        conn.setTransactionIsolation(0);
        conn.setAutoCommit(true);
        int rowCount = 0;
        s.executeUpdate("create table t1(id int not null unique, col1 int  )replicate offheap");
        s.executeUpdate("create table t2(id int not null, fkId int not null ,primary key(id), foreign key (fkId) references t1(id))OFFHEAP");
        s.execute("create index t1_col1 on t1(col1)");
        rowCount += s.executeUpdate("insert into t1 values(1, 1)");
        rowCount += s.executeUpdate("insert into t1 values(2,2)");
        rowCount += s.executeUpdate("insert into t1 values(3,2)");
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){
            private Map<RowLocation, byte[]> rowLocToBytes;
            private List<CompactCompositeIndexKey> indexKeys = new ArrayList<CompactCompositeIndexKey>();

            public void onUpdateResultSetOpen(ResultSet resultset) {
                this.populateIndexKeys((UpdateResultSet)resultset);
                try {
                    this.rowLocToBytes = OffHeapTest.this.conditionResultSet((ResultSet)((UpdateResultSet)resultset));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void beforeDeferredUpdate() {
                try {
                    for (Map.Entry<RowLocation, byte[]> entry : this.rowLocToBytes.entrySet()) {
                        RowLocation rowLoc = entry.getKey();
                        SimpleMemoryAllocatorImpl.Chunk chunk = (SimpleMemoryAllocatorImpl.Chunk)OffHeapRegionEntryUtils.prepareValueForCreate(null, (byte[])entry.getValue(), (boolean)false);
                        Iterator<CompactCompositeIndexKey> keyIters = this.indexKeys.iterator();
                        ArrayList<OffHeapByteSource> matchedOHBS = new ArrayList<OffHeapByteSource>();
                        while (keyIters.hasNext()) {
                            long oldAddress;
                            OffHeapByteSource obs;
                            long address;
                            CompactCompositeIndexKey ccik = keyIters.next();
                            Class<CompactCompositeKey> compactCompositeKeyClass = CompactCompositeKey.class;
                            Field valueBytesField = compactCompositeKeyClass.getDeclaredField("valueBytes");
                            valueBytesField.setAccessible(true);
                            Object valueBytes = valueBytesField.get(ccik);
                            if (!(valueBytes instanceof OffHeapByteSource) || (address = (obs = (OffHeapByteSource)valueBytes).getMemoryAddress()) != (oldAddress = ((OffHeapRegionEntry)rowLoc).getAddress())) continue;
                            matchedOHBS.add(obs);
                            keyIters.remove();
                        }
                        if (!matchedOHBS.isEmpty()) {
                            Class<SimpleMemoryAllocatorImpl.Chunk> chunkClass = SimpleMemoryAllocatorImpl.Chunk.class;
                            Field memoryAddressField = chunkClass.getDeclaredField("memoryAddress");
                            memoryAddressField.setAccessible(true);
                            for (OffHeapByteSource ohbs : matchedOHBS) {
                                memoryAddressField.setLong(ohbs, chunk.getMemoryAddress());
                            }
                        }
                        Class<?> entryClass = rowLoc.getClass();
                        Field ohAddressField = entryClass.getDeclaredField("ohAddress");
                        ohAddressField.setAccessible(true);
                        ohAddressField.setLong(rowLoc, chunk.getMemoryAddress());
                    }
                    TestCase.assertTrue((boolean)this.indexKeys.isEmpty());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void populateIndexKeys(UpdateResultSet resultset) {
                try {
                    Class<UpdateResultSet> updateResultSetClass = UpdateResultSet.class;
                    Field containerField = updateResultSetClass.getDeclaredField("container");
                    containerField.setAccessible(true);
                    GemFireContainer container = (GemFireContainer)containerField.get(resultset);
                    List containers = container.getIndexManager().getAllIndexes();
                    for (GemFireContainer idxCont : containers) {
                        ConcurrentSkipListMap map = idxCont.getSkipListMap();
                        for (Object key : map.keySet()) {
                            if (!(key instanceof CompactCompositeIndexKey)) continue;
                            this.indexKeys.add((CompactCompositeIndexKey)key);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        rowCount += s.executeUpdate("insert into t2 values(1,2)");
        rowCount += s.executeUpdate("insert into t2 values(2,2)");
        rowCount += s.executeUpdate("insert into t2 values(3,2)");
        s.executeUpdate("update t1 set col1 = col1 +1 ");
        s.executeUpdate("update t1 set col1 = col1 *3");
        conn.commit();
        s.close();
    }

    public void _testOrphanInHA() throws Exception {
        Connection conn = OffHeapTest.getConnection();
        Statement s = conn.createStatement();
        int rowCount = 0;
        s.executeUpdate("create table t1(id int not null unique, col1 int  )replicate offheap");
        s.executeUpdate("create table t2(id int not null, fkId int not null ,primary key(id), foreign key (fkId) references t1(id))OFFHEAP");
        s.execute("create index t1_col1 on t1(col1)");
        rowCount += s.executeUpdate("insert into t1 values(1, 1)");
        rowCount += s.executeUpdate("insert into t1 values(2,2)");
        rowCount += s.executeUpdate("insert into t1 values(3,2)");
        rowCount += s.executeUpdate("insert into t2 values(1,2)");
        rowCount += s.executeUpdate("insert into t2 values(2,2)");
        rowCount += s.executeUpdate("insert into t2 values(3,2)");
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){
            private Map<RowLocation, byte[]> rowLocToBytes;
            private List<CompactCompositeIndexKey> indexKeys = new ArrayList<CompactCompositeIndexKey>();

            public void onUpdateResultSetDoneUpdate(ResultSet resultset) {
                try {
                    Thread th = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Misc.getGemFireCache().close();
                        }
                    });
                    th.start();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        s.executeUpdate("update t1 set col1 = col1 +1 ");
        conn.commit();
        s.close();
    }

    protected Map<RowLocation, byte[]> conditionResultSet(ResultSet resultset) throws Exception {
        boolean deferred;
        int resultWidth;
        Class<UpdateResultSet> clazz;
        final HashMap rowLocToAddressMap = new HashMap();
        final HashMap<RowLocation, byte[]> rowLocToBytes = new HashMap<RowLocation, byte[]>();
        final boolean isUpdate = resultset instanceof UpdateResultSet;
        if (isUpdate) {
            clazz = UpdateResultSet.class;
            Field resultWidthField = clazz.getDeclaredField("resultWidth");
            resultWidthField.setAccessible(true);
            resultWidth = (Integer)resultWidthField.get(resultset);
            Field deferredField = clazz.getDeclaredField("deferred");
            deferredField.setAccessible(true);
            deferred = (Boolean)deferredField.get(resultset);
        } else {
            boolean tempDef;
            clazz = DeleteResultSet.class;
            Field constantsField = clazz.getDeclaredField("constants");
            constantsField.setAccessible(true);
            DeleteConstantAction constants = (DeleteConstantAction)constantsField.get(resultset);
            Field deferredField = WriteCursorConstantAction.class.getDeclaredField("deferred");
            deferredField.setAccessible(true);
            deferred = tempDef = ((Boolean)deferredField.get(constants)).booleanValue();
            resultWidth = -1;
        }
        Field rowChangerField = isUpdate ? clazz.getDeclaredField("rowChanger") : clazz.getDeclaredField("rc");
        rowChangerField.setAccessible(true);
        final RowChanger rowChanger = (RowChanger)rowChangerField.get(resultset);
        RowChanger rowChangerPassThru = new RowChanger(){

            public void open(int lockMode) throws StandardException {
                rowChanger.open(lockMode);
            }

            public void setRowHolder(TemporaryRowHolder rowHolder) {
                rowChanger.setRowHolder(rowHolder);
            }

            public void setIndexNames(String[] indexNames) {
                rowChanger.setIndexNames(indexNames);
            }

            public void openForUpdate(boolean[] fixOnUpdate, int lockMode, boolean wait) throws StandardException {
                rowChanger.openForUpdate(fixOnUpdate, lockMode, wait);
            }

            public void insertRow(ExecRow baseRow) throws StandardException {
                rowChanger.insertRow(baseRow);
            }

            public boolean deleteRow(ExecRow baseRow, RowLocation baseRowLocation) throws StandardException {
                try {
                    Class<RowChangerImpl> rowChangerImplClass = RowChangerImpl.class;
                    Field iscField = rowChangerImplClass.getDeclaredField("isc");
                    iscField.setAccessible(true);
                    IndexSetChanger isc = (IndexSetChanger)iscField.get(rowChanger);
                    if (isc != null) {
                        isc.delete(baseRow, baseRowLocation);
                        iscField.set(rowChanger, null);
                    }
                    if (!deferred) {
                        long address = (Long)rowLocToAddressMap.get(baseRowLocation);
                        SimpleMemoryAllocatorImpl.Chunk.retain((long)address);
                    }
                    boolean result = rowChanger.deleteRow(baseRow, baseRowLocation);
                    if (isc != null) {
                        iscField.set(rowChanger, isc);
                    }
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean updateRow(ExecRow oldBaseRow, ExecRow newBaseRow, RowLocation baseRowLocation) throws StandardException {
                try {
                    Class<RowChangerImpl> rowChangerImplClass = RowChangerImpl.class;
                    Field iscField = rowChangerImplClass.getDeclaredField("isc");
                    iscField.setAccessible(true);
                    IndexSetChanger isc = (IndexSetChanger)iscField.get(rowChanger);
                    if (isc != null) {
                        isc.update(oldBaseRow, newBaseRow, baseRowLocation);
                        iscField.set(rowChanger, null);
                    }
                    if (!deferred) {
                        long address = (Long)rowLocToAddressMap.get(baseRowLocation);
                        SimpleMemoryAllocatorImpl.Chunk.retain((long)address);
                    }
                    boolean result = rowChanger.updateRow(oldBaseRow, newBaseRow, baseRowLocation);
                    if (isc != null) {
                        iscField.set(rowChanger, isc);
                    }
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void finish() throws StandardException {
                rowChanger.finish();
            }

            public void close() throws StandardException {
                rowChanger.close();
            }

            public ConglomerateController getHeapConglomerateController() {
                return rowChanger.getHeapConglomerateController();
            }

            public void open(int lockMode, boolean wait) throws StandardException {
                rowChanger.open(lockMode, wait);
            }
        };
        rowChangerField.set(resultset, rowChangerPassThru);
        Field sourceField = clazz.getDeclaredField("source");
        sourceField.setAccessible(true);
        final NoPutResultSet noputResultSet = (NoPutResultSet)sourceField.get(resultset);
        NoPutResultSet testResultSetPassThru = new NoPutResultSet(){
            private List<RowLocation> rowsScanned = new ArrayList<RowLocation>();

            public void deleteRowDirectly() throws StandardException {
                noputResultSet.deleteRowDirectly();
            }

            public boolean canUpdateInPlace() {
                return noputResultSet.canUpdateInPlace();
            }

            public boolean needsToClone() {
                return noputResultSet.needsToClone();
            }

            public FormatableBitSet getValidColumns() {
                return noputResultSet.getValidColumns();
            }

            public ExecRow getNextRowFromRowSource() throws StandardException {
                return noputResultSet.getNextRowFromRowSource();
            }

            public void closeRowSource() {
                noputResultSet.closeRowSource();
            }

            public void rowLocation(RowLocation rl) throws StandardException {
                noputResultSet.rowLocation(rl);
            }

            public boolean needsRowLocation() {
                return noputResultSet.needsRowLocation();
            }

            public ExecRow setBeforeFirstRow() throws StandardException {
                return noputResultSet.setBeforeFirstRow();
            }

            public ExecRow setAfterLastRow() throws StandardException {
                return noputResultSet.setAfterLastRow();
            }

            public boolean returnsRows() {
                return noputResultSet.returnsRows();
            }

            public void resetStatistics() {
                noputResultSet.resetStatistics();
            }

            public boolean releaseLocks(GemFireTransaction tran) {
                return noputResultSet.releaseLocks(tran);
            }

            public void open() throws StandardException {
                noputResultSet.open();
            }

            public int modifiedRowCount() {
                return noputResultSet.modifiedRowCount();
            }

            public void markLocallyExecuted() {
                noputResultSet.markLocallyExecuted();
            }

            public boolean isDistributedResultSet() {
                return noputResultSet.isDistributedResultSet();
            }

            public boolean isClosed() {
                return noputResultSet.isClosed();
            }

            public boolean hasAutoGeneratedKeysResultSet() {
                return noputResultSet.hasAutoGeneratedKeysResultSet();
            }

            public SQLWarning getWarnings() {
                return noputResultSet.getWarnings();
            }

            public long getTimeSpent(int type, int timeType) {
                return noputResultSet.getTimeSpent(type, timeType);
            }

            public NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
                return noputResultSet.getSubqueryTrackingArray(numSubqueries);
            }

            public int getRowNumber() {
                return noputResultSet.getRowNumber();
            }

            public ExecRow getRelativeRow(int row) throws StandardException {
                return noputResultSet.getRelativeRow(row);
            }

            public ExecRow getPreviousRow() throws StandardException {
                return noputResultSet.getPreviousRow();
            }

            public ExecRow getNextRow() throws StandardException {
                return noputResultSet.getNextRow();
            }

            public ExecRow getLastRow() throws StandardException {
                return noputResultSet.getLastRow();
            }

            public ExecRow getFirstRow() throws StandardException {
                return noputResultSet.getFirstRow();
            }

            public com.pivotal.gemfirexd.internal.catalog.UUID getExecutionPlanID() {
                return noputResultSet.getExecutionPlanID();
            }

            public long getExecuteTime() {
                return noputResultSet.getExecuteTime();
            }

            public Timestamp getEndExecutionTimestamp() {
                return noputResultSet.getEndExecutionTimestamp();
            }

            public String getCursorName() {
                return noputResultSet.getCursorName();
            }

            public Timestamp getBeginExecutionTimestamp() {
                return noputResultSet.getBeginExecutionTimestamp();
            }

            public ResultSet getAutoGeneratedKeysResultset() {
                return noputResultSet.getAutoGeneratedKeysResultset();
            }

            public Activation getActivation() {
                return noputResultSet.getActivation();
            }

            public ExecRow getAbsoluteRow(int row) throws StandardException {
                return noputResultSet.getAbsoluteRow(row);
            }

            public void flushBatch() throws StandardException {
                noputResultSet.flushBatch();
            }

            public void finish() throws StandardException {
                noputResultSet.finish();
            }

            public void closeBatch() throws StandardException {
                noputResultSet.closeBatch();
            }

            public void close(boolean cleanupOnError) throws StandardException {
                noputResultSet.close(cleanupOnError);
            }

            public void clearCurrentRow() {
                noputResultSet.clearCurrentRow();
            }

            public void cleanUp(boolean cleanupOnError) throws StandardException {
                noputResultSet.cleanUp(cleanupOnError);
            }

            public boolean checkRowPosition(int isType) throws StandardException {
                return noputResultSet.checkRowPosition(isType);
            }

            public void checkCancellationFlag() throws StandardException {
                noputResultSet.checkCancellationFlag();
            }

            public boolean addLockReference(GemFireTransaction tran) {
                return noputResultSet.addLockReference(tran);
            }

            public void accept(ResultSetStatisticsVisitor visitor) {
                noputResultSet.accept(visitor);
            }

            public void upgradeReadLockToWrite(RowLocation rl, GemFireContainer container) throws StandardException {
                noputResultSet.upgradeReadLockToWrite(rl, container);
            }

            public void updateRowLocationPostRead() throws StandardException {
                noputResultSet.updateRowLocationPostRead();
            }

            public void updateRow(ExecRow row) throws StandardException {
                noputResultSet.updateRow(row);
            }

            public boolean supportsMoveToNextKey() {
                return noputResultSet.supportsMoveToNextKey();
            }

            public void setTargetResultSet(TargetResultSet trs) {
                noputResultSet.setTargetResultSet(trs);
            }

            public void setNeedsRowLocation(boolean needsRowLocation) {
                noputResultSet.setNeedsRowLocation(needsRowLocation);
            }

            public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> keys) throws StandardException {
                noputResultSet.setGfKeysForNCJoin(keys);
            }

            public void setCurrentRow(ExecRow row) {
                noputResultSet.setCurrentRow(row);
            }

            public int resultSetNumber() {
                return noputResultSet.resultSetNumber();
            }

            public boolean requiresRelocking() {
                return noputResultSet.requiresRelocking();
            }

            public void reopenCore() throws StandardException {
                noputResultSet.reopenCore();
            }

            public void releasePreviousByteSource() {
                noputResultSet.releasePreviousByteSource();
            }

            public void setMaxSortingLimit(long limit) {
                noputResultSet.setMaxSortingLimit(limit);
            }

            public void positionScanAtRowLocation(RowLocation rLoc) throws StandardException {
                noputResultSet.positionScanAtRowLocation(rLoc);
            }

            public void openCore() throws StandardException {
                noputResultSet.openCore();
            }

            public void markRowAsDeleted() throws StandardException {
                noputResultSet.markRowAsDeleted();
            }

            public void markAsTopResultSet() {
                noputResultSet.markAsTopResultSet();
            }

            public boolean isForUpdate() {
                return noputResultSet.isForUpdate();
            }

            public TXState initLocalTXState() {
                return noputResultSet.initLocalTXState();
            }

            public int getScanKeyGroupID() {
                return noputResultSet.getScanKeyGroupID();
            }

            public int getScanIsolationLevel() {
                return noputResultSet.getScanIsolationLevel();
            }

            public int getPointOfAttachment() {
                return noputResultSet.getPointOfAttachment();
            }

            public ExecRow getNextRowCore() throws StandardException {
                ExecRow row = noputResultSet.getNextRowCore();
                if (row != null) {
                    RowLocation baseRowLocation;
                    RowLocation rowLocation = baseRowLocation = isUpdate ? (RowLocation)row.getColumn(resultWidth).getObject() : (RowLocation)row.getLastColumn().getObject();
                    if (deferred) {
                        this.rowsScanned.add(baseRowLocation);
                    } else {
                        OffHeapByteSource obs = (OffHeapByteSource)((AbstractRegionEntry)baseRowLocation).getValueInVM(null);
                        byte[] bytes = obs.getRowBytes();
                        obs.release();
                        rowLocToBytes.put(baseRowLocation, bytes);
                        long address = ((OffHeapRegionEntry)baseRowLocation).getAddress();
                        SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                        rowLocToAddressMap.put(baseRowLocation, address);
                    }
                } else if (deferred) {
                    for (RowLocation baseRowLocation : this.rowsScanned) {
                        OffHeapByteSource obs = (OffHeapByteSource)((AbstractRegionEntry)baseRowLocation).getValueInVM(null);
                        byte[] bytes = obs.getRowBytes();
                        obs.release();
                        rowLocToBytes.put(baseRowLocation, bytes);
                        long address = ((OffHeapRegionEntry)baseRowLocation).getAddress();
                        SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                        rowLocToAddressMap.put(baseRowLocation, address);
                    }
                }
                return row;
            }

            public PlanUtils.Context getNewPlanContext() {
                return noputResultSet.getNewPlanContext();
            }

            public double getEstimatedRowCount() {
                return noputResultSet.getEstimatedRowCount();
            }

            public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
                noputResultSet.filteredRowLocationPostRead(localTXState);
            }

            public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
                return noputResultSet.fetch(loc, destRow, validColumns, faultIn, container);
            }

            public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
                return noputResultSet.buildQueryPlan(builder, context);
            }

            public void forceReOpenCore() throws StandardException {
                noputResultSet.forceReOpenCore();
            }
        };
        sourceField.set(resultset, testResultSetPassThru);
        return rowLocToBytes;
    }

    public void testOffHeapMemoryReleaseOnForeignkeyConstraintViolation_1() throws Exception {
        Statement s;
        Connection conn;
        block3: {
            if (isTransactional) {
                return;
            }
            conn = OffHeapTest.getConnection();
            s = conn.createStatement();
            int rowCount = 0;
            s.executeUpdate("create table t2(id int not null, primary key(id))OFFHEAP");
            s.executeUpdate("create table t1(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t2(id))replicate offheap");
            try {
                rowCount += s.executeUpdate("insert into t1 values(1, 1)");
                OffHeapTest.fail("should have thrown an SQLException");
            }
            catch (SQLException sqle) {
                if ("23503".equals(sqle.getSQLState())) break block3;
                throw sqle;
            }
        }
        rowCount += s.executeUpdate("insert into t2 values(2)");
        rowCount += s.executeUpdate("insert into t2 values(1)");
        rowCount += s.executeUpdate("insert into t1 values(2, 2)");
        rowCount += s.executeUpdate("update t1 set fkId =2 ");
        s.executeUpdate("delete from t1 where id = 2");
        conn.commit();
        s.close();
    }

    public void testOffHeapMemoryReleaseOnForeignkeyConstraintViolation_2() throws Exception {
        Statement s;
        Connection conn;
        block3: {
            if (isTransactional) {
                return;
            }
            conn = OffHeapTest.getConnection();
            s = conn.createStatement();
            int rowCount = 0;
            s.executeUpdate("create table t2(id int not null, primary key(id))OFFHEAP");
            s.executeUpdate("create table t1(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t2(id))replicate offheap");
            try {
                rowCount += s.executeUpdate("insert into t1 values(1, 1)");
                OffHeapTest.fail("should have thrown an SQLException");
            }
            catch (SQLException sqle) {
                if ("23503".equals(sqle.getSQLState())) break block3;
                throw sqle;
            }
        }
        rowCount += s.executeUpdate("insert into t2 values(2)");
        rowCount += s.executeUpdate("insert into t2 values(1)");
        rowCount += s.executeUpdate("insert into t1 values(2, 2)");
        rowCount += s.executeUpdate("update t1 set fkId =1 ");
        s.executeUpdate("delete from t1 where id = 2");
        conn.commit();
        s.close();
    }

    public void testBasicDDLForTableCreateLoader() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create schema EMP");
        stmt.execute("create table EMP.PARTITIONTESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID)) offheap");
        GfxdCallbacksTest.addLoader("EMP", "PARTITIONTESTTABLE", "com.pivotal.gemfirexd.ddl.GfxdTestRowLoader", null);
        try {
            java.sql.ResultSet rs = stmt.executeQuery("select ID from EMP.PARTITIONTESTTABLE where ID = 1");
            rs.next();
            OffHeapTest.assertEquals((int)1, (int)rs.getInt(1));
            rs.close();
            rs = stmt.executeQuery("select ID from EMP.PARTITIONTESTTABLE where ID = 2");
            rs.next();
            OffHeapTest.assertEquals((int)2, (int)rs.getInt(1));
            rs.close();
            rs = stmt.executeQuery("select ID from EMP.PARTITIONTESTTABLE where ID = 3");
            rs.next();
            OffHeapTest.assertEquals((int)3, (int)rs.getInt(1));
            rs.close();
            GemFireCacheImpl cache = Misc.getGemFireCache();
            Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
            RegionAttributes rattr = regtwo.getAttributes();
            CacheLoader ldr = rattr.getCacheLoader();
            GfxdCacheLoader gfxdldr = (GfxdCacheLoader)ldr;
            OffHeapTest.assertNotNull((Object)gfxdldr);
            OffHeapTest.assertEquals((String)"Number of entries expected to be 3", (int)regtwo.size(), (int)3);
            for (Object keyObj : regtwo.keySet()) {
                RegionKey key = (RegionKey)keyObj;
                OffHeapTest.assertNotNull((Object)key);
                Object val = regtwo.get((Object)key);
                OffHeapTest.assertNotNull((Object)val);
                GemFireContainer gfContainer = (GemFireContainer)regtwo.getUserAttribute();
                if (gfContainer.isByteArrayStore()) {
                    OffHeapTest.assertTrue((boolean)(val instanceof OffHeapByteSource));
                    ((OffHeapByteSource)val).release();
                } else {
                    OffHeapTest.assertTrue((boolean)(val instanceof DataValueDescriptor[]));
                }
                OffHeapTest.assertNotNull((Object)val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemoryReleaseForOrderByAndGroupBy_1() throws Exception {
        if (isTransactional) {
            return;
        }
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            s.execute("create index i1 on trade.securities(symbol)");
            s.execute("create index i2 on trade.securities(exchange)");
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            for (int i = -50; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i * -1);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, exchange[-1 * i % 7]);
                psInsert4.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            final IndexToBaseRowNode[] indexNode = new IndexToBaseRowNode[1];
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void afterOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
                    try {
                        qt.accept((Visitor)new VisitorAdaptor(){

                            public Visitable visit(Visitable node) throws StandardException {
                                if (node instanceof IndexToBaseRowNode) {
                                    indexNode[0] = (IndexToBaseRowNode)node;
                                }
                                return node;
                            }

                            public boolean stopTraversal() {
                                return indexNode[0] != null;
                            }
                        });
                        TestCase.assertNotNull((Object)indexNode[0]);
                        TestCase.assertEquals((String)"I2", (String)indexNode[0].getSource().getTrulyTheBestAccessPath().getConglomerateDescriptor().getConglomerateName());
                    }
                    catch (StandardException se) {
                        throw new GemFireXDRuntimeException((Throwable)se);
                    }
                }
            });
            String query = "select * from trade.securities  order by exchange asc";
            java.sql.ResultSet rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getInt(1);
            }
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testBug49108() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        Object rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol),constraint exchange_unq unique ( exchange)) offheap");
        st.execute("create index company_tid on trade.companies(tid)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid) values (?,?,?,?,?,?,?,?,?,?,?,?)");
        OffHeapMemoryStats stats = SimpleMemoryAllocatorImpl.getAllocator().getStats();
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        long freeSizeBeforeInserts = stats.getFreeMemory();
        long refCountBeforeInsert = JDBC.getTotalRefCount(ma);
        DataGenerator dg = new DataGenerator();
        dg.insertIntoCompanies(psComp, "SYMB1", "NSE", 0);
        dg.insertIntoCompanies(psComp, "SYMB2", "BSE", 0);
        long refCountAfterInsert = JDBC.getTotalRefCount(ma);
        OffHeapTest.assertTrue((refCountBeforeInsert != refCountAfterInsert ? 1 : 0) != 0);
        long freesizeAfterInserts = stats.getFreeMemory();
        OffHeapTest.assertTrue((freesizeAfterInserts != freeSizeBeforeInserts ? 1 : 0) != 0);
        try {
            st.executeUpdate("update trade.companies set exchange = 'NSE' where symbol = 'SYMB2'");
            OffHeapTest.fail("unique constraint violation expected");
        }
        catch (SQLException sqle) {
            OffHeapTest.assertEquals((String)"23505", (String)sqle.getSQLState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentDeletes() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            s.execute("create index i1 on trade.securities(symbol)");
            s.execute("create index i2 on trade.securities(exchange)");
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            for (int i = -2000; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i * -1);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, exchange[-1 * i % 7]);
                psInsert4.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement st = conn1.createStatement();
                        st.executeUpdate("delete from trade.securities where sec_id < 0");
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            };
            Thread th1 = new Thread(runnable);
            Thread th2 = new Thread(runnable);
            Thread th3 = new Thread(runnable);
            th1.start();
            th2.start();
            th3.start();
            th1.join();
            th2.join();
            th3.join();
            psInsert4.setInt(1, -2001);
            psInsert4.setString(2, "symbol2001");
            psInsert4.setFloat(3, 68.94f);
            psInsert4.setString(4, exchange[6]);
            psInsert4.setInt(5, 2);
            OffHeapTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentDeletesAndUpdates() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(500) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            s.execute("create index i1 on trade.securities(symbol)");
            s.execute("create index i2 on trade.securities(exchange)");
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            for (int i = -2000; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i * -1);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, exchange[-1 * i % 7]);
                psInsert4.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            Runnable deletes = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement st = conn1.createStatement();
                        st.executeUpdate("delete from trade.securities where sec_id < 0");
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            };
            Runnable updates = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement st = conn1.createStatement();
                        st.executeUpdate("update  trade.securities set symbol = 'abc" + Thread.currentThread().getId() + "' where sec_id < 0");
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            };
            Thread th1 = new Thread(deletes);
            Thread th2 = new Thread(deletes);
            Thread th3 = new Thread(deletes);
            Thread th4 = new Thread(updates);
            Thread th5 = new Thread(updates);
            th1.start();
            th2.start();
            th3.start();
            th4.start();
            th5.start();
            th1.join();
            th2.join();
            th3.join();
            th4.join();
            th5.join();
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentDeletesAndUpdates_1() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(500) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            s.execute("create index i1 on trade.securities(symbol)");
            s.execute("create index i2 on trade.securities(exchange)");
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            for (int i = -500; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i * -1);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, exchange[-1 * i % 7]);
                psInsert4.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            Runnable deletes = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement st = conn1.createStatement();
                        for (int i = 0; i > -5000; i -= 200) {
                            st.executeUpdate("delete from trade.securities where sec_id > " + i);
                        }
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            };
            Runnable updates = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement st = conn1.createStatement();
                        for (int i = 1; i < 20; ++i) {
                            st.executeUpdate("update  trade.securities set symbol = 'abc" + Thread.currentThread().getId() + "_" + i + "' where sec_id < 0");
                        }
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            };
            Thread th1 = new Thread(deletes);
            Thread th2 = new Thread(deletes);
            Thread th3 = new Thread(deletes);
            Thread th4 = new Thread(updates);
            Thread th5 = new Thread(updates);
            th1.start();
            th2.start();
            th3.start();
            th4.start();
            th5.start();
            th1.join();
            th2.join();
            th3.join();
            th4.join();
            th5.join();
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testConcurrentDeletesAndUpdatesWithDiskException() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        final ThreadLocal<Boolean> raiseException = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        CacheObserverHolder.setInstance((CacheObserver)new CacheObserverAdapter(){

            public void afterSettingOplogOffSet(long offset) {
                if (((Boolean)raiseException.get()).booleanValue()) {
                    throw new DiskAccessException("Test", "Test");
                }
            }
        });
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(500) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap persistent";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            s.execute("create index i1 on trade.securities(symbol)");
            s.execute("create index i2 on trade.securities(exchange)");
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            for (int i = -500; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i * -1);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, exchange[-1 * i % 7]);
                psInsert4.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
            Runnable deletes = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement st = conn1.createStatement();
                        for (int i = 0; i > -5000; i -= 200) {
                            if (i % 400 == 0) {
                                raiseException.set(Boolean.TRUE);
                            }
                            try {
                                st.executeUpdate("delete from trade.securities where sec_id > " + i);
                                continue;
                            }
                            catch (DiskAccessException dae) {
                                raiseException.set(Boolean.FALSE);
                                continue;
                            }
                            catch (SQLException sqle) {
                                if (sqle.getCause().toString().indexOf("DiskAccessException ") != -1) {
                                    raiseException.set(Boolean.FALSE);
                                    continue;
                                }
                                sqle.printStackTrace();
                                throw sqle;
                            }
                        }
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            };
            Runnable updates = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement st = conn1.createStatement();
                        for (int i = 1; i < 20; ++i) {
                            if (i % 5 == 0) {
                                raiseException.set(Boolean.TRUE);
                            }
                            try {
                                st.executeUpdate("update  trade.securities set symbol = 'abc" + Thread.currentThread().getId() + "_" + i + "' where sec_id < 0");
                                continue;
                            }
                            catch (DiskAccessException dae) {
                                raiseException.set(Boolean.FALSE);
                                continue;
                            }
                            catch (SQLException sqle) {
                                if (sqle.getCause().toString().indexOf("DiskAccessException ") != -1) {
                                    raiseException.set(Boolean.FALSE);
                                    continue;
                                }
                                sqle.printStackTrace();
                                throw sqle;
                            }
                        }
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            };
            Thread th1 = new Thread(deletes);
            Thread th2 = new Thread(deletes);
            Thread th3 = new Thread(deletes);
            Thread th4 = new Thread(updates);
            Thread th5 = new Thread(updates);
            th1.start();
            th2.start();
            th3.start();
            th4.start();
            th5.start();
            th1.join();
            th2.join();
            th3.join();
            th4.join();
            th5.join();
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            System.setProperty("gemfire.partitionedRegionRetryTimeout", "");
            LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
            CacheObserverHolder.setInstance(null);
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug49193_1() throws Exception {
        OffHeapTest.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("create table customers (cid int not null, cust_name varchar(100), col1 int , col2 int not null unique ,tid int, primary key (cid))  offheap partition by range(tid)   ( values between 0  and 10    ,values between 10  and 100)");
            stmt.execute("create index i1 on customers(col1)");
            PreparedStatement psInsert = conn.prepareStatement("insert into customers values (?,?,?,?,?)");
            for (int i = 1; i < 20; ++i) {
                psInsert.setInt(1, i);
                psInsert.setString(2, "name" + i);
                psInsert.setInt(3, i % 4);
                psInsert.setInt(4, i);
                psInsert.setInt(5, 1);
                psInsert.executeUpdate();
            }
            conn = TestUtil.getConnection();
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void beforeGlobalIndexDelete() {
                    throw new PartitionOfflineException(null, "test ignore");
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimizerEvalutatedCost) {
                    return Double.MIN_VALUE;
                }
            });
            OffHeapTest.addExpectedException(PartitionOfflineException.class);
            try {
                stmt.executeUpdate("delete from customers where cid > 0");
                OffHeapTest.fail("Test should fail due to problem in global index maintenance");
            }
            catch (Exception ignore) {
                OffHeapTest.removeExpectedException(PartitionOfflineException.class);
            }
            GemFireXDQueryObserverHolder.clearInstance();
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimizerEvalutatedCost) {
                    return Double.MIN_VALUE;
                }
            });
            stmt.executeUpdate("delete from customers where cid > 0");
            for (int i = 21; i < 40; ++i) {
                psInsert.setInt(1, i);
                psInsert.setString(2, "name" + i);
                psInsert.setInt(3, i % 4);
                psInsert.setInt(4, i);
                psInsert.setInt(5, 1);
                psInsert.executeUpdate();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug49193_2() throws Exception {
        OffHeapTest.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("create table customers (cid int not null, cust_name varchar(100), col1 int , col2 int not null unique ,tid int, primary key (cid)) offheap  partition by range(tid)   ( values between 0  and 10    ,values between 10  and 100)");
            stmt.execute("create index i1 on customers(col1)");
            PreparedStatement psInsert = conn.prepareStatement("insert into customers values (?,?,?,?,?)");
            for (int i = 1; i < 2; ++i) {
                psInsert.setInt(1, i);
                psInsert.setString(2, "name" + i);
                psInsert.setInt(3, i % 4);
                psInsert.setInt(4, i);
                psInsert.setInt(5, 1);
                psInsert.executeUpdate();
            }
            conn = TestUtil.getConnection();
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void beforeGlobalIndexDelete() {
                    throw new PartitionOfflineException(null, "test ignore");
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimizerEvalutatedCost) {
                    return Double.MIN_VALUE;
                }
            });
            OffHeapTest.addExpectedException(PartitionOfflineException.class);
            try {
                stmt.executeUpdate("delete from customers where cid > 0");
                OffHeapTest.fail("Test should fail due to problem in global index maintenance");
            }
            catch (Exception ignore) {
                OffHeapTest.removeExpectedException(PartitionOfflineException.class);
            }
            GemFireXDQueryObserverHolder.clearInstance();
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimizerEvalutatedCost) {
                    return Double.MIN_VALUE;
                }
            });
            stmt.executeUpdate("delete from customers where cid > 0");
            for (int i = 21; i < 40; ++i) {
                psInsert.setInt(1, i);
                psInsert.setString(2, "name" + i);
                psInsert.setInt(3, i % 4);
                psInsert.setInt(4, i);
                psInsert.setInt(5, 1);
                psInsert.executeUpdate();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexUpdateWithRowInsertedUsingLoader() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Object psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(500) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            s.execute("create index i1 on trade.securities(symbol)");
            s.execute("create index i2 on trade.securities(exchange)");
            s.execute("create index i3 on trade.securities(price)");
            GfxdCallbacksTest.addLoader("trade", "securities", "com.pivotal.gemfirexd.jdbc.offheap.OffHeapTest$SecuritiesLoader", null);
            int K = 1000;
            Runnable inserts = new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = 1; i < 500; i += 4) {
                            Connection conn1 = TestUtil.getConnection();
                            PreparedStatement pstmt = conn1.prepareStatement("select * from trade.securities where sec_id in (?, ?, ?, ?,?)");
                            pstmt.setInt(1, -1);
                            pstmt.setInt(2, -(i + 1));
                            pstmt.setInt(3, -(i + 2));
                            pstmt.setInt(4, -(i + 3));
                            pstmt.setInt(5, -(i + 4));
                            TestUtil.addExpectedException(ConflictException.class);
                            try {
                                java.sql.ResultSet rs = pstmt.executeQuery();
                                int cnt = 0;
                                while (rs.next()) {
                                    rs.getInt(1);
                                    ++cnt;
                                }
                                TestUtil.removeExpectedException(ConflictException.class);
                                TestCase.assertEquals((int)5, (int)cnt);
                                continue;
                            }
                            catch (SQLException sqle) {
                                TestUtil.removeExpectedException(ConflictException.class);
                                if (sqle.getSQLState().indexOf("X0Z02") != -1) continue;
                                throw sqle;
                            }
                        }
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            };
            Runnable deletes = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement st = conn1.createStatement();
                        for (int i = 0; i > -1000; i -= 10) {
                            st.executeUpdate("delete from trade.securities where sec_id > " + i);
                        }
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            };
            Thread th1 = new Thread(deletes);
            Thread th2 = new Thread(deletes);
            Thread th4 = new Thread(inserts);
            Thread th5 = new Thread(inserts);
            th1.start();
            th2.start();
            th4.start();
            th5.start();
            th1.join();
            th2.join();
            th4.join();
            th5.join();
            s.executeUpdate("delete from trade.securities");
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexUpdateWithRowInsertedUsingLoader_2() throws Exception {
        if (isTransactional) {
            return;
        }
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Object psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(500) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap";
            final String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            s.execute("create index i1 on trade.securities(symbol)");
            s.execute("create index i2 on trade.securities(exchange)");
            s.execute("create index i3 on trade.securities(price)");
            GfxdCallbacksTest.addLoader("trade", "securities", "com.pivotal.gemfirexd.jdbc.offheap.OffHeapTest$SecuritiesLoader", null);
            int K = -500;
            final boolean[] fail = new boolean[]{false};
            Runnable selects = new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = -1; i > -500; i -= 4) {
                            Connection conn1 = TestUtil.getConnection();
                            PreparedStatement pstmt = conn1.prepareStatement("select * from trade.securities where sec_id in (?, ?, ?, ?,?)");
                            pstmt.setInt(1, i);
                            pstmt.setInt(2, i - 1);
                            pstmt.setInt(3, i - 2);
                            pstmt.setInt(4, i - 3);
                            pstmt.setInt(5, i - 4);
                            TestUtil.addExpectedException(ConflictException.class);
                            try {
                                java.sql.ResultSet rs = pstmt.executeQuery();
                                int cnt = 0;
                                while (rs.next()) {
                                    rs.getInt(1);
                                    ++cnt;
                                }
                                rs.close();
                                TestUtil.removeExpectedException(ConflictException.class);
                                TestCase.assertEquals((int)5, (int)cnt);
                                continue;
                            }
                            catch (SQLException sqle) {
                                TestUtil.removeExpectedException(ConflictException.class);
                                if (sqle.getSQLState().indexOf("X0Z02") != -1) continue;
                                throw sqle;
                            }
                        }
                    }
                    catch (SQLException sqle) {
                        fail[0] = true;
                        sqle.printStackTrace();
                    }
                }
            };
            Runnable inserts = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        Statement st = conn1.createStatement();
                        PreparedStatement psInsert = conn1.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
                        for (int i = -1; i > -500; --i) {
                            psInsert.setInt(1, i);
                            psInsert.setString(2, "symbol" + -(i * 1));
                            psInsert.setFloat(3, 68.94f);
                            psInsert.setString(4, exchange[-i % 7]);
                            psInsert.setInt(5, 2);
                            try {
                                TestCase.assertEquals((int)1, (int)psInsert.executeUpdate());
                                continue;
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            };
            Thread th4 = new Thread(selects);
            Thread th5 = new Thread(inserts);
            th5.start();
            th4.start();
            th4.join();
            th5.join();
            s.executeUpdate("delete from trade.securities");
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
            OffHeapTest.assertFalse((boolean)fail[0]);
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexUpdateWithMultiPutUpdate() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Object psInsert1 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(500) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id)) offheap";
            s.execute(tab1);
            s.execute("create index i3 on trade.securities(price)");
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection conn1 = TestUtil.getConnection();
                        PreparedStatement psInsert1 = conn1.prepareStatement("insert into trade.securities values (?,?,?,?,?)");
                        for (int i = 1; i < 2; ++i) {
                            psInsert1.setInt(1, i);
                            psInsert1.setString(2, "symb" + i);
                            psInsert1.setFloat(3, 7.1f * (float)i);
                            psInsert1.setString(4, "exch" + i);
                            psInsert1.setInt(5, 2);
                            psInsert1.executeUpdate();
                        }
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            });
            Statement st = conn.createStatement();
            st.executeUpdate("insert into trade.securities values (114,'symb114-',114.43,'exch114-',2) ");
            th.start();
            th.join();
            try {
                st.executeUpdate("insert into trade.securities values  (6,'symb6-',6.43,'exch6-',2), (1,'symb1-',8.43,'exch1-',2) , (7,'symb7-',7.43,'exch7-',2) ");
                OffHeapTest.fail("insert should have failed");
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            s.executeUpdate("update  trade.securities set price = 10.73 where sec_id = 1");
            s.executeUpdate("delete from trade.securities");
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexUpdateWithRowInsertedUsingLoader_1() throws Exception {
        if (isTransactional) {
            return;
        }
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Object psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(500) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            GfxdCallbacksTest.addLoader("trade", "securities", "com.pivotal.gemfirexd.jdbc.offheap.OffHeapTest$SecuritiesLoader", null);
            Connection conn1 = TestUtil.getConnection();
            PreparedStatement pstmt = conn1.prepareStatement("select * from trade.securities where sec_id in (?)");
            pstmt.setInt(1, -1);
            java.sql.ResultSet rs = pstmt.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                rs.getInt(1);
                ++cnt;
            }
            OffHeapTest.assertEquals((int)1, (int)cnt);
            rs.close();
            rs = pstmt.executeQuery();
            cnt = 0;
            while (rs.next()) {
                rs.getInt(1);
                ++cnt;
            }
            rs.close();
            OffHeapTest.assertEquals((int)1, (int)cnt);
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemoryReleaseOnRegionIteration() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(500) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            s.execute("create index i1 on trade.securities(symbol)");
            s.execute("create index i2 on trade.securities(exchange)");
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            for (int i = -2000; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i * -1);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, exchange[-1 * i % 7]);
                psInsert4.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            Region rgn = Misc.getRegion((String)"/TRADE/SECURITIES", (boolean)true, (boolean)false);
            Set keys = rgn.keySet();
            for (Object e : keys) {
            }
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemoryRelease_1() throws Exception {
        if (isTransactional) {
            return;
        }
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            int i;
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap";
            String tab2 = " create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid)) offheap";
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid), constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id) on delete restrict, constraint bo_qty_ck check (qty>=0))  offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            s.execute(tab2);
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            for (i = -2000; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i * -1);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, exchange[-1 * i % 7]);
                psInsert4.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            PreparedStatement psInsert1 = conn.prepareStatement("insert into trade.customers values (?, ?,?,?,?)");
            for (i = 1; i < 2000; ++i) {
                psInsert1.setInt(1, i);
                psInsert1.setString(2, "name" + i);
                psInsert1.setDate(3, new Date(2004, 12, 1));
                psInsert1.setString(4, "address" + i);
                psInsert1.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert1.executeUpdate());
            }
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (i = 1; i < 1800; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, -1 * i);
                psInsert2.setInt(4, 100 * i);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert2.setString(7, "open");
                psInsert2.setInt(8, 5);
                OffHeapTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            this.doOffHeapValidations();
            String updt = "update trade.customers set cust_name = 'yyy' , addr ='xxx' where cid=40 and tid =5";
            s.executeUpdate(updt);
            this.doOffHeapValidations();
            String query = "select cid, cast (avg(qty*bid) as decimal (30, 20)) as amount from trade.buyorders  where status ='open' and tid =5 GROUP BY cid ORDER BY amount";
            java.sql.ResultSet rs = s.executeQuery(query);
            int cnt = 0;
            while (rs.next()) {
                rs.getBigDecimal(2);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            cnt = 0;
            query = "select * from trade.securities where symbol is not null and tid = 2";
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getString(1);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            cnt = 0;
            query = "select sid, count(*) from trade.buyorders  where status ='open' and tid =5 GROUP BY sid HAVING count(*) >=0";
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getInt(2);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            query = "select * from trade.buyorders where status = 'open' and tid = 5";
            cnt = 0;
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getInt(2);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            query = "select cid, min(qty*bid) as smallest_order from trade.buyorders  where status ='open' and tid =5 GROUP BY cid";
            cnt = 0;
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getInt(2);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            query = "select distinct sid from trade.buyorders where qty >=0  and tid =5";
            cnt = 0;
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getInt(1);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            PreparedStatement ps = conn.prepareStatement("select * from trade.buyorders where status = 'open' and tid = ?");
            ps.setInt(1, 5);
            rs = ps.executeQuery();
            rs.close();
            ps.setInt(1, 5);
            rs = ps.executeQuery();
            ps.close();
            ps = conn.prepareStatement("select * from trade.buyorders where status = 'open' and tid = ?");
            ps.setInt(1, 5);
            rs = ps.executeQuery();
            rs = ps.executeQuery();
            rs.close();
            this.doOffHeapValidations();
            ps.setInt(1, 5);
            rs = ps.executeQuery();
            for (int i2 = 0; rs.next() && i2 < 18; ++i2) {
                rs.getInt(1);
            }
            rs.close();
            s.executeUpdate("delete from trade.buyorders");
            s.executeUpdate("delete from trade.customers");
            s.executeUpdate("delete from trade.securities");
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
                s.execute("drop table if exists trade.customers");
                this.rmcd.waitTillAllClear();
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemoryRelease_2() throws Exception {
        if (isTransactional) {
            return;
        }
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            int i;
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap";
            String tab2 = " create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid)) offheap";
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid), constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id) on delete restrict, constraint bo_qty_ck check (qty>=0))  offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            s.execute(tab2);
            s.execute(tab3);
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            for (i = -2000; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i * -1);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, exchange[-1 * i % 7]);
                psInsert4.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            PreparedStatement psInsert1 = conn.prepareStatement("insert into trade.customers values (?, ?,?,?,?)");
            for (i = 1; i < 2000; ++i) {
                psInsert1.setInt(1, i);
                psInsert1.setString(2, "name" + i);
                psInsert1.setDate(3, new Date(2004, 12, 1));
                psInsert1.setString(4, "address" + i);
                psInsert1.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert1.executeUpdate());
            }
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (i = 1; i < 1800; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, -1 * i);
                psInsert2.setInt(4, 100 * i);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert2.setString(7, "open");
                psInsert2.setInt(8, 5);
                OffHeapTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            this.doOffHeapValidations();
            String updt = "update trade.customers set cust_name = 'yyy' , addr ='xxx' where cid=40 and tid =5";
            s.executeUpdate(updt);
            this.doOffHeapValidations();
            String query = "select cid, cast (avg(qty*bid) as decimal (30, 20)) as amount from trade.buyorders  where status ='open' and tid =5 GROUP BY cid ORDER BY amount";
            java.sql.ResultSet rs = s.executeQuery(query);
            int cnt = 0;
            while (rs.next()) {
                rs.getBigDecimal(2);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            cnt = 0;
            query = "select * from trade.securities where symbol is not null and tid = 2";
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getString(1);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            cnt = 0;
            query = "select sid, count(*) from trade.buyorders  where status ='open' and tid =5 GROUP BY sid HAVING count(*) >=0";
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getInt(2);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            query = "select * from trade.buyorders where status = 'open' and tid = 5";
            cnt = 0;
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getInt(2);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            query = "select cid, min(qty*bid) as smallest_order from trade.buyorders  where status ='open' and tid =5 GROUP BY cid";
            cnt = 0;
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getInt(2);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            query = "select distinct sid from trade.buyorders where qty >=0  and tid =5";
            cnt = 0;
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getInt(1);
                ++cnt;
            }
            OffHeapTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
            PreparedStatement ps = conn.prepareStatement("select * from trade.buyorders where status = 'open' and tid = ?");
            ps.setInt(1, 5);
            rs = ps.executeQuery();
            rs.close();
            ps.setInt(1, 5);
            rs = ps.executeQuery();
            ps.close();
            ps = conn.prepareStatement("select * from trade.buyorders where status = 'open' and tid = ?");
            ps.setInt(1, 5);
            rs = ps.executeQuery();
            rs = ps.executeQuery();
            rs.close();
            this.doOffHeapValidations();
            ps.setInt(1, 0);
            rs = ps.executeQuery();
            for (int i2 = 0; rs.next() && i2 < 18; ++i2) {
                rs.getInt(1);
            }
            rs.close();
            s.executeUpdate("delete from trade.buyorders");
            s.executeUpdate("delete from trade.customers");
            s.executeUpdate("delete from trade.securities");
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
                s.execute("drop table if exists trade.customers");
                this.rmcd.waitTillAllClear();
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testAlterTableBug48333_1_ADD_COl() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA,  tid int, constraint comp_pk primary key (symbol, exchange)) offheap");
        st.execute("create index company_tid on trade.companies(tid)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid,  tid) values (?,?,?,?,?)");
        for (int i = 1; i < 2; ++i) {
            UUID uid = UUID.fromString("3f90bd11-dfc3-4fd0-b758-08ed895b5c02");
            short companyType = 8;
            psComp.setString(1, "symb" + i);
            psComp.setString(2, "exchng" + i);
            psComp.setShort(3, companyType);
            psComp.setBytes(4, DataGenerator.getUidBytes(uid));
            psComp.setInt(5, 10);
            psComp.executeUpdate();
        }
        st.execute("alter table trade.companies add column companyinfo clob");
        int n = st.executeUpdate("update trade.companies set tid = 5 ");
        OffHeapTest.assertEquals((int)1, (int)n);
        rs = st.executeQuery("select * from trade.companies ");
        int numRows = 0;
        int numCols = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            for (int i = 0; i < numCols; ++i) {
                String columnName = rs.getMetaData().getColumnName(i + 1);
                Object obj = rs.getObject(i + 1);
                if (columnName.equals("symbol")) {
                    OffHeapTest.assertEquals((Object)"symb1", (Object)obj);
                    continue;
                }
                if (columnName.equals("symbol")) {
                    OffHeapTest.assertEquals((Object)"exchng1", (Object)obj);
                    continue;
                }
                if (columnName.equals("companytype")) {
                    OffHeapTest.assertEquals((int)8, (int)((Number)obj).intValue());
                    continue;
                }
                if (!columnName.equals("tid")) continue;
                OffHeapTest.assertEquals((int)5, (int)((Number)obj).intValue());
            }
            ++numRows;
        }
        OffHeapTest.assertEquals((int)1, (int)numRows);
        PreparedStatement updtClob = conn.prepareStatement("update trade.companies set companyinfo = ?");
        DataGenerator dg = new DataGenerator();
        Clob clob = dg.getClob(1)[0];
        updtClob.setClob(1, clob);
        updtClob.executeUpdate();
        rs = st.executeQuery("select companyinfo from trade.companies");
        OffHeapTest.assertTrue((boolean)rs.next());
        OffHeapTest.assertEquals((String)DataGenerator.convertClobToString(clob), (String)DataGenerator.convertClobToString(rs.getClob(1)));
    }

    public void testAlterTableBug48333_2_ADD_COL() throws Exception {
        if (isTransactional) {
            return;
        }
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA,  tid int, companyinfo1 clob,  constraint comp_pk primary key (symbol, exchange)) offheap");
        st.execute("create index company_tid on trade.companies(tid)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid,  tid, companyinfo1) values (?,?,?,?,?,?)");
        DataGenerator dg1 = new DataGenerator();
        Clob clob1 = dg1.getClob(1)[0];
        for (int i = 1; i < 2; ++i) {
            UUID uid = UUID.fromString("3f90bd11-dfc3-4fd0-b758-08ed895b5c02");
            short companyType = 8;
            psComp.setString(1, "symb" + i);
            psComp.setString(2, "exchng" + i);
            psComp.setShort(3, companyType);
            psComp.setBytes(4, DataGenerator.getUidBytes(uid));
            psComp.setInt(5, 10);
            psComp.setClob(6, clob1);
            psComp.executeUpdate();
        }
        st.execute("alter table trade.companies add column companyinfo2 clob");
        PreparedStatement updtClob = conn.prepareStatement("update trade.companies set companyinfo2 = ?");
        DataGenerator dg2 = new DataGenerator();
        Clob clob2 = dg2.getClob(1)[0];
        updtClob.setClob(1, clob2);
        updtClob.executeUpdate();
        rs = st.executeQuery("select companyinfo1 , companyinfo2 from trade.companies ");
        OffHeapTest.assertTrue((boolean)rs.next());
        OffHeapTest.assertEquals((String)DataGenerator.convertClobToString(clob1), (String)DataGenerator.convertClobToString(rs.getClob(1)));
        OffHeapTest.assertEquals((String)DataGenerator.convertClobToString(clob2), (String)DataGenerator.convertClobToString(rs.getClob(2)));
    }

    public void testAlterTableBug48333_3_ADD_COL() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA,  tid int, companyinfo1 clob,  constraint comp_pk primary key (symbol, exchange)) offheap");
        st.execute("create index company_tid on trade.companies(tid)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid,  tid, companyinfo1) values (?,?,?,?,?,?)");
        DataGenerator dg1 = new DataGenerator();
        Clob clob1 = dg1.getClob(1)[0];
        for (int i = 1; i < 2; ++i) {
            UUID uid = UUID.fromString("3f90bd11-dfc3-4fd0-b758-08ed895b5c02");
            short companyType = 8;
            psComp.setString(1, "symb" + i);
            psComp.setString(2, "exchng" + i);
            psComp.setShort(3, companyType);
            psComp.setBytes(4, DataGenerator.getUidBytes(uid));
            psComp.setInt(5, 10);
            psComp.setNull(6, 2005);
            psComp.executeUpdate();
        }
        st.execute("alter table trade.companies add column companyinfo2 clob");
        PreparedStatement updtClob = conn.prepareStatement("update trade.companies set companyinfo2 = ? ");
        DataGenerator dg2 = new DataGenerator();
        Clob clob2 = dg2.getClob(1)[0];
        updtClob.setClob(1, clob2);
        updtClob.executeUpdate();
        rs = st.executeQuery("select companyinfo1 , companyinfo2 from trade.companies ");
        OffHeapTest.assertTrue((boolean)rs.next());
        OffHeapTest.assertEquals(null, (Object)rs.getClob(1));
        OffHeapTest.assertEquals((String)DataGenerator.convertClobToString(clob2), (String)DataGenerator.convertClobToString(rs.getClob(2)));
    }

    public void testAlterTableBug48333_4_ADD_COL() throws Exception {
        if (isTransactional) {
            return;
        }
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA,  tid int, companyinfo1 clob,  constraint comp_pk primary key (symbol, exchange)) offheap");
        st.execute("create index company_tid on trade.companies(tid)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid,  tid, companyinfo1) values (?,?,?,?,?,?)");
        DataGenerator dg1 = new DataGenerator();
        Clob clob1 = dg1.getClob(1)[0];
        for (int i = 1; i < 2; ++i) {
            UUID uid = UUID.fromString("3f90bd11-dfc3-4fd0-b758-08ed895b5c02");
            short companyType = 8;
            psComp.setString(1, "symb" + i);
            psComp.setString(2, "exchng" + i);
            psComp.setShort(3, companyType);
            psComp.setBytes(4, DataGenerator.getUidBytes(uid));
            psComp.setInt(5, 10);
            psComp.setClob(6, clob1);
            psComp.executeUpdate();
        }
        st.execute("alter table trade.companies add column companyinfo2 clob");
        PreparedStatement updtClob = conn.prepareStatement("update trade.companies set companyinfo1 = ? ");
        DataGenerator dg2 = new DataGenerator();
        Clob clob2 = dg2.getClob(1)[0];
        updtClob.setClob(1, clob2);
        updtClob.executeUpdate();
        rs = st.executeQuery("select companyinfo1 , companyinfo2 from trade.companies ");
        OffHeapTest.assertTrue((boolean)rs.next());
        OffHeapTest.assertEquals(null, (Object)rs.getClob(2));
        OffHeapTest.assertEquals((String)DataGenerator.convertClobToString(clob2), (String)DataGenerator.convertClobToString(rs.getClob(1)));
    }

    public void testAlterTableBug48333_5_DEL_COL() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA,  tid int, companyinfo1 clob, companyinfo2 clob, companyinfo3 clob, constraint comp_pk primary key (symbol, exchange)) offheap");
        st.execute("create index company_tid on trade.companies(tid)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid,  tid, companyinfo1, companyinfo2, companyinfo3) values (?,?,?,?,?,?,?,?)");
        DataGenerator dg1 = new DataGenerator();
        Clob[] clobs = dg1.getClob(3);
        Clob clob1 = clobs[0];
        Clob clob2 = clobs[1];
        Clob clob3 = clobs[2];
        for (int i = 1; i < 2; ++i) {
            UUID uid = UUID.fromString("3f90bd11-dfc3-4fd0-b758-08ed895b5c02");
            short companyType = 8;
            psComp.setString(1, "symb" + i);
            psComp.setString(2, "exchng" + i);
            psComp.setShort(3, companyType);
            psComp.setBytes(4, DataGenerator.getUidBytes(uid));
            psComp.setInt(5, 10);
            psComp.setClob(6, clob1);
            psComp.setClob(7, clob2);
            psComp.setClob(8, clob3);
            psComp.executeUpdate();
        }
        st.execute("alter table trade.companies drop column companyinfo2 ");
        PreparedStatement updtClob = conn.prepareStatement("update trade.companies set companyinfo1 = ? ");
        DataGenerator dg2 = new DataGenerator();
        Clob clob1_ = dg2.getClob(1)[0];
        updtClob.setClob(1, clob1_);
        updtClob.executeUpdate();
        rs = st.executeQuery("select companyinfo1 , companyinfo3 from trade.companies ");
        OffHeapTest.assertTrue((boolean)rs.next());
        OffHeapTest.assertEquals((String)DataGenerator.convertClobToString(clob1_), (String)DataGenerator.convertClobToString(rs.getClob(1)));
        OffHeapTest.assertEquals((String)DataGenerator.convertClobToString(clob3), (String)DataGenerator.convertClobToString(rs.getClob(2)));
    }

    public void testAlterTableBug48333_6_ADD_COl() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA,  tid int, constraint comp_pk primary key (symbol, exchange)) offheap");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid,  tid) values (?,?,?,?,?)");
        for (int i = 1; i < 2; ++i) {
            UUID uid = UUID.fromString("3f90bd11-dfc3-4fd0-b758-08ed895b5c02");
            short companyType = 8;
            psComp.setString(1, "symb" + i);
            psComp.setString(2, "exchng" + i);
            psComp.setShort(3, companyType);
            psComp.setBytes(4, DataGenerator.getUidBytes(uid));
            psComp.setInt(5, 10);
            psComp.executeUpdate();
        }
        st.execute("alter table trade.companies add column companyinfo clob");
        int n = st.executeUpdate("update trade.companies set tid = 5 ");
        OffHeapTest.assertEquals((int)1, (int)n);
        rs = st.executeQuery("select * from trade.companies ");
        int numRows = 0;
        int numCols = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            for (int i = 0; i < numCols; ++i) {
                String columnName = rs.getMetaData().getColumnName(i + 1);
                Object obj = rs.getObject(i + 1);
                if (columnName.equals("symbol")) {
                    OffHeapTest.assertEquals((Object)"symb1", (Object)obj);
                    continue;
                }
                if (columnName.equals("symbol")) {
                    OffHeapTest.assertEquals((Object)"exchng1", (Object)obj);
                    continue;
                }
                if (columnName.equals("companytype")) {
                    OffHeapTest.assertEquals((int)8, (int)((Number)obj).intValue());
                    continue;
                }
                if (!columnName.equals("tid")) continue;
                OffHeapTest.assertEquals((int)5, (int)((Number)obj).intValue());
            }
            ++numRows;
        }
        OffHeapTest.assertEquals((int)1, (int)numRows);
        PreparedStatement updtClob = conn.prepareStatement("update trade.companies set companyinfo = ?");
        DataGenerator dg = new DataGenerator();
        Clob clob = dg.getClob(1)[0];
        updtClob.setClob(1, clob);
        updtClob.executeUpdate();
        rs = st.executeQuery("select companyinfo from trade.companies");
        OffHeapTest.assertTrue((boolean)rs.next());
        OffHeapTest.assertEquals((String)DataGenerator.convertClobToString(clob), (String)DataGenerator.convertClobToString(rs.getClob(1)));
    }

    public void testMemoryReleaseOnFilteredRow() throws Exception {
        String query = "select oid, sid, ask, cid, status from trade.sellorders  where ((status =? and ask <?) OR (status =? and ask >?))  and cid not IN (?, ?, ?, ?, ?) and tid =?";
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int,  ask decimal (30, 20), status varchar(10) default 'open', tid int, constraint status_ch check (status in ('cancelled', 'open', 'filled'))) offheap");
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.sellorders values(?,?,?,?,?,?)");
        for (int i = 0; i < 800; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i * 3);
            psInsert.setInt(3, i * 4);
            psInsert.setFloat(4, (float)i * 173.56f);
            psInsert.setString(5, i % 3 == 0 ? "open" : "cancelled");
            psInsert.setInt(6, i % 2 == 0 ? 1 : 2);
            psInsert.executeUpdate();
        }
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }
        });
        st.execute("create index i1 on trade.sellorders(cid)");
        st.execute("create index i2 on trade.sellorders(ask)");
        PreparedStatement psq = conn.prepareStatement(query);
        psq.setString(1, "open");
        psq.setFloat(2, 600.75f);
        psq.setString(3, "open");
        psq.setFloat(4, 1300.75f);
        psq.setInt(5, 9);
        psq.setInt(6, 18);
        psq.setInt(7, 72);
        psq.setInt(8, 55);
        psq.setInt(9, 24);
        psq.setInt(10, 2);
        int numRows = 0;
        rs = psq.executeQuery();
        while (rs.next()) {
            rs.getInt(1);
            ++numRows;
        }
        OffHeapTest.assertTrue((numRows > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLRURegionEntryCreateUpdateAndFaultIn() throws Exception {
        if (isTransactional) {
            return;
        }
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) offheap eviction by lrucount 1 evictaction overflow synchronous ";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1);
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            for (int i = 0; i < 6; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, exchange[i % 7]);
                psInsert4.setInt(5, 2);
                OffHeapTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            this.doOffHeapValidations();
            String updt = "update trade.securities set tid = 5 ";
            int n = s.executeUpdate(updt);
            OffHeapTest.assertEquals((int)6, (int)n);
            this.doOffHeapValidations();
            int cnt = 0;
            String query = "select * from trade.securities where symbol is not null and tid = 5 for update";
            java.sql.ResultSet rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getString(1);
                ++cnt;
            }
            OffHeapTest.assertEquals((int)6, (int)cnt);
            s.execute("create index sec_tid on trade.securities(tid)");
            cnt = 0;
            rs = s.executeQuery(query);
            while (rs.next()) {
                rs.getString(1);
                ++cnt;
            }
            OffHeapTest.assertEquals((int)6, (int)cnt);
            s.executeUpdate("delete from trade.securities");
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.securities");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug49014() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Object psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            conn.setTransactionIsolation(4);
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 3; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, -1 * i);
                psInsert2.setInt(4, 100 * i);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert2.setString(7, "cancelled");
                psInsert2.setInt(8, 5);
                OffHeapTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            conn.commit();
            Statement st = conn.createStatement();
            st.executeUpdate("update trade.buyorders set status = 'xxxx' where cid =1");
            st.executeUpdate("update trade.buyorders set status = 'cancelled' where cid = 1");
            conn.commit();
            psInsert2.setInt(1, 4);
            psInsert2.setInt(2, 4);
            psInsert2.setInt(3, -4);
            psInsert2.setInt(4, 400);
            psInsert2.setFloat(5, 30.4f);
            psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            psInsert2.setString(7, "cancelled");
            psInsert2.setInt(8, 5);
            OffHeapTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            this.doOffHeapValidations();
            conn.commit();
            s.executeUpdate("delete from trade.buyorders");
            conn.commit();
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForSingleOHAddressCache() throws Exception {
        if (isTransactional) {
            return;
        }
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Object psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 100; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, -1 * i);
                psInsert2.setInt(4, 100 * i);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert2.setString(7, "cancelled");
                psInsert2.setInt(8, 5);
                OffHeapTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            String query = "select * from trade.buyorders where status = 'cancelled' and tid > 0";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = tableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            rs.next();
            rs.close();
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleOHAddressCacheForUpdateAndSimpleDelete() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Object psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 100; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, -1 * i);
                psInsert2.setInt(4, 100 * i);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert2.setString(7, "cancelled");
                psInsert2.setInt(8, 5);
                OffHeapTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                private void reflectAndAssert(ResultSet resultSet, Class<?> resultsetClass) throws Exception {
                    Field sourceField = resultsetClass.getDeclaredField("source");
                    sourceField.setAccessible(true);
                    ProjectRestrictResultSet psRs = (ProjectRestrictResultSet)sourceField.get(resultSet);
                    TableScanResultSet ts = (TableScanResultSet)psRs.getSource();
                    Class<TableScanResultSet> tableScanClazz = TableScanResultSet.class;
                    Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                    field.setAccessible(true);
                    OHAddressCache addressCache = (OHAddressCache)field.get(ts);
                    Class<TableScanResultSet.SingleOHAddressCache> addressCacheClass = TableScanResultSet.SingleOHAddressCache.class;
                    TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
                }

                public void onUpdateResultSetOpen(ResultSet resultSet) {
                    try {
                        this.reflectAndAssert(resultSet, UpdateResultSet.class);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onDeleteResultSetOpen(ResultSet resultSet) {
                    try {
                        this.reflectAndAssert(resultSet, DeleteResultSet.class);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            String update = "update trade.buyorders set status = 'open' where oid > 50 and tid > 0";
            s.executeUpdate(update);
            String delete = "delete from trade.buyorders  where oid > 50 and tid > 0";
            s.executeUpdate(delete);
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testOffHeapReleaseForMultiColumnTableScanResultSet() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Object psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 500; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, -1 * i);
                psInsert2.setInt(4, 100 * i);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert2.setString(7, "cancelled");
                psInsert2.setInt(8, 5);
                OffHeapTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            String query = "select cid, sid from trade.buyorders where  ( qty < 100 or qty > 150)";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = tableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            while (rs.next()) {
                rs.getInt(1);
                ++num;
            }
            OffHeapTest.assertTrue((num > 0 ? 1 : 0) != 0);
            rs.close();
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void _testBug() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        String[] status = new String[]{"open", "filled", "cancelled"};
        st.execute("create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, status varchar(10), tid int, constraint status_ch check (status in ('cancelled', 'open', 'filled')))  offheap");
        st.execute("create index cid_index on trade.sellorders(cid)");
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.sellorders values (?,?,?,?,?,?)");
        for (int i = 0; i < 2; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setInt(3, i);
            psInsert.setInt(4, i * 1000);
            psInsert.setString(5, "open");
            psInsert.setInt(6, 1);
            psInsert.executeUpdate();
        }
        java.sql.ResultSet rs = null;
        int count = 0;
        rs = st.executeQuery("select * from TRADE.SELLORDERS where status = 'open' and tid =1");
        while (rs.next()) {
            rs.getInt(1);
            ++count;
        }
        OffHeapTest.assertTrue((count > 0 ? 1 : 0) != 0);
        for (int i = 10; i < 10000; ++i) {
            psInsert.setInt(1, i);
            psInsert.setInt(2, i);
            psInsert.setInt(3, i);
            psInsert.setInt(4, i * 1000);
            psInsert.setString(5, status[i % status.length]);
            psInsert.setInt(6, 1);
            psInsert.executeUpdate();
        }
        rs = st.executeQuery("select * from TRADE.SELLORDERS where status = 'open' and tid =1");
        count = 0;
        while (rs.next()) {
            rs.getInt(1);
            ++count;
        }
        OffHeapTest.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForBatchOHAddressCache() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Object psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 100; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, -1 * i);
                psInsert2.setInt(4, 100 * i);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert2.setString(7, "cancelled");
                psInsert2.setInt(8, 5);
                OffHeapTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            String query = "select * from trade.buyorders where  tid > 0";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = bulkTableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            rs.next();
            rs.close();
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForCollectionBasedOHAddressCache() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert2 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap";
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            psInsert2 = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 10; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, -1 * i);
                psInsert2.setInt(4, 100 * i);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert2.setString(7, "cancelled");
                psInsert2.setInt(8, 5);
                OffHeapTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            String query = "select * from trade.buyorders where  tid > 0 order by qty";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        if (!(addressCache instanceof CollectionBasedOHAddressCache)) {
                            TestUtil.fail("expected " + addressCache.getClass() + " to be an instanceof CollectionBasedOHAddressCache");
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            rs.next();
            rs.close();
            GemFireXDQueryObserverHolder.clearInstance();
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug50432() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        try {
            int partRead;
            byte[] blobBytes = new byte[]{-98, -126, 101, 99, -38, 4, -115};
            String tab = " create table portfoliov1 (cid int not null, sid int not null, data blob)  OFFHEAP";
            s.execute(tab);
            HarmonySerialBlob data = new HarmonySerialBlob(blobBytes);
            PreparedStatement insert = conn.prepareStatement("insert into portfoliov1 values (?, ?,?)");
            insert.setInt(1, 659);
            insert.setInt(2, 753);
            insert.setBlob(3, (Blob)data);
            insert.executeUpdate();
            java.sql.ResultSet rs = s.executeQuery("select * from portfoliov1");
            OffHeapTest.assertTrue((boolean)rs.next());
            OffHeapTest.assertEquals((int)659, (int)rs.getInt(1));
            OffHeapTest.assertEquals((int)753, (int)rs.getInt(2));
            Blob out = rs.getBlob(3);
            InputStream is = out.getBinaryStream();
            int size = is.available();
            byte[] resultBytes = new byte[size];
            for (int read = 0; read != size; read += partRead) {
                partRead = is.read(resultBytes, read, size - read);
            }
            OffHeapTest.assertTrue((boolean)Arrays.equals(blobBytes, resultBytes));
        }
        finally {
            try {
                if (s != null) {
                    s.execute("drop table if exists portfoliov1");
                    this.rmcd.waitTillAllClear();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug49427() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            s.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
            s.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
            String tab1 = " create table trade.companies (symbol varchar(10) not null, exchange varchar(10)  not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange)) replicate offheap";
            s.execute(tab1);
            psInsert4 = conn.prepareStatement("insert into trade.companies values (?, ?, ?,?,?,?,?,?,?,?,?,?)");
            DataGenerator.insertIntoCompanies("s", "tse", (short)7, new byte[]{123, 119, -95, 80, 60, -94, 78, 12, -106, 37, 126, 44, -39, -111, 67, -44}, UUID.fromString("7b77a150-3ca2-4e0c-9625-7e2cd99143d4"), "i}\\h[?bW1xzZ :jBONH\\f@'A<6XNQh9N`)EkQ)7&!gAl=U$2mx'q3.-:xJ\"!R{@Zp}uG5)J7", null, "fcae89533a563a2e648d174f6a7748fb", new UDTPrice(new BigDecimal(28.95f), new BigDecimal(38.95f)), 2533297914191977240L, new byte[]{125, -125, 71, 101, -76, -99, 33, -79, -99, 116, -82, -53, -98, 83, 88, -75, -49, 84, 98, 68, 123, -46, -42, 50, -51, -56, 6, -2, -67, 0, 124, 85, -98, -59, -93, 102, 58, -45, 75, -14, 41, -93, 99, 82, -86, 30, -118, -66, -99, 116, -1, -70, -44, 0, -79, -12, -44, 89, -122, -90, 17, 55, -36, -71, 25, 111, 13, 89, -65, -53, -25, -89, -72, -10, -57, -89, -119, -92, -15, -67, -98, 111, -52, -106, 20, 19, 123, -43, -42, -42, -27, 17, 92, -65, 22, 101, 29}, 45, psInsert4);
            try {
                DataGenerator.insertIntoCompanies("s", "tse", (short)8, new byte[]{-81, 112, -67, 52, -86, -2, 78, -73, -91, -105, 110, -75, -104, 103, -126, 46}, UUID.fromString("af70bd34-aafe-4eb7-a597-6eb59867822e"), "2H1z_hP1LZ(Hi0!tPHf\\_Twa-;cJ\\=^3fvxbPTz5UY9xO{`>nSmI'uMFw79RbO wDW;Z>_iyp", null, "3c628efc7ab37a3da2f71c515edde23", new UDTPrice(new BigDecimal(25.73), new BigDecimal(35.73)), -7292667050878051554L, new byte[]{-124, -90, 51, 9, -112, 9, -83, 31, -86, 42, 29, -59, -116, -104, -126, 7, -54, 83, -95, -90, -104, -96, 121, -116, -40, 71, -49, -49, 7, -62, -6, 34, 84, 79, -115, -33, 46, 79, 37, -68, 104, -81, 7, -108, 58, 71, 106, -86, -55, 91, -70, 47, 82, -103, -37, 78, 121, 29, 7, -102, 97, -103, -98, 106, -66, 22, 109, -112, 26, 42, 58, -76, -44, 121, 3, 12, 41, -21, 62, -11}, 14, psInsert4);
                OffHeapTest.fail("PK violation expected");
            }
            catch (SQLException sqle) {
                OffHeapTest.assertEquals((String)"23505", (String)sqle.getSQLState());
            }
            try {
                DataGenerator.insertIntoCompanies("s", "tse", (short)1, new byte[]{72, -28, 97, -127, 7, 26, 79, 11, -99, -28, 57, 80, 84, 48, 30, -40}, UUID.fromString("48e46181-071a-4f0b-9de4-395054301ed8"), "_2FOQU!_-\"tFam55(+5szXb*Ka/M7<=mLam>+S`)|ksVOTD", new SerialClob("ceaf4ca3ebb26021d1c8f65a7ee4ac".toCharArray()), "535179aa524b229485b0572f992a959a", new UDTPrice(new BigDecimal(36.31f), new BigDecimal(46.31f)), -3134025377833192825L, new byte[]{116, -91, 90, 14, 71, -122, 62, 39, -86, -20, 3, -18, -119, -113, 111, -21, 18, -36, 38, -68, -75, 11, 83, 6, 95, 11, -79, 72, 59, -29, 18, 102, 107, -28, 60, -35, -11, -32, -92, 4, -113, 96, 92, 82, -46, -97, -90, -42, 4, -34, 97, -100, -122, -117, -61, -118, 81, 28, -44, -21, -116, -17, -35, -109, 47, -104, 40, -65}, 47, psInsert4);
                OffHeapTest.fail("PK violation expected");
            }
            catch (SQLException sqle) {
                OffHeapTest.assertEquals((String)"23505", (String)sqle.getSQLState());
            }
            try {
                DataGenerator.insertIntoCompanies("s", "tse", (short)6, new byte[]{36, 121, 0, -67, -96, -103, 79, 104, -127, 101, 9, -103, -5, 8, -91, -105}, UUID.fromString("247900bd-a099-4f68-8165-0999fb08a597"), "MgOiL'<,?w_L6m2w)DZT?V9[ah)MOa|9SVeL97c*eGcc&HziIS1z1aIp o{&4-w'j\"8Y&i#awy79C\"A)cX", new SerialClob("f01aa5c3c3d944d158dcc7c8cad05b".toCharArray()), "981825e8ac81c7a98b945aa2c63c40a", new UDTPrice(new BigDecimal(36.06), new BigDecimal(46.06)), -9015588843748895269L, new byte[]{-64, -122, 60, 124, 53, -46, 111, 105, -47, 27, 46, 8, 113, -39, -89, 39, -1, 110, 57, 55, 30, -99, -76, -98, 30, -100, 83, 45, -10, -89, 1, -125, -47, -98, -70, -9, 100}, 16, psInsert4);
                OffHeapTest.fail("PK violation expected");
            }
            catch (SQLException sqle) {
                OffHeapTest.assertEquals((String)"23505", (String)sqle.getSQLState());
            }
            try {
                DataGenerator.insertIntoCompanies("s", "tse", (short)3, new byte[]{104, 38, -56, -11, 121, 58, 73, -63, -81, 54, 102, 46, -69, -15, 60, 31}, UUID.fromString("6826c8f5-793a-49c1-af36-662ebbf13c1f"), "z(#(Adud!mcy'H/CvaHUbg:ygU|", new SerialClob("2b168c8dc33a25cc22faa97f83d545".toCharArray()), "fd5b3e2731ffff2b3e442fb8d2844c", new UDTPrice(new BigDecimal(28.48), new BigDecimal(38.48)), -1353682257425529307L, new byte[]{-32, -23, -12, 116, -98, -106, -17, 51, -105, 124, 1, 56, -5, 77, -74, -10, 9, 45, -76, 80, -41, -40, 61, 65, -85, -114, -54, 37, 91, 121, -123, -1, -65, 112, -43, 35, 103, 126, -123, -109, 80, -45, 78}, 13, psInsert4);
                OffHeapTest.fail("PK violation expected");
            }
            catch (SQLException sqle) {
                OffHeapTest.assertEquals((String)"23505", (String)sqle.getSQLState());
            }
            try {
                DataGenerator.insertIntoCompanies("s", "tse", (short)2, new byte[]{96, 62, 12, -118, 103, 28, 64, -104, -78, 31, -73, -114, -66, -104, 53, 18}, UUID.fromString("603e0c8a-671c-4098-b21f-b78ebe983512"), "cW{h%>dG*fQ4Q$F<,LX-{0yx8%Q;ai3mRQi`Cr0gmfy4xEI%$uuJGPp `%B", null, "29f8a66124314958358ce1bddad5d6", new UDTPrice(new BigDecimal(25.75), new BigDecimal(35.75)), -5335896508433741988L, new byte[]{72, -2, 112, -52, -111, -29, 43, -97, 113, -107, 72, -91, -36, 42, 59, 63, -119, 71, -62, -1, -52, -119, -12, -119, 15, -103, 95, -100, 84, -99, 104, 124, -23, -88, 63, 71, 58, -116, -111, 81, 27, -76, 92, -84, -99, -100, 101, 26, 91, 23, -30, -62}, 53, psInsert4);
                OffHeapTest.fail("PK violation expected");
            }
            catch (SQLException sqle) {
                OffHeapTest.assertEquals((String)"23505", (String)sqle.getSQLState());
            }
            this.doOffHeapValidations();
            s.executeUpdate("delete from trade.companies");
            this.doOffHeapValidations();
            if (s != null) {
                s.execute("drop table if exists trade.comapnies");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testBug51451_clob() throws Exception {
        Connection cxn = TestUtil.getConnection();
        String createTable1 = "create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid) , clob_details clob , networth_clob clob , buyorder_clob clob )  replicate offheap";
        String createTable2 = "create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0) , clob_details clob ) offheap";
        cxn.createStatement().execute(createTable1);
        cxn.createStatement().execute(createTable2);
        cxn.setTransactionIsolation(2);
        cxn.setAutoCommit(false);
        PreparedStatement ps1 = cxn.prepareStatement("insert into trade.customers values (?, ?, ?, ?, ? , ?, ?, ?)");
        for (int i = 1; i <= 5; ++i) {
            ps1.setInt(1, i);
            ps1.setString(2, "name" + i);
            ps1.setDate(3, new Date(1980, 1, 1));
            ps1.setString(4, "address" + i);
            ps1.setInt(5, i);
            ps1.setObject(6, "{f" + i + ":" + i + "}");
            ps1.setObject(7, "{f" + i + ":" + i + "}");
            ps1.setObject(8, "{f" + i + ":" + i + "}");
            ps1.addBatch();
        }
        ps1.executeBatch();
        cxn.commit();
        PreparedStatement ps2 = cxn.prepareStatement("insert into trade.networth values (?, ?, ?, ?, ? , ?, ?)");
        for (int i = 1; i <= 5; ++i) {
            ps2.setInt(1, i);
            ps2.setInt(2, i);
            ps2.setInt(3, i);
            ps2.setInt(4, i * 2);
            ps2.setInt(5, i);
            ps2.setInt(6, i);
            ps2.setObject(7, "{f1 : " + i + "}");
            ps2.addBatch();
        }
        ps2.executeBatch();
        cxn.commit();
        String updateStatement = "update trade.networth set securities=? ,  clob_details = ? where tid  = ?";
        PreparedStatement ps3 = cxn.prepareStatement(updateStatement);
        ps3.setInt(1, 1000);
        ps3.setObject(2, "{f1 : 1000}");
        ps3.setInt(3, 1);
        ps3.execute();
        ps3.setInt(1, 2000);
        ps3.setObject(2, "{f1 : 2000}");
        ps3.setInt(3, 1);
        ps3.execute();
        cxn.commit();
        java.sql.ResultSet rs = cxn.createStatement().executeQuery("select * from trade.networth order by tid");
        int i = 1;
        while (rs.next()) {
            OffHeapTest.assertEquals((int)i, (int)rs.getInt(1));
            OffHeapTest.assertEquals((int)i, (int)rs.getInt(2));
            if (i == 1) {
                OffHeapTest.assertEquals((int)(i * 2000), (int)rs.getInt(3));
            } else {
                OffHeapTest.assertEquals((int)i, (int)rs.getInt(3));
            }
            OffHeapTest.assertEquals((int)(i * 2), (int)rs.getInt(4));
            OffHeapTest.assertEquals((int)i, (int)rs.getInt(5));
            OffHeapTest.assertEquals((int)i, (int)rs.getInt(6));
            rs.getString(7);
            ++i;
        }
    }

    public static class SecuritiesLoader
    implements RowLoader {
        private String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};

        public Object getRow(String schemaName, String tableName, Object[] primarykey) throws SQLException {
            Integer num = (Integer)primarykey[0];
            Object[] values = new Object[]{num, "symbol" + num * -1, new BigDecimal(1.7263548E7), this.exchange[-1 * num % 7], 2};
            return values;
        }

        public void init(String initStr) throws SQLException {
        }
    }

    public static class DataGenerator {
        protected static String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        private Random rand = new Random();

        void insertIntoSecurities(PreparedStatement ps, int sec_id) throws SQLException {
            block2: {
                ps.setInt(1, sec_id);
                ps.setString(2, this.getSymbol(1, 8));
                ps.setBigDecimal(3, this.getPrice());
                ps.setString(4, this.getExchange());
                ps.setInt(5, 50);
                try {
                    ps.executeUpdate();
                }
                catch (SQLException sqle) {
                    if (sqle.getSQLState().equals("23505")) break block2;
                    throw sqle;
                }
            }
        }

        public static void insertIntoCompanies(String symbol, String exchange, short companyType, byte[] uidBytes, UUID uuid, String companyName, Clob companyInfo, String note, UDTPrice udtPrice, long asset, byte[] logo, int tid, PreparedStatement ps) throws Exception {
            ps.setString(1, symbol);
            ps.setString(2, symbol);
            ps.setShort(3, companyType);
            ps.setBytes(4, uidBytes);
            ps.setObject(5, uuid);
            ps.setString(6, companyName);
            if (companyInfo == null) {
                ps.setNull(7, 2005);
            } else {
                ps.setClob(7, companyInfo);
            }
            ps.setString(8, note);
            ps.setObject(9, udtPrice);
            ps.setLong(10, asset);
            ps.setBytes(11, logo);
            ps.setInt(12, tid);
            ps.executeUpdate();
        }

        public void insertIntoCompanies(PreparedStatement ps, String symbol, String exchange, int extraLobColsCount) throws SQLException {
            UUID uid = UUID.fromString("3f90bd11-dfc3-4fd0-b758-08ed895b5c02");
            short companyType = 8;
            String companyName = "+=uqGd1w]bR6z[!j]|Chc>WTdf";
            Object companyInfo = null;
            String note = this.getString(31000, 32700);
            UDTPrice price = this.getRandomPrice();
            long asset = this.rand.nextLong();
            byte[] logo = this.getByteArray(100);
            ps.setString(1, symbol);
            ps.setString(2, exchange);
            ps.setShort(3, companyType);
            ps.setBytes(4, DataGenerator.getUidBytes(uid));
            ps.setObject(5, uid);
            ps.setString(6, companyName);
            if (companyInfo == null) {
                ps.setNull(7, 2005);
            } else {
                ps.setClob(7, (Clob)companyInfo[0]);
            }
            ps.setString(8, note);
            ps.setObject(9, price);
            ps.setLong(10, asset);
            ps.setBytes(11, logo);
            ps.setInt(12, 10);
            for (int i = 0; i < extraLobColsCount; ++i) {
                byte[] newBytes = new byte[90];
                ByteBuffer buff = ByteBuffer.wrap(newBytes);
                buff.putInt(i);
                ps.setBytes(12 + (i + 1), newBytes);
            }
            ps.executeUpdate();
        }

        protected BigDecimal getPrice() {
            return new BigDecimal(Double.toString((double)(this.rand.nextInt(10000) + 1) * 0.01));
        }

        protected String getExchange() {
            return exchanges[this.rand.nextInt(exchanges.length)];
        }

        public static byte[] getUidBytes(UUID uuid) {
            if (uuid == null) {
                return null;
            }
            long[] longArray = new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()};
            byte[] bytes = new byte[16];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.putLong(longArray[0]);
            bb.putLong(longArray[1]);
            return bytes;
        }

        protected byte[] getByteArray(int maxLength) {
            int arrayLength = this.rand.nextInt(maxLength) + 1;
            byte[] byteArray = new byte[arrayLength];
            for (int j = 0; j < arrayLength; ++j) {
                byteArray[j] = (byte)this.rand.nextInt(256);
            }
            return byteArray;
        }

        protected UDTPrice getRandomPrice() {
            BigDecimal low = new BigDecimal(Double.toString((double)(this.rand.nextInt(3000) + 1) * 0.01)).add(new BigDecimal("20"));
            BigDecimal high = new BigDecimal("10").add(low);
            return new UDTPrice(low, high);
        }

        protected String getString(int minLength, int maxLength) {
            int length = this.rand.nextInt(maxLength - minLength + 1) + minLength;
            return this.getRandPrintableVarChar(length);
        }

        protected String getSymbol(int minLength, int maxLength) {
            int aVal = 97;
            int symbolLength = this.rand.nextInt(maxLength - minLength + 1) + minLength;
            char[] charArray = new char[symbolLength];
            for (int j = 0; j < symbolLength; ++j) {
                charArray[j] = (char)(this.rand.nextInt(26) + aVal);
            }
            return new String(charArray);
        }

        public static String convertClobToString(Clob clob) throws IOException, SQLException {
            int ch;
            Reader reader = clob.getCharacterStream();
            StringBuilder sb = new StringBuilder();
            while ((ch = reader.read()) != -1) {
                sb.append((char)ch);
            }
            return sb.toString();
        }

        protected String getRandPrintableVarChar(int length) {
            if (length == 0) {
                return "";
            }
            int sp = 32;
            int tilde = 126;
            char[] charArray = new char[length];
            for (int j = 0; j < length; ++j) {
                charArray[j] = (char)(this.rand.nextInt(tilde - sp) + sp);
            }
            return new String(charArray);
        }

        protected char[] getCharArray(int length) {
            int arrayLength = this.rand.nextInt(length) + 1;
            char[] charArray = new char[arrayLength];
            for (int j = 0; j < arrayLength; ++j) {
                charArray[j] = this.getValidChar();
            }
            return charArray;
        }

        protected char getValidChar() {
            return (char)this.rand.nextInt(1319);
        }

        protected char[] getAsciiCharArray(int length) {
            int arrayLength = this.rand.nextInt(length) + 1;
            char[] charArray = new char[arrayLength];
            for (int j = 0; j < arrayLength; ++j) {
                charArray[j] = (char)this.rand.nextInt(128);
            }
            return charArray;
        }

        public Clob[] getClob(int size) {
            Clob[] profile = new Clob[size];
            int maxClobSize = 10000;
            try {
                for (int i = 0; i < size; ++i) {
                    char[] chars;
                    if (this.rand.nextBoolean()) {
                        chars = this.rand.nextInt(10) != 0 ? this.getAsciiCharArray(this.rand.nextInt(maxClobSize) + 1) : this.getCharArray(this.rand.nextInt(maxClobSize) + 1);
                        profile[i] = new SerialClob(chars);
                        continue;
                    }
                    chars = new char[500];
                    profile[i] = new SerialClob(chars);
                }
            }
            catch (SQLException se) {
                TestUtil.fail("unexpected SQLException " + se, se);
            }
            return profile;
        }
    }
}

